import { ActionResult } from '../../../Interface/Action';
import { Capability } from '../CapabilityProvider';
import { ResultForUsersInRoom, ResultForUsersInSet, RoomSetResult } from './RoomSetResult';
import { StringRoomID, StringUserID } from '@the-draupnir-project/matrix-basic-types';
import { MemberPolicyMatches } from '../../../MembershipPolicies/MembershipPolicyRevision';
export type TargetMember = MemberPolicyMatches | {
    userID: StringUserID;
    reason: string;
};
export declare function targetReason(member: TargetMember): string;
export interface UserConsequences extends Capability {
    consequenceForUserInRoom(roomID: StringRoomID, user: StringUserID, reason: string): Promise<ActionResult<void>>;
    consequenceForUsersInRoom(roomID: StringRoomID, users: TargetMember[]): Promise<ActionResult<ResultForUsersInRoom>>;
    consequenceForUsersInRoomSet(users: TargetMember[]): Promise<ActionResult<ResultForUsersInSet>>;
    unbanUserFromRoomSet(userID: StringUserID, reason: string): Promise<ActionResult<RoomSetResult>>;
}
export declare const UserConsequences: import("@sinclair/typebox").TIntersect<[import("@sinclair/typebox").TObject<{
    consequenceForUserInRoom: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
    consequenceForUsersInRoomSet: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
    consequenceForUsersInRoom: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
    unbanUserFromRoomSet: import("@sinclair/typebox").TFunction<[], import("@sinclair/typebox").TAny>;
}>, import("@sinclair/typebox").TObject<{
    requiredPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredEventPermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
    requiredStatePermissions: import("@sinclair/typebox").TArray<import("@sinclair/typebox").TString>;
}>]>;
//# sourceMappingURL=UserConsequences.d.ts.map