"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.HandleDataSourceType = void 0;
exports.describeHandle = describeHandle;
var HandleDataSourceType;
(function (HandleDataSourceType) {
    /**
     * These are handles that use a plugin to derive the source data stream for
     * the handle. The handle glue code is closely associated with the plugin.
     * For example, `handleProtectionIntent` is an example of a handle that
     * takes the protection's intent projection and uses to to derive a callback.
     */
    HandleDataSourceType["Plugin"] = "plugin";
    /**
     * These are handles that use the plugin context to derive the source data
     * stream for the handle.
     */
    HandleDataSourceType["Context"] = "context";
})(HandleDataSourceType || (exports.HandleDataSourceType = HandleDataSourceType = {}));
function describeHandle(description) {
    return description;
}
//# sourceMappingURL=HandleDescription.js.map