import { AnyHandleDescription } from './HandleDescription';
import { SemanticType } from '../../Interface/SemanticType';
import { Result } from '@gnuxie/typescript-result';
import { HandleRegistry } from './HandleRegistry';
import { OwnLifetime } from '../../Interface/Lifetime';
export interface HandleRegistryDescription<TPluginContext = Record<string, unknown>, THandles extends AnyHandleDescription = never> {
    /**
     * The set of handle descriptions that are available for a particular
     * registry context type.
     */
    readonly handleDescriptions: readonly THandles[];
    /**
     * Phantom property to capture the plugin context type parameter. This
     * is never read at runtime.
     */
    readonly _pluginContext?: TPluginContext;
    registerHandleDescription<THandleDescription extends AnyHandleDescription>(description: THandleDescription): HandleRegistryDescription<TPluginContext, THandles | THandleDescription>;
    registryForContext(lifetime: OwnLifetime<HandleRegistry<TPluginContext, THandles>>, context: TPluginContext): Result<HandleRegistry<TPluginContext, THandles>>;
}
export declare const HandleRegistryDescriptionSemantics: SemanticType<HandleRegistryDescription<Record<string, unknown>, never>>;
//# sourceMappingURL=HandleRegistryDescription.d.ts.map