"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardHandleRegistryDescription = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const StandardHandleRegistry_1 = require("./StandardHandleRegistry");
class StandardHandleRegistryDescription {
    constructor(handleDescriptions = []) {
        this.handleDescriptions = handleDescriptions;
    }
    registerHandleDescription(description) {
        return new StandardHandleRegistryDescription([...this.handleDescriptions, description]);
    }
    registryForContext(lifetime, context) {
        const registry = new StandardHandleRegistry_1.StandardHandleRegistry(context, lifetime);
        for (const handle of this.handleDescriptions) {
            const registerResult = registry.registerHandleDescription(handle);
            if ((0, typescript_result_1.isError)(registerResult)) {
                void lifetime[Symbol.asyncDispose]();
                return registerResult;
            }
        }
        return (0, typescript_result_1.Ok)(registry);
    }
}
exports.StandardHandleRegistryDescription = StandardHandleRegistryDescription;
//# sourceMappingURL=StandardHandleRegistryDescription.js.map