import { RoomEvent } from '../MatrixTypes/Events';
import { EventReport } from '../Reporting/EventReport';
import { SetRoomMembership } from '../Membership/SetRoomMembership';
import { SetRoomState } from '../StateTracking/SetRoomState';
import { ProtectionsManager } from './ProtectionsManager/ProtectionsManager';
import { Protection, ProtectionDescription } from './Protection';
import { MissingPermissionsChange } from '../Client/PowerLevelsMirror';
import { ProtectedRoomsManager } from './ProtectedRoomsManager/ProtectedRoomsManager';
import { MembershipEvent } from '../MatrixTypes/MembershipEvent';
import { StringUserID, MatrixRoomID, StringRoomID } from '@the-draupnir-project/matrix-basic-types';
import { SetMembershipRevisionIssuer } from '../Membership/SetMembershipRevisionIssuer';
import { SetMembershipPolicyRevisionIssuer } from '../MembershipPolicies/SetMembershipPolicyRevisionIssuer';
import { WatchedPolicyRooms } from './WatchedPolicyRooms/WatchedPolicyRooms';
import { MixinExtractor } from '../SafeMatrixEvents/EventMixinExtraction/EventMixinExtraction';
export interface ProtectedRoomsSet {
    readonly watchedPolicyRooms: WatchedPolicyRooms;
    readonly protectedRoomsManager: ProtectedRoomsManager;
    readonly protections: ProtectionsManager;
    readonly setRoomMembership: SetRoomMembership;
    readonly setMembership: SetMembershipRevisionIssuer;
    readonly setRoomState: SetRoomState;
    readonly setPoliciesMatchingMembership: SetMembershipPolicyRevisionIssuer;
    readonly userID: StringUserID;
    readonly allProtectedRooms: MatrixRoomID[];
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
    handleEventReport(report: EventReport): void;
    handleExternalMembership(roomID: StringRoomID, event: MembershipEvent): void;
    isProtectedRoom(roomID: StringRoomID): boolean;
    unregisterListeners(): void;
}
export type ProtectionPermissionsChange = {
    protection: Protection<ProtectionDescription>;
    permissionsChange: MissingPermissionsChange;
};
export type HandleMissingProtectionPermissions = (roomID: StringRoomID, protectionPermissions: ProtectionPermissionsChange[]) => void;
export declare class StandardProtectedRoomsSet implements ProtectedRoomsSet {
    readonly watchedPolicyRooms: WatchedPolicyRooms;
    readonly protectedRoomsManager: ProtectedRoomsManager;
    readonly protections: ProtectionsManager;
    readonly userID: StringUserID;
    readonly eventMixinExtractor: MixinExtractor;
    private readonly handleMissingProtectionPermissions?;
    private readonly membershipChangeListener;
    private readonly policyChangeListener;
    private readonly stateChangeListener;
    private readonly roomsChangeListener;
    private readonly setMembershiprevisionListener;
    private readonly setMembershipPolicyRevisionListener;
    readonly setPoliciesMatchingMembership: SetMembershipPolicyRevisionIssuer;
    constructor(watchedPolicyRooms: WatchedPolicyRooms, protectedRoomsManager: ProtectedRoomsManager, protections: ProtectionsManager, userID: StringUserID, eventMixinExtractor: MixinExtractor, handleMissingProtectionPermissions?: HandleMissingProtectionPermissions | undefined);
    get setRoomState(): SetRoomState;
    get setRoomMembership(): SetRoomMembership;
    get setMembership(): SetMembershipRevisionIssuer;
    get allProtectedRooms(): MatrixRoomID[];
    handleTimelineEvent(roomID: StringRoomID, event: RoomEvent): void;
    handleEventReport(report: EventReport): void;
    handleExternalMembership(roomID: StringRoomID, event: MembershipEvent): void;
    isProtectedRoom(roomID: StringRoomID): boolean;
    private setMembershipChangeListener;
    private policyRevisionChangeListener;
    /**
     * To be called only after power levels
     * have changed in a room. For some reason it's conflicted with
     * checking permissions within a room that has just been added.
     * Which is wrong.
     *
     * I really don't know how to fix this right now!!
     */
    private powerLevelsChangeFromContent;
    private powerLevelsChangeFromRevision;
    private stateRevisionChangeListener;
    private protectedRoomsChangeListener;
    private setMembershipRevision;
    private setMembershipPolicyRevision;
    unregisterListeners(): void;
}
//# sourceMappingURL=ProtectedRoomsSet.d.ts.map