"use strict";
// Copyright 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 2022 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.MjolnirProtectionSettingsEvent = exports.MjolnirProtectionSettingsEventContent = exports.MjolnirProtectionSettingsEventType = exports.MjolnirEnabledProtectionsEventType = exports.MjolnirEnabledProtectionsEvent = void 0;
const typebox_1 = require("@sinclair/typebox");
const Value_1 = require("../../Interface/Value");
const Events_1 = require("../../MatrixTypes/Events");
const SchemedMatrixData_1 = require("../../Interface/SchemedMatrixData");
exports.MjolnirEnabledProtectionsEvent = typebox_1.Type.Object({
    enabled: typebox_1.Type.Array(typebox_1.Type.String()),
    [SchemedMatrixData_1.DRAUPNIR_SCHEMA_VERSION_KEY]: typebox_1.Type.Optional(typebox_1.Type.Number()),
});
Value_1.Value.Compile(exports.MjolnirEnabledProtectionsEvent);
exports.MjolnirEnabledProtectionsEventType = 'org.matrix.mjolnir.enabled_protections';
exports.MjolnirProtectionSettingsEventType = 'org.matrix.mjolnir.setting';
exports.MjolnirProtectionSettingsEventContent = typebox_1.Type.Record(typebox_1.Type.String(), typebox_1.Type.Unknown());
exports.MjolnirProtectionSettingsEvent = typebox_1.Type.Intersect([
    typebox_1.Type.Omit((0, Events_1.StateEvent)(exports.MjolnirProtectionSettingsEventContent), ['type']),
    typebox_1.Type.Object({
        type: typebox_1.Type.Literal(exports.MjolnirProtectionSettingsEventType),
    }),
]);
//# sourceMappingURL=MjolnirEnabledProtectionsEvent.js.map