import { Result } from '@gnuxie/typescript-result';
import { CapabilityProviderSet } from '../Capability/CapabilitySet';
import { ProtectedRoomsSet } from '../ProtectedRoomsSet';
import { Protection, ProtectionDescription } from '../Protection';
import { ProtectionFailedToStartCB, ProtectionsManager } from './ProtectionsManager';
import { ProtectionSettingsConfig } from '../ProtectionsConfig/ProtectionSettingsConfig/ProtectionSettingsConfig';
import { ProtectionCapabilityProviderSetConfig } from '../ProtectionsConfig/ProtectionCapabilityProviderSetConfig/ProtectionCapabilityProviderSetConfig';
import { ProtectionsConfig } from '../ProtectionsConfig/ProtectionsConfig';
import { TObject } from '@sinclair/typebox';
import { EDStatic } from '../../Interface/Static';
import { UnknownConfig } from '../../Config/ConfigDescription';
import { CapabilityProviderDescription } from '../Capability/CapabilityProvider';
import { HandleRegistry } from '../HandleRegistry/HandleRegistry';
import { HandleRegistryDescription } from '../HandleRegistry/HandleRegistryDescription';
import { AnyHandleDescription } from '../HandleRegistry/HandleDescription';
export declare class StandardProtectionsManager<Context = unknown> implements ProtectionsManager<Context> {
    private readonly enabledProtectionsConfig;
    private readonly capabilityProviderSetConfig;
    private readonly settingsConfig;
    private readonly handleRegistryDescription;
    private readonly lifetime;
    private readonly enabledProtections;
    private handleRegistry;
    getHandleRegistry(context: Context): Result<HandleRegistry<Context>>;
    constructor(enabledProtectionsConfig: ProtectionsConfig, capabilityProviderSetConfig: ProtectionCapabilityProviderSetConfig, settingsConfig: ProtectionSettingsConfig, handleRegistryDescription: HandleRegistryDescription<Context, AnyHandleDescription>);
    get allProtections(): Protection<ProtectionDescription<unknown, TObject<{}>, import("../Capability/CapabilitySet").CapabilitySet>>[];
    private startProtection;
    addProtection(protectionDescription: ProtectionDescription, protectedRoomsSet: ProtectedRoomsSet, context: Context): Promise<Result<void>>;
    private removeProtectionWithoutStore;
    removeProtection(protection: ProtectionDescription): Promise<Result<void>>;
    loadProtections(protectedRoomsSet: ProtectedRoomsSet, context: Context, protectionFailedToStart: ProtectionFailedToStartCB): Promise<Result<void>>;
    changeProtectionSettings<TProtectionDescription extends ProtectionDescription = ProtectionDescription>(protectionDescription: TProtectionDescription, protectedRoomsSet: ProtectedRoomsSet, context: Context, settings: Record<string, unknown>): Promise<Result<Protection<TProtectionDescription>>>;
    changeCapabilityProvider(context: Context, protectedRoomsSet: ProtectedRoomsSet, protectionDescription: ProtectionDescription, capabilityKey: string, capabilityProvider: CapabilityProviderDescription): Promise<Result<void>>;
    changeCapabilityProviderSet(protectionDescription: ProtectionDescription, protectedRoomsSet: ProtectedRoomsSet, context: Context, capabilityProviderSet: CapabilityProviderSet): Promise<Result<void>>;
    getCapabilityProviderSet(protectionDescription: ProtectionDescription): Promise<Result<CapabilityProviderSet>>;
    getProtectionSettings<TConfigSchema extends TObject = UnknownConfig>(protectionDescription: ProtectionDescription): Promise<Result<EDStatic<TConfigSchema>>>;
    isEnabledProtection(protectionDescription: ProtectionDescription): boolean;
    findEnabledProtection<TProtectionDescription extends ProtectionDescription>(name: string): Protection<TProtectionDescription> | undefined;
    withEnabledProtection<TProtectionDescription extends ProtectionDescription>(name: string, cb: (protection: Protection<TProtectionDescription>) => void): void;
    unregisterListeners(): void;
}
//# sourceMappingURL=StandardProtectionsManager.d.ts.map