"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardMemberBanIntentProjection = void 0;
const ulidx_1 = require("ulidx");
const Projection_1 = require("../../../Projection/Projection");
const MemberBanIntentProjectionNode_1 = require("./MemberBanIntentProjectionNode");
class StandardMemberBanIntentProjection extends Projection_1.ProjectionOutputHelper {
    constructor(membershipPolicyRevisionIssuer) {
        const node = MemberBanIntentProjectionNode_1.StandardMemberBanIntentProjectionNode.create((0, ulidx_1.monotonicFactory)());
        const delta = node.reduceInitialInputs([
            membershipPolicyRevisionIssuer.currentRevision,
        ]);
        super(node.reduceDelta(delta));
        this.membershipPolicyRevisionIssuer = membershipPolicyRevisionIssuer;
        this.handleUpstreamRevision = ((_revision, delta) => {
            this.applyInput(delta);
        });
        this.membershipPolicyRevisionIssuer.on('revision', this.handleUpstreamRevision);
    }
    [Symbol.dispose]() {
        this.membershipPolicyRevisionIssuer.off('revision', this.handleUpstreamRevision);
        super[Symbol.dispose]();
    }
}
exports.StandardMemberBanIntentProjection = StandardMemberBanIntentProjection;
//# sourceMappingURL=MemberBanIntentProjection.js.map