import { StringRoomID, StringServerName } from '@the-draupnir-project/matrix-basic-types';
import { RoomStateEventSender } from '../../../Client/RoomStateEventSender';
import { ProtectedRoomsSet } from '../../ProtectedRoomsSet';
import './ServerBanSynchronisationCapability';
import { Result } from '@gnuxie/typescript-result';
import { ServerBanSynchronisationCapability } from './ServerBanSynchronisationCapability';
import { Capability } from '../../Capability/CapabilityProvider';
import { RoomSetResult } from '../../Capability/StandardCapability/RoomSetResult';
import { ServerBanIntentProjection } from './ServerBanIntentProjection';
import { ServerBanIntentProjectionNode } from './ServerBanIntentProjectionNode';
import { ServerACLBuilder } from '../../../MatrixTypes/ServerACLBuilder';
export declare function compileServerACL(ourServerName: StringServerName, projectionNode: ServerBanIntentProjectionNode): ServerACLBuilder;
export declare class ServerACLSynchronisationCapability implements ServerBanSynchronisationCapability, Capability {
    private readonly protectedRoomsSet;
    readonly requiredPermissions: never[];
    readonly requiredEventPermissions: never[];
    readonly requiredStatePermissions: string[];
    private readonly queue;
    constructor(stateEventSender: RoomStateEventSender, protectedRoomsSet: ProtectedRoomsSet);
    private applyIntentToSet;
    outcomeFromIntentInRoom(roomID: StringRoomID, projection: ServerBanIntentProjection): Promise<Result<boolean>>;
    outcomeFromIntentInRoomSet(projection: ServerBanIntentProjection): Promise<Result<RoomSetResult>>;
}
export type ServerACLSynchronisationCapabilityContext = {
    stateEventSender: RoomStateEventSender;
    protectedRoomsSet: ProtectedRoomsSet;
};
//# sourceMappingURL=ServerACLSynchronisationCapability.d.ts.map