import { StringServerName } from '@the-draupnir-project/matrix-basic-types';
import { ProjectionNode } from '../../../Projection/ProjectionNode';
import { PolicyListBridgeProjectionNode } from './PolicyListBridgeProjection';
import { PolicyRuleChange } from '../../../PolicyList/PolicyRuleChange';
import { ULID, ULIDFactory } from 'ulidx';
import { GlobPolicyRule, LiteralPolicyRule } from '../../../PolicyList/PolicyRule';
import { Map as PersistentMap, List } from 'immutable';
export type ServerBanIntentProjectionDelta = {
    deny: StringServerName[];
    recall: StringServerName[];
    add: (LiteralPolicyRule | GlobPolicyRule)[];
    remove: (LiteralPolicyRule | GlobPolicyRule)[];
};
export type ServerBanIntentProjectionNode = ProjectionNode<[
    PolicyListBridgeProjectionNode
], ServerBanIntentProjectionDelta, {
    deny: StringServerName[];
}>;
export declare const ServerBanIntentProjectionHelper: Readonly<{
    reducePolicyDelta(input: PolicyRuleChange[]): Pick<ServerBanIntentProjectionDelta, "add" | "remove">;
    reduceIntentDelta(input: Pick<ServerBanIntentProjectionDelta, "add" | "remove">, policies: PersistentMap<StringServerName, List<GlobPolicyRule | LiteralPolicyRule>>): ServerBanIntentProjectionDelta;
}>;
export declare class StandardServerBanIntentProjectionNode implements ServerBanIntentProjectionNode {
    private readonly ulidFactory;
    private readonly policies;
    readonly ulid: ULID;
    constructor(ulidFactory: ULIDFactory, policies: PersistentMap<StringServerName, List<LiteralPolicyRule | GlobPolicyRule>>);
    static create(ulidFactory: ULIDFactory): ServerBanIntentProjectionNode;
    reduceInput(input: PolicyRuleChange[]): ServerBanIntentProjectionDelta;
    reduceInitialInputs([policyListRevision]: [
        PolicyListBridgeProjectionNode
    ]): ServerBanIntentProjectionDelta;
    isEmpty(): boolean;
    reduceDelta(input: ServerBanIntentProjectionDelta): ServerBanIntentProjectionNode;
    get deny(): StringServerName[];
}
//# sourceMappingURL=ServerBanIntentProjectionNode.d.ts.map