import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { ActionResult } from '../../../Interface/Action';
import { RoomStateRevision, StateChange } from '../../../StateTracking/StateRevisionIssuer';
import { ProtectedRoomsSet } from '../../ProtectedRoomsSet';
import { AbstractProtection, Protection, ProtectionDescription } from '../../Protection';
import { UnknownConfig } from '../../../Config/ConfigDescription';
import './ServerBanSynchronisationCapability';
import './ServerACLSynchronisationCapability';
import { OwnLifetime } from '../../../Interface/Lifetime';
import { ServerBanIntentProjection } from './ServerBanIntentProjection';
import { ServerBanSynchronisationCapability } from './ServerBanSynchronisationCapability';
export declare class ServerBanSynchronisationProtection extends AbstractProtection<ProtectionDescription<unknown, UnknownConfig, Capabilities>> implements Protection<ProtectionDescription<unknown, UnknownConfig, Capabilities>, ServerBanIntentProjection> {
    readonly intentProjection: ServerBanIntentProjection;
    private readonly capability;
    constructor(description: ProtectionDescription<unknown, UnknownConfig, Capabilities>, lifetime: OwnLifetime<Protection<ProtectionDescription<unknown, UnknownConfig, Capabilities>>>, capabilities: Capabilities, protectedRoomsSet: ProtectedRoomsSet, intentProjection: ServerBanIntentProjection);
    handleStateChange(revision: RoomStateRevision, changes: StateChange[]): Promise<ActionResult<void>>;
    handleIntentProjectionNode(): void;
    handlePermissionRequirementsMet(room: MatrixRoomID): void;
}
type Capabilities = {
    serverConsequences: ServerBanSynchronisationCapability;
};
export {};
//# sourceMappingURL=ServerBanSynchronisation.d.ts.map