"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimulatedServerBanSynchronisationCapability = void 0;
const typescript_result_1 = require("@gnuxie/typescript-result");
const EventGeneration_1 = require("../../../TestUtilities/EventGeneration");
const CapabilityProvider_1 = require("../../Capability/CapabilityProvider");
const ServerACLSynchronisationCapability_1 = require("./ServerACLSynchronisationCapability");
const FakeStateSender = Object.freeze({
    sendStateEvent(_room, _stateType, _stateKey, _content) {
        return Promise.resolve((0, typescript_result_1.Ok)((0, EventGeneration_1.randomEventID)()));
    },
});
class SimulatedServerBanSynchronisationCapability {
    constructor(protectedRoomsSet) {
        this.protectedRoomsSet = protectedRoomsSet;
        this.requiredPermissions = [];
        this.requiredEventPermissions = [];
        this.requiredStatePermissions = [];
        this.isSimulated = true;
        this.simulatedCapability = new ServerACLSynchronisationCapability_1.ServerACLSynchronisationCapability(FakeStateSender, this.protectedRoomsSet);
        this.outcomeFromIntentInRoom = this.simulatedCapability.outcomeFromIntentInRoom.bind(this.simulatedCapability);
        this.outcomeFromIntentInRoomSet = this.simulatedCapability.outcomeFromIntentInRoomSet.bind(this.simulatedCapability);
        // nothing to do.
    }
}
exports.SimulatedServerBanSynchronisationCapability = SimulatedServerBanSynchronisationCapability;
(0, CapabilityProvider_1.describeCapabilityProvider)({
    name: 'SimulatedServerBanSynchronisationCapability',
    description: 'Simulates banning servers in protected rooms, but has no real effects',
    interface: 'ServerBanSynchronisationCapability',
    isSimulated: true,
    factory(_description, context) {
        return new SimulatedServerBanSynchronisationCapability(context.protectedRoomsSet);
    },
});
//# sourceMappingURL=SimulatedServerBanSynchronisationCapability.js.map