"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.reversePoliciesOfType = reversePoliciesOfType;
const PolicyRule_1 = require("../../../PolicyList/PolicyRule");
function reversePoliciesOfType(hashRecords, entityExtractor, type, sourceRevision) {
    const reversedPolicies = [];
    for (const record of hashRecords) {
        const matchingPolicies = sourceRevision.findRulesMatchingHash(record.sha256, 'sha256', {
            type,
        });
        reversedPolicies.push(...matchingPolicies.map((policy) => (0, PolicyRule_1.makeReversedHashedPolicy)(entityExtractor(record), policy)));
    }
    return reversedPolicies;
}
//# sourceMappingURL=Reversal.js.map