import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { PolicyListRevision } from '../../PolicyList/PolicyListRevision';
import { WatchedPolicyRoom, WatchedPolicyRooms } from './WatchedPolicyRooms';
import { Result } from '@gnuxie/typescript-result';
import { PolicyListConfig } from '../PolicyListConfig/PolicyListConfig';
import { DirectPropagationPolicyListRevisionIssuer } from '../DirectPropagationPolicyListRevisionIssuer';
import { PolicyRoomManager } from '../../PolicyList/PolicyRoomManger';
import { RoomJoiner } from '../../Client/RoomJoiner';
export declare class StandardWatchedPolicyRooms implements WatchedPolicyRooms {
    private readonly policyListConfig;
    private readonly policyRoomRevisionIssuers;
    readonly revisionIssuer: DirectPropagationPolicyListRevisionIssuer;
    private readonly policyRoomManager;
    private readonly roomJoiner;
    private constructor();
    static create(policyListConfig: PolicyListConfig, policyRoomManager: PolicyRoomManager, roomJoiner: RoomJoiner): Promise<Result<StandardWatchedPolicyRooms>>;
    watchPolicyRoomDirectly(room: MatrixRoomID): Promise<Result<void>>;
    unwatchPolicyRoom(room: MatrixRoomID): Promise<Result<void>>;
    get allRooms(): WatchedPolicyRoom[];
    get currentRevision(): PolicyListRevision;
    unregisterListeners(): void;
    findPolicyRoomFromShortcode(shortcode: string): WatchedPolicyRoom | undefined;
}
//# sourceMappingURL=StandardWatchedPolicyRooms.d.ts.map