"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardMixinExtractor = void 0;
exports.extractPrimaryContent = extractPrimaryContent;
exports.extractEventType = extractEventType;
exports.ErroneousMixin = ErroneousMixin;
const SafeMembershipEvent_1 = require("../SafeMembershipEvent");
const UndecodableEventContent_1 = require("../UndecodableEventContent");
function extractPrimaryContent(event) {
    return (0, UndecodableEventContent_1.isUndecodableEvent)(event)
        ? event[SafeMembershipEvent_1.UnsafeContentKey]
        : event.content;
}
function extractEventType(event) {
    if ((0, UndecodableEventContent_1.isUndecodableEvent)(event)) {
        return event.originalType;
    }
    return event.type;
}
function ErroneousMixin(description, message) {
    return {
        description,
        isErroneous: true,
        message,
    };
}
class StandardMixinExtractor {
    constructor(mixinDescriptions) {
        this.mixinDescriptions = new Set(mixinDescriptions);
    }
    parseContent(content) {
        const usedPropeties = [];
        const mixins = [];
        for (const description of this.mixinDescriptions) {
            const mixin = description.parser(content, this);
            if (mixin === undefined) {
                continue;
            }
            mixins.push(mixin);
            for (const property of description.properties) {
                usedPropeties.push(property);
            }
        }
        return {
            mixins,
            additionalProperties: Object.fromEntries(Object.entries(content).filter(([key]) => !usedPropeties.includes(key))),
            findMixin(description) {
                return this.mixins.find((mixin) => mixin.description === description);
            },
        };
    }
    parseEvent(event) {
        const primaryContent = extractPrimaryContent(event);
        const eventType = extractEventType(event);
        const contentMixins = this.parseContent(primaryContent);
        return {
            ...contentMixins,
            sourceEvent: event,
            eventType,
        };
    }
}
exports.StandardMixinExtractor = StandardMixinExtractor;
//# sourceMappingURL=StandardMixinExtractor.js.map