"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultMixinExtractor = void 0;
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const ExtensibleTextMixin_1 = require("./ExtensibleTextMixin");
const MentionsMixin_1 = require("./MentionsMixin");
const NewContentMixin_1 = require("./NewContentMixin");
const RoomMessageBodyMixin_1 = require("./RoomMessageBodyMixin");
const RoomMessageFileMixin_1 = require("./RoomMessageFileMixin");
const RoomMessageFormatedBodyMixin_1 = require("./RoomMessageFormatedBodyMixin");
const RoomMessageMediaURLMixin_1 = require("./RoomMessageMediaURLMixin");
const RoomMessageThumbnailURLMixin_1 = require("./RoomMessageThumbnailURLMixin");
exports.DefaultMixinExtractor = new StandardMixinExtractor_1.StandardMixinExtractor([
    ExtensibleTextMixin_1.ExtensibleTextMixinDescription,
    MentionsMixin_1.MentionsMixinDescription,
    NewContentMixin_1.NewContentMixinDescription,
    RoomMessageBodyMixin_1.RoomMessageBodyMixinDescription,
    RoomMessageFileMixin_1.RoomMessageFileMixinDescription,
    RoomMessageFormatedBodyMixin_1.RoomMessageFormattedBodyMixinDescription,
    RoomMessageMediaURLMixin_1.RoomMessageMediaURLMixinDescription,
    RoomMessageThumbnailURLMixin_1.RoomMessageThumbnailURLMixinDescription,
]);
//# sourceMappingURL=DefaultMixinExtractor.js.map