"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.MentionsMixinDescription = void 0;
const typebox_1 = require("@sinclair/typebox");
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
const Value_1 = require("../../Interface/Value");
const StringlyTypedMatrix_1 = require("../../MatrixTypes/StringlyTypedMatrix");
const MentionsContentSchema = typebox_1.Type.Object({
    'm.mentions': typebox_1.Type.Object({
        user_ids: typebox_1.Type.Optional(typebox_1.Type.Array(StringlyTypedMatrix_1.StringUserIDSchema)),
    }),
});
exports.MentionsMixinDescription = Object.freeze({
    name: 'm.mentions',
    description: 'Extracts the m.mentions mixin from any event',
    properties: ['m.mentions'],
    parser(content) {
        if (!(0, hasOwn_1.hasOwn)(content, 'm.mentions')) {
            return undefined;
        }
        if (!Value_1.Value.Check(MentionsContentSchema, content)) {
            return (0, StandardMixinExtractor_1.ErroneousMixin)(this, "The m.mentions mixin doesn't match the schema");
        }
        const userIDs = content['m.mentions']['user_ids'];
        if (userIDs === undefined || userIDs.length === 0) {
            // We don't want to create this mixin when there are no mentions
            // and the client is just emitting garbage.
            return undefined;
        }
        return {
            description: this,
            isErroneous: false,
            user_ids: userIDs,
        };
    },
});
//# sourceMappingURL=MentionsMixin.js.map