"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from matrix-protection-suite
// https://github.com/Gnuxie/matrix-protection-suite
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomMessageThumbnailURLMixinDescription = void 0;
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
exports.RoomMessageThumbnailURLMixinDescription = Object.freeze({
    name: 'm.room.message thumbnail URL mixin',
    description: 'Extracts the thumbnail URL mixin from content that looks like m.room.message',
    properties: ['thumbnail_url'],
    parser(content) {
        if (!(0, hasOwn_1.hasOwn)(content, 'thumbnail_url')) {
            return undefined;
        }
        if (typeof content.thumbnail_url !== 'string') {
            return (0, StandardMixinExtractor_1.ErroneousMixin)(this, "The thumbnail URL mixin doesn't match the schema");
        }
        return {
            description: this,
            isErroneous: false,
            thumbnail_url: content.thumbnail_url,
        };
    },
});
//# sourceMappingURL=RoomMessageThumbnailURLMixin.js.map