import { ActionResult } from '../Interface/Action';
import { DecodeException } from '../Interface/Value';
import { BaseMembershipEvent, MembershipEventContent } from '../MatrixTypes/MembershipEvent';
/**
 * Used by the `SafeMembershipEventMirror` to extract unsafe content from an event.
 */
export declare const UnsafeContentKey: unique symbol;
/**
 * Used by the `SafeMembershipEventMirror` to determine if an object is `SafeMembershipEventContent`.
 */
declare const SafeMembershipEventContentKey: unique symbol;
export interface SafeMembershipEventContent extends MembershipEventContent {
    [UnsafeContentKey]?: Record<string, unknown>;
    [SafeMembershipEventContentKey]: true;
}
export type SafeMembershipEvent = Omit<BaseMembershipEvent, 'content'> & {
    content: SafeMembershipEventContent;
};
export declare const SafeMembershipEventMirror: Readonly<{
    getUnsafeContent(content: SafeMembershipEventContent): Record<string, unknown> | undefined;
    isSafeContent(content: unknown): content is SafeMembershipEventContent;
    /**
     * Create `SafeMembershipEventContent` from valid content and unsafe content.
     */
    create(content: MembershipEventContent, { unsafeContent, }?: {
        unsafeContent?: SafeMembershipEventContent[typeof UnsafeContentKey];
    }): SafeMembershipEventContent;
    /**
     * Parse unknown membership content into safe membership content, if possible.
     * @param unknownContent unknown content.
     * @returns An ActionResult with the safe content, or a reason why safe content cannot be created.
     */
    parse(unknownContent: Record<string, unknown>): ActionResult<SafeMembershipEventContent, DecodeException>;
    parseEvent(event: unknown): ActionResult<SafeMembershipEvent, DecodeException>;
}>;
export type SafeMembershipEventMirror = typeof SafeMembershipEventMirror;
export {};
//# sourceMappingURL=SafeMembershipEvent.d.ts.map