"use strict";
// Copyright (C) 2023 - 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FakeRoomStateRevisionIssuer = void 0;
const events_1 = __importDefault(require("events"));
class FakeRoomStateRevisionIssuer extends events_1.default {
    constructor(currentRevision, room) {
        super();
        this.currentRevision = currentRevision;
        this.room = room;
    }
    updateForEvent(event) {
        const state = this.currentRevision.allState.filter((existingEvent) => existingEvent.state_key !== event.state_key &&
            event.type !== existingEvent.type);
        this.reviseFromState([...state, event]);
    }
    updateForRedaction() {
        // nothing to do.
    }
    unregisterListeners() {
        // nothing to unregister
    }
    // this is a method specifically for the fake side of the implementation.
    // ideally, we'd have some way to define the different side as a mixin.
    // and then only allow access to that side through a mirror for that side.
    reviseRevision(changes) {
        const previousRevision = this.currentRevision;
        this.currentRevision = this.currentRevision.reviseFromChanges(changes);
        this.emit('revision', this.currentRevision, changes, previousRevision);
    }
    // this method is also on the Fake side.
    reviseFromState(state) {
        const changes = this.currentRevision.changesFromState(state);
        this.reviseRevision(changes);
    }
    // also on the Fake side.
    appendState(state) {
        this.reviseFromState([...this.currentRevision.allState, ...state]);
    }
}
exports.FakeRoomStateRevisionIssuer = FakeRoomStateRevisionIssuer;
//# sourceMappingURL=FakeRoomStateRevisionIssuer.js.map