"use strict";
// Copyright (C) 2023 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.randomRawEvent = randomRawEvent;
exports.makePolicyRuleUserEvent = makePolicyRuleUserEvent;
exports.randomPolicyRuleEvent = randomPolicyRuleEvent;
exports.randomRoomID = randomRoomID;
exports.randomUserID = randomUserID;
exports.randomEventID = randomEventID;
const crypto_1 = require("crypto");
const PolicyEvents_1 = require("../MatrixTypes/PolicyEvents");
const PolicyRule_1 = require("../PolicyList/PolicyRule");
const Value_1 = require("../Interface/Value");
const Action_1 = require("../Interface/Action");
const PolicyRuleEventBuilder_1 = require("../PolicyList/PolicyRuleEventBuilder");
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
function randomRawEvent(sender, room_id) {
    const rawEventJSON = {
        room_id,
        sender,
        event_id: `$${(0, crypto_1.randomUUID)()}:example.com`,
        origin_server_ts: Date.now(),
        type: 'm.room.message',
        content: {
            body: (0, crypto_1.randomUUID)(),
            msgtype: 'm.text',
        },
    };
    return rawEventJSON;
}
function makePolicyRuleUserEvent({ sender = randomUserID(), room_id = `!${(0, crypto_1.randomUUID)()}:example.com`, reason = '<no reason supplied>', entity = randomUserID(), recommendation = PolicyRule_1.Recommendation.Ban, state_key, copyFrom, remove, }) {
    const description = (0, PolicyRuleEventBuilder_1.buildPolicyEvent)({
        state_key,
        type: PolicyEvents_1.PolicyRuleType.User,
        content: {
            entity,
            recommendation,
            reason,
        },
        copyFrom,
        remove,
    });
    const rawEventJSON = {
        room_id,
        event_id: randomEventID(),
        origin_server_ts: Date.now(),
        state_key: description.state_key,
        type: description.type,
        sender,
        content: description.content,
    };
    const decodeResult = Value_1.Value.Decode(PolicyEvents_1.PolicyRuleEvent, rawEventJSON);
    if ((0, Action_1.isError)(decodeResult)) {
        const errors = [...Value_1.Value.Errors(PolicyEvents_1.PolicyRuleEvent, rawEventJSON)];
        throw new TypeError(`Something is wrong with the event generator [${errors.toString()}]`);
    }
    else {
        return decodeResult.ok;
    }
}
function randomPolicyRuleEvent(sender, room_id) {
    return makePolicyRuleUserEvent({
        sender,
        room_id,
    });
}
function randomRoomID(viaServers) {
    const roomID = `!${(0, crypto_1.randomUUID)()}:example.com`;
    if (!(0, matrix_basic_types_1.isStringRoomID)(roomID)) {
        throw new TypeError(`RoomID generator is wrong`);
    }
    return matrix_basic_types_1.MatrixRoomReference.fromRoomID(roomID, viaServers);
}
function randomUserID() {
    const userID = `@${(0, crypto_1.randomUUID)()}:example.com`;
    if (!(0, matrix_basic_types_1.isStringUserID)(userID)) {
        throw new TypeError(`UserID generator is wrong`);
    }
    return userID;
}
function randomEventID() {
    const eventID = `$${(0, crypto_1.randomUUID)()}:example.com`;
    if (!(0, matrix_basic_types_1.isStringEventID)(eventID)) {
        throw new TypeError(`EventID generator is wrong`);
    }
    return eventID;
}
//# sourceMappingURL=EventGeneration.js.map