"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.CapabilitySetProviderMigration = void 0;
exports.serverBanSynchronisationCapabilityRename = serverBanSynchronisationCapabilityRename;
const typescript_result_1 = require("@gnuxie/typescript-result");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const log = new matrix_protection_suite_1.Logger("CapabilitySetProviderMigration");
async function serverBanSynchronisationCapabilityRename(input, toVersion) {
    // Annoyingly, having a record type on the top level mixed with known
    // properties is really terrible for typescript to deal with.
    if (!matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.CapabilityProviderConfig, input)) {
        return typescript_result_1.ResultError.Result(`The data for the capability provider config is corrupted.`);
    }
    const protectionCapabilityName = "serverConsequences";
    const oldSimulatedServerConsequencesName = "SimulatedServerConsequences";
    const oldServerACLConsequencesName = "ServerACLConsequences";
    const oldServerConsequencesSet = input[protectionCapabilityName];
    if (oldServerConsequencesSet === undefined) {
        return (0, typescript_result_1.Ok)({
            ...input,
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: toVersion,
        });
    }
    log.debug(`Migrating capability provider from ${protectionCapabilityName} to ServerBanSynchronisationCapability`);
    const makeProviderSet = (capabilityName) => {
        return {
            [protectionCapabilityName]: {
                capability_provider_name: capabilityName,
            },
            [matrix_protection_suite_1.DRAUPNIR_SCHEMA_VERSION_KEY]: toVersion,
        };
    };
    switch (oldServerConsequencesSet.capability_provider_name) {
        case oldSimulatedServerConsequencesName:
            return (0, typescript_result_1.Ok)(makeProviderSet(matrix_protection_suite_1.SimulatedServerBanSynchronisationCapability.name));
        case oldServerACLConsequencesName:
            return (0, typescript_result_1.Ok)(makeProviderSet(matrix_protection_suite_1.ServerACLSynchronisationCapability.name));
        default:
            // if someone has written their own custom thing, they probably need to know that we've
            // change the interface name.
            throw new TypeError(`Unknown capability provider name: ${oldServerConsequencesSet.capability_provider_name}`);
    }
}
exports.CapabilitySetProviderMigration = new matrix_protection_suite_1.SchemedDataManager([
    serverBanSynchronisationCapabilityRename,
]);
//# sourceMappingURL=CapabilitySetProviderMigration.js.map