"use strict";
// SPDX-FileCopyrightText: 2025 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtectedJoinedRooms = void 0;
const matrix_basic_types_1 = require("@the-draupnir-project/matrix-basic-types");
const matrix_protection_suite_1 = require("matrix-protection-suite");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const log = new matrix_protection_suite_1.Logger("ProtectAllJoinedRooms");
class ProtectedJoinedRooms {
    constructor(clientUserID, managementRoomID, protectedRoomsSet, clientRooms, roomMessageSender) {
        this.clientUserID = clientUserID;
        this.managementRoomID = managementRoomID;
        this.protectedRoomsSet = protectedRoomsSet;
        this.clientRooms = clientRooms;
        this.roomMessageSender = roomMessageSender;
        this.batcher = new matrix_protection_suite_1.StandardBatcher(() => new matrix_protection_suite_1.ConstantPeriodItemBatch(this.syncProtectedRooms.bind(this), { waitPeriodMS: 1000 }));
        // nothing to do.
    }
    handleMembershipChange(changes) {
        for (const change of changes) {
            if (change.userID === this.clientUserID) {
                switch (change.membershipChangeType) {
                    case matrix_protection_suite_1.MembershipChangeType.NoChange: {
                        continue;
                    }
                    default: {
                        this.batcher.add(change.roomID);
                        return;
                    }
                }
            }
        }
    }
    handleExternalMembership(roomID, _event) {
        this.batcher.add(roomID);
    }
    async syncProtectedRooms() {
        const policyRooms = this.protectedRoomsSet.watchedPolicyRooms.allRooms.map((profile) => profile.room.toRoomIDOrAlias());
        const roomsToProtect = this.clientRooms.currentRevision.allJoinedRooms.filter((roomID) => {
            return (!policyRooms.includes(roomID) &&
                !this.protectedRoomsSet.isProtectedRoom(roomID));
        });
        const setResult = new matrix_protection_suite_1.RoomSetResultBuilder();
        for (const roomID of roomsToProtect) {
            const protectResult = await this.protectedRoomsSet.protectedRoomsManager.addRoom(matrix_basic_types_1.MatrixRoomReference.fromRoomID(roomID));
            if ((0, matrix_protection_suite_1.isError)(protectResult)) {
                log.error("Unable to protect the room", roomID, protectResult.error);
            }
            setResult.addResult(roomID, protectResult);
        }
        if (setResult.getResult().map.size === 0) {
            return;
        }
        else {
            void (0, matrix_protection_suite_1.Task)((0, mps_interface_adaptor_1.sendMatrixEventsFromDeadDocument)(this.roomMessageSender, this.managementRoomID, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null, (0, mps_interface_adaptor_1.renderRoomSetResult)(setResult.getResult(), {
                summary: interface_manager_1.DeadDocumentJSX.JSXFactory("p", null, "Protecting new rooms."),
            })), {}), {
                description: "Report newly protected rooms to the managmeent room.",
            });
        }
    }
}
exports.ProtectedJoinedRooms = ProtectedJoinedRooms;
//# sourceMappingURL=ProtectJoinedRooms.js.map