"use strict";
// Copyright 2022 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderProtectionFailedToStart = renderProtectionFailedToStart;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const mps_interface_adaptor_1 = require("@the-draupnir-project/mps-interface-adaptor");
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
// The callback that this is required for in MPS, is kinda silly and should
// really be `void` and not `Promise<void>`. If it wanted to be `Promise<void>`,
// then it should really be `Promise<Result<void>>`.
async function renderProtectionFailedToStart(roomMessageSender, managementRoomID, error, protectionName, _protectionDescription) {
    void (0, matrix_protection_suite_1.Task)((0, mps_interface_adaptor_1.sendMatrixEventsFromDeadDocument)(roomMessageSender, managementRoomID, interface_manager_1.DeadDocumentJSX.JSXFactory("root", null,
        interface_manager_1.DeadDocumentJSX.JSXFactory("span", null,
            "A protection ",
            protectionName,
            " failed to start for the following reason:"),
        interface_manager_1.DeadDocumentJSX.JSXFactory("span", null, error.message)), {}));
}
//# sourceMappingURL=ProtectedRoomsSetRenderers.js.map