/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.SuccesorTaskFinder;
import org.eclipse.ui.internal.cheatsheets.composite.model.TaskStateUtilities;
import org.eclipse.ui.internal.cheatsheets.composite.parser.MarkupParser;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.provisional.cheatsheets.IEditableTask;
import org.eclipse.ui.internal.provisional.cheatsheets.ITaskGroup;

public class DescriptionPanel {
    public static final String REVIEW_IMAGE = "review";
    private static final String GOTO_IMAGE = "goto";
    private static final String SKIP_IMAGE = "skip";
    private static final String START_IMAGE = "start";
    private static final String WARNING_IMAGE = "warning";
    private static final String INFORMATION_IMAGE = "info";
    private Composite panel;
    private Composite control;
    private FormText upperText;
    private FormText lowerText;
    private ScrolledForm form;

    protected DescriptionPanel() {
    }

    public DescriptionPanel(ManagedForm mform, Composite parent) {
        FormToolkit toolkit = mform.getToolkit();
        this.control = new Composite(parent, 0);
        GridLayout controlLayout = new GridLayout();
        controlLayout.marginHeight = 0;
        controlLayout.marginWidth = 0;
        this.control.setLayout((Layout)controlLayout);
        this.form = toolkit.createScrolledForm(this.control);
        this.panel = this.form.getBody();
        this.form.setLayoutData((Object)new GridData(1808));
        toolkit.adapt(this.panel);
        TableWrapLayout layout = new TableWrapLayout();
        this.panel.setLayout((Layout)layout);
        this.upperText = mform.getToolkit().createFormText(this.panel, false);
        mform.getToolkit().adapt((Control)this.upperText, false, false);
        Composite separator = toolkit.createCompositeSeparator(this.panel);
        TableWrapData data = new TableWrapData();
        data.align = 128;
        data.grabHorizontal = true;
        data.maxHeight = 1;
        separator.setLayoutData((Object)data);
        this.lowerText = mform.getToolkit().createFormText(this.panel, false);
        mform.getToolkit().adapt((Control)this.lowerText, false, false);
        this.upperText.marginWidth = 5;
        this.upperText.marginHeight = 5;
        this.upperText.setFont("header", JFaceResources.getHeaderFont());
        this.upperText.setColor("title", toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.lowerText.marginWidth = 5;
        this.lowerText.marginHeight = 5;
        this.lowerText.setImage(START_IMAGE, CheatSheetPlugin.getPlugin().getImage("COMPOSITE_TASK_START"));
        this.lowerText.setImage(SKIP_IMAGE, CheatSheetPlugin.getPlugin().getImage("COMPOSITE_TASK_SKIP"));
        this.lowerText.setImage(GOTO_IMAGE, CheatSheetPlugin.getPlugin().getImage("COMPOSITE_GOTO_TASK"));
        this.lowerText.setImage(REVIEW_IMAGE, CheatSheetPlugin.getPlugin().getImage("COMPOSITE_TASK_REVIEW"));
        this.lowerText.setImage(WARNING_IMAGE, CheatSheetPlugin.getPlugin().getImage("WARNING"));
        this.lowerText.setImage(INFORMATION_IMAGE, CheatSheetPlugin.getPlugin().getImage("INFORMATION"));
    }

    public Control getControl() {
        return this.control;
    }

    public void addHyperlinkListener(IHyperlinkListener listener) {
        this.lowerText.addHyperlinkListener(listener);
    }

    public void showDescription(ICompositeCheatSheetTask task) {
        StringBuilder upperMessage = new StringBuilder();
        upperMessage.append("<form>");
        upperMessage.append("<p><span color=\"title\" font=\"header\">");
        upperMessage.append(MarkupParser.escapeText(task.getName()));
        upperMessage.append("</span></p>");
        upperMessage.append(MarkupParser.createParagraph(task.getDescription(), null));
        upperMessage.append("</form>");
        this.upperText.setText(upperMessage.toString(), true, false);
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        boolean startable = false;
        boolean isBlocked = false;
        boolean isSkippable = ((AbstractTask)task).isSkippable();
        if (task.getState() == 3) {
            buf.append(MarkupParser.createParagraph(task.getCompletionMessage(), null));
            isSkippable = false;
        } else if (task.getState() == 2) {
            buf.append(MarkupParser.createParagraph(Messages.THIS_TASK_SKIPPED, INFORMATION_IMAGE));
            isSkippable = false;
        } else if (TaskStateUtilities.findSkippedAncestor(task) != null) {
            ICompositeCheatSheetTask skipped = TaskStateUtilities.findSkippedAncestor(task);
            String skipParentMsg = NLS.bind((String)Messages.PARENT_SKIPPED, (Object[])new Object[]{MarkupParser.escapeText(skipped.getName())});
            buf.append(MarkupParser.createParagraph(skipParentMsg, WARNING_IMAGE));
            isSkippable = false;
        } else if (TaskStateUtilities.findCompletedAncestor(task) != null) {
            ICompositeCheatSheetTask completed = TaskStateUtilities.findCompletedAncestor(task);
            String completedParentMsg = NLS.bind((String)Messages.PARENT_COMPLETED, (Object[])new Object[]{MarkupParser.escapeText(completed.getName())});
            buf.append(MarkupParser.createParagraph(completedParentMsg, WARNING_IMAGE));
            isSkippable = false;
        } else if (!task.requiredTasksCompleted()) {
            isBlocked = true;
            this.showBlockingTasks(Messages.COMPOSITE_PAGE_BLOCKED, task, buf);
        } else if (TaskStateUtilities.findBlockedAncestor(task) != null) {
            isBlocked = true;
            ICompositeCheatSheetTask blockedAncestor = TaskStateUtilities.findBlockedAncestor(task);
            String blockingAncestorMsg = NLS.bind((String)Messages.PARENT_BLOCKED, (Object[])new Object[]{MarkupParser.escapeText(blockedAncestor.getName())});
            this.showBlockingTasks(blockingAncestorMsg, blockedAncestor, buf);
        } else {
            boolean bl = startable = task instanceof IEditableTask && task.getState() == 0;
        }
        if (startable) {
            this.addHyperlink(buf, "__start__", START_IMAGE, Messages.COMPOSITE_PAGE_START_TASK);
        }
        if (task instanceof IEditableTask && task.getState() == 3) {
            this.addHyperlink(buf, "__review__", REVIEW_IMAGE, Messages.COMPOSITE_PAGE_REVIEW_TASK);
        }
        if (isSkippable) {
            String skipMessage = task instanceof ITaskGroup ? Messages.COMPOSITE_PAGE_SKIP_TASK_GROUP : Messages.COMPOSITE_PAGE_SKIP_TASK;
            this.addHyperlink(buf, "__skip__", SKIP_IMAGE, skipMessage);
        }
        if (!startable && !isBlocked) {
            this.showSuccesorTaskLinks(task, buf);
        }
        buf.append("</form>");
        this.lowerText.setText(buf.toString(), true, false);
        this.getControl().setData("task", (Object)task);
        this.form.reflow(true);
    }

    private void showBlockingTasks(String message, ICompositeCheatSheetTask task, StringBuilder buf) {
        ICompositeCheatSheetTask[] requiredTasks;
        buf.append("<p/>");
        buf.append("<p>");
        buf.append("<img href=\"");
        buf.append(WARNING_IMAGE);
        buf.append("\"/> ");
        buf.append(message);
        buf.append("</p>");
        ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = requiredTasks = task.getRequiredTasks();
        int n = requiredTasks.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeCheatSheetTask requiredTask = iCompositeCheatSheetTaskArray[n2];
            this.warnOfIncompleteTask(buf, requiredTask);
            ++n2;
        }
        buf.append("<p>");
        buf.append("</p>");
    }

    private void addHyperlink(StringBuilder buf, String href, String imageRef, String message) {
        buf.append("<p><a href=\"");
        buf.append(href);
        buf.append("\">");
        buf.append("<img href=\"");
        buf.append(imageRef);
        buf.append("\"/> ");
        buf.append(message);
        buf.append("</a></p>");
    }

    private void warnOfIncompleteTask(StringBuilder buf, ICompositeCheatSheetTask task) {
        if (task.getState() != 3 && task.getState() != 2) {
            buf.append("<li>");
            buf.append("<a href=\"");
            buf.append("__goto__");
            buf.append(task.getId());
            buf.append("\">");
            buf.append(NLS.bind((String)Messages.COMPOSITE_PAGE_TASK_NOT_COMPLETE, (Object[])new Object[]{MarkupParser.escapeText(task.getName())}));
            buf.append("</a>");
            buf.append("</li>");
        }
    }

    private void showSuccesorTaskLinks(ICompositeCheatSheetTask task, StringBuilder buf) {
        ICompositeCheatSheetTask[] successorTasks;
        ICompositeCheatSheetTask[] iCompositeCheatSheetTaskArray = successorTasks = new SuccesorTaskFinder(task).getRecommendedSuccessors();
        int n = successorTasks.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeCheatSheetTask successor = iCompositeCheatSheetTaskArray[n2];
            String message = NLS.bind((String)Messages.COMPOSITE_PAGE_GOTO_TASK, (Object[])new Object[]{MarkupParser.escapeText(successor.getName())});
            this.addHyperlink(buf, "__goto__" + successor.getId(), GOTO_IMAGE, message);
            ++n2;
        }
    }
}

