/*
 * Copyright (c) 2018 EKA2L1 Team.
 *
 * This file is part of EKA2L1 project
 * (see bentokun.github.com/EKA2L1).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#include <common/language.h>
#include <map>

static std::map<int, std::string> lang_map{
    { 0, "Test Language" },
    { 1, "English (UK)" },
    { 2, "French" },
    { 3, "German" },
    { 4, "Spanish" },
    { 5, "Italian" },
    { 6, "Swedish" },
    { 7, "Danish" },
    { 8, "Norwegian" },
    { 9, "Finnish" },
    { 10, "English American" },
    { 11, "Swiss French" },
    { 12, "Swiss German" },
    { 13, "Portuguese" },
    { 14, "Turkish" },
    { 15, "Icelandic" },
    { 16, "Russian" },
    { 17, "Hungarian" },
    { 18, "Dutch" },
    { 19, "Flemish Belgian" },
    { 20, "Australian" },
    { 21, "Belgian French" },
    { 22, "Austrian" },
    { 23, "New Zealand" },
    { 24, "French International" },
    { 25, "Czech" },
    { 26, "Slovak" },
    { 27, "Polish" },
    { 28, "Slovenian" },
    { 29, "Chinese Taiwan" },
    { 30, "Hong Kong Chinese" },
    { 31, "Chinese PRC" },
    { 32, "Japanese" },
    { 33, "Thai" },
    { 34, "Afrikaans" },
    { 35, "Albanian" },
    { 36, "Amharic" },
    { 37, "Arabic" },
    { 38, "Armenian" },
    { 39, "Tagalog" },
    { 40, "Belarussian" },
    { 41, "Bengali" },
    { 42, "Bulgarian" },
    { 43, "Burmese" },
    { 44, "Catalan" },
    { 45, "Croatian" },
    { 46, "Canadian English" },
    { 47, "English International" },
    { 48, "South African English" },
    { 49, "Estonian" },
    { 50, "Farsi" },
    { 51, "French Canadian" },
    { 52, "Gaelic Scots" },
    { 53, "Georgian" },
    { 54, "Greek" },
    { 55, "Greek (Cyprus)" },
    { 56, "Gujarati" },
    { 57, "Hebrew" },
    { 58, "Hindi" },
    { 59, "Indonesian" },
    { 60, "Irish" },
    { 61, "Swiss Italian" },
    { 62, "Kannada" },
    { 63, "Kazakh" },
    { 64, "Khmer" },
    { 65, "Korean" },
    { 66, "Laothian" },
    { 67, "Latvian" },
    { 68, "Lithuanian" },
    { 69, "Macedonian" },
    { 70, "Malay" },
    { 71, "Malayalam" },
    { 72, "Marathi" },
    { 73, "Moldovian" },
    { 74, "Mongolian" },
    { 75, "Norwegian Nynorsk" },
    { 76, "Brazilian Portuguese" },
    { 77, "Punjabi" },
    { 78, "Romanian" },
    { 79, "Serbian" },
    { 80, "Sinhalese" },
    { 81, "Somali" },
    { 82, "International Spanish" },
    { 83, "Latin American Spanish" },
    { 84, "Swahili" },
    { 85, "Finland Swedish" },
    { 86, "Reserved1" },
    { 87, "Tamil" },
    { 88, "Telugu" },
    { 89, "Tibetan" },
    { 90, "Tigrinya" },
    { 91, "Cyprus Turkish" },
    { 92, "Turkmen" },
    { 93, "Ukrainian" },
    { 94, "Urdu" },
    { 95, "Reserved2" },
    { 96, "Vietnamese" },
    { 97, "Welsh" },
    { 98, "Zulu" },
    { 99, "Other" },
    { 100, "English used by device manufacturer" },
    { 101, "South Sotho" },
    { 102, "Basque" },
    { 103, "Galician" },
    { 104, "Javanese" },
    { 105, "Maithili" },
    { 106, "Azerbaijani Latin" },
    { 107, "Azerbaijani Cyrillic" },
    { 108, "Oriya" },
    { 109, "Bhojpuri" },
    { 110, "Sundanese" },
    { 111, "Kurdish Latin" },
    { 112, "Kurdish Arabic" },
    { 113, "Pashto" },
    { 114, "Hausa" },
    { 115, "Oromo" },
    { 116, "Uzbek Latin" },
    { 117, "Uzbek Cyrillic" },
    { 118, "Sindhi Arabic" },
    { 119, "Sindhi Devanagari" },
    { 120, "Yoruba" },
    { 121, "Cebuano" },
    { 122, "Igbo" },
    { 123, "Malagasy" },
    { 124, "Nepali" },
    { 125, "Assamese" },
    { 126, "Shona" },
    { 127, "Zhuang" },
    { 128, "Madurese" },
    { 129, "English in Asia-Pacific regions" },
    { 157, "English in Taiwan" },
    { 158, "English in Hong Kong" },
    { 159, "English in People's Republic of China" },
    { 160, "English in Japan" },
    { 161, "English in Thailand" },
    { 162, "Fulfulde" },
    { 163, "Tamazight" },
    { 164, "BolivianQuechua" },
    { 165, "PeruQuechua" },
    { 166, "EcuadorQuechua" },
    { 167, "Tajik Cyrillic" },
    { 168, "Tajik PersoArabic" },
    { 169, "Nyanja" },
    { 170, "HaitianCreole" },
    { 171, "Lombard" },
    { 172, "Koongo" },
    { 173, "Akan" },
    { 174, "Hmong" },
    { 175, "Yi" },
    { 176, "Tshiluba" },
    { 177, "Ilocano" },
    { 178, "Uyghur" },
    { 179, "Neapolitan" },
    { 180, "Rwanda" },
    { 181, "Xhosa" },
    { 182, "Balochi" },
    { 183, "Hiligaynon" },
    { 184, "Minangkabau" },
    { 185, "Makhuwa" },
    { 186, "Santali" },
    { 187, "Gikuyu" },
    { 188, "Moore" },
    { 189, "Guarani" },
    { 190, "Rundi" },
    { 191, "Romani Latin" },
    { 192, "Romani Cyrillic" },
    { 193, "Tswana" },
    { 194, "Kanuri" },
    { 195, "Kashmiri Devanagari" },
    { 196, "Kashmiri PersoArabic" },
    { 197, "Umbundu" },
    { 198, "Konkani" },
    { 199, "Balinese" },
    { 200, "NorthernSotho" },
    { 201, "Wolof" },
    { 202, "Bemba" },
    { 203, "Tsonga" },
    { 204, "Yiddish" },
    { 205, "Kirghiz" },
    { 206, "Ganda" },
    { 207, "Soga" },
    { 208, "Mbundu" },
    { 209, "Bambara" },
    { 210, "CentralAymara" },
    { 211, "Zarma" },
    { 212, "Lingala" },
    { 213, "Bashkir" },
    { 214, "Chuvash" },
    { 215, "Swati" },
    { 216, "Tatar" },
    { 217, "SouthernNdebele" },
    { 218, "Sardinian" },
    { 219, "Scots" },
    { 220, "Meitei" },
    { 221, "Walloon" },
    { 222, "Kabardian" },
    { 223, "Mazanderani" },
    { 224, "Gilaki" },
    { 225, "Shan" },
    { 226, "Luyia" },
    { 227, "uageLuo" },
    { 228, "Sukuma" },
    { 229, "Aceh" },
    { 230, "English India" },
    { 326, "Malay in Asia-Pacific regions" },
    { 327, "Indonesian Apac" },
    { 0xFFFF, "None" }
};

namespace eka2l1::common {
    std::string get_language_name_by_code(int lang_code) {
        if (lang_map.count(lang_code) == 1)
            return lang_map.at(lang_code);
        return "Language not found";
    }
}
