/*
 * Copyright (c) 2021 EKA2L1 Team.
 * 
 * This file is part of EKA2L1 project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <cstdint>
#include <dispatch/libraries/register.h>

namespace eka2l1::dispatch {
    static const patch_info LIBGLES_CM_PATCH_INFOS[] = {
        // Dispatch number, Ordinal number
        { 0x1100, 1 },
        { 0x1101, 2 },
        { 0x1102, 3 },
        { 0x1103, 4 },
        { 0x1104, 5 },
        { 0x1105, 6 },
        { 0x1106, 7 },
        { 0x1107, 8 },
        { 0x1108, 9 },
        { 0x1109, 10 },
        { 0x110a, 11 },
        { 0x110b, 12 },
        { 0x110c, 13 },
        { 0x110d, 14 },
        { 0x110e, 15 },
        { 0x110f, 16 },
        { 0x1110, 17 },
        { 0x1111, 18 },
        { 0x1112, 19 },
        { 0x1113, 20 },
        { 0x1114, 21 },
        { 0x1115, 22 },
        { 0x1116, 23 },
        { 0x1117, 24 },
        { 0x1118, 25 },
        { 0x1119, 26 },
        { 0x111a, 27 },
        { 0x111b, 28 },
        { 0x111c, 29 },
        { 0x111d, 30 },
        { 0x111e, 31 },
        { 0x111f, 32 },
        { 0x1120, 33 },
        { 0x1121, 34 },
        { 0x1122, 35 },
        { 0x1123, 36 },
        { 0x1124, 37 },
        { 0x1125, 38 },
        { 0x1126, 39 },
        { 0x1127, 40 },
        { 0x1128, 41 },
        { 0x1129, 42 },
        { 0x112a, 43 },
        { 0x112b, 44 },
        { 0x112c, 45 },
        { 0x112d, 46 },
        { 0x112e, 47 },
        { 0x112f, 48 },
        { 0x1130, 49 },
        { 0x1131, 50 },
        { 0x1132, 51 },
        { 0x1133, 52 },
        { 0x1134, 53 },
        { 0x1135, 54 },
        { 0x1136, 55 },
        { 0x1137, 56 },
        { 0x1138, 57 },
        { 0x1139, 58 },
        { 0x113a, 59 },
        { 0x113b, 60 },
        { 0x113c, 61 },
        { 0x113d, 62 },
        { 0x113e, 63 },
        { 0x113f, 64 },
        { 0x1140, 65 },
        { 0x1141, 66 },
        { 0x1142, 67 },
        { 0x1143, 68 },
        { 0x1144, 69 },
        { 0x1145, 70 },
        { 0x1146, 71 },
        { 0x1147, 72 },
        { 0x1148, 73 },
        { 0x1149, 74 },
        { 0x114a, 75 },
        { 0x114b, 76 },
        { 0x114c, 77 },
        { 0x114d, 78 },
        { 0x114e, 79 },
        { 0x114f, 80 },
        { 0x1150, 81 },
        { 0x1151, 82 },
        { 0x1152, 83 },
        { 0x1153, 84 },
        { 0x1154, 85 },
        { 0x1155, 86 },
        { 0x1156, 87 },
        { 0x1157, 88 },
        { 0x1158, 89 },
        { 0x1159, 90 },
        { 0x115a, 91 },
        { 0x115b, 92 },
        { 0x115c, 93 },
        { 0x115d, 94 },
        { 0x115e, 95 },
        { 0x115f, 96 },
        { 0x1160, 97 },
        { 0x1161, 98 },
        { 0x1162, 99 },
        { 0x1163, 100 },
        { 0x1164, 101 },
        { 0x1165, 102 },
        { 0x1166, 103 },
        { 0x1167, 104 },
        { 0x1168, 105 },
        { 0x1169, 106 },
        { 0x116a, 107 },
        { 0x116b, 108 },
        { 0x116c, 109 },
        { 0x116d, 110 },
        { 0x116e, 111 },
        { 0x116f, 112 },
        { 0x1170, 113 },
        { 0x1171, 114 },
        { 0x1172, 115 },
        { 0x1173, 116 },
        { 0x1174, 117 },
        { 0x1175, 118 },
        { 0x1176, 119 },
        { 0x1177, 120 },
        { 0x1178, 121 },
        { 0x1179, 122 },
        { 0x117a, 123 },
        { 0x117b, 124 },
        { 0x117c, 125 },
        { 0x117d, 126 },
        { 0x117e, 127 },
        { 0x117f, 128 },
        { 0x1180, 129 },
        { 0x1181, 130 },
        { 0x1182, 131 },
        { 0x1183, 132 },
        { 0x1184, 133 },
        { 0x1185, 134 },
        { 0x1186, 135 },
        { 0x1187, 136 },
        { 0x1188, 137 },
        { 0x1189, 138 },
        { 0x118a, 139 },
        { 0x118b, 140 },
        { 0x118c, 141 },
        { 0x118d, 142 },
        { 0x118e, 143 },
        { 0x118f, 144 },
        { 0x1190, 145 },
        { 0x1191, 146 },
        { 0x1192, 147 },
        { 0x1193, 148 },
        { 0x1194, 149 },
        { 0x1195, 150 },
        { 0x1196, 151 },
        { 0x1197, 152 },
        { 0x1198, 153 },
        { 0x1199, 154 },
        { 0x119a, 155 },
        { 0x119b, 156 },
        { 0x119c, 157 },
        { 0x119d, 158 },
        { 0x119e, 159 },
        { 0x119f, 160 },
        { 0x11a0, 161 },
        { 0x11a1, 162 },
        { 0x11a2, 163 },
        { 0x11a3, 164 },
        { 0x11a4, 165 },
        { 0x11a5, 166 },
        { 0x11a6, 167 },
        { 0x11a7, 168 },
        { 0x11a8, 169 },
        { 0x11a9, 170 },
        { 0x11aa, 171 },
        { 0x11ab, 172 },
        { 0x11ac, 173 },
        { 0x11ad, 174 },
        { 0x11ae, 175 }
    };

    static const patch_info LIBGLES_V1_CM_PATCH_INFOS[] = {
        { 0x1119, 2 },
        { 0x111a, 3 },
        { 0x111b, 4 },
        { 0x1185, 5 },
        { 0x111c, 6 },
        { 0x111d, 7 },
        { 0x1186, 8 },
        { 0x1187, 9 },
        { 0x111e, 10 },
        { 0x111f, 11 },
        { 0x1120, 12 },
        { 0x1121, 13 },
        { 0x1122, 14 },
        { 0x1123, 15 },
        { 0x1124, 16 },
        { 0x1188, 17 },
        { 0x1189, 18 },
        { 0x1125, 19 },
        { 0x118A, 20 },
        { 0x1126, 21 },
        { 0x1127, 22 },
        { 0x1128, 23 },
        { 0x1129, 24 },
        { 0x112a, 25 },
        { 0x112b, 26 },
        { 0x112c, 27 },
        { 0x112d, 28 },
        { 0x11b4, 29 },
        { 0x118b, 30 },
        { 0x112e, 31 },
        { 0x112f, 32 },
        { 0x1130, 33 },
        { 0x1131, 34 },
        { 0x1132, 35 },
        { 0x1133, 36 },
        { 0x1134, 37 },
        { 0x1135, 38 },
        { 0x1136, 39 },
        { 0x11b5, 40 },
        { 0x11b6, 41 },
        { 0x11b7, 42 },
        { 0x11b8, 43 },
        { 0x11b9, 44 },
        { 0x11ba, 45 },
        { 0x11bb, 46 },
        { 0x11bc, 47 },
        { 0x1137, 48 },
        { 0x1138, 49 },
        { 0x1139, 50 },
        { 0x113a, 51 },
        { 0x113b, 52 },
        { 0x113c, 53 },
        { 0x113d, 54 },
        { 0x113e, 55 },
        { 0x113f, 56 },
        { 0x1140, 57 },
        { 0x1141, 58 },
        { 0x118c, 59 },
        { 0x1142, 60 },
        { 0x118d, 61 },
        { 0x118e, 62 },
        { 0x118f, 63 },
        { 0x1190, 64 },
        { 0x1143, 65 },
        { 0x1191, 66 },
        { 0x1192, 67 },
        { 0x1144, 68 },
        { 0x1193, 69 },
        { 0x1194, 70 },
        { 0x1195, 71 },
        { 0x1196, 72 },
        { 0x1197, 73 },
        { 0x1145, 74 },
        { 0x1198, 75 },
        { 0x1199, 76 },
        { 0x119a, 77 },
        { 0x119b, 78 },
        { 0x119c, 79 },
        { 0x119d, 80 },
        { 0x1146, 81 },
        { 0x119e, 82 },
        { 0x119f, 83 },
        { 0x11a0, 84 },
        { 0x114b, 85 },
        { 0x114c, 86 },
        { 0x1147, 87 },
        { 0x1148, 88 },
        { 0x1149, 89 },
        { 0x114a, 90 },
        { 0x114d, 91 },
        { 0x114e, 92 },
        { 0x114f, 93 },
        { 0x1150, 94 },
        { 0x1151, 95 },
        { 0x1152, 96 },
        { 0x1153, 97 },
        { 0x11bd, 98 },
        { 0x1154, 99 },
        { 0x1155, 100 },
        { 0x1156, 101 },
        { 0x1157, 102 },
        { 0x1158, 103 },
        { 0x11be, 104 },
        { 0x1159, 105 },
        { 0x115c, 106 },
        { 0x115d, 107 },
        { 0x115a, 108 },
        { 0x115b, 109 },
        { 0x115e, 110 },
        { 0x115f, 111 },
        { 0x1160, 112 },
        { 0x1161, 113 },
        { 0x1162, 114 },
        { 0x1163, 115 },
        { 0x11a1, 116 },
        { 0x11a2, 117 },
        { 0x11a3, 118 },
        { 0x11a4, 119 },
        { 0x1164, 120 },
        { 0x11a5, 121 },
        { 0x1165, 122 },
        { 0x1166, 123 },
        { 0x1167, 124 },
        { 0x1168, 125 },
        { 0x1169, 126 },
        { 0x116b, 127 },
        { 0x116c, 128 },
        { 0x116d, 129 },
        { 0x116e, 130 },
        { 0x116f, 131 },
        { 0x1170, 132 },
        { 0x1171, 133 },
        { 0x1172, 134 },
        { 0x1173, 135 },
        { 0x1174, 136 },
        { 0x1175, 137 },
        { 0x1176, 138 },
        { 0x1177, 139 },
        { 0x1178, 140 },
        { 0x1179, 141 },
        { 0x11a6, 142 },
        { 0x11a7, 143 },
        { 0x117a, 144 },
        { 0x117b, 145 },
        { 0x117c, 146 },
        { 0x117d, 147 },
        { 0x11a8, 148 },
        { 0x11a9, 149 },
        { 0x11aa, 150 },
        { 0x117e, 151 },
        { 0x11ab, 152 },
        { 0x117f, 153 },
        { 0x1180, 154 },
        { 0x1181, 155 },
        { 0x1182, 156 },
        { 0x1183, 157 },
        { 0x11bf, 158 }
    };

    static const std::uint32_t LIBGLES_CM_PATCH_COUNT = sizeof(LIBGLES_CM_PATCH_INFOS) / sizeof(patch_info);
    static const std::uint32_t LIBGLES_V1_CM_PATCH_COUNT = sizeof(LIBGLES_V1_CM_PATCH_INFOS) / sizeof(patch_info);
}