/*
 * Copyright (c) 2021 EKA2L1 Team.
 * 
 * This file is part of EKA2L1 project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <cstdint>
#include <dispatch/libraries/register.h>

namespace eka2l1::dispatch {
    static const patch_info LIBGLESV2_PATCH_INFOS[] = {
        // Dispatch number, Ordinal number
        { 0x1119, 2 },
        { 0x11C0, 3 },
        { 0x11C1, 4 },
        { 0x1185, 5 },
        { 0x11C2, 6 },
        { 0x11C3, 7 },
        { 0x111C, 8 },
        { 0x11C4, 9 },
        { 0x11C5, 10 },
        { 0x11C6, 11 },
        { 0x111D, 12 },
        { 0x11C7, 13 },
        { 0x1186, 14 },
        { 0x1187, 15 },
        { 0x11C8, 16 },
        { 0x111E, 17 },
        { 0x111F, 18 },
        { 0x1121, 19 },
        { 0x1123, 20 },
        { 0x1127, 21 },
        { 0x11C9, 22 },
        { 0x1129, 23 },
        { 0x112A, 24 },
        { 0x112B, 25 },
        { 0x112C, 26 },
        { 0x11CA, 27 },
        { 0x11CB, 28 },
        { 0x112D, 29 },
        { 0x118B, 30 },
        { 0x11CC, 31 },
        { 0x11CD, 32 },
        { 0x11CE, 33 },
        { 0x11CF, 34 },
        { 0x112E, 35 },
        { 0x112F, 36 },
        { 0x1130, 37 },
        { 0x1131, 38 },
        { 0x11D0, 39 },
        { 0x1133, 40 },
        { 0x11D1, 41 },
        { 0x1135, 42 },
        { 0x1136, 43 },
        { 0x1137, 44 },
        { 0x11D2, 45 },
        { 0x1139, 46 },
        { 0x113A, 47 },
        { 0x11D3, 48 },
        { 0x11D4, 49 },
        { 0x113F, 50 },
        { 0x118C, 51 },
        { 0x11D5, 52 },
        { 0x11D6, 53 },
        { 0x1142, 54 },
        { 0x11D7, 55 },
        { 0x11D8, 56 },
        { 0x11D9, 57 },
        { 0x11DA, 58 },
        { 0x11DB, 59 },
        { 0x118D, 60 },
        { 0x118E, 61 },
        { 0x1143, 62 },
        { 0x1192, 63 },
        { 0x11DC, 64 },
        { 0x1144, 65 },
        { 0x11DD, 66 },
        { 0x11DE, 67 },
        { 0x11DF, 68 },
        { 0x11E0, 69 },
        { 0x11E1, 70 },
        { 0x11E2, 71 },
        { 0x11E3, 72 },
        { 0x1145, 73 },
        { 0x119B, 74 },
        { 0x119C, 75 },
        { 0x1211, 76 },
        { 0x1212, 77 },
        { 0x1213, 78 },
        { 0x11E4, 79 },
        { 0x11E5, 80 },
        { 0x11E6, 81 },
        { 0x1146, 82 },
        { 0x119E, 83 },
        { 0x119F, 84 },
        { 0x11E7, 85 },
        { 0x11E8, 86 },
        { 0x11E9, 87 },
        { 0x11EA, 88 },
        { 0x11A0, 89 },
        { 0x114F, 90 },
        { 0x11EB, 91 },
        { 0x1163, 92 },
        { 0x1166, 93 },
        { 0x116B, 94 },
        { 0x11EC, 95 },
        { 0x11ED, 96 },
        { 0x116E, 97 },
        { 0x1172, 98 },
        { 0x11EE, 99 },
        { 0x11EF, 100 },
        { 0x1174, 101 },
        { 0x11F0, 102 },
        { 0x1175, 103 },
        { 0x11F1, 104 },
        { 0x1176, 105 },
        { 0x11F2, 106 },
        { 0x117C, 107 },
        { 0x117D, 108 },
        { 0x11A8, 109 },
        { 0x11A9, 110 },
        { 0x11AA, 111 },
        { 0x117F, 112 },
        { 0x11F3, 113 },
        { 0x11F4, 114 },
        { 0x11F5, 115 },
        { 0x11F6, 116 },
        { 0x11F7, 117 },
        { 0x11F8, 118 },
        { 0x11F9, 119 },
        { 0x11FA, 120 },
        { 0x11FB, 121 },
        { 0x11FC, 122 },
        { 0x11FD, 123 },
        { 0x11FE, 124 },
        { 0x11FF, 125 },
        { 0x1200, 126 },
        { 0x1201, 127 },
        { 0x1202, 128 },
        { 0x1203, 129 },
        { 0x1204, 130 },
        { 0x1205, 131 },
        { 0x1206, 132 },
        { 0x1207, 133 },
        { 0x1208, 134 },
        { 0x1209, 135 },
        { 0x120A, 136 },
        { 0x120B, 137 },
        { 0x120C, 138 },
        { 0x120D, 139 },
        { 0x120E, 140 },
        { 0x120F, 141 },
        { 0x1210, 142 },
        { 0x1183, 143 }
    };

    static const std::uint32_t LIBGLESV2_PATCH_COUNT = sizeof(LIBGLESV2_PATCH_INFOS) / sizeof(patch_info);
}