/*
 * Copyright (c) 2023 EKA2L1 Team.
 * 
 * This file is part of EKA2L1 project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <common/applauncher.h>
#include <utils/reqsts.h>
#include <utils/err.h>

#include <kernel/kernel.h>

#include <QDesktopServices>
#include <QMessageBox>
#include <QUrl>

namespace eka2l1::common {
    bool launch_browser(const std::string &url) {
        QUrl qt_url(QString::fromStdString(url));
        return QDesktopServices::openUrl(qt_url);
    }
}