/*
 * Copyright (c) 2021 EKA2L1 Team
 *
 * This file is part of EKA2L1 project.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <lua.hpp>

namespace eka2l1::scripting {
    struct luacpp_state {
    public:
        lua_State *state_;

    public:
        explicit luacpp_state()
            : state_(nullptr) {
        }

        explicit luacpp_state(lua_State *state)
            : state_(state) {
        }

        ~luacpp_state() {
            if (state_) {
                lua_settop(state_, 0);
                lua_gc(state_, LUA_GCCOLLECT, 0);
                lua_close(state_);
            }
        }
    };
}