/*
 * Copyright (c) 2019 EKA2L1 Team.
 * 
 * This file is part of EKA2L1 project.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <kernel/server.h>
#include <scripting/server.h>

namespace eka2l1::scripting {
    server_wrapper::server_wrapper(std::uint64_t handle)
        : srv_(reinterpret_cast<service::server *>(handle)) {
    }

    std::string server_wrapper::get_name() {
        return srv_->name();
    }
}

extern "C" {
EKA2L1_EXPORT void eka2l1_free_server(eka2l1::scripting::server_wrapper *svr) {
    delete svr;
}

EKA2L1_EXPORT const char *eka2l1_server_name(eka2l1::scripting::server_wrapper *sv) {
    std::string data = sv->get_name();
    char *ret_val = new char[data.length() + 1];

    std::memcpy(ret_val, data.data(), data.length());
    ret_val[data.length()] = '\0';

    return ret_val;
}
}