/*
 * Copyright (c) 2020 EKA2L1 Team
 * 
 * This file is part of EKA2L1 project
 * (see bentokun.github.com/EKA2L1).
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

namespace eka2l1::epoc {

    enum std_scan_code {
        std_key_null = 0x00,
        std_key_backspace = 0x01,
        std_key_tab = 0x02,
        std_key_enter = 0x03,
        std_key_escape = 0x04,
        std_key_space = 0x05,
        std_key_print_screen = 0x06,
        std_key_pause = 0x07,
        std_key_home = 0x08,
        std_key_end = 0x09,
        std_key_page_up = 0x0a,
        std_key_page_down = 0x0b,
        std_key_insert = 0x0c,
        std_key_delete = 0x0d,
        std_key_left_arrow = 0x0e,
        std_key_right_arrow = 0x0f,
        std_key_up_arrow = 0x10,
        std_key_down_arrow = 0x11,
        std_key_left_shift = 0x12,
        std_key_right_shift = 0x13,
        std_key_left_alt = 0x14,
        std_key_right_alt = 0x15,
        std_key_left_ctrl = 0x16,
        std_key_right_ctrl = 0x17,
        std_key_left_func = 0x18,
        std_key_right_func = 0x19,
        std_key_caps_lock = 0x1a,
        std_key_num_lock = 0x1b,
        std_key_scroll_lock = 0x1c,
        std_key_f1 = 0x60,
        std_key_f2 = 0x61,
        std_key_f3 = 0x62,
        std_key_f4 = 0x63,
        std_key_f5 = 0x64,
        std_key_f6 = 0x65,
        std_key_f7 = 0x66,
        std_key_f8 = 0x67,
        std_key_f9 = 0x68,
        std_key_f10 = 0x69,
        std_key_f11 = 0x6a,
        std_key_f12 = 0x6b,
        std_key_f13 = 0x6c,
        std_key_f14 = 0x6d,
        std_key_f15 = 0x6e,
        std_key_f16 = 0x6f,
        std_key_f17 = 0x70,
        std_key_f18 = 0x71,
        std_key_f19 = 0x72,
        std_key_f20 = 0x73,
        std_key_f21 = 0x74,
        std_key_f22 = 0x75,
        std_key_f23 = 0x76,
        std_key_f24 = 0x77,
        std_key_xxx = 0x78,
        std_key_comma = 0x79,
        std_key_full_stop = 0x7a,
        std_key_forward_slash = 0x7b,
        std_key_back_slash = 0x7c,
        std_key_semicolon = 0x7d,
        std_key_single_quote = 0x7e,
        std_key_hash = 0x7f,
        std_key_square_bracket_left = 0x80,
        std_key_square_bracket_right = 0x81,
        std_key_minus = 0x82,
        std_key_equals = 0x83,
        std_key_nkp_forward_slash = 0x84,
        std_key_nkp_asterisk = 0x85,
        std_key_nkp_minus = 0x86,
        std_key_nkp_plus = 0x87,
        std_key_nkp_enter = 0x88,
        std_key_nkp_1 = 0x89,
        std_key_nkp_2 = 0x8a,
        std_key_nkp_3 = 0x8b,
        std_key_nkp_4 = 0x8c,
        std_key_nkp_5 = 0x8d,
        std_key_nkp_6 = 0x8e,
        std_key_nkp_7 = 0x8f,
        std_key_nkp_8 = 0x90,
        std_key_nkp_9 = 0x91,
        std_key_nkp_0 = 0x92,
        std_key_nkp_full_stop = 0x93,
        std_key_menu = 0x94,
        std_key_backlight_on = 0x95,
        std_key_backlight_off = 0x96,
        std_key_backlight_toggle = 0x97,
        std_key_inc_contrast = 0x98,
        std_key_dec_contrast = 0x99,
        std_key_slider_down = 0x9a,
        std_key_slider_up = 0x9b,
        std_key_dictaphone_play = 0x9c,
        std_key_dictaphone_stop = 0x9d,
        std_key_dictaphone_record = 0x9e,
        std_key_help = 0x9f,
        std_key_off = 0xa0,
        std_key_dial = 0xa1,
        std_key_inc_volume = 0xa2,
        std_key_dec_volume = 0xa3,
        std_key_device_0 = 0xa4,
        std_key_device_1 = 0xa5,
        std_key_device_2 = 0xa6,
        std_key_device_3 = 0xa7,
        std_key_device_4 = 0xa8,
        std_key_device_5 = 0xa9,
        std_key_device_6 = 0xaa,
        std_key_device_7 = 0xab,
        std_key_device_8 = 0xac,
        std_key_device_9 = 0xad,
        std_key_device_a = 0xae,
        std_key_device_b = 0xaf,
        std_key_device_c = 0xb0,
        std_key_device_d = 0xb1,
        std_key_device_e = 0xb2,
        std_key_device_f = 0xb3,
        std_key_application_0 = 0xb4,
        std_key_application_1 = 0xb5,
        std_key_application_2 = 0xb6,
        std_key_application_3 = 0xb7,
        std_key_application_4 = 0xb8,
        std_key_application_5 = 0xb9,
        std_key_application_6 = 0xba,
        std_key_application_7 = 0xbb,
        std_key_application_8 = 0xbc,
        std_key_application_9 = 0xbd,
        std_key_application_a = 0xbe,
        std_key_application_b = 0xbf,
        std_key_application_c = 0xc0,
        std_key_application_d = 0xc1,
        std_key_application_e = 0xc2,
        std_key_application_f = 0xc3,
        std_key_yes = 0xc4,
        std_key_no = 0xc5,
        std_key_inc_brightness = 0xc6,
        std_key_dec_brightness = 0xc7,
        std_key_keyboard_extend = 0xc8,
        std_key_device_10 = 0xc9,
        std_key_device_11 = 0xca,
        std_key_device_12 = 0xcb,
        std_key_device_13 = 0xcc,
        std_key_device_14 = 0xcd,
        std_key_device_15 = 0xce,
        std_key_device_16 = 0xcf,
        std_key_device_17 = 0xd0,
        std_key_device_18 = 0xd1,
        std_key_device_19 = 0xd2,
        std_key_device_1a = 0xd3,
        std_key_device_1b = 0xd4,
        std_key_device_1c = 0xd5,
        std_key_device_1d = 0xd6,
        std_key_device_1e = 0xd7,
        std_key_device_1f = 0xd8,
        std_key_application_10 = 0xd9,
        std_key_application_11 = 0xda,
        std_key_application_12 = 0xdb,
        std_key_application_13 = 0xdc,
        std_key_application_14 = 0xdd,
        std_key_application_15 = 0xde,
        std_key_application_16 = 0xdf,
        std_key_application_17 = 0xe0,
        std_key_application_18 = 0xe1,
        std_key_application_19 = 0xe2,
        std_key_application_1a = 0xe3,
        std_key_application_1b = 0xe4,
        std_key_application_1c = 0xe5,
        std_key_application_1d = 0xe6,
        std_key_application_1e = 0xe7,
        std_key_application_1f = 0xe8,
        std_key_device_20 = 0xe9,
        std_key_device_21 = 0xea,
        std_key_device_22 = 0xeb,
        std_key_device_23 = 0xec,
        std_key_device_24 = 0xed,
        std_key_device_25 = 0xee,
        std_key_device_26 = 0xef,
        std_key_device_27 = 0xf0,
        std_key_application_20 = 0xf1,
        std_key_application_21 = 0xf2,
        std_key_application_22 = 0xf3,
        std_key_application_23 = 0xf4,
        std_key_application_24 = 0xf5,
        std_key_application_25 = 0xf6,
        std_key_application_26 = 0xf7,
        std_key_application_27 = 0xf8
    };

    enum key_code {
        key_null = 0x0000,
        key_bell = 0x0007,
        key_backspace = 0x0008,
        key_tab = 0x0009,
        key_line_feed = 0x000a,
        key_vertical_tab = 0x000b,
        key_form_feed = 0x000c,
        key_enter = 0x000d,
        key_escape = 0x001b,
        key_space = 0x0020,
        key_delete = 0x007f,
        key_print_screen = 0xf800,
        key_pause,
        key_home,
        key_end,
        key_page_up,
        key_page_down,
        key_insert,
        key_left_arrow,
        key_right_arrow,
        key_up_arrow,
        key_down_arrow,
        key_left_shift,
        key_right_shift,
        key_left_alt,
        key_right_alt,
        key_left_ctrl,
        key_right_ctrl,
        key_left_func,
        key_right_func,
        key_caps_lock,
        key_num_lock,
        key_scroll_lock,
        key_f1,
        key_f2,
        key_f3,
        key_f4,
        key_f5,
        key_f6,
        key_f7,
        key_f8,
        key_f9,
        key_f10,
        key_f11,
        key_f12,
        key_f13,
        key_f14,
        key_f15,
        key_f16,
        key_f17,
        key_f18,
        key_f19,
        key_f20,
        key_f21,
        key_f22,
        key_f23,
        key_f24,
        key_off,
        key_inc_contrast,
        key_dec_contrast,
        key_backlight_on,
        key_backlight_off,
        key_backlight_toggle,
        key_slider_down,
        key_slider_up,
        key_menu,
        key_dictaphone_play,
        key_dictaphone_stop,
        key_dictaphone_record,
        key_help,
        key_dial,
        key_screen_dimension_0,
        key_screen_dimension_1,
        key_screen_dimension_2,
        key_screen_dimension_3,
        key_inc_volume,
        key_dec_volume,
        key_device_0,
        key_device_1,
        key_device_2,
        key_device_3,
        key_device_4,
        key_device_5,
        key_device_6,
        key_device_7,
        key_device_8,
        key_device_9,
        key_device_a,
        key_device_b,
        key_device_c,
        key_device_d,
        key_device_e,
        key_device_f,
        key_application_0,
        key_application_1,
        key_application_2,
        key_application_3,
        key_application_4,
        key_application_5,
        key_application_6,
        key_application_7,
        key_application_8,
        key_application_9,
        key_application_a,
        key_application_b,
        key_application_c,
        key_application_d,
        key_application_e,
        key_application_f,
        key_yes,
        key_no,
        key_inc_brightness,
        key_dec_brightness,
        key_keyboard_extend,
        key_device_10,
        key_device_11,
        key_device_12,
        key_device_13,
        key_device_14,
        key_device_15,
        key_device_16,
        key_device_17,
        key_device_18,
        key_device_19,
        key_device_1a,
        key_device_1b,
        key_device_1c,
        key_device_1d,
        key_device_1e,
        key_device_1f,
        key_application_10,
        key_application_11,
        key_application_12,
        key_application_13,
        key_application_14,
        key_application_15,
        key_application_16,
        key_application_17,
        key_application_18,
        key_application_19,
        key_application_1a,
        key_application_1b,
        key_application_1c,
        key_application_1d,
        key_application_1e,
        key_application_1f,
        key_device_20,
        key_device_21,
        key_device_22,
        key_device_23,
        key_device_24,
        key_device_25,
        key_device_26,
        key_device_27,
        key_application_20,
        key_application_21,
        key_application_22,
        key_application_23,
        key_application_24,
        key_application_25,
        key_application_26,
        key_application_27
    };
}
