/*

    OpenGL, OpenGL ES loader generated by glad 0.1.35 on Sun Mar 27 16:05:04 2022.

    Language/Generator: C/C++ Debug
    Specification: gl
    APIs: gl=3.3, gles2=3.0
    Profile: core
    Extensions:
        GL_ARB_ES3_compatibility,
        GL_ARB_draw_elements_base_vertex,
        GL_EXT_texture_compression_s3tc,
        GL_EXT_texture_compression_s3tc_srgb,
        GL_EXT_texture_filter_anisotropic,
        GL_IMG_texture_compression_pvrtc,
        GL_IMG_texture_compression_pvrtc2
    Loader: True
    Local files: False
    Omit khrplatform: False
    Reproducible: False

    Commandline:
        --profile="core" --api="gl=3.3,gles2=3.0" --generator="c-debug" --spec="gl" --extensions="GL_ARB_ES3_compatibility,GL_ARB_draw_elements_base_vertex,GL_EXT_texture_compression_s3tc,GL_EXT_texture_compression_s3tc_srgb,GL_EXT_texture_filter_anisotropic,GL_IMG_texture_compression_pvrtc,GL_IMG_texture_compression_pvrtc2"
    Online:
        https://glad.dav1d.de/#profile=core&language=c-debug&specification=gl&loader=on&api=gl%3D3.3&api=gles2%3D3.0&extensions=GL_ARB_ES3_compatibility&extensions=GL_ARB_draw_elements_base_vertex&extensions=GL_EXT_texture_compression_s3tc&extensions=GL_EXT_texture_compression_s3tc_srgb&extensions=GL_EXT_texture_filter_anisotropic&extensions=GL_IMG_texture_compression_pvrtc&extensions=GL_IMG_texture_compression_pvrtc2
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glad/glad.h>

void _pre_call_callback_default_gl(const char *name, void *funcptr, int len_args, ...) {
    (void) name;
    (void) funcptr;
    (void) len_args;
}
void _post_call_callback_default_gl(const char *name, void *funcptr, int len_args, ...) {
    GLenum error_code;

    (void) funcptr;
    (void) len_args;

    error_code = glad_glGetError();

    if (error_code != GL_NO_ERROR) {
        fprintf(stderr, "ERROR %d in %s\n", error_code, name);
    }
}

static GLADcallback _pre_call_callback_gl = _pre_call_callback_default_gl;
void glad_set_pre_callback_gl(GLADcallback cb) {
    _pre_call_callback_gl = cb;
}

static GLADcallback _post_call_callback_gl = _post_call_callback_default_gl;
void glad_set_post_callback_gl(GLADcallback cb) {
    _post_call_callback_gl = cb;
}

void glad_set_pre_callback(GLADcallback cb) {
    glad_set_pre_callback_gl(cb);
}
void glad_set_post_callback(GLADcallback cb) {
    glad_set_post_callback_gl(cb);
}

static void* get_proc(const char *namez);

#if defined(_WIN32) || defined(__CYGWIN__)
#ifndef _WINDOWS_
#undef APIENTRY
#endif
#include <windows.h>
static HMODULE libGL;

typedef void* (APIENTRYP PFNWGLGETPROCADDRESSPROC_PRIVATE)(const char*);
static PFNWGLGETPROCADDRESSPROC_PRIVATE gladGetProcAddressPtr;

#ifdef _MSC_VER
#ifdef __has_include
  #if __has_include(<winapifamily.h>)
    #define HAVE_WINAPIFAMILY 1
  #endif
#elif _MSC_VER >= 1700 && !_USING_V110_SDK71_
  #define HAVE_WINAPIFAMILY 1
#endif
#endif

#ifdef HAVE_WINAPIFAMILY
  #include <winapifamily.h>
  #if !WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) && WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)
    #define IS_UWP 1
  #endif
#endif

static
int open_gl(void) {
#ifndef IS_UWP
    libGL = LoadLibraryW(L"opengl32.dll");
    if(libGL != NULL) {
        void (* tmp)(void);
        tmp = (void(*)(void)) GetProcAddress(libGL, "wglGetProcAddress");
        gladGetProcAddressPtr = (PFNWGLGETPROCADDRESSPROC_PRIVATE) tmp;
        return gladGetProcAddressPtr != NULL;
    }
#endif

    return 0;
}

static
void close_gl(void) {
    if(libGL != NULL) {
        FreeLibrary((HMODULE) libGL);
        libGL = NULL;
    }
}
#else
#include <dlfcn.h>
static void* libGL;

#if !defined(__APPLE__) && !defined(__HAIKU__)
typedef void* (APIENTRYP PFNGLXGETPROCADDRESSPROC_PRIVATE)(const char*);
static PFNGLXGETPROCADDRESSPROC_PRIVATE gladGetProcAddressPtr;
#endif

static
int open_gl(void) {
#ifdef __APPLE__
    static const char *NAMES[] = {
        "../Frameworks/OpenGL.framework/OpenGL",
        "/Library/Frameworks/OpenGL.framework/OpenGL",
        "/System/Library/Frameworks/OpenGL.framework/OpenGL",
        "/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL"
    };
#else
    static const char *NAMES[] = {"libGL.so.1", "libGL.so"};
#endif

    unsigned int index = 0;
    for(index = 0; index < (sizeof(NAMES) / sizeof(NAMES[0])); index++) {
        libGL = dlopen(NAMES[index], RTLD_NOW | RTLD_GLOBAL);

        if(libGL != NULL) {
#if defined(__APPLE__) || defined(__HAIKU__)
            return 1;
#else
            gladGetProcAddressPtr = (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(libGL,
                "glXGetProcAddressARB");
            return gladGetProcAddressPtr != NULL;
#endif
        }
    }

    return 0;
}

static
void close_gl(void) {
    if(libGL != NULL) {
        dlclose(libGL);
        libGL = NULL;
    }
}
#endif

static
void* get_proc(const char *namez) {
    void* result = NULL;
    if(libGL == NULL) return NULL;

#if !defined(__APPLE__) && !defined(__HAIKU__)
    if(gladGetProcAddressPtr != NULL) {
        result = gladGetProcAddressPtr(namez);
    }
#endif
    if(result == NULL) {
#if defined(_WIN32) || defined(__CYGWIN__)
        result = (void*)GetProcAddress((HMODULE) libGL, namez);
#else
        result = dlsym(libGL, namez);
#endif
    }

    return result;
}

int gladLoadGL(void) {
    int status = 0;

    if(open_gl()) {
        status = gladLoadGLLoader(&get_proc);
        close_gl();
    }

    return status;
}

struct gladGLversionStruct GLVersion = { 0, 0 };

#if defined(GL_ES_VERSION_3_0) || defined(GL_VERSION_3_0)
#define _GLAD_IS_SOME_NEW_VERSION 1
#endif

static int max_loaded_major;
static int max_loaded_minor;

static const char *exts = NULL;
static int num_exts_i = 0;
static char **exts_i = NULL;

static int get_exts(void) {
#ifdef _GLAD_IS_SOME_NEW_VERSION
    if(max_loaded_major < 3) {
#endif
        exts = (const char *)glGetString(GL_EXTENSIONS);
#ifdef _GLAD_IS_SOME_NEW_VERSION
    } else {
        unsigned int index;

        num_exts_i = 0;
        glGetIntegerv(GL_NUM_EXTENSIONS, &num_exts_i);
        if (num_exts_i > 0) {
            exts_i = (char **)malloc((size_t)num_exts_i * (sizeof *exts_i));
        }

        if (exts_i == NULL) {
            return 0;
        }

        for(index = 0; index < (unsigned)num_exts_i; index++) {
            const char *gl_str_tmp = (const char*)glGetStringi(GL_EXTENSIONS, index);
            size_t len = strlen(gl_str_tmp);

            char *local_str = (char*)malloc((len+1) * sizeof(char));
            if(local_str != NULL) {
                memcpy(local_str, gl_str_tmp, (len+1) * sizeof(char));
            }
            exts_i[index] = local_str;
        }
    }
#endif
    return 1;
}

static void free_exts(void) {
    if (exts_i != NULL) {
        int index;
        for(index = 0; index < num_exts_i; index++) {
            free((char *)exts_i[index]);
        }
        free((void *)exts_i);
        exts_i = NULL;
    }
}

static int has_ext(const char *ext) {
#ifdef _GLAD_IS_SOME_NEW_VERSION
    if(max_loaded_major < 3) {
#endif
        const char *extensions;
        const char *loc;
        const char *terminator;
        extensions = exts;
        if(extensions == NULL || ext == NULL) {
            return 0;
        }

        while(1) {
            loc = strstr(extensions, ext);
            if(loc == NULL) {
                return 0;
            }

            terminator = loc + strlen(ext);
            if((loc == extensions || *(loc - 1) == ' ') &&
                (*terminator == ' ' || *terminator == '\0')) {
                return 1;
            }
            extensions = terminator;
        }
#ifdef _GLAD_IS_SOME_NEW_VERSION
    } else {
        int index;
        if(exts_i == NULL) return 0;
        for(index = 0; index < num_exts_i; index++) {
            const char *e = exts_i[index];

            if(exts_i[index] != NULL && strcmp(e, ext) == 0) {
                return 1;
            }
        }
    }
#endif

    return 0;
}
int GLAD_GL_VERSION_1_0 = 0;
int GLAD_GL_VERSION_1_1 = 0;
int GLAD_GL_VERSION_1_2 = 0;
int GLAD_GL_VERSION_1_3 = 0;
int GLAD_GL_VERSION_1_4 = 0;
int GLAD_GL_VERSION_1_5 = 0;
int GLAD_GL_VERSION_2_0 = 0;
int GLAD_GL_VERSION_2_1 = 0;
int GLAD_GL_VERSION_3_0 = 0;
int GLAD_GL_VERSION_3_1 = 0;
int GLAD_GL_VERSION_3_2 = 0;
int GLAD_GL_VERSION_3_3 = 0;
int GLAD_GL_ES_VERSION_2_0 = 0;
int GLAD_GL_ES_VERSION_3_0 = 0;
PFNGLACTIVETEXTUREPROC glad_glActiveTexture;
void APIENTRY glad_debug_impl_glActiveTexture(GLenum arg0) {    
    _pre_call_callback_gl("glActiveTexture", (void*)glActiveTexture, 1, arg0);
     glad_glActiveTexture(arg0);
    _post_call_callback_gl("glActiveTexture", (void*)glActiveTexture, 1, arg0);
    
}
PFNGLACTIVETEXTUREPROC glad_debug_glActiveTexture = glad_debug_impl_glActiveTexture;
PFNGLATTACHSHADERPROC glad_glAttachShader;
void APIENTRY glad_debug_impl_glAttachShader(GLuint arg0, GLuint arg1) {    
    _pre_call_callback_gl("glAttachShader", (void*)glAttachShader, 2, arg0, arg1);
     glad_glAttachShader(arg0, arg1);
    _post_call_callback_gl("glAttachShader", (void*)glAttachShader, 2, arg0, arg1);
    
}
PFNGLATTACHSHADERPROC glad_debug_glAttachShader = glad_debug_impl_glAttachShader;
PFNGLBEGINCONDITIONALRENDERPROC glad_glBeginConditionalRender;
void APIENTRY glad_debug_impl_glBeginConditionalRender(GLuint arg0, GLenum arg1) {    
    _pre_call_callback_gl("glBeginConditionalRender", (void*)glBeginConditionalRender, 2, arg0, arg1);
     glad_glBeginConditionalRender(arg0, arg1);
    _post_call_callback_gl("glBeginConditionalRender", (void*)glBeginConditionalRender, 2, arg0, arg1);
    
}
PFNGLBEGINCONDITIONALRENDERPROC glad_debug_glBeginConditionalRender = glad_debug_impl_glBeginConditionalRender;
PFNGLBEGINQUERYPROC glad_glBeginQuery;
void APIENTRY glad_debug_impl_glBeginQuery(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glBeginQuery", (void*)glBeginQuery, 2, arg0, arg1);
     glad_glBeginQuery(arg0, arg1);
    _post_call_callback_gl("glBeginQuery", (void*)glBeginQuery, 2, arg0, arg1);
    
}
PFNGLBEGINQUERYPROC glad_debug_glBeginQuery = glad_debug_impl_glBeginQuery;
PFNGLBEGINTRANSFORMFEEDBACKPROC glad_glBeginTransformFeedback;
void APIENTRY glad_debug_impl_glBeginTransformFeedback(GLenum arg0) {    
    _pre_call_callback_gl("glBeginTransformFeedback", (void*)glBeginTransformFeedback, 1, arg0);
     glad_glBeginTransformFeedback(arg0);
    _post_call_callback_gl("glBeginTransformFeedback", (void*)glBeginTransformFeedback, 1, arg0);
    
}
PFNGLBEGINTRANSFORMFEEDBACKPROC glad_debug_glBeginTransformFeedback = glad_debug_impl_glBeginTransformFeedback;
PFNGLBINDATTRIBLOCATIONPROC glad_glBindAttribLocation;
void APIENTRY glad_debug_impl_glBindAttribLocation(GLuint arg0, GLuint arg1, const GLchar * arg2) {    
    _pre_call_callback_gl("glBindAttribLocation", (void*)glBindAttribLocation, 3, arg0, arg1, arg2);
     glad_glBindAttribLocation(arg0, arg1, arg2);
    _post_call_callback_gl("glBindAttribLocation", (void*)glBindAttribLocation, 3, arg0, arg1, arg2);
    
}
PFNGLBINDATTRIBLOCATIONPROC glad_debug_glBindAttribLocation = glad_debug_impl_glBindAttribLocation;
PFNGLBINDBUFFERPROC glad_glBindBuffer;
void APIENTRY glad_debug_impl_glBindBuffer(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glBindBuffer", (void*)glBindBuffer, 2, arg0, arg1);
     glad_glBindBuffer(arg0, arg1);
    _post_call_callback_gl("glBindBuffer", (void*)glBindBuffer, 2, arg0, arg1);
    
}
PFNGLBINDBUFFERPROC glad_debug_glBindBuffer = glad_debug_impl_glBindBuffer;
PFNGLBINDBUFFERBASEPROC glad_glBindBufferBase;
void APIENTRY glad_debug_impl_glBindBufferBase(GLenum arg0, GLuint arg1, GLuint arg2) {    
    _pre_call_callback_gl("glBindBufferBase", (void*)glBindBufferBase, 3, arg0, arg1, arg2);
     glad_glBindBufferBase(arg0, arg1, arg2);
    _post_call_callback_gl("glBindBufferBase", (void*)glBindBufferBase, 3, arg0, arg1, arg2);
    
}
PFNGLBINDBUFFERBASEPROC glad_debug_glBindBufferBase = glad_debug_impl_glBindBufferBase;
PFNGLBINDBUFFERRANGEPROC glad_glBindBufferRange;
void APIENTRY glad_debug_impl_glBindBufferRange(GLenum arg0, GLuint arg1, GLuint arg2, GLintptr arg3, GLsizeiptr arg4) {    
    _pre_call_callback_gl("glBindBufferRange", (void*)glBindBufferRange, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glBindBufferRange(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glBindBufferRange", (void*)glBindBufferRange, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLBINDBUFFERRANGEPROC glad_debug_glBindBufferRange = glad_debug_impl_glBindBufferRange;
PFNGLBINDFRAGDATALOCATIONPROC glad_glBindFragDataLocation;
void APIENTRY glad_debug_impl_glBindFragDataLocation(GLuint arg0, GLuint arg1, const GLchar * arg2) {    
    _pre_call_callback_gl("glBindFragDataLocation", (void*)glBindFragDataLocation, 3, arg0, arg1, arg2);
     glad_glBindFragDataLocation(arg0, arg1, arg2);
    _post_call_callback_gl("glBindFragDataLocation", (void*)glBindFragDataLocation, 3, arg0, arg1, arg2);
    
}
PFNGLBINDFRAGDATALOCATIONPROC glad_debug_glBindFragDataLocation = glad_debug_impl_glBindFragDataLocation;
PFNGLBINDFRAGDATALOCATIONINDEXEDPROC glad_glBindFragDataLocationIndexed;
void APIENTRY glad_debug_impl_glBindFragDataLocationIndexed(GLuint arg0, GLuint arg1, GLuint arg2, const GLchar * arg3) {    
    _pre_call_callback_gl("glBindFragDataLocationIndexed", (void*)glBindFragDataLocationIndexed, 4, arg0, arg1, arg2, arg3);
     glad_glBindFragDataLocationIndexed(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glBindFragDataLocationIndexed", (void*)glBindFragDataLocationIndexed, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLBINDFRAGDATALOCATIONINDEXEDPROC glad_debug_glBindFragDataLocationIndexed = glad_debug_impl_glBindFragDataLocationIndexed;
PFNGLBINDFRAMEBUFFERPROC glad_glBindFramebuffer;
void APIENTRY glad_debug_impl_glBindFramebuffer(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glBindFramebuffer", (void*)glBindFramebuffer, 2, arg0, arg1);
     glad_glBindFramebuffer(arg0, arg1);
    _post_call_callback_gl("glBindFramebuffer", (void*)glBindFramebuffer, 2, arg0, arg1);
    
}
PFNGLBINDFRAMEBUFFERPROC glad_debug_glBindFramebuffer = glad_debug_impl_glBindFramebuffer;
PFNGLBINDRENDERBUFFERPROC glad_glBindRenderbuffer;
void APIENTRY glad_debug_impl_glBindRenderbuffer(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glBindRenderbuffer", (void*)glBindRenderbuffer, 2, arg0, arg1);
     glad_glBindRenderbuffer(arg0, arg1);
    _post_call_callback_gl("glBindRenderbuffer", (void*)glBindRenderbuffer, 2, arg0, arg1);
    
}
PFNGLBINDRENDERBUFFERPROC glad_debug_glBindRenderbuffer = glad_debug_impl_glBindRenderbuffer;
PFNGLBINDSAMPLERPROC glad_glBindSampler;
void APIENTRY glad_debug_impl_glBindSampler(GLuint arg0, GLuint arg1) {    
    _pre_call_callback_gl("glBindSampler", (void*)glBindSampler, 2, arg0, arg1);
     glad_glBindSampler(arg0, arg1);
    _post_call_callback_gl("glBindSampler", (void*)glBindSampler, 2, arg0, arg1);
    
}
PFNGLBINDSAMPLERPROC glad_debug_glBindSampler = glad_debug_impl_glBindSampler;
PFNGLBINDTEXTUREPROC glad_glBindTexture;
void APIENTRY glad_debug_impl_glBindTexture(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glBindTexture", (void*)glBindTexture, 2, arg0, arg1);
     glad_glBindTexture(arg0, arg1);
    _post_call_callback_gl("glBindTexture", (void*)glBindTexture, 2, arg0, arg1);
    
}
PFNGLBINDTEXTUREPROC glad_debug_glBindTexture = glad_debug_impl_glBindTexture;
PFNGLBINDTRANSFORMFEEDBACKPROC glad_glBindTransformFeedback;
void APIENTRY glad_debug_impl_glBindTransformFeedback(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glBindTransformFeedback", (void*)glBindTransformFeedback, 2, arg0, arg1);
     glad_glBindTransformFeedback(arg0, arg1);
    _post_call_callback_gl("glBindTransformFeedback", (void*)glBindTransformFeedback, 2, arg0, arg1);
    
}
PFNGLBINDTRANSFORMFEEDBACKPROC glad_debug_glBindTransformFeedback = glad_debug_impl_glBindTransformFeedback;
PFNGLBINDVERTEXARRAYPROC glad_glBindVertexArray;
void APIENTRY glad_debug_impl_glBindVertexArray(GLuint arg0) {    
    _pre_call_callback_gl("glBindVertexArray", (void*)glBindVertexArray, 1, arg0);
     glad_glBindVertexArray(arg0);
    _post_call_callback_gl("glBindVertexArray", (void*)glBindVertexArray, 1, arg0);
    
}
PFNGLBINDVERTEXARRAYPROC glad_debug_glBindVertexArray = glad_debug_impl_glBindVertexArray;
PFNGLBLENDCOLORPROC glad_glBlendColor;
void APIENTRY glad_debug_impl_glBlendColor(GLfloat arg0, GLfloat arg1, GLfloat arg2, GLfloat arg3) {    
    _pre_call_callback_gl("glBlendColor", (void*)glBlendColor, 4, arg0, arg1, arg2, arg3);
     glad_glBlendColor(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glBlendColor", (void*)glBlendColor, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLBLENDCOLORPROC glad_debug_glBlendColor = glad_debug_impl_glBlendColor;
PFNGLBLENDEQUATIONPROC glad_glBlendEquation;
void APIENTRY glad_debug_impl_glBlendEquation(GLenum arg0) {    
    _pre_call_callback_gl("glBlendEquation", (void*)glBlendEquation, 1, arg0);
     glad_glBlendEquation(arg0);
    _post_call_callback_gl("glBlendEquation", (void*)glBlendEquation, 1, arg0);
    
}
PFNGLBLENDEQUATIONPROC glad_debug_glBlendEquation = glad_debug_impl_glBlendEquation;
PFNGLBLENDEQUATIONSEPARATEPROC glad_glBlendEquationSeparate;
void APIENTRY glad_debug_impl_glBlendEquationSeparate(GLenum arg0, GLenum arg1) {    
    _pre_call_callback_gl("glBlendEquationSeparate", (void*)glBlendEquationSeparate, 2, arg0, arg1);
     glad_glBlendEquationSeparate(arg0, arg1);
    _post_call_callback_gl("glBlendEquationSeparate", (void*)glBlendEquationSeparate, 2, arg0, arg1);
    
}
PFNGLBLENDEQUATIONSEPARATEPROC glad_debug_glBlendEquationSeparate = glad_debug_impl_glBlendEquationSeparate;
PFNGLBLENDFUNCPROC glad_glBlendFunc;
void APIENTRY glad_debug_impl_glBlendFunc(GLenum arg0, GLenum arg1) {    
    _pre_call_callback_gl("glBlendFunc", (void*)glBlendFunc, 2, arg0, arg1);
     glad_glBlendFunc(arg0, arg1);
    _post_call_callback_gl("glBlendFunc", (void*)glBlendFunc, 2, arg0, arg1);
    
}
PFNGLBLENDFUNCPROC glad_debug_glBlendFunc = glad_debug_impl_glBlendFunc;
PFNGLBLENDFUNCSEPARATEPROC glad_glBlendFuncSeparate;
void APIENTRY glad_debug_impl_glBlendFuncSeparate(GLenum arg0, GLenum arg1, GLenum arg2, GLenum arg3) {    
    _pre_call_callback_gl("glBlendFuncSeparate", (void*)glBlendFuncSeparate, 4, arg0, arg1, arg2, arg3);
     glad_glBlendFuncSeparate(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glBlendFuncSeparate", (void*)glBlendFuncSeparate, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLBLENDFUNCSEPARATEPROC glad_debug_glBlendFuncSeparate = glad_debug_impl_glBlendFuncSeparate;
PFNGLBLITFRAMEBUFFERPROC glad_glBlitFramebuffer;
void APIENTRY glad_debug_impl_glBlitFramebuffer(GLint arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4, GLint arg5, GLint arg6, GLint arg7, GLbitfield arg8, GLenum arg9) {    
    _pre_call_callback_gl("glBlitFramebuffer", (void*)glBlitFramebuffer, 10, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
     glad_glBlitFramebuffer(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    _post_call_callback_gl("glBlitFramebuffer", (void*)glBlitFramebuffer, 10, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    
}
PFNGLBLITFRAMEBUFFERPROC glad_debug_glBlitFramebuffer = glad_debug_impl_glBlitFramebuffer;
PFNGLBUFFERDATAPROC glad_glBufferData;
void APIENTRY glad_debug_impl_glBufferData(GLenum arg0, GLsizeiptr arg1, const void * arg2, GLenum arg3) {    
    _pre_call_callback_gl("glBufferData", (void*)glBufferData, 4, arg0, arg1, arg2, arg3);
     glad_glBufferData(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glBufferData", (void*)glBufferData, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLBUFFERDATAPROC glad_debug_glBufferData = glad_debug_impl_glBufferData;
PFNGLBUFFERSUBDATAPROC glad_glBufferSubData;
void APIENTRY glad_debug_impl_glBufferSubData(GLenum arg0, GLintptr arg1, GLsizeiptr arg2, const void * arg3) {    
    _pre_call_callback_gl("glBufferSubData", (void*)glBufferSubData, 4, arg0, arg1, arg2, arg3);
     glad_glBufferSubData(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glBufferSubData", (void*)glBufferSubData, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLBUFFERSUBDATAPROC glad_debug_glBufferSubData = glad_debug_impl_glBufferSubData;
PFNGLCHECKFRAMEBUFFERSTATUSPROC glad_glCheckFramebufferStatus;
GLenum APIENTRY glad_debug_impl_glCheckFramebufferStatus(GLenum arg0) {    
    GLenum ret;
    _pre_call_callback_gl("glCheckFramebufferStatus", (void*)glCheckFramebufferStatus, 1, arg0);
    ret =  glad_glCheckFramebufferStatus(arg0);
    _post_call_callback_gl("glCheckFramebufferStatus", (void*)glCheckFramebufferStatus, 1, arg0);
    return ret;
}
PFNGLCHECKFRAMEBUFFERSTATUSPROC glad_debug_glCheckFramebufferStatus = glad_debug_impl_glCheckFramebufferStatus;
PFNGLCLAMPCOLORPROC glad_glClampColor;
void APIENTRY glad_debug_impl_glClampColor(GLenum arg0, GLenum arg1) {    
    _pre_call_callback_gl("glClampColor", (void*)glClampColor, 2, arg0, arg1);
     glad_glClampColor(arg0, arg1);
    _post_call_callback_gl("glClampColor", (void*)glClampColor, 2, arg0, arg1);
    
}
PFNGLCLAMPCOLORPROC glad_debug_glClampColor = glad_debug_impl_glClampColor;
PFNGLCLEARPROC glad_glClear;
void APIENTRY glad_debug_impl_glClear(GLbitfield arg0) {    
    _pre_call_callback_gl("glClear", (void*)glClear, 1, arg0);
     glad_glClear(arg0);
    _post_call_callback_gl("glClear", (void*)glClear, 1, arg0);
    
}
PFNGLCLEARPROC glad_debug_glClear = glad_debug_impl_glClear;
PFNGLCLEARBUFFERFIPROC glad_glClearBufferfi;
void APIENTRY glad_debug_impl_glClearBufferfi(GLenum arg0, GLint arg1, GLfloat arg2, GLint arg3) {    
    _pre_call_callback_gl("glClearBufferfi", (void*)glClearBufferfi, 4, arg0, arg1, arg2, arg3);
     glad_glClearBufferfi(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glClearBufferfi", (void*)glClearBufferfi, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLCLEARBUFFERFIPROC glad_debug_glClearBufferfi = glad_debug_impl_glClearBufferfi;
PFNGLCLEARBUFFERFVPROC glad_glClearBufferfv;
void APIENTRY glad_debug_impl_glClearBufferfv(GLenum arg0, GLint arg1, const GLfloat * arg2) {    
    _pre_call_callback_gl("glClearBufferfv", (void*)glClearBufferfv, 3, arg0, arg1, arg2);
     glad_glClearBufferfv(arg0, arg1, arg2);
    _post_call_callback_gl("glClearBufferfv", (void*)glClearBufferfv, 3, arg0, arg1, arg2);
    
}
PFNGLCLEARBUFFERFVPROC glad_debug_glClearBufferfv = glad_debug_impl_glClearBufferfv;
PFNGLCLEARBUFFERIVPROC glad_glClearBufferiv;
void APIENTRY glad_debug_impl_glClearBufferiv(GLenum arg0, GLint arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glClearBufferiv", (void*)glClearBufferiv, 3, arg0, arg1, arg2);
     glad_glClearBufferiv(arg0, arg1, arg2);
    _post_call_callback_gl("glClearBufferiv", (void*)glClearBufferiv, 3, arg0, arg1, arg2);
    
}
PFNGLCLEARBUFFERIVPROC glad_debug_glClearBufferiv = glad_debug_impl_glClearBufferiv;
PFNGLCLEARBUFFERUIVPROC glad_glClearBufferuiv;
void APIENTRY glad_debug_impl_glClearBufferuiv(GLenum arg0, GLint arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glClearBufferuiv", (void*)glClearBufferuiv, 3, arg0, arg1, arg2);
     glad_glClearBufferuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glClearBufferuiv", (void*)glClearBufferuiv, 3, arg0, arg1, arg2);
    
}
PFNGLCLEARBUFFERUIVPROC glad_debug_glClearBufferuiv = glad_debug_impl_glClearBufferuiv;
PFNGLCLEARCOLORPROC glad_glClearColor;
void APIENTRY glad_debug_impl_glClearColor(GLfloat arg0, GLfloat arg1, GLfloat arg2, GLfloat arg3) {    
    _pre_call_callback_gl("glClearColor", (void*)glClearColor, 4, arg0, arg1, arg2, arg3);
     glad_glClearColor(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glClearColor", (void*)glClearColor, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLCLEARCOLORPROC glad_debug_glClearColor = glad_debug_impl_glClearColor;
PFNGLCLEARDEPTHPROC glad_glClearDepth;
void APIENTRY glad_debug_impl_glClearDepth(GLdouble arg0) {    
    _pre_call_callback_gl("glClearDepth", (void*)glClearDepth, 1, arg0);
     glad_glClearDepth(arg0);
    _post_call_callback_gl("glClearDepth", (void*)glClearDepth, 1, arg0);
    
}
PFNGLCLEARDEPTHPROC glad_debug_glClearDepth = glad_debug_impl_glClearDepth;
PFNGLCLEARDEPTHFPROC glad_glClearDepthf;
void APIENTRY glad_debug_impl_glClearDepthf(GLfloat arg0) {    
    _pre_call_callback_gl("glClearDepthf", (void*)glClearDepthf, 1, arg0);
     glad_glClearDepthf(arg0);
    _post_call_callback_gl("glClearDepthf", (void*)glClearDepthf, 1, arg0);
    
}
PFNGLCLEARDEPTHFPROC glad_debug_glClearDepthf = glad_debug_impl_glClearDepthf;
PFNGLCLEARSTENCILPROC glad_glClearStencil;
void APIENTRY glad_debug_impl_glClearStencil(GLint arg0) {    
    _pre_call_callback_gl("glClearStencil", (void*)glClearStencil, 1, arg0);
     glad_glClearStencil(arg0);
    _post_call_callback_gl("glClearStencil", (void*)glClearStencil, 1, arg0);
    
}
PFNGLCLEARSTENCILPROC glad_debug_glClearStencil = glad_debug_impl_glClearStencil;
PFNGLCLIENTWAITSYNCPROC glad_glClientWaitSync;
GLenum APIENTRY glad_debug_impl_glClientWaitSync(GLsync arg0, GLbitfield arg1, GLuint64 arg2) {    
    GLenum ret;
    _pre_call_callback_gl("glClientWaitSync", (void*)glClientWaitSync, 3, arg0, arg1, arg2);
    ret =  glad_glClientWaitSync(arg0, arg1, arg2);
    _post_call_callback_gl("glClientWaitSync", (void*)glClientWaitSync, 3, arg0, arg1, arg2);
    return ret;
}
PFNGLCLIENTWAITSYNCPROC glad_debug_glClientWaitSync = glad_debug_impl_glClientWaitSync;
PFNGLCOLORMASKPROC glad_glColorMask;
void APIENTRY glad_debug_impl_glColorMask(GLboolean arg0, GLboolean arg1, GLboolean arg2, GLboolean arg3) {    
    _pre_call_callback_gl("glColorMask", (void*)glColorMask, 4, arg0, arg1, arg2, arg3);
     glad_glColorMask(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glColorMask", (void*)glColorMask, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLCOLORMASKPROC glad_debug_glColorMask = glad_debug_impl_glColorMask;
PFNGLCOLORMASKIPROC glad_glColorMaski;
void APIENTRY glad_debug_impl_glColorMaski(GLuint arg0, GLboolean arg1, GLboolean arg2, GLboolean arg3, GLboolean arg4) {    
    _pre_call_callback_gl("glColorMaski", (void*)glColorMaski, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glColorMaski(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glColorMaski", (void*)glColorMaski, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLCOLORMASKIPROC glad_debug_glColorMaski = glad_debug_impl_glColorMaski;
PFNGLCOLORP3UIPROC glad_glColorP3ui;
void APIENTRY glad_debug_impl_glColorP3ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glColorP3ui", (void*)glColorP3ui, 2, arg0, arg1);
     glad_glColorP3ui(arg0, arg1);
    _post_call_callback_gl("glColorP3ui", (void*)glColorP3ui, 2, arg0, arg1);
    
}
PFNGLCOLORP3UIPROC glad_debug_glColorP3ui = glad_debug_impl_glColorP3ui;
PFNGLCOLORP3UIVPROC glad_glColorP3uiv;
void APIENTRY glad_debug_impl_glColorP3uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glColorP3uiv", (void*)glColorP3uiv, 2, arg0, arg1);
     glad_glColorP3uiv(arg0, arg1);
    _post_call_callback_gl("glColorP3uiv", (void*)glColorP3uiv, 2, arg0, arg1);
    
}
PFNGLCOLORP3UIVPROC glad_debug_glColorP3uiv = glad_debug_impl_glColorP3uiv;
PFNGLCOLORP4UIPROC glad_glColorP4ui;
void APIENTRY glad_debug_impl_glColorP4ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glColorP4ui", (void*)glColorP4ui, 2, arg0, arg1);
     glad_glColorP4ui(arg0, arg1);
    _post_call_callback_gl("glColorP4ui", (void*)glColorP4ui, 2, arg0, arg1);
    
}
PFNGLCOLORP4UIPROC glad_debug_glColorP4ui = glad_debug_impl_glColorP4ui;
PFNGLCOLORP4UIVPROC glad_glColorP4uiv;
void APIENTRY glad_debug_impl_glColorP4uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glColorP4uiv", (void*)glColorP4uiv, 2, arg0, arg1);
     glad_glColorP4uiv(arg0, arg1);
    _post_call_callback_gl("glColorP4uiv", (void*)glColorP4uiv, 2, arg0, arg1);
    
}
PFNGLCOLORP4UIVPROC glad_debug_glColorP4uiv = glad_debug_impl_glColorP4uiv;
PFNGLCOMPILESHADERPROC glad_glCompileShader;
void APIENTRY glad_debug_impl_glCompileShader(GLuint arg0) {    
    _pre_call_callback_gl("glCompileShader", (void*)glCompileShader, 1, arg0);
     glad_glCompileShader(arg0);
    _post_call_callback_gl("glCompileShader", (void*)glCompileShader, 1, arg0);
    
}
PFNGLCOMPILESHADERPROC glad_debug_glCompileShader = glad_debug_impl_glCompileShader;
PFNGLCOMPRESSEDTEXIMAGE1DPROC glad_glCompressedTexImage1D;
void APIENTRY glad_debug_impl_glCompressedTexImage1D(GLenum arg0, GLint arg1, GLenum arg2, GLsizei arg3, GLint arg4, GLsizei arg5, const void * arg6) {    
    _pre_call_callback_gl("glCompressedTexImage1D", (void*)glCompressedTexImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glCompressedTexImage1D(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glCompressedTexImage1D", (void*)glCompressedTexImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLCOMPRESSEDTEXIMAGE1DPROC glad_debug_glCompressedTexImage1D = glad_debug_impl_glCompressedTexImage1D;
PFNGLCOMPRESSEDTEXIMAGE2DPROC glad_glCompressedTexImage2D;
void APIENTRY glad_debug_impl_glCompressedTexImage2D(GLenum arg0, GLint arg1, GLenum arg2, GLsizei arg3, GLsizei arg4, GLint arg5, GLsizei arg6, const void * arg7) {    
    _pre_call_callback_gl("glCompressedTexImage2D", (void*)glCompressedTexImage2D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
     glad_glCompressedTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    _post_call_callback_gl("glCompressedTexImage2D", (void*)glCompressedTexImage2D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    
}
PFNGLCOMPRESSEDTEXIMAGE2DPROC glad_debug_glCompressedTexImage2D = glad_debug_impl_glCompressedTexImage2D;
PFNGLCOMPRESSEDTEXIMAGE3DPROC glad_glCompressedTexImage3D;
void APIENTRY glad_debug_impl_glCompressedTexImage3D(GLenum arg0, GLint arg1, GLenum arg2, GLsizei arg3, GLsizei arg4, GLsizei arg5, GLint arg6, GLsizei arg7, const void * arg8) {    
    _pre_call_callback_gl("glCompressedTexImage3D", (void*)glCompressedTexImage3D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
     glad_glCompressedTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    _post_call_callback_gl("glCompressedTexImage3D", (void*)glCompressedTexImage3D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    
}
PFNGLCOMPRESSEDTEXIMAGE3DPROC glad_debug_glCompressedTexImage3D = glad_debug_impl_glCompressedTexImage3D;
PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC glad_glCompressedTexSubImage1D;
void APIENTRY glad_debug_impl_glCompressedTexSubImage1D(GLenum arg0, GLint arg1, GLint arg2, GLsizei arg3, GLenum arg4, GLsizei arg5, const void * arg6) {    
    _pre_call_callback_gl("glCompressedTexSubImage1D", (void*)glCompressedTexSubImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glCompressedTexSubImage1D(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glCompressedTexSubImage1D", (void*)glCompressedTexSubImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC glad_debug_glCompressedTexSubImage1D = glad_debug_impl_glCompressedTexSubImage1D;
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC glad_glCompressedTexSubImage2D;
void APIENTRY glad_debug_impl_glCompressedTexSubImage2D(GLenum arg0, GLint arg1, GLint arg2, GLint arg3, GLsizei arg4, GLsizei arg5, GLenum arg6, GLsizei arg7, const void * arg8) {    
    _pre_call_callback_gl("glCompressedTexSubImage2D", (void*)glCompressedTexSubImage2D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
     glad_glCompressedTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    _post_call_callback_gl("glCompressedTexSubImage2D", (void*)glCompressedTexSubImage2D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    
}
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC glad_debug_glCompressedTexSubImage2D = glad_debug_impl_glCompressedTexSubImage2D;
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC glad_glCompressedTexSubImage3D;
void APIENTRY glad_debug_impl_glCompressedTexSubImage3D(GLenum arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4, GLsizei arg5, GLsizei arg6, GLsizei arg7, GLenum arg8, GLsizei arg9, const void * arg10) {    
    _pre_call_callback_gl("glCompressedTexSubImage3D", (void*)glCompressedTexSubImage3D, 11, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
     glad_glCompressedTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    _post_call_callback_gl("glCompressedTexSubImage3D", (void*)glCompressedTexSubImage3D, 11, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    
}
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC glad_debug_glCompressedTexSubImage3D = glad_debug_impl_glCompressedTexSubImage3D;
PFNGLCOPYBUFFERSUBDATAPROC glad_glCopyBufferSubData;
void APIENTRY glad_debug_impl_glCopyBufferSubData(GLenum arg0, GLenum arg1, GLintptr arg2, GLintptr arg3, GLsizeiptr arg4) {    
    _pre_call_callback_gl("glCopyBufferSubData", (void*)glCopyBufferSubData, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glCopyBufferSubData(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glCopyBufferSubData", (void*)glCopyBufferSubData, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLCOPYBUFFERSUBDATAPROC glad_debug_glCopyBufferSubData = glad_debug_impl_glCopyBufferSubData;
PFNGLCOPYTEXIMAGE1DPROC glad_glCopyTexImage1D;
void APIENTRY glad_debug_impl_glCopyTexImage1D(GLenum arg0, GLint arg1, GLenum arg2, GLint arg3, GLint arg4, GLsizei arg5, GLint arg6) {    
    _pre_call_callback_gl("glCopyTexImage1D", (void*)glCopyTexImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glCopyTexImage1D(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glCopyTexImage1D", (void*)glCopyTexImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLCOPYTEXIMAGE1DPROC glad_debug_glCopyTexImage1D = glad_debug_impl_glCopyTexImage1D;
PFNGLCOPYTEXIMAGE2DPROC glad_glCopyTexImage2D;
void APIENTRY glad_debug_impl_glCopyTexImage2D(GLenum arg0, GLint arg1, GLenum arg2, GLint arg3, GLint arg4, GLsizei arg5, GLsizei arg6, GLint arg7) {    
    _pre_call_callback_gl("glCopyTexImage2D", (void*)glCopyTexImage2D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
     glad_glCopyTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    _post_call_callback_gl("glCopyTexImage2D", (void*)glCopyTexImage2D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    
}
PFNGLCOPYTEXIMAGE2DPROC glad_debug_glCopyTexImage2D = glad_debug_impl_glCopyTexImage2D;
PFNGLCOPYTEXSUBIMAGE1DPROC glad_glCopyTexSubImage1D;
void APIENTRY glad_debug_impl_glCopyTexSubImage1D(GLenum arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4, GLsizei arg5) {    
    _pre_call_callback_gl("glCopyTexSubImage1D", (void*)glCopyTexSubImage1D, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glCopyTexSubImage1D(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glCopyTexSubImage1D", (void*)glCopyTexSubImage1D, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLCOPYTEXSUBIMAGE1DPROC glad_debug_glCopyTexSubImage1D = glad_debug_impl_glCopyTexSubImage1D;
PFNGLCOPYTEXSUBIMAGE2DPROC glad_glCopyTexSubImage2D;
void APIENTRY glad_debug_impl_glCopyTexSubImage2D(GLenum arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4, GLint arg5, GLsizei arg6, GLsizei arg7) {    
    _pre_call_callback_gl("glCopyTexSubImage2D", (void*)glCopyTexSubImage2D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
     glad_glCopyTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    _post_call_callback_gl("glCopyTexSubImage2D", (void*)glCopyTexSubImage2D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    
}
PFNGLCOPYTEXSUBIMAGE2DPROC glad_debug_glCopyTexSubImage2D = glad_debug_impl_glCopyTexSubImage2D;
PFNGLCOPYTEXSUBIMAGE3DPROC glad_glCopyTexSubImage3D;
void APIENTRY glad_debug_impl_glCopyTexSubImage3D(GLenum arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4, GLint arg5, GLint arg6, GLsizei arg7, GLsizei arg8) {    
    _pre_call_callback_gl("glCopyTexSubImage3D", (void*)glCopyTexSubImage3D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
     glad_glCopyTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    _post_call_callback_gl("glCopyTexSubImage3D", (void*)glCopyTexSubImage3D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    
}
PFNGLCOPYTEXSUBIMAGE3DPROC glad_debug_glCopyTexSubImage3D = glad_debug_impl_glCopyTexSubImage3D;
PFNGLCREATEPROGRAMPROC glad_glCreateProgram;
GLuint APIENTRY glad_debug_impl_glCreateProgram(void) {    
    GLuint ret;
    _pre_call_callback_gl("glCreateProgram", (void*)glCreateProgram, 0);
    ret =  glad_glCreateProgram();
    _post_call_callback_gl("glCreateProgram", (void*)glCreateProgram, 0);
    return ret;
}
PFNGLCREATEPROGRAMPROC glad_debug_glCreateProgram = glad_debug_impl_glCreateProgram;
PFNGLCREATESHADERPROC glad_glCreateShader;
GLuint APIENTRY glad_debug_impl_glCreateShader(GLenum arg0) {    
    GLuint ret;
    _pre_call_callback_gl("glCreateShader", (void*)glCreateShader, 1, arg0);
    ret =  glad_glCreateShader(arg0);
    _post_call_callback_gl("glCreateShader", (void*)glCreateShader, 1, arg0);
    return ret;
}
PFNGLCREATESHADERPROC glad_debug_glCreateShader = glad_debug_impl_glCreateShader;
PFNGLCULLFACEPROC glad_glCullFace;
void APIENTRY glad_debug_impl_glCullFace(GLenum arg0) {    
    _pre_call_callback_gl("glCullFace", (void*)glCullFace, 1, arg0);
     glad_glCullFace(arg0);
    _post_call_callback_gl("glCullFace", (void*)glCullFace, 1, arg0);
    
}
PFNGLCULLFACEPROC glad_debug_glCullFace = glad_debug_impl_glCullFace;
PFNGLDELETEBUFFERSPROC glad_glDeleteBuffers;
void APIENTRY glad_debug_impl_glDeleteBuffers(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteBuffers", (void*)glDeleteBuffers, 2, arg0, arg1);
     glad_glDeleteBuffers(arg0, arg1);
    _post_call_callback_gl("glDeleteBuffers", (void*)glDeleteBuffers, 2, arg0, arg1);
    
}
PFNGLDELETEBUFFERSPROC glad_debug_glDeleteBuffers = glad_debug_impl_glDeleteBuffers;
PFNGLDELETEFRAMEBUFFERSPROC glad_glDeleteFramebuffers;
void APIENTRY glad_debug_impl_glDeleteFramebuffers(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteFramebuffers", (void*)glDeleteFramebuffers, 2, arg0, arg1);
     glad_glDeleteFramebuffers(arg0, arg1);
    _post_call_callback_gl("glDeleteFramebuffers", (void*)glDeleteFramebuffers, 2, arg0, arg1);
    
}
PFNGLDELETEFRAMEBUFFERSPROC glad_debug_glDeleteFramebuffers = glad_debug_impl_glDeleteFramebuffers;
PFNGLDELETEPROGRAMPROC glad_glDeleteProgram;
void APIENTRY glad_debug_impl_glDeleteProgram(GLuint arg0) {    
    _pre_call_callback_gl("glDeleteProgram", (void*)glDeleteProgram, 1, arg0);
     glad_glDeleteProgram(arg0);
    _post_call_callback_gl("glDeleteProgram", (void*)glDeleteProgram, 1, arg0);
    
}
PFNGLDELETEPROGRAMPROC glad_debug_glDeleteProgram = glad_debug_impl_glDeleteProgram;
PFNGLDELETEQUERIESPROC glad_glDeleteQueries;
void APIENTRY glad_debug_impl_glDeleteQueries(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteQueries", (void*)glDeleteQueries, 2, arg0, arg1);
     glad_glDeleteQueries(arg0, arg1);
    _post_call_callback_gl("glDeleteQueries", (void*)glDeleteQueries, 2, arg0, arg1);
    
}
PFNGLDELETEQUERIESPROC glad_debug_glDeleteQueries = glad_debug_impl_glDeleteQueries;
PFNGLDELETERENDERBUFFERSPROC glad_glDeleteRenderbuffers;
void APIENTRY glad_debug_impl_glDeleteRenderbuffers(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteRenderbuffers", (void*)glDeleteRenderbuffers, 2, arg0, arg1);
     glad_glDeleteRenderbuffers(arg0, arg1);
    _post_call_callback_gl("glDeleteRenderbuffers", (void*)glDeleteRenderbuffers, 2, arg0, arg1);
    
}
PFNGLDELETERENDERBUFFERSPROC glad_debug_glDeleteRenderbuffers = glad_debug_impl_glDeleteRenderbuffers;
PFNGLDELETESAMPLERSPROC glad_glDeleteSamplers;
void APIENTRY glad_debug_impl_glDeleteSamplers(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteSamplers", (void*)glDeleteSamplers, 2, arg0, arg1);
     glad_glDeleteSamplers(arg0, arg1);
    _post_call_callback_gl("glDeleteSamplers", (void*)glDeleteSamplers, 2, arg0, arg1);
    
}
PFNGLDELETESAMPLERSPROC glad_debug_glDeleteSamplers = glad_debug_impl_glDeleteSamplers;
PFNGLDELETESHADERPROC glad_glDeleteShader;
void APIENTRY glad_debug_impl_glDeleteShader(GLuint arg0) {    
    _pre_call_callback_gl("glDeleteShader", (void*)glDeleteShader, 1, arg0);
     glad_glDeleteShader(arg0);
    _post_call_callback_gl("glDeleteShader", (void*)glDeleteShader, 1, arg0);
    
}
PFNGLDELETESHADERPROC glad_debug_glDeleteShader = glad_debug_impl_glDeleteShader;
PFNGLDELETESYNCPROC glad_glDeleteSync;
void APIENTRY glad_debug_impl_glDeleteSync(GLsync arg0) {    
    _pre_call_callback_gl("glDeleteSync", (void*)glDeleteSync, 1, arg0);
     glad_glDeleteSync(arg0);
    _post_call_callback_gl("glDeleteSync", (void*)glDeleteSync, 1, arg0);
    
}
PFNGLDELETESYNCPROC glad_debug_glDeleteSync = glad_debug_impl_glDeleteSync;
PFNGLDELETETEXTURESPROC glad_glDeleteTextures;
void APIENTRY glad_debug_impl_glDeleteTextures(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteTextures", (void*)glDeleteTextures, 2, arg0, arg1);
     glad_glDeleteTextures(arg0, arg1);
    _post_call_callback_gl("glDeleteTextures", (void*)glDeleteTextures, 2, arg0, arg1);
    
}
PFNGLDELETETEXTURESPROC glad_debug_glDeleteTextures = glad_debug_impl_glDeleteTextures;
PFNGLDELETETRANSFORMFEEDBACKSPROC glad_glDeleteTransformFeedbacks;
void APIENTRY glad_debug_impl_glDeleteTransformFeedbacks(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteTransformFeedbacks", (void*)glDeleteTransformFeedbacks, 2, arg0, arg1);
     glad_glDeleteTransformFeedbacks(arg0, arg1);
    _post_call_callback_gl("glDeleteTransformFeedbacks", (void*)glDeleteTransformFeedbacks, 2, arg0, arg1);
    
}
PFNGLDELETETRANSFORMFEEDBACKSPROC glad_debug_glDeleteTransformFeedbacks = glad_debug_impl_glDeleteTransformFeedbacks;
PFNGLDELETEVERTEXARRAYSPROC glad_glDeleteVertexArrays;
void APIENTRY glad_debug_impl_glDeleteVertexArrays(GLsizei arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glDeleteVertexArrays", (void*)glDeleteVertexArrays, 2, arg0, arg1);
     glad_glDeleteVertexArrays(arg0, arg1);
    _post_call_callback_gl("glDeleteVertexArrays", (void*)glDeleteVertexArrays, 2, arg0, arg1);
    
}
PFNGLDELETEVERTEXARRAYSPROC glad_debug_glDeleteVertexArrays = glad_debug_impl_glDeleteVertexArrays;
PFNGLDEPTHFUNCPROC glad_glDepthFunc;
void APIENTRY glad_debug_impl_glDepthFunc(GLenum arg0) {    
    _pre_call_callback_gl("glDepthFunc", (void*)glDepthFunc, 1, arg0);
     glad_glDepthFunc(arg0);
    _post_call_callback_gl("glDepthFunc", (void*)glDepthFunc, 1, arg0);
    
}
PFNGLDEPTHFUNCPROC glad_debug_glDepthFunc = glad_debug_impl_glDepthFunc;
PFNGLDEPTHMASKPROC glad_glDepthMask;
void APIENTRY glad_debug_impl_glDepthMask(GLboolean arg0) {    
    _pre_call_callback_gl("glDepthMask", (void*)glDepthMask, 1, arg0);
     glad_glDepthMask(arg0);
    _post_call_callback_gl("glDepthMask", (void*)glDepthMask, 1, arg0);
    
}
PFNGLDEPTHMASKPROC glad_debug_glDepthMask = glad_debug_impl_glDepthMask;
PFNGLDEPTHRANGEPROC glad_glDepthRange;
void APIENTRY glad_debug_impl_glDepthRange(GLdouble arg0, GLdouble arg1) {    
    _pre_call_callback_gl("glDepthRange", (void*)glDepthRange, 2, arg0, arg1);
     glad_glDepthRange(arg0, arg1);
    _post_call_callback_gl("glDepthRange", (void*)glDepthRange, 2, arg0, arg1);
    
}
PFNGLDEPTHRANGEPROC glad_debug_glDepthRange = glad_debug_impl_glDepthRange;
PFNGLDEPTHRANGEFPROC glad_glDepthRangef;
void APIENTRY glad_debug_impl_glDepthRangef(GLfloat arg0, GLfloat arg1) {    
    _pre_call_callback_gl("glDepthRangef", (void*)glDepthRangef, 2, arg0, arg1);
     glad_glDepthRangef(arg0, arg1);
    _post_call_callback_gl("glDepthRangef", (void*)glDepthRangef, 2, arg0, arg1);
    
}
PFNGLDEPTHRANGEFPROC glad_debug_glDepthRangef = glad_debug_impl_glDepthRangef;
PFNGLDETACHSHADERPROC glad_glDetachShader;
void APIENTRY glad_debug_impl_glDetachShader(GLuint arg0, GLuint arg1) {    
    _pre_call_callback_gl("glDetachShader", (void*)glDetachShader, 2, arg0, arg1);
     glad_glDetachShader(arg0, arg1);
    _post_call_callback_gl("glDetachShader", (void*)glDetachShader, 2, arg0, arg1);
    
}
PFNGLDETACHSHADERPROC glad_debug_glDetachShader = glad_debug_impl_glDetachShader;
PFNGLDISABLEPROC glad_glDisable;
void APIENTRY glad_debug_impl_glDisable(GLenum arg0) {    
    _pre_call_callback_gl("glDisable", (void*)glDisable, 1, arg0);
     glad_glDisable(arg0);
    _post_call_callback_gl("glDisable", (void*)glDisable, 1, arg0);
    
}
PFNGLDISABLEPROC glad_debug_glDisable = glad_debug_impl_glDisable;
PFNGLDISABLEVERTEXATTRIBARRAYPROC glad_glDisableVertexAttribArray;
void APIENTRY glad_debug_impl_glDisableVertexAttribArray(GLuint arg0) {    
    _pre_call_callback_gl("glDisableVertexAttribArray", (void*)glDisableVertexAttribArray, 1, arg0);
     glad_glDisableVertexAttribArray(arg0);
    _post_call_callback_gl("glDisableVertexAttribArray", (void*)glDisableVertexAttribArray, 1, arg0);
    
}
PFNGLDISABLEVERTEXATTRIBARRAYPROC glad_debug_glDisableVertexAttribArray = glad_debug_impl_glDisableVertexAttribArray;
PFNGLDISABLEIPROC glad_glDisablei;
void APIENTRY glad_debug_impl_glDisablei(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glDisablei", (void*)glDisablei, 2, arg0, arg1);
     glad_glDisablei(arg0, arg1);
    _post_call_callback_gl("glDisablei", (void*)glDisablei, 2, arg0, arg1);
    
}
PFNGLDISABLEIPROC glad_debug_glDisablei = glad_debug_impl_glDisablei;
PFNGLDRAWARRAYSPROC glad_glDrawArrays;
void APIENTRY glad_debug_impl_glDrawArrays(GLenum arg0, GLint arg1, GLsizei arg2) {    
    _pre_call_callback_gl("glDrawArrays", (void*)glDrawArrays, 3, arg0, arg1, arg2);
     glad_glDrawArrays(arg0, arg1, arg2);
    _post_call_callback_gl("glDrawArrays", (void*)glDrawArrays, 3, arg0, arg1, arg2);
    
}
PFNGLDRAWARRAYSPROC glad_debug_glDrawArrays = glad_debug_impl_glDrawArrays;
PFNGLDRAWARRAYSINSTANCEDPROC glad_glDrawArraysInstanced;
void APIENTRY glad_debug_impl_glDrawArraysInstanced(GLenum arg0, GLint arg1, GLsizei arg2, GLsizei arg3) {    
    _pre_call_callback_gl("glDrawArraysInstanced", (void*)glDrawArraysInstanced, 4, arg0, arg1, arg2, arg3);
     glad_glDrawArraysInstanced(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glDrawArraysInstanced", (void*)glDrawArraysInstanced, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLDRAWARRAYSINSTANCEDPROC glad_debug_glDrawArraysInstanced = glad_debug_impl_glDrawArraysInstanced;
PFNGLDRAWBUFFERPROC glad_glDrawBuffer;
void APIENTRY glad_debug_impl_glDrawBuffer(GLenum arg0) {    
    _pre_call_callback_gl("glDrawBuffer", (void*)glDrawBuffer, 1, arg0);
     glad_glDrawBuffer(arg0);
    _post_call_callback_gl("glDrawBuffer", (void*)glDrawBuffer, 1, arg0);
    
}
PFNGLDRAWBUFFERPROC glad_debug_glDrawBuffer = glad_debug_impl_glDrawBuffer;
PFNGLDRAWBUFFERSPROC glad_glDrawBuffers;
void APIENTRY glad_debug_impl_glDrawBuffers(GLsizei arg0, const GLenum * arg1) {    
    _pre_call_callback_gl("glDrawBuffers", (void*)glDrawBuffers, 2, arg0, arg1);
     glad_glDrawBuffers(arg0, arg1);
    _post_call_callback_gl("glDrawBuffers", (void*)glDrawBuffers, 2, arg0, arg1);
    
}
PFNGLDRAWBUFFERSPROC glad_debug_glDrawBuffers = glad_debug_impl_glDrawBuffers;
PFNGLDRAWELEMENTSPROC glad_glDrawElements;
void APIENTRY glad_debug_impl_glDrawElements(GLenum arg0, GLsizei arg1, GLenum arg2, const void * arg3) {    
    _pre_call_callback_gl("glDrawElements", (void*)glDrawElements, 4, arg0, arg1, arg2, arg3);
     glad_glDrawElements(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glDrawElements", (void*)glDrawElements, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLDRAWELEMENTSPROC glad_debug_glDrawElements = glad_debug_impl_glDrawElements;
PFNGLDRAWELEMENTSBASEVERTEXPROC glad_glDrawElementsBaseVertex;
void APIENTRY glad_debug_impl_glDrawElementsBaseVertex(GLenum arg0, GLsizei arg1, GLenum arg2, const void * arg3, GLint arg4) {    
    _pre_call_callback_gl("glDrawElementsBaseVertex", (void*)glDrawElementsBaseVertex, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glDrawElementsBaseVertex(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glDrawElementsBaseVertex", (void*)glDrawElementsBaseVertex, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLDRAWELEMENTSBASEVERTEXPROC glad_debug_glDrawElementsBaseVertex = glad_debug_impl_glDrawElementsBaseVertex;
PFNGLDRAWELEMENTSINSTANCEDPROC glad_glDrawElementsInstanced;
void APIENTRY glad_debug_impl_glDrawElementsInstanced(GLenum arg0, GLsizei arg1, GLenum arg2, const void * arg3, GLsizei arg4) {    
    _pre_call_callback_gl("glDrawElementsInstanced", (void*)glDrawElementsInstanced, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glDrawElementsInstanced(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glDrawElementsInstanced", (void*)glDrawElementsInstanced, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLDRAWELEMENTSINSTANCEDPROC glad_debug_glDrawElementsInstanced = glad_debug_impl_glDrawElementsInstanced;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC glad_glDrawElementsInstancedBaseVertex;
void APIENTRY glad_debug_impl_glDrawElementsInstancedBaseVertex(GLenum arg0, GLsizei arg1, GLenum arg2, const void * arg3, GLsizei arg4, GLint arg5) {    
    _pre_call_callback_gl("glDrawElementsInstancedBaseVertex", (void*)glDrawElementsInstancedBaseVertex, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glDrawElementsInstancedBaseVertex(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glDrawElementsInstancedBaseVertex", (void*)glDrawElementsInstancedBaseVertex, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC glad_debug_glDrawElementsInstancedBaseVertex = glad_debug_impl_glDrawElementsInstancedBaseVertex;
PFNGLDRAWRANGEELEMENTSPROC glad_glDrawRangeElements;
void APIENTRY glad_debug_impl_glDrawRangeElements(GLenum arg0, GLuint arg1, GLuint arg2, GLsizei arg3, GLenum arg4, const void * arg5) {    
    _pre_call_callback_gl("glDrawRangeElements", (void*)glDrawRangeElements, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glDrawRangeElements(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glDrawRangeElements", (void*)glDrawRangeElements, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLDRAWRANGEELEMENTSPROC glad_debug_glDrawRangeElements = glad_debug_impl_glDrawRangeElements;
PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC glad_glDrawRangeElementsBaseVertex;
void APIENTRY glad_debug_impl_glDrawRangeElementsBaseVertex(GLenum arg0, GLuint arg1, GLuint arg2, GLsizei arg3, GLenum arg4, const void * arg5, GLint arg6) {    
    _pre_call_callback_gl("glDrawRangeElementsBaseVertex", (void*)glDrawRangeElementsBaseVertex, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glDrawRangeElementsBaseVertex(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glDrawRangeElementsBaseVertex", (void*)glDrawRangeElementsBaseVertex, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC glad_debug_glDrawRangeElementsBaseVertex = glad_debug_impl_glDrawRangeElementsBaseVertex;
PFNGLENABLEPROC glad_glEnable;
void APIENTRY glad_debug_impl_glEnable(GLenum arg0) {    
    _pre_call_callback_gl("glEnable", (void*)glEnable, 1, arg0);
     glad_glEnable(arg0);
    _post_call_callback_gl("glEnable", (void*)glEnable, 1, arg0);
    
}
PFNGLENABLEPROC glad_debug_glEnable = glad_debug_impl_glEnable;
PFNGLENABLEVERTEXATTRIBARRAYPROC glad_glEnableVertexAttribArray;
void APIENTRY glad_debug_impl_glEnableVertexAttribArray(GLuint arg0) {    
    _pre_call_callback_gl("glEnableVertexAttribArray", (void*)glEnableVertexAttribArray, 1, arg0);
     glad_glEnableVertexAttribArray(arg0);
    _post_call_callback_gl("glEnableVertexAttribArray", (void*)glEnableVertexAttribArray, 1, arg0);
    
}
PFNGLENABLEVERTEXATTRIBARRAYPROC glad_debug_glEnableVertexAttribArray = glad_debug_impl_glEnableVertexAttribArray;
PFNGLENABLEIPROC glad_glEnablei;
void APIENTRY glad_debug_impl_glEnablei(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glEnablei", (void*)glEnablei, 2, arg0, arg1);
     glad_glEnablei(arg0, arg1);
    _post_call_callback_gl("glEnablei", (void*)glEnablei, 2, arg0, arg1);
    
}
PFNGLENABLEIPROC glad_debug_glEnablei = glad_debug_impl_glEnablei;
PFNGLENDCONDITIONALRENDERPROC glad_glEndConditionalRender;
void APIENTRY glad_debug_impl_glEndConditionalRender(void) {    
    _pre_call_callback_gl("glEndConditionalRender", (void*)glEndConditionalRender, 0);
     glad_glEndConditionalRender();
    _post_call_callback_gl("glEndConditionalRender", (void*)glEndConditionalRender, 0);
    
}
PFNGLENDCONDITIONALRENDERPROC glad_debug_glEndConditionalRender = glad_debug_impl_glEndConditionalRender;
PFNGLENDQUERYPROC glad_glEndQuery;
void APIENTRY glad_debug_impl_glEndQuery(GLenum arg0) {    
    _pre_call_callback_gl("glEndQuery", (void*)glEndQuery, 1, arg0);
     glad_glEndQuery(arg0);
    _post_call_callback_gl("glEndQuery", (void*)glEndQuery, 1, arg0);
    
}
PFNGLENDQUERYPROC glad_debug_glEndQuery = glad_debug_impl_glEndQuery;
PFNGLENDTRANSFORMFEEDBACKPROC glad_glEndTransformFeedback;
void APIENTRY glad_debug_impl_glEndTransformFeedback(void) {    
    _pre_call_callback_gl("glEndTransformFeedback", (void*)glEndTransformFeedback, 0);
     glad_glEndTransformFeedback();
    _post_call_callback_gl("glEndTransformFeedback", (void*)glEndTransformFeedback, 0);
    
}
PFNGLENDTRANSFORMFEEDBACKPROC glad_debug_glEndTransformFeedback = glad_debug_impl_glEndTransformFeedback;
PFNGLFENCESYNCPROC glad_glFenceSync;
GLsync APIENTRY glad_debug_impl_glFenceSync(GLenum arg0, GLbitfield arg1) {    
    GLsync ret;
    _pre_call_callback_gl("glFenceSync", (void*)glFenceSync, 2, arg0, arg1);
    ret =  glad_glFenceSync(arg0, arg1);
    _post_call_callback_gl("glFenceSync", (void*)glFenceSync, 2, arg0, arg1);
    return ret;
}
PFNGLFENCESYNCPROC glad_debug_glFenceSync = glad_debug_impl_glFenceSync;
PFNGLFINISHPROC glad_glFinish;
void APIENTRY glad_debug_impl_glFinish(void) {    
    _pre_call_callback_gl("glFinish", (void*)glFinish, 0);
     glad_glFinish();
    _post_call_callback_gl("glFinish", (void*)glFinish, 0);
    
}
PFNGLFINISHPROC glad_debug_glFinish = glad_debug_impl_glFinish;
PFNGLFLUSHPROC glad_glFlush;
void APIENTRY glad_debug_impl_glFlush(void) {    
    _pre_call_callback_gl("glFlush", (void*)glFlush, 0);
     glad_glFlush();
    _post_call_callback_gl("glFlush", (void*)glFlush, 0);
    
}
PFNGLFLUSHPROC glad_debug_glFlush = glad_debug_impl_glFlush;
PFNGLFLUSHMAPPEDBUFFERRANGEPROC glad_glFlushMappedBufferRange;
void APIENTRY glad_debug_impl_glFlushMappedBufferRange(GLenum arg0, GLintptr arg1, GLsizeiptr arg2) {    
    _pre_call_callback_gl("glFlushMappedBufferRange", (void*)glFlushMappedBufferRange, 3, arg0, arg1, arg2);
     glad_glFlushMappedBufferRange(arg0, arg1, arg2);
    _post_call_callback_gl("glFlushMappedBufferRange", (void*)glFlushMappedBufferRange, 3, arg0, arg1, arg2);
    
}
PFNGLFLUSHMAPPEDBUFFERRANGEPROC glad_debug_glFlushMappedBufferRange = glad_debug_impl_glFlushMappedBufferRange;
PFNGLFRAMEBUFFERRENDERBUFFERPROC glad_glFramebufferRenderbuffer;
void APIENTRY glad_debug_impl_glFramebufferRenderbuffer(GLenum arg0, GLenum arg1, GLenum arg2, GLuint arg3) {    
    _pre_call_callback_gl("glFramebufferRenderbuffer", (void*)glFramebufferRenderbuffer, 4, arg0, arg1, arg2, arg3);
     glad_glFramebufferRenderbuffer(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glFramebufferRenderbuffer", (void*)glFramebufferRenderbuffer, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLFRAMEBUFFERRENDERBUFFERPROC glad_debug_glFramebufferRenderbuffer = glad_debug_impl_glFramebufferRenderbuffer;
PFNGLFRAMEBUFFERTEXTUREPROC glad_glFramebufferTexture;
void APIENTRY glad_debug_impl_glFramebufferTexture(GLenum arg0, GLenum arg1, GLuint arg2, GLint arg3) {    
    _pre_call_callback_gl("glFramebufferTexture", (void*)glFramebufferTexture, 4, arg0, arg1, arg2, arg3);
     glad_glFramebufferTexture(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glFramebufferTexture", (void*)glFramebufferTexture, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLFRAMEBUFFERTEXTUREPROC glad_debug_glFramebufferTexture = glad_debug_impl_glFramebufferTexture;
PFNGLFRAMEBUFFERTEXTURE1DPROC glad_glFramebufferTexture1D;
void APIENTRY glad_debug_impl_glFramebufferTexture1D(GLenum arg0, GLenum arg1, GLenum arg2, GLuint arg3, GLint arg4) {    
    _pre_call_callback_gl("glFramebufferTexture1D", (void*)glFramebufferTexture1D, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glFramebufferTexture1D(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glFramebufferTexture1D", (void*)glFramebufferTexture1D, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLFRAMEBUFFERTEXTURE1DPROC glad_debug_glFramebufferTexture1D = glad_debug_impl_glFramebufferTexture1D;
PFNGLFRAMEBUFFERTEXTURE2DPROC glad_glFramebufferTexture2D;
void APIENTRY glad_debug_impl_glFramebufferTexture2D(GLenum arg0, GLenum arg1, GLenum arg2, GLuint arg3, GLint arg4) {    
    _pre_call_callback_gl("glFramebufferTexture2D", (void*)glFramebufferTexture2D, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glFramebufferTexture2D(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glFramebufferTexture2D", (void*)glFramebufferTexture2D, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLFRAMEBUFFERTEXTURE2DPROC glad_debug_glFramebufferTexture2D = glad_debug_impl_glFramebufferTexture2D;
PFNGLFRAMEBUFFERTEXTURE3DPROC glad_glFramebufferTexture3D;
void APIENTRY glad_debug_impl_glFramebufferTexture3D(GLenum arg0, GLenum arg1, GLenum arg2, GLuint arg3, GLint arg4, GLint arg5) {    
    _pre_call_callback_gl("glFramebufferTexture3D", (void*)glFramebufferTexture3D, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glFramebufferTexture3D(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glFramebufferTexture3D", (void*)glFramebufferTexture3D, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLFRAMEBUFFERTEXTURE3DPROC glad_debug_glFramebufferTexture3D = glad_debug_impl_glFramebufferTexture3D;
PFNGLFRAMEBUFFERTEXTURELAYERPROC glad_glFramebufferTextureLayer;
void APIENTRY glad_debug_impl_glFramebufferTextureLayer(GLenum arg0, GLenum arg1, GLuint arg2, GLint arg3, GLint arg4) {    
    _pre_call_callback_gl("glFramebufferTextureLayer", (void*)glFramebufferTextureLayer, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glFramebufferTextureLayer(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glFramebufferTextureLayer", (void*)glFramebufferTextureLayer, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLFRAMEBUFFERTEXTURELAYERPROC glad_debug_glFramebufferTextureLayer = glad_debug_impl_glFramebufferTextureLayer;
PFNGLFRONTFACEPROC glad_glFrontFace;
void APIENTRY glad_debug_impl_glFrontFace(GLenum arg0) {    
    _pre_call_callback_gl("glFrontFace", (void*)glFrontFace, 1, arg0);
     glad_glFrontFace(arg0);
    _post_call_callback_gl("glFrontFace", (void*)glFrontFace, 1, arg0);
    
}
PFNGLFRONTFACEPROC glad_debug_glFrontFace = glad_debug_impl_glFrontFace;
PFNGLGENBUFFERSPROC glad_glGenBuffers;
void APIENTRY glad_debug_impl_glGenBuffers(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenBuffers", (void*)glGenBuffers, 2, arg0, arg1);
     glad_glGenBuffers(arg0, arg1);
    _post_call_callback_gl("glGenBuffers", (void*)glGenBuffers, 2, arg0, arg1);
    
}
PFNGLGENBUFFERSPROC glad_debug_glGenBuffers = glad_debug_impl_glGenBuffers;
PFNGLGENFRAMEBUFFERSPROC glad_glGenFramebuffers;
void APIENTRY glad_debug_impl_glGenFramebuffers(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenFramebuffers", (void*)glGenFramebuffers, 2, arg0, arg1);
     glad_glGenFramebuffers(arg0, arg1);
    _post_call_callback_gl("glGenFramebuffers", (void*)glGenFramebuffers, 2, arg0, arg1);
    
}
PFNGLGENFRAMEBUFFERSPROC glad_debug_glGenFramebuffers = glad_debug_impl_glGenFramebuffers;
PFNGLGENQUERIESPROC glad_glGenQueries;
void APIENTRY glad_debug_impl_glGenQueries(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenQueries", (void*)glGenQueries, 2, arg0, arg1);
     glad_glGenQueries(arg0, arg1);
    _post_call_callback_gl("glGenQueries", (void*)glGenQueries, 2, arg0, arg1);
    
}
PFNGLGENQUERIESPROC glad_debug_glGenQueries = glad_debug_impl_glGenQueries;
PFNGLGENRENDERBUFFERSPROC glad_glGenRenderbuffers;
void APIENTRY glad_debug_impl_glGenRenderbuffers(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenRenderbuffers", (void*)glGenRenderbuffers, 2, arg0, arg1);
     glad_glGenRenderbuffers(arg0, arg1);
    _post_call_callback_gl("glGenRenderbuffers", (void*)glGenRenderbuffers, 2, arg0, arg1);
    
}
PFNGLGENRENDERBUFFERSPROC glad_debug_glGenRenderbuffers = glad_debug_impl_glGenRenderbuffers;
PFNGLGENSAMPLERSPROC glad_glGenSamplers;
void APIENTRY glad_debug_impl_glGenSamplers(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenSamplers", (void*)glGenSamplers, 2, arg0, arg1);
     glad_glGenSamplers(arg0, arg1);
    _post_call_callback_gl("glGenSamplers", (void*)glGenSamplers, 2, arg0, arg1);
    
}
PFNGLGENSAMPLERSPROC glad_debug_glGenSamplers = glad_debug_impl_glGenSamplers;
PFNGLGENTEXTURESPROC glad_glGenTextures;
void APIENTRY glad_debug_impl_glGenTextures(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenTextures", (void*)glGenTextures, 2, arg0, arg1);
     glad_glGenTextures(arg0, arg1);
    _post_call_callback_gl("glGenTextures", (void*)glGenTextures, 2, arg0, arg1);
    
}
PFNGLGENTEXTURESPROC glad_debug_glGenTextures = glad_debug_impl_glGenTextures;
PFNGLGENTRANSFORMFEEDBACKSPROC glad_glGenTransformFeedbacks;
void APIENTRY glad_debug_impl_glGenTransformFeedbacks(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenTransformFeedbacks", (void*)glGenTransformFeedbacks, 2, arg0, arg1);
     glad_glGenTransformFeedbacks(arg0, arg1);
    _post_call_callback_gl("glGenTransformFeedbacks", (void*)glGenTransformFeedbacks, 2, arg0, arg1);
    
}
PFNGLGENTRANSFORMFEEDBACKSPROC glad_debug_glGenTransformFeedbacks = glad_debug_impl_glGenTransformFeedbacks;
PFNGLGENVERTEXARRAYSPROC glad_glGenVertexArrays;
void APIENTRY glad_debug_impl_glGenVertexArrays(GLsizei arg0, GLuint * arg1) {    
    _pre_call_callback_gl("glGenVertexArrays", (void*)glGenVertexArrays, 2, arg0, arg1);
     glad_glGenVertexArrays(arg0, arg1);
    _post_call_callback_gl("glGenVertexArrays", (void*)glGenVertexArrays, 2, arg0, arg1);
    
}
PFNGLGENVERTEXARRAYSPROC glad_debug_glGenVertexArrays = glad_debug_impl_glGenVertexArrays;
PFNGLGENERATEMIPMAPPROC glad_glGenerateMipmap;
void APIENTRY glad_debug_impl_glGenerateMipmap(GLenum arg0) {    
    _pre_call_callback_gl("glGenerateMipmap", (void*)glGenerateMipmap, 1, arg0);
     glad_glGenerateMipmap(arg0);
    _post_call_callback_gl("glGenerateMipmap", (void*)glGenerateMipmap, 1, arg0);
    
}
PFNGLGENERATEMIPMAPPROC glad_debug_glGenerateMipmap = glad_debug_impl_glGenerateMipmap;
PFNGLGETACTIVEATTRIBPROC glad_glGetActiveAttrib;
void APIENTRY glad_debug_impl_glGetActiveAttrib(GLuint arg0, GLuint arg1, GLsizei arg2, GLsizei * arg3, GLint * arg4, GLenum * arg5, GLchar * arg6) {    
    _pre_call_callback_gl("glGetActiveAttrib", (void*)glGetActiveAttrib, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glGetActiveAttrib(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glGetActiveAttrib", (void*)glGetActiveAttrib, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLGETACTIVEATTRIBPROC glad_debug_glGetActiveAttrib = glad_debug_impl_glGetActiveAttrib;
PFNGLGETACTIVEUNIFORMPROC glad_glGetActiveUniform;
void APIENTRY glad_debug_impl_glGetActiveUniform(GLuint arg0, GLuint arg1, GLsizei arg2, GLsizei * arg3, GLint * arg4, GLenum * arg5, GLchar * arg6) {    
    _pre_call_callback_gl("glGetActiveUniform", (void*)glGetActiveUniform, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glGetActiveUniform(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glGetActiveUniform", (void*)glGetActiveUniform, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLGETACTIVEUNIFORMPROC glad_debug_glGetActiveUniform = glad_debug_impl_glGetActiveUniform;
PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC glad_glGetActiveUniformBlockName;
void APIENTRY glad_debug_impl_glGetActiveUniformBlockName(GLuint arg0, GLuint arg1, GLsizei arg2, GLsizei * arg3, GLchar * arg4) {    
    _pre_call_callback_gl("glGetActiveUniformBlockName", (void*)glGetActiveUniformBlockName, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glGetActiveUniformBlockName(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glGetActiveUniformBlockName", (void*)glGetActiveUniformBlockName, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC glad_debug_glGetActiveUniformBlockName = glad_debug_impl_glGetActiveUniformBlockName;
PFNGLGETACTIVEUNIFORMBLOCKIVPROC glad_glGetActiveUniformBlockiv;
void APIENTRY glad_debug_impl_glGetActiveUniformBlockiv(GLuint arg0, GLuint arg1, GLenum arg2, GLint * arg3) {    
    _pre_call_callback_gl("glGetActiveUniformBlockiv", (void*)glGetActiveUniformBlockiv, 4, arg0, arg1, arg2, arg3);
     glad_glGetActiveUniformBlockiv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetActiveUniformBlockiv", (void*)glGetActiveUniformBlockiv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETACTIVEUNIFORMBLOCKIVPROC glad_debug_glGetActiveUniformBlockiv = glad_debug_impl_glGetActiveUniformBlockiv;
PFNGLGETACTIVEUNIFORMNAMEPROC glad_glGetActiveUniformName;
void APIENTRY glad_debug_impl_glGetActiveUniformName(GLuint arg0, GLuint arg1, GLsizei arg2, GLsizei * arg3, GLchar * arg4) {    
    _pre_call_callback_gl("glGetActiveUniformName", (void*)glGetActiveUniformName, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glGetActiveUniformName(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glGetActiveUniformName", (void*)glGetActiveUniformName, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLGETACTIVEUNIFORMNAMEPROC glad_debug_glGetActiveUniformName = glad_debug_impl_glGetActiveUniformName;
PFNGLGETACTIVEUNIFORMSIVPROC glad_glGetActiveUniformsiv;
void APIENTRY glad_debug_impl_glGetActiveUniformsiv(GLuint arg0, GLsizei arg1, const GLuint * arg2, GLenum arg3, GLint * arg4) {    
    _pre_call_callback_gl("glGetActiveUniformsiv", (void*)glGetActiveUniformsiv, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glGetActiveUniformsiv(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glGetActiveUniformsiv", (void*)glGetActiveUniformsiv, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLGETACTIVEUNIFORMSIVPROC glad_debug_glGetActiveUniformsiv = glad_debug_impl_glGetActiveUniformsiv;
PFNGLGETATTACHEDSHADERSPROC glad_glGetAttachedShaders;
void APIENTRY glad_debug_impl_glGetAttachedShaders(GLuint arg0, GLsizei arg1, GLsizei * arg2, GLuint * arg3) {    
    _pre_call_callback_gl("glGetAttachedShaders", (void*)glGetAttachedShaders, 4, arg0, arg1, arg2, arg3);
     glad_glGetAttachedShaders(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetAttachedShaders", (void*)glGetAttachedShaders, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETATTACHEDSHADERSPROC glad_debug_glGetAttachedShaders = glad_debug_impl_glGetAttachedShaders;
PFNGLGETATTRIBLOCATIONPROC glad_glGetAttribLocation;
GLint APIENTRY glad_debug_impl_glGetAttribLocation(GLuint arg0, const GLchar * arg1) {    
    GLint ret;
    _pre_call_callback_gl("glGetAttribLocation", (void*)glGetAttribLocation, 2, arg0, arg1);
    ret =  glad_glGetAttribLocation(arg0, arg1);
    _post_call_callback_gl("glGetAttribLocation", (void*)glGetAttribLocation, 2, arg0, arg1);
    return ret;
}
PFNGLGETATTRIBLOCATIONPROC glad_debug_glGetAttribLocation = glad_debug_impl_glGetAttribLocation;
PFNGLGETBOOLEANI_VPROC glad_glGetBooleani_v;
void APIENTRY glad_debug_impl_glGetBooleani_v(GLenum arg0, GLuint arg1, GLboolean * arg2) {    
    _pre_call_callback_gl("glGetBooleani_v", (void*)glGetBooleani_v, 3, arg0, arg1, arg2);
     glad_glGetBooleani_v(arg0, arg1, arg2);
    _post_call_callback_gl("glGetBooleani_v", (void*)glGetBooleani_v, 3, arg0, arg1, arg2);
    
}
PFNGLGETBOOLEANI_VPROC glad_debug_glGetBooleani_v = glad_debug_impl_glGetBooleani_v;
PFNGLGETBOOLEANVPROC glad_glGetBooleanv;
void APIENTRY glad_debug_impl_glGetBooleanv(GLenum arg0, GLboolean * arg1) {    
    _pre_call_callback_gl("glGetBooleanv", (void*)glGetBooleanv, 2, arg0, arg1);
     glad_glGetBooleanv(arg0, arg1);
    _post_call_callback_gl("glGetBooleanv", (void*)glGetBooleanv, 2, arg0, arg1);
    
}
PFNGLGETBOOLEANVPROC glad_debug_glGetBooleanv = glad_debug_impl_glGetBooleanv;
PFNGLGETBUFFERPARAMETERI64VPROC glad_glGetBufferParameteri64v;
void APIENTRY glad_debug_impl_glGetBufferParameteri64v(GLenum arg0, GLenum arg1, GLint64 * arg2) {    
    _pre_call_callback_gl("glGetBufferParameteri64v", (void*)glGetBufferParameteri64v, 3, arg0, arg1, arg2);
     glad_glGetBufferParameteri64v(arg0, arg1, arg2);
    _post_call_callback_gl("glGetBufferParameteri64v", (void*)glGetBufferParameteri64v, 3, arg0, arg1, arg2);
    
}
PFNGLGETBUFFERPARAMETERI64VPROC glad_debug_glGetBufferParameteri64v = glad_debug_impl_glGetBufferParameteri64v;
PFNGLGETBUFFERPARAMETERIVPROC glad_glGetBufferParameteriv;
void APIENTRY glad_debug_impl_glGetBufferParameteriv(GLenum arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetBufferParameteriv", (void*)glGetBufferParameteriv, 3, arg0, arg1, arg2);
     glad_glGetBufferParameteriv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetBufferParameteriv", (void*)glGetBufferParameteriv, 3, arg0, arg1, arg2);
    
}
PFNGLGETBUFFERPARAMETERIVPROC glad_debug_glGetBufferParameteriv = glad_debug_impl_glGetBufferParameteriv;
PFNGLGETBUFFERPOINTERVPROC glad_glGetBufferPointerv;
void APIENTRY glad_debug_impl_glGetBufferPointerv(GLenum arg0, GLenum arg1, void ** arg2) {    
    _pre_call_callback_gl("glGetBufferPointerv", (void*)glGetBufferPointerv, 3, arg0, arg1, arg2);
     glad_glGetBufferPointerv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetBufferPointerv", (void*)glGetBufferPointerv, 3, arg0, arg1, arg2);
    
}
PFNGLGETBUFFERPOINTERVPROC glad_debug_glGetBufferPointerv = glad_debug_impl_glGetBufferPointerv;
PFNGLGETBUFFERSUBDATAPROC glad_glGetBufferSubData;
void APIENTRY glad_debug_impl_glGetBufferSubData(GLenum arg0, GLintptr arg1, GLsizeiptr arg2, void * arg3) {    
    _pre_call_callback_gl("glGetBufferSubData", (void*)glGetBufferSubData, 4, arg0, arg1, arg2, arg3);
     glad_glGetBufferSubData(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetBufferSubData", (void*)glGetBufferSubData, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETBUFFERSUBDATAPROC glad_debug_glGetBufferSubData = glad_debug_impl_glGetBufferSubData;
PFNGLGETCOMPRESSEDTEXIMAGEPROC glad_glGetCompressedTexImage;
void APIENTRY glad_debug_impl_glGetCompressedTexImage(GLenum arg0, GLint arg1, void * arg2) {    
    _pre_call_callback_gl("glGetCompressedTexImage", (void*)glGetCompressedTexImage, 3, arg0, arg1, arg2);
     glad_glGetCompressedTexImage(arg0, arg1, arg2);
    _post_call_callback_gl("glGetCompressedTexImage", (void*)glGetCompressedTexImage, 3, arg0, arg1, arg2);
    
}
PFNGLGETCOMPRESSEDTEXIMAGEPROC glad_debug_glGetCompressedTexImage = glad_debug_impl_glGetCompressedTexImage;
PFNGLGETDOUBLEVPROC glad_glGetDoublev;
void APIENTRY glad_debug_impl_glGetDoublev(GLenum arg0, GLdouble * arg1) {    
    _pre_call_callback_gl("glGetDoublev", (void*)glGetDoublev, 2, arg0, arg1);
     glad_glGetDoublev(arg0, arg1);
    _post_call_callback_gl("glGetDoublev", (void*)glGetDoublev, 2, arg0, arg1);
    
}
PFNGLGETDOUBLEVPROC glad_debug_glGetDoublev = glad_debug_impl_glGetDoublev;
PFNGLGETERRORPROC glad_glGetError;
GLenum APIENTRY glad_debug_impl_glGetError(void) {    
    GLenum ret;
    _pre_call_callback_gl("glGetError", (void*)glGetError, 0);
    ret =  glad_glGetError();
    _post_call_callback_gl("glGetError", (void*)glGetError, 0);
    return ret;
}
PFNGLGETERRORPROC glad_debug_glGetError = glad_debug_impl_glGetError;
PFNGLGETFLOATVPROC glad_glGetFloatv;
void APIENTRY glad_debug_impl_glGetFloatv(GLenum arg0, GLfloat * arg1) {    
    _pre_call_callback_gl("glGetFloatv", (void*)glGetFloatv, 2, arg0, arg1);
     glad_glGetFloatv(arg0, arg1);
    _post_call_callback_gl("glGetFloatv", (void*)glGetFloatv, 2, arg0, arg1);
    
}
PFNGLGETFLOATVPROC glad_debug_glGetFloatv = glad_debug_impl_glGetFloatv;
PFNGLGETFRAGDATAINDEXPROC glad_glGetFragDataIndex;
GLint APIENTRY glad_debug_impl_glGetFragDataIndex(GLuint arg0, const GLchar * arg1) {    
    GLint ret;
    _pre_call_callback_gl("glGetFragDataIndex", (void*)glGetFragDataIndex, 2, arg0, arg1);
    ret =  glad_glGetFragDataIndex(arg0, arg1);
    _post_call_callback_gl("glGetFragDataIndex", (void*)glGetFragDataIndex, 2, arg0, arg1);
    return ret;
}
PFNGLGETFRAGDATAINDEXPROC glad_debug_glGetFragDataIndex = glad_debug_impl_glGetFragDataIndex;
PFNGLGETFRAGDATALOCATIONPROC glad_glGetFragDataLocation;
GLint APIENTRY glad_debug_impl_glGetFragDataLocation(GLuint arg0, const GLchar * arg1) {    
    GLint ret;
    _pre_call_callback_gl("glGetFragDataLocation", (void*)glGetFragDataLocation, 2, arg0, arg1);
    ret =  glad_glGetFragDataLocation(arg0, arg1);
    _post_call_callback_gl("glGetFragDataLocation", (void*)glGetFragDataLocation, 2, arg0, arg1);
    return ret;
}
PFNGLGETFRAGDATALOCATIONPROC glad_debug_glGetFragDataLocation = glad_debug_impl_glGetFragDataLocation;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC glad_glGetFramebufferAttachmentParameteriv;
void APIENTRY glad_debug_impl_glGetFramebufferAttachmentParameteriv(GLenum arg0, GLenum arg1, GLenum arg2, GLint * arg3) {    
    _pre_call_callback_gl("glGetFramebufferAttachmentParameteriv", (void*)glGetFramebufferAttachmentParameteriv, 4, arg0, arg1, arg2, arg3);
     glad_glGetFramebufferAttachmentParameteriv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetFramebufferAttachmentParameteriv", (void*)glGetFramebufferAttachmentParameteriv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC glad_debug_glGetFramebufferAttachmentParameteriv = glad_debug_impl_glGetFramebufferAttachmentParameteriv;
PFNGLGETINTEGER64I_VPROC glad_glGetInteger64i_v;
void APIENTRY glad_debug_impl_glGetInteger64i_v(GLenum arg0, GLuint arg1, GLint64 * arg2) {    
    _pre_call_callback_gl("glGetInteger64i_v", (void*)glGetInteger64i_v, 3, arg0, arg1, arg2);
     glad_glGetInteger64i_v(arg0, arg1, arg2);
    _post_call_callback_gl("glGetInteger64i_v", (void*)glGetInteger64i_v, 3, arg0, arg1, arg2);
    
}
PFNGLGETINTEGER64I_VPROC glad_debug_glGetInteger64i_v = glad_debug_impl_glGetInteger64i_v;
PFNGLGETINTEGER64VPROC glad_glGetInteger64v;
void APIENTRY glad_debug_impl_glGetInteger64v(GLenum arg0, GLint64 * arg1) {    
    _pre_call_callback_gl("glGetInteger64v", (void*)glGetInteger64v, 2, arg0, arg1);
     glad_glGetInteger64v(arg0, arg1);
    _post_call_callback_gl("glGetInteger64v", (void*)glGetInteger64v, 2, arg0, arg1);
    
}
PFNGLGETINTEGER64VPROC glad_debug_glGetInteger64v = glad_debug_impl_glGetInteger64v;
PFNGLGETINTEGERI_VPROC glad_glGetIntegeri_v;
void APIENTRY glad_debug_impl_glGetIntegeri_v(GLenum arg0, GLuint arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetIntegeri_v", (void*)glGetIntegeri_v, 3, arg0, arg1, arg2);
     glad_glGetIntegeri_v(arg0, arg1, arg2);
    _post_call_callback_gl("glGetIntegeri_v", (void*)glGetIntegeri_v, 3, arg0, arg1, arg2);
    
}
PFNGLGETINTEGERI_VPROC glad_debug_glGetIntegeri_v = glad_debug_impl_glGetIntegeri_v;
PFNGLGETINTEGERVPROC glad_glGetIntegerv;
void APIENTRY glad_debug_impl_glGetIntegerv(GLenum arg0, GLint * arg1) {    
    _pre_call_callback_gl("glGetIntegerv", (void*)glGetIntegerv, 2, arg0, arg1);
     glad_glGetIntegerv(arg0, arg1);
    _post_call_callback_gl("glGetIntegerv", (void*)glGetIntegerv, 2, arg0, arg1);
    
}
PFNGLGETINTEGERVPROC glad_debug_glGetIntegerv = glad_debug_impl_glGetIntegerv;
PFNGLGETINTERNALFORMATIVPROC glad_glGetInternalformativ;
void APIENTRY glad_debug_impl_glGetInternalformativ(GLenum arg0, GLenum arg1, GLenum arg2, GLsizei arg3, GLint * arg4) {    
    _pre_call_callback_gl("glGetInternalformativ", (void*)glGetInternalformativ, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glGetInternalformativ(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glGetInternalformativ", (void*)glGetInternalformativ, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLGETINTERNALFORMATIVPROC glad_debug_glGetInternalformativ = glad_debug_impl_glGetInternalformativ;
PFNGLGETMULTISAMPLEFVPROC glad_glGetMultisamplefv;
void APIENTRY glad_debug_impl_glGetMultisamplefv(GLenum arg0, GLuint arg1, GLfloat * arg2) {    
    _pre_call_callback_gl("glGetMultisamplefv", (void*)glGetMultisamplefv, 3, arg0, arg1, arg2);
     glad_glGetMultisamplefv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetMultisamplefv", (void*)glGetMultisamplefv, 3, arg0, arg1, arg2);
    
}
PFNGLGETMULTISAMPLEFVPROC glad_debug_glGetMultisamplefv = glad_debug_impl_glGetMultisamplefv;
PFNGLGETPROGRAMBINARYPROC glad_glGetProgramBinary;
void APIENTRY glad_debug_impl_glGetProgramBinary(GLuint arg0, GLsizei arg1, GLsizei * arg2, GLenum * arg3, void * arg4) {    
    _pre_call_callback_gl("glGetProgramBinary", (void*)glGetProgramBinary, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glGetProgramBinary(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glGetProgramBinary", (void*)glGetProgramBinary, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLGETPROGRAMBINARYPROC glad_debug_glGetProgramBinary = glad_debug_impl_glGetProgramBinary;
PFNGLGETPROGRAMINFOLOGPROC glad_glGetProgramInfoLog;
void APIENTRY glad_debug_impl_glGetProgramInfoLog(GLuint arg0, GLsizei arg1, GLsizei * arg2, GLchar * arg3) {    
    _pre_call_callback_gl("glGetProgramInfoLog", (void*)glGetProgramInfoLog, 4, arg0, arg1, arg2, arg3);
     glad_glGetProgramInfoLog(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetProgramInfoLog", (void*)glGetProgramInfoLog, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETPROGRAMINFOLOGPROC glad_debug_glGetProgramInfoLog = glad_debug_impl_glGetProgramInfoLog;
PFNGLGETPROGRAMIVPROC glad_glGetProgramiv;
void APIENTRY glad_debug_impl_glGetProgramiv(GLuint arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetProgramiv", (void*)glGetProgramiv, 3, arg0, arg1, arg2);
     glad_glGetProgramiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetProgramiv", (void*)glGetProgramiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETPROGRAMIVPROC glad_debug_glGetProgramiv = glad_debug_impl_glGetProgramiv;
PFNGLGETQUERYOBJECTI64VPROC glad_glGetQueryObjecti64v;
void APIENTRY glad_debug_impl_glGetQueryObjecti64v(GLuint arg0, GLenum arg1, GLint64 * arg2) {    
    _pre_call_callback_gl("glGetQueryObjecti64v", (void*)glGetQueryObjecti64v, 3, arg0, arg1, arg2);
     glad_glGetQueryObjecti64v(arg0, arg1, arg2);
    _post_call_callback_gl("glGetQueryObjecti64v", (void*)glGetQueryObjecti64v, 3, arg0, arg1, arg2);
    
}
PFNGLGETQUERYOBJECTI64VPROC glad_debug_glGetQueryObjecti64v = glad_debug_impl_glGetQueryObjecti64v;
PFNGLGETQUERYOBJECTIVPROC glad_glGetQueryObjectiv;
void APIENTRY glad_debug_impl_glGetQueryObjectiv(GLuint arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetQueryObjectiv", (void*)glGetQueryObjectiv, 3, arg0, arg1, arg2);
     glad_glGetQueryObjectiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetQueryObjectiv", (void*)glGetQueryObjectiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETQUERYOBJECTIVPROC glad_debug_glGetQueryObjectiv = glad_debug_impl_glGetQueryObjectiv;
PFNGLGETQUERYOBJECTUI64VPROC glad_glGetQueryObjectui64v;
void APIENTRY glad_debug_impl_glGetQueryObjectui64v(GLuint arg0, GLenum arg1, GLuint64 * arg2) {    
    _pre_call_callback_gl("glGetQueryObjectui64v", (void*)glGetQueryObjectui64v, 3, arg0, arg1, arg2);
     glad_glGetQueryObjectui64v(arg0, arg1, arg2);
    _post_call_callback_gl("glGetQueryObjectui64v", (void*)glGetQueryObjectui64v, 3, arg0, arg1, arg2);
    
}
PFNGLGETQUERYOBJECTUI64VPROC glad_debug_glGetQueryObjectui64v = glad_debug_impl_glGetQueryObjectui64v;
PFNGLGETQUERYOBJECTUIVPROC glad_glGetQueryObjectuiv;
void APIENTRY glad_debug_impl_glGetQueryObjectuiv(GLuint arg0, GLenum arg1, GLuint * arg2) {    
    _pre_call_callback_gl("glGetQueryObjectuiv", (void*)glGetQueryObjectuiv, 3, arg0, arg1, arg2);
     glad_glGetQueryObjectuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetQueryObjectuiv", (void*)glGetQueryObjectuiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETQUERYOBJECTUIVPROC glad_debug_glGetQueryObjectuiv = glad_debug_impl_glGetQueryObjectuiv;
PFNGLGETQUERYIVPROC glad_glGetQueryiv;
void APIENTRY glad_debug_impl_glGetQueryiv(GLenum arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetQueryiv", (void*)glGetQueryiv, 3, arg0, arg1, arg2);
     glad_glGetQueryiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetQueryiv", (void*)glGetQueryiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETQUERYIVPROC glad_debug_glGetQueryiv = glad_debug_impl_glGetQueryiv;
PFNGLGETRENDERBUFFERPARAMETERIVPROC glad_glGetRenderbufferParameteriv;
void APIENTRY glad_debug_impl_glGetRenderbufferParameteriv(GLenum arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetRenderbufferParameteriv", (void*)glGetRenderbufferParameteriv, 3, arg0, arg1, arg2);
     glad_glGetRenderbufferParameteriv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetRenderbufferParameteriv", (void*)glGetRenderbufferParameteriv, 3, arg0, arg1, arg2);
    
}
PFNGLGETRENDERBUFFERPARAMETERIVPROC glad_debug_glGetRenderbufferParameteriv = glad_debug_impl_glGetRenderbufferParameteriv;
PFNGLGETSAMPLERPARAMETERIIVPROC glad_glGetSamplerParameterIiv;
void APIENTRY glad_debug_impl_glGetSamplerParameterIiv(GLuint arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetSamplerParameterIiv", (void*)glGetSamplerParameterIiv, 3, arg0, arg1, arg2);
     glad_glGetSamplerParameterIiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetSamplerParameterIiv", (void*)glGetSamplerParameterIiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETSAMPLERPARAMETERIIVPROC glad_debug_glGetSamplerParameterIiv = glad_debug_impl_glGetSamplerParameterIiv;
PFNGLGETSAMPLERPARAMETERIUIVPROC glad_glGetSamplerParameterIuiv;
void APIENTRY glad_debug_impl_glGetSamplerParameterIuiv(GLuint arg0, GLenum arg1, GLuint * arg2) {    
    _pre_call_callback_gl("glGetSamplerParameterIuiv", (void*)glGetSamplerParameterIuiv, 3, arg0, arg1, arg2);
     glad_glGetSamplerParameterIuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetSamplerParameterIuiv", (void*)glGetSamplerParameterIuiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETSAMPLERPARAMETERIUIVPROC glad_debug_glGetSamplerParameterIuiv = glad_debug_impl_glGetSamplerParameterIuiv;
PFNGLGETSAMPLERPARAMETERFVPROC glad_glGetSamplerParameterfv;
void APIENTRY glad_debug_impl_glGetSamplerParameterfv(GLuint arg0, GLenum arg1, GLfloat * arg2) {    
    _pre_call_callback_gl("glGetSamplerParameterfv", (void*)glGetSamplerParameterfv, 3, arg0, arg1, arg2);
     glad_glGetSamplerParameterfv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetSamplerParameterfv", (void*)glGetSamplerParameterfv, 3, arg0, arg1, arg2);
    
}
PFNGLGETSAMPLERPARAMETERFVPROC glad_debug_glGetSamplerParameterfv = glad_debug_impl_glGetSamplerParameterfv;
PFNGLGETSAMPLERPARAMETERIVPROC glad_glGetSamplerParameteriv;
void APIENTRY glad_debug_impl_glGetSamplerParameteriv(GLuint arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetSamplerParameteriv", (void*)glGetSamplerParameteriv, 3, arg0, arg1, arg2);
     glad_glGetSamplerParameteriv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetSamplerParameteriv", (void*)glGetSamplerParameteriv, 3, arg0, arg1, arg2);
    
}
PFNGLGETSAMPLERPARAMETERIVPROC glad_debug_glGetSamplerParameteriv = glad_debug_impl_glGetSamplerParameteriv;
PFNGLGETSHADERINFOLOGPROC glad_glGetShaderInfoLog;
void APIENTRY glad_debug_impl_glGetShaderInfoLog(GLuint arg0, GLsizei arg1, GLsizei * arg2, GLchar * arg3) {    
    _pre_call_callback_gl("glGetShaderInfoLog", (void*)glGetShaderInfoLog, 4, arg0, arg1, arg2, arg3);
     glad_glGetShaderInfoLog(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetShaderInfoLog", (void*)glGetShaderInfoLog, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETSHADERINFOLOGPROC glad_debug_glGetShaderInfoLog = glad_debug_impl_glGetShaderInfoLog;
PFNGLGETSHADERPRECISIONFORMATPROC glad_glGetShaderPrecisionFormat;
void APIENTRY glad_debug_impl_glGetShaderPrecisionFormat(GLenum arg0, GLenum arg1, GLint * arg2, GLint * arg3) {    
    _pre_call_callback_gl("glGetShaderPrecisionFormat", (void*)glGetShaderPrecisionFormat, 4, arg0, arg1, arg2, arg3);
     glad_glGetShaderPrecisionFormat(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetShaderPrecisionFormat", (void*)glGetShaderPrecisionFormat, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETSHADERPRECISIONFORMATPROC glad_debug_glGetShaderPrecisionFormat = glad_debug_impl_glGetShaderPrecisionFormat;
PFNGLGETSHADERSOURCEPROC glad_glGetShaderSource;
void APIENTRY glad_debug_impl_glGetShaderSource(GLuint arg0, GLsizei arg1, GLsizei * arg2, GLchar * arg3) {    
    _pre_call_callback_gl("glGetShaderSource", (void*)glGetShaderSource, 4, arg0, arg1, arg2, arg3);
     glad_glGetShaderSource(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetShaderSource", (void*)glGetShaderSource, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETSHADERSOURCEPROC glad_debug_glGetShaderSource = glad_debug_impl_glGetShaderSource;
PFNGLGETSHADERIVPROC glad_glGetShaderiv;
void APIENTRY glad_debug_impl_glGetShaderiv(GLuint arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetShaderiv", (void*)glGetShaderiv, 3, arg0, arg1, arg2);
     glad_glGetShaderiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetShaderiv", (void*)glGetShaderiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETSHADERIVPROC glad_debug_glGetShaderiv = glad_debug_impl_glGetShaderiv;
PFNGLGETSTRINGPROC glad_glGetString;
const GLubyte * APIENTRY glad_debug_impl_glGetString(GLenum arg0) {    
    const GLubyte * ret;
    _pre_call_callback_gl("glGetString", (void*)glGetString, 1, arg0);
    ret =  glad_glGetString(arg0);
    _post_call_callback_gl("glGetString", (void*)glGetString, 1, arg0);
    return ret;
}
PFNGLGETSTRINGPROC glad_debug_glGetString = glad_debug_impl_glGetString;
PFNGLGETSTRINGIPROC glad_glGetStringi;
const GLubyte * APIENTRY glad_debug_impl_glGetStringi(GLenum arg0, GLuint arg1) {    
    const GLubyte * ret;
    _pre_call_callback_gl("glGetStringi", (void*)glGetStringi, 2, arg0, arg1);
    ret =  glad_glGetStringi(arg0, arg1);
    _post_call_callback_gl("glGetStringi", (void*)glGetStringi, 2, arg0, arg1);
    return ret;
}
PFNGLGETSTRINGIPROC glad_debug_glGetStringi = glad_debug_impl_glGetStringi;
PFNGLGETSYNCIVPROC glad_glGetSynciv;
void APIENTRY glad_debug_impl_glGetSynciv(GLsync arg0, GLenum arg1, GLsizei arg2, GLsizei * arg3, GLint * arg4) {    
    _pre_call_callback_gl("glGetSynciv", (void*)glGetSynciv, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glGetSynciv(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glGetSynciv", (void*)glGetSynciv, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLGETSYNCIVPROC glad_debug_glGetSynciv = glad_debug_impl_glGetSynciv;
PFNGLGETTEXIMAGEPROC glad_glGetTexImage;
void APIENTRY glad_debug_impl_glGetTexImage(GLenum arg0, GLint arg1, GLenum arg2, GLenum arg3, void * arg4) {    
    _pre_call_callback_gl("glGetTexImage", (void*)glGetTexImage, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glGetTexImage(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glGetTexImage", (void*)glGetTexImage, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLGETTEXIMAGEPROC glad_debug_glGetTexImage = glad_debug_impl_glGetTexImage;
PFNGLGETTEXLEVELPARAMETERFVPROC glad_glGetTexLevelParameterfv;
void APIENTRY glad_debug_impl_glGetTexLevelParameterfv(GLenum arg0, GLint arg1, GLenum arg2, GLfloat * arg3) {    
    _pre_call_callback_gl("glGetTexLevelParameterfv", (void*)glGetTexLevelParameterfv, 4, arg0, arg1, arg2, arg3);
     glad_glGetTexLevelParameterfv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetTexLevelParameterfv", (void*)glGetTexLevelParameterfv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETTEXLEVELPARAMETERFVPROC glad_debug_glGetTexLevelParameterfv = glad_debug_impl_glGetTexLevelParameterfv;
PFNGLGETTEXLEVELPARAMETERIVPROC glad_glGetTexLevelParameteriv;
void APIENTRY glad_debug_impl_glGetTexLevelParameteriv(GLenum arg0, GLint arg1, GLenum arg2, GLint * arg3) {    
    _pre_call_callback_gl("glGetTexLevelParameteriv", (void*)glGetTexLevelParameteriv, 4, arg0, arg1, arg2, arg3);
     glad_glGetTexLevelParameteriv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetTexLevelParameteriv", (void*)glGetTexLevelParameteriv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETTEXLEVELPARAMETERIVPROC glad_debug_glGetTexLevelParameteriv = glad_debug_impl_glGetTexLevelParameteriv;
PFNGLGETTEXPARAMETERIIVPROC glad_glGetTexParameterIiv;
void APIENTRY glad_debug_impl_glGetTexParameterIiv(GLenum arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetTexParameterIiv", (void*)glGetTexParameterIiv, 3, arg0, arg1, arg2);
     glad_glGetTexParameterIiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetTexParameterIiv", (void*)glGetTexParameterIiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETTEXPARAMETERIIVPROC glad_debug_glGetTexParameterIiv = glad_debug_impl_glGetTexParameterIiv;
PFNGLGETTEXPARAMETERIUIVPROC glad_glGetTexParameterIuiv;
void APIENTRY glad_debug_impl_glGetTexParameterIuiv(GLenum arg0, GLenum arg1, GLuint * arg2) {    
    _pre_call_callback_gl("glGetTexParameterIuiv", (void*)glGetTexParameterIuiv, 3, arg0, arg1, arg2);
     glad_glGetTexParameterIuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetTexParameterIuiv", (void*)glGetTexParameterIuiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETTEXPARAMETERIUIVPROC glad_debug_glGetTexParameterIuiv = glad_debug_impl_glGetTexParameterIuiv;
PFNGLGETTEXPARAMETERFVPROC glad_glGetTexParameterfv;
void APIENTRY glad_debug_impl_glGetTexParameterfv(GLenum arg0, GLenum arg1, GLfloat * arg2) {    
    _pre_call_callback_gl("glGetTexParameterfv", (void*)glGetTexParameterfv, 3, arg0, arg1, arg2);
     glad_glGetTexParameterfv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetTexParameterfv", (void*)glGetTexParameterfv, 3, arg0, arg1, arg2);
    
}
PFNGLGETTEXPARAMETERFVPROC glad_debug_glGetTexParameterfv = glad_debug_impl_glGetTexParameterfv;
PFNGLGETTEXPARAMETERIVPROC glad_glGetTexParameteriv;
void APIENTRY glad_debug_impl_glGetTexParameteriv(GLenum arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetTexParameteriv", (void*)glGetTexParameteriv, 3, arg0, arg1, arg2);
     glad_glGetTexParameteriv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetTexParameteriv", (void*)glGetTexParameteriv, 3, arg0, arg1, arg2);
    
}
PFNGLGETTEXPARAMETERIVPROC glad_debug_glGetTexParameteriv = glad_debug_impl_glGetTexParameteriv;
PFNGLGETTRANSFORMFEEDBACKVARYINGPROC glad_glGetTransformFeedbackVarying;
void APIENTRY glad_debug_impl_glGetTransformFeedbackVarying(GLuint arg0, GLuint arg1, GLsizei arg2, GLsizei * arg3, GLsizei * arg4, GLenum * arg5, GLchar * arg6) {    
    _pre_call_callback_gl("glGetTransformFeedbackVarying", (void*)glGetTransformFeedbackVarying, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glGetTransformFeedbackVarying(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glGetTransformFeedbackVarying", (void*)glGetTransformFeedbackVarying, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLGETTRANSFORMFEEDBACKVARYINGPROC glad_debug_glGetTransformFeedbackVarying = glad_debug_impl_glGetTransformFeedbackVarying;
PFNGLGETUNIFORMBLOCKINDEXPROC glad_glGetUniformBlockIndex;
GLuint APIENTRY glad_debug_impl_glGetUniformBlockIndex(GLuint arg0, const GLchar * arg1) {    
    GLuint ret;
    _pre_call_callback_gl("glGetUniformBlockIndex", (void*)glGetUniformBlockIndex, 2, arg0, arg1);
    ret =  glad_glGetUniformBlockIndex(arg0, arg1);
    _post_call_callback_gl("glGetUniformBlockIndex", (void*)glGetUniformBlockIndex, 2, arg0, arg1);
    return ret;
}
PFNGLGETUNIFORMBLOCKINDEXPROC glad_debug_glGetUniformBlockIndex = glad_debug_impl_glGetUniformBlockIndex;
PFNGLGETUNIFORMINDICESPROC glad_glGetUniformIndices;
void APIENTRY glad_debug_impl_glGetUniformIndices(GLuint arg0, GLsizei arg1, const GLchar *const* arg2, GLuint * arg3) {    
    _pre_call_callback_gl("glGetUniformIndices", (void*)glGetUniformIndices, 4, arg0, arg1, arg2, arg3);
     glad_glGetUniformIndices(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glGetUniformIndices", (void*)glGetUniformIndices, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLGETUNIFORMINDICESPROC glad_debug_glGetUniformIndices = glad_debug_impl_glGetUniformIndices;
PFNGLGETUNIFORMLOCATIONPROC glad_glGetUniformLocation;
GLint APIENTRY glad_debug_impl_glGetUniformLocation(GLuint arg0, const GLchar * arg1) {    
    GLint ret;
    _pre_call_callback_gl("glGetUniformLocation", (void*)glGetUniformLocation, 2, arg0, arg1);
    ret =  glad_glGetUniformLocation(arg0, arg1);
    _post_call_callback_gl("glGetUniformLocation", (void*)glGetUniformLocation, 2, arg0, arg1);
    return ret;
}
PFNGLGETUNIFORMLOCATIONPROC glad_debug_glGetUniformLocation = glad_debug_impl_glGetUniformLocation;
PFNGLGETUNIFORMFVPROC glad_glGetUniformfv;
void APIENTRY glad_debug_impl_glGetUniformfv(GLuint arg0, GLint arg1, GLfloat * arg2) {    
    _pre_call_callback_gl("glGetUniformfv", (void*)glGetUniformfv, 3, arg0, arg1, arg2);
     glad_glGetUniformfv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetUniformfv", (void*)glGetUniformfv, 3, arg0, arg1, arg2);
    
}
PFNGLGETUNIFORMFVPROC glad_debug_glGetUniformfv = glad_debug_impl_glGetUniformfv;
PFNGLGETUNIFORMIVPROC glad_glGetUniformiv;
void APIENTRY glad_debug_impl_glGetUniformiv(GLuint arg0, GLint arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetUniformiv", (void*)glGetUniformiv, 3, arg0, arg1, arg2);
     glad_glGetUniformiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetUniformiv", (void*)glGetUniformiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETUNIFORMIVPROC glad_debug_glGetUniformiv = glad_debug_impl_glGetUniformiv;
PFNGLGETUNIFORMUIVPROC glad_glGetUniformuiv;
void APIENTRY glad_debug_impl_glGetUniformuiv(GLuint arg0, GLint arg1, GLuint * arg2) {    
    _pre_call_callback_gl("glGetUniformuiv", (void*)glGetUniformuiv, 3, arg0, arg1, arg2);
     glad_glGetUniformuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetUniformuiv", (void*)glGetUniformuiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETUNIFORMUIVPROC glad_debug_glGetUniformuiv = glad_debug_impl_glGetUniformuiv;
PFNGLGETVERTEXATTRIBIIVPROC glad_glGetVertexAttribIiv;
void APIENTRY glad_debug_impl_glGetVertexAttribIiv(GLuint arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetVertexAttribIiv", (void*)glGetVertexAttribIiv, 3, arg0, arg1, arg2);
     glad_glGetVertexAttribIiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetVertexAttribIiv", (void*)glGetVertexAttribIiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETVERTEXATTRIBIIVPROC glad_debug_glGetVertexAttribIiv = glad_debug_impl_glGetVertexAttribIiv;
PFNGLGETVERTEXATTRIBIUIVPROC glad_glGetVertexAttribIuiv;
void APIENTRY glad_debug_impl_glGetVertexAttribIuiv(GLuint arg0, GLenum arg1, GLuint * arg2) {    
    _pre_call_callback_gl("glGetVertexAttribIuiv", (void*)glGetVertexAttribIuiv, 3, arg0, arg1, arg2);
     glad_glGetVertexAttribIuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetVertexAttribIuiv", (void*)glGetVertexAttribIuiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETVERTEXATTRIBIUIVPROC glad_debug_glGetVertexAttribIuiv = glad_debug_impl_glGetVertexAttribIuiv;
PFNGLGETVERTEXATTRIBPOINTERVPROC glad_glGetVertexAttribPointerv;
void APIENTRY glad_debug_impl_glGetVertexAttribPointerv(GLuint arg0, GLenum arg1, void ** arg2) {    
    _pre_call_callback_gl("glGetVertexAttribPointerv", (void*)glGetVertexAttribPointerv, 3, arg0, arg1, arg2);
     glad_glGetVertexAttribPointerv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetVertexAttribPointerv", (void*)glGetVertexAttribPointerv, 3, arg0, arg1, arg2);
    
}
PFNGLGETVERTEXATTRIBPOINTERVPROC glad_debug_glGetVertexAttribPointerv = glad_debug_impl_glGetVertexAttribPointerv;
PFNGLGETVERTEXATTRIBDVPROC glad_glGetVertexAttribdv;
void APIENTRY glad_debug_impl_glGetVertexAttribdv(GLuint arg0, GLenum arg1, GLdouble * arg2) {    
    _pre_call_callback_gl("glGetVertexAttribdv", (void*)glGetVertexAttribdv, 3, arg0, arg1, arg2);
     glad_glGetVertexAttribdv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetVertexAttribdv", (void*)glGetVertexAttribdv, 3, arg0, arg1, arg2);
    
}
PFNGLGETVERTEXATTRIBDVPROC glad_debug_glGetVertexAttribdv = glad_debug_impl_glGetVertexAttribdv;
PFNGLGETVERTEXATTRIBFVPROC glad_glGetVertexAttribfv;
void APIENTRY glad_debug_impl_glGetVertexAttribfv(GLuint arg0, GLenum arg1, GLfloat * arg2) {    
    _pre_call_callback_gl("glGetVertexAttribfv", (void*)glGetVertexAttribfv, 3, arg0, arg1, arg2);
     glad_glGetVertexAttribfv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetVertexAttribfv", (void*)glGetVertexAttribfv, 3, arg0, arg1, arg2);
    
}
PFNGLGETVERTEXATTRIBFVPROC glad_debug_glGetVertexAttribfv = glad_debug_impl_glGetVertexAttribfv;
PFNGLGETVERTEXATTRIBIVPROC glad_glGetVertexAttribiv;
void APIENTRY glad_debug_impl_glGetVertexAttribiv(GLuint arg0, GLenum arg1, GLint * arg2) {    
    _pre_call_callback_gl("glGetVertexAttribiv", (void*)glGetVertexAttribiv, 3, arg0, arg1, arg2);
     glad_glGetVertexAttribiv(arg0, arg1, arg2);
    _post_call_callback_gl("glGetVertexAttribiv", (void*)glGetVertexAttribiv, 3, arg0, arg1, arg2);
    
}
PFNGLGETVERTEXATTRIBIVPROC glad_debug_glGetVertexAttribiv = glad_debug_impl_glGetVertexAttribiv;
PFNGLHINTPROC glad_glHint;
void APIENTRY glad_debug_impl_glHint(GLenum arg0, GLenum arg1) {    
    _pre_call_callback_gl("glHint", (void*)glHint, 2, arg0, arg1);
     glad_glHint(arg0, arg1);
    _post_call_callback_gl("glHint", (void*)glHint, 2, arg0, arg1);
    
}
PFNGLHINTPROC glad_debug_glHint = glad_debug_impl_glHint;
PFNGLINVALIDATEFRAMEBUFFERPROC glad_glInvalidateFramebuffer;
void APIENTRY glad_debug_impl_glInvalidateFramebuffer(GLenum arg0, GLsizei arg1, const GLenum * arg2) {    
    _pre_call_callback_gl("glInvalidateFramebuffer", (void*)glInvalidateFramebuffer, 3, arg0, arg1, arg2);
     glad_glInvalidateFramebuffer(arg0, arg1, arg2);
    _post_call_callback_gl("glInvalidateFramebuffer", (void*)glInvalidateFramebuffer, 3, arg0, arg1, arg2);
    
}
PFNGLINVALIDATEFRAMEBUFFERPROC glad_debug_glInvalidateFramebuffer = glad_debug_impl_glInvalidateFramebuffer;
PFNGLINVALIDATESUBFRAMEBUFFERPROC glad_glInvalidateSubFramebuffer;
void APIENTRY glad_debug_impl_glInvalidateSubFramebuffer(GLenum arg0, GLsizei arg1, const GLenum * arg2, GLint arg3, GLint arg4, GLsizei arg5, GLsizei arg6) {    
    _pre_call_callback_gl("glInvalidateSubFramebuffer", (void*)glInvalidateSubFramebuffer, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glInvalidateSubFramebuffer(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glInvalidateSubFramebuffer", (void*)glInvalidateSubFramebuffer, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLINVALIDATESUBFRAMEBUFFERPROC glad_debug_glInvalidateSubFramebuffer = glad_debug_impl_glInvalidateSubFramebuffer;
PFNGLISBUFFERPROC glad_glIsBuffer;
GLboolean APIENTRY glad_debug_impl_glIsBuffer(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsBuffer", (void*)glIsBuffer, 1, arg0);
    ret =  glad_glIsBuffer(arg0);
    _post_call_callback_gl("glIsBuffer", (void*)glIsBuffer, 1, arg0);
    return ret;
}
PFNGLISBUFFERPROC glad_debug_glIsBuffer = glad_debug_impl_glIsBuffer;
PFNGLISENABLEDPROC glad_glIsEnabled;
GLboolean APIENTRY glad_debug_impl_glIsEnabled(GLenum arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsEnabled", (void*)glIsEnabled, 1, arg0);
    ret =  glad_glIsEnabled(arg0);
    _post_call_callback_gl("glIsEnabled", (void*)glIsEnabled, 1, arg0);
    return ret;
}
PFNGLISENABLEDPROC glad_debug_glIsEnabled = glad_debug_impl_glIsEnabled;
PFNGLISENABLEDIPROC glad_glIsEnabledi;
GLboolean APIENTRY glad_debug_impl_glIsEnabledi(GLenum arg0, GLuint arg1) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsEnabledi", (void*)glIsEnabledi, 2, arg0, arg1);
    ret =  glad_glIsEnabledi(arg0, arg1);
    _post_call_callback_gl("glIsEnabledi", (void*)glIsEnabledi, 2, arg0, arg1);
    return ret;
}
PFNGLISENABLEDIPROC glad_debug_glIsEnabledi = glad_debug_impl_glIsEnabledi;
PFNGLISFRAMEBUFFERPROC glad_glIsFramebuffer;
GLboolean APIENTRY glad_debug_impl_glIsFramebuffer(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsFramebuffer", (void*)glIsFramebuffer, 1, arg0);
    ret =  glad_glIsFramebuffer(arg0);
    _post_call_callback_gl("glIsFramebuffer", (void*)glIsFramebuffer, 1, arg0);
    return ret;
}
PFNGLISFRAMEBUFFERPROC glad_debug_glIsFramebuffer = glad_debug_impl_glIsFramebuffer;
PFNGLISPROGRAMPROC glad_glIsProgram;
GLboolean APIENTRY glad_debug_impl_glIsProgram(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsProgram", (void*)glIsProgram, 1, arg0);
    ret =  glad_glIsProgram(arg0);
    _post_call_callback_gl("glIsProgram", (void*)glIsProgram, 1, arg0);
    return ret;
}
PFNGLISPROGRAMPROC glad_debug_glIsProgram = glad_debug_impl_glIsProgram;
PFNGLISQUERYPROC glad_glIsQuery;
GLboolean APIENTRY glad_debug_impl_glIsQuery(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsQuery", (void*)glIsQuery, 1, arg0);
    ret =  glad_glIsQuery(arg0);
    _post_call_callback_gl("glIsQuery", (void*)glIsQuery, 1, arg0);
    return ret;
}
PFNGLISQUERYPROC glad_debug_glIsQuery = glad_debug_impl_glIsQuery;
PFNGLISRENDERBUFFERPROC glad_glIsRenderbuffer;
GLboolean APIENTRY glad_debug_impl_glIsRenderbuffer(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsRenderbuffer", (void*)glIsRenderbuffer, 1, arg0);
    ret =  glad_glIsRenderbuffer(arg0);
    _post_call_callback_gl("glIsRenderbuffer", (void*)glIsRenderbuffer, 1, arg0);
    return ret;
}
PFNGLISRENDERBUFFERPROC glad_debug_glIsRenderbuffer = glad_debug_impl_glIsRenderbuffer;
PFNGLISSAMPLERPROC glad_glIsSampler;
GLboolean APIENTRY glad_debug_impl_glIsSampler(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsSampler", (void*)glIsSampler, 1, arg0);
    ret =  glad_glIsSampler(arg0);
    _post_call_callback_gl("glIsSampler", (void*)glIsSampler, 1, arg0);
    return ret;
}
PFNGLISSAMPLERPROC glad_debug_glIsSampler = glad_debug_impl_glIsSampler;
PFNGLISSHADERPROC glad_glIsShader;
GLboolean APIENTRY glad_debug_impl_glIsShader(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsShader", (void*)glIsShader, 1, arg0);
    ret =  glad_glIsShader(arg0);
    _post_call_callback_gl("glIsShader", (void*)glIsShader, 1, arg0);
    return ret;
}
PFNGLISSHADERPROC glad_debug_glIsShader = glad_debug_impl_glIsShader;
PFNGLISSYNCPROC glad_glIsSync;
GLboolean APIENTRY glad_debug_impl_glIsSync(GLsync arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsSync", (void*)glIsSync, 1, arg0);
    ret =  glad_glIsSync(arg0);
    _post_call_callback_gl("glIsSync", (void*)glIsSync, 1, arg0);
    return ret;
}
PFNGLISSYNCPROC glad_debug_glIsSync = glad_debug_impl_glIsSync;
PFNGLISTEXTUREPROC glad_glIsTexture;
GLboolean APIENTRY glad_debug_impl_glIsTexture(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsTexture", (void*)glIsTexture, 1, arg0);
    ret =  glad_glIsTexture(arg0);
    _post_call_callback_gl("glIsTexture", (void*)glIsTexture, 1, arg0);
    return ret;
}
PFNGLISTEXTUREPROC glad_debug_glIsTexture = glad_debug_impl_glIsTexture;
PFNGLISTRANSFORMFEEDBACKPROC glad_glIsTransformFeedback;
GLboolean APIENTRY glad_debug_impl_glIsTransformFeedback(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsTransformFeedback", (void*)glIsTransformFeedback, 1, arg0);
    ret =  glad_glIsTransformFeedback(arg0);
    _post_call_callback_gl("glIsTransformFeedback", (void*)glIsTransformFeedback, 1, arg0);
    return ret;
}
PFNGLISTRANSFORMFEEDBACKPROC glad_debug_glIsTransformFeedback = glad_debug_impl_glIsTransformFeedback;
PFNGLISVERTEXARRAYPROC glad_glIsVertexArray;
GLboolean APIENTRY glad_debug_impl_glIsVertexArray(GLuint arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glIsVertexArray", (void*)glIsVertexArray, 1, arg0);
    ret =  glad_glIsVertexArray(arg0);
    _post_call_callback_gl("glIsVertexArray", (void*)glIsVertexArray, 1, arg0);
    return ret;
}
PFNGLISVERTEXARRAYPROC glad_debug_glIsVertexArray = glad_debug_impl_glIsVertexArray;
PFNGLLINEWIDTHPROC glad_glLineWidth;
void APIENTRY glad_debug_impl_glLineWidth(GLfloat arg0) {    
    _pre_call_callback_gl("glLineWidth", (void*)glLineWidth, 1, arg0);
     glad_glLineWidth(arg0);
    _post_call_callback_gl("glLineWidth", (void*)glLineWidth, 1, arg0);
    
}
PFNGLLINEWIDTHPROC glad_debug_glLineWidth = glad_debug_impl_glLineWidth;
PFNGLLINKPROGRAMPROC glad_glLinkProgram;
void APIENTRY glad_debug_impl_glLinkProgram(GLuint arg0) {    
    _pre_call_callback_gl("glLinkProgram", (void*)glLinkProgram, 1, arg0);
     glad_glLinkProgram(arg0);
    _post_call_callback_gl("glLinkProgram", (void*)glLinkProgram, 1, arg0);
    
}
PFNGLLINKPROGRAMPROC glad_debug_glLinkProgram = glad_debug_impl_glLinkProgram;
PFNGLLOGICOPPROC glad_glLogicOp;
void APIENTRY glad_debug_impl_glLogicOp(GLenum arg0) {    
    _pre_call_callback_gl("glLogicOp", (void*)glLogicOp, 1, arg0);
     glad_glLogicOp(arg0);
    _post_call_callback_gl("glLogicOp", (void*)glLogicOp, 1, arg0);
    
}
PFNGLLOGICOPPROC glad_debug_glLogicOp = glad_debug_impl_glLogicOp;
PFNGLMAPBUFFERPROC glad_glMapBuffer;
void * APIENTRY glad_debug_impl_glMapBuffer(GLenum arg0, GLenum arg1) {    
    void * ret;
    _pre_call_callback_gl("glMapBuffer", (void*)glMapBuffer, 2, arg0, arg1);
    ret =  glad_glMapBuffer(arg0, arg1);
    _post_call_callback_gl("glMapBuffer", (void*)glMapBuffer, 2, arg0, arg1);
    return ret;
}
PFNGLMAPBUFFERPROC glad_debug_glMapBuffer = glad_debug_impl_glMapBuffer;
PFNGLMAPBUFFERRANGEPROC glad_glMapBufferRange;
void * APIENTRY glad_debug_impl_glMapBufferRange(GLenum arg0, GLintptr arg1, GLsizeiptr arg2, GLbitfield arg3) {    
    void * ret;
    _pre_call_callback_gl("glMapBufferRange", (void*)glMapBufferRange, 4, arg0, arg1, arg2, arg3);
    ret =  glad_glMapBufferRange(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glMapBufferRange", (void*)glMapBufferRange, 4, arg0, arg1, arg2, arg3);
    return ret;
}
PFNGLMAPBUFFERRANGEPROC glad_debug_glMapBufferRange = glad_debug_impl_glMapBufferRange;
PFNGLMULTIDRAWARRAYSPROC glad_glMultiDrawArrays;
void APIENTRY glad_debug_impl_glMultiDrawArrays(GLenum arg0, const GLint * arg1, const GLsizei * arg2, GLsizei arg3) {    
    _pre_call_callback_gl("glMultiDrawArrays", (void*)glMultiDrawArrays, 4, arg0, arg1, arg2, arg3);
     glad_glMultiDrawArrays(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glMultiDrawArrays", (void*)glMultiDrawArrays, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLMULTIDRAWARRAYSPROC glad_debug_glMultiDrawArrays = glad_debug_impl_glMultiDrawArrays;
PFNGLMULTIDRAWELEMENTSPROC glad_glMultiDrawElements;
void APIENTRY glad_debug_impl_glMultiDrawElements(GLenum arg0, const GLsizei * arg1, GLenum arg2, const void *const* arg3, GLsizei arg4) {    
    _pre_call_callback_gl("glMultiDrawElements", (void*)glMultiDrawElements, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glMultiDrawElements(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glMultiDrawElements", (void*)glMultiDrawElements, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLMULTIDRAWELEMENTSPROC glad_debug_glMultiDrawElements = glad_debug_impl_glMultiDrawElements;
PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC glad_glMultiDrawElementsBaseVertex;
void APIENTRY glad_debug_impl_glMultiDrawElementsBaseVertex(GLenum arg0, const GLsizei * arg1, GLenum arg2, const void *const* arg3, GLsizei arg4, const GLint * arg5) {    
    _pre_call_callback_gl("glMultiDrawElementsBaseVertex", (void*)glMultiDrawElementsBaseVertex, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glMultiDrawElementsBaseVertex(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glMultiDrawElementsBaseVertex", (void*)glMultiDrawElementsBaseVertex, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC glad_debug_glMultiDrawElementsBaseVertex = glad_debug_impl_glMultiDrawElementsBaseVertex;
PFNGLMULTITEXCOORDP1UIPROC glad_glMultiTexCoordP1ui;
void APIENTRY glad_debug_impl_glMultiTexCoordP1ui(GLenum arg0, GLenum arg1, GLuint arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP1ui", (void*)glMultiTexCoordP1ui, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP1ui(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP1ui", (void*)glMultiTexCoordP1ui, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP1UIPROC glad_debug_glMultiTexCoordP1ui = glad_debug_impl_glMultiTexCoordP1ui;
PFNGLMULTITEXCOORDP1UIVPROC glad_glMultiTexCoordP1uiv;
void APIENTRY glad_debug_impl_glMultiTexCoordP1uiv(GLenum arg0, GLenum arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP1uiv", (void*)glMultiTexCoordP1uiv, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP1uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP1uiv", (void*)glMultiTexCoordP1uiv, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP1UIVPROC glad_debug_glMultiTexCoordP1uiv = glad_debug_impl_glMultiTexCoordP1uiv;
PFNGLMULTITEXCOORDP2UIPROC glad_glMultiTexCoordP2ui;
void APIENTRY glad_debug_impl_glMultiTexCoordP2ui(GLenum arg0, GLenum arg1, GLuint arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP2ui", (void*)glMultiTexCoordP2ui, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP2ui(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP2ui", (void*)glMultiTexCoordP2ui, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP2UIPROC glad_debug_glMultiTexCoordP2ui = glad_debug_impl_glMultiTexCoordP2ui;
PFNGLMULTITEXCOORDP2UIVPROC glad_glMultiTexCoordP2uiv;
void APIENTRY glad_debug_impl_glMultiTexCoordP2uiv(GLenum arg0, GLenum arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP2uiv", (void*)glMultiTexCoordP2uiv, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP2uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP2uiv", (void*)glMultiTexCoordP2uiv, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP2UIVPROC glad_debug_glMultiTexCoordP2uiv = glad_debug_impl_glMultiTexCoordP2uiv;
PFNGLMULTITEXCOORDP3UIPROC glad_glMultiTexCoordP3ui;
void APIENTRY glad_debug_impl_glMultiTexCoordP3ui(GLenum arg0, GLenum arg1, GLuint arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP3ui", (void*)glMultiTexCoordP3ui, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP3ui(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP3ui", (void*)glMultiTexCoordP3ui, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP3UIPROC glad_debug_glMultiTexCoordP3ui = glad_debug_impl_glMultiTexCoordP3ui;
PFNGLMULTITEXCOORDP3UIVPROC glad_glMultiTexCoordP3uiv;
void APIENTRY glad_debug_impl_glMultiTexCoordP3uiv(GLenum arg0, GLenum arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP3uiv", (void*)glMultiTexCoordP3uiv, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP3uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP3uiv", (void*)glMultiTexCoordP3uiv, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP3UIVPROC glad_debug_glMultiTexCoordP3uiv = glad_debug_impl_glMultiTexCoordP3uiv;
PFNGLMULTITEXCOORDP4UIPROC glad_glMultiTexCoordP4ui;
void APIENTRY glad_debug_impl_glMultiTexCoordP4ui(GLenum arg0, GLenum arg1, GLuint arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP4ui", (void*)glMultiTexCoordP4ui, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP4ui(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP4ui", (void*)glMultiTexCoordP4ui, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP4UIPROC glad_debug_glMultiTexCoordP4ui = glad_debug_impl_glMultiTexCoordP4ui;
PFNGLMULTITEXCOORDP4UIVPROC glad_glMultiTexCoordP4uiv;
void APIENTRY glad_debug_impl_glMultiTexCoordP4uiv(GLenum arg0, GLenum arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glMultiTexCoordP4uiv", (void*)glMultiTexCoordP4uiv, 3, arg0, arg1, arg2);
     glad_glMultiTexCoordP4uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glMultiTexCoordP4uiv", (void*)glMultiTexCoordP4uiv, 3, arg0, arg1, arg2);
    
}
PFNGLMULTITEXCOORDP4UIVPROC glad_debug_glMultiTexCoordP4uiv = glad_debug_impl_glMultiTexCoordP4uiv;
PFNGLNORMALP3UIPROC glad_glNormalP3ui;
void APIENTRY glad_debug_impl_glNormalP3ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glNormalP3ui", (void*)glNormalP3ui, 2, arg0, arg1);
     glad_glNormalP3ui(arg0, arg1);
    _post_call_callback_gl("glNormalP3ui", (void*)glNormalP3ui, 2, arg0, arg1);
    
}
PFNGLNORMALP3UIPROC glad_debug_glNormalP3ui = glad_debug_impl_glNormalP3ui;
PFNGLNORMALP3UIVPROC glad_glNormalP3uiv;
void APIENTRY glad_debug_impl_glNormalP3uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glNormalP3uiv", (void*)glNormalP3uiv, 2, arg0, arg1);
     glad_glNormalP3uiv(arg0, arg1);
    _post_call_callback_gl("glNormalP3uiv", (void*)glNormalP3uiv, 2, arg0, arg1);
    
}
PFNGLNORMALP3UIVPROC glad_debug_glNormalP3uiv = glad_debug_impl_glNormalP3uiv;
PFNGLPAUSETRANSFORMFEEDBACKPROC glad_glPauseTransformFeedback;
void APIENTRY glad_debug_impl_glPauseTransformFeedback(void) {    
    _pre_call_callback_gl("glPauseTransformFeedback", (void*)glPauseTransformFeedback, 0);
     glad_glPauseTransformFeedback();
    _post_call_callback_gl("glPauseTransformFeedback", (void*)glPauseTransformFeedback, 0);
    
}
PFNGLPAUSETRANSFORMFEEDBACKPROC glad_debug_glPauseTransformFeedback = glad_debug_impl_glPauseTransformFeedback;
PFNGLPIXELSTOREFPROC glad_glPixelStoref;
void APIENTRY glad_debug_impl_glPixelStoref(GLenum arg0, GLfloat arg1) {    
    _pre_call_callback_gl("glPixelStoref", (void*)glPixelStoref, 2, arg0, arg1);
     glad_glPixelStoref(arg0, arg1);
    _post_call_callback_gl("glPixelStoref", (void*)glPixelStoref, 2, arg0, arg1);
    
}
PFNGLPIXELSTOREFPROC glad_debug_glPixelStoref = glad_debug_impl_glPixelStoref;
PFNGLPIXELSTOREIPROC glad_glPixelStorei;
void APIENTRY glad_debug_impl_glPixelStorei(GLenum arg0, GLint arg1) {    
    _pre_call_callback_gl("glPixelStorei", (void*)glPixelStorei, 2, arg0, arg1);
     glad_glPixelStorei(arg0, arg1);
    _post_call_callback_gl("glPixelStorei", (void*)glPixelStorei, 2, arg0, arg1);
    
}
PFNGLPIXELSTOREIPROC glad_debug_glPixelStorei = glad_debug_impl_glPixelStorei;
PFNGLPOINTPARAMETERFPROC glad_glPointParameterf;
void APIENTRY glad_debug_impl_glPointParameterf(GLenum arg0, GLfloat arg1) {    
    _pre_call_callback_gl("glPointParameterf", (void*)glPointParameterf, 2, arg0, arg1);
     glad_glPointParameterf(arg0, arg1);
    _post_call_callback_gl("glPointParameterf", (void*)glPointParameterf, 2, arg0, arg1);
    
}
PFNGLPOINTPARAMETERFPROC glad_debug_glPointParameterf = glad_debug_impl_glPointParameterf;
PFNGLPOINTPARAMETERFVPROC glad_glPointParameterfv;
void APIENTRY glad_debug_impl_glPointParameterfv(GLenum arg0, const GLfloat * arg1) {    
    _pre_call_callback_gl("glPointParameterfv", (void*)glPointParameterfv, 2, arg0, arg1);
     glad_glPointParameterfv(arg0, arg1);
    _post_call_callback_gl("glPointParameterfv", (void*)glPointParameterfv, 2, arg0, arg1);
    
}
PFNGLPOINTPARAMETERFVPROC glad_debug_glPointParameterfv = glad_debug_impl_glPointParameterfv;
PFNGLPOINTPARAMETERIPROC glad_glPointParameteri;
void APIENTRY glad_debug_impl_glPointParameteri(GLenum arg0, GLint arg1) {    
    _pre_call_callback_gl("glPointParameteri", (void*)glPointParameteri, 2, arg0, arg1);
     glad_glPointParameteri(arg0, arg1);
    _post_call_callback_gl("glPointParameteri", (void*)glPointParameteri, 2, arg0, arg1);
    
}
PFNGLPOINTPARAMETERIPROC glad_debug_glPointParameteri = glad_debug_impl_glPointParameteri;
PFNGLPOINTPARAMETERIVPROC glad_glPointParameteriv;
void APIENTRY glad_debug_impl_glPointParameteriv(GLenum arg0, const GLint * arg1) {    
    _pre_call_callback_gl("glPointParameteriv", (void*)glPointParameteriv, 2, arg0, arg1);
     glad_glPointParameteriv(arg0, arg1);
    _post_call_callback_gl("glPointParameteriv", (void*)glPointParameteriv, 2, arg0, arg1);
    
}
PFNGLPOINTPARAMETERIVPROC glad_debug_glPointParameteriv = glad_debug_impl_glPointParameteriv;
PFNGLPOINTSIZEPROC glad_glPointSize;
void APIENTRY glad_debug_impl_glPointSize(GLfloat arg0) {    
    _pre_call_callback_gl("glPointSize", (void*)glPointSize, 1, arg0);
     glad_glPointSize(arg0);
    _post_call_callback_gl("glPointSize", (void*)glPointSize, 1, arg0);
    
}
PFNGLPOINTSIZEPROC glad_debug_glPointSize = glad_debug_impl_glPointSize;
PFNGLPOLYGONMODEPROC glad_glPolygonMode;
void APIENTRY glad_debug_impl_glPolygonMode(GLenum arg0, GLenum arg1) {    
    _pre_call_callback_gl("glPolygonMode", (void*)glPolygonMode, 2, arg0, arg1);
     glad_glPolygonMode(arg0, arg1);
    _post_call_callback_gl("glPolygonMode", (void*)glPolygonMode, 2, arg0, arg1);
    
}
PFNGLPOLYGONMODEPROC glad_debug_glPolygonMode = glad_debug_impl_glPolygonMode;
PFNGLPOLYGONOFFSETPROC glad_glPolygonOffset;
void APIENTRY glad_debug_impl_glPolygonOffset(GLfloat arg0, GLfloat arg1) {    
    _pre_call_callback_gl("glPolygonOffset", (void*)glPolygonOffset, 2, arg0, arg1);
     glad_glPolygonOffset(arg0, arg1);
    _post_call_callback_gl("glPolygonOffset", (void*)glPolygonOffset, 2, arg0, arg1);
    
}
PFNGLPOLYGONOFFSETPROC glad_debug_glPolygonOffset = glad_debug_impl_glPolygonOffset;
PFNGLPRIMITIVERESTARTINDEXPROC glad_glPrimitiveRestartIndex;
void APIENTRY glad_debug_impl_glPrimitiveRestartIndex(GLuint arg0) {    
    _pre_call_callback_gl("glPrimitiveRestartIndex", (void*)glPrimitiveRestartIndex, 1, arg0);
     glad_glPrimitiveRestartIndex(arg0);
    _post_call_callback_gl("glPrimitiveRestartIndex", (void*)glPrimitiveRestartIndex, 1, arg0);
    
}
PFNGLPRIMITIVERESTARTINDEXPROC glad_debug_glPrimitiveRestartIndex = glad_debug_impl_glPrimitiveRestartIndex;
PFNGLPROGRAMBINARYPROC glad_glProgramBinary;
void APIENTRY glad_debug_impl_glProgramBinary(GLuint arg0, GLenum arg1, const void * arg2, GLsizei arg3) {    
    _pre_call_callback_gl("glProgramBinary", (void*)glProgramBinary, 4, arg0, arg1, arg2, arg3);
     glad_glProgramBinary(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glProgramBinary", (void*)glProgramBinary, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLPROGRAMBINARYPROC glad_debug_glProgramBinary = glad_debug_impl_glProgramBinary;
PFNGLPROGRAMPARAMETERIPROC glad_glProgramParameteri;
void APIENTRY glad_debug_impl_glProgramParameteri(GLuint arg0, GLenum arg1, GLint arg2) {    
    _pre_call_callback_gl("glProgramParameteri", (void*)glProgramParameteri, 3, arg0, arg1, arg2);
     glad_glProgramParameteri(arg0, arg1, arg2);
    _post_call_callback_gl("glProgramParameteri", (void*)glProgramParameteri, 3, arg0, arg1, arg2);
    
}
PFNGLPROGRAMPARAMETERIPROC glad_debug_glProgramParameteri = glad_debug_impl_glProgramParameteri;
PFNGLPROVOKINGVERTEXPROC glad_glProvokingVertex;
void APIENTRY glad_debug_impl_glProvokingVertex(GLenum arg0) {    
    _pre_call_callback_gl("glProvokingVertex", (void*)glProvokingVertex, 1, arg0);
     glad_glProvokingVertex(arg0);
    _post_call_callback_gl("glProvokingVertex", (void*)glProvokingVertex, 1, arg0);
    
}
PFNGLPROVOKINGVERTEXPROC glad_debug_glProvokingVertex = glad_debug_impl_glProvokingVertex;
PFNGLQUERYCOUNTERPROC glad_glQueryCounter;
void APIENTRY glad_debug_impl_glQueryCounter(GLuint arg0, GLenum arg1) {    
    _pre_call_callback_gl("glQueryCounter", (void*)glQueryCounter, 2, arg0, arg1);
     glad_glQueryCounter(arg0, arg1);
    _post_call_callback_gl("glQueryCounter", (void*)glQueryCounter, 2, arg0, arg1);
    
}
PFNGLQUERYCOUNTERPROC glad_debug_glQueryCounter = glad_debug_impl_glQueryCounter;
PFNGLREADBUFFERPROC glad_glReadBuffer;
void APIENTRY glad_debug_impl_glReadBuffer(GLenum arg0) {    
    _pre_call_callback_gl("glReadBuffer", (void*)glReadBuffer, 1, arg0);
     glad_glReadBuffer(arg0);
    _post_call_callback_gl("glReadBuffer", (void*)glReadBuffer, 1, arg0);
    
}
PFNGLREADBUFFERPROC glad_debug_glReadBuffer = glad_debug_impl_glReadBuffer;
PFNGLREADPIXELSPROC glad_glReadPixels;
void APIENTRY glad_debug_impl_glReadPixels(GLint arg0, GLint arg1, GLsizei arg2, GLsizei arg3, GLenum arg4, GLenum arg5, void * arg6) {    
    _pre_call_callback_gl("glReadPixels", (void*)glReadPixels, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glReadPixels(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glReadPixels", (void*)glReadPixels, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLREADPIXELSPROC glad_debug_glReadPixels = glad_debug_impl_glReadPixels;
PFNGLRELEASESHADERCOMPILERPROC glad_glReleaseShaderCompiler;
void APIENTRY glad_debug_impl_glReleaseShaderCompiler(void) {    
    _pre_call_callback_gl("glReleaseShaderCompiler", (void*)glReleaseShaderCompiler, 0);
     glad_glReleaseShaderCompiler();
    _post_call_callback_gl("glReleaseShaderCompiler", (void*)glReleaseShaderCompiler, 0);
    
}
PFNGLRELEASESHADERCOMPILERPROC glad_debug_glReleaseShaderCompiler = glad_debug_impl_glReleaseShaderCompiler;
PFNGLRENDERBUFFERSTORAGEPROC glad_glRenderbufferStorage;
void APIENTRY glad_debug_impl_glRenderbufferStorage(GLenum arg0, GLenum arg1, GLsizei arg2, GLsizei arg3) {    
    _pre_call_callback_gl("glRenderbufferStorage", (void*)glRenderbufferStorage, 4, arg0, arg1, arg2, arg3);
     glad_glRenderbufferStorage(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glRenderbufferStorage", (void*)glRenderbufferStorage, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLRENDERBUFFERSTORAGEPROC glad_debug_glRenderbufferStorage = glad_debug_impl_glRenderbufferStorage;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC glad_glRenderbufferStorageMultisample;
void APIENTRY glad_debug_impl_glRenderbufferStorageMultisample(GLenum arg0, GLsizei arg1, GLenum arg2, GLsizei arg3, GLsizei arg4) {    
    _pre_call_callback_gl("glRenderbufferStorageMultisample", (void*)glRenderbufferStorageMultisample, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glRenderbufferStorageMultisample(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glRenderbufferStorageMultisample", (void*)glRenderbufferStorageMultisample, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC glad_debug_glRenderbufferStorageMultisample = glad_debug_impl_glRenderbufferStorageMultisample;
PFNGLRESUMETRANSFORMFEEDBACKPROC glad_glResumeTransformFeedback;
void APIENTRY glad_debug_impl_glResumeTransformFeedback(void) {    
    _pre_call_callback_gl("glResumeTransformFeedback", (void*)glResumeTransformFeedback, 0);
     glad_glResumeTransformFeedback();
    _post_call_callback_gl("glResumeTransformFeedback", (void*)glResumeTransformFeedback, 0);
    
}
PFNGLRESUMETRANSFORMFEEDBACKPROC glad_debug_glResumeTransformFeedback = glad_debug_impl_glResumeTransformFeedback;
PFNGLSAMPLECOVERAGEPROC glad_glSampleCoverage;
void APIENTRY glad_debug_impl_glSampleCoverage(GLfloat arg0, GLboolean arg1) {    
    _pre_call_callback_gl("glSampleCoverage", (void*)glSampleCoverage, 2, arg0, arg1);
     glad_glSampleCoverage(arg0, arg1);
    _post_call_callback_gl("glSampleCoverage", (void*)glSampleCoverage, 2, arg0, arg1);
    
}
PFNGLSAMPLECOVERAGEPROC glad_debug_glSampleCoverage = glad_debug_impl_glSampleCoverage;
PFNGLSAMPLEMASKIPROC glad_glSampleMaski;
void APIENTRY glad_debug_impl_glSampleMaski(GLuint arg0, GLbitfield arg1) {    
    _pre_call_callback_gl("glSampleMaski", (void*)glSampleMaski, 2, arg0, arg1);
     glad_glSampleMaski(arg0, arg1);
    _post_call_callback_gl("glSampleMaski", (void*)glSampleMaski, 2, arg0, arg1);
    
}
PFNGLSAMPLEMASKIPROC glad_debug_glSampleMaski = glad_debug_impl_glSampleMaski;
PFNGLSAMPLERPARAMETERIIVPROC glad_glSamplerParameterIiv;
void APIENTRY glad_debug_impl_glSamplerParameterIiv(GLuint arg0, GLenum arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glSamplerParameterIiv", (void*)glSamplerParameterIiv, 3, arg0, arg1, arg2);
     glad_glSamplerParameterIiv(arg0, arg1, arg2);
    _post_call_callback_gl("glSamplerParameterIiv", (void*)glSamplerParameterIiv, 3, arg0, arg1, arg2);
    
}
PFNGLSAMPLERPARAMETERIIVPROC glad_debug_glSamplerParameterIiv = glad_debug_impl_glSamplerParameterIiv;
PFNGLSAMPLERPARAMETERIUIVPROC glad_glSamplerParameterIuiv;
void APIENTRY glad_debug_impl_glSamplerParameterIuiv(GLuint arg0, GLenum arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glSamplerParameterIuiv", (void*)glSamplerParameterIuiv, 3, arg0, arg1, arg2);
     glad_glSamplerParameterIuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glSamplerParameterIuiv", (void*)glSamplerParameterIuiv, 3, arg0, arg1, arg2);
    
}
PFNGLSAMPLERPARAMETERIUIVPROC glad_debug_glSamplerParameterIuiv = glad_debug_impl_glSamplerParameterIuiv;
PFNGLSAMPLERPARAMETERFPROC glad_glSamplerParameterf;
void APIENTRY glad_debug_impl_glSamplerParameterf(GLuint arg0, GLenum arg1, GLfloat arg2) {    
    _pre_call_callback_gl("glSamplerParameterf", (void*)glSamplerParameterf, 3, arg0, arg1, arg2);
     glad_glSamplerParameterf(arg0, arg1, arg2);
    _post_call_callback_gl("glSamplerParameterf", (void*)glSamplerParameterf, 3, arg0, arg1, arg2);
    
}
PFNGLSAMPLERPARAMETERFPROC glad_debug_glSamplerParameterf = glad_debug_impl_glSamplerParameterf;
PFNGLSAMPLERPARAMETERFVPROC glad_glSamplerParameterfv;
void APIENTRY glad_debug_impl_glSamplerParameterfv(GLuint arg0, GLenum arg1, const GLfloat * arg2) {    
    _pre_call_callback_gl("glSamplerParameterfv", (void*)glSamplerParameterfv, 3, arg0, arg1, arg2);
     glad_glSamplerParameterfv(arg0, arg1, arg2);
    _post_call_callback_gl("glSamplerParameterfv", (void*)glSamplerParameterfv, 3, arg0, arg1, arg2);
    
}
PFNGLSAMPLERPARAMETERFVPROC glad_debug_glSamplerParameterfv = glad_debug_impl_glSamplerParameterfv;
PFNGLSAMPLERPARAMETERIPROC glad_glSamplerParameteri;
void APIENTRY glad_debug_impl_glSamplerParameteri(GLuint arg0, GLenum arg1, GLint arg2) {    
    _pre_call_callback_gl("glSamplerParameteri", (void*)glSamplerParameteri, 3, arg0, arg1, arg2);
     glad_glSamplerParameteri(arg0, arg1, arg2);
    _post_call_callback_gl("glSamplerParameteri", (void*)glSamplerParameteri, 3, arg0, arg1, arg2);
    
}
PFNGLSAMPLERPARAMETERIPROC glad_debug_glSamplerParameteri = glad_debug_impl_glSamplerParameteri;
PFNGLSAMPLERPARAMETERIVPROC glad_glSamplerParameteriv;
void APIENTRY glad_debug_impl_glSamplerParameteriv(GLuint arg0, GLenum arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glSamplerParameteriv", (void*)glSamplerParameteriv, 3, arg0, arg1, arg2);
     glad_glSamplerParameteriv(arg0, arg1, arg2);
    _post_call_callback_gl("glSamplerParameteriv", (void*)glSamplerParameteriv, 3, arg0, arg1, arg2);
    
}
PFNGLSAMPLERPARAMETERIVPROC glad_debug_glSamplerParameteriv = glad_debug_impl_glSamplerParameteriv;
PFNGLSCISSORPROC glad_glScissor;
void APIENTRY glad_debug_impl_glScissor(GLint arg0, GLint arg1, GLsizei arg2, GLsizei arg3) {    
    _pre_call_callback_gl("glScissor", (void*)glScissor, 4, arg0, arg1, arg2, arg3);
     glad_glScissor(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glScissor", (void*)glScissor, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLSCISSORPROC glad_debug_glScissor = glad_debug_impl_glScissor;
PFNGLSECONDARYCOLORP3UIPROC glad_glSecondaryColorP3ui;
void APIENTRY glad_debug_impl_glSecondaryColorP3ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glSecondaryColorP3ui", (void*)glSecondaryColorP3ui, 2, arg0, arg1);
     glad_glSecondaryColorP3ui(arg0, arg1);
    _post_call_callback_gl("glSecondaryColorP3ui", (void*)glSecondaryColorP3ui, 2, arg0, arg1);
    
}
PFNGLSECONDARYCOLORP3UIPROC glad_debug_glSecondaryColorP3ui = glad_debug_impl_glSecondaryColorP3ui;
PFNGLSECONDARYCOLORP3UIVPROC glad_glSecondaryColorP3uiv;
void APIENTRY glad_debug_impl_glSecondaryColorP3uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glSecondaryColorP3uiv", (void*)glSecondaryColorP3uiv, 2, arg0, arg1);
     glad_glSecondaryColorP3uiv(arg0, arg1);
    _post_call_callback_gl("glSecondaryColorP3uiv", (void*)glSecondaryColorP3uiv, 2, arg0, arg1);
    
}
PFNGLSECONDARYCOLORP3UIVPROC glad_debug_glSecondaryColorP3uiv = glad_debug_impl_glSecondaryColorP3uiv;
PFNGLSHADERBINARYPROC glad_glShaderBinary;
void APIENTRY glad_debug_impl_glShaderBinary(GLsizei arg0, const GLuint * arg1, GLenum arg2, const void * arg3, GLsizei arg4) {    
    _pre_call_callback_gl("glShaderBinary", (void*)glShaderBinary, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glShaderBinary(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glShaderBinary", (void*)glShaderBinary, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLSHADERBINARYPROC glad_debug_glShaderBinary = glad_debug_impl_glShaderBinary;
PFNGLSHADERSOURCEPROC glad_glShaderSource;
void APIENTRY glad_debug_impl_glShaderSource(GLuint arg0, GLsizei arg1, const GLchar *const* arg2, const GLint * arg3) {    
    _pre_call_callback_gl("glShaderSource", (void*)glShaderSource, 4, arg0, arg1, arg2, arg3);
     glad_glShaderSource(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glShaderSource", (void*)glShaderSource, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLSHADERSOURCEPROC glad_debug_glShaderSource = glad_debug_impl_glShaderSource;
PFNGLSTENCILFUNCPROC glad_glStencilFunc;
void APIENTRY glad_debug_impl_glStencilFunc(GLenum arg0, GLint arg1, GLuint arg2) {    
    _pre_call_callback_gl("glStencilFunc", (void*)glStencilFunc, 3, arg0, arg1, arg2);
     glad_glStencilFunc(arg0, arg1, arg2);
    _post_call_callback_gl("glStencilFunc", (void*)glStencilFunc, 3, arg0, arg1, arg2);
    
}
PFNGLSTENCILFUNCPROC glad_debug_glStencilFunc = glad_debug_impl_glStencilFunc;
PFNGLSTENCILFUNCSEPARATEPROC glad_glStencilFuncSeparate;
void APIENTRY glad_debug_impl_glStencilFuncSeparate(GLenum arg0, GLenum arg1, GLint arg2, GLuint arg3) {    
    _pre_call_callback_gl("glStencilFuncSeparate", (void*)glStencilFuncSeparate, 4, arg0, arg1, arg2, arg3);
     glad_glStencilFuncSeparate(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glStencilFuncSeparate", (void*)glStencilFuncSeparate, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLSTENCILFUNCSEPARATEPROC glad_debug_glStencilFuncSeparate = glad_debug_impl_glStencilFuncSeparate;
PFNGLSTENCILMASKPROC glad_glStencilMask;
void APIENTRY glad_debug_impl_glStencilMask(GLuint arg0) {    
    _pre_call_callback_gl("glStencilMask", (void*)glStencilMask, 1, arg0);
     glad_glStencilMask(arg0);
    _post_call_callback_gl("glStencilMask", (void*)glStencilMask, 1, arg0);
    
}
PFNGLSTENCILMASKPROC glad_debug_glStencilMask = glad_debug_impl_glStencilMask;
PFNGLSTENCILMASKSEPARATEPROC glad_glStencilMaskSeparate;
void APIENTRY glad_debug_impl_glStencilMaskSeparate(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glStencilMaskSeparate", (void*)glStencilMaskSeparate, 2, arg0, arg1);
     glad_glStencilMaskSeparate(arg0, arg1);
    _post_call_callback_gl("glStencilMaskSeparate", (void*)glStencilMaskSeparate, 2, arg0, arg1);
    
}
PFNGLSTENCILMASKSEPARATEPROC glad_debug_glStencilMaskSeparate = glad_debug_impl_glStencilMaskSeparate;
PFNGLSTENCILOPPROC glad_glStencilOp;
void APIENTRY glad_debug_impl_glStencilOp(GLenum arg0, GLenum arg1, GLenum arg2) {    
    _pre_call_callback_gl("glStencilOp", (void*)glStencilOp, 3, arg0, arg1, arg2);
     glad_glStencilOp(arg0, arg1, arg2);
    _post_call_callback_gl("glStencilOp", (void*)glStencilOp, 3, arg0, arg1, arg2);
    
}
PFNGLSTENCILOPPROC glad_debug_glStencilOp = glad_debug_impl_glStencilOp;
PFNGLSTENCILOPSEPARATEPROC glad_glStencilOpSeparate;
void APIENTRY glad_debug_impl_glStencilOpSeparate(GLenum arg0, GLenum arg1, GLenum arg2, GLenum arg3) {    
    _pre_call_callback_gl("glStencilOpSeparate", (void*)glStencilOpSeparate, 4, arg0, arg1, arg2, arg3);
     glad_glStencilOpSeparate(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glStencilOpSeparate", (void*)glStencilOpSeparate, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLSTENCILOPSEPARATEPROC glad_debug_glStencilOpSeparate = glad_debug_impl_glStencilOpSeparate;
PFNGLTEXBUFFERPROC glad_glTexBuffer;
void APIENTRY glad_debug_impl_glTexBuffer(GLenum arg0, GLenum arg1, GLuint arg2) {    
    _pre_call_callback_gl("glTexBuffer", (void*)glTexBuffer, 3, arg0, arg1, arg2);
     glad_glTexBuffer(arg0, arg1, arg2);
    _post_call_callback_gl("glTexBuffer", (void*)glTexBuffer, 3, arg0, arg1, arg2);
    
}
PFNGLTEXBUFFERPROC glad_debug_glTexBuffer = glad_debug_impl_glTexBuffer;
PFNGLTEXCOORDP1UIPROC glad_glTexCoordP1ui;
void APIENTRY glad_debug_impl_glTexCoordP1ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glTexCoordP1ui", (void*)glTexCoordP1ui, 2, arg0, arg1);
     glad_glTexCoordP1ui(arg0, arg1);
    _post_call_callback_gl("glTexCoordP1ui", (void*)glTexCoordP1ui, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP1UIPROC glad_debug_glTexCoordP1ui = glad_debug_impl_glTexCoordP1ui;
PFNGLTEXCOORDP1UIVPROC glad_glTexCoordP1uiv;
void APIENTRY glad_debug_impl_glTexCoordP1uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glTexCoordP1uiv", (void*)glTexCoordP1uiv, 2, arg0, arg1);
     glad_glTexCoordP1uiv(arg0, arg1);
    _post_call_callback_gl("glTexCoordP1uiv", (void*)glTexCoordP1uiv, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP1UIVPROC glad_debug_glTexCoordP1uiv = glad_debug_impl_glTexCoordP1uiv;
PFNGLTEXCOORDP2UIPROC glad_glTexCoordP2ui;
void APIENTRY glad_debug_impl_glTexCoordP2ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glTexCoordP2ui", (void*)glTexCoordP2ui, 2, arg0, arg1);
     glad_glTexCoordP2ui(arg0, arg1);
    _post_call_callback_gl("glTexCoordP2ui", (void*)glTexCoordP2ui, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP2UIPROC glad_debug_glTexCoordP2ui = glad_debug_impl_glTexCoordP2ui;
PFNGLTEXCOORDP2UIVPROC glad_glTexCoordP2uiv;
void APIENTRY glad_debug_impl_glTexCoordP2uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glTexCoordP2uiv", (void*)glTexCoordP2uiv, 2, arg0, arg1);
     glad_glTexCoordP2uiv(arg0, arg1);
    _post_call_callback_gl("glTexCoordP2uiv", (void*)glTexCoordP2uiv, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP2UIVPROC glad_debug_glTexCoordP2uiv = glad_debug_impl_glTexCoordP2uiv;
PFNGLTEXCOORDP3UIPROC glad_glTexCoordP3ui;
void APIENTRY glad_debug_impl_glTexCoordP3ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glTexCoordP3ui", (void*)glTexCoordP3ui, 2, arg0, arg1);
     glad_glTexCoordP3ui(arg0, arg1);
    _post_call_callback_gl("glTexCoordP3ui", (void*)glTexCoordP3ui, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP3UIPROC glad_debug_glTexCoordP3ui = glad_debug_impl_glTexCoordP3ui;
PFNGLTEXCOORDP3UIVPROC glad_glTexCoordP3uiv;
void APIENTRY glad_debug_impl_glTexCoordP3uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glTexCoordP3uiv", (void*)glTexCoordP3uiv, 2, arg0, arg1);
     glad_glTexCoordP3uiv(arg0, arg1);
    _post_call_callback_gl("glTexCoordP3uiv", (void*)glTexCoordP3uiv, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP3UIVPROC glad_debug_glTexCoordP3uiv = glad_debug_impl_glTexCoordP3uiv;
PFNGLTEXCOORDP4UIPROC glad_glTexCoordP4ui;
void APIENTRY glad_debug_impl_glTexCoordP4ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glTexCoordP4ui", (void*)glTexCoordP4ui, 2, arg0, arg1);
     glad_glTexCoordP4ui(arg0, arg1);
    _post_call_callback_gl("glTexCoordP4ui", (void*)glTexCoordP4ui, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP4UIPROC glad_debug_glTexCoordP4ui = glad_debug_impl_glTexCoordP4ui;
PFNGLTEXCOORDP4UIVPROC glad_glTexCoordP4uiv;
void APIENTRY glad_debug_impl_glTexCoordP4uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glTexCoordP4uiv", (void*)glTexCoordP4uiv, 2, arg0, arg1);
     glad_glTexCoordP4uiv(arg0, arg1);
    _post_call_callback_gl("glTexCoordP4uiv", (void*)glTexCoordP4uiv, 2, arg0, arg1);
    
}
PFNGLTEXCOORDP4UIVPROC glad_debug_glTexCoordP4uiv = glad_debug_impl_glTexCoordP4uiv;
PFNGLTEXIMAGE1DPROC glad_glTexImage1D;
void APIENTRY glad_debug_impl_glTexImage1D(GLenum arg0, GLint arg1, GLint arg2, GLsizei arg3, GLint arg4, GLenum arg5, GLenum arg6, const void * arg7) {    
    _pre_call_callback_gl("glTexImage1D", (void*)glTexImage1D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
     glad_glTexImage1D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    _post_call_callback_gl("glTexImage1D", (void*)glTexImage1D, 8, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    
}
PFNGLTEXIMAGE1DPROC glad_debug_glTexImage1D = glad_debug_impl_glTexImage1D;
PFNGLTEXIMAGE2DPROC glad_glTexImage2D;
void APIENTRY glad_debug_impl_glTexImage2D(GLenum arg0, GLint arg1, GLint arg2, GLsizei arg3, GLsizei arg4, GLint arg5, GLenum arg6, GLenum arg7, const void * arg8) {    
    _pre_call_callback_gl("glTexImage2D", (void*)glTexImage2D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
     glad_glTexImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    _post_call_callback_gl("glTexImage2D", (void*)glTexImage2D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    
}
PFNGLTEXIMAGE2DPROC glad_debug_glTexImage2D = glad_debug_impl_glTexImage2D;
PFNGLTEXIMAGE2DMULTISAMPLEPROC glad_glTexImage2DMultisample;
void APIENTRY glad_debug_impl_glTexImage2DMultisample(GLenum arg0, GLsizei arg1, GLenum arg2, GLsizei arg3, GLsizei arg4, GLboolean arg5) {    
    _pre_call_callback_gl("glTexImage2DMultisample", (void*)glTexImage2DMultisample, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glTexImage2DMultisample(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glTexImage2DMultisample", (void*)glTexImage2DMultisample, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLTEXIMAGE2DMULTISAMPLEPROC glad_debug_glTexImage2DMultisample = glad_debug_impl_glTexImage2DMultisample;
PFNGLTEXIMAGE3DPROC glad_glTexImage3D;
void APIENTRY glad_debug_impl_glTexImage3D(GLenum arg0, GLint arg1, GLint arg2, GLsizei arg3, GLsizei arg4, GLsizei arg5, GLint arg6, GLenum arg7, GLenum arg8, const void * arg9) {    
    _pre_call_callback_gl("glTexImage3D", (void*)glTexImage3D, 10, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
     glad_glTexImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    _post_call_callback_gl("glTexImage3D", (void*)glTexImage3D, 10, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    
}
PFNGLTEXIMAGE3DPROC glad_debug_glTexImage3D = glad_debug_impl_glTexImage3D;
PFNGLTEXIMAGE3DMULTISAMPLEPROC glad_glTexImage3DMultisample;
void APIENTRY glad_debug_impl_glTexImage3DMultisample(GLenum arg0, GLsizei arg1, GLenum arg2, GLsizei arg3, GLsizei arg4, GLsizei arg5, GLboolean arg6) {    
    _pre_call_callback_gl("glTexImage3DMultisample", (void*)glTexImage3DMultisample, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glTexImage3DMultisample(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glTexImage3DMultisample", (void*)glTexImage3DMultisample, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLTEXIMAGE3DMULTISAMPLEPROC glad_debug_glTexImage3DMultisample = glad_debug_impl_glTexImage3DMultisample;
PFNGLTEXPARAMETERIIVPROC glad_glTexParameterIiv;
void APIENTRY glad_debug_impl_glTexParameterIiv(GLenum arg0, GLenum arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glTexParameterIiv", (void*)glTexParameterIiv, 3, arg0, arg1, arg2);
     glad_glTexParameterIiv(arg0, arg1, arg2);
    _post_call_callback_gl("glTexParameterIiv", (void*)glTexParameterIiv, 3, arg0, arg1, arg2);
    
}
PFNGLTEXPARAMETERIIVPROC glad_debug_glTexParameterIiv = glad_debug_impl_glTexParameterIiv;
PFNGLTEXPARAMETERIUIVPROC glad_glTexParameterIuiv;
void APIENTRY glad_debug_impl_glTexParameterIuiv(GLenum arg0, GLenum arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glTexParameterIuiv", (void*)glTexParameterIuiv, 3, arg0, arg1, arg2);
     glad_glTexParameterIuiv(arg0, arg1, arg2);
    _post_call_callback_gl("glTexParameterIuiv", (void*)glTexParameterIuiv, 3, arg0, arg1, arg2);
    
}
PFNGLTEXPARAMETERIUIVPROC glad_debug_glTexParameterIuiv = glad_debug_impl_glTexParameterIuiv;
PFNGLTEXPARAMETERFPROC glad_glTexParameterf;
void APIENTRY glad_debug_impl_glTexParameterf(GLenum arg0, GLenum arg1, GLfloat arg2) {    
    _pre_call_callback_gl("glTexParameterf", (void*)glTexParameterf, 3, arg0, arg1, arg2);
     glad_glTexParameterf(arg0, arg1, arg2);
    _post_call_callback_gl("glTexParameterf", (void*)glTexParameterf, 3, arg0, arg1, arg2);
    
}
PFNGLTEXPARAMETERFPROC glad_debug_glTexParameterf = glad_debug_impl_glTexParameterf;
PFNGLTEXPARAMETERFVPROC glad_glTexParameterfv;
void APIENTRY glad_debug_impl_glTexParameterfv(GLenum arg0, GLenum arg1, const GLfloat * arg2) {    
    _pre_call_callback_gl("glTexParameterfv", (void*)glTexParameterfv, 3, arg0, arg1, arg2);
     glad_glTexParameterfv(arg0, arg1, arg2);
    _post_call_callback_gl("glTexParameterfv", (void*)glTexParameterfv, 3, arg0, arg1, arg2);
    
}
PFNGLTEXPARAMETERFVPROC glad_debug_glTexParameterfv = glad_debug_impl_glTexParameterfv;
PFNGLTEXPARAMETERIPROC glad_glTexParameteri;
void APIENTRY glad_debug_impl_glTexParameteri(GLenum arg0, GLenum arg1, GLint arg2) {    
    _pre_call_callback_gl("glTexParameteri", (void*)glTexParameteri, 3, arg0, arg1, arg2);
     glad_glTexParameteri(arg0, arg1, arg2);
    _post_call_callback_gl("glTexParameteri", (void*)glTexParameteri, 3, arg0, arg1, arg2);
    
}
PFNGLTEXPARAMETERIPROC glad_debug_glTexParameteri = glad_debug_impl_glTexParameteri;
PFNGLTEXPARAMETERIVPROC glad_glTexParameteriv;
void APIENTRY glad_debug_impl_glTexParameteriv(GLenum arg0, GLenum arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glTexParameteriv", (void*)glTexParameteriv, 3, arg0, arg1, arg2);
     glad_glTexParameteriv(arg0, arg1, arg2);
    _post_call_callback_gl("glTexParameteriv", (void*)glTexParameteriv, 3, arg0, arg1, arg2);
    
}
PFNGLTEXPARAMETERIVPROC glad_debug_glTexParameteriv = glad_debug_impl_glTexParameteriv;
PFNGLTEXSTORAGE2DPROC glad_glTexStorage2D;
void APIENTRY glad_debug_impl_glTexStorage2D(GLenum arg0, GLsizei arg1, GLenum arg2, GLsizei arg3, GLsizei arg4) {    
    _pre_call_callback_gl("glTexStorage2D", (void*)glTexStorage2D, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glTexStorage2D(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glTexStorage2D", (void*)glTexStorage2D, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLTEXSTORAGE2DPROC glad_debug_glTexStorage2D = glad_debug_impl_glTexStorage2D;
PFNGLTEXSTORAGE3DPROC glad_glTexStorage3D;
void APIENTRY glad_debug_impl_glTexStorage3D(GLenum arg0, GLsizei arg1, GLenum arg2, GLsizei arg3, GLsizei arg4, GLsizei arg5) {    
    _pre_call_callback_gl("glTexStorage3D", (void*)glTexStorage3D, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glTexStorage3D(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glTexStorage3D", (void*)glTexStorage3D, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLTEXSTORAGE3DPROC glad_debug_glTexStorage3D = glad_debug_impl_glTexStorage3D;
PFNGLTEXSUBIMAGE1DPROC glad_glTexSubImage1D;
void APIENTRY glad_debug_impl_glTexSubImage1D(GLenum arg0, GLint arg1, GLint arg2, GLsizei arg3, GLenum arg4, GLenum arg5, const void * arg6) {    
    _pre_call_callback_gl("glTexSubImage1D", (void*)glTexSubImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
     glad_glTexSubImage1D(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    _post_call_callback_gl("glTexSubImage1D", (void*)glTexSubImage1D, 7, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    
}
PFNGLTEXSUBIMAGE1DPROC glad_debug_glTexSubImage1D = glad_debug_impl_glTexSubImage1D;
PFNGLTEXSUBIMAGE2DPROC glad_glTexSubImage2D;
void APIENTRY glad_debug_impl_glTexSubImage2D(GLenum arg0, GLint arg1, GLint arg2, GLint arg3, GLsizei arg4, GLsizei arg5, GLenum arg6, GLenum arg7, const void * arg8) {    
    _pre_call_callback_gl("glTexSubImage2D", (void*)glTexSubImage2D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
     glad_glTexSubImage2D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    _post_call_callback_gl("glTexSubImage2D", (void*)glTexSubImage2D, 9, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    
}
PFNGLTEXSUBIMAGE2DPROC glad_debug_glTexSubImage2D = glad_debug_impl_glTexSubImage2D;
PFNGLTEXSUBIMAGE3DPROC glad_glTexSubImage3D;
void APIENTRY glad_debug_impl_glTexSubImage3D(GLenum arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4, GLsizei arg5, GLsizei arg6, GLsizei arg7, GLenum arg8, GLenum arg9, const void * arg10) {    
    _pre_call_callback_gl("glTexSubImage3D", (void*)glTexSubImage3D, 11, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
     glad_glTexSubImage3D(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    _post_call_callback_gl("glTexSubImage3D", (void*)glTexSubImage3D, 11, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    
}
PFNGLTEXSUBIMAGE3DPROC glad_debug_glTexSubImage3D = glad_debug_impl_glTexSubImage3D;
PFNGLTRANSFORMFEEDBACKVARYINGSPROC glad_glTransformFeedbackVaryings;
void APIENTRY glad_debug_impl_glTransformFeedbackVaryings(GLuint arg0, GLsizei arg1, const GLchar *const* arg2, GLenum arg3) {    
    _pre_call_callback_gl("glTransformFeedbackVaryings", (void*)glTransformFeedbackVaryings, 4, arg0, arg1, arg2, arg3);
     glad_glTransformFeedbackVaryings(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glTransformFeedbackVaryings", (void*)glTransformFeedbackVaryings, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLTRANSFORMFEEDBACKVARYINGSPROC glad_debug_glTransformFeedbackVaryings = glad_debug_impl_glTransformFeedbackVaryings;
PFNGLUNIFORM1FPROC glad_glUniform1f;
void APIENTRY glad_debug_impl_glUniform1f(GLint arg0, GLfloat arg1) {    
    _pre_call_callback_gl("glUniform1f", (void*)glUniform1f, 2, arg0, arg1);
     glad_glUniform1f(arg0, arg1);
    _post_call_callback_gl("glUniform1f", (void*)glUniform1f, 2, arg0, arg1);
    
}
PFNGLUNIFORM1FPROC glad_debug_glUniform1f = glad_debug_impl_glUniform1f;
PFNGLUNIFORM1FVPROC glad_glUniform1fv;
void APIENTRY glad_debug_impl_glUniform1fv(GLint arg0, GLsizei arg1, const GLfloat * arg2) {    
    _pre_call_callback_gl("glUniform1fv", (void*)glUniform1fv, 3, arg0, arg1, arg2);
     glad_glUniform1fv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform1fv", (void*)glUniform1fv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM1FVPROC glad_debug_glUniform1fv = glad_debug_impl_glUniform1fv;
PFNGLUNIFORM1IPROC glad_glUniform1i;
void APIENTRY glad_debug_impl_glUniform1i(GLint arg0, GLint arg1) {    
    _pre_call_callback_gl("glUniform1i", (void*)glUniform1i, 2, arg0, arg1);
     glad_glUniform1i(arg0, arg1);
    _post_call_callback_gl("glUniform1i", (void*)glUniform1i, 2, arg0, arg1);
    
}
PFNGLUNIFORM1IPROC glad_debug_glUniform1i = glad_debug_impl_glUniform1i;
PFNGLUNIFORM1IVPROC glad_glUniform1iv;
void APIENTRY glad_debug_impl_glUniform1iv(GLint arg0, GLsizei arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glUniform1iv", (void*)glUniform1iv, 3, arg0, arg1, arg2);
     glad_glUniform1iv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform1iv", (void*)glUniform1iv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM1IVPROC glad_debug_glUniform1iv = glad_debug_impl_glUniform1iv;
PFNGLUNIFORM1UIPROC glad_glUniform1ui;
void APIENTRY glad_debug_impl_glUniform1ui(GLint arg0, GLuint arg1) {    
    _pre_call_callback_gl("glUniform1ui", (void*)glUniform1ui, 2, arg0, arg1);
     glad_glUniform1ui(arg0, arg1);
    _post_call_callback_gl("glUniform1ui", (void*)glUniform1ui, 2, arg0, arg1);
    
}
PFNGLUNIFORM1UIPROC glad_debug_glUniform1ui = glad_debug_impl_glUniform1ui;
PFNGLUNIFORM1UIVPROC glad_glUniform1uiv;
void APIENTRY glad_debug_impl_glUniform1uiv(GLint arg0, GLsizei arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glUniform1uiv", (void*)glUniform1uiv, 3, arg0, arg1, arg2);
     glad_glUniform1uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform1uiv", (void*)glUniform1uiv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM1UIVPROC glad_debug_glUniform1uiv = glad_debug_impl_glUniform1uiv;
PFNGLUNIFORM2FPROC glad_glUniform2f;
void APIENTRY glad_debug_impl_glUniform2f(GLint arg0, GLfloat arg1, GLfloat arg2) {    
    _pre_call_callback_gl("glUniform2f", (void*)glUniform2f, 3, arg0, arg1, arg2);
     glad_glUniform2f(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform2f", (void*)glUniform2f, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM2FPROC glad_debug_glUniform2f = glad_debug_impl_glUniform2f;
PFNGLUNIFORM2FVPROC glad_glUniform2fv;
void APIENTRY glad_debug_impl_glUniform2fv(GLint arg0, GLsizei arg1, const GLfloat * arg2) {    
    _pre_call_callback_gl("glUniform2fv", (void*)glUniform2fv, 3, arg0, arg1, arg2);
     glad_glUniform2fv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform2fv", (void*)glUniform2fv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM2FVPROC glad_debug_glUniform2fv = glad_debug_impl_glUniform2fv;
PFNGLUNIFORM2IPROC glad_glUniform2i;
void APIENTRY glad_debug_impl_glUniform2i(GLint arg0, GLint arg1, GLint arg2) {    
    _pre_call_callback_gl("glUniform2i", (void*)glUniform2i, 3, arg0, arg1, arg2);
     glad_glUniform2i(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform2i", (void*)glUniform2i, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM2IPROC glad_debug_glUniform2i = glad_debug_impl_glUniform2i;
PFNGLUNIFORM2IVPROC glad_glUniform2iv;
void APIENTRY glad_debug_impl_glUniform2iv(GLint arg0, GLsizei arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glUniform2iv", (void*)glUniform2iv, 3, arg0, arg1, arg2);
     glad_glUniform2iv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform2iv", (void*)glUniform2iv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM2IVPROC glad_debug_glUniform2iv = glad_debug_impl_glUniform2iv;
PFNGLUNIFORM2UIPROC glad_glUniform2ui;
void APIENTRY glad_debug_impl_glUniform2ui(GLint arg0, GLuint arg1, GLuint arg2) {    
    _pre_call_callback_gl("glUniform2ui", (void*)glUniform2ui, 3, arg0, arg1, arg2);
     glad_glUniform2ui(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform2ui", (void*)glUniform2ui, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM2UIPROC glad_debug_glUniform2ui = glad_debug_impl_glUniform2ui;
PFNGLUNIFORM2UIVPROC glad_glUniform2uiv;
void APIENTRY glad_debug_impl_glUniform2uiv(GLint arg0, GLsizei arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glUniform2uiv", (void*)glUniform2uiv, 3, arg0, arg1, arg2);
     glad_glUniform2uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform2uiv", (void*)glUniform2uiv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM2UIVPROC glad_debug_glUniform2uiv = glad_debug_impl_glUniform2uiv;
PFNGLUNIFORM3FPROC glad_glUniform3f;
void APIENTRY glad_debug_impl_glUniform3f(GLint arg0, GLfloat arg1, GLfloat arg2, GLfloat arg3) {    
    _pre_call_callback_gl("glUniform3f", (void*)glUniform3f, 4, arg0, arg1, arg2, arg3);
     glad_glUniform3f(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniform3f", (void*)glUniform3f, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORM3FPROC glad_debug_glUniform3f = glad_debug_impl_glUniform3f;
PFNGLUNIFORM3FVPROC glad_glUniform3fv;
void APIENTRY glad_debug_impl_glUniform3fv(GLint arg0, GLsizei arg1, const GLfloat * arg2) {    
    _pre_call_callback_gl("glUniform3fv", (void*)glUniform3fv, 3, arg0, arg1, arg2);
     glad_glUniform3fv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform3fv", (void*)glUniform3fv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM3FVPROC glad_debug_glUniform3fv = glad_debug_impl_glUniform3fv;
PFNGLUNIFORM3IPROC glad_glUniform3i;
void APIENTRY glad_debug_impl_glUniform3i(GLint arg0, GLint arg1, GLint arg2, GLint arg3) {    
    _pre_call_callback_gl("glUniform3i", (void*)glUniform3i, 4, arg0, arg1, arg2, arg3);
     glad_glUniform3i(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniform3i", (void*)glUniform3i, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORM3IPROC glad_debug_glUniform3i = glad_debug_impl_glUniform3i;
PFNGLUNIFORM3IVPROC glad_glUniform3iv;
void APIENTRY glad_debug_impl_glUniform3iv(GLint arg0, GLsizei arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glUniform3iv", (void*)glUniform3iv, 3, arg0, arg1, arg2);
     glad_glUniform3iv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform3iv", (void*)glUniform3iv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM3IVPROC glad_debug_glUniform3iv = glad_debug_impl_glUniform3iv;
PFNGLUNIFORM3UIPROC glad_glUniform3ui;
void APIENTRY glad_debug_impl_glUniform3ui(GLint arg0, GLuint arg1, GLuint arg2, GLuint arg3) {    
    _pre_call_callback_gl("glUniform3ui", (void*)glUniform3ui, 4, arg0, arg1, arg2, arg3);
     glad_glUniform3ui(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniform3ui", (void*)glUniform3ui, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORM3UIPROC glad_debug_glUniform3ui = glad_debug_impl_glUniform3ui;
PFNGLUNIFORM3UIVPROC glad_glUniform3uiv;
void APIENTRY glad_debug_impl_glUniform3uiv(GLint arg0, GLsizei arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glUniform3uiv", (void*)glUniform3uiv, 3, arg0, arg1, arg2);
     glad_glUniform3uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform3uiv", (void*)glUniform3uiv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM3UIVPROC glad_debug_glUniform3uiv = glad_debug_impl_glUniform3uiv;
PFNGLUNIFORM4FPROC glad_glUniform4f;
void APIENTRY glad_debug_impl_glUniform4f(GLint arg0, GLfloat arg1, GLfloat arg2, GLfloat arg3, GLfloat arg4) {    
    _pre_call_callback_gl("glUniform4f", (void*)glUniform4f, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glUniform4f(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glUniform4f", (void*)glUniform4f, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLUNIFORM4FPROC glad_debug_glUniform4f = glad_debug_impl_glUniform4f;
PFNGLUNIFORM4FVPROC glad_glUniform4fv;
void APIENTRY glad_debug_impl_glUniform4fv(GLint arg0, GLsizei arg1, const GLfloat * arg2) {    
    _pre_call_callback_gl("glUniform4fv", (void*)glUniform4fv, 3, arg0, arg1, arg2);
     glad_glUniform4fv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform4fv", (void*)glUniform4fv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM4FVPROC glad_debug_glUniform4fv = glad_debug_impl_glUniform4fv;
PFNGLUNIFORM4IPROC glad_glUniform4i;
void APIENTRY glad_debug_impl_glUniform4i(GLint arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4) {    
    _pre_call_callback_gl("glUniform4i", (void*)glUniform4i, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glUniform4i(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glUniform4i", (void*)glUniform4i, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLUNIFORM4IPROC glad_debug_glUniform4i = glad_debug_impl_glUniform4i;
PFNGLUNIFORM4IVPROC glad_glUniform4iv;
void APIENTRY glad_debug_impl_glUniform4iv(GLint arg0, GLsizei arg1, const GLint * arg2) {    
    _pre_call_callback_gl("glUniform4iv", (void*)glUniform4iv, 3, arg0, arg1, arg2);
     glad_glUniform4iv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform4iv", (void*)glUniform4iv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM4IVPROC glad_debug_glUniform4iv = glad_debug_impl_glUniform4iv;
PFNGLUNIFORM4UIPROC glad_glUniform4ui;
void APIENTRY glad_debug_impl_glUniform4ui(GLint arg0, GLuint arg1, GLuint arg2, GLuint arg3, GLuint arg4) {    
    _pre_call_callback_gl("glUniform4ui", (void*)glUniform4ui, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glUniform4ui(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glUniform4ui", (void*)glUniform4ui, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLUNIFORM4UIPROC glad_debug_glUniform4ui = glad_debug_impl_glUniform4ui;
PFNGLUNIFORM4UIVPROC glad_glUniform4uiv;
void APIENTRY glad_debug_impl_glUniform4uiv(GLint arg0, GLsizei arg1, const GLuint * arg2) {    
    _pre_call_callback_gl("glUniform4uiv", (void*)glUniform4uiv, 3, arg0, arg1, arg2);
     glad_glUniform4uiv(arg0, arg1, arg2);
    _post_call_callback_gl("glUniform4uiv", (void*)glUniform4uiv, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORM4UIVPROC glad_debug_glUniform4uiv = glad_debug_impl_glUniform4uiv;
PFNGLUNIFORMBLOCKBINDINGPROC glad_glUniformBlockBinding;
void APIENTRY glad_debug_impl_glUniformBlockBinding(GLuint arg0, GLuint arg1, GLuint arg2) {    
    _pre_call_callback_gl("glUniformBlockBinding", (void*)glUniformBlockBinding, 3, arg0, arg1, arg2);
     glad_glUniformBlockBinding(arg0, arg1, arg2);
    _post_call_callback_gl("glUniformBlockBinding", (void*)glUniformBlockBinding, 3, arg0, arg1, arg2);
    
}
PFNGLUNIFORMBLOCKBINDINGPROC glad_debug_glUniformBlockBinding = glad_debug_impl_glUniformBlockBinding;
PFNGLUNIFORMMATRIX2FVPROC glad_glUniformMatrix2fv;
void APIENTRY glad_debug_impl_glUniformMatrix2fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix2fv", (void*)glUniformMatrix2fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix2fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix2fv", (void*)glUniformMatrix2fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX2FVPROC glad_debug_glUniformMatrix2fv = glad_debug_impl_glUniformMatrix2fv;
PFNGLUNIFORMMATRIX2X3FVPROC glad_glUniformMatrix2x3fv;
void APIENTRY glad_debug_impl_glUniformMatrix2x3fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix2x3fv", (void*)glUniformMatrix2x3fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix2x3fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix2x3fv", (void*)glUniformMatrix2x3fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX2X3FVPROC glad_debug_glUniformMatrix2x3fv = glad_debug_impl_glUniformMatrix2x3fv;
PFNGLUNIFORMMATRIX2X4FVPROC glad_glUniformMatrix2x4fv;
void APIENTRY glad_debug_impl_glUniformMatrix2x4fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix2x4fv", (void*)glUniformMatrix2x4fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix2x4fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix2x4fv", (void*)glUniformMatrix2x4fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX2X4FVPROC glad_debug_glUniformMatrix2x4fv = glad_debug_impl_glUniformMatrix2x4fv;
PFNGLUNIFORMMATRIX3FVPROC glad_glUniformMatrix3fv;
void APIENTRY glad_debug_impl_glUniformMatrix3fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix3fv", (void*)glUniformMatrix3fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix3fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix3fv", (void*)glUniformMatrix3fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX3FVPROC glad_debug_glUniformMatrix3fv = glad_debug_impl_glUniformMatrix3fv;
PFNGLUNIFORMMATRIX3X2FVPROC glad_glUniformMatrix3x2fv;
void APIENTRY glad_debug_impl_glUniformMatrix3x2fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix3x2fv", (void*)glUniformMatrix3x2fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix3x2fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix3x2fv", (void*)glUniformMatrix3x2fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX3X2FVPROC glad_debug_glUniformMatrix3x2fv = glad_debug_impl_glUniformMatrix3x2fv;
PFNGLUNIFORMMATRIX3X4FVPROC glad_glUniformMatrix3x4fv;
void APIENTRY glad_debug_impl_glUniformMatrix3x4fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix3x4fv", (void*)glUniformMatrix3x4fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix3x4fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix3x4fv", (void*)glUniformMatrix3x4fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX3X4FVPROC glad_debug_glUniformMatrix3x4fv = glad_debug_impl_glUniformMatrix3x4fv;
PFNGLUNIFORMMATRIX4FVPROC glad_glUniformMatrix4fv;
void APIENTRY glad_debug_impl_glUniformMatrix4fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix4fv", (void*)glUniformMatrix4fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix4fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix4fv", (void*)glUniformMatrix4fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX4FVPROC glad_debug_glUniformMatrix4fv = glad_debug_impl_glUniformMatrix4fv;
PFNGLUNIFORMMATRIX4X2FVPROC glad_glUniformMatrix4x2fv;
void APIENTRY glad_debug_impl_glUniformMatrix4x2fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix4x2fv", (void*)glUniformMatrix4x2fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix4x2fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix4x2fv", (void*)glUniformMatrix4x2fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX4X2FVPROC glad_debug_glUniformMatrix4x2fv = glad_debug_impl_glUniformMatrix4x2fv;
PFNGLUNIFORMMATRIX4X3FVPROC glad_glUniformMatrix4x3fv;
void APIENTRY glad_debug_impl_glUniformMatrix4x3fv(GLint arg0, GLsizei arg1, GLboolean arg2, const GLfloat * arg3) {    
    _pre_call_callback_gl("glUniformMatrix4x3fv", (void*)glUniformMatrix4x3fv, 4, arg0, arg1, arg2, arg3);
     glad_glUniformMatrix4x3fv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glUniformMatrix4x3fv", (void*)glUniformMatrix4x3fv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLUNIFORMMATRIX4X3FVPROC glad_debug_glUniformMatrix4x3fv = glad_debug_impl_glUniformMatrix4x3fv;
PFNGLUNMAPBUFFERPROC glad_glUnmapBuffer;
GLboolean APIENTRY glad_debug_impl_glUnmapBuffer(GLenum arg0) {    
    GLboolean ret;
    _pre_call_callback_gl("glUnmapBuffer", (void*)glUnmapBuffer, 1, arg0);
    ret =  glad_glUnmapBuffer(arg0);
    _post_call_callback_gl("glUnmapBuffer", (void*)glUnmapBuffer, 1, arg0);
    return ret;
}
PFNGLUNMAPBUFFERPROC glad_debug_glUnmapBuffer = glad_debug_impl_glUnmapBuffer;
PFNGLUSEPROGRAMPROC glad_glUseProgram;
void APIENTRY glad_debug_impl_glUseProgram(GLuint arg0) {    
    _pre_call_callback_gl("glUseProgram", (void*)glUseProgram, 1, arg0);
     glad_glUseProgram(arg0);
    _post_call_callback_gl("glUseProgram", (void*)glUseProgram, 1, arg0);
    
}
PFNGLUSEPROGRAMPROC glad_debug_glUseProgram = glad_debug_impl_glUseProgram;
PFNGLVALIDATEPROGRAMPROC glad_glValidateProgram;
void APIENTRY glad_debug_impl_glValidateProgram(GLuint arg0) {    
    _pre_call_callback_gl("glValidateProgram", (void*)glValidateProgram, 1, arg0);
     glad_glValidateProgram(arg0);
    _post_call_callback_gl("glValidateProgram", (void*)glValidateProgram, 1, arg0);
    
}
PFNGLVALIDATEPROGRAMPROC glad_debug_glValidateProgram = glad_debug_impl_glValidateProgram;
PFNGLVERTEXATTRIB1DPROC glad_glVertexAttrib1d;
void APIENTRY glad_debug_impl_glVertexAttrib1d(GLuint arg0, GLdouble arg1) {    
    _pre_call_callback_gl("glVertexAttrib1d", (void*)glVertexAttrib1d, 2, arg0, arg1);
     glad_glVertexAttrib1d(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib1d", (void*)glVertexAttrib1d, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB1DPROC glad_debug_glVertexAttrib1d = glad_debug_impl_glVertexAttrib1d;
PFNGLVERTEXATTRIB1DVPROC glad_glVertexAttrib1dv;
void APIENTRY glad_debug_impl_glVertexAttrib1dv(GLuint arg0, const GLdouble * arg1) {    
    _pre_call_callback_gl("glVertexAttrib1dv", (void*)glVertexAttrib1dv, 2, arg0, arg1);
     glad_glVertexAttrib1dv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib1dv", (void*)glVertexAttrib1dv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB1DVPROC glad_debug_glVertexAttrib1dv = glad_debug_impl_glVertexAttrib1dv;
PFNGLVERTEXATTRIB1FPROC glad_glVertexAttrib1f;
void APIENTRY glad_debug_impl_glVertexAttrib1f(GLuint arg0, GLfloat arg1) {    
    _pre_call_callback_gl("glVertexAttrib1f", (void*)glVertexAttrib1f, 2, arg0, arg1);
     glad_glVertexAttrib1f(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib1f", (void*)glVertexAttrib1f, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB1FPROC glad_debug_glVertexAttrib1f = glad_debug_impl_glVertexAttrib1f;
PFNGLVERTEXATTRIB1FVPROC glad_glVertexAttrib1fv;
void APIENTRY glad_debug_impl_glVertexAttrib1fv(GLuint arg0, const GLfloat * arg1) {    
    _pre_call_callback_gl("glVertexAttrib1fv", (void*)glVertexAttrib1fv, 2, arg0, arg1);
     glad_glVertexAttrib1fv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib1fv", (void*)glVertexAttrib1fv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB1FVPROC glad_debug_glVertexAttrib1fv = glad_debug_impl_glVertexAttrib1fv;
PFNGLVERTEXATTRIB1SPROC glad_glVertexAttrib1s;
void APIENTRY glad_debug_impl_glVertexAttrib1s(GLuint arg0, GLshort arg1) {    
    _pre_call_callback_gl("glVertexAttrib1s", (void*)glVertexAttrib1s, 2, arg0, arg1);
     glad_glVertexAttrib1s(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib1s", (void*)glVertexAttrib1s, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB1SPROC glad_debug_glVertexAttrib1s = glad_debug_impl_glVertexAttrib1s;
PFNGLVERTEXATTRIB1SVPROC glad_glVertexAttrib1sv;
void APIENTRY glad_debug_impl_glVertexAttrib1sv(GLuint arg0, const GLshort * arg1) {    
    _pre_call_callback_gl("glVertexAttrib1sv", (void*)glVertexAttrib1sv, 2, arg0, arg1);
     glad_glVertexAttrib1sv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib1sv", (void*)glVertexAttrib1sv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB1SVPROC glad_debug_glVertexAttrib1sv = glad_debug_impl_glVertexAttrib1sv;
PFNGLVERTEXATTRIB2DPROC glad_glVertexAttrib2d;
void APIENTRY glad_debug_impl_glVertexAttrib2d(GLuint arg0, GLdouble arg1, GLdouble arg2) {    
    _pre_call_callback_gl("glVertexAttrib2d", (void*)glVertexAttrib2d, 3, arg0, arg1, arg2);
     glad_glVertexAttrib2d(arg0, arg1, arg2);
    _post_call_callback_gl("glVertexAttrib2d", (void*)glVertexAttrib2d, 3, arg0, arg1, arg2);
    
}
PFNGLVERTEXATTRIB2DPROC glad_debug_glVertexAttrib2d = glad_debug_impl_glVertexAttrib2d;
PFNGLVERTEXATTRIB2DVPROC glad_glVertexAttrib2dv;
void APIENTRY glad_debug_impl_glVertexAttrib2dv(GLuint arg0, const GLdouble * arg1) {    
    _pre_call_callback_gl("glVertexAttrib2dv", (void*)glVertexAttrib2dv, 2, arg0, arg1);
     glad_glVertexAttrib2dv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib2dv", (void*)glVertexAttrib2dv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB2DVPROC glad_debug_glVertexAttrib2dv = glad_debug_impl_glVertexAttrib2dv;
PFNGLVERTEXATTRIB2FPROC glad_glVertexAttrib2f;
void APIENTRY glad_debug_impl_glVertexAttrib2f(GLuint arg0, GLfloat arg1, GLfloat arg2) {    
    _pre_call_callback_gl("glVertexAttrib2f", (void*)glVertexAttrib2f, 3, arg0, arg1, arg2);
     glad_glVertexAttrib2f(arg0, arg1, arg2);
    _post_call_callback_gl("glVertexAttrib2f", (void*)glVertexAttrib2f, 3, arg0, arg1, arg2);
    
}
PFNGLVERTEXATTRIB2FPROC glad_debug_glVertexAttrib2f = glad_debug_impl_glVertexAttrib2f;
PFNGLVERTEXATTRIB2FVPROC glad_glVertexAttrib2fv;
void APIENTRY glad_debug_impl_glVertexAttrib2fv(GLuint arg0, const GLfloat * arg1) {    
    _pre_call_callback_gl("glVertexAttrib2fv", (void*)glVertexAttrib2fv, 2, arg0, arg1);
     glad_glVertexAttrib2fv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib2fv", (void*)glVertexAttrib2fv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB2FVPROC glad_debug_glVertexAttrib2fv = glad_debug_impl_glVertexAttrib2fv;
PFNGLVERTEXATTRIB2SPROC glad_glVertexAttrib2s;
void APIENTRY glad_debug_impl_glVertexAttrib2s(GLuint arg0, GLshort arg1, GLshort arg2) {    
    _pre_call_callback_gl("glVertexAttrib2s", (void*)glVertexAttrib2s, 3, arg0, arg1, arg2);
     glad_glVertexAttrib2s(arg0, arg1, arg2);
    _post_call_callback_gl("glVertexAttrib2s", (void*)glVertexAttrib2s, 3, arg0, arg1, arg2);
    
}
PFNGLVERTEXATTRIB2SPROC glad_debug_glVertexAttrib2s = glad_debug_impl_glVertexAttrib2s;
PFNGLVERTEXATTRIB2SVPROC glad_glVertexAttrib2sv;
void APIENTRY glad_debug_impl_glVertexAttrib2sv(GLuint arg0, const GLshort * arg1) {    
    _pre_call_callback_gl("glVertexAttrib2sv", (void*)glVertexAttrib2sv, 2, arg0, arg1);
     glad_glVertexAttrib2sv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib2sv", (void*)glVertexAttrib2sv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB2SVPROC glad_debug_glVertexAttrib2sv = glad_debug_impl_glVertexAttrib2sv;
PFNGLVERTEXATTRIB3DPROC glad_glVertexAttrib3d;
void APIENTRY glad_debug_impl_glVertexAttrib3d(GLuint arg0, GLdouble arg1, GLdouble arg2, GLdouble arg3) {    
    _pre_call_callback_gl("glVertexAttrib3d", (void*)glVertexAttrib3d, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttrib3d(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttrib3d", (void*)glVertexAttrib3d, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIB3DPROC glad_debug_glVertexAttrib3d = glad_debug_impl_glVertexAttrib3d;
PFNGLVERTEXATTRIB3DVPROC glad_glVertexAttrib3dv;
void APIENTRY glad_debug_impl_glVertexAttrib3dv(GLuint arg0, const GLdouble * arg1) {    
    _pre_call_callback_gl("glVertexAttrib3dv", (void*)glVertexAttrib3dv, 2, arg0, arg1);
     glad_glVertexAttrib3dv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib3dv", (void*)glVertexAttrib3dv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB3DVPROC glad_debug_glVertexAttrib3dv = glad_debug_impl_glVertexAttrib3dv;
PFNGLVERTEXATTRIB3FPROC glad_glVertexAttrib3f;
void APIENTRY glad_debug_impl_glVertexAttrib3f(GLuint arg0, GLfloat arg1, GLfloat arg2, GLfloat arg3) {    
    _pre_call_callback_gl("glVertexAttrib3f", (void*)glVertexAttrib3f, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttrib3f(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttrib3f", (void*)glVertexAttrib3f, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIB3FPROC glad_debug_glVertexAttrib3f = glad_debug_impl_glVertexAttrib3f;
PFNGLVERTEXATTRIB3FVPROC glad_glVertexAttrib3fv;
void APIENTRY glad_debug_impl_glVertexAttrib3fv(GLuint arg0, const GLfloat * arg1) {    
    _pre_call_callback_gl("glVertexAttrib3fv", (void*)glVertexAttrib3fv, 2, arg0, arg1);
     glad_glVertexAttrib3fv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib3fv", (void*)glVertexAttrib3fv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB3FVPROC glad_debug_glVertexAttrib3fv = glad_debug_impl_glVertexAttrib3fv;
PFNGLVERTEXATTRIB3SPROC glad_glVertexAttrib3s;
void APIENTRY glad_debug_impl_glVertexAttrib3s(GLuint arg0, GLshort arg1, GLshort arg2, GLshort arg3) {    
    _pre_call_callback_gl("glVertexAttrib3s", (void*)glVertexAttrib3s, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttrib3s(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttrib3s", (void*)glVertexAttrib3s, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIB3SPROC glad_debug_glVertexAttrib3s = glad_debug_impl_glVertexAttrib3s;
PFNGLVERTEXATTRIB3SVPROC glad_glVertexAttrib3sv;
void APIENTRY glad_debug_impl_glVertexAttrib3sv(GLuint arg0, const GLshort * arg1) {    
    _pre_call_callback_gl("glVertexAttrib3sv", (void*)glVertexAttrib3sv, 2, arg0, arg1);
     glad_glVertexAttrib3sv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib3sv", (void*)glVertexAttrib3sv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB3SVPROC glad_debug_glVertexAttrib3sv = glad_debug_impl_glVertexAttrib3sv;
PFNGLVERTEXATTRIB4NBVPROC glad_glVertexAttrib4Nbv;
void APIENTRY glad_debug_impl_glVertexAttrib4Nbv(GLuint arg0, const GLbyte * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4Nbv", (void*)glVertexAttrib4Nbv, 2, arg0, arg1);
     glad_glVertexAttrib4Nbv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4Nbv", (void*)glVertexAttrib4Nbv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4NBVPROC glad_debug_glVertexAttrib4Nbv = glad_debug_impl_glVertexAttrib4Nbv;
PFNGLVERTEXATTRIB4NIVPROC glad_glVertexAttrib4Niv;
void APIENTRY glad_debug_impl_glVertexAttrib4Niv(GLuint arg0, const GLint * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4Niv", (void*)glVertexAttrib4Niv, 2, arg0, arg1);
     glad_glVertexAttrib4Niv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4Niv", (void*)glVertexAttrib4Niv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4NIVPROC glad_debug_glVertexAttrib4Niv = glad_debug_impl_glVertexAttrib4Niv;
PFNGLVERTEXATTRIB4NSVPROC glad_glVertexAttrib4Nsv;
void APIENTRY glad_debug_impl_glVertexAttrib4Nsv(GLuint arg0, const GLshort * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4Nsv", (void*)glVertexAttrib4Nsv, 2, arg0, arg1);
     glad_glVertexAttrib4Nsv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4Nsv", (void*)glVertexAttrib4Nsv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4NSVPROC glad_debug_glVertexAttrib4Nsv = glad_debug_impl_glVertexAttrib4Nsv;
PFNGLVERTEXATTRIB4NUBPROC glad_glVertexAttrib4Nub;
void APIENTRY glad_debug_impl_glVertexAttrib4Nub(GLuint arg0, GLubyte arg1, GLubyte arg2, GLubyte arg3, GLubyte arg4) {    
    _pre_call_callback_gl("glVertexAttrib4Nub", (void*)glVertexAttrib4Nub, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glVertexAttrib4Nub(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glVertexAttrib4Nub", (void*)glVertexAttrib4Nub, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLVERTEXATTRIB4NUBPROC glad_debug_glVertexAttrib4Nub = glad_debug_impl_glVertexAttrib4Nub;
PFNGLVERTEXATTRIB4NUBVPROC glad_glVertexAttrib4Nubv;
void APIENTRY glad_debug_impl_glVertexAttrib4Nubv(GLuint arg0, const GLubyte * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4Nubv", (void*)glVertexAttrib4Nubv, 2, arg0, arg1);
     glad_glVertexAttrib4Nubv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4Nubv", (void*)glVertexAttrib4Nubv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4NUBVPROC glad_debug_glVertexAttrib4Nubv = glad_debug_impl_glVertexAttrib4Nubv;
PFNGLVERTEXATTRIB4NUIVPROC glad_glVertexAttrib4Nuiv;
void APIENTRY glad_debug_impl_glVertexAttrib4Nuiv(GLuint arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4Nuiv", (void*)glVertexAttrib4Nuiv, 2, arg0, arg1);
     glad_glVertexAttrib4Nuiv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4Nuiv", (void*)glVertexAttrib4Nuiv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4NUIVPROC glad_debug_glVertexAttrib4Nuiv = glad_debug_impl_glVertexAttrib4Nuiv;
PFNGLVERTEXATTRIB4NUSVPROC glad_glVertexAttrib4Nusv;
void APIENTRY glad_debug_impl_glVertexAttrib4Nusv(GLuint arg0, const GLushort * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4Nusv", (void*)glVertexAttrib4Nusv, 2, arg0, arg1);
     glad_glVertexAttrib4Nusv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4Nusv", (void*)glVertexAttrib4Nusv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4NUSVPROC glad_debug_glVertexAttrib4Nusv = glad_debug_impl_glVertexAttrib4Nusv;
PFNGLVERTEXATTRIB4BVPROC glad_glVertexAttrib4bv;
void APIENTRY glad_debug_impl_glVertexAttrib4bv(GLuint arg0, const GLbyte * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4bv", (void*)glVertexAttrib4bv, 2, arg0, arg1);
     glad_glVertexAttrib4bv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4bv", (void*)glVertexAttrib4bv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4BVPROC glad_debug_glVertexAttrib4bv = glad_debug_impl_glVertexAttrib4bv;
PFNGLVERTEXATTRIB4DPROC glad_glVertexAttrib4d;
void APIENTRY glad_debug_impl_glVertexAttrib4d(GLuint arg0, GLdouble arg1, GLdouble arg2, GLdouble arg3, GLdouble arg4) {    
    _pre_call_callback_gl("glVertexAttrib4d", (void*)glVertexAttrib4d, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glVertexAttrib4d(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glVertexAttrib4d", (void*)glVertexAttrib4d, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLVERTEXATTRIB4DPROC glad_debug_glVertexAttrib4d = glad_debug_impl_glVertexAttrib4d;
PFNGLVERTEXATTRIB4DVPROC glad_glVertexAttrib4dv;
void APIENTRY glad_debug_impl_glVertexAttrib4dv(GLuint arg0, const GLdouble * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4dv", (void*)glVertexAttrib4dv, 2, arg0, arg1);
     glad_glVertexAttrib4dv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4dv", (void*)glVertexAttrib4dv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4DVPROC glad_debug_glVertexAttrib4dv = glad_debug_impl_glVertexAttrib4dv;
PFNGLVERTEXATTRIB4FPROC glad_glVertexAttrib4f;
void APIENTRY glad_debug_impl_glVertexAttrib4f(GLuint arg0, GLfloat arg1, GLfloat arg2, GLfloat arg3, GLfloat arg4) {    
    _pre_call_callback_gl("glVertexAttrib4f", (void*)glVertexAttrib4f, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glVertexAttrib4f(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glVertexAttrib4f", (void*)glVertexAttrib4f, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLVERTEXATTRIB4FPROC glad_debug_glVertexAttrib4f = glad_debug_impl_glVertexAttrib4f;
PFNGLVERTEXATTRIB4FVPROC glad_glVertexAttrib4fv;
void APIENTRY glad_debug_impl_glVertexAttrib4fv(GLuint arg0, const GLfloat * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4fv", (void*)glVertexAttrib4fv, 2, arg0, arg1);
     glad_glVertexAttrib4fv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4fv", (void*)glVertexAttrib4fv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4FVPROC glad_debug_glVertexAttrib4fv = glad_debug_impl_glVertexAttrib4fv;
PFNGLVERTEXATTRIB4IVPROC glad_glVertexAttrib4iv;
void APIENTRY glad_debug_impl_glVertexAttrib4iv(GLuint arg0, const GLint * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4iv", (void*)glVertexAttrib4iv, 2, arg0, arg1);
     glad_glVertexAttrib4iv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4iv", (void*)glVertexAttrib4iv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4IVPROC glad_debug_glVertexAttrib4iv = glad_debug_impl_glVertexAttrib4iv;
PFNGLVERTEXATTRIB4SPROC glad_glVertexAttrib4s;
void APIENTRY glad_debug_impl_glVertexAttrib4s(GLuint arg0, GLshort arg1, GLshort arg2, GLshort arg3, GLshort arg4) {    
    _pre_call_callback_gl("glVertexAttrib4s", (void*)glVertexAttrib4s, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glVertexAttrib4s(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glVertexAttrib4s", (void*)glVertexAttrib4s, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLVERTEXATTRIB4SPROC glad_debug_glVertexAttrib4s = glad_debug_impl_glVertexAttrib4s;
PFNGLVERTEXATTRIB4SVPROC glad_glVertexAttrib4sv;
void APIENTRY glad_debug_impl_glVertexAttrib4sv(GLuint arg0, const GLshort * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4sv", (void*)glVertexAttrib4sv, 2, arg0, arg1);
     glad_glVertexAttrib4sv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4sv", (void*)glVertexAttrib4sv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4SVPROC glad_debug_glVertexAttrib4sv = glad_debug_impl_glVertexAttrib4sv;
PFNGLVERTEXATTRIB4UBVPROC glad_glVertexAttrib4ubv;
void APIENTRY glad_debug_impl_glVertexAttrib4ubv(GLuint arg0, const GLubyte * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4ubv", (void*)glVertexAttrib4ubv, 2, arg0, arg1);
     glad_glVertexAttrib4ubv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4ubv", (void*)glVertexAttrib4ubv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4UBVPROC glad_debug_glVertexAttrib4ubv = glad_debug_impl_glVertexAttrib4ubv;
PFNGLVERTEXATTRIB4UIVPROC glad_glVertexAttrib4uiv;
void APIENTRY glad_debug_impl_glVertexAttrib4uiv(GLuint arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4uiv", (void*)glVertexAttrib4uiv, 2, arg0, arg1);
     glad_glVertexAttrib4uiv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4uiv", (void*)glVertexAttrib4uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4UIVPROC glad_debug_glVertexAttrib4uiv = glad_debug_impl_glVertexAttrib4uiv;
PFNGLVERTEXATTRIB4USVPROC glad_glVertexAttrib4usv;
void APIENTRY glad_debug_impl_glVertexAttrib4usv(GLuint arg0, const GLushort * arg1) {    
    _pre_call_callback_gl("glVertexAttrib4usv", (void*)glVertexAttrib4usv, 2, arg0, arg1);
     glad_glVertexAttrib4usv(arg0, arg1);
    _post_call_callback_gl("glVertexAttrib4usv", (void*)glVertexAttrib4usv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIB4USVPROC glad_debug_glVertexAttrib4usv = glad_debug_impl_glVertexAttrib4usv;
PFNGLVERTEXATTRIBDIVISORPROC glad_glVertexAttribDivisor;
void APIENTRY glad_debug_impl_glVertexAttribDivisor(GLuint arg0, GLuint arg1) {    
    _pre_call_callback_gl("glVertexAttribDivisor", (void*)glVertexAttribDivisor, 2, arg0, arg1);
     glad_glVertexAttribDivisor(arg0, arg1);
    _post_call_callback_gl("glVertexAttribDivisor", (void*)glVertexAttribDivisor, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBDIVISORPROC glad_debug_glVertexAttribDivisor = glad_debug_impl_glVertexAttribDivisor;
PFNGLVERTEXATTRIBI1IPROC glad_glVertexAttribI1i;
void APIENTRY glad_debug_impl_glVertexAttribI1i(GLuint arg0, GLint arg1) {    
    _pre_call_callback_gl("glVertexAttribI1i", (void*)glVertexAttribI1i, 2, arg0, arg1);
     glad_glVertexAttribI1i(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI1i", (void*)glVertexAttribI1i, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI1IPROC glad_debug_glVertexAttribI1i = glad_debug_impl_glVertexAttribI1i;
PFNGLVERTEXATTRIBI1IVPROC glad_glVertexAttribI1iv;
void APIENTRY glad_debug_impl_glVertexAttribI1iv(GLuint arg0, const GLint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI1iv", (void*)glVertexAttribI1iv, 2, arg0, arg1);
     glad_glVertexAttribI1iv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI1iv", (void*)glVertexAttribI1iv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI1IVPROC glad_debug_glVertexAttribI1iv = glad_debug_impl_glVertexAttribI1iv;
PFNGLVERTEXATTRIBI1UIPROC glad_glVertexAttribI1ui;
void APIENTRY glad_debug_impl_glVertexAttribI1ui(GLuint arg0, GLuint arg1) {    
    _pre_call_callback_gl("glVertexAttribI1ui", (void*)glVertexAttribI1ui, 2, arg0, arg1);
     glad_glVertexAttribI1ui(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI1ui", (void*)glVertexAttribI1ui, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI1UIPROC glad_debug_glVertexAttribI1ui = glad_debug_impl_glVertexAttribI1ui;
PFNGLVERTEXATTRIBI1UIVPROC glad_glVertexAttribI1uiv;
void APIENTRY glad_debug_impl_glVertexAttribI1uiv(GLuint arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI1uiv", (void*)glVertexAttribI1uiv, 2, arg0, arg1);
     glad_glVertexAttribI1uiv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI1uiv", (void*)glVertexAttribI1uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI1UIVPROC glad_debug_glVertexAttribI1uiv = glad_debug_impl_glVertexAttribI1uiv;
PFNGLVERTEXATTRIBI2IPROC glad_glVertexAttribI2i;
void APIENTRY glad_debug_impl_glVertexAttribI2i(GLuint arg0, GLint arg1, GLint arg2) {    
    _pre_call_callback_gl("glVertexAttribI2i", (void*)glVertexAttribI2i, 3, arg0, arg1, arg2);
     glad_glVertexAttribI2i(arg0, arg1, arg2);
    _post_call_callback_gl("glVertexAttribI2i", (void*)glVertexAttribI2i, 3, arg0, arg1, arg2);
    
}
PFNGLVERTEXATTRIBI2IPROC glad_debug_glVertexAttribI2i = glad_debug_impl_glVertexAttribI2i;
PFNGLVERTEXATTRIBI2IVPROC glad_glVertexAttribI2iv;
void APIENTRY glad_debug_impl_glVertexAttribI2iv(GLuint arg0, const GLint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI2iv", (void*)glVertexAttribI2iv, 2, arg0, arg1);
     glad_glVertexAttribI2iv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI2iv", (void*)glVertexAttribI2iv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI2IVPROC glad_debug_glVertexAttribI2iv = glad_debug_impl_glVertexAttribI2iv;
PFNGLVERTEXATTRIBI2UIPROC glad_glVertexAttribI2ui;
void APIENTRY glad_debug_impl_glVertexAttribI2ui(GLuint arg0, GLuint arg1, GLuint arg2) {    
    _pre_call_callback_gl("glVertexAttribI2ui", (void*)glVertexAttribI2ui, 3, arg0, arg1, arg2);
     glad_glVertexAttribI2ui(arg0, arg1, arg2);
    _post_call_callback_gl("glVertexAttribI2ui", (void*)glVertexAttribI2ui, 3, arg0, arg1, arg2);
    
}
PFNGLVERTEXATTRIBI2UIPROC glad_debug_glVertexAttribI2ui = glad_debug_impl_glVertexAttribI2ui;
PFNGLVERTEXATTRIBI2UIVPROC glad_glVertexAttribI2uiv;
void APIENTRY glad_debug_impl_glVertexAttribI2uiv(GLuint arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI2uiv", (void*)glVertexAttribI2uiv, 2, arg0, arg1);
     glad_glVertexAttribI2uiv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI2uiv", (void*)glVertexAttribI2uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI2UIVPROC glad_debug_glVertexAttribI2uiv = glad_debug_impl_glVertexAttribI2uiv;
PFNGLVERTEXATTRIBI3IPROC glad_glVertexAttribI3i;
void APIENTRY glad_debug_impl_glVertexAttribI3i(GLuint arg0, GLint arg1, GLint arg2, GLint arg3) {    
    _pre_call_callback_gl("glVertexAttribI3i", (void*)glVertexAttribI3i, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribI3i(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribI3i", (void*)glVertexAttribI3i, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBI3IPROC glad_debug_glVertexAttribI3i = glad_debug_impl_glVertexAttribI3i;
PFNGLVERTEXATTRIBI3IVPROC glad_glVertexAttribI3iv;
void APIENTRY glad_debug_impl_glVertexAttribI3iv(GLuint arg0, const GLint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI3iv", (void*)glVertexAttribI3iv, 2, arg0, arg1);
     glad_glVertexAttribI3iv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI3iv", (void*)glVertexAttribI3iv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI3IVPROC glad_debug_glVertexAttribI3iv = glad_debug_impl_glVertexAttribI3iv;
PFNGLVERTEXATTRIBI3UIPROC glad_glVertexAttribI3ui;
void APIENTRY glad_debug_impl_glVertexAttribI3ui(GLuint arg0, GLuint arg1, GLuint arg2, GLuint arg3) {    
    _pre_call_callback_gl("glVertexAttribI3ui", (void*)glVertexAttribI3ui, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribI3ui(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribI3ui", (void*)glVertexAttribI3ui, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBI3UIPROC glad_debug_glVertexAttribI3ui = glad_debug_impl_glVertexAttribI3ui;
PFNGLVERTEXATTRIBI3UIVPROC glad_glVertexAttribI3uiv;
void APIENTRY glad_debug_impl_glVertexAttribI3uiv(GLuint arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI3uiv", (void*)glVertexAttribI3uiv, 2, arg0, arg1);
     glad_glVertexAttribI3uiv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI3uiv", (void*)glVertexAttribI3uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI3UIVPROC glad_debug_glVertexAttribI3uiv = glad_debug_impl_glVertexAttribI3uiv;
PFNGLVERTEXATTRIBI4BVPROC glad_glVertexAttribI4bv;
void APIENTRY glad_debug_impl_glVertexAttribI4bv(GLuint arg0, const GLbyte * arg1) {    
    _pre_call_callback_gl("glVertexAttribI4bv", (void*)glVertexAttribI4bv, 2, arg0, arg1);
     glad_glVertexAttribI4bv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI4bv", (void*)glVertexAttribI4bv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI4BVPROC glad_debug_glVertexAttribI4bv = glad_debug_impl_glVertexAttribI4bv;
PFNGLVERTEXATTRIBI4IPROC glad_glVertexAttribI4i;
void APIENTRY glad_debug_impl_glVertexAttribI4i(GLuint arg0, GLint arg1, GLint arg2, GLint arg3, GLint arg4) {    
    _pre_call_callback_gl("glVertexAttribI4i", (void*)glVertexAttribI4i, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glVertexAttribI4i(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glVertexAttribI4i", (void*)glVertexAttribI4i, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLVERTEXATTRIBI4IPROC glad_debug_glVertexAttribI4i = glad_debug_impl_glVertexAttribI4i;
PFNGLVERTEXATTRIBI4IVPROC glad_glVertexAttribI4iv;
void APIENTRY glad_debug_impl_glVertexAttribI4iv(GLuint arg0, const GLint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI4iv", (void*)glVertexAttribI4iv, 2, arg0, arg1);
     glad_glVertexAttribI4iv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI4iv", (void*)glVertexAttribI4iv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI4IVPROC glad_debug_glVertexAttribI4iv = glad_debug_impl_glVertexAttribI4iv;
PFNGLVERTEXATTRIBI4SVPROC glad_glVertexAttribI4sv;
void APIENTRY glad_debug_impl_glVertexAttribI4sv(GLuint arg0, const GLshort * arg1) {    
    _pre_call_callback_gl("glVertexAttribI4sv", (void*)glVertexAttribI4sv, 2, arg0, arg1);
     glad_glVertexAttribI4sv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI4sv", (void*)glVertexAttribI4sv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI4SVPROC glad_debug_glVertexAttribI4sv = glad_debug_impl_glVertexAttribI4sv;
PFNGLVERTEXATTRIBI4UBVPROC glad_glVertexAttribI4ubv;
void APIENTRY glad_debug_impl_glVertexAttribI4ubv(GLuint arg0, const GLubyte * arg1) {    
    _pre_call_callback_gl("glVertexAttribI4ubv", (void*)glVertexAttribI4ubv, 2, arg0, arg1);
     glad_glVertexAttribI4ubv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI4ubv", (void*)glVertexAttribI4ubv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI4UBVPROC glad_debug_glVertexAttribI4ubv = glad_debug_impl_glVertexAttribI4ubv;
PFNGLVERTEXATTRIBI4UIPROC glad_glVertexAttribI4ui;
void APIENTRY glad_debug_impl_glVertexAttribI4ui(GLuint arg0, GLuint arg1, GLuint arg2, GLuint arg3, GLuint arg4) {    
    _pre_call_callback_gl("glVertexAttribI4ui", (void*)glVertexAttribI4ui, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glVertexAttribI4ui(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glVertexAttribI4ui", (void*)glVertexAttribI4ui, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLVERTEXATTRIBI4UIPROC glad_debug_glVertexAttribI4ui = glad_debug_impl_glVertexAttribI4ui;
PFNGLVERTEXATTRIBI4UIVPROC glad_glVertexAttribI4uiv;
void APIENTRY glad_debug_impl_glVertexAttribI4uiv(GLuint arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexAttribI4uiv", (void*)glVertexAttribI4uiv, 2, arg0, arg1);
     glad_glVertexAttribI4uiv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI4uiv", (void*)glVertexAttribI4uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI4UIVPROC glad_debug_glVertexAttribI4uiv = glad_debug_impl_glVertexAttribI4uiv;
PFNGLVERTEXATTRIBI4USVPROC glad_glVertexAttribI4usv;
void APIENTRY glad_debug_impl_glVertexAttribI4usv(GLuint arg0, const GLushort * arg1) {    
    _pre_call_callback_gl("glVertexAttribI4usv", (void*)glVertexAttribI4usv, 2, arg0, arg1);
     glad_glVertexAttribI4usv(arg0, arg1);
    _post_call_callback_gl("glVertexAttribI4usv", (void*)glVertexAttribI4usv, 2, arg0, arg1);
    
}
PFNGLVERTEXATTRIBI4USVPROC glad_debug_glVertexAttribI4usv = glad_debug_impl_glVertexAttribI4usv;
PFNGLVERTEXATTRIBIPOINTERPROC glad_glVertexAttribIPointer;
void APIENTRY glad_debug_impl_glVertexAttribIPointer(GLuint arg0, GLint arg1, GLenum arg2, GLsizei arg3, const void * arg4) {    
    _pre_call_callback_gl("glVertexAttribIPointer", (void*)glVertexAttribIPointer, 5, arg0, arg1, arg2, arg3, arg4);
     glad_glVertexAttribIPointer(arg0, arg1, arg2, arg3, arg4);
    _post_call_callback_gl("glVertexAttribIPointer", (void*)glVertexAttribIPointer, 5, arg0, arg1, arg2, arg3, arg4);
    
}
PFNGLVERTEXATTRIBIPOINTERPROC glad_debug_glVertexAttribIPointer = glad_debug_impl_glVertexAttribIPointer;
PFNGLVERTEXATTRIBP1UIPROC glad_glVertexAttribP1ui;
void APIENTRY glad_debug_impl_glVertexAttribP1ui(GLuint arg0, GLenum arg1, GLboolean arg2, GLuint arg3) {    
    _pre_call_callback_gl("glVertexAttribP1ui", (void*)glVertexAttribP1ui, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP1ui(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP1ui", (void*)glVertexAttribP1ui, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP1UIPROC glad_debug_glVertexAttribP1ui = glad_debug_impl_glVertexAttribP1ui;
PFNGLVERTEXATTRIBP1UIVPROC glad_glVertexAttribP1uiv;
void APIENTRY glad_debug_impl_glVertexAttribP1uiv(GLuint arg0, GLenum arg1, GLboolean arg2, const GLuint * arg3) {    
    _pre_call_callback_gl("glVertexAttribP1uiv", (void*)glVertexAttribP1uiv, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP1uiv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP1uiv", (void*)glVertexAttribP1uiv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP1UIVPROC glad_debug_glVertexAttribP1uiv = glad_debug_impl_glVertexAttribP1uiv;
PFNGLVERTEXATTRIBP2UIPROC glad_glVertexAttribP2ui;
void APIENTRY glad_debug_impl_glVertexAttribP2ui(GLuint arg0, GLenum arg1, GLboolean arg2, GLuint arg3) {    
    _pre_call_callback_gl("glVertexAttribP2ui", (void*)glVertexAttribP2ui, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP2ui(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP2ui", (void*)glVertexAttribP2ui, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP2UIPROC glad_debug_glVertexAttribP2ui = glad_debug_impl_glVertexAttribP2ui;
PFNGLVERTEXATTRIBP2UIVPROC glad_glVertexAttribP2uiv;
void APIENTRY glad_debug_impl_glVertexAttribP2uiv(GLuint arg0, GLenum arg1, GLboolean arg2, const GLuint * arg3) {    
    _pre_call_callback_gl("glVertexAttribP2uiv", (void*)glVertexAttribP2uiv, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP2uiv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP2uiv", (void*)glVertexAttribP2uiv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP2UIVPROC glad_debug_glVertexAttribP2uiv = glad_debug_impl_glVertexAttribP2uiv;
PFNGLVERTEXATTRIBP3UIPROC glad_glVertexAttribP3ui;
void APIENTRY glad_debug_impl_glVertexAttribP3ui(GLuint arg0, GLenum arg1, GLboolean arg2, GLuint arg3) {    
    _pre_call_callback_gl("glVertexAttribP3ui", (void*)glVertexAttribP3ui, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP3ui(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP3ui", (void*)glVertexAttribP3ui, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP3UIPROC glad_debug_glVertexAttribP3ui = glad_debug_impl_glVertexAttribP3ui;
PFNGLVERTEXATTRIBP3UIVPROC glad_glVertexAttribP3uiv;
void APIENTRY glad_debug_impl_glVertexAttribP3uiv(GLuint arg0, GLenum arg1, GLboolean arg2, const GLuint * arg3) {    
    _pre_call_callback_gl("glVertexAttribP3uiv", (void*)glVertexAttribP3uiv, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP3uiv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP3uiv", (void*)glVertexAttribP3uiv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP3UIVPROC glad_debug_glVertexAttribP3uiv = glad_debug_impl_glVertexAttribP3uiv;
PFNGLVERTEXATTRIBP4UIPROC glad_glVertexAttribP4ui;
void APIENTRY glad_debug_impl_glVertexAttribP4ui(GLuint arg0, GLenum arg1, GLboolean arg2, GLuint arg3) {    
    _pre_call_callback_gl("glVertexAttribP4ui", (void*)glVertexAttribP4ui, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP4ui(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP4ui", (void*)glVertexAttribP4ui, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP4UIPROC glad_debug_glVertexAttribP4ui = glad_debug_impl_glVertexAttribP4ui;
PFNGLVERTEXATTRIBP4UIVPROC glad_glVertexAttribP4uiv;
void APIENTRY glad_debug_impl_glVertexAttribP4uiv(GLuint arg0, GLenum arg1, GLboolean arg2, const GLuint * arg3) {    
    _pre_call_callback_gl("glVertexAttribP4uiv", (void*)glVertexAttribP4uiv, 4, arg0, arg1, arg2, arg3);
     glad_glVertexAttribP4uiv(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glVertexAttribP4uiv", (void*)glVertexAttribP4uiv, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVERTEXATTRIBP4UIVPROC glad_debug_glVertexAttribP4uiv = glad_debug_impl_glVertexAttribP4uiv;
PFNGLVERTEXATTRIBPOINTERPROC glad_glVertexAttribPointer;
void APIENTRY glad_debug_impl_glVertexAttribPointer(GLuint arg0, GLint arg1, GLenum arg2, GLboolean arg3, GLsizei arg4, const void * arg5) {    
    _pre_call_callback_gl("glVertexAttribPointer", (void*)glVertexAttribPointer, 6, arg0, arg1, arg2, arg3, arg4, arg5);
     glad_glVertexAttribPointer(arg0, arg1, arg2, arg3, arg4, arg5);
    _post_call_callback_gl("glVertexAttribPointer", (void*)glVertexAttribPointer, 6, arg0, arg1, arg2, arg3, arg4, arg5);
    
}
PFNGLVERTEXATTRIBPOINTERPROC glad_debug_glVertexAttribPointer = glad_debug_impl_glVertexAttribPointer;
PFNGLVERTEXP2UIPROC glad_glVertexP2ui;
void APIENTRY glad_debug_impl_glVertexP2ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glVertexP2ui", (void*)glVertexP2ui, 2, arg0, arg1);
     glad_glVertexP2ui(arg0, arg1);
    _post_call_callback_gl("glVertexP2ui", (void*)glVertexP2ui, 2, arg0, arg1);
    
}
PFNGLVERTEXP2UIPROC glad_debug_glVertexP2ui = glad_debug_impl_glVertexP2ui;
PFNGLVERTEXP2UIVPROC glad_glVertexP2uiv;
void APIENTRY glad_debug_impl_glVertexP2uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexP2uiv", (void*)glVertexP2uiv, 2, arg0, arg1);
     glad_glVertexP2uiv(arg0, arg1);
    _post_call_callback_gl("glVertexP2uiv", (void*)glVertexP2uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXP2UIVPROC glad_debug_glVertexP2uiv = glad_debug_impl_glVertexP2uiv;
PFNGLVERTEXP3UIPROC glad_glVertexP3ui;
void APIENTRY glad_debug_impl_glVertexP3ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glVertexP3ui", (void*)glVertexP3ui, 2, arg0, arg1);
     glad_glVertexP3ui(arg0, arg1);
    _post_call_callback_gl("glVertexP3ui", (void*)glVertexP3ui, 2, arg0, arg1);
    
}
PFNGLVERTEXP3UIPROC glad_debug_glVertexP3ui = glad_debug_impl_glVertexP3ui;
PFNGLVERTEXP3UIVPROC glad_glVertexP3uiv;
void APIENTRY glad_debug_impl_glVertexP3uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexP3uiv", (void*)glVertexP3uiv, 2, arg0, arg1);
     glad_glVertexP3uiv(arg0, arg1);
    _post_call_callback_gl("glVertexP3uiv", (void*)glVertexP3uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXP3UIVPROC glad_debug_glVertexP3uiv = glad_debug_impl_glVertexP3uiv;
PFNGLVERTEXP4UIPROC glad_glVertexP4ui;
void APIENTRY glad_debug_impl_glVertexP4ui(GLenum arg0, GLuint arg1) {    
    _pre_call_callback_gl("glVertexP4ui", (void*)glVertexP4ui, 2, arg0, arg1);
     glad_glVertexP4ui(arg0, arg1);
    _post_call_callback_gl("glVertexP4ui", (void*)glVertexP4ui, 2, arg0, arg1);
    
}
PFNGLVERTEXP4UIPROC glad_debug_glVertexP4ui = glad_debug_impl_glVertexP4ui;
PFNGLVERTEXP4UIVPROC glad_glVertexP4uiv;
void APIENTRY glad_debug_impl_glVertexP4uiv(GLenum arg0, const GLuint * arg1) {    
    _pre_call_callback_gl("glVertexP4uiv", (void*)glVertexP4uiv, 2, arg0, arg1);
     glad_glVertexP4uiv(arg0, arg1);
    _post_call_callback_gl("glVertexP4uiv", (void*)glVertexP4uiv, 2, arg0, arg1);
    
}
PFNGLVERTEXP4UIVPROC glad_debug_glVertexP4uiv = glad_debug_impl_glVertexP4uiv;
PFNGLVIEWPORTPROC glad_glViewport;
void APIENTRY glad_debug_impl_glViewport(GLint arg0, GLint arg1, GLsizei arg2, GLsizei arg3) {    
    _pre_call_callback_gl("glViewport", (void*)glViewport, 4, arg0, arg1, arg2, arg3);
     glad_glViewport(arg0, arg1, arg2, arg3);
    _post_call_callback_gl("glViewport", (void*)glViewport, 4, arg0, arg1, arg2, arg3);
    
}
PFNGLVIEWPORTPROC glad_debug_glViewport = glad_debug_impl_glViewport;
PFNGLWAITSYNCPROC glad_glWaitSync;
void APIENTRY glad_debug_impl_glWaitSync(GLsync arg0, GLbitfield arg1, GLuint64 arg2) {    
    _pre_call_callback_gl("glWaitSync", (void*)glWaitSync, 3, arg0, arg1, arg2);
     glad_glWaitSync(arg0, arg1, arg2);
    _post_call_callback_gl("glWaitSync", (void*)glWaitSync, 3, arg0, arg1, arg2);
    
}
PFNGLWAITSYNCPROC glad_debug_glWaitSync = glad_debug_impl_glWaitSync;
int GLAD_GL_ARB_ES3_compatibility = 0;
int GLAD_GL_ARB_draw_elements_base_vertex = 0;
int GLAD_GL_EXT_texture_compression_s3tc = 0;
int GLAD_GL_EXT_texture_compression_s3tc_srgb = 0;
int GLAD_GL_EXT_texture_filter_anisotropic = 0;
int GLAD_GL_IMG_texture_compression_pvrtc = 0;
int GLAD_GL_IMG_texture_compression_pvrtc2 = 0;
static void load_GL_VERSION_1_0(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_0) return;
	glad_glCullFace = (PFNGLCULLFACEPROC)load("glCullFace");
	glad_glFrontFace = (PFNGLFRONTFACEPROC)load("glFrontFace");
	glad_glHint = (PFNGLHINTPROC)load("glHint");
	glad_glLineWidth = (PFNGLLINEWIDTHPROC)load("glLineWidth");
	glad_glPointSize = (PFNGLPOINTSIZEPROC)load("glPointSize");
	glad_glPolygonMode = (PFNGLPOLYGONMODEPROC)load("glPolygonMode");
	glad_glScissor = (PFNGLSCISSORPROC)load("glScissor");
	glad_glTexParameterf = (PFNGLTEXPARAMETERFPROC)load("glTexParameterf");
	glad_glTexParameterfv = (PFNGLTEXPARAMETERFVPROC)load("glTexParameterfv");
	glad_glTexParameteri = (PFNGLTEXPARAMETERIPROC)load("glTexParameteri");
	glad_glTexParameteriv = (PFNGLTEXPARAMETERIVPROC)load("glTexParameteriv");
	glad_glTexImage1D = (PFNGLTEXIMAGE1DPROC)load("glTexImage1D");
	glad_glTexImage2D = (PFNGLTEXIMAGE2DPROC)load("glTexImage2D");
	glad_glDrawBuffer = (PFNGLDRAWBUFFERPROC)load("glDrawBuffer");
	glad_glClear = (PFNGLCLEARPROC)load("glClear");
	glad_glClearColor = (PFNGLCLEARCOLORPROC)load("glClearColor");
	glad_glClearStencil = (PFNGLCLEARSTENCILPROC)load("glClearStencil");
	glad_glClearDepth = (PFNGLCLEARDEPTHPROC)load("glClearDepth");
	glad_glStencilMask = (PFNGLSTENCILMASKPROC)load("glStencilMask");
	glad_glColorMask = (PFNGLCOLORMASKPROC)load("glColorMask");
	glad_glDepthMask = (PFNGLDEPTHMASKPROC)load("glDepthMask");
	glad_glDisable = (PFNGLDISABLEPROC)load("glDisable");
	glad_glEnable = (PFNGLENABLEPROC)load("glEnable");
	glad_glFinish = (PFNGLFINISHPROC)load("glFinish");
	glad_glFlush = (PFNGLFLUSHPROC)load("glFlush");
	glad_glBlendFunc = (PFNGLBLENDFUNCPROC)load("glBlendFunc");
	glad_glLogicOp = (PFNGLLOGICOPPROC)load("glLogicOp");
	glad_glStencilFunc = (PFNGLSTENCILFUNCPROC)load("glStencilFunc");
	glad_glStencilOp = (PFNGLSTENCILOPPROC)load("glStencilOp");
	glad_glDepthFunc = (PFNGLDEPTHFUNCPROC)load("glDepthFunc");
	glad_glPixelStoref = (PFNGLPIXELSTOREFPROC)load("glPixelStoref");
	glad_glPixelStorei = (PFNGLPIXELSTOREIPROC)load("glPixelStorei");
	glad_glReadBuffer = (PFNGLREADBUFFERPROC)load("glReadBuffer");
	glad_glReadPixels = (PFNGLREADPIXELSPROC)load("glReadPixels");
	glad_glGetBooleanv = (PFNGLGETBOOLEANVPROC)load("glGetBooleanv");
	glad_glGetDoublev = (PFNGLGETDOUBLEVPROC)load("glGetDoublev");
	glad_glGetError = (PFNGLGETERRORPROC)load("glGetError");
	glad_glGetFloatv = (PFNGLGETFLOATVPROC)load("glGetFloatv");
	glad_glGetIntegerv = (PFNGLGETINTEGERVPROC)load("glGetIntegerv");
	glad_glGetString = (PFNGLGETSTRINGPROC)load("glGetString");
	glad_glGetTexImage = (PFNGLGETTEXIMAGEPROC)load("glGetTexImage");
	glad_glGetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC)load("glGetTexParameterfv");
	glad_glGetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC)load("glGetTexParameteriv");
	glad_glGetTexLevelParameterfv = (PFNGLGETTEXLEVELPARAMETERFVPROC)load("glGetTexLevelParameterfv");
	glad_glGetTexLevelParameteriv = (PFNGLGETTEXLEVELPARAMETERIVPROC)load("glGetTexLevelParameteriv");
	glad_glIsEnabled = (PFNGLISENABLEDPROC)load("glIsEnabled");
	glad_glDepthRange = (PFNGLDEPTHRANGEPROC)load("glDepthRange");
	glad_glViewport = (PFNGLVIEWPORTPROC)load("glViewport");
}
static void load_GL_VERSION_1_1(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_1) return;
	glad_glDrawArrays = (PFNGLDRAWARRAYSPROC)load("glDrawArrays");
	glad_glDrawElements = (PFNGLDRAWELEMENTSPROC)load("glDrawElements");
	glad_glPolygonOffset = (PFNGLPOLYGONOFFSETPROC)load("glPolygonOffset");
	glad_glCopyTexImage1D = (PFNGLCOPYTEXIMAGE1DPROC)load("glCopyTexImage1D");
	glad_glCopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC)load("glCopyTexImage2D");
	glad_glCopyTexSubImage1D = (PFNGLCOPYTEXSUBIMAGE1DPROC)load("glCopyTexSubImage1D");
	glad_glCopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC)load("glCopyTexSubImage2D");
	glad_glTexSubImage1D = (PFNGLTEXSUBIMAGE1DPROC)load("glTexSubImage1D");
	glad_glTexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC)load("glTexSubImage2D");
	glad_glBindTexture = (PFNGLBINDTEXTUREPROC)load("glBindTexture");
	glad_glDeleteTextures = (PFNGLDELETETEXTURESPROC)load("glDeleteTextures");
	glad_glGenTextures = (PFNGLGENTEXTURESPROC)load("glGenTextures");
	glad_glIsTexture = (PFNGLISTEXTUREPROC)load("glIsTexture");
}
static void load_GL_VERSION_1_2(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_2) return;
	glad_glDrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC)load("glDrawRangeElements");
	glad_glTexImage3D = (PFNGLTEXIMAGE3DPROC)load("glTexImage3D");
	glad_glTexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC)load("glTexSubImage3D");
	glad_glCopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC)load("glCopyTexSubImage3D");
}
static void load_GL_VERSION_1_3(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_3) return;
	glad_glActiveTexture = (PFNGLACTIVETEXTUREPROC)load("glActiveTexture");
	glad_glSampleCoverage = (PFNGLSAMPLECOVERAGEPROC)load("glSampleCoverage");
	glad_glCompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC)load("glCompressedTexImage3D");
	glad_glCompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC)load("glCompressedTexImage2D");
	glad_glCompressedTexImage1D = (PFNGLCOMPRESSEDTEXIMAGE1DPROC)load("glCompressedTexImage1D");
	glad_glCompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC)load("glCompressedTexSubImage3D");
	glad_glCompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC)load("glCompressedTexSubImage2D");
	glad_glCompressedTexSubImage1D = (PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC)load("glCompressedTexSubImage1D");
	glad_glGetCompressedTexImage = (PFNGLGETCOMPRESSEDTEXIMAGEPROC)load("glGetCompressedTexImage");
}
static void load_GL_VERSION_1_4(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_4) return;
	glad_glBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC)load("glBlendFuncSeparate");
	glad_glMultiDrawArrays = (PFNGLMULTIDRAWARRAYSPROC)load("glMultiDrawArrays");
	glad_glMultiDrawElements = (PFNGLMULTIDRAWELEMENTSPROC)load("glMultiDrawElements");
	glad_glPointParameterf = (PFNGLPOINTPARAMETERFPROC)load("glPointParameterf");
	glad_glPointParameterfv = (PFNGLPOINTPARAMETERFVPROC)load("glPointParameterfv");
	glad_glPointParameteri = (PFNGLPOINTPARAMETERIPROC)load("glPointParameteri");
	glad_glPointParameteriv = (PFNGLPOINTPARAMETERIVPROC)load("glPointParameteriv");
	glad_glBlendColor = (PFNGLBLENDCOLORPROC)load("glBlendColor");
	glad_glBlendEquation = (PFNGLBLENDEQUATIONPROC)load("glBlendEquation");
}
static void load_GL_VERSION_1_5(GLADloadproc load) {
	if(!GLAD_GL_VERSION_1_5) return;
	glad_glGenQueries = (PFNGLGENQUERIESPROC)load("glGenQueries");
	glad_glDeleteQueries = (PFNGLDELETEQUERIESPROC)load("glDeleteQueries");
	glad_glIsQuery = (PFNGLISQUERYPROC)load("glIsQuery");
	glad_glBeginQuery = (PFNGLBEGINQUERYPROC)load("glBeginQuery");
	glad_glEndQuery = (PFNGLENDQUERYPROC)load("glEndQuery");
	glad_glGetQueryiv = (PFNGLGETQUERYIVPROC)load("glGetQueryiv");
	glad_glGetQueryObjectiv = (PFNGLGETQUERYOBJECTIVPROC)load("glGetQueryObjectiv");
	glad_glGetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC)load("glGetQueryObjectuiv");
	glad_glBindBuffer = (PFNGLBINDBUFFERPROC)load("glBindBuffer");
	glad_glDeleteBuffers = (PFNGLDELETEBUFFERSPROC)load("glDeleteBuffers");
	glad_glGenBuffers = (PFNGLGENBUFFERSPROC)load("glGenBuffers");
	glad_glIsBuffer = (PFNGLISBUFFERPROC)load("glIsBuffer");
	glad_glBufferData = (PFNGLBUFFERDATAPROC)load("glBufferData");
	glad_glBufferSubData = (PFNGLBUFFERSUBDATAPROC)load("glBufferSubData");
	glad_glGetBufferSubData = (PFNGLGETBUFFERSUBDATAPROC)load("glGetBufferSubData");
	glad_glMapBuffer = (PFNGLMAPBUFFERPROC)load("glMapBuffer");
	glad_glUnmapBuffer = (PFNGLUNMAPBUFFERPROC)load("glUnmapBuffer");
	glad_glGetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC)load("glGetBufferParameteriv");
	glad_glGetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC)load("glGetBufferPointerv");
}
static void load_GL_VERSION_2_0(GLADloadproc load) {
	if(!GLAD_GL_VERSION_2_0) return;
	glad_glBlendEquationSeparate = (PFNGLBLENDEQUATIONSEPARATEPROC)load("glBlendEquationSeparate");
	glad_glDrawBuffers = (PFNGLDRAWBUFFERSPROC)load("glDrawBuffers");
	glad_glStencilOpSeparate = (PFNGLSTENCILOPSEPARATEPROC)load("glStencilOpSeparate");
	glad_glStencilFuncSeparate = (PFNGLSTENCILFUNCSEPARATEPROC)load("glStencilFuncSeparate");
	glad_glStencilMaskSeparate = (PFNGLSTENCILMASKSEPARATEPROC)load("glStencilMaskSeparate");
	glad_glAttachShader = (PFNGLATTACHSHADERPROC)load("glAttachShader");
	glad_glBindAttribLocation = (PFNGLBINDATTRIBLOCATIONPROC)load("glBindAttribLocation");
	glad_glCompileShader = (PFNGLCOMPILESHADERPROC)load("glCompileShader");
	glad_glCreateProgram = (PFNGLCREATEPROGRAMPROC)load("glCreateProgram");
	glad_glCreateShader = (PFNGLCREATESHADERPROC)load("glCreateShader");
	glad_glDeleteProgram = (PFNGLDELETEPROGRAMPROC)load("glDeleteProgram");
	glad_glDeleteShader = (PFNGLDELETESHADERPROC)load("glDeleteShader");
	glad_glDetachShader = (PFNGLDETACHSHADERPROC)load("glDetachShader");
	glad_glDisableVertexAttribArray = (PFNGLDISABLEVERTEXATTRIBARRAYPROC)load("glDisableVertexAttribArray");
	glad_glEnableVertexAttribArray = (PFNGLENABLEVERTEXATTRIBARRAYPROC)load("glEnableVertexAttribArray");
	glad_glGetActiveAttrib = (PFNGLGETACTIVEATTRIBPROC)load("glGetActiveAttrib");
	glad_glGetActiveUniform = (PFNGLGETACTIVEUNIFORMPROC)load("glGetActiveUniform");
	glad_glGetAttachedShaders = (PFNGLGETATTACHEDSHADERSPROC)load("glGetAttachedShaders");
	glad_glGetAttribLocation = (PFNGLGETATTRIBLOCATIONPROC)load("glGetAttribLocation");
	glad_glGetProgramiv = (PFNGLGETPROGRAMIVPROC)load("glGetProgramiv");
	glad_glGetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC)load("glGetProgramInfoLog");
	glad_glGetShaderiv = (PFNGLGETSHADERIVPROC)load("glGetShaderiv");
	glad_glGetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC)load("glGetShaderInfoLog");
	glad_glGetShaderSource = (PFNGLGETSHADERSOURCEPROC)load("glGetShaderSource");
	glad_glGetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC)load("glGetUniformLocation");
	glad_glGetUniformfv = (PFNGLGETUNIFORMFVPROC)load("glGetUniformfv");
	glad_glGetUniformiv = (PFNGLGETUNIFORMIVPROC)load("glGetUniformiv");
	glad_glGetVertexAttribdv = (PFNGLGETVERTEXATTRIBDVPROC)load("glGetVertexAttribdv");
	glad_glGetVertexAttribfv = (PFNGLGETVERTEXATTRIBFVPROC)load("glGetVertexAttribfv");
	glad_glGetVertexAttribiv = (PFNGLGETVERTEXATTRIBIVPROC)load("glGetVertexAttribiv");
	glad_glGetVertexAttribPointerv = (PFNGLGETVERTEXATTRIBPOINTERVPROC)load("glGetVertexAttribPointerv");
	glad_glIsProgram = (PFNGLISPROGRAMPROC)load("glIsProgram");
	glad_glIsShader = (PFNGLISSHADERPROC)load("glIsShader");
	glad_glLinkProgram = (PFNGLLINKPROGRAMPROC)load("glLinkProgram");
	glad_glShaderSource = (PFNGLSHADERSOURCEPROC)load("glShaderSource");
	glad_glUseProgram = (PFNGLUSEPROGRAMPROC)load("glUseProgram");
	glad_glUniform1f = (PFNGLUNIFORM1FPROC)load("glUniform1f");
	glad_glUniform2f = (PFNGLUNIFORM2FPROC)load("glUniform2f");
	glad_glUniform3f = (PFNGLUNIFORM3FPROC)load("glUniform3f");
	glad_glUniform4f = (PFNGLUNIFORM4FPROC)load("glUniform4f");
	glad_glUniform1i = (PFNGLUNIFORM1IPROC)load("glUniform1i");
	glad_glUniform2i = (PFNGLUNIFORM2IPROC)load("glUniform2i");
	glad_glUniform3i = (PFNGLUNIFORM3IPROC)load("glUniform3i");
	glad_glUniform4i = (PFNGLUNIFORM4IPROC)load("glUniform4i");
	glad_glUniform1fv = (PFNGLUNIFORM1FVPROC)load("glUniform1fv");
	glad_glUniform2fv = (PFNGLUNIFORM2FVPROC)load("glUniform2fv");
	glad_glUniform3fv = (PFNGLUNIFORM3FVPROC)load("glUniform3fv");
	glad_glUniform4fv = (PFNGLUNIFORM4FVPROC)load("glUniform4fv");
	glad_glUniform1iv = (PFNGLUNIFORM1IVPROC)load("glUniform1iv");
	glad_glUniform2iv = (PFNGLUNIFORM2IVPROC)load("glUniform2iv");
	glad_glUniform3iv = (PFNGLUNIFORM3IVPROC)load("glUniform3iv");
	glad_glUniform4iv = (PFNGLUNIFORM4IVPROC)load("glUniform4iv");
	glad_glUniformMatrix2fv = (PFNGLUNIFORMMATRIX2FVPROC)load("glUniformMatrix2fv");
	glad_glUniformMatrix3fv = (PFNGLUNIFORMMATRIX3FVPROC)load("glUniformMatrix3fv");
	glad_glUniformMatrix4fv = (PFNGLUNIFORMMATRIX4FVPROC)load("glUniformMatrix4fv");
	glad_glValidateProgram = (PFNGLVALIDATEPROGRAMPROC)load("glValidateProgram");
	glad_glVertexAttrib1d = (PFNGLVERTEXATTRIB1DPROC)load("glVertexAttrib1d");
	glad_glVertexAttrib1dv = (PFNGLVERTEXATTRIB1DVPROC)load("glVertexAttrib1dv");
	glad_glVertexAttrib1f = (PFNGLVERTEXATTRIB1FPROC)load("glVertexAttrib1f");
	glad_glVertexAttrib1fv = (PFNGLVERTEXATTRIB1FVPROC)load("glVertexAttrib1fv");
	glad_glVertexAttrib1s = (PFNGLVERTEXATTRIB1SPROC)load("glVertexAttrib1s");
	glad_glVertexAttrib1sv = (PFNGLVERTEXATTRIB1SVPROC)load("glVertexAttrib1sv");
	glad_glVertexAttrib2d = (PFNGLVERTEXATTRIB2DPROC)load("glVertexAttrib2d");
	glad_glVertexAttrib2dv = (PFNGLVERTEXATTRIB2DVPROC)load("glVertexAttrib2dv");
	glad_glVertexAttrib2f = (PFNGLVERTEXATTRIB2FPROC)load("glVertexAttrib2f");
	glad_glVertexAttrib2fv = (PFNGLVERTEXATTRIB2FVPROC)load("glVertexAttrib2fv");
	glad_glVertexAttrib2s = (PFNGLVERTEXATTRIB2SPROC)load("glVertexAttrib2s");
	glad_glVertexAttrib2sv = (PFNGLVERTEXATTRIB2SVPROC)load("glVertexAttrib2sv");
	glad_glVertexAttrib3d = (PFNGLVERTEXATTRIB3DPROC)load("glVertexAttrib3d");
	glad_glVertexAttrib3dv = (PFNGLVERTEXATTRIB3DVPROC)load("glVertexAttrib3dv");
	glad_glVertexAttrib3f = (PFNGLVERTEXATTRIB3FPROC)load("glVertexAttrib3f");
	glad_glVertexAttrib3fv = (PFNGLVERTEXATTRIB3FVPROC)load("glVertexAttrib3fv");
	glad_glVertexAttrib3s = (PFNGLVERTEXATTRIB3SPROC)load("glVertexAttrib3s");
	glad_glVertexAttrib3sv = (PFNGLVERTEXATTRIB3SVPROC)load("glVertexAttrib3sv");
	glad_glVertexAttrib4Nbv = (PFNGLVERTEXATTRIB4NBVPROC)load("glVertexAttrib4Nbv");
	glad_glVertexAttrib4Niv = (PFNGLVERTEXATTRIB4NIVPROC)load("glVertexAttrib4Niv");
	glad_glVertexAttrib4Nsv = (PFNGLVERTEXATTRIB4NSVPROC)load("glVertexAttrib4Nsv");
	glad_glVertexAttrib4Nub = (PFNGLVERTEXATTRIB4NUBPROC)load("glVertexAttrib4Nub");
	glad_glVertexAttrib4Nubv = (PFNGLVERTEXATTRIB4NUBVPROC)load("glVertexAttrib4Nubv");
	glad_glVertexAttrib4Nuiv = (PFNGLVERTEXATTRIB4NUIVPROC)load("glVertexAttrib4Nuiv");
	glad_glVertexAttrib4Nusv = (PFNGLVERTEXATTRIB4NUSVPROC)load("glVertexAttrib4Nusv");
	glad_glVertexAttrib4bv = (PFNGLVERTEXATTRIB4BVPROC)load("glVertexAttrib4bv");
	glad_glVertexAttrib4d = (PFNGLVERTEXATTRIB4DPROC)load("glVertexAttrib4d");
	glad_glVertexAttrib4dv = (PFNGLVERTEXATTRIB4DVPROC)load("glVertexAttrib4dv");
	glad_glVertexAttrib4f = (PFNGLVERTEXATTRIB4FPROC)load("glVertexAttrib4f");
	glad_glVertexAttrib4fv = (PFNGLVERTEXATTRIB4FVPROC)load("glVertexAttrib4fv");
	glad_glVertexAttrib4iv = (PFNGLVERTEXATTRIB4IVPROC)load("glVertexAttrib4iv");
	glad_glVertexAttrib4s = (PFNGLVERTEXATTRIB4SPROC)load("glVertexAttrib4s");
	glad_glVertexAttrib4sv = (PFNGLVERTEXATTRIB4SVPROC)load("glVertexAttrib4sv");
	glad_glVertexAttrib4ubv = (PFNGLVERTEXATTRIB4UBVPROC)load("glVertexAttrib4ubv");
	glad_glVertexAttrib4uiv = (PFNGLVERTEXATTRIB4UIVPROC)load("glVertexAttrib4uiv");
	glad_glVertexAttrib4usv = (PFNGLVERTEXATTRIB4USVPROC)load("glVertexAttrib4usv");
	glad_glVertexAttribPointer = (PFNGLVERTEXATTRIBPOINTERPROC)load("glVertexAttribPointer");
}
static void load_GL_VERSION_2_1(GLADloadproc load) {
	if(!GLAD_GL_VERSION_2_1) return;
	glad_glUniformMatrix2x3fv = (PFNGLUNIFORMMATRIX2X3FVPROC)load("glUniformMatrix2x3fv");
	glad_glUniformMatrix3x2fv = (PFNGLUNIFORMMATRIX3X2FVPROC)load("glUniformMatrix3x2fv");
	glad_glUniformMatrix2x4fv = (PFNGLUNIFORMMATRIX2X4FVPROC)load("glUniformMatrix2x4fv");
	glad_glUniformMatrix4x2fv = (PFNGLUNIFORMMATRIX4X2FVPROC)load("glUniformMatrix4x2fv");
	glad_glUniformMatrix3x4fv = (PFNGLUNIFORMMATRIX3X4FVPROC)load("glUniformMatrix3x4fv");
	glad_glUniformMatrix4x3fv = (PFNGLUNIFORMMATRIX4X3FVPROC)load("glUniformMatrix4x3fv");
}
static void load_GL_VERSION_3_0(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_0) return;
	glad_glColorMaski = (PFNGLCOLORMASKIPROC)load("glColorMaski");
	glad_glGetBooleani_v = (PFNGLGETBOOLEANI_VPROC)load("glGetBooleani_v");
	glad_glGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)load("glGetIntegeri_v");
	glad_glEnablei = (PFNGLENABLEIPROC)load("glEnablei");
	glad_glDisablei = (PFNGLDISABLEIPROC)load("glDisablei");
	glad_glIsEnabledi = (PFNGLISENABLEDIPROC)load("glIsEnabledi");
	glad_glBeginTransformFeedback = (PFNGLBEGINTRANSFORMFEEDBACKPROC)load("glBeginTransformFeedback");
	glad_glEndTransformFeedback = (PFNGLENDTRANSFORMFEEDBACKPROC)load("glEndTransformFeedback");
	glad_glBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)load("glBindBufferRange");
	glad_glBindBufferBase = (PFNGLBINDBUFFERBASEPROC)load("glBindBufferBase");
	glad_glTransformFeedbackVaryings = (PFNGLTRANSFORMFEEDBACKVARYINGSPROC)load("glTransformFeedbackVaryings");
	glad_glGetTransformFeedbackVarying = (PFNGLGETTRANSFORMFEEDBACKVARYINGPROC)load("glGetTransformFeedbackVarying");
	glad_glClampColor = (PFNGLCLAMPCOLORPROC)load("glClampColor");
	glad_glBeginConditionalRender = (PFNGLBEGINCONDITIONALRENDERPROC)load("glBeginConditionalRender");
	glad_glEndConditionalRender = (PFNGLENDCONDITIONALRENDERPROC)load("glEndConditionalRender");
	glad_glVertexAttribIPointer = (PFNGLVERTEXATTRIBIPOINTERPROC)load("glVertexAttribIPointer");
	glad_glGetVertexAttribIiv = (PFNGLGETVERTEXATTRIBIIVPROC)load("glGetVertexAttribIiv");
	glad_glGetVertexAttribIuiv = (PFNGLGETVERTEXATTRIBIUIVPROC)load("glGetVertexAttribIuiv");
	glad_glVertexAttribI1i = (PFNGLVERTEXATTRIBI1IPROC)load("glVertexAttribI1i");
	glad_glVertexAttribI2i = (PFNGLVERTEXATTRIBI2IPROC)load("glVertexAttribI2i");
	glad_glVertexAttribI3i = (PFNGLVERTEXATTRIBI3IPROC)load("glVertexAttribI3i");
	glad_glVertexAttribI4i = (PFNGLVERTEXATTRIBI4IPROC)load("glVertexAttribI4i");
	glad_glVertexAttribI1ui = (PFNGLVERTEXATTRIBI1UIPROC)load("glVertexAttribI1ui");
	glad_glVertexAttribI2ui = (PFNGLVERTEXATTRIBI2UIPROC)load("glVertexAttribI2ui");
	glad_glVertexAttribI3ui = (PFNGLVERTEXATTRIBI3UIPROC)load("glVertexAttribI3ui");
	glad_glVertexAttribI4ui = (PFNGLVERTEXATTRIBI4UIPROC)load("glVertexAttribI4ui");
	glad_glVertexAttribI1iv = (PFNGLVERTEXATTRIBI1IVPROC)load("glVertexAttribI1iv");
	glad_glVertexAttribI2iv = (PFNGLVERTEXATTRIBI2IVPROC)load("glVertexAttribI2iv");
	glad_glVertexAttribI3iv = (PFNGLVERTEXATTRIBI3IVPROC)load("glVertexAttribI3iv");
	glad_glVertexAttribI4iv = (PFNGLVERTEXATTRIBI4IVPROC)load("glVertexAttribI4iv");
	glad_glVertexAttribI1uiv = (PFNGLVERTEXATTRIBI1UIVPROC)load("glVertexAttribI1uiv");
	glad_glVertexAttribI2uiv = (PFNGLVERTEXATTRIBI2UIVPROC)load("glVertexAttribI2uiv");
	glad_glVertexAttribI3uiv = (PFNGLVERTEXATTRIBI3UIVPROC)load("glVertexAttribI3uiv");
	glad_glVertexAttribI4uiv = (PFNGLVERTEXATTRIBI4UIVPROC)load("glVertexAttribI4uiv");
	glad_glVertexAttribI4bv = (PFNGLVERTEXATTRIBI4BVPROC)load("glVertexAttribI4bv");
	glad_glVertexAttribI4sv = (PFNGLVERTEXATTRIBI4SVPROC)load("glVertexAttribI4sv");
	glad_glVertexAttribI4ubv = (PFNGLVERTEXATTRIBI4UBVPROC)load("glVertexAttribI4ubv");
	glad_glVertexAttribI4usv = (PFNGLVERTEXATTRIBI4USVPROC)load("glVertexAttribI4usv");
	glad_glGetUniformuiv = (PFNGLGETUNIFORMUIVPROC)load("glGetUniformuiv");
	glad_glBindFragDataLocation = (PFNGLBINDFRAGDATALOCATIONPROC)load("glBindFragDataLocation");
	glad_glGetFragDataLocation = (PFNGLGETFRAGDATALOCATIONPROC)load("glGetFragDataLocation");
	glad_glUniform1ui = (PFNGLUNIFORM1UIPROC)load("glUniform1ui");
	glad_glUniform2ui = (PFNGLUNIFORM2UIPROC)load("glUniform2ui");
	glad_glUniform3ui = (PFNGLUNIFORM3UIPROC)load("glUniform3ui");
	glad_glUniform4ui = (PFNGLUNIFORM4UIPROC)load("glUniform4ui");
	glad_glUniform1uiv = (PFNGLUNIFORM1UIVPROC)load("glUniform1uiv");
	glad_glUniform2uiv = (PFNGLUNIFORM2UIVPROC)load("glUniform2uiv");
	glad_glUniform3uiv = (PFNGLUNIFORM3UIVPROC)load("glUniform3uiv");
	glad_glUniform4uiv = (PFNGLUNIFORM4UIVPROC)load("glUniform4uiv");
	glad_glTexParameterIiv = (PFNGLTEXPARAMETERIIVPROC)load("glTexParameterIiv");
	glad_glTexParameterIuiv = (PFNGLTEXPARAMETERIUIVPROC)load("glTexParameterIuiv");
	glad_glGetTexParameterIiv = (PFNGLGETTEXPARAMETERIIVPROC)load("glGetTexParameterIiv");
	glad_glGetTexParameterIuiv = (PFNGLGETTEXPARAMETERIUIVPROC)load("glGetTexParameterIuiv");
	glad_glClearBufferiv = (PFNGLCLEARBUFFERIVPROC)load("glClearBufferiv");
	glad_glClearBufferuiv = (PFNGLCLEARBUFFERUIVPROC)load("glClearBufferuiv");
	glad_glClearBufferfv = (PFNGLCLEARBUFFERFVPROC)load("glClearBufferfv");
	glad_glClearBufferfi = (PFNGLCLEARBUFFERFIPROC)load("glClearBufferfi");
	glad_glGetStringi = (PFNGLGETSTRINGIPROC)load("glGetStringi");
	glad_glIsRenderbuffer = (PFNGLISRENDERBUFFERPROC)load("glIsRenderbuffer");
	glad_glBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC)load("glBindRenderbuffer");
	glad_glDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC)load("glDeleteRenderbuffers");
	glad_glGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC)load("glGenRenderbuffers");
	glad_glRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC)load("glRenderbufferStorage");
	glad_glGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC)load("glGetRenderbufferParameteriv");
	glad_glIsFramebuffer = (PFNGLISFRAMEBUFFERPROC)load("glIsFramebuffer");
	glad_glBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC)load("glBindFramebuffer");
	glad_glDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC)load("glDeleteFramebuffers");
	glad_glGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC)load("glGenFramebuffers");
	glad_glCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC)load("glCheckFramebufferStatus");
	glad_glFramebufferTexture1D = (PFNGLFRAMEBUFFERTEXTURE1DPROC)load("glFramebufferTexture1D");
	glad_glFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC)load("glFramebufferTexture2D");
	glad_glFramebufferTexture3D = (PFNGLFRAMEBUFFERTEXTURE3DPROC)load("glFramebufferTexture3D");
	glad_glFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC)load("glFramebufferRenderbuffer");
	glad_glGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC)load("glGetFramebufferAttachmentParameteriv");
	glad_glGenerateMipmap = (PFNGLGENERATEMIPMAPPROC)load("glGenerateMipmap");
	glad_glBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC)load("glBlitFramebuffer");
	glad_glRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC)load("glRenderbufferStorageMultisample");
	glad_glFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC)load("glFramebufferTextureLayer");
	glad_glMapBufferRange = (PFNGLMAPBUFFERRANGEPROC)load("glMapBufferRange");
	glad_glFlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC)load("glFlushMappedBufferRange");
	glad_glBindVertexArray = (PFNGLBINDVERTEXARRAYPROC)load("glBindVertexArray");
	glad_glDeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC)load("glDeleteVertexArrays");
	glad_glGenVertexArrays = (PFNGLGENVERTEXARRAYSPROC)load("glGenVertexArrays");
	glad_glIsVertexArray = (PFNGLISVERTEXARRAYPROC)load("glIsVertexArray");
}
static void load_GL_VERSION_3_1(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_1) return;
	glad_glDrawArraysInstanced = (PFNGLDRAWARRAYSINSTANCEDPROC)load("glDrawArraysInstanced");
	glad_glDrawElementsInstanced = (PFNGLDRAWELEMENTSINSTANCEDPROC)load("glDrawElementsInstanced");
	glad_glTexBuffer = (PFNGLTEXBUFFERPROC)load("glTexBuffer");
	glad_glPrimitiveRestartIndex = (PFNGLPRIMITIVERESTARTINDEXPROC)load("glPrimitiveRestartIndex");
	glad_glCopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC)load("glCopyBufferSubData");
	glad_glGetUniformIndices = (PFNGLGETUNIFORMINDICESPROC)load("glGetUniformIndices");
	glad_glGetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC)load("glGetActiveUniformsiv");
	glad_glGetActiveUniformName = (PFNGLGETACTIVEUNIFORMNAMEPROC)load("glGetActiveUniformName");
	glad_glGetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC)load("glGetUniformBlockIndex");
	glad_glGetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC)load("glGetActiveUniformBlockiv");
	glad_glGetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC)load("glGetActiveUniformBlockName");
	glad_glUniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC)load("glUniformBlockBinding");
	glad_glBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)load("glBindBufferRange");
	glad_glBindBufferBase = (PFNGLBINDBUFFERBASEPROC)load("glBindBufferBase");
	glad_glGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)load("glGetIntegeri_v");
}
static void load_GL_VERSION_3_2(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_2) return;
	glad_glDrawElementsBaseVertex = (PFNGLDRAWELEMENTSBASEVERTEXPROC)load("glDrawElementsBaseVertex");
	glad_glDrawRangeElementsBaseVertex = (PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC)load("glDrawRangeElementsBaseVertex");
	glad_glDrawElementsInstancedBaseVertex = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC)load("glDrawElementsInstancedBaseVertex");
	glad_glMultiDrawElementsBaseVertex = (PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC)load("glMultiDrawElementsBaseVertex");
	glad_glProvokingVertex = (PFNGLPROVOKINGVERTEXPROC)load("glProvokingVertex");
	glad_glFenceSync = (PFNGLFENCESYNCPROC)load("glFenceSync");
	glad_glIsSync = (PFNGLISSYNCPROC)load("glIsSync");
	glad_glDeleteSync = (PFNGLDELETESYNCPROC)load("glDeleteSync");
	glad_glClientWaitSync = (PFNGLCLIENTWAITSYNCPROC)load("glClientWaitSync");
	glad_glWaitSync = (PFNGLWAITSYNCPROC)load("glWaitSync");
	glad_glGetInteger64v = (PFNGLGETINTEGER64VPROC)load("glGetInteger64v");
	glad_glGetSynciv = (PFNGLGETSYNCIVPROC)load("glGetSynciv");
	glad_glGetInteger64i_v = (PFNGLGETINTEGER64I_VPROC)load("glGetInteger64i_v");
	glad_glGetBufferParameteri64v = (PFNGLGETBUFFERPARAMETERI64VPROC)load("glGetBufferParameteri64v");
	glad_glFramebufferTexture = (PFNGLFRAMEBUFFERTEXTUREPROC)load("glFramebufferTexture");
	glad_glTexImage2DMultisample = (PFNGLTEXIMAGE2DMULTISAMPLEPROC)load("glTexImage2DMultisample");
	glad_glTexImage3DMultisample = (PFNGLTEXIMAGE3DMULTISAMPLEPROC)load("glTexImage3DMultisample");
	glad_glGetMultisamplefv = (PFNGLGETMULTISAMPLEFVPROC)load("glGetMultisamplefv");
	glad_glSampleMaski = (PFNGLSAMPLEMASKIPROC)load("glSampleMaski");
}
static void load_GL_VERSION_3_3(GLADloadproc load) {
	if(!GLAD_GL_VERSION_3_3) return;
	glad_glBindFragDataLocationIndexed = (PFNGLBINDFRAGDATALOCATIONINDEXEDPROC)load("glBindFragDataLocationIndexed");
	glad_glGetFragDataIndex = (PFNGLGETFRAGDATAINDEXPROC)load("glGetFragDataIndex");
	glad_glGenSamplers = (PFNGLGENSAMPLERSPROC)load("glGenSamplers");
	glad_glDeleteSamplers = (PFNGLDELETESAMPLERSPROC)load("glDeleteSamplers");
	glad_glIsSampler = (PFNGLISSAMPLERPROC)load("glIsSampler");
	glad_glBindSampler = (PFNGLBINDSAMPLERPROC)load("glBindSampler");
	glad_glSamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC)load("glSamplerParameteri");
	glad_glSamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC)load("glSamplerParameteriv");
	glad_glSamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC)load("glSamplerParameterf");
	glad_glSamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC)load("glSamplerParameterfv");
	glad_glSamplerParameterIiv = (PFNGLSAMPLERPARAMETERIIVPROC)load("glSamplerParameterIiv");
	glad_glSamplerParameterIuiv = (PFNGLSAMPLERPARAMETERIUIVPROC)load("glSamplerParameterIuiv");
	glad_glGetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC)load("glGetSamplerParameteriv");
	glad_glGetSamplerParameterIiv = (PFNGLGETSAMPLERPARAMETERIIVPROC)load("glGetSamplerParameterIiv");
	glad_glGetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC)load("glGetSamplerParameterfv");
	glad_glGetSamplerParameterIuiv = (PFNGLGETSAMPLERPARAMETERIUIVPROC)load("glGetSamplerParameterIuiv");
	glad_glQueryCounter = (PFNGLQUERYCOUNTERPROC)load("glQueryCounter");
	glad_glGetQueryObjecti64v = (PFNGLGETQUERYOBJECTI64VPROC)load("glGetQueryObjecti64v");
	glad_glGetQueryObjectui64v = (PFNGLGETQUERYOBJECTUI64VPROC)load("glGetQueryObjectui64v");
	glad_glVertexAttribDivisor = (PFNGLVERTEXATTRIBDIVISORPROC)load("glVertexAttribDivisor");
	glad_glVertexAttribP1ui = (PFNGLVERTEXATTRIBP1UIPROC)load("glVertexAttribP1ui");
	glad_glVertexAttribP1uiv = (PFNGLVERTEXATTRIBP1UIVPROC)load("glVertexAttribP1uiv");
	glad_glVertexAttribP2ui = (PFNGLVERTEXATTRIBP2UIPROC)load("glVertexAttribP2ui");
	glad_glVertexAttribP2uiv = (PFNGLVERTEXATTRIBP2UIVPROC)load("glVertexAttribP2uiv");
	glad_glVertexAttribP3ui = (PFNGLVERTEXATTRIBP3UIPROC)load("glVertexAttribP3ui");
	glad_glVertexAttribP3uiv = (PFNGLVERTEXATTRIBP3UIVPROC)load("glVertexAttribP3uiv");
	glad_glVertexAttribP4ui = (PFNGLVERTEXATTRIBP4UIPROC)load("glVertexAttribP4ui");
	glad_glVertexAttribP4uiv = (PFNGLVERTEXATTRIBP4UIVPROC)load("glVertexAttribP4uiv");
	glad_glVertexP2ui = (PFNGLVERTEXP2UIPROC)load("glVertexP2ui");
	glad_glVertexP2uiv = (PFNGLVERTEXP2UIVPROC)load("glVertexP2uiv");
	glad_glVertexP3ui = (PFNGLVERTEXP3UIPROC)load("glVertexP3ui");
	glad_glVertexP3uiv = (PFNGLVERTEXP3UIVPROC)load("glVertexP3uiv");
	glad_glVertexP4ui = (PFNGLVERTEXP4UIPROC)load("glVertexP4ui");
	glad_glVertexP4uiv = (PFNGLVERTEXP4UIVPROC)load("glVertexP4uiv");
	glad_glTexCoordP1ui = (PFNGLTEXCOORDP1UIPROC)load("glTexCoordP1ui");
	glad_glTexCoordP1uiv = (PFNGLTEXCOORDP1UIVPROC)load("glTexCoordP1uiv");
	glad_glTexCoordP2ui = (PFNGLTEXCOORDP2UIPROC)load("glTexCoordP2ui");
	glad_glTexCoordP2uiv = (PFNGLTEXCOORDP2UIVPROC)load("glTexCoordP2uiv");
	glad_glTexCoordP3ui = (PFNGLTEXCOORDP3UIPROC)load("glTexCoordP3ui");
	glad_glTexCoordP3uiv = (PFNGLTEXCOORDP3UIVPROC)load("glTexCoordP3uiv");
	glad_glTexCoordP4ui = (PFNGLTEXCOORDP4UIPROC)load("glTexCoordP4ui");
	glad_glTexCoordP4uiv = (PFNGLTEXCOORDP4UIVPROC)load("glTexCoordP4uiv");
	glad_glMultiTexCoordP1ui = (PFNGLMULTITEXCOORDP1UIPROC)load("glMultiTexCoordP1ui");
	glad_glMultiTexCoordP1uiv = (PFNGLMULTITEXCOORDP1UIVPROC)load("glMultiTexCoordP1uiv");
	glad_glMultiTexCoordP2ui = (PFNGLMULTITEXCOORDP2UIPROC)load("glMultiTexCoordP2ui");
	glad_glMultiTexCoordP2uiv = (PFNGLMULTITEXCOORDP2UIVPROC)load("glMultiTexCoordP2uiv");
	glad_glMultiTexCoordP3ui = (PFNGLMULTITEXCOORDP3UIPROC)load("glMultiTexCoordP3ui");
	glad_glMultiTexCoordP3uiv = (PFNGLMULTITEXCOORDP3UIVPROC)load("glMultiTexCoordP3uiv");
	glad_glMultiTexCoordP4ui = (PFNGLMULTITEXCOORDP4UIPROC)load("glMultiTexCoordP4ui");
	glad_glMultiTexCoordP4uiv = (PFNGLMULTITEXCOORDP4UIVPROC)load("glMultiTexCoordP4uiv");
	glad_glNormalP3ui = (PFNGLNORMALP3UIPROC)load("glNormalP3ui");
	glad_glNormalP3uiv = (PFNGLNORMALP3UIVPROC)load("glNormalP3uiv");
	glad_glColorP3ui = (PFNGLCOLORP3UIPROC)load("glColorP3ui");
	glad_glColorP3uiv = (PFNGLCOLORP3UIVPROC)load("glColorP3uiv");
	glad_glColorP4ui = (PFNGLCOLORP4UIPROC)load("glColorP4ui");
	glad_glColorP4uiv = (PFNGLCOLORP4UIVPROC)load("glColorP4uiv");
	glad_glSecondaryColorP3ui = (PFNGLSECONDARYCOLORP3UIPROC)load("glSecondaryColorP3ui");
	glad_glSecondaryColorP3uiv = (PFNGLSECONDARYCOLORP3UIVPROC)load("glSecondaryColorP3uiv");
}
static void load_GL_ARB_draw_elements_base_vertex(GLADloadproc load) {
	if(!GLAD_GL_ARB_draw_elements_base_vertex) return;
	glad_glDrawElementsBaseVertex = (PFNGLDRAWELEMENTSBASEVERTEXPROC)load("glDrawElementsBaseVertex");
	glad_glDrawRangeElementsBaseVertex = (PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC)load("glDrawRangeElementsBaseVertex");
	glad_glDrawElementsInstancedBaseVertex = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC)load("glDrawElementsInstancedBaseVertex");
	glad_glMultiDrawElementsBaseVertex = (PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC)load("glMultiDrawElementsBaseVertex");
}
static int find_extensionsGL(void) {
	if (!get_exts()) return 0;
	GLAD_GL_ARB_ES3_compatibility = has_ext("GL_ARB_ES3_compatibility");
	GLAD_GL_ARB_draw_elements_base_vertex = has_ext("GL_ARB_draw_elements_base_vertex");
	GLAD_GL_EXT_texture_compression_s3tc = has_ext("GL_EXT_texture_compression_s3tc");
	GLAD_GL_EXT_texture_filter_anisotropic = has_ext("GL_EXT_texture_filter_anisotropic");
	free_exts();
	return 1;
}

static void find_coreGL(void) {

    /* Thank you @elmindreda
     * https://github.com/elmindreda/greg/blob/master/templates/greg.c.in#L176
     * https://github.com/glfw/glfw/blob/master/src/context.c#L36
     */
    int i, major, minor;

    const char* version;
    const char* prefixes[] = {
        "OpenGL ES-CM ",
        "OpenGL ES-CL ",
        "OpenGL ES ",
        NULL
    };

    version = (const char*) glGetString(GL_VERSION);
    if (!version) return;

    for (i = 0;  prefixes[i];  i++) {
        const size_t length = strlen(prefixes[i]);
        if (strncmp(version, prefixes[i], length) == 0) {
            version += length;
            break;
        }
    }

/* PR #18 */
#ifdef _MSC_VER
    sscanf_s(version, "%d.%d", &major, &minor);
#else
    sscanf(version, "%d.%d", &major, &minor);
#endif

    GLVersion.major = major; GLVersion.minor = minor;
    max_loaded_major = major; max_loaded_minor = minor;
	GLAD_GL_VERSION_1_0 = (major == 1 && minor >= 0) || major > 1;
	GLAD_GL_VERSION_1_1 = (major == 1 && minor >= 1) || major > 1;
	GLAD_GL_VERSION_1_2 = (major == 1 && minor >= 2) || major > 1;
	GLAD_GL_VERSION_1_3 = (major == 1 && minor >= 3) || major > 1;
	GLAD_GL_VERSION_1_4 = (major == 1 && minor >= 4) || major > 1;
	GLAD_GL_VERSION_1_5 = (major == 1 && minor >= 5) || major > 1;
	GLAD_GL_VERSION_2_0 = (major == 2 && minor >= 0) || major > 2;
	GLAD_GL_VERSION_2_1 = (major == 2 && minor >= 1) || major > 2;
	GLAD_GL_VERSION_3_0 = (major == 3 && minor >= 0) || major > 3;
	GLAD_GL_VERSION_3_1 = (major == 3 && minor >= 1) || major > 3;
	GLAD_GL_VERSION_3_2 = (major == 3 && minor >= 2) || major > 3;
	GLAD_GL_VERSION_3_3 = (major == 3 && minor >= 3) || major > 3;
	if (GLVersion.major > 3 || (GLVersion.major >= 3 && GLVersion.minor >= 3)) {
		max_loaded_major = 3;
		max_loaded_minor = 3;
	}
}

int gladLoadGLLoader(GLADloadproc load) {
	GLVersion.major = 0; GLVersion.minor = 0;
	glGetString = (PFNGLGETSTRINGPROC)load("glGetString");
	if(glGetString == NULL) return 0;
	if(glGetString(GL_VERSION) == NULL) return 0;
	find_coreGL();
	load_GL_VERSION_1_0(load);
	load_GL_VERSION_1_1(load);
	load_GL_VERSION_1_2(load);
	load_GL_VERSION_1_3(load);
	load_GL_VERSION_1_4(load);
	load_GL_VERSION_1_5(load);
	load_GL_VERSION_2_0(load);
	load_GL_VERSION_2_1(load);
	load_GL_VERSION_3_0(load);
	load_GL_VERSION_3_1(load);
	load_GL_VERSION_3_2(load);
	load_GL_VERSION_3_3(load);

	if (!find_extensionsGL()) return 0;
	load_GL_ARB_draw_elements_base_vertex(load);
	return GLVersion.major != 0 || GLVersion.minor != 0;
}

static void load_GL_ES_VERSION_2_0(GLADloadproc load) {
	if(!GLAD_GL_ES_VERSION_2_0) return;
	glad_glActiveTexture = (PFNGLACTIVETEXTUREPROC)load("glActiveTexture");
	glad_glAttachShader = (PFNGLATTACHSHADERPROC)load("glAttachShader");
	glad_glBindAttribLocation = (PFNGLBINDATTRIBLOCATIONPROC)load("glBindAttribLocation");
	glad_glBindBuffer = (PFNGLBINDBUFFERPROC)load("glBindBuffer");
	glad_glBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC)load("glBindFramebuffer");
	glad_glBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC)load("glBindRenderbuffer");
	glad_glBindTexture = (PFNGLBINDTEXTUREPROC)load("glBindTexture");
	glad_glBlendColor = (PFNGLBLENDCOLORPROC)load("glBlendColor");
	glad_glBlendEquation = (PFNGLBLENDEQUATIONPROC)load("glBlendEquation");
	glad_glBlendEquationSeparate = (PFNGLBLENDEQUATIONSEPARATEPROC)load("glBlendEquationSeparate");
	glad_glBlendFunc = (PFNGLBLENDFUNCPROC)load("glBlendFunc");
	glad_glBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC)load("glBlendFuncSeparate");
	glad_glBufferData = (PFNGLBUFFERDATAPROC)load("glBufferData");
	glad_glBufferSubData = (PFNGLBUFFERSUBDATAPROC)load("glBufferSubData");
	glad_glCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC)load("glCheckFramebufferStatus");
	glad_glClear = (PFNGLCLEARPROC)load("glClear");
	glad_glClearColor = (PFNGLCLEARCOLORPROC)load("glClearColor");
	glad_glClearDepthf = (PFNGLCLEARDEPTHFPROC)load("glClearDepthf");
	glad_glClearStencil = (PFNGLCLEARSTENCILPROC)load("glClearStencil");
	glad_glColorMask = (PFNGLCOLORMASKPROC)load("glColorMask");
	glad_glCompileShader = (PFNGLCOMPILESHADERPROC)load("glCompileShader");
	glad_glCompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC)load("glCompressedTexImage2D");
	glad_glCompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC)load("glCompressedTexSubImage2D");
	glad_glCopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC)load("glCopyTexImage2D");
	glad_glCopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC)load("glCopyTexSubImage2D");
	glad_glCreateProgram = (PFNGLCREATEPROGRAMPROC)load("glCreateProgram");
	glad_glCreateShader = (PFNGLCREATESHADERPROC)load("glCreateShader");
	glad_glCullFace = (PFNGLCULLFACEPROC)load("glCullFace");
	glad_glDeleteBuffers = (PFNGLDELETEBUFFERSPROC)load("glDeleteBuffers");
	glad_glDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC)load("glDeleteFramebuffers");
	glad_glDeleteProgram = (PFNGLDELETEPROGRAMPROC)load("glDeleteProgram");
	glad_glDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC)load("glDeleteRenderbuffers");
	glad_glDeleteShader = (PFNGLDELETESHADERPROC)load("glDeleteShader");
	glad_glDeleteTextures = (PFNGLDELETETEXTURESPROC)load("glDeleteTextures");
	glad_glDepthFunc = (PFNGLDEPTHFUNCPROC)load("glDepthFunc");
	glad_glDepthMask = (PFNGLDEPTHMASKPROC)load("glDepthMask");
	glad_glDepthRangef = (PFNGLDEPTHRANGEFPROC)load("glDepthRangef");
	glad_glDetachShader = (PFNGLDETACHSHADERPROC)load("glDetachShader");
	glad_glDisable = (PFNGLDISABLEPROC)load("glDisable");
	glad_glDisableVertexAttribArray = (PFNGLDISABLEVERTEXATTRIBARRAYPROC)load("glDisableVertexAttribArray");
	glad_glDrawArrays = (PFNGLDRAWARRAYSPROC)load("glDrawArrays");
	glad_glDrawElements = (PFNGLDRAWELEMENTSPROC)load("glDrawElements");
	glad_glEnable = (PFNGLENABLEPROC)load("glEnable");
	glad_glEnableVertexAttribArray = (PFNGLENABLEVERTEXATTRIBARRAYPROC)load("glEnableVertexAttribArray");
	glad_glFinish = (PFNGLFINISHPROC)load("glFinish");
	glad_glFlush = (PFNGLFLUSHPROC)load("glFlush");
	glad_glFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC)load("glFramebufferRenderbuffer");
	glad_glFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC)load("glFramebufferTexture2D");
	glad_glFrontFace = (PFNGLFRONTFACEPROC)load("glFrontFace");
	glad_glGenBuffers = (PFNGLGENBUFFERSPROC)load("glGenBuffers");
	glad_glGenerateMipmap = (PFNGLGENERATEMIPMAPPROC)load("glGenerateMipmap");
	glad_glGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC)load("glGenFramebuffers");
	glad_glGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC)load("glGenRenderbuffers");
	glad_glGenTextures = (PFNGLGENTEXTURESPROC)load("glGenTextures");
	glad_glGetActiveAttrib = (PFNGLGETACTIVEATTRIBPROC)load("glGetActiveAttrib");
	glad_glGetActiveUniform = (PFNGLGETACTIVEUNIFORMPROC)load("glGetActiveUniform");
	glad_glGetAttachedShaders = (PFNGLGETATTACHEDSHADERSPROC)load("glGetAttachedShaders");
	glad_glGetAttribLocation = (PFNGLGETATTRIBLOCATIONPROC)load("glGetAttribLocation");
	glad_glGetBooleanv = (PFNGLGETBOOLEANVPROC)load("glGetBooleanv");
	glad_glGetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC)load("glGetBufferParameteriv");
	glad_glGetError = (PFNGLGETERRORPROC)load("glGetError");
	glad_glGetFloatv = (PFNGLGETFLOATVPROC)load("glGetFloatv");
	glad_glGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC)load("glGetFramebufferAttachmentParameteriv");
	glad_glGetIntegerv = (PFNGLGETINTEGERVPROC)load("glGetIntegerv");
	glad_glGetProgramiv = (PFNGLGETPROGRAMIVPROC)load("glGetProgramiv");
	glad_glGetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC)load("glGetProgramInfoLog");
	glad_glGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC)load("glGetRenderbufferParameteriv");
	glad_glGetShaderiv = (PFNGLGETSHADERIVPROC)load("glGetShaderiv");
	glad_glGetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC)load("glGetShaderInfoLog");
	glad_glGetShaderPrecisionFormat = (PFNGLGETSHADERPRECISIONFORMATPROC)load("glGetShaderPrecisionFormat");
	glad_glGetShaderSource = (PFNGLGETSHADERSOURCEPROC)load("glGetShaderSource");
	glad_glGetString = (PFNGLGETSTRINGPROC)load("glGetString");
	glad_glGetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC)load("glGetTexParameterfv");
	glad_glGetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC)load("glGetTexParameteriv");
	glad_glGetUniformfv = (PFNGLGETUNIFORMFVPROC)load("glGetUniformfv");
	glad_glGetUniformiv = (PFNGLGETUNIFORMIVPROC)load("glGetUniformiv");
	glad_glGetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC)load("glGetUniformLocation");
	glad_glGetVertexAttribfv = (PFNGLGETVERTEXATTRIBFVPROC)load("glGetVertexAttribfv");
	glad_glGetVertexAttribiv = (PFNGLGETVERTEXATTRIBIVPROC)load("glGetVertexAttribiv");
	glad_glGetVertexAttribPointerv = (PFNGLGETVERTEXATTRIBPOINTERVPROC)load("glGetVertexAttribPointerv");
	glad_glHint = (PFNGLHINTPROC)load("glHint");
	glad_glIsBuffer = (PFNGLISBUFFERPROC)load("glIsBuffer");
	glad_glIsEnabled = (PFNGLISENABLEDPROC)load("glIsEnabled");
	glad_glIsFramebuffer = (PFNGLISFRAMEBUFFERPROC)load("glIsFramebuffer");
	glad_glIsProgram = (PFNGLISPROGRAMPROC)load("glIsProgram");
	glad_glIsRenderbuffer = (PFNGLISRENDERBUFFERPROC)load("glIsRenderbuffer");
	glad_glIsShader = (PFNGLISSHADERPROC)load("glIsShader");
	glad_glIsTexture = (PFNGLISTEXTUREPROC)load("glIsTexture");
	glad_glLineWidth = (PFNGLLINEWIDTHPROC)load("glLineWidth");
	glad_glLinkProgram = (PFNGLLINKPROGRAMPROC)load("glLinkProgram");
	glad_glPixelStorei = (PFNGLPIXELSTOREIPROC)load("glPixelStorei");
	glad_glPolygonOffset = (PFNGLPOLYGONOFFSETPROC)load("glPolygonOffset");
	glad_glReadPixels = (PFNGLREADPIXELSPROC)load("glReadPixels");
	glad_glReleaseShaderCompiler = (PFNGLRELEASESHADERCOMPILERPROC)load("glReleaseShaderCompiler");
	glad_glRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC)load("glRenderbufferStorage");
	glad_glSampleCoverage = (PFNGLSAMPLECOVERAGEPROC)load("glSampleCoverage");
	glad_glScissor = (PFNGLSCISSORPROC)load("glScissor");
	glad_glShaderBinary = (PFNGLSHADERBINARYPROC)load("glShaderBinary");
	glad_glShaderSource = (PFNGLSHADERSOURCEPROC)load("glShaderSource");
	glad_glStencilFunc = (PFNGLSTENCILFUNCPROC)load("glStencilFunc");
	glad_glStencilFuncSeparate = (PFNGLSTENCILFUNCSEPARATEPROC)load("glStencilFuncSeparate");
	glad_glStencilMask = (PFNGLSTENCILMASKPROC)load("glStencilMask");
	glad_glStencilMaskSeparate = (PFNGLSTENCILMASKSEPARATEPROC)load("glStencilMaskSeparate");
	glad_glStencilOp = (PFNGLSTENCILOPPROC)load("glStencilOp");
	glad_glStencilOpSeparate = (PFNGLSTENCILOPSEPARATEPROC)load("glStencilOpSeparate");
	glad_glTexImage2D = (PFNGLTEXIMAGE2DPROC)load("glTexImage2D");
	glad_glTexParameterf = (PFNGLTEXPARAMETERFPROC)load("glTexParameterf");
	glad_glTexParameterfv = (PFNGLTEXPARAMETERFVPROC)load("glTexParameterfv");
	glad_glTexParameteri = (PFNGLTEXPARAMETERIPROC)load("glTexParameteri");
	glad_glTexParameteriv = (PFNGLTEXPARAMETERIVPROC)load("glTexParameteriv");
	glad_glTexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC)load("glTexSubImage2D");
	glad_glUniform1f = (PFNGLUNIFORM1FPROC)load("glUniform1f");
	glad_glUniform1fv = (PFNGLUNIFORM1FVPROC)load("glUniform1fv");
	glad_glUniform1i = (PFNGLUNIFORM1IPROC)load("glUniform1i");
	glad_glUniform1iv = (PFNGLUNIFORM1IVPROC)load("glUniform1iv");
	glad_glUniform2f = (PFNGLUNIFORM2FPROC)load("glUniform2f");
	glad_glUniform2fv = (PFNGLUNIFORM2FVPROC)load("glUniform2fv");
	glad_glUniform2i = (PFNGLUNIFORM2IPROC)load("glUniform2i");
	glad_glUniform2iv = (PFNGLUNIFORM2IVPROC)load("glUniform2iv");
	glad_glUniform3f = (PFNGLUNIFORM3FPROC)load("glUniform3f");
	glad_glUniform3fv = (PFNGLUNIFORM3FVPROC)load("glUniform3fv");
	glad_glUniform3i = (PFNGLUNIFORM3IPROC)load("glUniform3i");
	glad_glUniform3iv = (PFNGLUNIFORM3IVPROC)load("glUniform3iv");
	glad_glUniform4f = (PFNGLUNIFORM4FPROC)load("glUniform4f");
	glad_glUniform4fv = (PFNGLUNIFORM4FVPROC)load("glUniform4fv");
	glad_glUniform4i = (PFNGLUNIFORM4IPROC)load("glUniform4i");
	glad_glUniform4iv = (PFNGLUNIFORM4IVPROC)load("glUniform4iv");
	glad_glUniformMatrix2fv = (PFNGLUNIFORMMATRIX2FVPROC)load("glUniformMatrix2fv");
	glad_glUniformMatrix3fv = (PFNGLUNIFORMMATRIX3FVPROC)load("glUniformMatrix3fv");
	glad_glUniformMatrix4fv = (PFNGLUNIFORMMATRIX4FVPROC)load("glUniformMatrix4fv");
	glad_glUseProgram = (PFNGLUSEPROGRAMPROC)load("glUseProgram");
	glad_glValidateProgram = (PFNGLVALIDATEPROGRAMPROC)load("glValidateProgram");
	glad_glVertexAttrib1f = (PFNGLVERTEXATTRIB1FPROC)load("glVertexAttrib1f");
	glad_glVertexAttrib1fv = (PFNGLVERTEXATTRIB1FVPROC)load("glVertexAttrib1fv");
	glad_glVertexAttrib2f = (PFNGLVERTEXATTRIB2FPROC)load("glVertexAttrib2f");
	glad_glVertexAttrib2fv = (PFNGLVERTEXATTRIB2FVPROC)load("glVertexAttrib2fv");
	glad_glVertexAttrib3f = (PFNGLVERTEXATTRIB3FPROC)load("glVertexAttrib3f");
	glad_glVertexAttrib3fv = (PFNGLVERTEXATTRIB3FVPROC)load("glVertexAttrib3fv");
	glad_glVertexAttrib4f = (PFNGLVERTEXATTRIB4FPROC)load("glVertexAttrib4f");
	glad_glVertexAttrib4fv = (PFNGLVERTEXATTRIB4FVPROC)load("glVertexAttrib4fv");
	glad_glVertexAttribPointer = (PFNGLVERTEXATTRIBPOINTERPROC)load("glVertexAttribPointer");
	glad_glViewport = (PFNGLVIEWPORTPROC)load("glViewport");
}
static void load_GL_ES_VERSION_3_0(GLADloadproc load) {
	if(!GLAD_GL_ES_VERSION_3_0) return;
	glad_glReadBuffer = (PFNGLREADBUFFERPROC)load("glReadBuffer");
	glad_glDrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC)load("glDrawRangeElements");
	glad_glTexImage3D = (PFNGLTEXIMAGE3DPROC)load("glTexImage3D");
	glad_glTexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC)load("glTexSubImage3D");
	glad_glCopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC)load("glCopyTexSubImage3D");
	glad_glCompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC)load("glCompressedTexImage3D");
	glad_glCompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC)load("glCompressedTexSubImage3D");
	glad_glGenQueries = (PFNGLGENQUERIESPROC)load("glGenQueries");
	glad_glDeleteQueries = (PFNGLDELETEQUERIESPROC)load("glDeleteQueries");
	glad_glIsQuery = (PFNGLISQUERYPROC)load("glIsQuery");
	glad_glBeginQuery = (PFNGLBEGINQUERYPROC)load("glBeginQuery");
	glad_glEndQuery = (PFNGLENDQUERYPROC)load("glEndQuery");
	glad_glGetQueryiv = (PFNGLGETQUERYIVPROC)load("glGetQueryiv");
	glad_glGetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC)load("glGetQueryObjectuiv");
	glad_glUnmapBuffer = (PFNGLUNMAPBUFFERPROC)load("glUnmapBuffer");
	glad_glGetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC)load("glGetBufferPointerv");
	glad_glDrawBuffers = (PFNGLDRAWBUFFERSPROC)load("glDrawBuffers");
	glad_glUniformMatrix2x3fv = (PFNGLUNIFORMMATRIX2X3FVPROC)load("glUniformMatrix2x3fv");
	glad_glUniformMatrix3x2fv = (PFNGLUNIFORMMATRIX3X2FVPROC)load("glUniformMatrix3x2fv");
	glad_glUniformMatrix2x4fv = (PFNGLUNIFORMMATRIX2X4FVPROC)load("glUniformMatrix2x4fv");
	glad_glUniformMatrix4x2fv = (PFNGLUNIFORMMATRIX4X2FVPROC)load("glUniformMatrix4x2fv");
	glad_glUniformMatrix3x4fv = (PFNGLUNIFORMMATRIX3X4FVPROC)load("glUniformMatrix3x4fv");
	glad_glUniformMatrix4x3fv = (PFNGLUNIFORMMATRIX4X3FVPROC)load("glUniformMatrix4x3fv");
	glad_glBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC)load("glBlitFramebuffer");
	glad_glRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC)load("glRenderbufferStorageMultisample");
	glad_glFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC)load("glFramebufferTextureLayer");
	glad_glMapBufferRange = (PFNGLMAPBUFFERRANGEPROC)load("glMapBufferRange");
	glad_glFlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC)load("glFlushMappedBufferRange");
	glad_glBindVertexArray = (PFNGLBINDVERTEXARRAYPROC)load("glBindVertexArray");
	glad_glDeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC)load("glDeleteVertexArrays");
	glad_glGenVertexArrays = (PFNGLGENVERTEXARRAYSPROC)load("glGenVertexArrays");
	glad_glIsVertexArray = (PFNGLISVERTEXARRAYPROC)load("glIsVertexArray");
	glad_glGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)load("glGetIntegeri_v");
	glad_glBeginTransformFeedback = (PFNGLBEGINTRANSFORMFEEDBACKPROC)load("glBeginTransformFeedback");
	glad_glEndTransformFeedback = (PFNGLENDTRANSFORMFEEDBACKPROC)load("glEndTransformFeedback");
	glad_glBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)load("glBindBufferRange");
	glad_glBindBufferBase = (PFNGLBINDBUFFERBASEPROC)load("glBindBufferBase");
	glad_glTransformFeedbackVaryings = (PFNGLTRANSFORMFEEDBACKVARYINGSPROC)load("glTransformFeedbackVaryings");
	glad_glGetTransformFeedbackVarying = (PFNGLGETTRANSFORMFEEDBACKVARYINGPROC)load("glGetTransformFeedbackVarying");
	glad_glVertexAttribIPointer = (PFNGLVERTEXATTRIBIPOINTERPROC)load("glVertexAttribIPointer");
	glad_glGetVertexAttribIiv = (PFNGLGETVERTEXATTRIBIIVPROC)load("glGetVertexAttribIiv");
	glad_glGetVertexAttribIuiv = (PFNGLGETVERTEXATTRIBIUIVPROC)load("glGetVertexAttribIuiv");
	glad_glVertexAttribI4i = (PFNGLVERTEXATTRIBI4IPROC)load("glVertexAttribI4i");
	glad_glVertexAttribI4ui = (PFNGLVERTEXATTRIBI4UIPROC)load("glVertexAttribI4ui");
	glad_glVertexAttribI4iv = (PFNGLVERTEXATTRIBI4IVPROC)load("glVertexAttribI4iv");
	glad_glVertexAttribI4uiv = (PFNGLVERTEXATTRIBI4UIVPROC)load("glVertexAttribI4uiv");
	glad_glGetUniformuiv = (PFNGLGETUNIFORMUIVPROC)load("glGetUniformuiv");
	glad_glGetFragDataLocation = (PFNGLGETFRAGDATALOCATIONPROC)load("glGetFragDataLocation");
	glad_glUniform1ui = (PFNGLUNIFORM1UIPROC)load("glUniform1ui");
	glad_glUniform2ui = (PFNGLUNIFORM2UIPROC)load("glUniform2ui");
	glad_glUniform3ui = (PFNGLUNIFORM3UIPROC)load("glUniform3ui");
	glad_glUniform4ui = (PFNGLUNIFORM4UIPROC)load("glUniform4ui");
	glad_glUniform1uiv = (PFNGLUNIFORM1UIVPROC)load("glUniform1uiv");
	glad_glUniform2uiv = (PFNGLUNIFORM2UIVPROC)load("glUniform2uiv");
	glad_glUniform3uiv = (PFNGLUNIFORM3UIVPROC)load("glUniform3uiv");
	glad_glUniform4uiv = (PFNGLUNIFORM4UIVPROC)load("glUniform4uiv");
	glad_glClearBufferiv = (PFNGLCLEARBUFFERIVPROC)load("glClearBufferiv");
	glad_glClearBufferuiv = (PFNGLCLEARBUFFERUIVPROC)load("glClearBufferuiv");
	glad_glClearBufferfv = (PFNGLCLEARBUFFERFVPROC)load("glClearBufferfv");
	glad_glClearBufferfi = (PFNGLCLEARBUFFERFIPROC)load("glClearBufferfi");
	glad_glGetStringi = (PFNGLGETSTRINGIPROC)load("glGetStringi");
	glad_glCopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC)load("glCopyBufferSubData");
	glad_glGetUniformIndices = (PFNGLGETUNIFORMINDICESPROC)load("glGetUniformIndices");
	glad_glGetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC)load("glGetActiveUniformsiv");
	glad_glGetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC)load("glGetUniformBlockIndex");
	glad_glGetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC)load("glGetActiveUniformBlockiv");
	glad_glGetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC)load("glGetActiveUniformBlockName");
	glad_glUniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC)load("glUniformBlockBinding");
	glad_glDrawArraysInstanced = (PFNGLDRAWARRAYSINSTANCEDPROC)load("glDrawArraysInstanced");
	glad_glDrawElementsInstanced = (PFNGLDRAWELEMENTSINSTANCEDPROC)load("glDrawElementsInstanced");
	glad_glFenceSync = (PFNGLFENCESYNCPROC)load("glFenceSync");
	glad_glIsSync = (PFNGLISSYNCPROC)load("glIsSync");
	glad_glDeleteSync = (PFNGLDELETESYNCPROC)load("glDeleteSync");
	glad_glClientWaitSync = (PFNGLCLIENTWAITSYNCPROC)load("glClientWaitSync");
	glad_glWaitSync = (PFNGLWAITSYNCPROC)load("glWaitSync");
	glad_glGetInteger64v = (PFNGLGETINTEGER64VPROC)load("glGetInteger64v");
	glad_glGetSynciv = (PFNGLGETSYNCIVPROC)load("glGetSynciv");
	glad_glGetInteger64i_v = (PFNGLGETINTEGER64I_VPROC)load("glGetInteger64i_v");
	glad_glGetBufferParameteri64v = (PFNGLGETBUFFERPARAMETERI64VPROC)load("glGetBufferParameteri64v");
	glad_glGenSamplers = (PFNGLGENSAMPLERSPROC)load("glGenSamplers");
	glad_glDeleteSamplers = (PFNGLDELETESAMPLERSPROC)load("glDeleteSamplers");
	glad_glIsSampler = (PFNGLISSAMPLERPROC)load("glIsSampler");
	glad_glBindSampler = (PFNGLBINDSAMPLERPROC)load("glBindSampler");
	glad_glSamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC)load("glSamplerParameteri");
	glad_glSamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC)load("glSamplerParameteriv");
	glad_glSamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC)load("glSamplerParameterf");
	glad_glSamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC)load("glSamplerParameterfv");
	glad_glGetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC)load("glGetSamplerParameteriv");
	glad_glGetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC)load("glGetSamplerParameterfv");
	glad_glVertexAttribDivisor = (PFNGLVERTEXATTRIBDIVISORPROC)load("glVertexAttribDivisor");
	glad_glBindTransformFeedback = (PFNGLBINDTRANSFORMFEEDBACKPROC)load("glBindTransformFeedback");
	glad_glDeleteTransformFeedbacks = (PFNGLDELETETRANSFORMFEEDBACKSPROC)load("glDeleteTransformFeedbacks");
	glad_glGenTransformFeedbacks = (PFNGLGENTRANSFORMFEEDBACKSPROC)load("glGenTransformFeedbacks");
	glad_glIsTransformFeedback = (PFNGLISTRANSFORMFEEDBACKPROC)load("glIsTransformFeedback");
	glad_glPauseTransformFeedback = (PFNGLPAUSETRANSFORMFEEDBACKPROC)load("glPauseTransformFeedback");
	glad_glResumeTransformFeedback = (PFNGLRESUMETRANSFORMFEEDBACKPROC)load("glResumeTransformFeedback");
	glad_glGetProgramBinary = (PFNGLGETPROGRAMBINARYPROC)load("glGetProgramBinary");
	glad_glProgramBinary = (PFNGLPROGRAMBINARYPROC)load("glProgramBinary");
	glad_glProgramParameteri = (PFNGLPROGRAMPARAMETERIPROC)load("glProgramParameteri");
	glad_glInvalidateFramebuffer = (PFNGLINVALIDATEFRAMEBUFFERPROC)load("glInvalidateFramebuffer");
	glad_glInvalidateSubFramebuffer = (PFNGLINVALIDATESUBFRAMEBUFFERPROC)load("glInvalidateSubFramebuffer");
	glad_glTexStorage2D = (PFNGLTEXSTORAGE2DPROC)load("glTexStorage2D");
	glad_glTexStorage3D = (PFNGLTEXSTORAGE3DPROC)load("glTexStorage3D");
	glad_glGetInternalformativ = (PFNGLGETINTERNALFORMATIVPROC)load("glGetInternalformativ");
}
static int find_extensionsGLES2(void) {
	if (!get_exts()) return 0;
	GLAD_GL_EXT_texture_compression_s3tc = has_ext("GL_EXT_texture_compression_s3tc");
	GLAD_GL_EXT_texture_compression_s3tc_srgb = has_ext("GL_EXT_texture_compression_s3tc_srgb");
	GLAD_GL_EXT_texture_filter_anisotropic = has_ext("GL_EXT_texture_filter_anisotropic");
	GLAD_GL_IMG_texture_compression_pvrtc = has_ext("GL_IMG_texture_compression_pvrtc");
	GLAD_GL_IMG_texture_compression_pvrtc2 = has_ext("GL_IMG_texture_compression_pvrtc2");
	free_exts();
	return 1;
}

static void find_coreGLES2(void) {

    /* Thank you @elmindreda
     * https://github.com/elmindreda/greg/blob/master/templates/greg.c.in#L176
     * https://github.com/glfw/glfw/blob/master/src/context.c#L36
     */
    int i, major, minor;

    const char* version;
    const char* prefixes[] = {
        "OpenGL ES-CM ",
        "OpenGL ES-CL ",
        "OpenGL ES ",
        NULL
    };

    version = (const char*) glGetString(GL_VERSION);
    if (!version) return;

    for (i = 0;  prefixes[i];  i++) {
        const size_t length = strlen(prefixes[i]);
        if (strncmp(version, prefixes[i], length) == 0) {
            version += length;
            break;
        }
    }

/* PR #18 */
#ifdef _MSC_VER
    sscanf_s(version, "%d.%d", &major, &minor);
#else
    sscanf(version, "%d.%d", &major, &minor);
#endif

    GLVersion.major = major; GLVersion.minor = minor;
    max_loaded_major = major; max_loaded_minor = minor;
	GLAD_GL_ES_VERSION_2_0 = (major == 2 && minor >= 0) || major > 2;
	GLAD_GL_ES_VERSION_3_0 = (major == 3 && minor >= 0) || major > 3;
	if (GLVersion.major > 3 || (GLVersion.major >= 3 && GLVersion.minor >= 0)) {
		max_loaded_major = 3;
		max_loaded_minor = 0;
	}
}

int gladLoadGLES2Loader(GLADloadproc load) {
	GLVersion.major = 0; GLVersion.minor = 0;
	glGetString = (PFNGLGETSTRINGPROC)load("glGetString");
	if(glGetString == NULL) return 0;
	if(glGetString(GL_VERSION) == NULL) return 0;
	find_coreGLES2();
	load_GL_ES_VERSION_2_0(load);
	load_GL_ES_VERSION_3_0(load);

	if (!find_extensionsGLES2()) return 0;
	return GLVersion.major != 0 || GLVersion.minor != 0;
}

