/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gptool;

import apdu4j.core.HexUtils;
import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.Optional;
import pro.javacard.gp.CardKeysProvider;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.keys.PlaintextKeys;

@AutoService(value={CardKeysProvider.class})
public class PlaintextKeysProvider
implements CardKeysProvider {
    @Override
    public Optional<GPCardKeys> getCardKeys(String spec) {
        if (spec == null) {
            return Optional.empty();
        }
        spec = spec.trim();
        try {
            for (Map.Entry<String, String> d : PlaintextKeys.kdf_templates.entrySet()) {
                if (!spec.toLowerCase().startsWith(d.getKey())) continue;
                byte[] k = PlaintextKeysProvider.hexOrDefault(spec.substring(d.getKey().length() + 1));
                return Optional.of(PlaintextKeys.fromMasterKey(k, d.getValue()));
            }
            byte[] k = PlaintextKeysProvider.hexOrDefault(spec);
            return Optional.of(PlaintextKeys.fromMasterKey(k));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    static byte[] hexOrDefault(String v) {
        if ("default".startsWith(v.toLowerCase())) {
            return PlaintextKeys.DEFAULT_KEY();
        }
        return HexUtils.stringToBin(v);
    }
}

