/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.tlv;

import java.nio.ByteBuffer;
import pro.javacard.tlv.Tag;

public record DGITag(int dgi) implements Tag
{
    public DGITag {
        if (dgi < 0 || dgi > 65535) {
            throw new IllegalArgumentException("DGI must be 0x0000-0xFFFF");
        }
    }

    @Override
    public byte[] bytes() {
        return new byte[]{(byte)(this.dgi >> 8), (byte)this.dgi};
    }

    static DGITag parse(ByteBuffer buffer) {
        int high = buffer.get() & 0xFF;
        int low = buffer.get() & 0xFF;
        return new DGITag(high << 8 | low);
    }

    @Override
    public String toString() {
        return this.toHex();
    }
}

