/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.tlv;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import pro.javacard.tlv.BERTag;
import pro.javacard.tlv.DGITag;
import pro.javacard.tlv.Len;
import pro.javacard.tlv.SimpleTag;
import pro.javacard.tlv.TLV;
import pro.javacard.tlv.Tag;

public final class TLVParser {
    private TLVParser() {
    }

    public static List<TLV> parse(ByteBuffer buf, Tag.Type type) {
        ArrayList<TLV> result = new ArrayList<TLV>();
        while (buf.hasRemaining()) {
            result.add(TLVParser.parseOne(buf, type));
        }
        return List.copyOf(result);
    }

    public static List<TLV> parse(byte[] data, Tag.Type type) {
        return TLVParser.parse(ByteBuffer.wrap(data), type);
    }

    public static List<TLV> parse(byte[] data, int offset, int length, Tag.Type type) {
        return TLVParser.parse(ByteBuffer.wrap(data, offset, length), type);
    }

    public static TLV parseOne(ByteBuffer buf, Tag.Type type) {
        try {
            Record ber;
            Record tag = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Tag.Type.BER -> BERTag.parse(buf);
                case Tag.Type.SIMPLE -> SimpleTag.parse(buf);
                case Tag.Type.DGI -> DGITag.parse(buf);
            };
            int length = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Tag.Type.BER -> Len.ber(buf);
                case Tag.Type.SIMPLE, Tag.Type.DGI -> Len.ext(buf);
            };
            byte[] value = new byte[length];
            buf.get(value);
            if (tag instanceof BERTag && ((BERTag)(ber = tag)).isConstructed()) {
                ArrayList<TLV> kids = new ArrayList<TLV>(TLVParser.parse(ByteBuffer.wrap(value), type));
                return new TLV((Tag)((Object)tag), null, kids);
            }
            return new TLV((Tag)((Object)tag), value, null);
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Insufficient data to parse TLV", e);
        }
    }
}

