/* application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application.vala, do not modify */

/*
 * Copyright (c) 2013-2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <gom/gom.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libpeas/peas.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <config.h>
#include <sqlite3.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define POMODORO_APPLICATION_REPOSITORY_VERSION ((guint) 1)
#define POMODORO_APPLICATION_SETUP_PLUGINS_TIMEOUT ((guint) 3000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	POMODORO_APPLICATION_0_PROPERTY,
	POMODORO_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* pomodoro_application_properties[POMODORO_APPLICATION_NUM_PROPERTIES];
typedef enum  {
	POMODORO_APPLICATION_EXIT_STATUS_UNDEFINED = -1,
	POMODORO_APPLICATION_EXIT_STATUS_SUCCESS = 0,
	POMODORO_APPLICATION_EXIT_STATUS_FAILURE = 1
} PomodoroApplicationExitStatus;

#define POMODORO_APPLICATION_TYPE_EXIT_STATUS (pomodoro_application_exit_status_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _PomodoroApplicationSetupPluginsData PomodoroApplicationSetupPluginsData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define POMODORO_TYPE_ENTRY (pomodoro_entry_get_type ())
#define POMODORO_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_TYPE_ENTRY, PomodoroEntry))
#define POMODORO_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_TYPE_ENTRY, PomodoroEntryClass))
#define POMODORO_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_TYPE_ENTRY))
#define POMODORO_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_TYPE_ENTRY))
#define POMODORO_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_TYPE_ENTRY, PomodoroEntryClass))

typedef struct _PomodoroEntry PomodoroEntry;
typedef struct _PomodoroEntryClass PomodoroEntryClass;
typedef struct _Block4Data Block4Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block5Data Block5Data;

#define POMODORO_APPLICATION_TYPE_OPTIONS (pomodoro_application_options_get_type ())
#define POMODORO_APPLICATION_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POMODORO_APPLICATION_TYPE_OPTIONS, PomodoroApplicationOptions))
#define POMODORO_APPLICATION_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POMODORO_APPLICATION_TYPE_OPTIONS, PomodoroApplicationOptionsClass))
#define POMODORO_APPLICATION_IS_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POMODORO_APPLICATION_TYPE_OPTIONS))
#define POMODORO_APPLICATION_IS_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POMODORO_APPLICATION_TYPE_OPTIONS))
#define POMODORO_APPLICATION_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POMODORO_APPLICATION_TYPE_OPTIONS, PomodoroApplicationOptionsClass))

typedef struct _PomodoroApplicationOptions PomodoroApplicationOptions;
typedef struct _PomodoroApplicationOptionsClass PomodoroApplicationOptionsClass;
typedef struct _PomodoroApplicationOptionsPrivate PomodoroApplicationOptionsPrivate;
typedef struct _PomodoroApplicationParamSpecOptions PomodoroApplicationParamSpecOptions;

struct _PomodoroApplicationPrivate {
	GomRepository* repository;
	GomAdapter* adapter;
	PomodoroPreferencesDialog* preferences_dialog;
	PomodoroWindow* window;
	PomodoroDesktopExtension* desktop_extension;
	GtkWindow* about_dialog;
	PeasExtensionSet* extensions;
	GSettings* settings;
};

struct _Block2Data {
	int _ref_count_;
	PomodoroApplication* self;
	GCancellable* timeout_cancellable;
	guint timeout_source;
	gint wait_count;
	gpointer _async_data_;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GAsyncInitable* extension;
	PeasPluginInfo* info;
};

struct _PomodoroApplicationSetupPluginsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PomodoroApplication* self;
	Block2Data* _data2_;
	PeasEngine* engine;
	PeasEngine* _tmp0_;
	PeasEngine* _tmp1_;
	PeasEngine* _tmp2_;
	GCancellable* _tmp3_;
	PeasEngine* _tmp4_;
	PeasExtensionSet* _tmp5_;
	PeasExtensionSet* _tmp6_;
};

struct _Block4Data {
	int _ref_count_;
	PomodoroApplication* self;
	PomodoroEntry* entry;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	PomodoroEntry* entry_after_midnight;
};

struct _PomodoroApplicationOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PomodoroApplicationOptionsPrivate * priv;
};

struct _PomodoroApplicationOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (PomodoroApplicationOptions *self);
};

struct _PomodoroApplicationParamSpecOptions {
	GParamSpec parent_instance;
};

static gint PomodoroApplication_private_offset;
static gpointer pomodoro_application_parent_class = NULL;
static PomodoroApplicationExitStatus pomodoro_application_options_exit_status;
static gboolean pomodoro_application_options_start_stop;
static gboolean pomodoro_application_options_start;
static gboolean pomodoro_application_options_stop;
static gboolean pomodoro_application_options_pause_resume;
static gboolean pomodoro_application_options_pause;
static gboolean pomodoro_application_options_resume;
static gboolean pomodoro_application_options_skip;
static gboolean pomodoro_application_options_extend;
static gboolean pomodoro_application_options_reset;
static gboolean pomodoro_application_options_no_default_window;
static gboolean pomodoro_application_options_preferences;
static gboolean pomodoro_application_options_quit;
static gpointer pomodoro_application_options_parent_class = NULL;
static gboolean pomodoro_application_options_no_default_window = FALSE;
static gboolean pomodoro_application_options_preferences = FALSE;
static gboolean pomodoro_application_options_quit = FALSE;
static gboolean pomodoro_application_options_start_stop = FALSE;
static gboolean pomodoro_application_options_start = FALSE;
static gboolean pomodoro_application_options_stop = FALSE;
static gboolean pomodoro_application_options_pause_resume = FALSE;
static gboolean pomodoro_application_options_pause = FALSE;
static gboolean pomodoro_application_options_resume = FALSE;
static gboolean pomodoro_application_options_skip = FALSE;
static gboolean pomodoro_application_options_extend = FALSE;
static gboolean pomodoro_application_options_reset = FALSE;
static PomodoroApplicationExitStatus pomodoro_application_options_exit_status = POMODORO_APPLICATION_EXIT_STATUS_UNDEFINED;

static GType pomodoro_application_extension_get_type_once (void);
VALA_EXTERN GomRepository* pomodoro_get_repository (void);
static GType pomodoro_application_exit_status_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void pomodoro_application_setup_resources (PomodoroApplication* self);
static void pomodoro_application_setup_desktop_extension (PomodoroApplication* self);
static void pomodoro_application_setup_plugins_data_free (gpointer _data);
static void pomodoro_application_setup_plugins (PomodoroApplication* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void pomodoro_application_setup_plugins_finish (PomodoroApplication* self,
                                                GAsyncResult* _res_);
static gboolean pomodoro_application_setup_plugins_co (PomodoroApplicationSetupPluginsData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda32_ (Block2Data* _data2_);
static gboolean ___lambda32__gsource_func (gpointer self);
static void __lambda33_ (Block2Data* _data2_,
                  PeasExtensionSet* extension_set,
                  PeasPluginInfo* info,
                  GObject* extension_object);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda34_ (Block3Data* _data3_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda34__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda33__peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                      PeasPluginInfo* info,
                                                      GObject* exten,
                                                      gpointer self);
static void pomodoro_application_load_plugins (PomodoroApplication* self);
static void pomodoro_application_setup_capabilities (PomodoroApplication* self);
static gboolean pomodoro_application_migrate_repository (GomRepository* repository,
                                                  GomAdapter* adapter,
                                                  guint version,
                                                  GError** error);
static void pomodoro_application_setup_repository (PomodoroApplication* self);
static gboolean _pomodoro_application_migrate_repository_gom_repository_migrator (GomRepository* repository,
                                                                           GomAdapter* adapter,
                                                                           guint version,
                                                                           gpointer self,
                                                                           GError** error);
static void _g_free0_ (gpointer var);
static void ___lambda14_ (PomodoroApplication* self);
static void ____lambda14__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void ___lambda27_ (PomodoroApplication* self);
static void ____lambda27__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void pomodoro_application_activate_timer (PomodoroApplication* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void pomodoro_application_activate_stats (PomodoroApplication* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void pomodoro_application_activate_preferences (PomodoroApplication* self,
                                                GSimpleAction* action,
                                                GVariant* parameter);
static void pomodoro_application_activate_visit_website (PomodoroApplication* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter);
static void pomodoro_application_activate_report_issue (PomodoroApplication* self,
                                                 GSimpleAction* action,
                                                 GVariant* parameter);
static void pomodoro_application_activate_about (PomodoroApplication* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void ___lambda37_ (PomodoroApplication* self);
static void ____lambda37__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void pomodoro_application_activate_quit (PomodoroApplication* self,
                                         GSimpleAction* action,
                                         GVariant* parameter);
static void pomodoro_application_activate_timer_skip (PomodoroApplication* self,
                                               GSimpleAction* action,
                                               GVariant* parameter);
static void pomodoro_application_activate_timer_set_state (PomodoroApplication* self,
                                                    GSimpleAction* action,
                                                    GVariant* parameter);
static void pomodoro_application_activate_timer_switch_state (PomodoroApplication* self,
                                                       GSimpleAction* action,
                                                       GVariant* parameter);
static void pomodoro_application_setup_actions (PomodoroApplication* self);
static void _pomodoro_application_activate_timer_g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void _pomodoro_application_activate_stats_g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void _pomodoro_application_activate_preferences_g_simple_action_activate (GSimpleAction* _sender,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void _pomodoro_application_activate_visit_website_g_simple_action_activate (GSimpleAction* _sender,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void _pomodoro_application_activate_report_issue_g_simple_action_activate (GSimpleAction* _sender,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void _pomodoro_application_activate_about_g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void _pomodoro_application_activate_quit_g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _pomodoro_application_activate_timer_skip_g_simple_action_activate (GSimpleAction* _sender,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void _pomodoro_application_activate_timer_set_state_g_simple_action_activate (GSimpleAction* _sender,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void _pomodoro_application_activate_timer_switch_state_g_simple_action_activate (GSimpleAction* _sender,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static gboolean pomodoro_application_command_line_version_callback (void);
static void pomodoro_application_real_startup (GApplication* base);
static void pomodoro_application_restore_timer (PomodoroApplication* self);
static void __lambda38_ (PomodoroApplication* self,
                  GObject* obj,
                  GAsyncResult* res);
static gboolean __lambda39_ (PomodoroApplication* self);
static gboolean ___lambda39__gsource_func (gpointer self);
static void ___lambda38__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void pomodoro_application_parse_command_line (PomodoroApplication* self,
                                              gchar*** arguments,
                                              gint* arguments_length1,
                                              GError** error);
static gboolean pomodoro_application_real_local_command_line (GApplication* base,
                                                       gchar*** arguments,
                                                       gint* exit_status);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gint pomodoro_application_real_command_line (GApplication* base,
                                             GApplicationCommandLine* command_line);
static void pomodoro_application_real_shutdown (GApplication* base);
static void pomodoro_application_save_timer (PomodoroApplication* self);
static void pomodoro_application_real_activate (GApplication* base);
static gboolean pomodoro_application_options_has_timer_option (void);
static void pomodoro_application_options_set_defaults (void);
static gboolean pomodoro_application_real_dbus_register (GApplication* base,
                                                  GDBusConnection* connection,
                                                  const gchar* object_path,
                                                  GError** error);
static void pomodoro_application_on_timer_is_paused_notify (PomodoroApplication* self);
static void _pomodoro_application_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void pomodoro_application_on_timer_state_changed (PomodoroApplication* self,
                                                  PomodoroTimer* timer,
                                                  PomodoroTimerState* state,
                                                  PomodoroTimerState* previous_state);
static void _pomodoro_application_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                                PomodoroTimerState* state,
                                                                                PomodoroTimerState* previous_state,
                                                                                gpointer self);
static void pomodoro_application_on_settings_changed (PomodoroApplication* self,
                                               GSettings* settings,
                                               const gchar* key);
static void _pomodoro_application_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self);
static void pomodoro_application_real_dbus_unregister (GApplication* base,
                                                GDBusConnection* connection,
                                                const gchar* object_path);
VALA_EXTERN GType pomodoro_entry_get_type (void) G_GNUC_CONST ;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN PomodoroEntry* pomodoro_entry_new_from_state (PomodoroTimerState* state);
VALA_EXTERN PomodoroEntry* pomodoro_entry_construct_from_state (GType object_type,
                                                    PomodoroTimerState* state);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN gint64 pomodoro_entry_get_elapsed (PomodoroEntry* self);
VALA_EXTERN void pomodoro_entry_set_elapsed (PomodoroEntry* self,
                                 gint64 value);
VALA_EXTERN void pomodoro_entry_set_datetime (PomodoroEntry* self,
                                  GDateTime* value);
static void ____lambda40_ (Block5Data* _data5_,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda40__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ___lambda41_ (Block4Data* _data4_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda41__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gpointer pomodoro_application_options_ref (gpointer instance);
static void pomodoro_application_options_unref (gpointer instance);
static GParamSpec* pomodoro_application_param_spec_options (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags) G_GNUC_UNUSED ;
static void pomodoro_application_value_set_options (GValue* value,
                                             gpointer v_object) G_GNUC_UNUSED ;
static void pomodoro_application_value_take_options (GValue* value,
                                              gpointer v_object) G_GNUC_UNUSED ;
static gpointer pomodoro_application_value_get_options (const GValue* value) G_GNUC_UNUSED ;
static GType pomodoro_application_options_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PomodoroApplicationOptions* pomodoro_application_options_new (void);
static PomodoroApplicationOptions* pomodoro_application_options_construct (GType object_type);
static void pomodoro_application_options_finalize (PomodoroApplicationOptions * obj);
static GType pomodoro_application_options_get_type_once (void);
static void pomodoro_application_finalize (GObject * obj);
static GType pomodoro_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const gchar* POMODORO_APPLICATION_LEGACY_PLUGINS[2] = {"indicator", "notifications"};
static const GOptionEntry POMODORO_APPLICATION_OPTIONS_ENTRIES[14] = {{"start-stop", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_start_stop, N_ ("Start/Stop"), NULL}, {"start", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_start, N_ ("Start"), NULL}, {"stop", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_stop, N_ ("Stop"), NULL}, {"pause-resume", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_pause_resume, N_ ("Pause/Resume"), NULL}, {"pause", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_pause, N_ ("Pause"), NULL}, {"resume", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_resume, N_ ("Resume"), NULL}, {"skip", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_skip, N_ ("Skip to a pomodoro or to a break"), NULL}, {"extend", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_extend, N_ ("Extend current pomodoro or break"), NULL}, {"reset", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_reset, N_ ("Reset current session"), NULL}, {"no-default-window", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_no_default_window, N_ ("Run as background service"), NULL}, {"preferences", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_preferences, N_ ("Show preferences"), NULL}, {"quit", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &pomodoro_application_options_quit, N_ ("Quit application"), NULL}, {"version", (gchar) 0, (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) pomodoro_application_command_line_version_callback, N_ ("Print version information and exit"), NULL}, {NULL}};

static void
pomodoro_application_extension_default_init (PomodoroApplicationExtensionIface * iface,
                                             gpointer iface_data)
{
}

static GType
pomodoro_application_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroApplicationExtensionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_application_extension_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pomodoro_application_extension_type_id;
	pomodoro_application_extension_type_id = g_type_register_static (G_TYPE_INTERFACE, "PomodoroApplicationExtension", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pomodoro_application_extension_type_id, peas_extension_base_get_type ());
	return pomodoro_application_extension_type_id;
}

GType
pomodoro_application_extension_get_type (void)
{
	static volatile gsize pomodoro_application_extension_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_application_extension_type_id__once)) {
		GType pomodoro_application_extension_type_id;
		pomodoro_application_extension_type_id = pomodoro_application_extension_get_type_once ();
		g_once_init_leave (&pomodoro_application_extension_type_id__once, pomodoro_application_extension_type_id);
	}
	return pomodoro_application_extension_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GomRepository*
pomodoro_get_repository (void)
{
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp0_;
	PomodoroApplication* _tmp1_;
	GObject* _tmp2_;
	GomRepository* result;
	_tmp0_ = pomodoro_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	application = _tmp1_;
	_tmp2_ = pomodoro_application_get_repository (application);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gom_repository_get_type (), GomRepository);
	_g_object_unref0 (application);
	return result;
}

static inline gpointer
pomodoro_application_get_instance_private (PomodoroApplication* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroApplication_private_offset);
}

static GType
pomodoro_application_exit_status_get_type_once (void)
{
	static const GEnumValue values[] = {{POMODORO_APPLICATION_EXIT_STATUS_UNDEFINED, "POMODORO_APPLICATION_EXIT_STATUS_UNDEFINED", "undefined"}, {POMODORO_APPLICATION_EXIT_STATUS_SUCCESS, "POMODORO_APPLICATION_EXIT_STATUS_SUCCESS", "success"}, {POMODORO_APPLICATION_EXIT_STATUS_FAILURE, "POMODORO_APPLICATION_EXIT_STATUS_FAILURE", "failure"}, {0, NULL, NULL}};
	GType pomodoro_application_exit_status_type_id;
	pomodoro_application_exit_status_type_id = g_enum_register_static ("PomodoroApplicationExitStatus", values);
	return pomodoro_application_exit_status_type_id;
}

static GType
pomodoro_application_exit_status_get_type (void)
{
	static volatile gsize pomodoro_application_exit_status_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_application_exit_status_type_id__once)) {
		GType pomodoro_application_exit_status_type_id;
		pomodoro_application_exit_status_type_id = pomodoro_application_exit_status_get_type_once ();
		g_once_init_leave (&pomodoro_application_exit_status_type_id__once, pomodoro_application_exit_status_type_id);
	}
	return pomodoro_application_exit_status_type_id__once;
}

GObject*
pomodoro_application_get_repository (PomodoroApplication* self)
{
	GomRepository* _tmp0_;
	GObject* _tmp1_;
	GObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->repository;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject));
	result = _tmp1_;
	return result;
}

PomodoroApplication*
pomodoro_application_construct (GType object_type)
{
	PomodoroApplication * self = NULL;
	self = (PomodoroApplication*) g_object_new (object_type, "application-id", "org.gnome.Pomodoro", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	_g_object_unref0 (self->timer);
	self->timer = NULL;
	_g_object_unref0 (self->service);
	self->service = NULL;
	return self;
}

PomodoroApplication*
pomodoro_application_new (void)
{
	return pomodoro_application_construct (POMODORO_TYPE_APPLICATION);
}

PomodoroApplication*
pomodoro_application_get_default (void)
{
	GApplication* _tmp0_;
	PomodoroApplication* result;
	_tmp0_ = g_application_get_default ();
	result = POMODORO_IS_APPLICATION (_tmp0_) ? ((PomodoroApplication*) _tmp0_) : NULL;
	return result;
}

GtkWindow*
pomodoro_application_get_last_focused_window (PomodoroApplication* self)
{
	GList* windows = NULL;
	GList* _tmp0_;
	GtkWindow* _tmp1_ = NULL;
	GList* _tmp2_;
	GtkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	windows = _tmp0_;
	_tmp2_ = windows;
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		_tmp3_ = windows;
		_tmp4_ = g_list_first (_tmp3_);
		_tmp5_ = _tmp4_->data;
		_tmp1_ = (GtkWindow*) _tmp5_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
pomodoro_application_setup_resources (PomodoroApplication* self)
{
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkScreen* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	gtk_css_provider_load_from_resource (css_provider, "/org/gnome/pomodoro/style.css");
	_tmp1_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp1_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (css_provider);
}

static void
pomodoro_application_setup_desktop_extension (PomodoroApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PomodoroDesktopExtension* _tmp0_ = NULL;
		PomodoroDesktopExtension* _tmp1_;
		PomodoroDesktopExtension* _tmp2_;
		PomodoroCapabilityManager* _tmp3_;
		PomodoroDesktopExtension* _tmp4_;
		PomodoroCapabilityGroup* _tmp5_;
		PomodoroCapabilityGroup* _tmp6_;
		_tmp1_ = pomodoro_desktop_extension_new (&_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->desktop_extension);
		self->priv->desktop_extension = _tmp2_;
		_tmp3_ = self->capabilities;
		_tmp4_ = self->priv->desktop_extension;
		_tmp5_ = pomodoro_desktop_extension_get_capabilities (_tmp4_);
		_tmp6_ = _tmp5_;
		pomodoro_capability_manager_add_group (_tmp3_, _tmp6_, POMODORO_PRIORITY_HIGH);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("application.vala:205: Error while initializing desktop extension: %s", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pomodoro_application_setup_plugins_data_free (gpointer _data)
{
	PomodoroApplicationSetupPluginsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PomodoroApplicationSetupPluginsData, _data_);
}

static void
pomodoro_application_setup_plugins (PomodoroApplication* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	PomodoroApplicationSetupPluginsData* _data_;
	PomodoroApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PomodoroApplicationSetupPluginsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pomodoro_application_setup_plugins_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pomodoro_application_setup_plugins_co (_data_);
}

static void
pomodoro_application_setup_plugins_finish (PomodoroApplication* self,
                                           GAsyncResult* _res_)
{
	PomodoroApplicationSetupPluginsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PomodoroApplication* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->timeout_cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda32_ (Block2Data* _data2_)
{
	PomodoroApplication* self;
	GCancellable* _tmp0_;
	gboolean result;
	self = _data2_->self;
	g_debug ("application.vala:220: Timeout reached while setting up plugins");
	_data2_->timeout_source = (guint) 0;
	_tmp0_ = _data2_->timeout_cancellable;
	g_cancellable_cancel (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda32_ (self);
	return result;
}

static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PomodoroApplication* self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->extension);
		__vala_PeasPluginInfo_free0 (_data3_->info);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda34_ (Block3Data* _data3_,
              GObject* obj,
              GAsyncResult* res)
{
	Block2Data* _data2_;
	PomodoroApplication* self;
	gint _tmp4_;
	GError* _inner_error0_ = NULL;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		GAsyncInitable* _tmp0_;
		_tmp0_ = _data3_->extension;
		g_async_initable_init_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = peas_plugin_info_get_module_name (_data3_->info);
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->message;
		g_warning ("application.vala:241: Failed to initialize plugin \"%s\": %s", _tmp1_, _tmp3_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = _data2_->wait_count;
	_data2_->wait_count = _tmp4_ - 1;
	pomodoro_application_setup_plugins_co (_data2_->_async_data_);
}

static void
____lambda34__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda34_ (self, source_object, res);
	block3_data_unref (self);
}

static void
__lambda33_ (Block2Data* _data2_,
             PeasExtensionSet* extension_set,
             PeasPluginInfo* info,
             GObject* extension_object)
{
	PomodoroApplication* self;
	Block3Data* _data3_;
	PeasPluginInfo* _tmp0_;
	GAsyncInitable* _tmp1_;
	GAsyncInitable* _tmp2_;
	self = _data2_->self;
	g_return_if_fail (extension_set != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (extension_object != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->_data2_ = block2_data_ref (_data2_);
	_tmp0_ = __vala_PeasPluginInfo_copy0 (info);
	__vala_PeasPluginInfo_free0 (_data3_->info);
	_data3_->info = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (extension_object, g_async_initable_get_type ()) ? ((GAsyncInitable*) extension_object) : NULL);
	_data3_->extension = _tmp1_;
	_tmp2_ = _data3_->extension;
	if (_tmp2_ != NULL) {
		GAsyncInitable* _tmp3_;
		GCancellable* _tmp4_;
		gint _tmp5_;
		_tmp3_ = _data3_->extension;
		_tmp4_ = _data2_->timeout_cancellable;
		g_async_initable_init_async (_tmp3_, G_PRIORITY_DEFAULT, _tmp4_, ____lambda34__gasync_ready_callback, block3_data_ref (_data3_));
		_tmp5_ = _data2_->wait_count;
		_data2_->wait_count = _tmp5_ + 1;
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
___lambda33__peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                 PeasPluginInfo* info,
                                                 GObject* exten,
                                                 gpointer self)
{
	__lambda33_ (self, _sender, info, exten);
}

static gboolean
pomodoro_application_setup_plugins_co (PomodoroApplicationSetupPluginsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = peas_engine_get_default ();
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->engine = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->engine;
	peas_engine_add_search_path (_data_->_tmp2_, PLUGIN_LIB_DIR, PLUGIN_DATA_DIR);
	_data_->_tmp3_ = g_cancellable_new ();
	_data_->_data2_->timeout_cancellable = _data_->_tmp3_;
	_data_->_data2_->timeout_source = (guint) 0;
	_data_->_data2_->wait_count = 0;
	_data_->_data2_->timeout_source = g_timeout_add_full (G_PRIORITY_DEFAULT, POMODORO_APPLICATION_SETUP_PLUGINS_TIMEOUT, ___lambda32__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
	_data_->_tmp4_ = _data_->engine;
	_data_->_tmp5_ = peas_extension_set_new (_data_->_tmp4_, POMODORO_TYPE_APPLICATION_EXTENSION, NULL);
	_g_object_unref0 (_data_->self->priv->extensions);
	_data_->self->priv->extensions = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->self->priv->extensions;
	g_signal_connect_data (_data_->_tmp6_, "extension-added", (GCallback) ___lambda33__peas_extension_set_extension_added, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
	pomodoro_application_load_plugins (_data_->self);
	while (TRUE) {
		if (!(_data_->_data2_->wait_count > 0)) {
			break;
		}
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_g_object_unref0 (_data_->_data2_->timeout_cancellable);
	_data_->_data2_->timeout_cancellable = NULL;
	if (_data_->_data2_->timeout_source != ((guint) 0)) {
		g_source_remove (_data_->_data2_->timeout_source);
	}
	_g_object_unref0 (_data_->engine);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
pomodoro_application_setup_capabilities (PomodoroApplication* self)
{
	PomodoroCapabilityGroup* default_capabilities = NULL;
	PomodoroCapabilityGroup* _tmp0_;
	PomodoroNotificationsCapability* _tmp1_;
	PomodoroNotificationsCapability* _tmp2_;
	PomodoroCapabilityManager* _tmp3_;
	PomodoroCapabilityManager* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_capability_group_new ("default");
	default_capabilities = _tmp0_;
	_tmp1_ = pomodoro_notifications_capability_new ("notifications");
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	pomodoro_capability_group_add (default_capabilities, (PomodoroCapability*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = pomodoro_capability_manager_new ();
	_g_object_unref0 (self->capabilities);
	self->capabilities = _tmp3_;
	_tmp4_ = self->capabilities;
	pomodoro_capability_manager_add_group (_tmp4_, default_capabilities, POMODORO_PRIORITY_LOW);
	_g_object_unref0 (default_capabilities);
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

static gboolean
pomodoro_application_migrate_repository (GomRepository* repository,
                                         GomAdapter* adapter,
                                         guint version,
                                         GError** error)
{
	guint8* file_contents = NULL;
	gint file_contents_length1 = 0;
	gint _file_contents_size_ = 0;
	gchar* error_message = NULL;
	GFile* file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	guint8* _tmp5_ = NULL;
	gsize _tmp6_ = 0;
	sqlite3* database = NULL;
	sqlite3* _tmp8_;
	sqlite3* _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_ = NULL;
	gint _tmp12_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (repository != NULL, FALSE);
	g_return_val_if_fail (adapter != NULL, FALSE);
	g_debug ("application.vala:286: Migrating database to version %u", version);
	_tmp0_ = g_strdup_printf ("resource:///org/gnome/pomodoro/database/version-%u.sql", version);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	file = _tmp3_;
	_tmp4_ = file;
	g_file_load_contents (_tmp4_, NULL, &_tmp5_, &_tmp6_, NULL, &_inner_error0_);
	file_contents = (g_free (file_contents), NULL);
	file_contents = _tmp5_;
	file_contents_length1 = _tmp6_;
	_file_contents_size_ = file_contents_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_free0 (error_message);
		file_contents = (g_free (file_contents), NULL);
		return _tmp7_;
	}
	_tmp8_ = gom_adapter_get_handle (adapter);
	database = _tmp8_;
	_tmp9_ = database;
	_tmp10_ = file_contents;
	_tmp10__length1 = file_contents_length1;
	_tmp12_ = _sqlite3_exec (_tmp9_, (const gchar*) _tmp10_, NULL, NULL, &_tmp11_);
	_g_free0 (error_message);
	error_message = _tmp11_;
	if (_tmp12_ != SQLITE_OK) {
		const gchar* _tmp13_;
		GError* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = error_message;
		_tmp14_ = g_error_new_literal (GOM_ERROR, GOM_ERROR_COMMAND_SQLITE, _tmp13_);
		_inner_error0_ = _tmp14_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_free0 (error_message);
		file_contents = (g_free (file_contents), NULL);
		return _tmp15_;
	}
	result = TRUE;
	_g_object_unref0 (file);
	_g_free0 (error_message);
	file_contents = (g_free (file_contents), NULL);
	return result;
}

static gboolean
_pomodoro_application_migrate_repository_gom_repository_migrator (GomRepository* repository,
                                                                  GomAdapter* adapter,
                                                                  guint version,
                                                                  gpointer self,
                                                                  GError** error)
{
	gboolean result;
	result = pomodoro_application_migrate_repository (repository, adapter, version, error);
	return result;
}

static void
pomodoro_application_setup_repository (PomodoroApplication* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* directory = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	g_application_mark_busy ((GApplication*) self);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_NAME, "database.sqlite", NULL);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_get_parent (_tmp4_);
	directory = _tmp5_;
	_tmp6_ = directory;
	if (!g_file_query_exists (_tmp6_, NULL)) {
		{
			GFile* _tmp7_;
			_tmp7_ = directory;
			g_file_make_directory_with_parents (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = _error_;
			_tmp9_ = _tmp8_->message;
			g_warning ("application.vala:320: Failed to create directory: %s", _tmp9_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (directory);
			_g_object_unref0 (file);
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GomAdapter* adapter = NULL;
		GomAdapter* _tmp10_;
		GomAdapter* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GomAdapter* _tmp15_;
		GomAdapter* _tmp16_;
		GomRepository* repository = NULL;
		GomAdapter* _tmp17_;
		GomRepository* _tmp18_;
		GomRepository* _tmp19_;
		GomRepository* _tmp20_;
		GomRepository* _tmp21_;
		_tmp10_ = gom_adapter_new ();
		adapter = _tmp10_;
		_tmp11_ = adapter;
		_tmp12_ = file;
		_tmp13_ = g_file_get_uri (_tmp12_);
		_tmp14_ = _tmp13_;
		gom_adapter_open_sync (_tmp11_, _tmp14_, &_inner_error0_);
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (adapter);
			goto __catch1_g_error;
		}
		_tmp15_ = adapter;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_g_object_unref0 (self->priv->adapter);
		self->priv->adapter = _tmp16_;
		_tmp17_ = adapter;
		_tmp18_ = gom_repository_new (_tmp17_);
		repository = _tmp18_;
		_tmp19_ = repository;
		gom_repository_migrate_sync (_tmp19_, POMODORO_APPLICATION_REPOSITORY_VERSION, _pomodoro_application_migrate_repository_gom_repository_migrator, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repository);
			_g_object_unref0 (adapter);
			goto __catch1_g_error;
		}
		_tmp20_ = repository;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (self->priv->repository);
		self->priv->repository = _tmp21_;
		_g_object_unref0 (repository);
		_g_object_unref0 (adapter);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = _error_;
		_tmp23_ = _tmp22_->message;
		g_critical ("application.vala:338: Failed to migrate database: %s", _tmp23_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (directory);
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_application_unmark_busy ((GApplication*) self);
	g_application_release ((GApplication*) self);
	_g_object_unref0 (directory);
	_g_object_unref0 (file);
	_g_free0 (path);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
pomodoro_application_load_plugins (PomodoroApplication* self)
{
	PeasEngine* engine = NULL;
	PeasEngine* _tmp0_;
	PeasEngine* _tmp1_;
	gchar** enabled_plugins = NULL;
	GSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint enabled_plugins_length1;
	gint _enabled_plugins_size_;
	GHashTable* enabled_hash = NULL;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	PeasEngine* _tmp15_;
	GList* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = peas_engine_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	engine = _tmp1_;
	_tmp2_ = self->priv->settings;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "enabled-plugins");
	enabled_plugins = _tmp4_;
	enabled_plugins_length1 = _vala_array_length (_tmp3_);
	_enabled_plugins_size_ = enabled_plugins_length1;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, NULL);
	enabled_hash = _tmp7_;
	_tmp8_ = enabled_plugins;
	_tmp8__length1 = enabled_plugins_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp8_;
		name_collection_length1 = _tmp8__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp9_;
			gchar* name = NULL;
			_tmp9_ = g_strdup (name_collection[name_it]);
			name = _tmp9_;
			{
				GHashTable* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp10_ = enabled_hash;
				_tmp11_ = name;
				_tmp12_ = g_strdup (_tmp11_);
				g_hash_table_insert (_tmp10_, _tmp12_, (gpointer) ((gintptr) TRUE));
				_g_free0 (name);
			}
		}
	}
	{
		const gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = POMODORO_APPLICATION_LEGACY_PLUGINS;
		name_collection_length1 = G_N_ELEMENTS (POMODORO_APPLICATION_LEGACY_PLUGINS);
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				GHashTable* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = enabled_hash;
				_tmp14_ = name;
				g_hash_table_remove (_tmp13_, _tmp14_);
			}
		}
	}
	_tmp15_ = engine;
	_tmp16_ = peas_engine_get_plugin_list (_tmp15_);
	{
		GList* plugin_info_collection = NULL;
		GList* plugin_info_it = NULL;
		plugin_info_collection = _tmp16_;
		for (plugin_info_it = plugin_info_collection; plugin_info_it != NULL; plugin_info_it = plugin_info_it->next) {
			PeasPluginInfo* _tmp17_;
			PeasPluginInfo* plugin_info = NULL;
			_tmp17_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) plugin_info_it->data);
			plugin_info = _tmp17_;
			{
				gboolean _tmp18_ = FALSE;
				PeasPluginInfo* _tmp19_;
				_tmp19_ = plugin_info;
				if (peas_plugin_info_is_hidden (_tmp19_)) {
					_tmp18_ = TRUE;
				} else {
					GHashTable* _tmp20_;
					PeasPluginInfo* _tmp21_;
					const gchar* _tmp22_;
					_tmp20_ = enabled_hash;
					_tmp21_ = plugin_info;
					_tmp22_ = peas_plugin_info_get_module_name (_tmp21_);
					_tmp18_ = g_hash_table_contains (_tmp20_, _tmp22_);
				}
				if (_tmp18_) {
					PeasEngine* _tmp23_;
					PeasPluginInfo* _tmp24_;
					_tmp23_ = engine;
					_tmp24_ = plugin_info;
					peas_engine_load_plugin (_tmp23_, _tmp24_);
				} else {
					PeasEngine* _tmp25_;
					PeasPluginInfo* _tmp26_;
					_tmp25_ = engine;
					_tmp26_ = plugin_info;
					peas_engine_unload_plugin (_tmp25_, _tmp26_);
				}
				__vala_PeasPluginInfo_free0 (plugin_info);
			}
		}
	}
	_g_hash_table_unref0 (enabled_hash);
	enabled_plugins = (_vala_array_free (enabled_plugins, enabled_plugins_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
}

static void
___lambda14_ (PomodoroApplication* self)
{
	PomodoroWindow* _tmp0_;
	_tmp0_ = self->priv->window;
	gtk_application_remove_window ((GtkApplication*) self, (GtkWindow*) _tmp0_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = NULL;
}

static void
____lambda14__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda14_ ((PomodoroApplication*) self);
}

void
pomodoro_application_show_window (PomodoroApplication* self,
                                  const gchar* mode,
                                  guint32 timestamp)
{
	PomodoroWindow* _tmp0_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	PomodoroWindow* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mode != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		PomodoroWindow* _tmp1_;
		PomodoroWindow* _tmp2_;
		PomodoroWindow* _tmp3_;
		PomodoroWindow* _tmp4_;
		_tmp1_ = pomodoro_window_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->window);
		self->priv->window = _tmp1_;
		_tmp2_ = self->priv->window;
		gtk_window_set_application ((GtkWindow*) _tmp2_, (GtkApplication*) self);
		_tmp3_ = self->priv->window;
		g_signal_connect_object ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda14__gtk_widget_destroy, self, 0);
		_tmp4_ = self->priv->window;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp4_);
	}
	if (mode != NULL) {
		_tmp6_ = g_strcmp0 (mode, "default") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = mode;
	} else {
		PomodoroWindow* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = self->priv->window;
		_tmp8_ = pomodoro_window_get_default_mode (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = self->priv->window;
	pomodoro_window_set_mode (_tmp10_, _tmp5_);
	if (timestamp > ((guint32) 0)) {
		PomodoroWindow* _tmp11_;
		_tmp11_ = self->priv->window;
		gtk_window_present_with_time ((GtkWindow*) _tmp11_, timestamp);
	} else {
		PomodoroWindow* _tmp12_;
		_tmp12_ = self->priv->window;
		gtk_window_present ((GtkWindow*) _tmp12_);
	}
}

static void
___lambda27_ (PomodoroApplication* self)
{
	PomodoroPreferencesDialog* _tmp0_;
	_tmp0_ = self->priv->preferences_dialog;
	gtk_application_remove_window ((GtkApplication*) self, (GtkWindow*) _tmp0_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = NULL;
}

static void
____lambda27__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda27_ ((PomodoroApplication*) self);
}

void
pomodoro_application_show_preferences (PomodoroApplication* self,
                                       guint32 timestamp)
{
	PomodoroPreferencesDialog* _tmp0_;
	PomodoroPreferencesDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		PomodoroPreferencesDialog* _tmp1_;
		PomodoroPreferencesDialog* _tmp2_;
		PomodoroPreferencesDialog* _tmp3_;
		_tmp1_ = pomodoro_preferences_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp1_;
		_tmp2_ = self->priv->preferences_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp2_, "destroy", (GCallback) ____lambda27__gtk_widget_destroy, self, 0);
		_tmp3_ = self->priv->preferences_dialog;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp3_);
	}
	_tmp4_ = self->priv->preferences_dialog;
	if (_tmp4_ != NULL) {
		if (timestamp > ((guint32) 0)) {
			PomodoroPreferencesDialog* _tmp5_;
			_tmp5_ = self->priv->preferences_dialog;
			gtk_window_present_with_time ((GtkWindow*) _tmp5_, timestamp);
		} else {
			PomodoroPreferencesDialog* _tmp6_;
			_tmp6_ = self->priv->preferences_dialog;
			gtk_window_present ((GtkWindow*) _tmp6_);
		}
	}
}

static void
pomodoro_application_activate_timer (PomodoroApplication* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pomodoro_application_show_window (self, "timer", (guint32) 0);
}

static void
pomodoro_application_activate_stats (PomodoroApplication* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pomodoro_application_show_window (self, "stats", (guint32) 0);
}

static void
pomodoro_application_activate_preferences (PomodoroApplication* self,
                                           GSimpleAction* action,
                                           GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	pomodoro_application_show_preferences (self, (guint32) 0);
}

static void
pomodoro_application_activate_visit_website (PomodoroApplication* self,
                                             GSimpleAction* action,
                                             GVariant* parameter)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		gchar** spawn_args = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gint spawn_args_length1;
		gint _spawn_args_size_;
		gchar** spawn_env = NULL;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint spawn_env_length1;
		gint _spawn_env_size_;
		_tmp0_ = g_strdup ("xdg-open");
		_tmp1_ = g_strdup (PACKAGE_URL);
		_tmp2_ = g_new0 (gchar*, 2 + 1);
		_tmp2_[0] = _tmp0_;
		_tmp2_[1] = _tmp1_;
		spawn_args = _tmp2_;
		spawn_args_length1 = 2;
		_spawn_args_size_ = spawn_args_length1;
		_tmp4_ = _tmp3_ = g_get_environ ();
		spawn_env = _tmp4_;
		spawn_env_length1 = _vala_array_length (_tmp3_);
		_spawn_env_size_ = spawn_env_length1;
		g_spawn_async (NULL, spawn_args, spawn_env, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning ("application.vala:451: Failed to spawn process: %s", _tmp6_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pomodoro_application_activate_report_issue (PomodoroApplication* self,
                                            GSimpleAction* action,
                                            GVariant* parameter)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		gchar** spawn_args = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gint spawn_args_length1;
		gint _spawn_args_size_;
		gchar** spawn_env = NULL;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint spawn_env_length1;
		gint _spawn_env_size_;
		_tmp0_ = g_strdup ("xdg-open");
		_tmp1_ = g_strdup (PACKAGE_BUGREPORT);
		_tmp2_ = g_new0 (gchar*, 2 + 1);
		_tmp2_[0] = _tmp0_;
		_tmp2_[1] = _tmp1_;
		spawn_args = _tmp2_;
		spawn_args_length1 = 2;
		_spawn_args_size_ = spawn_args_length1;
		_tmp4_ = _tmp3_ = g_get_environ ();
		spawn_env = _tmp4_;
		spawn_env_length1 = _vala_array_length (_tmp3_);
		_spawn_env_size_ = spawn_env_length1;
		g_spawn_async (NULL, spawn_args, spawn_env, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
			spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
		spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning ("application.vala:470: Failed to spawn process: %s", _tmp6_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda37_ (PomodoroApplication* self)
{
	GtkWindow* _tmp0_;
	_tmp0_ = self->priv->about_dialog;
	gtk_application_remove_window ((GtkApplication*) self, _tmp0_);
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = NULL;
}

static void
____lambda37__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda37_ ((PomodoroApplication*) self);
}

static void
pomodoro_application_activate_about (PomodoroApplication* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	GtkWindow* _tmp0_;
	GtkWindow* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->about_dialog;
	if (_tmp0_ == NULL) {
		GtkWindow* window = NULL;
		GtkWindow* _tmp1_;
		GtkWindow* _tmp2_;
		PomodoroAboutDialog* _tmp3_;
		GtkWindow* _tmp4_;
		GtkWindow* _tmp5_;
		GtkWindow* _tmp8_;
		_tmp1_ = pomodoro_application_get_last_focused_window (self);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		_tmp3_ = pomodoro_about_dialog_new ();
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->about_dialog);
		self->priv->about_dialog = (GtkWindow*) _tmp3_;
		_tmp4_ = self->priv->about_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp4_, "destroy", (GCallback) ____lambda37__gtk_widget_destroy, self, 0);
		_tmp5_ = window;
		if (_tmp5_ != NULL) {
			GtkWindow* _tmp6_;
			GtkWindow* _tmp7_;
			_tmp6_ = self->priv->about_dialog;
			_tmp7_ = window;
			gtk_window_set_transient_for (_tmp6_, _tmp7_);
		}
		_tmp8_ = self->priv->about_dialog;
		gtk_application_add_window ((GtkApplication*) self, _tmp8_);
		_g_object_unref0 (window);
	}
	_tmp9_ = self->priv->about_dialog;
	gtk_window_present (_tmp9_);
}

static void
pomodoro_application_activate_quit (PomodoroApplication* self,
                                    GSimpleAction* action,
                                    GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_application_quit ((GApplication*) self);
}

static void
pomodoro_application_activate_timer_skip (PomodoroApplication* self,
                                          GSimpleAction* action,
                                          GVariant* parameter)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		PomodoroService* _tmp0_;
		_tmp0_ = self->service;
		pomodoro_service_skip (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pomodoro_application_activate_timer_set_state (PomodoroApplication* self,
                                               GSimpleAction* action,
                                               GVariant* parameter)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		PomodoroService* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->service;
		_tmp1_ = g_variant_get_string (parameter, NULL);
		pomodoro_service_set_state (_tmp0_, _tmp1_, 0.0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pomodoro_application_activate_timer_switch_state (PomodoroApplication* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		PomodoroService* _tmp0_;
		const gchar* _tmp1_;
		PomodoroTimer* _tmp2_;
		PomodoroTimerState* _tmp3_;
		PomodoroTimerState* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp0_ = self->service;
		_tmp1_ = g_variant_get_string (parameter, NULL);
		_tmp2_ = self->timer;
		_tmp3_ = pomodoro_timer_get_state (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = pomodoro_timer_state_get_timestamp (_tmp4_);
		_tmp6_ = _tmp5_;
		pomodoro_service_set_state (_tmp0_, _tmp1_, _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_pomodoro_application_activate_timer_g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	pomodoro_application_activate_timer ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_stats_g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	pomodoro_application_activate_stats ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_preferences_g_simple_action_activate (GSimpleAction* _sender,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	pomodoro_application_activate_preferences ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_visit_website_g_simple_action_activate (GSimpleAction* _sender,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	pomodoro_application_activate_visit_website ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_report_issue_g_simple_action_activate (GSimpleAction* _sender,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	pomodoro_application_activate_report_issue ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_about_g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	pomodoro_application_activate_about ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_quit_g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	pomodoro_application_activate_quit ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_timer_skip_g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	pomodoro_application_activate_timer_skip ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_timer_set_state_g_simple_action_activate (GSimpleAction* _sender,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	pomodoro_application_activate_timer_set_state ((PomodoroApplication*) self, _sender, parameter);
}

static void
_pomodoro_application_activate_timer_switch_state_g_simple_action_activate (GSimpleAction* _sender,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	pomodoro_application_activate_timer_switch_state ((PomodoroApplication*) self, _sender, parameter);
}

static void
pomodoro_application_setup_actions (PomodoroApplication* self)
{
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	GSimpleAction* _tmp19_;
	GSimpleAction* _tmp20_;
	GSimpleAction* _tmp21_;
	GSimpleAction* _tmp22_;
	GSimpleAction* _tmp23_;
	const GVariantType* _tmp24_;
	GSimpleAction* _tmp25_;
	GSimpleAction* _tmp26_;
	GSimpleAction* _tmp27_;
	const GVariantType* _tmp28_;
	GSimpleAction* _tmp29_;
	GSimpleAction* _tmp30_;
	GSimpleAction* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_new ("timer", NULL);
	_g_object_unref0 (action);
	action = _tmp0_;
	_tmp1_ = action;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) _pomodoro_application_activate_timer_g_simple_action_activate, self, 0);
	_tmp2_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp2_);
	_tmp3_ = g_simple_action_new ("stats", NULL);
	_g_object_unref0 (action);
	action = _tmp3_;
	_tmp4_ = action;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) _pomodoro_application_activate_stats_g_simple_action_activate, self, 0);
	_tmp5_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp5_);
	_tmp6_ = g_simple_action_new ("preferences", NULL);
	_g_object_unref0 (action);
	action = _tmp6_;
	_tmp7_ = action;
	g_signal_connect_object (_tmp7_, "activate", (GCallback) _pomodoro_application_activate_preferences_g_simple_action_activate, self, 0);
	_tmp8_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp8_);
	_tmp9_ = g_simple_action_new ("visit-website", NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _pomodoro_application_activate_visit_website_g_simple_action_activate, self, 0);
	_tmp11_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp11_);
	_tmp12_ = g_simple_action_new ("report-issue", NULL);
	_g_object_unref0 (action);
	action = _tmp12_;
	_tmp13_ = action;
	g_signal_connect_object (_tmp13_, "activate", (GCallback) _pomodoro_application_activate_report_issue_g_simple_action_activate, self, 0);
	_tmp14_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp14_);
	_tmp15_ = g_simple_action_new ("about", NULL);
	_g_object_unref0 (action);
	action = _tmp15_;
	_tmp16_ = action;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) _pomodoro_application_activate_about_g_simple_action_activate, self, 0);
	_tmp17_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp17_);
	_tmp18_ = g_simple_action_new ("quit", NULL);
	_g_object_unref0 (action);
	action = _tmp18_;
	_tmp19_ = action;
	g_signal_connect_object (_tmp19_, "activate", (GCallback) _pomodoro_application_activate_quit_g_simple_action_activate, self, 0);
	_tmp20_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp20_);
	_tmp21_ = g_simple_action_new ("timer-skip", NULL);
	_g_object_unref0 (action);
	action = _tmp21_;
	_tmp22_ = action;
	g_signal_connect_object (_tmp22_, "activate", (GCallback) _pomodoro_application_activate_timer_skip_g_simple_action_activate, self, 0);
	_tmp23_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp23_);
	_tmp24_ = G_VARIANT_TYPE_STRING;
	_tmp25_ = g_simple_action_new ("timer-set-state", _tmp24_);
	_g_object_unref0 (action);
	action = _tmp25_;
	_tmp26_ = action;
	g_signal_connect_object (_tmp26_, "activate", (GCallback) _pomodoro_application_activate_timer_set_state_g_simple_action_activate, self, 0);
	_tmp27_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp27_);
	_tmp28_ = G_VARIANT_TYPE_STRING;
	_tmp29_ = g_simple_action_new ("timer-switch-state", _tmp28_);
	_g_object_unref0 (action);
	action = _tmp29_;
	_tmp30_ = action;
	g_signal_connect_object (_tmp30_, "activate", (GCallback) _pomodoro_application_activate_timer_switch_state_g_simple_action_activate, self, 0);
	_tmp31_ = action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp31_);
	_tmp32_ = g_strdup ("<Alt>Left");
	_tmp33_ = g_strdup ("Back");
	_tmp34_ = g_new0 (gchar*, 2 + 1);
	_tmp34_[0] = _tmp32_;
	_tmp34_[1] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "stats.previous", _tmp35_);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	_tmp36_ = g_strdup ("<Alt>Right");
	_tmp37_ = g_strdup ("Forward");
	_tmp38_ = g_new0 (gchar*, 2 + 1);
	_tmp38_[0] = _tmp36_;
	_tmp38_[1] = _tmp37_;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "stats.next", _tmp39_);
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	_tmp40_ = g_strdup ("<Primary>q");
	_tmp41_ = g_new0 (gchar*, 1 + 1);
	_tmp41_[0] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp42_);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (action);
}

static gboolean
pomodoro_application_command_line_version_callback (void)
{
	FILE* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	_tmp0_ = stdout;
	_tmp1_ = g_get_application_name ();
	fprintf (_tmp0_, "%s %s\n", _tmp1_, PACKAGE_VERSION);
	pomodoro_application_options_exit_status = POMODORO_APPLICATION_EXIT_STATUS_SUCCESS;
	result = TRUE;
	return result;
}

/**
         * Emitted on the primary instance immediately after registration.
         */
static gboolean
__lambda39_ (PomodoroApplication* self)
{
	PomodoroCapabilityManager* _tmp0_;
	PomodoroCapabilityManager* _tmp1_;
	PomodoroCapabilityManager* _tmp2_;
	PomodoroCapabilityManager* _tmp3_;
	PomodoroCapabilityManager* _tmp4_;
	gboolean result;
	_tmp0_ = self->capabilities;
	pomodoro_capability_manager_enable (_tmp0_, "notifications");
	_tmp1_ = self->capabilities;
	pomodoro_capability_manager_enable (_tmp1_, "indicator");
	_tmp2_ = self->capabilities;
	pomodoro_capability_manager_enable (_tmp2_, "accelerator");
	_tmp3_ = self->capabilities;
	pomodoro_capability_manager_enable (_tmp3_, "hide-system-notifications");
	_tmp4_ = self->capabilities;
	pomodoro_capability_manager_enable (_tmp4_, "idle-monitor");
	g_application_release ((GApplication*) self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda39_ ((PomodoroApplication*) self);
	return result;
}

static void
__lambda38_ (PomodoroApplication* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	pomodoro_application_setup_plugins_finish (self, res);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda39__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda38__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda38_ ((PomodoroApplication*) self, source_object, res);
	g_object_unref (self);
}

static void
pomodoro_application_real_startup (GApplication* base)
{
	PomodoroApplication * self;
	self = (PomodoroApplication*) base;
	g_application_hold ((GApplication*) self);
	G_APPLICATION_CLASS (pomodoro_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	pomodoro_application_restore_timer (self);
	pomodoro_application_setup_resources (self);
	pomodoro_application_setup_actions (self);
	pomodoro_application_setup_repository (self);
	pomodoro_application_setup_capabilities (self);
	pomodoro_application_setup_desktop_extension (self);
	pomodoro_application_setup_plugins (self, ___lambda38__gasync_ready_callback, g_object_ref (self));
}

/**
         * This is just for local things, like showing help
         */
static void
pomodoro_application_parse_command_line (PomodoroApplication* self,
                                         gchar*** arguments,
                                         gint* arguments_length1,
                                         GError** error)
{
	GOptionContext* option_context = NULL;
	GOptionContext* _tmp0_;
	GOptionGroup* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_option_context_new (NULL);
	option_context = _tmp0_;
	g_option_context_add_main_entries (option_context, POMODORO_APPLICATION_OPTIONS_ENTRIES, GETTEXT_PACKAGE);
	_tmp1_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (option_context, _tmp1_);
	g_option_context_parse (option_context, (gint*) (arguments_length1), arguments, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_OPTION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_option_context_free0 (option_context);
			return;
		} else {
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_option_context_free0 (option_context);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
pomodoro_application_real_local_command_line (GApplication* base,
                                              gchar*** arguments,
                                              gint* exit_status)
{
	PomodoroApplication * self;
	gint _vala_exit_status = 0;
	gchar** tmp = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint tmp_length1;
	gint _tmp_size_;
	gchar** arguments_copy = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint arguments_copy_length1;
	gint _arguments_copy_size_;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PomodoroApplication*) base;
	_tmp0_ = ((*arguments) != NULL) ? _vala_array_dup1 (*arguments, _vala_array_length (*arguments)) : (*arguments);
	_tmp0__length1 = _vala_array_length (*arguments);
	tmp = _tmp0_;
	tmp_length1 = _tmp0__length1;
	_tmp_size_ = tmp_length1;
	_tmp1_ = tmp;
	_tmp1__length1 = tmp_length1;
	arguments_copy = _tmp1_;
	arguments_copy_length1 = _tmp1__length1;
	_arguments_copy_size_ = arguments_copy_length1;
	{
		pomodoro_application_parse_command_line (self, &arguments_copy, (gint*) (&arguments_copy_length1), &_inner_error0_);
		_arguments_copy_size_ = arguments_copy_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		fprintf (_tmp2_, "Failed to parse options: %s\n", _tmp4_);
		_vala_exit_status = (gint) POMODORO_APPLICATION_EXIT_STATUS_FAILURE;
		result = TRUE;
		_g_error_free0 (_error_);
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	if (pomodoro_application_options_exit_status != POMODORO_APPLICATION_EXIT_STATUS_UNDEFINED) {
		_vala_exit_status = (gint) pomodoro_application_options_exit_status;
		result = TRUE;
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	_tmp7_ = G_APPLICATION_CLASS (pomodoro_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), arguments, &_tmp6_);
	_vala_exit_status = _tmp6_;
	result = _tmp7_;
	tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
	return result;
}

static gint
pomodoro_application_real_command_line (GApplication* base,
                                        GApplicationCommandLine* command_line)
{
	PomodoroApplication * self;
	gchar** tmp = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint tmp_length1;
	gint _tmp_size_;
	gchar** arguments_copy = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint arguments_copy_length1;
	gint _arguments_copy_size_;
	PomodoroApplicationExitStatus exit_status = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (PomodoroApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp1_ = g_application_command_line_get_arguments (command_line, &_tmp0_);
	tmp = _tmp1_;
	tmp_length1 = _tmp0_;
	_tmp_size_ = tmp_length1;
	_tmp2_ = tmp;
	_tmp2__length1 = tmp_length1;
	arguments_copy = _tmp2_;
	arguments_copy_length1 = _tmp2__length1;
	_arguments_copy_size_ = arguments_copy_length1;
	exit_status = POMODORO_APPLICATION_EXIT_STATUS_SUCCESS;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			if (!_tmp3_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp3_ = FALSE;
			{
				pomodoro_application_parse_command_line (self, &arguments_copy, (gint*) (&arguments_copy_length1), &_inner_error0_);
				_arguments_copy_size_ = arguments_copy_length1;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* _error_ = NULL;
				FILE* _tmp4_;
				GError* _tmp5_;
				const gchar* _tmp6_;
				_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp4_ = stderr;
				_tmp5_ = _error_;
				_tmp6_ = _tmp5_->message;
				fprintf (_tmp4_, "Failed to parse options: %s\n", _tmp6_);
				exit_status = POMODORO_APPLICATION_EXIT_STATUS_FAILURE;
				_g_error_free0 (_error_);
				break;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp7_ = -1;
				tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp7_;
			}
			if (pomodoro_application_options_exit_status != POMODORO_APPLICATION_EXIT_STATUS_UNDEFINED) {
				exit_status = pomodoro_application_options_exit_status;
				break;
			}
			g_application_activate ((GApplication*) self);
		}
	}
	result = (gint) exit_status;
	tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
pomodoro_application_real_shutdown (GApplication* base)
{
	PomodoroApplication * self;
	PomodoroCapabilityManager* _tmp0_;
	PeasEngine* engine = NULL;
	PeasEngine* _tmp1_;
	PeasEngine* _tmp2_;
	PeasEngine* _tmp3_;
	GList* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (PomodoroApplication*) base;
	g_application_hold ((GApplication*) self);
	pomodoro_application_save_timer (self);
	_tmp0_ = self->capabilities;
	pomodoro_capability_manager_disable_all (_tmp0_);
	_tmp1_ = peas_engine_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	engine = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = peas_engine_get_plugin_list (_tmp3_);
	{
		GList* plugin_info_collection = NULL;
		GList* plugin_info_it = NULL;
		plugin_info_collection = _tmp4_;
		for (plugin_info_it = plugin_info_collection; plugin_info_it != NULL; plugin_info_it = plugin_info_it->next) {
			PeasPluginInfo* _tmp5_;
			PeasPluginInfo* plugin_info = NULL;
			_tmp5_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) plugin_info_it->data);
			plugin_info = _tmp5_;
			{
				PeasEngine* _tmp6_;
				PeasPluginInfo* _tmp7_;
				_tmp6_ = engine;
				_tmp7_ = plugin_info;
				peas_engine_unload_plugin (_tmp6_, _tmp7_);
				__vala_PeasPluginInfo_free0 (plugin_info);
			}
		}
	}
	{
		GomAdapter* _tmp8_;
		_tmp8_ = self->priv->adapter;
		if (_tmp8_ != NULL) {
			GomAdapter* _tmp9_;
			_tmp9_ = self->priv->adapter;
			gom_adapter_close_sync (_tmp9_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (engine);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (self->priv->window);
	self->priv->window = NULL;
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = NULL;
	_g_object_unref0 (self->priv->about_dialog);
	self->priv->about_dialog = NULL;
	G_APPLICATION_CLASS (pomodoro_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_application_release ((GApplication*) self);
	_g_object_unref0 (engine);
}

static void
pomodoro_application_real_activate (GApplication* base)
{
	PomodoroApplication * self;
	self = (PomodoroApplication*) base;
	g_application_hold ((GApplication*) self);
	pomodoro_application_options_no_default_window = pomodoro_application_options_no_default_window | pomodoro_application_options_has_timer_option ();
	if (pomodoro_application_options_quit) {
		g_application_quit ((GApplication*) self);
	} else {
		if (pomodoro_application_options_reset) {
			PomodoroTimer* _tmp0_;
			_tmp0_ = self->timer;
			pomodoro_timer_reset (_tmp0_, pomodoro_get_current_time ());
		}
		if (pomodoro_application_options_start_stop) {
			PomodoroTimer* _tmp1_;
			_tmp1_ = self->timer;
			pomodoro_timer_toggle (_tmp1_, pomodoro_get_current_time ());
		} else {
			if (pomodoro_application_options_start) {
				PomodoroTimer* _tmp2_;
				_tmp2_ = self->timer;
				pomodoro_timer_start (_tmp2_, pomodoro_get_current_time ());
			} else {
				if (pomodoro_application_options_stop) {
					PomodoroTimer* _tmp3_;
					_tmp3_ = self->timer;
					pomodoro_timer_stop (_tmp3_, pomodoro_get_current_time ());
				}
			}
		}
		if (pomodoro_application_options_skip) {
			PomodoroTimer* _tmp4_;
			_tmp4_ = self->timer;
			pomodoro_timer_skip (_tmp4_, pomodoro_get_current_time ());
		} else {
			gboolean _tmp5_ = FALSE;
			if (pomodoro_application_options_extend) {
				PomodoroTimer* _tmp6_;
				PomodoroTimerState* _tmp7_;
				PomodoroTimerState* _tmp8_;
				gdouble _tmp9_;
				gdouble _tmp10_;
				_tmp6_ = self->timer;
				_tmp7_ = pomodoro_timer_get_state (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = pomodoro_timer_state_get_duration (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp5_ = _tmp10_ > 0.0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				PomodoroTimer* _tmp11_;
				PomodoroTimerState* _tmp12_;
				PomodoroTimerState* _tmp13_;
				PomodoroTimer* _tmp14_;
				PomodoroTimerState* _tmp15_;
				PomodoroTimerState* _tmp16_;
				gdouble _tmp17_;
				gdouble _tmp18_;
				_tmp11_ = self->timer;
				_tmp12_ = pomodoro_timer_get_state (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = self->timer;
				_tmp15_ = pomodoro_timer_get_state (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = pomodoro_timer_state_get_duration (_tmp16_);
				_tmp18_ = _tmp17_;
				pomodoro_timer_state_set_duration (_tmp16_, _tmp18_ + 60.0);
			}
		}
		if (pomodoro_application_options_pause_resume) {
			PomodoroTimer* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			_tmp19_ = self->timer;
			_tmp20_ = pomodoro_timer_get_is_paused (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				PomodoroTimer* _tmp22_;
				_tmp22_ = self->timer;
				pomodoro_timer_resume (_tmp22_, pomodoro_get_current_time ());
			} else {
				PomodoroTimer* _tmp23_;
				_tmp23_ = self->timer;
				pomodoro_timer_pause (_tmp23_, pomodoro_get_current_time ());
			}
		} else {
			if (pomodoro_application_options_pause) {
				PomodoroTimer* _tmp24_;
				_tmp24_ = self->timer;
				pomodoro_timer_pause (_tmp24_, pomodoro_get_current_time ());
			} else {
				if (pomodoro_application_options_resume) {
					PomodoroTimer* _tmp25_;
					_tmp25_ = self->timer;
					pomodoro_timer_resume (_tmp25_, pomodoro_get_current_time ());
				}
			}
		}
		if (pomodoro_application_options_preferences) {
			pomodoro_application_show_preferences (self, (guint32) 0);
		} else {
			if (!pomodoro_application_options_no_default_window) {
				pomodoro_application_show_window (self, "default", (guint32) 0);
			}
		}
		pomodoro_application_options_set_defaults ();
	}
	g_application_release ((GApplication*) self);
}

static void
_pomodoro_application_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	pomodoro_application_on_timer_is_paused_notify ((PomodoroApplication*) self);
}

static void
_pomodoro_application_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                           PomodoroTimerState* state,
                                                                           PomodoroTimerState* previous_state,
                                                                           gpointer self)
{
	pomodoro_application_on_timer_state_changed ((PomodoroApplication*) self, _sender, state, previous_state);
}

static void
_pomodoro_application_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self)
{
	pomodoro_application_on_settings_changed ((PomodoroApplication*) self, _sender, key);
}

static gboolean
pomodoro_application_real_dbus_register (GApplication* base,
                                         GDBusConnection* connection,
                                         const gchar* object_path,
                                         GError** error)
{
	PomodoroApplication * self;
	gboolean _tmp0_ = FALSE;
	PomodoroTimer* _tmp2_;
	GSettings* _tmp7_;
	PomodoroService* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PomodoroApplication*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	_tmp0_ = G_APPLICATION_CLASS (pomodoro_application_parent_class)->dbus_register ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, object_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->timer;
	if (_tmp2_ == NULL) {
		PomodoroTimer* _tmp3_;
		PomodoroTimer* _tmp4_;
		PomodoroTimer* _tmp5_;
		PomodoroTimer* _tmp6_;
		_tmp3_ = pomodoro_timer_get_default ();
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->timer);
		self->timer = _tmp4_;
		_tmp5_ = self->timer;
		g_signal_connect_object ((GObject*) _tmp5_, "notify::is-paused", (GCallback) _pomodoro_application_on_timer_is_paused_notify_g_object_notify, self, 0);
		_tmp6_ = self->timer;
		g_signal_connect_object (_tmp6_, "state-changed", (GCallback) _pomodoro_application_on_timer_state_changed_pomodoro_timer_state_changed, self, G_CONNECT_AFTER);
	}
	_tmp7_ = self->priv->settings;
	if (_tmp7_ == NULL) {
		GSettings* _tmp8_;
		GSettings* _tmp9_;
		GSettings* _tmp10_;
		_tmp8_ = pomodoro_get_settings ();
		_tmp9_ = g_settings_get_child (_tmp8_, "preferences");
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp9_;
		_tmp10_ = self->priv->settings;
		g_signal_connect_object (_tmp10_, "changed", (GCallback) _pomodoro_application_on_settings_changed_g_settings_changed, self, 0);
	}
	_tmp11_ = self->service;
	if (_tmp11_ == NULL) {
		PomodoroTimer* _tmp12_;
		PomodoroService* _tmp13_;
		g_application_hold ((GApplication*) self);
		_tmp12_ = self->timer;
		_tmp13_ = pomodoro_service_new (connection, _tmp12_);
		_g_object_unref0 (self->service);
		self->service = _tmp13_;
		{
			PomodoroService* _tmp14_;
			_tmp14_ = self->service;
			pomodoro_service_register_object (_tmp14_, connection, "/org/gnome/Pomodoro", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp15_ = FALSE;
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch0_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp15_;
			}
		}
		goto __finally0;
		__catch0_g_io_error:
		{
			GError* _error_ = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = _error_;
			_tmp17_ = _tmp16_->message;
			g_warning ("application.vala:830: %s", _tmp17_);
			result = FALSE;
			_g_error_free0 (_error_);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp18_;
		}
	}
	result = TRUE;
	return result;
}

static void
pomodoro_application_real_dbus_unregister (GApplication* base,
                                           GDBusConnection* connection,
                                           const gchar* object_path)
{
	PomodoroApplication * self;
	PomodoroTimer* _tmp0_;
	PomodoroService* _tmp2_;
	self = (PomodoroApplication*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	G_APPLICATION_CLASS (pomodoro_application_parent_class)->dbus_unregister ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), connection, object_path);
	_tmp0_ = self->timer;
	if (_tmp0_ != NULL) {
		PomodoroTimer* _tmp1_;
		_tmp1_ = self->timer;
		g_signal_emit_by_name (_tmp1_, "destroy");
		_g_object_unref0 (self->timer);
		self->timer = NULL;
	}
	_tmp2_ = self->service;
	if (_tmp2_ != NULL) {
		_g_object_unref0 (self->service);
		self->service = NULL;
		g_application_release ((GApplication*) self);
	}
}

static void
pomodoro_application_save_timer (PomodoroApplication* self)
{
	GSettings* state_settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	PomodoroTimer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "state");
	state_settings = _tmp1_;
	_tmp2_ = self->timer;
	pomodoro_timer_save (_tmp2_, state_settings);
	_g_object_unref0 (state_settings);
}

static void
pomodoro_application_restore_timer (PomodoroApplication* self)
{
	GSettings* state_settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	PomodoroTimer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_get_settings ();
	_tmp1_ = g_settings_get_child (_tmp0_, "state");
	state_settings = _tmp1_;
	_tmp2_ = self->timer;
	pomodoro_timer_restore (_tmp2_, state_settings, pomodoro_get_current_time ());
	_g_object_unref0 (state_settings);
}

static void
pomodoro_application_on_settings_changed (PomodoroApplication* self,
                                          GSettings* settings,
                                          const gchar* key)
{
	gdouble state_duration = 0.0;
	PomodoroTimer* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	PomodoroTimer* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->timer;
	_tmp1_ = pomodoro_timer_get_state_duration (_tmp0_);
	_tmp2_ = _tmp1_;
	state_duration = _tmp2_;
	_tmp3_ = key;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("pomodoro-duration")))) {
		switch (0) {
			default:
			{
				PomodoroTimer* _tmp6_;
				PomodoroTimerState* _tmp7_;
				PomodoroTimerState* _tmp8_;
				_tmp6_ = self->timer;
				_tmp7_ = pomodoro_timer_get_state (_tmp6_);
				_tmp8_ = _tmp7_;
				if (POMODORO_IS_POMODORO_STATE (_tmp8_)) {
					state_duration = g_settings_get_double (settings, key);
				}
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("short-break-duration")))) {
		switch (0) {
			default:
			{
				PomodoroTimer* _tmp9_;
				PomodoroTimerState* _tmp10_;
				PomodoroTimerState* _tmp11_;
				_tmp9_ = self->timer;
				_tmp10_ = pomodoro_timer_get_state (_tmp9_);
				_tmp11_ = _tmp10_;
				if (POMODORO_IS_SHORT_BREAK_STATE (_tmp11_)) {
					state_duration = g_settings_get_double (settings, key);
				}
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("long-break-duration")))) {
		switch (0) {
			default:
			{
				PomodoroTimer* _tmp12_;
				PomodoroTimerState* _tmp13_;
				PomodoroTimerState* _tmp14_;
				_tmp12_ = self->timer;
				_tmp13_ = pomodoro_timer_get_state (_tmp12_);
				_tmp14_ = _tmp13_;
				if (POMODORO_IS_LONG_BREAK_STATE (_tmp14_)) {
					state_duration = g_settings_get_double (settings, key);
				}
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("enabled-plugins")))) {
		switch (0) {
			default:
			{
				pomodoro_application_load_plugins (self);
				break;
			}
		}
	}
	_tmp15_ = self->timer;
	_tmp16_ = pomodoro_timer_get_state_duration (_tmp15_);
	_tmp17_ = _tmp16_;
	if (state_duration != _tmp17_) {
		PomodoroTimer* _tmp18_;
		PomodoroTimer* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		_tmp18_ = self->timer;
		_tmp19_ = self->timer;
		_tmp20_ = pomodoro_timer_get_elapsed (_tmp19_);
		_tmp21_ = _tmp20_;
		pomodoro_timer_set_state_duration (_tmp18_, MAX (state_duration, _tmp21_));
	}
}

static void
pomodoro_application_on_timer_is_paused_notify (PomodoroApplication* self)
{
	g_return_if_fail (self != NULL);
	pomodoro_application_save_timer (self);
}

/**
         * Save timer state, assume user is idle when break is completed.
         */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PomodoroApplication* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PomodoroApplication* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->entry_after_midnight);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
____lambda40_ (Block5Data* _data5_,
               GObject* obj,
               GAsyncResult* res)
{
	Block4Data* _data4_;
	PomodoroApplication* self;
	GError* _inner_error0_ = NULL;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		PomodoroEntry* _tmp0_;
		_tmp0_ = _data5_->entry_after_midnight;
		gom_resource_save_finish ((GomResource*) _tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("application.vala:963: Error while saving entry: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_application_release ((GApplication*) self);
}

static void
_____lambda40__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda40_ (self, source_object, res);
	block5_data_unref (self);
}

static void
___lambda41_ (Block4Data* _data4_,
              GObject* obj,
              GAsyncResult* res)
{
	PomodoroApplication* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		PomodoroEntry* _tmp0_;
		_tmp0_ = _data4_->entry;
		gom_resource_save_finish ((GomResource*) _tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("application.vala:976: Error while saving entry: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_application_release ((GApplication*) self);
}

static void
____lambda41__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda41_ (self, source_object, res);
	block4_data_unref (self);
}

static void
pomodoro_application_on_timer_state_changed (PomodoroApplication* self,
                                             PomodoroTimer* timer,
                                             PomodoroTimerState* state,
                                             PomodoroTimerState* previous_state)
{
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timer != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (previous_state != NULL);
	pomodoro_application_save_timer (self);
	_tmp0_ = self->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PomodoroTimer* _tmp3_;
		_tmp3_ = self->timer;
		pomodoro_timer_resume (_tmp3_, pomodoro_get_current_time ());
	}
	if (!POMODORO_IS_DISABLED_STATE (previous_state)) {
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp5_ = pomodoro_timer_state_get_elapsed (previous_state);
		_tmp6_ = _tmp5_;
		_tmp4_ = _tmp6_ > ((gdouble) 0);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Block4Data* _data4_;
		GDateTime* datetime = NULL;
		gdouble _tmp7_;
		gdouble _tmp8_;
		GDateTime* _tmp9_;
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		GDateTime* _tmp12_;
		GDateTime* midnight_datetime = NULL;
		GDateTime* _tmp13_;
		GDateTime* _tmp14_;
		GDateTime* _tmp15_;
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		GDateTime* _tmp18_;
		GDateTime* _tmp19_;
		gdouble midnight_timestamp = 0.0;
		GDateTime* _tmp20_;
		gdouble midnight_split_ratio = 0.0;
		gdouble _tmp21_;
		gdouble _tmp22_;
		gdouble _tmp23_;
		gdouble _tmp24_;
		gdouble _tmp25_;
		gdouble _tmp26_;
		PomodoroEntry* _tmp27_;
		PomodoroEntry* _tmp28_;
		GomRepository* _tmp29_;
		PomodoroEntry* _tmp47_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_tmp7_ = pomodoro_timer_state_get_timestamp (state);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_new_from_unix_utc ((gint64) floor (_tmp8_));
		_tmp10_ = _tmp9_;
		_tmp11_ = g_date_time_to_local (_tmp10_);
		_tmp12_ = _tmp11_;
		_g_date_time_unref0 (_tmp10_);
		datetime = _tmp12_;
		_tmp13_ = datetime;
		_tmp14_ = datetime;
		_tmp15_ = datetime;
		_tmp16_ = g_date_time_new_local (g_date_time_get_year (_tmp13_), g_date_time_get_month (_tmp14_), g_date_time_get_day_of_month (_tmp15_), 0, 0, (gdouble) 0);
		midnight_datetime = _tmp16_;
		_tmp17_ = midnight_datetime;
		_tmp18_ = g_date_time_add_days (_tmp17_, 1);
		_tmp19_ = _tmp18_;
		_g_date_time_unref0 (_tmp19_);
		_tmp20_ = midnight_datetime;
		midnight_timestamp = (gdouble) g_date_time_to_unix (_tmp20_);
		_tmp21_ = pomodoro_timer_state_get_timestamp (previous_state);
		_tmp22_ = _tmp21_;
		_tmp23_ = pomodoro_timer_state_get_timestamp (state);
		_tmp24_ = _tmp23_;
		_tmp25_ = pomodoro_timer_state_get_timestamp (previous_state);
		_tmp26_ = _tmp25_;
		midnight_split_ratio = CLAMP ((midnight_timestamp - _tmp22_) / (_tmp24_ - _tmp26_), 0.0, 1.0);
		_tmp27_ = pomodoro_entry_new_from_state (previous_state);
		_data4_->entry = _tmp27_;
		_tmp28_ = _data4_->entry;
		_tmp29_ = self->priv->repository;
		g_object_set ((GomResource*) _tmp28_, "repository", _tmp29_, NULL);
		if (midnight_split_ratio > 0.0) {
			Block5Data* _data5_;
			PomodoroEntry* _tmp30_;
			PomodoroEntry* _tmp31_;
			gint64 _tmp32_;
			gint64 _tmp33_;
			PomodoroEntry* _tmp34_;
			PomodoroEntry* _tmp35_;
			GomRepository* _tmp36_;
			PomodoroEntry* _tmp37_;
			GDateTime* _tmp38_;
			PomodoroEntry* _tmp39_;
			PomodoroEntry* _tmp40_;
			gint64 _tmp41_;
			gint64 _tmp42_;
			PomodoroEntry* _tmp43_;
			gint64 _tmp44_;
			gint64 _tmp45_;
			PomodoroEntry* _tmp46_;
			_data5_ = g_slice_new0 (Block5Data);
			_data5_->_ref_count_ = 1;
			_data5_->_data4_ = block4_data_ref (_data4_);
			_tmp30_ = _data4_->entry;
			_tmp31_ = _data4_->entry;
			_tmp32_ = pomodoro_entry_get_elapsed (_tmp31_);
			_tmp33_ = _tmp32_;
			pomodoro_entry_set_elapsed (_tmp30_, (gint64) round (((gdouble) _tmp33_) * midnight_split_ratio));
			_tmp34_ = pomodoro_entry_new_from_state (previous_state);
			_data5_->entry_after_midnight = _tmp34_;
			_tmp35_ = _data5_->entry_after_midnight;
			_tmp36_ = self->priv->repository;
			g_object_set ((GomResource*) _tmp35_, "repository", _tmp36_, NULL);
			_tmp37_ = _data5_->entry_after_midnight;
			_tmp38_ = midnight_datetime;
			pomodoro_entry_set_datetime (_tmp37_, _tmp38_);
			_tmp39_ = _data5_->entry_after_midnight;
			_tmp40_ = _data5_->entry_after_midnight;
			_tmp41_ = pomodoro_entry_get_elapsed (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = _data4_->entry;
			_tmp44_ = pomodoro_entry_get_elapsed (_tmp43_);
			_tmp45_ = _tmp44_;
			pomodoro_entry_set_elapsed (_tmp40_, _tmp42_ - _tmp45_);
			g_application_hold ((GApplication*) self);
			_tmp46_ = _data5_->entry_after_midnight;
			gom_resource_save_async ((GomResource*) _tmp46_, _____lambda40__gasync_ready_callback, block5_data_ref (_data5_));
			block5_data_unref (_data5_);
			_data5_ = NULL;
		}
		g_application_hold ((GApplication*) self);
		_tmp47_ = _data4_->entry;
		gom_resource_save_async ((GomResource*) _tmp47_, ____lambda41__gasync_ready_callback, block4_data_ref (_data4_));
		_g_date_time_unref0 (midnight_datetime);
		_g_date_time_unref0 (datetime);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
}

static void
pomodoro_application_options_set_defaults (void)
{
	pomodoro_application_options_no_default_window = FALSE;
	pomodoro_application_options_preferences = FALSE;
	pomodoro_application_options_quit = FALSE;
	pomodoro_application_options_start_stop = FALSE;
	pomodoro_application_options_start = FALSE;
	pomodoro_application_options_stop = FALSE;
	pomodoro_application_options_pause_resume = FALSE;
	pomodoro_application_options_pause = FALSE;
	pomodoro_application_options_resume = FALSE;
	pomodoro_application_options_skip = FALSE;
	pomodoro_application_options_extend = FALSE;
	pomodoro_application_options_reset = FALSE;
}

static gboolean
pomodoro_application_options_has_timer_option (void)
{
	gboolean result;
	result = (((((((pomodoro_application_options_start_stop | pomodoro_application_options_start) | pomodoro_application_options_stop) | pomodoro_application_options_pause_resume) | pomodoro_application_options_pause) | pomodoro_application_options_resume) | pomodoro_application_options_skip) | pomodoro_application_options_extend) | pomodoro_application_options_reset;
	return result;
}

static PomodoroApplicationOptions*
pomodoro_application_options_construct (GType object_type)
{
	PomodoroApplicationOptions* self = NULL;
	self = (PomodoroApplicationOptions*) g_type_create_instance (object_type);
	return self;
}

static PomodoroApplicationOptions*
pomodoro_application_options_new (void)
{
	return pomodoro_application_options_construct (POMODORO_APPLICATION_TYPE_OPTIONS);
}

static void
pomodoro_application_value_options_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
pomodoro_application_value_options_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pomodoro_application_options_unref (value->data[0].v_pointer);
	}
}

static void
pomodoro_application_value_options_copy_value (const GValue* src_value,
                                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pomodoro_application_options_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
pomodoro_application_value_options_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
pomodoro_application_value_options_collect_value (GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PomodoroApplicationOptions * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pomodoro_application_options_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
pomodoro_application_value_options_lcopy_value (const GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	PomodoroApplicationOptions ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pomodoro_application_options_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
pomodoro_application_param_spec_options (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags)
{
	PomodoroApplicationParamSpecOptions* spec;
	g_return_val_if_fail (g_type_is_a (object_type, POMODORO_APPLICATION_TYPE_OPTIONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
pomodoro_application_value_get_options (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, POMODORO_APPLICATION_TYPE_OPTIONS), NULL);
	return value->data[0].v_pointer;
}

static void
pomodoro_application_value_set_options (GValue* value,
                                        gpointer v_object)
{
	PomodoroApplicationOptions * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, POMODORO_APPLICATION_TYPE_OPTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, POMODORO_APPLICATION_TYPE_OPTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pomodoro_application_options_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pomodoro_application_options_unref (old);
	}
}

static void
pomodoro_application_value_take_options (GValue* value,
                                         gpointer v_object)
{
	PomodoroApplicationOptions * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, POMODORO_APPLICATION_TYPE_OPTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, POMODORO_APPLICATION_TYPE_OPTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pomodoro_application_options_unref (old);
	}
}

static void
pomodoro_application_options_class_init (PomodoroApplicationOptionsClass * klass,
                                         gpointer klass_data)
{
	pomodoro_application_options_parent_class = g_type_class_peek_parent (klass);
	((PomodoroApplicationOptionsClass *) klass)->finalize = pomodoro_application_options_finalize;
}

static void
pomodoro_application_options_instance_init (PomodoroApplicationOptions * self,
                                            gpointer klass)
{
	self->ref_count = 1;
}

static void
pomodoro_application_options_finalize (PomodoroApplicationOptions * obj)
{
	PomodoroApplicationOptions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_APPLICATION_TYPE_OPTIONS, PomodoroApplicationOptions);
	g_signal_handlers_destroy (self);
}

static GType
pomodoro_application_options_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { pomodoro_application_value_options_init, pomodoro_application_value_options_free_value, pomodoro_application_value_options_copy_value, pomodoro_application_value_options_peek_pointer, "p", pomodoro_application_value_options_collect_value, "p", pomodoro_application_value_options_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroApplicationOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_application_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroApplicationOptions), 0, (GInstanceInitFunc) pomodoro_application_options_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pomodoro_application_options_type_id;
	pomodoro_application_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PomodoroApplicationOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return pomodoro_application_options_type_id;
}

static GType
pomodoro_application_options_get_type (void)
{
	static volatile gsize pomodoro_application_options_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_application_options_type_id__once)) {
		GType pomodoro_application_options_type_id;
		pomodoro_application_options_type_id = pomodoro_application_options_get_type_once ();
		g_once_init_leave (&pomodoro_application_options_type_id__once, pomodoro_application_options_type_id);
	}
	return pomodoro_application_options_type_id__once;
}

static gpointer
pomodoro_application_options_ref (gpointer instance)
{
	PomodoroApplicationOptions * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
pomodoro_application_options_unref (gpointer instance)
{
	PomodoroApplicationOptions * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		POMODORO_APPLICATION_OPTIONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
pomodoro_application_class_init (PomodoroApplicationClass * klass,
                                 gpointer klass_data)
{
	pomodoro_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) pomodoro_application_real_startup;
	((GApplicationClass *) klass)->local_command_line = (gboolean (*) (GApplication*, gchar***, gint*)) pomodoro_application_real_local_command_line;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) pomodoro_application_real_command_line;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) pomodoro_application_real_shutdown;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) pomodoro_application_real_activate;
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) pomodoro_application_real_dbus_register;
	((GApplicationClass *) klass)->dbus_unregister = (void (*) (GApplication*, GDBusConnection*, const gchar*)) pomodoro_application_real_dbus_unregister;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_application_finalize;
}

static void
pomodoro_application_instance_init (PomodoroApplication * self,
                                    gpointer klass)
{
	self->priv = pomodoro_application_get_instance_private (self);
}

static void
pomodoro_application_finalize (GObject * obj)
{
	PomodoroApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_APPLICATION, PomodoroApplication);
	_g_object_unref0 (self->service);
	_g_object_unref0 (self->timer);
	_g_object_unref0 (self->capabilities);
	_g_object_unref0 (self->priv->repository);
	_g_object_unref0 (self->priv->adapter);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->desktop_extension);
	_g_object_unref0 (self->priv->about_dialog);
	_g_object_unref0 (self->priv->extensions);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (pomodoro_application_parent_class)->finalize (obj);
}

static GType
pomodoro_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroApplication), 0, (GInstanceInitFunc) pomodoro_application_instance_init, NULL };
	GType pomodoro_application_type_id;
	pomodoro_application_type_id = g_type_register_static (gtk_application_get_type (), "PomodoroApplication", &g_define_type_info, 0);
	PomodoroApplication_private_offset = g_type_add_instance_private (pomodoro_application_type_id, sizeof (PomodoroApplicationPrivate));
	return pomodoro_application_type_id;
}

GType
pomodoro_application_get_type (void)
{
	static volatile gsize pomodoro_application_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_application_type_id__once)) {
		GType pomodoro_application_type_id;
		pomodoro_application_type_id = pomodoro_application_get_type_once ();
		g_once_init_leave (&pomodoro_application_type_id__once, pomodoro_application_type_id);
	}
	return pomodoro_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

