#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 590
#define LARGE_STATE_COUNT 160
#define SYMBOL_COUNT 211
#define ALIAS_COUNT 0
#define TOKEN_COUNT 136
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 3
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 16

enum ts_symbol_identifiers {
  sym_variable_identifier = 1,
  anon_sym_LBRACK = 2,
  anon_sym_RBRACK = 3,
  anon_sym_LBRACE = 4,
  anon_sym_RBRACE = 5,
  sym_block_comment = 6,
  anon_sym_false = 7,
  anon_sym_true = 8,
  anon_sym_DOLLAR = 9,
  anon_sym_SQUOTE = 10,
  aux_sym_character_token1 = 11,
  anon_sym_const = 12,
  anon_sym_function = 13,
  anon_sym_global = 14,
  anon_sym_spork = 15,
  anon_sym_LPAREN = 16,
  anon_sym_RPAREN = 17,
  anon_sym_PERCENT_EQ_GT = 18,
  anon_sym_AMP_EQ_GT = 19,
  anon_sym_STAR_EQ_GT = 20,
  anon_sym_PLUS_EQ_GT = 21,
  anon_sym_DASH_DASH_GT = 22,
  anon_sym_DASH_EQ_GT = 23,
  anon_sym_SLASH_EQ_GT = 24,
  anon_sym_EQ_LT = 25,
  anon_sym_EQ_GT = 26,
  anon_sym_EQ_CARET = 27,
  anon_sym_AT_EQ_GT = 28,
  anon_sym_CARET_EQ_GT = 29,
  anon_sym_PIPE_EQ_GT = 30,
  anon_sym_public = 31,
  anon_sym_class = 32,
  anon_sym_extends = 33,
  sym_class_identifier = 34,
  anon_sym_new = 35,
  anon_sym_implements = 36,
  anon_sym_interface = 37,
  anon_sym_private = 38,
  anon_sym_protected = 39,
  anon_sym_pure = 40,
  anon_sym_static = 41,
  anon_sym_super = 42,
  anon_sym_this = 43,
  anon_sym_POUND_LPAREN = 44,
  anon_sym_COMMA = 45,
  anon_sym_if = 46,
  anon_sym_else = 47,
  anon_sym_break = 48,
  anon_sym_continue = 49,
  anon_sym_switch = 50,
  anon_sym_LT_LT_LT = 51,
  anon_sym_GT_GT_GT = 52,
  anon_sym_ATdoc = 53,
  anon_sym_do = 54,
  anon_sym_day = 55,
  anon_sym_hour = 56,
  anon_sym_minute = 57,
  anon_sym_ms = 58,
  anon_sym_samp = 59,
  anon_sym_second = 60,
  anon_sym_week = 61,
  anon_sym_COLON_COLON = 62,
  sym_escape_character = 63,
  sym_float = 64,
  anon_sym_for = 65,
  anon_sym_SEMI = 66,
  anon_sym_COLON = 67,
  anon_sym_DOT = 68,
  anon_sym_fun = 69,
  anon_sym_adc = 70,
  anon_sym_blackhole = 71,
  anon_sym_dac = 72,
  sym_hexidecimal = 73,
  anon_sym_PLUS_PLUS = 74,
  anon_sym_DASH_DASH = 75,
  anon_sym_ATimport = 76,
  sym_int = 77,
  sym_line_comment = 78,
  anon_sym_repeat = 79,
  anon_sym_me = 80,
  anon_sym_ATconstruct = 81,
  anon_sym_ATdestruct = 82,
  anon_sym_BANG = 83,
  anon_sym_DASH = 84,
  anon_sym_BANG_EQ = 85,
  anon_sym_PERCENT = 86,
  anon_sym_AMP = 87,
  anon_sym_AMP_AMP = 88,
  anon_sym_STAR = 89,
  anon_sym_PLUS = 90,
  anon_sym_SLASH = 91,
  anon_sym_LT = 92,
  anon_sym_LT_LT = 93,
  anon_sym_LT_EQ = 94,
  anon_sym_EQ_EQ = 95,
  anon_sym_GT = 96,
  anon_sym_GT_EQ = 97,
  anon_sym_GT_GT = 98,
  anon_sym_CARET = 99,
  anon_sym_PIPE = 100,
  anon_sym_PIPE_PIPE = 101,
  anon_sym_AToperator = 102,
  anon_sym_PERCENT_LPAREN = 103,
  anon_sym_auto = 104,
  anon_sym_complex = 105,
  anon_sym_dur = 106,
  anon_sym_float = 107,
  anon_sym_int = 108,
  anon_sym_polar = 109,
  anon_sym_same = 110,
  anon_sym_time = 111,
  anon_sym_vec2 = 112,
  anon_sym_vec3 = 113,
  anon_sym_vec4 = 114,
  anon_sym_void = 115,
  anon_sym_AT = 116,
  anon_sym_Event = 117,
  anon_sym_Object = 118,
  anon_sym_UGen = 119,
  anon_sym_array = 120,
  anon_sym_string = 121,
  anon_sym_AT_LPAREN = 122,
  anon_sym_NULL = 123,
  anon_sym_maybe = 124,
  anon_sym_now = 125,
  anon_sym_null = 126,
  anon_sym_pi = 127,
  anon_sym_TILDE = 128,
  anon_sym_return = 129,
  anon_sym_DQUOTE = 130,
  aux_sym_string_token1 = 131,
  anon_sym_QMARK = 132,
  anon_sym_LBRACK_RBRACK = 133,
  anon_sym_until = 134,
  anon_sym_while = 135,
  sym_source_file = 136,
  sym_array = 137,
  sym_array_identifier = 138,
  sym_binary_expression = 139,
  sym_block = 140,
  sym_boolean_literal_value = 141,
  sym_cast = 142,
  sym_character = 143,
  sym__chuck_keyword = 144,
  sym_chuck_operation = 145,
  sym_chuck_operator = 146,
  sym_class_definition = 147,
  sym_class_instantiation = 148,
  sym__class_keyword = 149,
  sym_complex = 150,
  sym_conditional = 151,
  sym__control_structure = 152,
  sym_control_structure_keyword = 153,
  sym__control_structure_body = 154,
  sym_debug_print = 155,
  sym__declaration = 156,
  sym_doc_comment = 157,
  sym_documented_expression = 158,
  sym_do_loop = 159,
  sym_duration_identifier = 160,
  sym_dur = 161,
  sym__expression = 162,
  sym_expression_group = 163,
  sym__expression_list = 164,
  sym_for_loop = 165,
  sym_for_each_loop = 166,
  sym_function_call = 167,
  sym__function_call_chain = 168,
  sym_function_definition = 169,
  sym__function_keyword = 170,
  sym__function_name_and_body = 171,
  sym__function_parameters = 172,
  sym_global_unit_generator = 173,
  sym_post_increment_expression = 174,
  sym_pre_increment_expression = 175,
  sym__increment_expression = 176,
  sym__identifier = 177,
  sym_import_expression = 178,
  sym_keyword = 179,
  sym__literal_value = 180,
  sym_loop = 181,
  sym_member_identifier = 182,
  sym_method_definition = 183,
  sym_negation_expression = 184,
  sym_negative_expression = 185,
  sym__number = 186,
  sym_operator = 187,
  sym_overload_definition = 188,
  sym_polar = 189,
  sym_primitive_type = 190,
  sym_reference_declaration = 191,
  sym_reference_type = 192,
  sym_reference_values = 193,
  sym_special_literal_value = 194,
  sym_spork_expression = 195,
  sym_statement = 196,
  sym_string = 197,
  sym_ternary_expression = 198,
  sym__type = 199,
  sym__until_while_expression = 200,
  sym_variable_declaration = 201,
  aux_sym_source_file_repeat1 = 202,
  aux_sym_array_identifier_repeat1 = 203,
  aux_sym_block_repeat1 = 204,
  aux_sym__expression_list_repeat1 = 205,
  aux_sym__function_call_chain_repeat1 = 206,
  aux_sym__function_parameters_repeat1 = 207,
  aux_sym_import_expression_repeat1 = 208,
  aux_sym_member_identifier_repeat1 = 209,
  aux_sym_variable_declaration_repeat1 = 210,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_variable_identifier] = "variable_identifier",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_block_comment] = "block_comment",
  [anon_sym_false] = "false",
  [anon_sym_true] = "true",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_character_token1] = "character_token1",
  [anon_sym_const] = "const",
  [anon_sym_function] = "function",
  [anon_sym_global] = "global",
  [anon_sym_spork] = "spork",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_PERCENT_EQ_GT] = "%=>",
  [anon_sym_AMP_EQ_GT] = "&=>",
  [anon_sym_STAR_EQ_GT] = "*=>",
  [anon_sym_PLUS_EQ_GT] = "+=>",
  [anon_sym_DASH_DASH_GT] = "-->",
  [anon_sym_DASH_EQ_GT] = "-=>",
  [anon_sym_SLASH_EQ_GT] = "/=>",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_EQ_CARET] = "=^",
  [anon_sym_AT_EQ_GT] = "@=>",
  [anon_sym_CARET_EQ_GT] = "^=>",
  [anon_sym_PIPE_EQ_GT] = "|=>",
  [anon_sym_public] = "public",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [sym_class_identifier] = "class_identifier",
  [anon_sym_new] = "new",
  [anon_sym_implements] = "implements",
  [anon_sym_interface] = "interface",
  [anon_sym_private] = "private",
  [anon_sym_protected] = "protected",
  [anon_sym_pure] = "pure",
  [anon_sym_static] = "static",
  [anon_sym_super] = "super",
  [anon_sym_this] = "this",
  [anon_sym_POUND_LPAREN] = "#(",
  [anon_sym_COMMA] = ",",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_switch] = "switch",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_ATdoc] = "@doc",
  [anon_sym_do] = "do",
  [anon_sym_day] = "day",
  [anon_sym_hour] = "hour",
  [anon_sym_minute] = "minute",
  [anon_sym_ms] = "ms",
  [anon_sym_samp] = "samp",
  [anon_sym_second] = "second",
  [anon_sym_week] = "week",
  [anon_sym_COLON_COLON] = "::",
  [sym_escape_character] = "escape_character",
  [sym_float] = "float",
  [anon_sym_for] = "for",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT] = ".",
  [anon_sym_fun] = "fun",
  [anon_sym_adc] = "adc",
  [anon_sym_blackhole] = "blackhole",
  [anon_sym_dac] = "dac",
  [sym_hexidecimal] = "hexidecimal",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_ATimport] = "@import",
  [sym_int] = "int",
  [sym_line_comment] = "line_comment",
  [anon_sym_repeat] = "repeat",
  [anon_sym_me] = "me",
  [anon_sym_ATconstruct] = "@construct",
  [anon_sym_ATdestruct] = "@destruct",
  [anon_sym_BANG] = "!",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PERCENT] = "%",
  [anon_sym_AMP] = "&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_STAR] = "*",
  [anon_sym_PLUS] = "+",
  [anon_sym_SLASH] = "/",
  [anon_sym_LT] = "<",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AToperator] = "@operator",
  [anon_sym_PERCENT_LPAREN] = "%(",
  [anon_sym_auto] = "auto",
  [anon_sym_complex] = "complex",
  [anon_sym_dur] = "dur",
  [anon_sym_float] = "float",
  [anon_sym_int] = "int",
  [anon_sym_polar] = "polar",
  [anon_sym_same] = "same",
  [anon_sym_time] = "time",
  [anon_sym_vec2] = "vec2",
  [anon_sym_vec3] = "vec3",
  [anon_sym_vec4] = "vec4",
  [anon_sym_void] = "void",
  [anon_sym_AT] = "@",
  [anon_sym_Event] = "Event",
  [anon_sym_Object] = "Object",
  [anon_sym_UGen] = "UGen",
  [anon_sym_array] = "array",
  [anon_sym_string] = "string",
  [anon_sym_AT_LPAREN] = "@(",
  [anon_sym_NULL] = "NULL",
  [anon_sym_maybe] = "maybe",
  [anon_sym_now] = "now",
  [anon_sym_null] = "null",
  [anon_sym_pi] = "pi",
  [anon_sym_TILDE] = "~",
  [anon_sym_return] = "return",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_QMARK] = "\?",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_until] = "until",
  [anon_sym_while] = "while",
  [sym_source_file] = "source_file",
  [sym_array] = "array",
  [sym_array_identifier] = "array_identifier",
  [sym_binary_expression] = "binary_expression",
  [sym_block] = "block",
  [sym_boolean_literal_value] = "boolean_literal_value",
  [sym_cast] = "cast",
  [sym_character] = "character",
  [sym__chuck_keyword] = "_chuck_keyword",
  [sym_chuck_operation] = "chuck_operation",
  [sym_chuck_operator] = "chuck_operator",
  [sym_class_definition] = "class_definition",
  [sym_class_instantiation] = "class_instantiation",
  [sym__class_keyword] = "_class_keyword",
  [sym_complex] = "complex",
  [sym_conditional] = "conditional",
  [sym__control_structure] = "_control_structure",
  [sym_control_structure_keyword] = "control_structure_keyword",
  [sym__control_structure_body] = "_control_structure_body",
  [sym_debug_print] = "debug_print",
  [sym__declaration] = "_declaration",
  [sym_doc_comment] = "doc_comment",
  [sym_documented_expression] = "documented_expression",
  [sym_do_loop] = "do_loop",
  [sym_duration_identifier] = "duration_identifier",
  [sym_dur] = "dur",
  [sym__expression] = "_expression",
  [sym_expression_group] = "expression_group",
  [sym__expression_list] = "_expression_list",
  [sym_for_loop] = "for_loop",
  [sym_for_each_loop] = "for_each_loop",
  [sym_function_call] = "function_call",
  [sym__function_call_chain] = "_function_call_chain",
  [sym_function_definition] = "function_definition",
  [sym__function_keyword] = "_function_keyword",
  [sym__function_name_and_body] = "_function_name_and_body",
  [sym__function_parameters] = "_function_parameters",
  [sym_global_unit_generator] = "global_unit_generator",
  [sym_post_increment_expression] = "post_increment_expression",
  [sym_pre_increment_expression] = "pre_increment_expression",
  [sym__increment_expression] = "_increment_expression",
  [sym__identifier] = "_identifier",
  [sym_import_expression] = "import_expression",
  [sym_keyword] = "keyword",
  [sym__literal_value] = "_literal_value",
  [sym_loop] = "loop",
  [sym_member_identifier] = "member_identifier",
  [sym_method_definition] = "method_definition",
  [sym_negation_expression] = "negation_expression",
  [sym_negative_expression] = "negative_expression",
  [sym__number] = "_number",
  [sym_operator] = "operator",
  [sym_overload_definition] = "overload_definition",
  [sym_polar] = "polar",
  [sym_primitive_type] = "primitive_type",
  [sym_reference_declaration] = "reference_declaration",
  [sym_reference_type] = "reference_type",
  [sym_reference_values] = "reference_values",
  [sym_special_literal_value] = "special_literal_value",
  [sym_spork_expression] = "spork_expression",
  [sym_statement] = "statement",
  [sym_string] = "string",
  [sym_ternary_expression] = "ternary_expression",
  [sym__type] = "_type",
  [sym__until_while_expression] = "_until_while_expression",
  [sym_variable_declaration] = "variable_declaration",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_array_identifier_repeat1] = "array_identifier_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym__function_call_chain_repeat1] = "_function_call_chain_repeat1",
  [aux_sym__function_parameters_repeat1] = "_function_parameters_repeat1",
  [aux_sym_import_expression_repeat1] = "import_expression_repeat1",
  [aux_sym_member_identifier_repeat1] = "member_identifier_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_variable_identifier] = sym_variable_identifier,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_block_comment] = sym_block_comment,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_character_token1] = aux_sym_character_token1,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_spork] = anon_sym_spork,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_PERCENT_EQ_GT] = anon_sym_PERCENT_EQ_GT,
  [anon_sym_AMP_EQ_GT] = anon_sym_AMP_EQ_GT,
  [anon_sym_STAR_EQ_GT] = anon_sym_STAR_EQ_GT,
  [anon_sym_PLUS_EQ_GT] = anon_sym_PLUS_EQ_GT,
  [anon_sym_DASH_DASH_GT] = anon_sym_DASH_DASH_GT,
  [anon_sym_DASH_EQ_GT] = anon_sym_DASH_EQ_GT,
  [anon_sym_SLASH_EQ_GT] = anon_sym_SLASH_EQ_GT,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_EQ_CARET] = anon_sym_EQ_CARET,
  [anon_sym_AT_EQ_GT] = anon_sym_AT_EQ_GT,
  [anon_sym_CARET_EQ_GT] = anon_sym_CARET_EQ_GT,
  [anon_sym_PIPE_EQ_GT] = anon_sym_PIPE_EQ_GT,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [sym_class_identifier] = sym_class_identifier,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_implements] = anon_sym_implements,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_protected] = anon_sym_protected,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_super] = anon_sym_super,
  [anon_sym_this] = anon_sym_this,
  [anon_sym_POUND_LPAREN] = anon_sym_POUND_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_LT_LT_LT] = anon_sym_LT_LT_LT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_ATdoc] = anon_sym_ATdoc,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_day] = anon_sym_day,
  [anon_sym_hour] = anon_sym_hour,
  [anon_sym_minute] = anon_sym_minute,
  [anon_sym_ms] = anon_sym_ms,
  [anon_sym_samp] = anon_sym_samp,
  [anon_sym_second] = anon_sym_second,
  [anon_sym_week] = anon_sym_week,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_escape_character] = sym_escape_character,
  [sym_float] = sym_float,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_adc] = anon_sym_adc,
  [anon_sym_blackhole] = anon_sym_blackhole,
  [anon_sym_dac] = anon_sym_dac,
  [sym_hexidecimal] = sym_hexidecimal,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_ATimport] = anon_sym_ATimport,
  [sym_int] = sym_int,
  [sym_line_comment] = sym_line_comment,
  [anon_sym_repeat] = anon_sym_repeat,
  [anon_sym_me] = anon_sym_me,
  [anon_sym_ATconstruct] = anon_sym_ATconstruct,
  [anon_sym_ATdestruct] = anon_sym_ATdestruct,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AToperator] = anon_sym_AToperator,
  [anon_sym_PERCENT_LPAREN] = anon_sym_PERCENT_LPAREN,
  [anon_sym_auto] = anon_sym_auto,
  [anon_sym_complex] = anon_sym_complex,
  [anon_sym_dur] = anon_sym_dur,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_polar] = anon_sym_polar,
  [anon_sym_same] = anon_sym_same,
  [anon_sym_time] = anon_sym_time,
  [anon_sym_vec2] = anon_sym_vec2,
  [anon_sym_vec3] = anon_sym_vec3,
  [anon_sym_vec4] = anon_sym_vec4,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_Event] = anon_sym_Event,
  [anon_sym_Object] = anon_sym_Object,
  [anon_sym_UGen] = anon_sym_UGen,
  [anon_sym_array] = anon_sym_array,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_AT_LPAREN] = anon_sym_AT_LPAREN,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_maybe] = anon_sym_maybe,
  [anon_sym_now] = anon_sym_now,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_pi] = anon_sym_pi,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_until] = anon_sym_until,
  [anon_sym_while] = anon_sym_while,
  [sym_source_file] = sym_source_file,
  [sym_array] = sym_array,
  [sym_array_identifier] = sym_array_identifier,
  [sym_binary_expression] = sym_binary_expression,
  [sym_block] = sym_block,
  [sym_boolean_literal_value] = sym_boolean_literal_value,
  [sym_cast] = sym_cast,
  [sym_character] = sym_character,
  [sym__chuck_keyword] = sym__chuck_keyword,
  [sym_chuck_operation] = sym_chuck_operation,
  [sym_chuck_operator] = sym_chuck_operator,
  [sym_class_definition] = sym_class_definition,
  [sym_class_instantiation] = sym_class_instantiation,
  [sym__class_keyword] = sym__class_keyword,
  [sym_complex] = sym_complex,
  [sym_conditional] = sym_conditional,
  [sym__control_structure] = sym__control_structure,
  [sym_control_structure_keyword] = sym_control_structure_keyword,
  [sym__control_structure_body] = sym__control_structure_body,
  [sym_debug_print] = sym_debug_print,
  [sym__declaration] = sym__declaration,
  [sym_doc_comment] = sym_doc_comment,
  [sym_documented_expression] = sym_documented_expression,
  [sym_do_loop] = sym_do_loop,
  [sym_duration_identifier] = sym_duration_identifier,
  [sym_dur] = sym_dur,
  [sym__expression] = sym__expression,
  [sym_expression_group] = sym_expression_group,
  [sym__expression_list] = sym__expression_list,
  [sym_for_loop] = sym_for_loop,
  [sym_for_each_loop] = sym_for_each_loop,
  [sym_function_call] = sym_function_call,
  [sym__function_call_chain] = sym__function_call_chain,
  [sym_function_definition] = sym_function_definition,
  [sym__function_keyword] = sym__function_keyword,
  [sym__function_name_and_body] = sym__function_name_and_body,
  [sym__function_parameters] = sym__function_parameters,
  [sym_global_unit_generator] = sym_global_unit_generator,
  [sym_post_increment_expression] = sym_post_increment_expression,
  [sym_pre_increment_expression] = sym_pre_increment_expression,
  [sym__increment_expression] = sym__increment_expression,
  [sym__identifier] = sym__identifier,
  [sym_import_expression] = sym_import_expression,
  [sym_keyword] = sym_keyword,
  [sym__literal_value] = sym__literal_value,
  [sym_loop] = sym_loop,
  [sym_member_identifier] = sym_member_identifier,
  [sym_method_definition] = sym_method_definition,
  [sym_negation_expression] = sym_negation_expression,
  [sym_negative_expression] = sym_negative_expression,
  [sym__number] = sym__number,
  [sym_operator] = sym_operator,
  [sym_overload_definition] = sym_overload_definition,
  [sym_polar] = sym_polar,
  [sym_primitive_type] = sym_primitive_type,
  [sym_reference_declaration] = sym_reference_declaration,
  [sym_reference_type] = sym_reference_type,
  [sym_reference_values] = sym_reference_values,
  [sym_special_literal_value] = sym_special_literal_value,
  [sym_spork_expression] = sym_spork_expression,
  [sym_statement] = sym_statement,
  [sym_string] = sym_string,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym__type] = sym__type,
  [sym__until_while_expression] = sym__until_while_expression,
  [sym_variable_declaration] = sym_variable_declaration,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_array_identifier_repeat1] = aux_sym_array_identifier_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym__function_call_chain_repeat1] = aux_sym__function_call_chain_repeat1,
  [aux_sym__function_parameters_repeat1] = aux_sym__function_parameters_repeat1,
  [aux_sym_import_expression_repeat1] = aux_sym_import_expression_repeat1,
  [aux_sym_member_identifier_repeat1] = aux_sym_member_identifier_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_character_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_spork] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [sym_class_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implements] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_protected] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_super] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_this] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATdoc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_day] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hour] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minute] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ms] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_samp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_second] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_week] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_character] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_adc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blackhole] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dac] = {
    .visible = true,
    .named = false,
  },
  [sym_hexidecimal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATimport] = {
    .visible = true,
    .named = false,
  },
  [sym_int] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_repeat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_me] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATconstruct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATdestruct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AToperator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_auto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_complex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dur] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_polar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_same] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_time] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vec2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vec3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vec4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Object] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UGen] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_maybe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_now] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_until] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal_value] = {
    .visible = true,
    .named = true,
  },
  [sym_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_character] = {
    .visible = true,
    .named = true,
  },
  [sym__chuck_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_chuck_operation] = {
    .visible = true,
    .named = true,
  },
  [sym_chuck_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_class_instantiation] = {
    .visible = true,
    .named = true,
  },
  [sym__class_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym_complex] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional] = {
    .visible = true,
    .named = true,
  },
  [sym__control_structure] = {
    .visible = false,
    .named = true,
  },
  [sym_control_structure_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym__control_structure_body] = {
    .visible = false,
    .named = true,
  },
  [sym_debug_print] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_doc_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_documented_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_do_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_duration_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_dur] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_expression_group] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = false,
    .named = true,
  },
  [sym_for_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_for_each_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym__function_call_chain] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_keyword] = {
    .visible = false,
    .named = true,
  },
  [sym__function_name_and_body] = {
    .visible = false,
    .named = true,
  },
  [sym__function_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym_global_unit_generator] = {
    .visible = true,
    .named = true,
  },
  [sym_post_increment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_pre_increment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__increment_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_import_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_value] = {
    .visible = false,
    .named = true,
  },
  [sym_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_member_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_negation_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_negative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_overload_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_polar] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_type] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_values] = {
    .visible = true,
    .named = true,
  },
  [sym_special_literal_value] = {
    .visible = true,
    .named = true,
  },
  [sym_spork_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__until_while_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_call_chain_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_member_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_name = 2,
  field_parameter = 3,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_name] = "name",
  [field_parameter] = "parameter",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 2},
  [3] = {.index = 4, .length = 2},
  [4] = {.index = 6, .length = 2},
  [5] = {.index = 8, .length = 1},
  [6] = {.index = 9, .length = 1},
  [7] = {.index = 10, .length = 1},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 1},
  [10] = {.index = 14, .length = 2},
  [11] = {.index = 16, .length = 1},
  [12] = {.index = 17, .length = 1},
  [13] = {.index = 18, .length = 1},
  [14] = {.index = 19, .length = 2},
  [15] = {.index = 21, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
    {field_parameter, 0, .inherited = true},
  [2] =
    {field_name, 1, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [4] =
    {field_name, 2, .inherited = true},
    {field_parameter, 2, .inherited = true},
  [6] =
    {field_name, 0},
    {field_parameter, 1, .inherited = true},
  [8] =
    {field_argument, 2},
  [9] =
    {field_parameter, 1},
  [10] =
    {field_parameter, 2, .inherited = true},
  [11] =
    {field_name, 1},
    {field_parameter, 2, .inherited = true},
  [13] =
    {field_parameter, 3, .inherited = true},
  [14] =
    {field_parameter, 1},
    {field_parameter, 2},
  [16] =
    {field_parameter, 4, .inherited = true},
  [17] =
    {field_parameter, 4},
  [18] =
    {field_parameter, 5},
  [19] =
    {field_parameter, 4},
    {field_parameter, 5},
  [21] =
    {field_parameter, 5},
    {field_parameter, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 4,
  [6] = 6,
  [7] = 7,
  [8] = 4,
  [9] = 7,
  [10] = 4,
  [11] = 7,
  [12] = 7,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 15,
  [17] = 17,
  [18] = 17,
  [19] = 13,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 13,
  [25] = 15,
  [26] = 20,
  [27] = 17,
  [28] = 21,
  [29] = 20,
  [30] = 21,
  [31] = 22,
  [32] = 23,
  [33] = 22,
  [34] = 23,
  [35] = 14,
  [36] = 14,
  [37] = 37,
  [38] = 37,
  [39] = 37,
  [40] = 37,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 45,
  [47] = 47,
  [48] = 44,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 50,
  [54] = 51,
  [55] = 49,
  [56] = 52,
  [57] = 52,
  [58] = 58,
  [59] = 59,
  [60] = 59,
  [61] = 61,
  [62] = 61,
  [63] = 61,
  [64] = 61,
  [65] = 65,
  [66] = 66,
  [67] = 65,
  [68] = 58,
  [69] = 58,
  [70] = 65,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 73,
  [76] = 74,
  [77] = 71,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 79,
  [83] = 83,
  [84] = 78,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 83,
  [90] = 86,
  [91] = 88,
  [92] = 81,
  [93] = 93,
  [94] = 94,
  [95] = 81,
  [96] = 93,
  [97] = 94,
  [98] = 72,
  [99] = 94,
  [100] = 85,
  [101] = 80,
  [102] = 87,
  [103] = 72,
  [104] = 87,
  [105] = 93,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 109,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 107,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 110,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 108,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 118,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 158,
  [171] = 159,
  [172] = 161,
  [173] = 160,
  [174] = 162,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 168,
  [185] = 167,
  [186] = 186,
  [187] = 160,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 160,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 167,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 106,
  [217] = 143,
  [218] = 218,
  [219] = 107,
  [220] = 108,
  [221] = 109,
  [222] = 222,
  [223] = 223,
  [224] = 110,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 232,
  [236] = 236,
  [237] = 117,
  [238] = 116,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 119,
  [251] = 118,
  [252] = 252,
  [253] = 253,
  [254] = 113,
  [255] = 115,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 112,
  [260] = 260,
  [261] = 114,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 111,
  [269] = 253,
  [270] = 270,
  [271] = 270,
  [272] = 270,
  [273] = 273,
  [274] = 274,
  [275] = 274,
  [276] = 273,
  [277] = 277,
  [278] = 278,
  [279] = 277,
  [280] = 277,
  [281] = 273,
  [282] = 277,
  [283] = 274,
  [284] = 284,
  [285] = 284,
  [286] = 284,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 175,
  [293] = 176,
  [294] = 178,
  [295] = 181,
  [296] = 198,
  [297] = 182,
  [298] = 183,
  [299] = 193,
  [300] = 194,
  [301] = 186,
  [302] = 177,
  [303] = 188,
  [304] = 179,
  [305] = 191,
  [306] = 180,
  [307] = 160,
  [308] = 197,
  [309] = 205,
  [310] = 199,
  [311] = 207,
  [312] = 200,
  [313] = 208,
  [314] = 201,
  [315] = 204,
  [316] = 195,
  [317] = 189,
  [318] = 192,
  [319] = 211,
  [320] = 190,
  [321] = 227,
  [322] = 226,
  [323] = 213,
  [324] = 215,
  [325] = 222,
  [326] = 206,
  [327] = 223,
  [328] = 203,
  [329] = 218,
  [330] = 212,
  [331] = 209,
  [332] = 210,
  [333] = 246,
  [334] = 245,
  [335] = 236,
  [336] = 243,
  [337] = 143,
  [338] = 234,
  [339] = 239,
  [340] = 240,
  [341] = 230,
  [342] = 231,
  [343] = 242,
  [344] = 225,
  [345] = 244,
  [346] = 233,
  [347] = 106,
  [348] = 107,
  [349] = 108,
  [350] = 109,
  [351] = 110,
  [352] = 241,
  [353] = 265,
  [354] = 354,
  [355] = 355,
  [356] = 258,
  [357] = 260,
  [358] = 262,
  [359] = 359,
  [360] = 264,
  [361] = 267,
  [362] = 362,
  [363] = 363,
  [364] = 119,
  [365] = 115,
  [366] = 252,
  [367] = 113,
  [368] = 116,
  [369] = 112,
  [370] = 114,
  [371] = 111,
  [372] = 167,
  [373] = 266,
  [374] = 249,
  [375] = 248,
  [376] = 118,
  [377] = 256,
  [378] = 359,
  [379] = 379,
  [380] = 380,
  [381] = 263,
  [382] = 382,
  [383] = 383,
  [384] = 383,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 388,
  [390] = 382,
  [391] = 386,
  [392] = 387,
  [393] = 393,
  [394] = 393,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 402,
  [405] = 405,
  [406] = 401,
  [407] = 400,
  [408] = 397,
  [409] = 398,
  [410] = 410,
  [411] = 410,
  [412] = 397,
  [413] = 398,
  [414] = 410,
  [415] = 405,
  [416] = 399,
  [417] = 403,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 419,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 418,
  [428] = 424,
  [429] = 422,
  [430] = 419,
  [431] = 418,
  [432] = 424,
  [433] = 422,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 438,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 442,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 446,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 454,
  [456] = 456,
  [457] = 454,
  [458] = 456,
  [459] = 459,
  [460] = 460,
  [461] = 459,
  [462] = 459,
  [463] = 454,
  [464] = 456,
  [465] = 465,
  [466] = 460,
  [467] = 460,
  [468] = 468,
  [469] = 468,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 446,
  [476] = 445,
  [477] = 474,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 452,
  [488] = 488,
  [489] = 484,
  [490] = 490,
  [491] = 483,
  [492] = 492,
  [493] = 493,
  [494] = 450,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 483,
  [499] = 484,
  [500] = 483,
  [501] = 501,
  [502] = 492,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 506,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 446,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 519,
  [529] = 529,
  [530] = 530,
  [531] = 525,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 542,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 542,
  [555] = 544,
  [556] = 556,
  [557] = 545,
  [558] = 558,
  [559] = 559,
  [560] = 542,
  [561] = 561,
  [562] = 556,
  [563] = 541,
  [564] = 545,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 566,
  [569] = 569,
  [570] = 556,
  [571] = 541,
  [572] = 572,
  [573] = 559,
  [574] = 558,
  [575] = 553,
  [576] = 559,
  [577] = 553,
  [578] = 578,
  [579] = 558,
  [580] = 545,
  [581] = 552,
  [582] = 582,
  [583] = 567,
  [584] = 559,
  [585] = 547,
  [586] = 567,
  [587] = 572,
  [588] = 569,
  [589] = 589,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(88);
      ADVANCE_MAP(
        '!', 172,
        '"', 218,
        '#', 99,
        '$', 96,
        '%', 178,
        '&', 181,
        '\'', 97,
        '(', 112,
        ')', 113,
        '*', 184,
        '+', 186,
        ',', 144,
        '-', 173,
        '.', 158,
        '/', 188,
        '0', 101,
        ':', 156,
        ';', 155,
        '<', 189,
        '=', 104,
        '>', 195,
        '?', 226,
        '@', 208,
        'E', 108,
        'N', 106,
        'O', 107,
        'U', 105,
        '[', 90,
        '\\', 103,
        ']', 91,
        '^', 201,
        '_', 109,
        '{', 92,
        '|', 202,
        '}', 93,
        '~', 217,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(102);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(110);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(111);
      if (lookahead != 0) ADVANCE(98);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 172,
        '$', 96,
        '%', 179,
        '&', 181,
        '(', 112,
        ')', 113,
        '*', 184,
        '+', 186,
        ',', 144,
        '-', 173,
        '.', 157,
        '/', 188,
        ':', 156,
        ';', 155,
        '<', 190,
        '=', 19,
        '>', 195,
        '?', 226,
        '@', 24,
        'E', 141,
        'O', 131,
        'U', 127,
        '[', 89,
        ']', 91,
        '^', 201,
        '_', 84,
        '|', 202,
        '}', 93,
        '~', 217,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 22,
        '"', 218,
        '#', 8,
        '$', 96,
        '%', 178,
        '&', 181,
        '(', 112,
        ')', 113,
        '*', 184,
        '+', 186,
        ',', 144,
        '-', 173,
        '.', 157,
        '/', 188,
        ':', 156,
        ';', 155,
        '<', 190,
        '=', 19,
        '>', 195,
        '?', 226,
        '@', 208,
        'E', 141,
        'O', 131,
        'U', 127,
        '[', 90,
        ']', 91,
        '^', 201,
        '_', 84,
        '|', 202,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 22,
        '"', 218,
        '#', 8,
        '$', 96,
        '%', 178,
        '&', 181,
        '(', 112,
        ')', 113,
        '*', 184,
        '+', 186,
        ',', 144,
        '-', 173,
        '.', 157,
        '/', 188,
        ':', 156,
        ';', 155,
        '<', 190,
        '=', 19,
        '>', 195,
        '?', 226,
        '@', 208,
        'E', 141,
        'O', 131,
        'U', 127,
        '[', 89,
        ']', 91,
        '^', 201,
        '_', 84,
        '|', 202,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 22,
        '"', 218,
        '#', 8,
        '$', 96,
        '%', 177,
        '&', 180,
        '(', 112,
        ')', 113,
        '*', 183,
        '+', 185,
        ',', 144,
        '-', 174,
        '.', 157,
        '/', 187,
        ':', 156,
        ';', 155,
        '<', 190,
        '=', 23,
        '>', 196,
        '?', 226,
        '@', 207,
        'E', 141,
        'O', 131,
        'U', 127,
        '[', 90,
        ']', 91,
        '^', 200,
        '_', 84,
        '|', 203,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 22,
        '"', 218,
        '#', 8,
        '$', 96,
        '%', 177,
        '&', 180,
        '(', 112,
        ')', 113,
        '*', 183,
        '+', 185,
        ',', 144,
        '-', 174,
        '.', 157,
        '/', 187,
        ':', 156,
        ';', 155,
        '<', 190,
        '=', 23,
        '>', 196,
        '?', 226,
        '@', 207,
        'E', 141,
        'O', 131,
        'U', 127,
        '[', 89,
        ']', 91,
        '^', 200,
        '_', 84,
        '|', 203,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 22,
        '$', 96,
        '%', 179,
        '&', 181,
        '(', 112,
        ')', 113,
        '*', 184,
        '+', 186,
        ',', 144,
        '-', 173,
        '/', 188,
        ':', 18,
        ';', 155,
        '<', 190,
        '=', 19,
        '>', 195,
        '?', 226,
        '@', 25,
        '[', 38,
        ']', 91,
        '^', 201,
        '_', 84,
        '|', 202,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 22,
        '$', 96,
        '%', 176,
        '&', 180,
        '(', 112,
        ')', 113,
        '*', 183,
        '+', 185,
        ',', 144,
        '-', 174,
        '.', 157,
        '/', 187,
        ':', 156,
        ';', 155,
        '<', 190,
        '=', 23,
        '>', 196,
        '?', 226,
        'E', 141,
        'O', 131,
        'U', 127,
        '[', 89,
        ']', 91,
        '^', 200,
        '_', 84,
        '|', 203,
        '~', 217,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 8:
      if (lookahead == '(') ADVANCE(143);
      END_STATE();
    case 9:
      if (lookahead == '(') ADVANCE(206);
      END_STATE();
    case 10:
      if (lookahead == '(') ADVANCE(215);
      if (lookahead == '=') ADVANCE(33);
      if (lookahead == 'd') ADVANCE(57);
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 11:
      if (lookahead == '(') ADVANCE(215);
      if (lookahead == 'c') ADVANCE(56);
      if (lookahead == 'd') ADVANCE(46);
      if (lookahead == 'i') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 13:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(13);
      if (lookahead != 0) ADVANCE(14);
      END_STATE();
    case 15:
      if (lookahead == '+') ADVANCE(160);
      END_STATE();
    case 16:
      if (lookahead == '/') ADVANCE(12);
      if (lookahead == 'E') ADVANCE(79);
      if (lookahead == 'O') ADVANCE(40);
      if (lookahead == 'U') ADVANCE(37);
      if (lookahead == '_') ADVANCE(85);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == '\\') ADVANCE(103);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (lookahead != 0) ADVANCE(98);
      END_STATE();
    case 18:
      if (lookahead == ':') ADVANCE(148);
      END_STATE();
    case 19:
      if (lookahead == '<') ADVANCE(121);
      if (lookahead == '=') ADVANCE(194);
      if (lookahead == '>') ADVANCE(122);
      if (lookahead == '^') ADVANCE(123);
      END_STATE();
    case 20:
      if (lookahead == '<') ADVANCE(145);
      END_STATE();
    case 21:
      if (lookahead == '<') ADVANCE(20);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(175);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(194);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(33);
      if (lookahead == 'c') ADVANCE(56);
      if (lookahead == 'd') ADVANCE(45);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(33);
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(114);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 28:
      if (lookahead == '>') ADVANCE(116);
      END_STATE();
    case 29:
      if (lookahead == '>') ADVANCE(117);
      END_STATE();
    case 30:
      if (lookahead == '>') ADVANCE(119);
      END_STATE();
    case 31:
      if (lookahead == '>') ADVANCE(120);
      END_STATE();
    case 32:
      if (lookahead == '>') ADVANCE(146);
      END_STATE();
    case 33:
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 34:
      if (lookahead == '>') ADVANCE(125);
      END_STATE();
    case 35:
      if (lookahead == '>') ADVANCE(126);
      END_STATE();
    case 36:
      if (lookahead == '>') ADVANCE(32);
      END_STATE();
    case 37:
      if (lookahead == 'G') ADVANCE(49);
      END_STATE();
    case 38:
      if (lookahead == ']') ADVANCE(227);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(75);
      END_STATE();
    case 40:
      if (lookahead == 'b') ADVANCE(51);
      END_STATE();
    case 41:
      if (lookahead == 'c') ADVANCE(147);
      END_STATE();
    case 42:
      if (lookahead == 'c') ADVANCE(70);
      END_STATE();
    case 43:
      if (lookahead == 'c') ADVANCE(71);
      END_STATE();
    case 44:
      if (lookahead == 'c') ADVANCE(73);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(62);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 51:
      if (lookahead == 'j') ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(213);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(72);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(68);
      END_STATE();
    case 56:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 58:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 59:
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 61:
      if (lookahead == 'p') ADVANCE(58);
      END_STATE();
    case 62:
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 63:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(205);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(69);
      END_STATE();
    case 66:
      if (lookahead == 'r') ADVANCE(78);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 68:
      if (lookahead == 's') ADVANCE(76);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 70:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 72:
      if (lookahead == 't') ADVANCE(209);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 75:
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 76:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 77:
      if (lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 78:
      if (lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 79:
      if (lookahead == 'v') ADVANCE(48);
      END_STATE();
    case 80:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(149);
      END_STATE();
    case 81:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(80);
      END_STATE();
    case 82:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 83:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(159);
      END_STATE();
    case 84:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 85:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 86:
      if (eof) ADVANCE(88);
      ADVANCE_MAP(
        '!', 172,
        '"', 218,
        '#', 8,
        '$', 96,
        '%', 178,
        '&', 181,
        '\'', 97,
        '(', 112,
        ')', 113,
        '*', 184,
        '+', 186,
        ',', 144,
        '-', 173,
        '.', 82,
        '/', 188,
        '0', 164,
        ':', 18,
        ';', 155,
        '<', 189,
        '=', 19,
        '>', 195,
        '?', 226,
        '@', 10,
        'E', 141,
        'N', 130,
        'O', 131,
        'U', 127,
        '[', 89,
        ']', 91,
        '^', 201,
        '_', 84,
        '{', 92,
        '|', 202,
        '}', 93,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(86);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(165);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 87:
      if (eof) ADVANCE(88);
      ADVANCE_MAP(
        '!', 171,
        '"', 218,
        '#', 8,
        '%', 9,
        '\'', 97,
        '(', 112,
        ')', 113,
        '+', 15,
        ',', 144,
        '-', 174,
        '.', 82,
        '/', 12,
        '0', 164,
        ';', 155,
        '<', 21,
        '>', 36,
        '@', 11,
        'E', 141,
        'N', 130,
        'O', 131,
        'U', 127,
        '[', 89,
        ']', 91,
        '_', 84,
        '{', 92,
        '}', 93,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(87);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(165);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(227);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_block_comment);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_block_comment);
      if (lookahead == '\\') ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(224);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_character_token1);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '(') ADVANCE(143);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(165);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '.') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(165);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '0') ADVANCE(150);
      if (lookahead == '1') ADVANCE(81);
      if (lookahead == '"' ||
          lookahead == 'a' ||
          lookahead == 'n' ||
          lookahead == 't') ADVANCE(149);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == '<') ADVANCE(121);
      if (lookahead == '=') ADVANCE(194);
      if (lookahead == '>') ADVANCE(122);
      if (lookahead == '^') ADVANCE(123);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == 'G') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == 'U') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == 'b') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (lookahead == 'v') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_character_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ_GT);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_AMP_EQ_GT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_STAR_EQ_GT);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ_GT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_GT);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DASH_EQ_GT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ_GT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_EQ_CARET);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_AT_EQ_GT);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_CARET_EQ_GT);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ_GT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'G') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'L') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'L') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'U') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'b') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'c') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'e') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'e') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'e') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'j') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'n') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'n') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 't') ADVANCE(210);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 't') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_class_identifier);
      if (lookahead == 'v') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_class_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_POUND_LPAREN);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_ATdoc);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_escape_character);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_escape_character);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(80);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(148);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(153);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_hexidecimal);
      if (lookahead == '_') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(159);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '>') ADVANCE(118);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_ATimport);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_int);
      if (lookahead == '.') ADVANCE(154);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(165);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_int);
      if (lookahead == '.') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '"') ADVANCE(168);
      if (lookahead == '\\') ADVANCE(167);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(224);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\\') ADVANCE(167);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(224);
      if (lookahead != 0) ADVANCE(166);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_ATconstruct);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_ATdestruct);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(175);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(162);
      if (lookahead == '=') ADVANCE(30);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(161);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '(') ADVANCE(206);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '(') ADVANCE(206);
      if (lookahead == '=') ADVANCE(26);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(26);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(182);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(182);
      if (lookahead == '=') ADVANCE(27);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(28);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(160);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(160);
      if (lookahead == '=') ADVANCE(29);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(168);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(14);
      if (lookahead == '/') ADVANCE(168);
      if (lookahead == '=') ADVANCE(31);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(192);
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(191);
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '<') ADVANCE(145);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(197);
      if (lookahead == '>') ADVANCE(199);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(197);
      if (lookahead == '>') ADVANCE(198);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(146);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(34);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(35);
      if (lookahead == '|') ADVANCE(204);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(204);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_AToperator);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_PERCENT_LPAREN);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(33);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_Event);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_Event);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_Object);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_Object);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_UGen);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_UGen);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_AT_LPAREN);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_NULL);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(142);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '"') ADVANCE(14);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '\\') ADVANCE(222);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '"') ADVANCE(14);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(222);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(220);
      if (lookahead == '/') ADVANCE(166);
      if (lookahead == '\\') ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(224);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(219);
      if (lookahead == '\\') ADVANCE(222);
      if (lookahead != 0) ADVANCE(220);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(225);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(223);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(224);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\\') ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(224);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\\') ADVANCE(225);
      if (lookahead != 0) ADVANCE(224);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_variable_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(228);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'h', 8,
        'i', 9,
        'm', 10,
        'n', 11,
        'p', 12,
        'r', 13,
        's', 14,
        't', 15,
        'u', 16,
        'v', 17,
        'w', 18,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'd') ADVANCE(19);
      if (lookahead == 'r') ADVANCE(20);
      if (lookahead == 'u') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(22);
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      if (lookahead == 'u') ADVANCE(28);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'x') ADVANCE(30);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(31);
      if (lookahead == 'l') ADVANCE(32);
      if (lookahead == 'o') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'l') ADVANCE(35);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(37);
      if (lookahead == 'm') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'i') ADVANCE(42);
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'o') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 12:
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'o') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'e') ADVANCE(53);
      if (lookahead == 'p') ADVANCE(54);
      if (lookahead == 't') ADVANCE(55);
      if (lookahead == 'u') ADVANCE(56);
      if (lookahead == 'w') ADVANCE(57);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(58);
      if (lookahead == 'i') ADVANCE(59);
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(62);
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == 'h') ADVANCE(65);
      END_STATE();
    case 19:
      if (lookahead == 'c') ADVANCE(66);
      END_STATE();
    case 20:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 21:
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(71);
      END_STATE();
    case 25:
      if (lookahead == 'm') ADVANCE(72);
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(74);
      if (lookahead == 'y') ADVANCE(75);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 28:
      if (lookahead == 'r') ADVANCE(76);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 30:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 31:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 38:
      if (lookahead == 'p') ADVANCE(85);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 40:
      if (lookahead == 'y') ADVANCE(87);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_me);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_ms);
      END_STATE();
    case 44:
      if (lookahead == 'w') ADVANCE(89);
      END_STATE();
    case 45:
      if (lookahead == 'w') ADVANCE(90);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_pi);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(92);
      END_STATE();
    case 49:
      if (lookahead == 'i') ADVANCE(93);
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 50:
      if (lookahead == 'b') ADVANCE(95);
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 51:
      if (lookahead == 'p') ADVANCE(97);
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 52:
      if (lookahead == 'm') ADVANCE(99);
      END_STATE();
    case 53:
      if (lookahead == 'c') ADVANCE(100);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(101);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 56:
      if (lookahead == 'p') ADVANCE(104);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(106);
      END_STATE();
    case 59:
      if (lookahead == 'm') ADVANCE(107);
      END_STATE();
    case 60:
      if (lookahead == 'u') ADVANCE(108);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 62:
      if (lookahead == 'c') ADVANCE(110);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(113);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_adc);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(114);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 69:
      if (lookahead == 'c') ADVANCE(116);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(117);
      END_STATE();
    case 71:
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 72:
      if (lookahead == 'p') ADVANCE(119);
      END_STATE();
    case 73:
      if (lookahead == 's') ADVANCE(120);
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_dac);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_day);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_dur);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 79:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_fun);
      if (lookahead == 'c') ADVANCE(126);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(127);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 85:
      if (lookahead == 'l') ADVANCE(129);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 87:
      if (lookahead == 'b') ADVANCE(131);
      END_STATE();
    case 88:
      if (lookahead == 'u') ADVANCE(132);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_now);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(133);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(134);
      END_STATE();
    case 93:
      if (lookahead == 'v') ADVANCE(135);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(137);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 98:
      if (lookahead == 'u') ADVANCE(140);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(141);
      if (lookahead == 'p') ADVANCE(142);
      END_STATE();
    case 100:
      if (lookahead == 'o') ADVANCE(143);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(149);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 110:
      if (lookahead == '2') ADVANCE(153);
      if (lookahead == '3') ADVANCE(154);
      if (lookahead == '4') ADVANCE(155);
      END_STATE();
    case 111:
      if (lookahead == 'd') ADVANCE(156);
      END_STATE();
    case 112:
      if (lookahead == 'k') ADVANCE(157);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(158);
      END_STATE();
    case 114:
      if (lookahead == 'y') ADVANCE(159);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_auto);
      END_STATE();
    case 116:
      if (lookahead == 'k') ADVANCE(160);
      END_STATE();
    case 117:
      if (lookahead == 'k') ADVANCE(161);
      END_STATE();
    case 118:
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 119:
      if (lookahead == 'l') ADVANCE(163);
      END_STATE();
    case 120:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(165);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 123:
      if (lookahead == 'n') ADVANCE(166);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(170);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_hour);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 130:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 132:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 134:
      if (lookahead == 'r') ADVANCE(175);
      END_STATE();
    case 135:
      if (lookahead == 'a') ADVANCE(176);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 137:
      if (lookahead == 'i') ADVANCE(178);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 139:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 140:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_same);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_samp);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 144:
      if (lookahead == 'k') ADVANCE(182);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(183);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(184);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 148:
      if (lookahead == 'c') ADVANCE(186);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_this);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_time);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 152:
      if (lookahead == 'l') ADVANCE(187);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_vec2);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_vec3);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_vec4);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_week);
      END_STATE();
    case 158:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_array);
      END_STATE();
    case 160:
      if (lookahead == 'h') ADVANCE(189);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 165:
      if (lookahead == 'n') ADVANCE(191);
      END_STATE();
    case 166:
      if (lookahead == 'd') ADVANCE(192);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 169:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(194);
      END_STATE();
    case 171:
      if (lookahead == 'm') ADVANCE(195);
      END_STATE();
    case 172:
      if (lookahead == 'f') ADVANCE(196);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_maybe);
      END_STATE();
    case 174:
      if (lookahead == 'e') ADVANCE(197);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_polar);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(198);
      END_STATE();
    case 177:
      if (lookahead == 'c') ADVANCE(199);
      END_STATE();
    case 178:
      if (lookahead == 'c') ADVANCE(200);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 180:
      if (lookahead == 'n') ADVANCE(202);
      END_STATE();
    case 181:
      if (lookahead == 'd') ADVANCE(203);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_spork);
      END_STATE();
    case 183:
      if (lookahead == 'c') ADVANCE(204);
      END_STATE();
    case 184:
      if (lookahead == 'g') ADVANCE(205);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_super);
      END_STATE();
    case 186:
      if (lookahead == 'h') ADVANCE(206);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_until);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 189:
      if (lookahead == 'o') ADVANCE(207);
      END_STATE();
    case 190:
      if (lookahead == 'x') ADVANCE(208);
      END_STATE();
    case 191:
      if (lookahead == 'u') ADVANCE(209);
      END_STATE();
    case 192:
      if (lookahead == 's') ADVANCE(210);
      END_STATE();
    case 193:
      if (lookahead == 'o') ADVANCE(211);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(212);
      END_STATE();
    case 196:
      if (lookahead == 'a') ADVANCE(213);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_minute);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(214);
      END_STATE();
    case 199:
      if (lookahead == 't') ADVANCE(215);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_repeat);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_second);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 207:
      if (lookahead == 'l') ADVANCE(216);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_complex);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 212:
      if (lookahead == 'n') ADVANCE(219);
      END_STATE();
    case 213:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(221);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(223);
      END_STATE();
    case 220:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 221:
      if (lookahead == 'd') ADVANCE(225);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_blackhole);
      END_STATE();
    case 223:
      if (lookahead == 's') ADVANCE(226);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_protected);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_implements);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 87},
  [2] = {.lex_state = 87},
  [3] = {.lex_state = 87},
  [4] = {.lex_state = 87},
  [5] = {.lex_state = 87},
  [6] = {.lex_state = 87},
  [7] = {.lex_state = 87},
  [8] = {.lex_state = 87},
  [9] = {.lex_state = 87},
  [10] = {.lex_state = 87},
  [11] = {.lex_state = 87},
  [12] = {.lex_state = 87},
  [13] = {.lex_state = 87},
  [14] = {.lex_state = 87},
  [15] = {.lex_state = 87},
  [16] = {.lex_state = 87},
  [17] = {.lex_state = 87},
  [18] = {.lex_state = 87},
  [19] = {.lex_state = 87},
  [20] = {.lex_state = 87},
  [21] = {.lex_state = 87},
  [22] = {.lex_state = 87},
  [23] = {.lex_state = 87},
  [24] = {.lex_state = 87},
  [25] = {.lex_state = 87},
  [26] = {.lex_state = 87},
  [27] = {.lex_state = 87},
  [28] = {.lex_state = 87},
  [29] = {.lex_state = 87},
  [30] = {.lex_state = 87},
  [31] = {.lex_state = 87},
  [32] = {.lex_state = 87},
  [33] = {.lex_state = 87},
  [34] = {.lex_state = 87},
  [35] = {.lex_state = 87},
  [36] = {.lex_state = 87},
  [37] = {.lex_state = 87},
  [38] = {.lex_state = 87},
  [39] = {.lex_state = 87},
  [40] = {.lex_state = 87},
  [41] = {.lex_state = 87},
  [42] = {.lex_state = 87},
  [43] = {.lex_state = 87},
  [44] = {.lex_state = 87},
  [45] = {.lex_state = 87},
  [46] = {.lex_state = 87},
  [47] = {.lex_state = 87},
  [48] = {.lex_state = 87},
  [49] = {.lex_state = 87},
  [50] = {.lex_state = 87},
  [51] = {.lex_state = 87},
  [52] = {.lex_state = 87},
  [53] = {.lex_state = 87},
  [54] = {.lex_state = 87},
  [55] = {.lex_state = 87},
  [56] = {.lex_state = 87},
  [57] = {.lex_state = 87},
  [58] = {.lex_state = 87},
  [59] = {.lex_state = 87},
  [60] = {.lex_state = 87},
  [61] = {.lex_state = 87},
  [62] = {.lex_state = 87},
  [63] = {.lex_state = 87},
  [64] = {.lex_state = 87},
  [65] = {.lex_state = 87},
  [66] = {.lex_state = 87},
  [67] = {.lex_state = 87},
  [68] = {.lex_state = 87},
  [69] = {.lex_state = 87},
  [70] = {.lex_state = 87},
  [71] = {.lex_state = 87},
  [72] = {.lex_state = 87},
  [73] = {.lex_state = 87},
  [74] = {.lex_state = 87},
  [75] = {.lex_state = 87},
  [76] = {.lex_state = 87},
  [77] = {.lex_state = 87},
  [78] = {.lex_state = 87},
  [79] = {.lex_state = 87},
  [80] = {.lex_state = 87},
  [81] = {.lex_state = 87},
  [82] = {.lex_state = 87},
  [83] = {.lex_state = 87},
  [84] = {.lex_state = 87},
  [85] = {.lex_state = 87},
  [86] = {.lex_state = 87},
  [87] = {.lex_state = 87},
  [88] = {.lex_state = 87},
  [89] = {.lex_state = 87},
  [90] = {.lex_state = 87},
  [91] = {.lex_state = 87},
  [92] = {.lex_state = 87},
  [93] = {.lex_state = 87},
  [94] = {.lex_state = 87},
  [95] = {.lex_state = 87},
  [96] = {.lex_state = 87},
  [97] = {.lex_state = 87},
  [98] = {.lex_state = 87},
  [99] = {.lex_state = 87},
  [100] = {.lex_state = 87},
  [101] = {.lex_state = 87},
  [102] = {.lex_state = 87},
  [103] = {.lex_state = 87},
  [104] = {.lex_state = 87},
  [105] = {.lex_state = 87},
  [106] = {.lex_state = 86},
  [107] = {.lex_state = 86},
  [108] = {.lex_state = 86},
  [109] = {.lex_state = 86},
  [110] = {.lex_state = 86},
  [111] = {.lex_state = 86},
  [112] = {.lex_state = 86},
  [113] = {.lex_state = 86},
  [114] = {.lex_state = 86},
  [115] = {.lex_state = 86},
  [116] = {.lex_state = 86},
  [117] = {.lex_state = 86},
  [118] = {.lex_state = 86},
  [119] = {.lex_state = 86},
  [120] = {.lex_state = 86},
  [121] = {.lex_state = 86},
  [122] = {.lex_state = 87},
  [123] = {.lex_state = 87},
  [124] = {.lex_state = 87},
  [125] = {.lex_state = 87},
  [126] = {.lex_state = 87},
  [127] = {.lex_state = 87},
  [128] = {.lex_state = 87},
  [129] = {.lex_state = 87},
  [130] = {.lex_state = 87},
  [131] = {.lex_state = 87},
  [132] = {.lex_state = 87},
  [133] = {.lex_state = 87},
  [134] = {.lex_state = 87},
  [135] = {.lex_state = 87},
  [136] = {.lex_state = 87},
  [137] = {.lex_state = 87},
  [138] = {.lex_state = 87},
  [139] = {.lex_state = 87},
  [140] = {.lex_state = 87},
  [141] = {.lex_state = 87},
  [142] = {.lex_state = 87},
  [143] = {.lex_state = 87},
  [144] = {.lex_state = 87},
  [145] = {.lex_state = 87},
  [146] = {.lex_state = 87},
  [147] = {.lex_state = 87},
  [148] = {.lex_state = 87},
  [149] = {.lex_state = 87},
  [150] = {.lex_state = 87},
  [151] = {.lex_state = 87},
  [152] = {.lex_state = 87},
  [153] = {.lex_state = 87},
  [154] = {.lex_state = 87},
  [155] = {.lex_state = 87},
  [156] = {.lex_state = 87},
  [157] = {.lex_state = 87},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 2},
  [160] = {.lex_state = 2},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 2},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 2},
  [168] = {.lex_state = 2},
  [169] = {.lex_state = 87},
  [170] = {.lex_state = 7},
  [171] = {.lex_state = 4},
  [172] = {.lex_state = 7},
  [173] = {.lex_state = 4},
  [174] = {.lex_state = 5},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 4},
  [185] = {.lex_state = 4},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 6},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 2},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 7},
  [293] = {.lex_state = 7},
  [294] = {.lex_state = 7},
  [295] = {.lex_state = 7},
  [296] = {.lex_state = 7},
  [297] = {.lex_state = 7},
  [298] = {.lex_state = 7},
  [299] = {.lex_state = 7},
  [300] = {.lex_state = 7},
  [301] = {.lex_state = 7},
  [302] = {.lex_state = 7},
  [303] = {.lex_state = 7},
  [304] = {.lex_state = 7},
  [305] = {.lex_state = 7},
  [306] = {.lex_state = 7},
  [307] = {.lex_state = 7},
  [308] = {.lex_state = 7},
  [309] = {.lex_state = 7},
  [310] = {.lex_state = 7},
  [311] = {.lex_state = 7},
  [312] = {.lex_state = 7},
  [313] = {.lex_state = 7},
  [314] = {.lex_state = 7},
  [315] = {.lex_state = 7},
  [316] = {.lex_state = 7},
  [317] = {.lex_state = 7},
  [318] = {.lex_state = 7},
  [319] = {.lex_state = 7},
  [320] = {.lex_state = 7},
  [321] = {.lex_state = 7},
  [322] = {.lex_state = 7},
  [323] = {.lex_state = 7},
  [324] = {.lex_state = 7},
  [325] = {.lex_state = 7},
  [326] = {.lex_state = 7},
  [327] = {.lex_state = 7},
  [328] = {.lex_state = 7},
  [329] = {.lex_state = 7},
  [330] = {.lex_state = 7},
  [331] = {.lex_state = 7},
  [332] = {.lex_state = 7},
  [333] = {.lex_state = 7},
  [334] = {.lex_state = 7},
  [335] = {.lex_state = 7},
  [336] = {.lex_state = 7},
  [337] = {.lex_state = 7},
  [338] = {.lex_state = 7},
  [339] = {.lex_state = 7},
  [340] = {.lex_state = 7},
  [341] = {.lex_state = 7},
  [342] = {.lex_state = 7},
  [343] = {.lex_state = 7},
  [344] = {.lex_state = 7},
  [345] = {.lex_state = 7},
  [346] = {.lex_state = 7},
  [347] = {.lex_state = 7},
  [348] = {.lex_state = 7},
  [349] = {.lex_state = 7},
  [350] = {.lex_state = 7},
  [351] = {.lex_state = 7},
  [352] = {.lex_state = 7},
  [353] = {.lex_state = 7},
  [354] = {.lex_state = 1},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 7},
  [357] = {.lex_state = 7},
  [358] = {.lex_state = 7},
  [359] = {.lex_state = 2},
  [360] = {.lex_state = 7},
  [361] = {.lex_state = 7},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 2},
  [364] = {.lex_state = 7},
  [365] = {.lex_state = 7},
  [366] = {.lex_state = 7},
  [367] = {.lex_state = 7},
  [368] = {.lex_state = 7},
  [369] = {.lex_state = 7},
  [370] = {.lex_state = 7},
  [371] = {.lex_state = 7},
  [372] = {.lex_state = 7},
  [373] = {.lex_state = 7},
  [374] = {.lex_state = 7},
  [375] = {.lex_state = 7},
  [376] = {.lex_state = 7},
  [377] = {.lex_state = 7},
  [378] = {.lex_state = 2},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 7},
  [382] = {.lex_state = 2},
  [383] = {.lex_state = 2},
  [384] = {.lex_state = 2},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 2},
  [387] = {.lex_state = 2},
  [388] = {.lex_state = 2},
  [389] = {.lex_state = 2},
  [390] = {.lex_state = 2},
  [391] = {.lex_state = 2},
  [392] = {.lex_state = 2},
  [393] = {.lex_state = 2},
  [394] = {.lex_state = 2},
  [395] = {.lex_state = 1},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 7},
  [398] = {.lex_state = 7},
  [399] = {.lex_state = 7},
  [400] = {.lex_state = 7},
  [401] = {.lex_state = 7},
  [402] = {.lex_state = 7},
  [403] = {.lex_state = 7},
  [404] = {.lex_state = 7},
  [405] = {.lex_state = 7},
  [406] = {.lex_state = 7},
  [407] = {.lex_state = 7},
  [408] = {.lex_state = 7},
  [409] = {.lex_state = 7},
  [410] = {.lex_state = 7},
  [411] = {.lex_state = 7},
  [412] = {.lex_state = 7},
  [413] = {.lex_state = 7},
  [414] = {.lex_state = 7},
  [415] = {.lex_state = 7},
  [416] = {.lex_state = 7},
  [417] = {.lex_state = 7},
  [418] = {.lex_state = 7},
  [419] = {.lex_state = 7},
  [420] = {.lex_state = 7},
  [421] = {.lex_state = 1},
  [422] = {.lex_state = 7},
  [423] = {.lex_state = 7},
  [424] = {.lex_state = 7},
  [425] = {.lex_state = 1},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 7},
  [428] = {.lex_state = 7},
  [429] = {.lex_state = 7},
  [430] = {.lex_state = 7},
  [431] = {.lex_state = 7},
  [432] = {.lex_state = 7},
  [433] = {.lex_state = 7},
  [434] = {.lex_state = 1},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 1},
  [438] = {.lex_state = 1},
  [439] = {.lex_state = 86},
  [440] = {.lex_state = 1},
  [441] = {.lex_state = 86},
  [442] = {.lex_state = 16},
  [443] = {.lex_state = 86},
  [444] = {.lex_state = 16},
  [445] = {.lex_state = 2},
  [446] = {.lex_state = 2},
  [447] = {.lex_state = 86},
  [448] = {.lex_state = 2},
  [449] = {.lex_state = 86},
  [450] = {.lex_state = 2},
  [451] = {.lex_state = 86},
  [452] = {.lex_state = 2},
  [453] = {.lex_state = 86},
  [454] = {.lex_state = 86},
  [455] = {.lex_state = 86},
  [456] = {.lex_state = 86},
  [457] = {.lex_state = 86},
  [458] = {.lex_state = 86},
  [459] = {.lex_state = 86},
  [460] = {.lex_state = 86},
  [461] = {.lex_state = 86},
  [462] = {.lex_state = 86},
  [463] = {.lex_state = 86},
  [464] = {.lex_state = 86},
  [465] = {.lex_state = 86},
  [466] = {.lex_state = 86},
  [467] = {.lex_state = 86},
  [468] = {.lex_state = 6},
  [469] = {.lex_state = 6},
  [470] = {.lex_state = 6},
  [471] = {.lex_state = 87},
  [472] = {.lex_state = 87},
  [473] = {.lex_state = 6},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 6},
  [476] = {.lex_state = 6},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 87},
  [479] = {.lex_state = 87},
  [480] = {.lex_state = 87},
  [481] = {.lex_state = 87},
  [482] = {.lex_state = 87},
  [483] = {.lex_state = 87},
  [484] = {.lex_state = 87},
  [485] = {.lex_state = 87},
  [486] = {.lex_state = 87},
  [487] = {.lex_state = 6},
  [488] = {.lex_state = 87},
  [489] = {.lex_state = 87},
  [490] = {.lex_state = 87},
  [491] = {.lex_state = 87},
  [492] = {.lex_state = 1},
  [493] = {.lex_state = 87},
  [494] = {.lex_state = 6},
  [495] = {.lex_state = 87},
  [496] = {.lex_state = 87},
  [497] = {.lex_state = 87},
  [498] = {.lex_state = 87},
  [499] = {.lex_state = 87},
  [500] = {.lex_state = 87},
  [501] = {.lex_state = 87},
  [502] = {.lex_state = 1},
  [503] = {.lex_state = 6},
  [504] = {.lex_state = 87},
  [505] = {.lex_state = 6},
  [506] = {.lex_state = 87},
  [507] = {.lex_state = 87},
  [508] = {.lex_state = 87},
  [509] = {.lex_state = 6},
  [510] = {.lex_state = 87},
  [511] = {.lex_state = 87},
  [512] = {.lex_state = 87},
  [513] = {.lex_state = 87},
  [514] = {.lex_state = 87},
  [515] = {.lex_state = 87},
  [516] = {.lex_state = 87},
  [517] = {.lex_state = 6},
  [518] = {.lex_state = 87},
  [519] = {.lex_state = 17},
  [520] = {.lex_state = 87},
  [521] = {.lex_state = 87},
  [522] = {.lex_state = 87},
  [523] = {.lex_state = 87},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 6},
  [526] = {.lex_state = 87},
  [527] = {.lex_state = 6},
  [528] = {.lex_state = 17},
  [529] = {.lex_state = 87},
  [530] = {.lex_state = 87},
  [531] = {.lex_state = 6},
  [532] = {.lex_state = 6},
  [533] = {.lex_state = 87},
  [534] = {.lex_state = 87},
  [535] = {.lex_state = 87},
  [536] = {.lex_state = 87},
  [537] = {.lex_state = 87},
  [538] = {.lex_state = 87},
  [539] = {.lex_state = 87},
  [540] = {.lex_state = 87},
  [541] = {.lex_state = 87},
  [542] = {.lex_state = 87},
  [543] = {.lex_state = 87},
  [544] = {.lex_state = 87},
  [545] = {.lex_state = 87},
  [546] = {.lex_state = 87},
  [547] = {.lex_state = 87},
  [548] = {.lex_state = 6},
  [549] = {.lex_state = 87},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 87},
  [552] = {.lex_state = 87},
  [553] = {.lex_state = 223},
  [554] = {.lex_state = 87},
  [555] = {.lex_state = 87},
  [556] = {.lex_state = 87},
  [557] = {.lex_state = 87},
  [558] = {.lex_state = 87},
  [559] = {.lex_state = 87},
  [560] = {.lex_state = 87},
  [561] = {.lex_state = 87},
  [562] = {.lex_state = 87},
  [563] = {.lex_state = 87},
  [564] = {.lex_state = 87},
  [565] = {.lex_state = 87},
  [566] = {.lex_state = 87},
  [567] = {.lex_state = 87},
  [568] = {.lex_state = 87},
  [569] = {.lex_state = 87},
  [570] = {.lex_state = 87},
  [571] = {.lex_state = 87},
  [572] = {.lex_state = 87},
  [573] = {.lex_state = 87},
  [574] = {.lex_state = 87},
  [575] = {.lex_state = 223},
  [576] = {.lex_state = 87},
  [577] = {.lex_state = 223},
  [578] = {.lex_state = 87},
  [579] = {.lex_state = 87},
  [580] = {.lex_state = 87},
  [581] = {.lex_state = 87},
  [582] = {.lex_state = 6},
  [583] = {.lex_state = 87},
  [584] = {.lex_state = 87},
  [585] = {.lex_state = 87},
  [586] = {.lex_state = 87},
  [587] = {.lex_state = 87},
  [588] = {.lex_state = 87},
  [589] = {.lex_state = 6},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_variable_identifier] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [aux_sym_character_token1] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_spork] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(1),
    [anon_sym_AMP_EQ_GT] = ACTIONS(1),
    [anon_sym_STAR_EQ_GT] = ACTIONS(1),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(1),
    [anon_sym_DASH_DASH_GT] = ACTIONS(1),
    [anon_sym_DASH_EQ_GT] = ACTIONS(1),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_EQ_CARET] = ACTIONS(1),
    [anon_sym_AT_EQ_GT] = ACTIONS(1),
    [anon_sym_CARET_EQ_GT] = ACTIONS(1),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [sym_class_identifier] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_implements] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_protected] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_super] = ACTIONS(1),
    [anon_sym_this] = ACTIONS(1),
    [anon_sym_POUND_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_day] = ACTIONS(1),
    [anon_sym_hour] = ACTIONS(1),
    [anon_sym_minute] = ACTIONS(1),
    [anon_sym_ms] = ACTIONS(1),
    [anon_sym_samp] = ACTIONS(1),
    [anon_sym_second] = ACTIONS(1),
    [anon_sym_week] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [sym_escape_character] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_adc] = ACTIONS(1),
    [anon_sym_blackhole] = ACTIONS(1),
    [anon_sym_dac] = ACTIONS(1),
    [sym_hexidecimal] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym_int] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(1),
    [anon_sym_me] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(1),
    [anon_sym_auto] = ACTIONS(1),
    [anon_sym_complex] = ACTIONS(1),
    [anon_sym_dur] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_polar] = ACTIONS(1),
    [anon_sym_same] = ACTIONS(1),
    [anon_sym_time] = ACTIONS(1),
    [anon_sym_vec2] = ACTIONS(1),
    [anon_sym_vec3] = ACTIONS(1),
    [anon_sym_vec4] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_Event] = ACTIONS(1),
    [anon_sym_Object] = ACTIONS(1),
    [anon_sym_UGen] = ACTIONS(1),
    [anon_sym_array] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_maybe] = ACTIONS(1),
    [anon_sym_now] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_pi] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_until] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(550),
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(3),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(3),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(120),
    [sym__control_structure] = STATE(120),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(42),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(120),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(120),
    [sym_for_each_loop] = STATE(120),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(139),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_import_expression] = STATE(3),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(120),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(139),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(3),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_ATimport] = ACTIONS(65),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [2] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(2),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(2),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(120),
    [sym__control_structure] = STATE(120),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(42),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(120),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(120),
    [sym_for_each_loop] = STATE(120),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(139),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_import_expression] = STATE(2),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(120),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(139),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(2),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(93),
    [sym_variable_identifier] = ACTIONS(95),
    [anon_sym_LBRACK] = ACTIONS(98),
    [anon_sym_LBRACE] = ACTIONS(101),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(104),
    [anon_sym_true] = ACTIONS(104),
    [anon_sym_SQUOTE] = ACTIONS(107),
    [anon_sym_const] = ACTIONS(110),
    [anon_sym_function] = ACTIONS(113),
    [anon_sym_global] = ACTIONS(116),
    [anon_sym_spork] = ACTIONS(119),
    [anon_sym_LPAREN] = ACTIONS(122),
    [anon_sym_public] = ACTIONS(125),
    [anon_sym_class] = ACTIONS(128),
    [anon_sym_extends] = ACTIONS(110),
    [sym_class_identifier] = ACTIONS(131),
    [anon_sym_new] = ACTIONS(134),
    [anon_sym_implements] = ACTIONS(110),
    [anon_sym_interface] = ACTIONS(110),
    [anon_sym_private] = ACTIONS(137),
    [anon_sym_protected] = ACTIONS(110),
    [anon_sym_pure] = ACTIONS(110),
    [anon_sym_static] = ACTIONS(140),
    [anon_sym_super] = ACTIONS(110),
    [anon_sym_this] = ACTIONS(143),
    [anon_sym_POUND_LPAREN] = ACTIONS(146),
    [anon_sym_if] = ACTIONS(149),
    [anon_sym_break] = ACTIONS(152),
    [anon_sym_continue] = ACTIONS(152),
    [anon_sym_switch] = ACTIONS(152),
    [anon_sym_LT_LT_LT] = ACTIONS(155),
    [anon_sym_ATdoc] = ACTIONS(158),
    [anon_sym_do] = ACTIONS(161),
    [anon_sym_day] = ACTIONS(164),
    [anon_sym_hour] = ACTIONS(164),
    [anon_sym_minute] = ACTIONS(164),
    [anon_sym_ms] = ACTIONS(164),
    [anon_sym_samp] = ACTIONS(164),
    [anon_sym_second] = ACTIONS(164),
    [anon_sym_week] = ACTIONS(164),
    [sym_float] = ACTIONS(167),
    [anon_sym_for] = ACTIONS(170),
    [anon_sym_fun] = ACTIONS(173),
    [anon_sym_adc] = ACTIONS(176),
    [anon_sym_blackhole] = ACTIONS(176),
    [anon_sym_dac] = ACTIONS(176),
    [sym_hexidecimal] = ACTIONS(167),
    [anon_sym_PLUS_PLUS] = ACTIONS(179),
    [anon_sym_DASH_DASH] = ACTIONS(179),
    [anon_sym_ATimport] = ACTIONS(182),
    [sym_int] = ACTIONS(185),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(188),
    [anon_sym_me] = ACTIONS(191),
    [anon_sym_BANG] = ACTIONS(194),
    [anon_sym_DASH] = ACTIONS(197),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(200),
    [anon_sym_auto] = ACTIONS(203),
    [anon_sym_complex] = ACTIONS(203),
    [anon_sym_dur] = ACTIONS(203),
    [anon_sym_float] = ACTIONS(203),
    [anon_sym_int] = ACTIONS(203),
    [anon_sym_polar] = ACTIONS(203),
    [anon_sym_same] = ACTIONS(203),
    [anon_sym_time] = ACTIONS(203),
    [anon_sym_vec2] = ACTIONS(203),
    [anon_sym_vec3] = ACTIONS(203),
    [anon_sym_vec4] = ACTIONS(203),
    [anon_sym_void] = ACTIONS(203),
    [anon_sym_Event] = ACTIONS(206),
    [anon_sym_Object] = ACTIONS(206),
    [anon_sym_UGen] = ACTIONS(206),
    [anon_sym_array] = ACTIONS(206),
    [anon_sym_string] = ACTIONS(206),
    [anon_sym_AT_LPAREN] = ACTIONS(209),
    [anon_sym_NULL] = ACTIONS(212),
    [anon_sym_maybe] = ACTIONS(212),
    [anon_sym_now] = ACTIONS(212),
    [anon_sym_null] = ACTIONS(212),
    [anon_sym_pi] = ACTIONS(212),
    [anon_sym_return] = ACTIONS(215),
    [anon_sym_DQUOTE] = ACTIONS(218),
    [anon_sym_until] = ACTIONS(221),
    [anon_sym_while] = ACTIONS(221),
  },
  [3] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(2),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(2),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(120),
    [sym__control_structure] = STATE(120),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(42),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(120),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(120),
    [sym_for_each_loop] = STATE(120),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(139),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_import_expression] = STATE(2),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(120),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(139),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(2),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(224),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(27),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [anon_sym_ATimport] = ACTIONS(65),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [4] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(6),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(6),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(6),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(6),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(228),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [5] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(6),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(6),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(6),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(6),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(236),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [6] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(6),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(6),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(6),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(6),
    [sym_variable_identifier] = ACTIONS(238),
    [anon_sym_LBRACK] = ACTIONS(241),
    [anon_sym_RBRACE] = ACTIONS(244),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(246),
    [anon_sym_true] = ACTIONS(246),
    [anon_sym_SQUOTE] = ACTIONS(249),
    [anon_sym_const] = ACTIONS(252),
    [anon_sym_function] = ACTIONS(255),
    [anon_sym_global] = ACTIONS(258),
    [anon_sym_spork] = ACTIONS(261),
    [anon_sym_LPAREN] = ACTIONS(264),
    [anon_sym_public] = ACTIONS(267),
    [anon_sym_class] = ACTIONS(270),
    [anon_sym_extends] = ACTIONS(252),
    [sym_class_identifier] = ACTIONS(273),
    [anon_sym_new] = ACTIONS(276),
    [anon_sym_implements] = ACTIONS(252),
    [anon_sym_interface] = ACTIONS(252),
    [anon_sym_private] = ACTIONS(279),
    [anon_sym_protected] = ACTIONS(252),
    [anon_sym_pure] = ACTIONS(252),
    [anon_sym_static] = ACTIONS(282),
    [anon_sym_super] = ACTIONS(252),
    [anon_sym_this] = ACTIONS(285),
    [anon_sym_POUND_LPAREN] = ACTIONS(288),
    [anon_sym_if] = ACTIONS(291),
    [anon_sym_break] = ACTIONS(294),
    [anon_sym_continue] = ACTIONS(294),
    [anon_sym_switch] = ACTIONS(294),
    [anon_sym_LT_LT_LT] = ACTIONS(297),
    [anon_sym_ATdoc] = ACTIONS(300),
    [anon_sym_do] = ACTIONS(303),
    [anon_sym_day] = ACTIONS(306),
    [anon_sym_hour] = ACTIONS(306),
    [anon_sym_minute] = ACTIONS(306),
    [anon_sym_ms] = ACTIONS(306),
    [anon_sym_samp] = ACTIONS(306),
    [anon_sym_second] = ACTIONS(306),
    [anon_sym_week] = ACTIONS(306),
    [sym_float] = ACTIONS(309),
    [anon_sym_for] = ACTIONS(312),
    [anon_sym_fun] = ACTIONS(315),
    [anon_sym_adc] = ACTIONS(318),
    [anon_sym_blackhole] = ACTIONS(318),
    [anon_sym_dac] = ACTIONS(318),
    [sym_hexidecimal] = ACTIONS(309),
    [anon_sym_PLUS_PLUS] = ACTIONS(321),
    [anon_sym_DASH_DASH] = ACTIONS(321),
    [sym_int] = ACTIONS(324),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(327),
    [anon_sym_me] = ACTIONS(330),
    [anon_sym_BANG] = ACTIONS(333),
    [anon_sym_DASH] = ACTIONS(336),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(339),
    [anon_sym_auto] = ACTIONS(342),
    [anon_sym_complex] = ACTIONS(342),
    [anon_sym_dur] = ACTIONS(342),
    [anon_sym_float] = ACTIONS(342),
    [anon_sym_int] = ACTIONS(342),
    [anon_sym_polar] = ACTIONS(342),
    [anon_sym_same] = ACTIONS(342),
    [anon_sym_time] = ACTIONS(342),
    [anon_sym_vec2] = ACTIONS(342),
    [anon_sym_vec3] = ACTIONS(342),
    [anon_sym_vec4] = ACTIONS(342),
    [anon_sym_void] = ACTIONS(342),
    [anon_sym_Event] = ACTIONS(345),
    [anon_sym_Object] = ACTIONS(345),
    [anon_sym_UGen] = ACTIONS(345),
    [anon_sym_array] = ACTIONS(345),
    [anon_sym_string] = ACTIONS(345),
    [anon_sym_AT_LPAREN] = ACTIONS(348),
    [anon_sym_NULL] = ACTIONS(351),
    [anon_sym_maybe] = ACTIONS(351),
    [anon_sym_now] = ACTIONS(351),
    [anon_sym_null] = ACTIONS(351),
    [anon_sym_pi] = ACTIONS(351),
    [anon_sym_return] = ACTIONS(354),
    [anon_sym_DQUOTE] = ACTIONS(357),
    [anon_sym_until] = ACTIONS(360),
    [anon_sym_while] = ACTIONS(360),
  },
  [7] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(8),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(8),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(8),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(8),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(363),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [8] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(6),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(6),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(6),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(6),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(365),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [9] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(10),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(10),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(10),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(10),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(367),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [10] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(6),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(6),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(6),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(6),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(369),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [11] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(4),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(4),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(4),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(4),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(371),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [12] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_definition] = STATE(5),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(121),
    [sym__control_structure] = STATE(121),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(41),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(121),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(121),
    [sym_for_each_loop] = STATE(121),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(146),
    [sym__function_keyword] = STATE(396),
    [sym__function_name_and_body] = STATE(150),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(121),
    [sym_member_identifier] = STATE(207),
    [sym_method_definition] = STATE(5),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(146),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(5),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(15),
    [sym_variable_declaration] = STATE(257),
    [aux_sym_block_repeat1] = STATE(5),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_RBRACE] = ACTIONS(373),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(230),
    [anon_sym_class] = ACTIONS(29),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(51),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(57),
    [anon_sym_fun] = ACTIONS(234),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(69),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [13] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(367),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(367),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(564),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(564),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(564),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(564),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(367),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(375),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [14] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(489),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(489),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(557),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(557),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(489),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [15] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(119),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(119),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(580),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(580),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(580),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(580),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(119),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(389),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [16] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(250),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(250),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(545),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(545),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(545),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(545),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(250),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(393),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [17] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(106),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(106),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(580),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(580),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(580),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(580),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(106),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(389),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [18] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(216),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(216),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(545),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(545),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(545),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(545),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(216),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(393),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [19] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(254),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(254),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(545),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(545),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(545),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(545),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(254),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(393),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [20] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(238),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(237),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(238),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(545),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(545),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(545),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(545),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(238),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(393),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [21] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(259),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(259),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(545),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(545),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(545),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(545),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(259),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(393),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [22] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(261),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(261),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(545),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(545),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(545),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(545),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(261),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(393),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [23] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(268),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(268),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(545),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(545),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(545),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(545),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(268),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(393),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(395),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [24] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(113),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(113),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(580),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(580),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(580),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(580),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(113),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(389),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [25] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(364),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(364),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(564),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(564),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(564),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(564),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(364),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(375),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [26] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(116),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(117),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(116),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(580),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(580),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(580),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(580),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(116),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(389),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [27] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(347),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(347),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(564),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(564),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(564),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(564),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(347),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(375),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [28] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(112),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(112),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(580),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(580),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(580),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(580),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(112),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(389),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [29] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(368),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(237),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(368),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(564),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(564),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(564),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(564),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(368),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(375),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [30] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(369),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(369),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(564),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(564),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(564),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(564),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(369),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(375),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [31] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(370),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(370),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(564),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(564),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(564),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(564),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(370),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(375),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [32] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(371),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(371),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(564),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(564),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(564),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(564),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(371),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(375),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(387),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [33] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(114),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(114),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(580),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(580),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(580),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(580),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(114),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(389),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [34] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(111),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(111),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(580),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(580),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(580),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(580),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(111),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(389),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(391),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [35] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(499),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(499),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(557),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(557),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(499),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [36] = {
    [sym_array] = STATE(257),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(257),
    [sym_block] = STATE(484),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(257),
    [sym_character] = STATE(257),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(453),
    [sym_class_instantiation] = STATE(257),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(257),
    [sym__control_structure] = STATE(257),
    [sym_control_structure_keyword] = STATE(252),
    [sym__control_structure_body] = STATE(484),
    [sym_debug_print] = STATE(257),
    [sym__declaration] = STATE(257),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(557),
    [sym_do_loop] = STATE(257),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(557),
    [sym_for_loop] = STATE(257),
    [sym_for_each_loop] = STATE(257),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(557),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(257),
    [sym_pre_increment_expression] = STATE(257),
    [sym__increment_expression] = STATE(257),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(257),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(257),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(257),
    [sym_negative_expression] = STATE(257),
    [sym__number] = STATE(257),
    [sym_overload_definition] = STATE(557),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(257),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(257),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(257),
    [sym_statement] = STATE(484),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(257),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(257),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [anon_sym_LBRACE] = ACTIONS(11),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(55),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(67),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_return] = ACTIONS(87),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [37] = {
    [sym_array] = STATE(247),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(247),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(247),
    [sym_character] = STATE(247),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(451),
    [sym_class_instantiation] = STATE(247),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(247),
    [sym__control_structure] = STATE(247),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(247),
    [sym__declaration] = STATE(247),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(584),
    [sym_do_loop] = STATE(247),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(247),
    [sym__expression] = STATE(247),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(584),
    [sym_for_loop] = STATE(247),
    [sym_for_each_loop] = STATE(247),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(584),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(247),
    [sym_pre_increment_expression] = STATE(247),
    [sym__increment_expression] = STATE(247),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(247),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(247),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(247),
    [sym_negative_expression] = STATE(247),
    [sym__number] = STATE(247),
    [sym_overload_definition] = STATE(584),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(247),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(247),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(247),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(247),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(247),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(397),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(401),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [38] = {
    [sym_array] = STATE(247),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(247),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(247),
    [sym_character] = STATE(247),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(451),
    [sym_class_instantiation] = STATE(247),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(247),
    [sym__control_structure] = STATE(247),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(247),
    [sym__declaration] = STATE(247),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(559),
    [sym_do_loop] = STATE(247),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(247),
    [sym__expression] = STATE(247),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(559),
    [sym_for_loop] = STATE(247),
    [sym_for_each_loop] = STATE(247),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(559),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(247),
    [sym_pre_increment_expression] = STATE(247),
    [sym__increment_expression] = STATE(247),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(247),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(247),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(247),
    [sym_negative_expression] = STATE(247),
    [sym__number] = STATE(247),
    [sym_overload_definition] = STATE(559),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(247),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(247),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(247),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(247),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(247),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(403),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(397),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(401),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [39] = {
    [sym_array] = STATE(247),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(247),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(247),
    [sym_character] = STATE(247),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(451),
    [sym_class_instantiation] = STATE(247),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(247),
    [sym__control_structure] = STATE(247),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(247),
    [sym__declaration] = STATE(247),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(576),
    [sym_do_loop] = STATE(247),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(247),
    [sym__expression] = STATE(247),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(576),
    [sym_for_loop] = STATE(247),
    [sym_for_each_loop] = STATE(247),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(576),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(247),
    [sym_pre_increment_expression] = STATE(247),
    [sym__increment_expression] = STATE(247),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(247),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(247),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(247),
    [sym_negative_expression] = STATE(247),
    [sym__number] = STATE(247),
    [sym_overload_definition] = STATE(576),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(247),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(247),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(247),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(247),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(247),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(405),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(397),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(401),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [40] = {
    [sym_array] = STATE(247),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(247),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(247),
    [sym_character] = STATE(247),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(451),
    [sym_class_instantiation] = STATE(247),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(247),
    [sym__control_structure] = STATE(247),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(247),
    [sym__declaration] = STATE(247),
    [sym_doc_comment] = STATE(47),
    [sym_documented_expression] = STATE(573),
    [sym_do_loop] = STATE(247),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(247),
    [sym__expression] = STATE(247),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(573),
    [sym_for_loop] = STATE(247),
    [sym_for_each_loop] = STATE(247),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_function_definition] = STATE(573),
    [sym__function_keyword] = STATE(426),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(247),
    [sym_pre_increment_expression] = STATE(247),
    [sym__increment_expression] = STATE(247),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(247),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(247),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(247),
    [sym_negative_expression] = STATE(247),
    [sym__number] = STATE(247),
    [sym_overload_definition] = STATE(573),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(247),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(247),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(247),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(247),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(247),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(377),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(35),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_ATdoc] = ACTIONS(49),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(397),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(407),
    [anon_sym_fun] = ACTIONS(59),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(397),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(401),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [41] = {
    [sym_array] = STATE(278),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(278),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(278),
    [sym_character] = STATE(278),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(465),
    [sym_class_instantiation] = STATE(278),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(278),
    [sym__control_structure] = STATE(278),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(278),
    [sym__declaration] = STATE(278),
    [sym_do_loop] = STATE(278),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(278),
    [sym__expression] = STATE(278),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(278),
    [sym_for_each_loop] = STATE(278),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym__function_keyword] = STATE(395),
    [sym__function_name_and_body] = STATE(152),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(278),
    [sym_pre_increment_expression] = STATE(278),
    [sym__increment_expression] = STATE(278),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(278),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(278),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(278),
    [sym_negative_expression] = STATE(278),
    [sym__number] = STATE(278),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(278),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(278),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(278),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(278),
    [sym__type] = STATE(363),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(278),
    [sym_variable_identifier] = ACTIONS(226),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(409),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(232),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(413),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(415),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(417),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [42] = {
    [sym_array] = STATE(278),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(278),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(278),
    [sym_character] = STATE(278),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(465),
    [sym_class_instantiation] = STATE(278),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(278),
    [sym__control_structure] = STATE(278),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(278),
    [sym__declaration] = STATE(278),
    [sym_do_loop] = STATE(278),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(278),
    [sym__expression] = STATE(278),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(278),
    [sym_for_each_loop] = STATE(278),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym__function_keyword] = STATE(421),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(278),
    [sym_pre_increment_expression] = STATE(278),
    [sym__increment_expression] = STATE(278),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(278),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(278),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(278),
    [sym_negative_expression] = STATE(278),
    [sym__number] = STATE(278),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(278),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(278),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(278),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(278),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(278),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_public] = ACTIONS(419),
    [anon_sym_class] = ACTIONS(411),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(413),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(421),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(417),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [43] = {
    [sym_array] = STATE(269),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(269),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(269),
    [sym_character] = STATE(269),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(449),
    [sym_class_instantiation] = STATE(269),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(269),
    [sym__control_structure] = STATE(269),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(269),
    [sym__declaration] = STATE(269),
    [sym_do_loop] = STATE(269),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(269),
    [sym__expression] = STATE(269),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(581),
    [sym_for_loop] = STATE(269),
    [sym_for_each_loop] = STATE(269),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(269),
    [sym_pre_increment_expression] = STATE(269),
    [sym__increment_expression] = STATE(269),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(269),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(269),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(269),
    [sym_negative_expression] = STATE(269),
    [sym__number] = STATE(269),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(269),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(269),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(269),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(269),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(269),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(423),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(425),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(427),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [44] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(585),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [45] = {
    [sym_array] = STATE(269),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(269),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(269),
    [sym_character] = STATE(269),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(269),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(269),
    [sym__control_structure] = STATE(269),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(269),
    [sym__declaration] = STATE(269),
    [sym_do_loop] = STATE(269),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(269),
    [sym__expression] = STATE(269),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(581),
    [sym_for_loop] = STATE(269),
    [sym_for_each_loop] = STATE(269),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(269),
    [sym_pre_increment_expression] = STATE(269),
    [sym__increment_expression] = STATE(269),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(269),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(269),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(269),
    [sym_negative_expression] = STATE(269),
    [sym__number] = STATE(269),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(269),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(269),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(269),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(269),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(269),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(423),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(425),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(425),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(427),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [46] = {
    [sym_array] = STATE(253),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(253),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(253),
    [sym_character] = STATE(253),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(253),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(253),
    [sym__control_structure] = STATE(253),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(253),
    [sym__declaration] = STATE(253),
    [sym_do_loop] = STATE(253),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(253),
    [sym__expression] = STATE(253),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(552),
    [sym_for_loop] = STATE(253),
    [sym_for_each_loop] = STATE(253),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(253),
    [sym_pre_increment_expression] = STATE(253),
    [sym__increment_expression] = STATE(253),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(253),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(253),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(253),
    [sym_negative_expression] = STATE(253),
    [sym__number] = STATE(253),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(253),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(253),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(253),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(253),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(253),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(435),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(437),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(437),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(439),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [47] = {
    [sym_array] = STATE(278),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(278),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(278),
    [sym_character] = STATE(278),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(465),
    [sym_class_instantiation] = STATE(278),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(278),
    [sym__control_structure] = STATE(278),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(278),
    [sym__declaration] = STATE(278),
    [sym_do_loop] = STATE(278),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(278),
    [sym__expression] = STATE(278),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(278),
    [sym_for_each_loop] = STATE(278),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym__function_keyword] = STATE(421),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(278),
    [sym_pre_increment_expression] = STATE(278),
    [sym__increment_expression] = STATE(278),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(278),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(278),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(278),
    [sym_negative_expression] = STATE(278),
    [sym__number] = STATE(278),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(278),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(278),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(278),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(278),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(278),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(413),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_fun] = ACTIONS(421),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(413),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(417),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [48] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(547),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_RPAREN] = ACTIONS(441),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [49] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(566),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [50] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(569),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [51] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(587),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [52] = {
    [sym_array] = STATE(287),
    [sym_array_identifier] = STATE(271),
    [sym_binary_expression] = STATE(287),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(287),
    [sym_character] = STATE(287),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(460),
    [sym_class_instantiation] = STATE(287),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(287),
    [sym__control_structure] = STATE(287),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(287),
    [sym__declaration] = STATE(287),
    [sym_do_loop] = STATE(287),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(287),
    [sym__expression] = STATE(287),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(287),
    [sym_for_each_loop] = STATE(287),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(287),
    [sym_pre_increment_expression] = STATE(287),
    [sym__increment_expression] = STATE(287),
    [sym__identifier] = STATE(271),
    [sym_keyword] = STATE(287),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(287),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(287),
    [sym_negative_expression] = STATE(287),
    [sym__number] = STATE(287),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(287),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(287),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(287),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(287),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(284),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(445),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(443),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(447),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [53] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(588),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [54] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(572),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [55] = {
    [sym_array] = STATE(214),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(214),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(214),
    [sym_character] = STATE(214),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(443),
    [sym_class_instantiation] = STATE(214),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(214),
    [sym__control_structure] = STATE(214),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(214),
    [sym__declaration] = STATE(214),
    [sym_do_loop] = STATE(214),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(214),
    [sym__expression] = STATE(214),
    [sym_expression_group] = STATE(223),
    [sym__expression_list] = STATE(568),
    [sym_for_loop] = STATE(214),
    [sym_for_each_loop] = STATE(214),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(214),
    [sym_pre_increment_expression] = STATE(214),
    [sym__increment_expression] = STATE(214),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(214),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(214),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(214),
    [sym_negative_expression] = STATE(214),
    [sym__number] = STATE(214),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(214),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(214),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(214),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(214),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(214),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(431),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(433),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [56] = {
    [sym_array] = STATE(287),
    [sym_array_identifier] = STATE(272),
    [sym_binary_expression] = STATE(287),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(287),
    [sym_character] = STATE(287),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(466),
    [sym_class_instantiation] = STATE(287),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(287),
    [sym__control_structure] = STATE(287),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(287),
    [sym__declaration] = STATE(287),
    [sym_do_loop] = STATE(287),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(287),
    [sym__expression] = STATE(287),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(287),
    [sym_for_each_loop] = STATE(287),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(287),
    [sym_pre_increment_expression] = STATE(287),
    [sym__increment_expression] = STATE(287),
    [sym__identifier] = STATE(272),
    [sym_keyword] = STATE(287),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(287),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(287),
    [sym_negative_expression] = STATE(287),
    [sym__number] = STATE(287),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(287),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(287),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(287),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(287),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(285),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(449),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(443),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(447),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [57] = {
    [sym_array] = STATE(287),
    [sym_array_identifier] = STATE(270),
    [sym_binary_expression] = STATE(287),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(287),
    [sym_character] = STATE(287),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(467),
    [sym_class_instantiation] = STATE(287),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(287),
    [sym__control_structure] = STATE(287),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(287),
    [sym__declaration] = STATE(287),
    [sym_do_loop] = STATE(287),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(287),
    [sym__expression] = STATE(287),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(287),
    [sym_for_each_loop] = STATE(287),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(287),
    [sym_pre_increment_expression] = STATE(287),
    [sym__increment_expression] = STATE(287),
    [sym__identifier] = STATE(270),
    [sym_keyword] = STATE(287),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(287),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(287),
    [sym_negative_expression] = STATE(287),
    [sym__number] = STATE(287),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(287),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(287),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(287),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(287),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(286),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(443),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_SEMI] = ACTIONS(451),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(443),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(447),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [58] = {
    [sym_array] = STATE(283),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(283),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(283),
    [sym_character] = STATE(283),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(461),
    [sym_class_instantiation] = STATE(283),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(283),
    [sym__control_structure] = STATE(283),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(283),
    [sym__declaration] = STATE(283),
    [sym_do_loop] = STATE(283),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(283),
    [sym__expression] = STATE(283),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(283),
    [sym_for_each_loop] = STATE(283),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(283),
    [sym_pre_increment_expression] = STATE(283),
    [sym__increment_expression] = STATE(283),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(283),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(283),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(283),
    [sym_negative_expression] = STATE(283),
    [sym__number] = STATE(283),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(283),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(283),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(283),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(283),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(283),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(453),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(453),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(455),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [59] = {
    [sym_array] = STATE(404),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(404),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(404),
    [sym_character] = STATE(404),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(404),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(404),
    [sym__control_structure] = STATE(404),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(404),
    [sym__declaration] = STATE(404),
    [sym_do_loop] = STATE(404),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(404),
    [sym__expression] = STATE(404),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(404),
    [sym_for_each_loop] = STATE(404),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(404),
    [sym_pre_increment_expression] = STATE(404),
    [sym__increment_expression] = STATE(404),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(404),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(404),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(404),
    [sym_negative_expression] = STATE(404),
    [sym__number] = STATE(404),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(404),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(404),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(404),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(404),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(404),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_RBRACK] = ACTIONS(461),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(495),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(495),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(503),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [60] = {
    [sym_array] = STATE(402),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(402),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(402),
    [sym_character] = STATE(402),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(402),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(402),
    [sym__control_structure] = STATE(402),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(402),
    [sym__declaration] = STATE(402),
    [sym_do_loop] = STATE(402),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(402),
    [sym__expression] = STATE(402),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(402),
    [sym_for_each_loop] = STATE(402),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(402),
    [sym_pre_increment_expression] = STATE(402),
    [sym__increment_expression] = STATE(402),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(402),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(402),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(402),
    [sym_negative_expression] = STATE(402),
    [sym__number] = STATE(402),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(402),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(402),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(402),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(402),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(402),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [anon_sym_RBRACK] = ACTIONS(525),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(527),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(527),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(529),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [61] = {
    [sym_array] = STATE(277),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(277),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(277),
    [sym_character] = STATE(277),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(463),
    [sym_class_instantiation] = STATE(277),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(277),
    [sym__control_structure] = STATE(277),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(277),
    [sym__declaration] = STATE(277),
    [sym_do_loop] = STATE(277),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(277),
    [sym__expression] = STATE(277),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(277),
    [sym_for_each_loop] = STATE(277),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(277),
    [sym_pre_increment_expression] = STATE(277),
    [sym__increment_expression] = STATE(277),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(277),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(277),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(277),
    [sym_negative_expression] = STATE(277),
    [sym__number] = STATE(277),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(277),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(277),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(277),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(277),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(277),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(531),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(531),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(533),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [62] = {
    [sym_array] = STATE(280),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(280),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(280),
    [sym_character] = STATE(280),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(457),
    [sym_class_instantiation] = STATE(280),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(280),
    [sym__control_structure] = STATE(280),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(280),
    [sym__declaration] = STATE(280),
    [sym_do_loop] = STATE(280),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(280),
    [sym__expression] = STATE(280),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(280),
    [sym_for_each_loop] = STATE(280),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(280),
    [sym_pre_increment_expression] = STATE(280),
    [sym__increment_expression] = STATE(280),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(280),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(280),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(280),
    [sym_negative_expression] = STATE(280),
    [sym__number] = STATE(280),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(280),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(280),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(280),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(280),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(280),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(535),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(535),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(537),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [63] = {
    [sym_array] = STATE(279),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(279),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(279),
    [sym_character] = STATE(279),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(454),
    [sym_class_instantiation] = STATE(279),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(279),
    [sym__control_structure] = STATE(279),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(279),
    [sym__declaration] = STATE(279),
    [sym_do_loop] = STATE(279),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(279),
    [sym__expression] = STATE(279),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(279),
    [sym_for_each_loop] = STATE(279),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(279),
    [sym_pre_increment_expression] = STATE(279),
    [sym__increment_expression] = STATE(279),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(279),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(279),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(279),
    [sym_negative_expression] = STATE(279),
    [sym__number] = STATE(279),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(279),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(279),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(279),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(279),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(279),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(539),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(539),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(541),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [64] = {
    [sym_array] = STATE(282),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(282),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(282),
    [sym_character] = STATE(282),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(455),
    [sym_class_instantiation] = STATE(282),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(282),
    [sym__control_structure] = STATE(282),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(282),
    [sym__declaration] = STATE(282),
    [sym_do_loop] = STATE(282),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(282),
    [sym__expression] = STATE(282),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(282),
    [sym_for_each_loop] = STATE(282),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(282),
    [sym_pre_increment_expression] = STATE(282),
    [sym__increment_expression] = STATE(282),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(282),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(282),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(282),
    [sym_negative_expression] = STATE(282),
    [sym__number] = STATE(282),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(282),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(282),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(282),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(282),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(282),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(543),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(543),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(545),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [65] = {
    [sym_array] = STATE(281),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(281),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(281),
    [sym_character] = STATE(281),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(456),
    [sym_class_instantiation] = STATE(281),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(281),
    [sym__control_structure] = STATE(281),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(281),
    [sym__declaration] = STATE(281),
    [sym_do_loop] = STATE(281),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(281),
    [sym__expression] = STATE(281),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(281),
    [sym_for_each_loop] = STATE(281),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(281),
    [sym_pre_increment_expression] = STATE(281),
    [sym__increment_expression] = STATE(281),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(281),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(281),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(281),
    [sym_negative_expression] = STATE(281),
    [sym__number] = STATE(281),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(281),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(281),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(281),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(281),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(281),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(547),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(547),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [66] = {
    [sym_array] = STATE(229),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(229),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(229),
    [sym_character] = STATE(229),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(441),
    [sym_class_instantiation] = STATE(229),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(229),
    [sym__control_structure] = STATE(229),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(229),
    [sym__declaration] = STATE(229),
    [sym_do_loop] = STATE(229),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(229),
    [sym__expression] = STATE(229),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(229),
    [sym_for_each_loop] = STATE(229),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(229),
    [sym_pre_increment_expression] = STATE(229),
    [sym__increment_expression] = STATE(229),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(229),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(229),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(229),
    [sym_negative_expression] = STATE(229),
    [sym__number] = STATE(229),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(229),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(229),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(229),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(229),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(229),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(551),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(551),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(553),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [67] = {
    [sym_array] = STATE(273),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(273),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(273),
    [sym_character] = STATE(273),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(458),
    [sym_class_instantiation] = STATE(273),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(273),
    [sym__control_structure] = STATE(273),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(273),
    [sym__declaration] = STATE(273),
    [sym_do_loop] = STATE(273),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(273),
    [sym__expression] = STATE(273),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(273),
    [sym_for_each_loop] = STATE(273),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(273),
    [sym_pre_increment_expression] = STATE(273),
    [sym__increment_expression] = STATE(273),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(273),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(273),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(273),
    [sym_negative_expression] = STATE(273),
    [sym__number] = STATE(273),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(273),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(273),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(273),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(273),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(273),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(555),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(555),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(557),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [68] = {
    [sym_array] = STATE(274),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(274),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(274),
    [sym_character] = STATE(274),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(459),
    [sym_class_instantiation] = STATE(274),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(274),
    [sym__control_structure] = STATE(274),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(274),
    [sym__declaration] = STATE(274),
    [sym_do_loop] = STATE(274),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(274),
    [sym__expression] = STATE(274),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(274),
    [sym_for_each_loop] = STATE(274),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(274),
    [sym_pre_increment_expression] = STATE(274),
    [sym__increment_expression] = STATE(274),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(274),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(274),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(274),
    [sym_negative_expression] = STATE(274),
    [sym__number] = STATE(274),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(274),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(274),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(274),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(274),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(274),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(559),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(559),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(561),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [69] = {
    [sym_array] = STATE(275),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(275),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(275),
    [sym_character] = STATE(275),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(462),
    [sym_class_instantiation] = STATE(275),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(275),
    [sym__control_structure] = STATE(275),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(275),
    [sym__declaration] = STATE(275),
    [sym_do_loop] = STATE(275),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(275),
    [sym__expression] = STATE(275),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(275),
    [sym_for_each_loop] = STATE(275),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(275),
    [sym_pre_increment_expression] = STATE(275),
    [sym__increment_expression] = STATE(275),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(275),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(275),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(275),
    [sym_negative_expression] = STATE(275),
    [sym__number] = STATE(275),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(275),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(275),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(275),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(275),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(275),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(563),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(563),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(565),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [70] = {
    [sym_array] = STATE(276),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(276),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(276),
    [sym_character] = STATE(276),
    [sym__chuck_keyword] = STATE(252),
    [sym_chuck_operation] = STATE(464),
    [sym_class_instantiation] = STATE(276),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(276),
    [sym__control_structure] = STATE(276),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(276),
    [sym__declaration] = STATE(276),
    [sym_do_loop] = STATE(276),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(276),
    [sym__expression] = STATE(276),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(276),
    [sym_for_each_loop] = STATE(276),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(276),
    [sym_pre_increment_expression] = STATE(276),
    [sym__increment_expression] = STATE(276),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(276),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(276),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(276),
    [sym_negative_expression] = STATE(276),
    [sym__number] = STATE(276),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(276),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(276),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(276),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(276),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(276),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(25),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(567),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(567),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(569),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [71] = {
    [sym_array] = STATE(240),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(240),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(240),
    [sym_character] = STATE(240),
    [sym__chuck_keyword] = STATE(252),
    [sym_class_instantiation] = STATE(240),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(240),
    [sym__control_structure] = STATE(240),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(240),
    [sym__declaration] = STATE(240),
    [sym_do_loop] = STATE(240),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(240),
    [sym__expression] = STATE(240),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(240),
    [sym_for_each_loop] = STATE(240),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(240),
    [sym_pre_increment_expression] = STATE(240),
    [sym__increment_expression] = STATE(240),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(240),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(240),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(240),
    [sym_negative_expression] = STATE(240),
    [sym__number] = STATE(240),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(240),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(240),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(240),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(240),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(240),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(571),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(573),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(573),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(575),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [72] = {
    [sym_array] = STATE(420),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(433),
    [sym_boolean_literal_value] = STATE(419),
    [sym_cast] = STATE(420),
    [sym_character] = STATE(420),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(420),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(420),
    [sym__control_structure] = STATE(420),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(420),
    [sym__declaration] = STATE(420),
    [sym_do_loop] = STATE(420),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(420),
    [sym__expression] = STATE(420),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(420),
    [sym_for_each_loop] = STATE(420),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(420),
    [sym_pre_increment_expression] = STATE(420),
    [sym__increment_expression] = STATE(420),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(420),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(420),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(420),
    [sym_negative_expression] = STATE(420),
    [sym__number] = STATE(420),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(420),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(420),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(420),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(420),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(420),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(577),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(577),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(579),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [73] = {
    [sym_array] = STATE(234),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(234),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(234),
    [sym_character] = STATE(234),
    [sym__chuck_keyword] = STATE(252),
    [sym_class_instantiation] = STATE(234),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(234),
    [sym__control_structure] = STATE(234),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(234),
    [sym__declaration] = STATE(234),
    [sym_do_loop] = STATE(234),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(234),
    [sym__expression] = STATE(234),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(234),
    [sym_for_each_loop] = STATE(234),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(234),
    [sym_pre_increment_expression] = STATE(234),
    [sym__increment_expression] = STATE(234),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(234),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(234),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(234),
    [sym_negative_expression] = STATE(234),
    [sym__number] = STATE(234),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(234),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(234),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(234),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(234),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(234),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(571),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(581),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(581),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(583),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [74] = {
    [sym_array] = STATE(239),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(239),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(239),
    [sym_character] = STATE(239),
    [sym__chuck_keyword] = STATE(252),
    [sym_class_instantiation] = STATE(239),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(239),
    [sym__control_structure] = STATE(239),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(239),
    [sym__declaration] = STATE(239),
    [sym_do_loop] = STATE(239),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(239),
    [sym__expression] = STATE(239),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(239),
    [sym_for_each_loop] = STATE(239),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(239),
    [sym_pre_increment_expression] = STATE(239),
    [sym__increment_expression] = STATE(239),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(239),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(239),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(239),
    [sym_negative_expression] = STATE(239),
    [sym__number] = STATE(239),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(239),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(239),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(239),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(239),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(239),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(571),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(585),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(585),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(587),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [75] = {
    [sym_array] = STATE(338),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(338),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(338),
    [sym_character] = STATE(338),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(338),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(338),
    [sym__control_structure] = STATE(338),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(338),
    [sym__declaration] = STATE(338),
    [sym_do_loop] = STATE(338),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(338),
    [sym__expression] = STATE(338),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(338),
    [sym_for_each_loop] = STATE(338),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(338),
    [sym_pre_increment_expression] = STATE(338),
    [sym__increment_expression] = STATE(338),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(338),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(338),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(338),
    [sym_negative_expression] = STATE(338),
    [sym__number] = STATE(338),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(338),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(338),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(338),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(338),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(338),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(589),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(589),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(591),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [76] = {
    [sym_array] = STATE(339),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(339),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(339),
    [sym_character] = STATE(339),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(339),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(339),
    [sym__control_structure] = STATE(339),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(339),
    [sym__declaration] = STATE(339),
    [sym_do_loop] = STATE(339),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(339),
    [sym__expression] = STATE(339),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(339),
    [sym_for_each_loop] = STATE(339),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(339),
    [sym_pre_increment_expression] = STATE(339),
    [sym__increment_expression] = STATE(339),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(339),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(339),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(339),
    [sym_negative_expression] = STATE(339),
    [sym__number] = STATE(339),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(339),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(339),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(339),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(339),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(339),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(593),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(593),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(595),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [77] = {
    [sym_array] = STATE(340),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(340),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(340),
    [sym_character] = STATE(340),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(340),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(340),
    [sym__control_structure] = STATE(340),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(340),
    [sym__declaration] = STATE(340),
    [sym_do_loop] = STATE(340),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(340),
    [sym__expression] = STATE(340),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(340),
    [sym_for_each_loop] = STATE(340),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(340),
    [sym_pre_increment_expression] = STATE(340),
    [sym__increment_expression] = STATE(340),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(340),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(340),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(340),
    [sym_negative_expression] = STATE(340),
    [sym__number] = STATE(340),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(340),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(340),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(340),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(340),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(340),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(597),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(597),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(599),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [78] = {
    [sym_array] = STATE(333),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(333),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(333),
    [sym_character] = STATE(333),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(333),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(333),
    [sym__control_structure] = STATE(333),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(333),
    [sym__declaration] = STATE(333),
    [sym_do_loop] = STATE(333),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(333),
    [sym__expression] = STATE(333),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(333),
    [sym_for_each_loop] = STATE(333),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(333),
    [sym_pre_increment_expression] = STATE(333),
    [sym__increment_expression] = STATE(333),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(333),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(333),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(333),
    [sym_negative_expression] = STATE(333),
    [sym__number] = STATE(333),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(333),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(333),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(333),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(333),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(333),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(601),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(601),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(603),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [79] = {
    [sym_array] = STATE(352),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(352),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(352),
    [sym_character] = STATE(352),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(352),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(352),
    [sym__control_structure] = STATE(352),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(352),
    [sym__declaration] = STATE(352),
    [sym_do_loop] = STATE(352),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(352),
    [sym__expression] = STATE(352),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(352),
    [sym_for_each_loop] = STATE(352),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(352),
    [sym_pre_increment_expression] = STATE(352),
    [sym__increment_expression] = STATE(352),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(352),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(352),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(352),
    [sym_negative_expression] = STATE(352),
    [sym__number] = STATE(352),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(352),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(352),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(352),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(352),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(352),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(605),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(605),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(607),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [80] = {
    [sym_array] = STATE(403),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(403),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(403),
    [sym_character] = STATE(403),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(403),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(403),
    [sym__control_structure] = STATE(403),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(403),
    [sym__declaration] = STATE(403),
    [sym_do_loop] = STATE(403),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(403),
    [sym__expression] = STATE(403),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(403),
    [sym_for_each_loop] = STATE(403),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(403),
    [sym_pre_increment_expression] = STATE(403),
    [sym__increment_expression] = STATE(403),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(403),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(403),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(403),
    [sym_negative_expression] = STATE(403),
    [sym__number] = STATE(403),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(403),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(403),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(403),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(403),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(403),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(609),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(609),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(611),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [81] = {
    [sym_array] = STATE(397),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(397),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(397),
    [sym_character] = STATE(397),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(397),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(397),
    [sym__control_structure] = STATE(397),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(397),
    [sym__declaration] = STATE(397),
    [sym_do_loop] = STATE(397),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(397),
    [sym__expression] = STATE(397),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(397),
    [sym_for_each_loop] = STATE(397),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(397),
    [sym_pre_increment_expression] = STATE(397),
    [sym__increment_expression] = STATE(397),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(397),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(397),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(397),
    [sym_negative_expression] = STATE(397),
    [sym__number] = STATE(397),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(397),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(397),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(397),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(397),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(397),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(613),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(613),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(615),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [82] = {
    [sym_array] = STATE(241),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(241),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(241),
    [sym_character] = STATE(241),
    [sym__chuck_keyword] = STATE(252),
    [sym_class_instantiation] = STATE(241),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(241),
    [sym__control_structure] = STATE(241),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(241),
    [sym__declaration] = STATE(241),
    [sym_do_loop] = STATE(241),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(241),
    [sym__expression] = STATE(241),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(241),
    [sym_for_each_loop] = STATE(241),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(241),
    [sym_pre_increment_expression] = STATE(241),
    [sym__increment_expression] = STATE(241),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(241),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(241),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(241),
    [sym_negative_expression] = STATE(241),
    [sym__number] = STATE(241),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(241),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(241),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(241),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(241),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(241),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(571),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(617),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(617),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(619),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [83] = {
    [sym_array] = STATE(415),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(415),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(415),
    [sym_character] = STATE(415),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(415),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(415),
    [sym__control_structure] = STATE(415),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(415),
    [sym__declaration] = STATE(415),
    [sym_do_loop] = STATE(415),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(415),
    [sym__expression] = STATE(415),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(415),
    [sym_for_each_loop] = STATE(415),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(415),
    [sym_pre_increment_expression] = STATE(415),
    [sym__increment_expression] = STATE(415),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(415),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(415),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(415),
    [sym_negative_expression] = STATE(415),
    [sym__number] = STATE(415),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(415),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(415),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(415),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(415),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(415),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(621),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(621),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(623),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [84] = {
    [sym_array] = STATE(246),
    [sym_array_identifier] = STATE(208),
    [sym_binary_expression] = STATE(246),
    [sym_boolean_literal_value] = STATE(252),
    [sym_cast] = STATE(246),
    [sym_character] = STATE(246),
    [sym__chuck_keyword] = STATE(252),
    [sym_class_instantiation] = STATE(246),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(222),
    [sym_conditional] = STATE(246),
    [sym__control_structure] = STATE(246),
    [sym_control_structure_keyword] = STATE(252),
    [sym_debug_print] = STATE(246),
    [sym__declaration] = STATE(246),
    [sym_do_loop] = STATE(246),
    [sym_duration_identifier] = STATE(252),
    [sym_dur] = STATE(246),
    [sym__expression] = STATE(246),
    [sym_expression_group] = STATE(223),
    [sym_for_loop] = STATE(246),
    [sym_for_each_loop] = STATE(246),
    [sym_function_call] = STATE(198),
    [sym__function_call_chain] = STATE(226),
    [sym_global_unit_generator] = STATE(227),
    [sym_post_increment_expression] = STATE(246),
    [sym_pre_increment_expression] = STATE(246),
    [sym__increment_expression] = STATE(246),
    [sym__identifier] = STATE(208),
    [sym_keyword] = STATE(246),
    [sym__literal_value] = STATE(252),
    [sym_loop] = STATE(246),
    [sym_member_identifier] = STATE(207),
    [sym_negation_expression] = STATE(246),
    [sym_negative_expression] = STATE(246),
    [sym__number] = STATE(246),
    [sym_polar] = STATE(222),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(246),
    [sym_reference_type] = STATE(159),
    [sym_reference_values] = STATE(246),
    [sym_special_literal_value] = STATE(252),
    [sym_spork_expression] = STATE(246),
    [sym_string] = STATE(223),
    [sym_ternary_expression] = STATE(246),
    [sym__type] = STATE(359),
    [sym__until_while_expression] = STATE(16),
    [sym_variable_declaration] = STATE(246),
    [sym_variable_identifier] = ACTIONS(7),
    [anon_sym_LBRACK] = ACTIONS(9),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_SQUOTE] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(23),
    [anon_sym_LPAREN] = ACTIONS(571),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_new] = ACTIONS(33),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_if] = ACTIONS(379),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_LT_LT_LT] = ACTIONS(47),
    [anon_sym_do] = ACTIONS(381),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [sym_float] = ACTIONS(625),
    [anon_sym_for] = ACTIONS(383),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_hexidecimal] = ACTIONS(625),
    [anon_sym_PLUS_PLUS] = ACTIONS(63),
    [anon_sym_DASH_DASH] = ACTIONS(63),
    [sym_int] = ACTIONS(627),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(385),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_BANG] = ACTIONS(73),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_AT_LPAREN] = ACTIONS(83),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [85] = {
    [sym_array] = STATE(399),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(399),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(399),
    [sym_character] = STATE(399),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(399),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(399),
    [sym__control_structure] = STATE(399),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(399),
    [sym__declaration] = STATE(399),
    [sym_do_loop] = STATE(399),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(399),
    [sym__expression] = STATE(399),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(399),
    [sym_for_each_loop] = STATE(399),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(399),
    [sym_pre_increment_expression] = STATE(399),
    [sym__increment_expression] = STATE(399),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(399),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(399),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(399),
    [sym_negative_expression] = STATE(399),
    [sym__number] = STATE(399),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(399),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(399),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(399),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(399),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(399),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(629),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(629),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(631),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [86] = {
    [sym_array] = STATE(401),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(401),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(401),
    [sym_character] = STATE(401),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(401),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(401),
    [sym__control_structure] = STATE(401),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(401),
    [sym__declaration] = STATE(401),
    [sym_do_loop] = STATE(401),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(401),
    [sym__expression] = STATE(401),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(401),
    [sym_for_each_loop] = STATE(401),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(401),
    [sym_pre_increment_expression] = STATE(401),
    [sym__increment_expression] = STATE(401),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(401),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(401),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(401),
    [sym_negative_expression] = STATE(401),
    [sym__number] = STATE(401),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(401),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(401),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(401),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(401),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(401),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(633),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(633),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(635),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [87] = {
    [sym_array] = STATE(420),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(418),
    [sym_boolean_literal_value] = STATE(424),
    [sym_cast] = STATE(420),
    [sym_character] = STATE(420),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(420),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(420),
    [sym__control_structure] = STATE(420),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(420),
    [sym__declaration] = STATE(420),
    [sym_do_loop] = STATE(420),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(420),
    [sym__expression] = STATE(420),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(420),
    [sym_for_each_loop] = STATE(420),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(420),
    [sym_pre_increment_expression] = STATE(420),
    [sym__increment_expression] = STATE(420),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(420),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(420),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(420),
    [sym_negative_expression] = STATE(420),
    [sym__number] = STATE(420),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(420),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(420),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(420),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(420),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(420),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(577),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(577),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(579),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [88] = {
    [sym_array] = STATE(400),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(400),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(400),
    [sym_character] = STATE(400),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(400),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(400),
    [sym__control_structure] = STATE(400),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(400),
    [sym__declaration] = STATE(400),
    [sym_do_loop] = STATE(400),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(400),
    [sym__expression] = STATE(400),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(400),
    [sym_for_each_loop] = STATE(400),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(400),
    [sym_pre_increment_expression] = STATE(400),
    [sym__increment_expression] = STATE(400),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(400),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(400),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(400),
    [sym_negative_expression] = STATE(400),
    [sym__number] = STATE(400),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(400),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(400),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(400),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(400),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(400),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(637),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(637),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(639),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [89] = {
    [sym_array] = STATE(405),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(405),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(405),
    [sym_character] = STATE(405),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(405),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(405),
    [sym__control_structure] = STATE(405),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(405),
    [sym__declaration] = STATE(405),
    [sym_do_loop] = STATE(405),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(405),
    [sym__expression] = STATE(405),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(405),
    [sym_for_each_loop] = STATE(405),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(405),
    [sym_pre_increment_expression] = STATE(405),
    [sym__increment_expression] = STATE(405),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(405),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(405),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(405),
    [sym_negative_expression] = STATE(405),
    [sym__number] = STATE(405),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(405),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(405),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(405),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(405),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(405),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(641),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(641),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(643),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [90] = {
    [sym_array] = STATE(406),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(406),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(406),
    [sym_character] = STATE(406),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(406),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(406),
    [sym__control_structure] = STATE(406),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(406),
    [sym__declaration] = STATE(406),
    [sym_do_loop] = STATE(406),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(406),
    [sym__expression] = STATE(406),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(406),
    [sym_for_each_loop] = STATE(406),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(406),
    [sym_pre_increment_expression] = STATE(406),
    [sym__increment_expression] = STATE(406),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(406),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(406),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(406),
    [sym_negative_expression] = STATE(406),
    [sym__number] = STATE(406),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(406),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(406),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(406),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(406),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(406),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(645),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(645),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(647),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [91] = {
    [sym_array] = STATE(407),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(407),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(407),
    [sym_character] = STATE(407),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(407),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(407),
    [sym__control_structure] = STATE(407),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(407),
    [sym__declaration] = STATE(407),
    [sym_do_loop] = STATE(407),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(407),
    [sym__expression] = STATE(407),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(407),
    [sym_for_each_loop] = STATE(407),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(407),
    [sym_pre_increment_expression] = STATE(407),
    [sym__increment_expression] = STATE(407),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(407),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(407),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(407),
    [sym_negative_expression] = STATE(407),
    [sym__number] = STATE(407),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(407),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(407),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(407),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(407),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(407),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(649),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(649),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(651),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [92] = {
    [sym_array] = STATE(408),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(408),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(408),
    [sym_character] = STATE(408),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(408),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(408),
    [sym__control_structure] = STATE(408),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(408),
    [sym__declaration] = STATE(408),
    [sym_do_loop] = STATE(408),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(408),
    [sym__expression] = STATE(408),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(408),
    [sym_for_each_loop] = STATE(408),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(408),
    [sym_pre_increment_expression] = STATE(408),
    [sym__increment_expression] = STATE(408),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(408),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(408),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(408),
    [sym_negative_expression] = STATE(408),
    [sym__number] = STATE(408),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(408),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(408),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(408),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(408),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(408),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(653),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(653),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(655),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [93] = {
    [sym_array] = STATE(409),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(409),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(409),
    [sym_character] = STATE(409),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(409),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(409),
    [sym__control_structure] = STATE(409),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(409),
    [sym__declaration] = STATE(409),
    [sym_do_loop] = STATE(409),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(409),
    [sym__expression] = STATE(409),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(409),
    [sym_for_each_loop] = STATE(409),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(409),
    [sym_pre_increment_expression] = STATE(409),
    [sym__increment_expression] = STATE(409),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(409),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(409),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(409),
    [sym_negative_expression] = STATE(409),
    [sym__number] = STATE(409),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(409),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(409),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(409),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(409),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(409),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(657),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(657),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(659),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [94] = {
    [sym_array] = STATE(410),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(410),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(410),
    [sym_character] = STATE(410),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(410),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(410),
    [sym__control_structure] = STATE(410),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(410),
    [sym__declaration] = STATE(410),
    [sym_do_loop] = STATE(410),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(410),
    [sym__expression] = STATE(410),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(410),
    [sym_for_each_loop] = STATE(410),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(410),
    [sym_pre_increment_expression] = STATE(410),
    [sym__increment_expression] = STATE(410),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(410),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(410),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(410),
    [sym_negative_expression] = STATE(410),
    [sym__number] = STATE(410),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(410),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(410),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(410),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(410),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(410),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(661),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(661),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(663),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [95] = {
    [sym_array] = STATE(412),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(412),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(412),
    [sym_character] = STATE(412),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(412),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(412),
    [sym__control_structure] = STATE(412),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(412),
    [sym__declaration] = STATE(412),
    [sym_do_loop] = STATE(412),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(412),
    [sym__expression] = STATE(412),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(412),
    [sym_for_each_loop] = STATE(412),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(412),
    [sym_pre_increment_expression] = STATE(412),
    [sym__increment_expression] = STATE(412),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(412),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(412),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(412),
    [sym_negative_expression] = STATE(412),
    [sym__number] = STATE(412),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(412),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(412),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(412),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(412),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(412),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(665),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(665),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(667),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [96] = {
    [sym_array] = STATE(413),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(413),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(413),
    [sym_character] = STATE(413),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(413),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(413),
    [sym__control_structure] = STATE(413),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(413),
    [sym__declaration] = STATE(413),
    [sym_do_loop] = STATE(413),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(413),
    [sym__expression] = STATE(413),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(413),
    [sym_for_each_loop] = STATE(413),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(413),
    [sym_pre_increment_expression] = STATE(413),
    [sym__increment_expression] = STATE(413),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(413),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(413),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(413),
    [sym_negative_expression] = STATE(413),
    [sym__number] = STATE(413),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(413),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(413),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(413),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(413),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(413),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(669),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(669),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(671),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [97] = {
    [sym_array] = STATE(414),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(414),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(414),
    [sym_character] = STATE(414),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(414),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(414),
    [sym__control_structure] = STATE(414),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(414),
    [sym__declaration] = STATE(414),
    [sym_do_loop] = STATE(414),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(414),
    [sym__expression] = STATE(414),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(414),
    [sym_for_each_loop] = STATE(414),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(414),
    [sym_pre_increment_expression] = STATE(414),
    [sym__increment_expression] = STATE(414),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(414),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(414),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(414),
    [sym_negative_expression] = STATE(414),
    [sym__number] = STATE(414),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(414),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(414),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(414),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(414),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(414),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(673),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(673),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(675),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [98] = {
    [sym_array] = STATE(420),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(422),
    [sym_boolean_literal_value] = STATE(423),
    [sym_cast] = STATE(420),
    [sym_character] = STATE(420),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(420),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(420),
    [sym__control_structure] = STATE(420),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(420),
    [sym__declaration] = STATE(420),
    [sym_do_loop] = STATE(420),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(420),
    [sym__expression] = STATE(420),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(420),
    [sym_for_each_loop] = STATE(420),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(420),
    [sym_pre_increment_expression] = STATE(420),
    [sym__increment_expression] = STATE(420),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(420),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(420),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(420),
    [sym_negative_expression] = STATE(420),
    [sym__number] = STATE(420),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(420),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(420),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(420),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(420),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(420),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(577),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(577),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(579),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [99] = {
    [sym_array] = STATE(411),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(411),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(411),
    [sym_character] = STATE(411),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(411),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(411),
    [sym__control_structure] = STATE(411),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(411),
    [sym__declaration] = STATE(411),
    [sym_do_loop] = STATE(411),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(411),
    [sym__expression] = STATE(411),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(411),
    [sym_for_each_loop] = STATE(411),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(411),
    [sym_pre_increment_expression] = STATE(411),
    [sym__increment_expression] = STATE(411),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(411),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(411),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(411),
    [sym_negative_expression] = STATE(411),
    [sym__number] = STATE(411),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(411),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(411),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(411),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(411),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(411),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(677),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(677),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(679),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [100] = {
    [sym_array] = STATE(416),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(416),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(416),
    [sym_character] = STATE(416),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(416),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(416),
    [sym__control_structure] = STATE(416),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(416),
    [sym__declaration] = STATE(416),
    [sym_do_loop] = STATE(416),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(416),
    [sym__expression] = STATE(416),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(416),
    [sym_for_each_loop] = STATE(416),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(416),
    [sym_pre_increment_expression] = STATE(416),
    [sym__increment_expression] = STATE(416),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(416),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(416),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(416),
    [sym_negative_expression] = STATE(416),
    [sym__number] = STATE(416),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(416),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(416),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(416),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(416),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(416),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(681),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(681),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(683),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [101] = {
    [sym_array] = STATE(417),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(417),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(417),
    [sym_character] = STATE(417),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(417),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(417),
    [sym__control_structure] = STATE(417),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(417),
    [sym__declaration] = STATE(417),
    [sym_do_loop] = STATE(417),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(417),
    [sym__expression] = STATE(417),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(417),
    [sym_for_each_loop] = STATE(417),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(417),
    [sym_pre_increment_expression] = STATE(417),
    [sym__increment_expression] = STATE(417),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(417),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(417),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(417),
    [sym_negative_expression] = STATE(417),
    [sym__number] = STATE(417),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(417),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(417),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(417),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(417),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(417),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(685),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(685),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(687),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [102] = {
    [sym_array] = STATE(420),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(427),
    [sym_boolean_literal_value] = STATE(428),
    [sym_cast] = STATE(420),
    [sym_character] = STATE(420),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(420),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(420),
    [sym__control_structure] = STATE(420),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(420),
    [sym__declaration] = STATE(420),
    [sym_do_loop] = STATE(420),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(420),
    [sym__expression] = STATE(420),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(420),
    [sym_for_each_loop] = STATE(420),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(420),
    [sym_pre_increment_expression] = STATE(420),
    [sym__increment_expression] = STATE(420),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(420),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(420),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(420),
    [sym_negative_expression] = STATE(420),
    [sym__number] = STATE(420),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(420),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(420),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(420),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(420),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(420),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(577),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(577),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(579),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [103] = {
    [sym_array] = STATE(420),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(429),
    [sym_boolean_literal_value] = STATE(430),
    [sym_cast] = STATE(420),
    [sym_character] = STATE(420),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(420),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(420),
    [sym__control_structure] = STATE(420),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(420),
    [sym__declaration] = STATE(420),
    [sym_do_loop] = STATE(420),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(420),
    [sym__expression] = STATE(420),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(420),
    [sym_for_each_loop] = STATE(420),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(420),
    [sym_pre_increment_expression] = STATE(420),
    [sym__increment_expression] = STATE(420),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(420),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(420),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(420),
    [sym_negative_expression] = STATE(420),
    [sym__number] = STATE(420),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(420),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(420),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(420),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(420),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(420),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(577),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(577),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(579),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [104] = {
    [sym_array] = STATE(420),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(431),
    [sym_boolean_literal_value] = STATE(432),
    [sym_cast] = STATE(420),
    [sym_character] = STATE(420),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(420),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(420),
    [sym__control_structure] = STATE(420),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(420),
    [sym__declaration] = STATE(420),
    [sym_do_loop] = STATE(420),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(420),
    [sym__expression] = STATE(420),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(420),
    [sym_for_each_loop] = STATE(420),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(420),
    [sym_pre_increment_expression] = STATE(420),
    [sym__increment_expression] = STATE(420),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(420),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(420),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(420),
    [sym_negative_expression] = STATE(420),
    [sym__number] = STATE(420),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(420),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(420),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(420),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(420),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(420),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(577),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(577),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(579),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [105] = {
    [sym_array] = STATE(398),
    [sym_array_identifier] = STATE(313),
    [sym_binary_expression] = STATE(398),
    [sym_boolean_literal_value] = STATE(366),
    [sym_cast] = STATE(398),
    [sym_character] = STATE(398),
    [sym__chuck_keyword] = STATE(366),
    [sym_class_instantiation] = STATE(398),
    [sym__class_keyword] = STATE(366),
    [sym_complex] = STATE(325),
    [sym_conditional] = STATE(398),
    [sym__control_structure] = STATE(398),
    [sym_control_structure_keyword] = STATE(366),
    [sym_debug_print] = STATE(398),
    [sym__declaration] = STATE(398),
    [sym_do_loop] = STATE(398),
    [sym_duration_identifier] = STATE(366),
    [sym_dur] = STATE(398),
    [sym__expression] = STATE(398),
    [sym_expression_group] = STATE(327),
    [sym_for_loop] = STATE(398),
    [sym_for_each_loop] = STATE(398),
    [sym_function_call] = STATE(296),
    [sym__function_call_chain] = STATE(322),
    [sym_global_unit_generator] = STATE(321),
    [sym_post_increment_expression] = STATE(398),
    [sym_pre_increment_expression] = STATE(398),
    [sym__increment_expression] = STATE(398),
    [sym__identifier] = STATE(313),
    [sym_keyword] = STATE(398),
    [sym__literal_value] = STATE(366),
    [sym_loop] = STATE(398),
    [sym_member_identifier] = STATE(311),
    [sym_negation_expression] = STATE(398),
    [sym_negative_expression] = STATE(398),
    [sym__number] = STATE(398),
    [sym_polar] = STATE(325),
    [sym_primitive_type] = STATE(184),
    [sym_reference_declaration] = STATE(398),
    [sym_reference_type] = STATE(171),
    [sym_reference_values] = STATE(398),
    [sym_special_literal_value] = STATE(366),
    [sym_spork_expression] = STATE(398),
    [sym_string] = STATE(327),
    [sym_ternary_expression] = STATE(398),
    [sym__type] = STATE(378),
    [sym__until_while_expression] = STATE(25),
    [sym_variable_declaration] = STATE(398),
    [sym_variable_identifier] = ACTIONS(457),
    [anon_sym_LBRACK] = ACTIONS(459),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(463),
    [anon_sym_true] = ACTIONS(463),
    [anon_sym_SQUOTE] = ACTIONS(465),
    [anon_sym_const] = ACTIONS(467),
    [anon_sym_function] = ACTIONS(467),
    [anon_sym_global] = ACTIONS(469),
    [anon_sym_spork] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_extends] = ACTIONS(467),
    [sym_class_identifier] = ACTIONS(475),
    [anon_sym_new] = ACTIONS(477),
    [anon_sym_implements] = ACTIONS(467),
    [anon_sym_interface] = ACTIONS(467),
    [anon_sym_private] = ACTIONS(467),
    [anon_sym_protected] = ACTIONS(467),
    [anon_sym_pure] = ACTIONS(467),
    [anon_sym_static] = ACTIONS(479),
    [anon_sym_super] = ACTIONS(467),
    [anon_sym_this] = ACTIONS(481),
    [anon_sym_POUND_LPAREN] = ACTIONS(483),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_break] = ACTIONS(487),
    [anon_sym_continue] = ACTIONS(487),
    [anon_sym_switch] = ACTIONS(487),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [anon_sym_do] = ACTIONS(491),
    [anon_sym_day] = ACTIONS(493),
    [anon_sym_hour] = ACTIONS(493),
    [anon_sym_minute] = ACTIONS(493),
    [anon_sym_ms] = ACTIONS(493),
    [anon_sym_samp] = ACTIONS(493),
    [anon_sym_second] = ACTIONS(493),
    [anon_sym_week] = ACTIONS(493),
    [sym_float] = ACTIONS(689),
    [anon_sym_for] = ACTIONS(497),
    [anon_sym_adc] = ACTIONS(499),
    [anon_sym_blackhole] = ACTIONS(499),
    [anon_sym_dac] = ACTIONS(499),
    [sym_hexidecimal] = ACTIONS(689),
    [anon_sym_PLUS_PLUS] = ACTIONS(501),
    [anon_sym_DASH_DASH] = ACTIONS(501),
    [sym_int] = ACTIONS(691),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(505),
    [anon_sym_me] = ACTIONS(507),
    [anon_sym_BANG] = ACTIONS(509),
    [anon_sym_DASH] = ACTIONS(511),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(513),
    [anon_sym_auto] = ACTIONS(515),
    [anon_sym_complex] = ACTIONS(515),
    [anon_sym_dur] = ACTIONS(515),
    [anon_sym_float] = ACTIONS(515),
    [anon_sym_int] = ACTIONS(515),
    [anon_sym_polar] = ACTIONS(515),
    [anon_sym_same] = ACTIONS(515),
    [anon_sym_time] = ACTIONS(515),
    [anon_sym_vec2] = ACTIONS(515),
    [anon_sym_vec3] = ACTIONS(515),
    [anon_sym_vec4] = ACTIONS(515),
    [anon_sym_void] = ACTIONS(515),
    [anon_sym_Event] = ACTIONS(517),
    [anon_sym_Object] = ACTIONS(517),
    [anon_sym_UGen] = ACTIONS(517),
    [anon_sym_array] = ACTIONS(517),
    [anon_sym_string] = ACTIONS(517),
    [anon_sym_AT_LPAREN] = ACTIONS(519),
    [anon_sym_NULL] = ACTIONS(521),
    [anon_sym_maybe] = ACTIONS(521),
    [anon_sym_now] = ACTIONS(521),
    [anon_sym_null] = ACTIONS(521),
    [anon_sym_pi] = ACTIONS(521),
    [anon_sym_DQUOTE] = ACTIONS(523),
    [anon_sym_until] = ACTIONS(91),
    [anon_sym_while] = ACTIONS(91),
  },
  [106] = {
    [ts_builtin_sym_end] = ACTIONS(693),
    [sym_variable_identifier] = ACTIONS(695),
    [anon_sym_LBRACK] = ACTIONS(693),
    [anon_sym_LBRACE] = ACTIONS(693),
    [anon_sym_RBRACE] = ACTIONS(693),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(695),
    [anon_sym_true] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(693),
    [anon_sym_SQUOTE] = ACTIONS(693),
    [anon_sym_const] = ACTIONS(695),
    [anon_sym_function] = ACTIONS(695),
    [anon_sym_global] = ACTIONS(695),
    [anon_sym_spork] = ACTIONS(695),
    [anon_sym_LPAREN] = ACTIONS(693),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(693),
    [anon_sym_AMP_EQ_GT] = ACTIONS(693),
    [anon_sym_STAR_EQ_GT] = ACTIONS(693),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(693),
    [anon_sym_DASH_DASH_GT] = ACTIONS(693),
    [anon_sym_DASH_EQ_GT] = ACTIONS(693),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(693),
    [anon_sym_EQ_LT] = ACTIONS(693),
    [anon_sym_EQ_GT] = ACTIONS(693),
    [anon_sym_EQ_CARET] = ACTIONS(693),
    [anon_sym_AT_EQ_GT] = ACTIONS(693),
    [anon_sym_CARET_EQ_GT] = ACTIONS(693),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(693),
    [anon_sym_public] = ACTIONS(695),
    [anon_sym_class] = ACTIONS(695),
    [anon_sym_extends] = ACTIONS(695),
    [sym_class_identifier] = ACTIONS(695),
    [anon_sym_new] = ACTIONS(695),
    [anon_sym_implements] = ACTIONS(695),
    [anon_sym_interface] = ACTIONS(695),
    [anon_sym_private] = ACTIONS(695),
    [anon_sym_protected] = ACTIONS(695),
    [anon_sym_pure] = ACTIONS(695),
    [anon_sym_static] = ACTIONS(695),
    [anon_sym_super] = ACTIONS(695),
    [anon_sym_this] = ACTIONS(695),
    [anon_sym_POUND_LPAREN] = ACTIONS(693),
    [anon_sym_COMMA] = ACTIONS(693),
    [anon_sym_if] = ACTIONS(695),
    [anon_sym_else] = ACTIONS(697),
    [anon_sym_break] = ACTIONS(695),
    [anon_sym_continue] = ACTIONS(695),
    [anon_sym_switch] = ACTIONS(695),
    [anon_sym_LT_LT_LT] = ACTIONS(693),
    [anon_sym_ATdoc] = ACTIONS(693),
    [anon_sym_do] = ACTIONS(695),
    [anon_sym_day] = ACTIONS(695),
    [anon_sym_hour] = ACTIONS(695),
    [anon_sym_minute] = ACTIONS(695),
    [anon_sym_ms] = ACTIONS(695),
    [anon_sym_samp] = ACTIONS(695),
    [anon_sym_second] = ACTIONS(695),
    [anon_sym_week] = ACTIONS(695),
    [anon_sym_COLON_COLON] = ACTIONS(693),
    [sym_float] = ACTIONS(693),
    [anon_sym_for] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(693),
    [anon_sym_fun] = ACTIONS(695),
    [anon_sym_adc] = ACTIONS(695),
    [anon_sym_blackhole] = ACTIONS(695),
    [anon_sym_dac] = ACTIONS(695),
    [sym_hexidecimal] = ACTIONS(693),
    [anon_sym_PLUS_PLUS] = ACTIONS(693),
    [anon_sym_DASH_DASH] = ACTIONS(695),
    [anon_sym_ATimport] = ACTIONS(693),
    [sym_int] = ACTIONS(695),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(695),
    [anon_sym_me] = ACTIONS(695),
    [anon_sym_BANG] = ACTIONS(695),
    [anon_sym_DASH] = ACTIONS(695),
    [anon_sym_BANG_EQ] = ACTIONS(693),
    [anon_sym_PERCENT] = ACTIONS(695),
    [anon_sym_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(693),
    [anon_sym_STAR] = ACTIONS(695),
    [anon_sym_PLUS] = ACTIONS(695),
    [anon_sym_SLASH] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(695),
    [anon_sym_LT_LT] = ACTIONS(695),
    [anon_sym_LT_EQ] = ACTIONS(693),
    [anon_sym_EQ_EQ] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(695),
    [anon_sym_GT_EQ] = ACTIONS(693),
    [anon_sym_GT_GT] = ACTIONS(693),
    [anon_sym_CARET] = ACTIONS(695),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(693),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(693),
    [anon_sym_auto] = ACTIONS(695),
    [anon_sym_complex] = ACTIONS(695),
    [anon_sym_dur] = ACTIONS(695),
    [anon_sym_float] = ACTIONS(695),
    [anon_sym_int] = ACTIONS(695),
    [anon_sym_polar] = ACTIONS(695),
    [anon_sym_same] = ACTIONS(695),
    [anon_sym_time] = ACTIONS(695),
    [anon_sym_vec2] = ACTIONS(695),
    [anon_sym_vec3] = ACTIONS(695),
    [anon_sym_vec4] = ACTIONS(695),
    [anon_sym_void] = ACTIONS(695),
    [anon_sym_Event] = ACTIONS(695),
    [anon_sym_Object] = ACTIONS(695),
    [anon_sym_UGen] = ACTIONS(695),
    [anon_sym_array] = ACTIONS(695),
    [anon_sym_string] = ACTIONS(695),
    [anon_sym_AT_LPAREN] = ACTIONS(693),
    [anon_sym_NULL] = ACTIONS(695),
    [anon_sym_maybe] = ACTIONS(695),
    [anon_sym_now] = ACTIONS(695),
    [anon_sym_null] = ACTIONS(695),
    [anon_sym_pi] = ACTIONS(695),
    [anon_sym_return] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(693),
    [anon_sym_QMARK] = ACTIONS(693),
    [anon_sym_until] = ACTIONS(695),
    [anon_sym_while] = ACTIONS(695),
  },
  [107] = {
    [ts_builtin_sym_end] = ACTIONS(699),
    [sym_variable_identifier] = ACTIONS(701),
    [anon_sym_LBRACK] = ACTIONS(699),
    [anon_sym_LBRACE] = ACTIONS(699),
    [anon_sym_RBRACE] = ACTIONS(699),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(701),
    [anon_sym_true] = ACTIONS(701),
    [anon_sym_DOLLAR] = ACTIONS(699),
    [anon_sym_SQUOTE] = ACTIONS(699),
    [anon_sym_const] = ACTIONS(701),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_global] = ACTIONS(701),
    [anon_sym_spork] = ACTIONS(701),
    [anon_sym_LPAREN] = ACTIONS(699),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(699),
    [anon_sym_AMP_EQ_GT] = ACTIONS(699),
    [anon_sym_STAR_EQ_GT] = ACTIONS(699),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(699),
    [anon_sym_DASH_DASH_GT] = ACTIONS(699),
    [anon_sym_DASH_EQ_GT] = ACTIONS(699),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(699),
    [anon_sym_EQ_LT] = ACTIONS(699),
    [anon_sym_EQ_GT] = ACTIONS(699),
    [anon_sym_EQ_CARET] = ACTIONS(699),
    [anon_sym_AT_EQ_GT] = ACTIONS(699),
    [anon_sym_CARET_EQ_GT] = ACTIONS(699),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(699),
    [anon_sym_public] = ACTIONS(701),
    [anon_sym_class] = ACTIONS(701),
    [anon_sym_extends] = ACTIONS(701),
    [sym_class_identifier] = ACTIONS(701),
    [anon_sym_new] = ACTIONS(701),
    [anon_sym_implements] = ACTIONS(701),
    [anon_sym_interface] = ACTIONS(701),
    [anon_sym_private] = ACTIONS(701),
    [anon_sym_protected] = ACTIONS(701),
    [anon_sym_pure] = ACTIONS(701),
    [anon_sym_static] = ACTIONS(701),
    [anon_sym_super] = ACTIONS(701),
    [anon_sym_this] = ACTIONS(701),
    [anon_sym_POUND_LPAREN] = ACTIONS(699),
    [anon_sym_COMMA] = ACTIONS(699),
    [anon_sym_if] = ACTIONS(701),
    [anon_sym_else] = ACTIONS(701),
    [anon_sym_break] = ACTIONS(701),
    [anon_sym_continue] = ACTIONS(701),
    [anon_sym_switch] = ACTIONS(701),
    [anon_sym_LT_LT_LT] = ACTIONS(699),
    [anon_sym_ATdoc] = ACTIONS(699),
    [anon_sym_do] = ACTIONS(701),
    [anon_sym_day] = ACTIONS(701),
    [anon_sym_hour] = ACTIONS(701),
    [anon_sym_minute] = ACTIONS(701),
    [anon_sym_ms] = ACTIONS(701),
    [anon_sym_samp] = ACTIONS(701),
    [anon_sym_second] = ACTIONS(701),
    [anon_sym_week] = ACTIONS(701),
    [anon_sym_COLON_COLON] = ACTIONS(699),
    [sym_float] = ACTIONS(699),
    [anon_sym_for] = ACTIONS(701),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_fun] = ACTIONS(701),
    [anon_sym_adc] = ACTIONS(701),
    [anon_sym_blackhole] = ACTIONS(701),
    [anon_sym_dac] = ACTIONS(701),
    [sym_hexidecimal] = ACTIONS(699),
    [anon_sym_PLUS_PLUS] = ACTIONS(699),
    [anon_sym_DASH_DASH] = ACTIONS(701),
    [anon_sym_ATimport] = ACTIONS(699),
    [sym_int] = ACTIONS(701),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(701),
    [anon_sym_me] = ACTIONS(701),
    [anon_sym_BANG] = ACTIONS(701),
    [anon_sym_DASH] = ACTIONS(701),
    [anon_sym_BANG_EQ] = ACTIONS(699),
    [anon_sym_PERCENT] = ACTIONS(701),
    [anon_sym_AMP] = ACTIONS(701),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_STAR] = ACTIONS(701),
    [anon_sym_PLUS] = ACTIONS(701),
    [anon_sym_SLASH] = ACTIONS(701),
    [anon_sym_LT] = ACTIONS(701),
    [anon_sym_LT_LT] = ACTIONS(701),
    [anon_sym_LT_EQ] = ACTIONS(699),
    [anon_sym_EQ_EQ] = ACTIONS(699),
    [anon_sym_GT] = ACTIONS(701),
    [anon_sym_GT_EQ] = ACTIONS(699),
    [anon_sym_GT_GT] = ACTIONS(699),
    [anon_sym_CARET] = ACTIONS(701),
    [anon_sym_PIPE] = ACTIONS(701),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(699),
    [anon_sym_auto] = ACTIONS(701),
    [anon_sym_complex] = ACTIONS(701),
    [anon_sym_dur] = ACTIONS(701),
    [anon_sym_float] = ACTIONS(701),
    [anon_sym_int] = ACTIONS(701),
    [anon_sym_polar] = ACTIONS(701),
    [anon_sym_same] = ACTIONS(701),
    [anon_sym_time] = ACTIONS(701),
    [anon_sym_vec2] = ACTIONS(701),
    [anon_sym_vec3] = ACTIONS(701),
    [anon_sym_vec4] = ACTIONS(701),
    [anon_sym_void] = ACTIONS(701),
    [anon_sym_Event] = ACTIONS(701),
    [anon_sym_Object] = ACTIONS(701),
    [anon_sym_UGen] = ACTIONS(701),
    [anon_sym_array] = ACTIONS(701),
    [anon_sym_string] = ACTIONS(701),
    [anon_sym_AT_LPAREN] = ACTIONS(699),
    [anon_sym_NULL] = ACTIONS(701),
    [anon_sym_maybe] = ACTIONS(701),
    [anon_sym_now] = ACTIONS(701),
    [anon_sym_null] = ACTIONS(701),
    [anon_sym_pi] = ACTIONS(701),
    [anon_sym_return] = ACTIONS(701),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_QMARK] = ACTIONS(699),
    [anon_sym_until] = ACTIONS(701),
    [anon_sym_while] = ACTIONS(701),
  },
  [108] = {
    [ts_builtin_sym_end] = ACTIONS(703),
    [sym_variable_identifier] = ACTIONS(705),
    [anon_sym_LBRACK] = ACTIONS(703),
    [anon_sym_LBRACE] = ACTIONS(703),
    [anon_sym_RBRACE] = ACTIONS(703),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(705),
    [anon_sym_true] = ACTIONS(705),
    [anon_sym_DOLLAR] = ACTIONS(703),
    [anon_sym_SQUOTE] = ACTIONS(703),
    [anon_sym_const] = ACTIONS(705),
    [anon_sym_function] = ACTIONS(705),
    [anon_sym_global] = ACTIONS(705),
    [anon_sym_spork] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(703),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(703),
    [anon_sym_AMP_EQ_GT] = ACTIONS(703),
    [anon_sym_STAR_EQ_GT] = ACTIONS(703),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(703),
    [anon_sym_DASH_DASH_GT] = ACTIONS(703),
    [anon_sym_DASH_EQ_GT] = ACTIONS(703),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(703),
    [anon_sym_EQ_LT] = ACTIONS(703),
    [anon_sym_EQ_GT] = ACTIONS(703),
    [anon_sym_EQ_CARET] = ACTIONS(703),
    [anon_sym_AT_EQ_GT] = ACTIONS(703),
    [anon_sym_CARET_EQ_GT] = ACTIONS(703),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(703),
    [anon_sym_public] = ACTIONS(705),
    [anon_sym_class] = ACTIONS(705),
    [anon_sym_extends] = ACTIONS(705),
    [sym_class_identifier] = ACTIONS(705),
    [anon_sym_new] = ACTIONS(705),
    [anon_sym_implements] = ACTIONS(705),
    [anon_sym_interface] = ACTIONS(705),
    [anon_sym_private] = ACTIONS(705),
    [anon_sym_protected] = ACTIONS(705),
    [anon_sym_pure] = ACTIONS(705),
    [anon_sym_static] = ACTIONS(705),
    [anon_sym_super] = ACTIONS(705),
    [anon_sym_this] = ACTIONS(705),
    [anon_sym_POUND_LPAREN] = ACTIONS(703),
    [anon_sym_COMMA] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_else] = ACTIONS(705),
    [anon_sym_break] = ACTIONS(705),
    [anon_sym_continue] = ACTIONS(705),
    [anon_sym_switch] = ACTIONS(705),
    [anon_sym_LT_LT_LT] = ACTIONS(703),
    [anon_sym_ATdoc] = ACTIONS(703),
    [anon_sym_do] = ACTIONS(705),
    [anon_sym_day] = ACTIONS(705),
    [anon_sym_hour] = ACTIONS(705),
    [anon_sym_minute] = ACTIONS(705),
    [anon_sym_ms] = ACTIONS(705),
    [anon_sym_samp] = ACTIONS(705),
    [anon_sym_second] = ACTIONS(705),
    [anon_sym_week] = ACTIONS(705),
    [anon_sym_COLON_COLON] = ACTIONS(703),
    [sym_float] = ACTIONS(703),
    [anon_sym_for] = ACTIONS(705),
    [anon_sym_SEMI] = ACTIONS(703),
    [anon_sym_fun] = ACTIONS(705),
    [anon_sym_adc] = ACTIONS(705),
    [anon_sym_blackhole] = ACTIONS(705),
    [anon_sym_dac] = ACTIONS(705),
    [sym_hexidecimal] = ACTIONS(703),
    [anon_sym_PLUS_PLUS] = ACTIONS(703),
    [anon_sym_DASH_DASH] = ACTIONS(705),
    [anon_sym_ATimport] = ACTIONS(703),
    [sym_int] = ACTIONS(705),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(705),
    [anon_sym_me] = ACTIONS(705),
    [anon_sym_BANG] = ACTIONS(705),
    [anon_sym_DASH] = ACTIONS(705),
    [anon_sym_BANG_EQ] = ACTIONS(703),
    [anon_sym_PERCENT] = ACTIONS(705),
    [anon_sym_AMP] = ACTIONS(705),
    [anon_sym_AMP_AMP] = ACTIONS(703),
    [anon_sym_STAR] = ACTIONS(705),
    [anon_sym_PLUS] = ACTIONS(705),
    [anon_sym_SLASH] = ACTIONS(705),
    [anon_sym_LT] = ACTIONS(705),
    [anon_sym_LT_LT] = ACTIONS(705),
    [anon_sym_LT_EQ] = ACTIONS(703),
    [anon_sym_EQ_EQ] = ACTIONS(703),
    [anon_sym_GT] = ACTIONS(705),
    [anon_sym_GT_EQ] = ACTIONS(703),
    [anon_sym_GT_GT] = ACTIONS(703),
    [anon_sym_CARET] = ACTIONS(705),
    [anon_sym_PIPE] = ACTIONS(705),
    [anon_sym_PIPE_PIPE] = ACTIONS(703),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(703),
    [anon_sym_auto] = ACTIONS(705),
    [anon_sym_complex] = ACTIONS(705),
    [anon_sym_dur] = ACTIONS(705),
    [anon_sym_float] = ACTIONS(705),
    [anon_sym_int] = ACTIONS(705),
    [anon_sym_polar] = ACTIONS(705),
    [anon_sym_same] = ACTIONS(705),
    [anon_sym_time] = ACTIONS(705),
    [anon_sym_vec2] = ACTIONS(705),
    [anon_sym_vec3] = ACTIONS(705),
    [anon_sym_vec4] = ACTIONS(705),
    [anon_sym_void] = ACTIONS(705),
    [anon_sym_Event] = ACTIONS(705),
    [anon_sym_Object] = ACTIONS(705),
    [anon_sym_UGen] = ACTIONS(705),
    [anon_sym_array] = ACTIONS(705),
    [anon_sym_string] = ACTIONS(705),
    [anon_sym_AT_LPAREN] = ACTIONS(703),
    [anon_sym_NULL] = ACTIONS(705),
    [anon_sym_maybe] = ACTIONS(705),
    [anon_sym_now] = ACTIONS(705),
    [anon_sym_null] = ACTIONS(705),
    [anon_sym_pi] = ACTIONS(705),
    [anon_sym_return] = ACTIONS(705),
    [anon_sym_DQUOTE] = ACTIONS(703),
    [anon_sym_QMARK] = ACTIONS(703),
    [anon_sym_until] = ACTIONS(705),
    [anon_sym_while] = ACTIONS(705),
  },
  [109] = {
    [ts_builtin_sym_end] = ACTIONS(707),
    [sym_variable_identifier] = ACTIONS(709),
    [anon_sym_LBRACK] = ACTIONS(707),
    [anon_sym_LBRACE] = ACTIONS(707),
    [anon_sym_RBRACE] = ACTIONS(707),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(709),
    [anon_sym_true] = ACTIONS(709),
    [anon_sym_DOLLAR] = ACTIONS(707),
    [anon_sym_SQUOTE] = ACTIONS(707),
    [anon_sym_const] = ACTIONS(709),
    [anon_sym_function] = ACTIONS(709),
    [anon_sym_global] = ACTIONS(709),
    [anon_sym_spork] = ACTIONS(709),
    [anon_sym_LPAREN] = ACTIONS(707),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(707),
    [anon_sym_AMP_EQ_GT] = ACTIONS(707),
    [anon_sym_STAR_EQ_GT] = ACTIONS(707),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(707),
    [anon_sym_DASH_DASH_GT] = ACTIONS(707),
    [anon_sym_DASH_EQ_GT] = ACTIONS(707),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(707),
    [anon_sym_EQ_LT] = ACTIONS(707),
    [anon_sym_EQ_GT] = ACTIONS(707),
    [anon_sym_EQ_CARET] = ACTIONS(707),
    [anon_sym_AT_EQ_GT] = ACTIONS(707),
    [anon_sym_CARET_EQ_GT] = ACTIONS(707),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(707),
    [anon_sym_public] = ACTIONS(709),
    [anon_sym_class] = ACTIONS(709),
    [anon_sym_extends] = ACTIONS(709),
    [sym_class_identifier] = ACTIONS(709),
    [anon_sym_new] = ACTIONS(709),
    [anon_sym_implements] = ACTIONS(709),
    [anon_sym_interface] = ACTIONS(709),
    [anon_sym_private] = ACTIONS(709),
    [anon_sym_protected] = ACTIONS(709),
    [anon_sym_pure] = ACTIONS(709),
    [anon_sym_static] = ACTIONS(709),
    [anon_sym_super] = ACTIONS(709),
    [anon_sym_this] = ACTIONS(709),
    [anon_sym_POUND_LPAREN] = ACTIONS(707),
    [anon_sym_COMMA] = ACTIONS(707),
    [anon_sym_if] = ACTIONS(709),
    [anon_sym_else] = ACTIONS(709),
    [anon_sym_break] = ACTIONS(709),
    [anon_sym_continue] = ACTIONS(709),
    [anon_sym_switch] = ACTIONS(709),
    [anon_sym_LT_LT_LT] = ACTIONS(707),
    [anon_sym_ATdoc] = ACTIONS(707),
    [anon_sym_do] = ACTIONS(709),
    [anon_sym_day] = ACTIONS(709),
    [anon_sym_hour] = ACTIONS(709),
    [anon_sym_minute] = ACTIONS(709),
    [anon_sym_ms] = ACTIONS(709),
    [anon_sym_samp] = ACTIONS(709),
    [anon_sym_second] = ACTIONS(709),
    [anon_sym_week] = ACTIONS(709),
    [anon_sym_COLON_COLON] = ACTIONS(707),
    [sym_float] = ACTIONS(707),
    [anon_sym_for] = ACTIONS(709),
    [anon_sym_SEMI] = ACTIONS(707),
    [anon_sym_fun] = ACTIONS(709),
    [anon_sym_adc] = ACTIONS(709),
    [anon_sym_blackhole] = ACTIONS(709),
    [anon_sym_dac] = ACTIONS(709),
    [sym_hexidecimal] = ACTIONS(707),
    [anon_sym_PLUS_PLUS] = ACTIONS(707),
    [anon_sym_DASH_DASH] = ACTIONS(709),
    [anon_sym_ATimport] = ACTIONS(707),
    [sym_int] = ACTIONS(709),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_me] = ACTIONS(709),
    [anon_sym_BANG] = ACTIONS(709),
    [anon_sym_DASH] = ACTIONS(709),
    [anon_sym_BANG_EQ] = ACTIONS(707),
    [anon_sym_PERCENT] = ACTIONS(709),
    [anon_sym_AMP] = ACTIONS(709),
    [anon_sym_AMP_AMP] = ACTIONS(707),
    [anon_sym_STAR] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(709),
    [anon_sym_SLASH] = ACTIONS(709),
    [anon_sym_LT] = ACTIONS(709),
    [anon_sym_LT_LT] = ACTIONS(709),
    [anon_sym_LT_EQ] = ACTIONS(707),
    [anon_sym_EQ_EQ] = ACTIONS(707),
    [anon_sym_GT] = ACTIONS(709),
    [anon_sym_GT_EQ] = ACTIONS(707),
    [anon_sym_GT_GT] = ACTIONS(707),
    [anon_sym_CARET] = ACTIONS(709),
    [anon_sym_PIPE] = ACTIONS(709),
    [anon_sym_PIPE_PIPE] = ACTIONS(707),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(707),
    [anon_sym_auto] = ACTIONS(709),
    [anon_sym_complex] = ACTIONS(709),
    [anon_sym_dur] = ACTIONS(709),
    [anon_sym_float] = ACTIONS(709),
    [anon_sym_int] = ACTIONS(709),
    [anon_sym_polar] = ACTIONS(709),
    [anon_sym_same] = ACTIONS(709),
    [anon_sym_time] = ACTIONS(709),
    [anon_sym_vec2] = ACTIONS(709),
    [anon_sym_vec3] = ACTIONS(709),
    [anon_sym_vec4] = ACTIONS(709),
    [anon_sym_void] = ACTIONS(709),
    [anon_sym_Event] = ACTIONS(709),
    [anon_sym_Object] = ACTIONS(709),
    [anon_sym_UGen] = ACTIONS(709),
    [anon_sym_array] = ACTIONS(709),
    [anon_sym_string] = ACTIONS(709),
    [anon_sym_AT_LPAREN] = ACTIONS(707),
    [anon_sym_NULL] = ACTIONS(709),
    [anon_sym_maybe] = ACTIONS(709),
    [anon_sym_now] = ACTIONS(709),
    [anon_sym_null] = ACTIONS(709),
    [anon_sym_pi] = ACTIONS(709),
    [anon_sym_return] = ACTIONS(709),
    [anon_sym_DQUOTE] = ACTIONS(707),
    [anon_sym_QMARK] = ACTIONS(707),
    [anon_sym_until] = ACTIONS(709),
    [anon_sym_while] = ACTIONS(709),
  },
  [110] = {
    [ts_builtin_sym_end] = ACTIONS(711),
    [sym_variable_identifier] = ACTIONS(713),
    [anon_sym_LBRACK] = ACTIONS(711),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_RBRACE] = ACTIONS(711),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(713),
    [anon_sym_true] = ACTIONS(713),
    [anon_sym_DOLLAR] = ACTIONS(711),
    [anon_sym_SQUOTE] = ACTIONS(711),
    [anon_sym_const] = ACTIONS(713),
    [anon_sym_function] = ACTIONS(713),
    [anon_sym_global] = ACTIONS(713),
    [anon_sym_spork] = ACTIONS(713),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(711),
    [anon_sym_AMP_EQ_GT] = ACTIONS(711),
    [anon_sym_STAR_EQ_GT] = ACTIONS(711),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(711),
    [anon_sym_DASH_DASH_GT] = ACTIONS(711),
    [anon_sym_DASH_EQ_GT] = ACTIONS(711),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(711),
    [anon_sym_EQ_LT] = ACTIONS(711),
    [anon_sym_EQ_GT] = ACTIONS(711),
    [anon_sym_EQ_CARET] = ACTIONS(711),
    [anon_sym_AT_EQ_GT] = ACTIONS(711),
    [anon_sym_CARET_EQ_GT] = ACTIONS(711),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(711),
    [anon_sym_public] = ACTIONS(713),
    [anon_sym_class] = ACTIONS(713),
    [anon_sym_extends] = ACTIONS(713),
    [sym_class_identifier] = ACTIONS(713),
    [anon_sym_new] = ACTIONS(713),
    [anon_sym_implements] = ACTIONS(713),
    [anon_sym_interface] = ACTIONS(713),
    [anon_sym_private] = ACTIONS(713),
    [anon_sym_protected] = ACTIONS(713),
    [anon_sym_pure] = ACTIONS(713),
    [anon_sym_static] = ACTIONS(713),
    [anon_sym_super] = ACTIONS(713),
    [anon_sym_this] = ACTIONS(713),
    [anon_sym_POUND_LPAREN] = ACTIONS(711),
    [anon_sym_COMMA] = ACTIONS(711),
    [anon_sym_if] = ACTIONS(713),
    [anon_sym_else] = ACTIONS(713),
    [anon_sym_break] = ACTIONS(713),
    [anon_sym_continue] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(713),
    [anon_sym_LT_LT_LT] = ACTIONS(711),
    [anon_sym_ATdoc] = ACTIONS(711),
    [anon_sym_do] = ACTIONS(713),
    [anon_sym_day] = ACTIONS(713),
    [anon_sym_hour] = ACTIONS(713),
    [anon_sym_minute] = ACTIONS(713),
    [anon_sym_ms] = ACTIONS(713),
    [anon_sym_samp] = ACTIONS(713),
    [anon_sym_second] = ACTIONS(713),
    [anon_sym_week] = ACTIONS(713),
    [anon_sym_COLON_COLON] = ACTIONS(711),
    [sym_float] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_SEMI] = ACTIONS(711),
    [anon_sym_fun] = ACTIONS(713),
    [anon_sym_adc] = ACTIONS(713),
    [anon_sym_blackhole] = ACTIONS(713),
    [anon_sym_dac] = ACTIONS(713),
    [sym_hexidecimal] = ACTIONS(711),
    [anon_sym_PLUS_PLUS] = ACTIONS(711),
    [anon_sym_DASH_DASH] = ACTIONS(713),
    [anon_sym_ATimport] = ACTIONS(711),
    [sym_int] = ACTIONS(713),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(713),
    [anon_sym_me] = ACTIONS(713),
    [anon_sym_BANG] = ACTIONS(713),
    [anon_sym_DASH] = ACTIONS(713),
    [anon_sym_BANG_EQ] = ACTIONS(711),
    [anon_sym_PERCENT] = ACTIONS(713),
    [anon_sym_AMP] = ACTIONS(713),
    [anon_sym_AMP_AMP] = ACTIONS(711),
    [anon_sym_STAR] = ACTIONS(713),
    [anon_sym_PLUS] = ACTIONS(713),
    [anon_sym_SLASH] = ACTIONS(713),
    [anon_sym_LT] = ACTIONS(713),
    [anon_sym_LT_LT] = ACTIONS(713),
    [anon_sym_LT_EQ] = ACTIONS(711),
    [anon_sym_EQ_EQ] = ACTIONS(711),
    [anon_sym_GT] = ACTIONS(713),
    [anon_sym_GT_EQ] = ACTIONS(711),
    [anon_sym_GT_GT] = ACTIONS(711),
    [anon_sym_CARET] = ACTIONS(713),
    [anon_sym_PIPE] = ACTIONS(713),
    [anon_sym_PIPE_PIPE] = ACTIONS(711),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(711),
    [anon_sym_auto] = ACTIONS(713),
    [anon_sym_complex] = ACTIONS(713),
    [anon_sym_dur] = ACTIONS(713),
    [anon_sym_float] = ACTIONS(713),
    [anon_sym_int] = ACTIONS(713),
    [anon_sym_polar] = ACTIONS(713),
    [anon_sym_same] = ACTIONS(713),
    [anon_sym_time] = ACTIONS(713),
    [anon_sym_vec2] = ACTIONS(713),
    [anon_sym_vec3] = ACTIONS(713),
    [anon_sym_vec4] = ACTIONS(713),
    [anon_sym_void] = ACTIONS(713),
    [anon_sym_Event] = ACTIONS(713),
    [anon_sym_Object] = ACTIONS(713),
    [anon_sym_UGen] = ACTIONS(713),
    [anon_sym_array] = ACTIONS(713),
    [anon_sym_string] = ACTIONS(713),
    [anon_sym_AT_LPAREN] = ACTIONS(711),
    [anon_sym_NULL] = ACTIONS(713),
    [anon_sym_maybe] = ACTIONS(713),
    [anon_sym_now] = ACTIONS(713),
    [anon_sym_null] = ACTIONS(713),
    [anon_sym_pi] = ACTIONS(713),
    [anon_sym_return] = ACTIONS(713),
    [anon_sym_DQUOTE] = ACTIONS(711),
    [anon_sym_QMARK] = ACTIONS(711),
    [anon_sym_until] = ACTIONS(713),
    [anon_sym_while] = ACTIONS(713),
  },
  [111] = {
    [ts_builtin_sym_end] = ACTIONS(715),
    [sym_variable_identifier] = ACTIONS(717),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_LBRACE] = ACTIONS(715),
    [anon_sym_RBRACE] = ACTIONS(715),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(717),
    [anon_sym_true] = ACTIONS(717),
    [anon_sym_DOLLAR] = ACTIONS(715),
    [anon_sym_SQUOTE] = ACTIONS(715),
    [anon_sym_const] = ACTIONS(717),
    [anon_sym_function] = ACTIONS(717),
    [anon_sym_global] = ACTIONS(717),
    [anon_sym_spork] = ACTIONS(717),
    [anon_sym_LPAREN] = ACTIONS(715),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(715),
    [anon_sym_AMP_EQ_GT] = ACTIONS(715),
    [anon_sym_STAR_EQ_GT] = ACTIONS(715),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(715),
    [anon_sym_DASH_DASH_GT] = ACTIONS(715),
    [anon_sym_DASH_EQ_GT] = ACTIONS(715),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(715),
    [anon_sym_EQ_LT] = ACTIONS(715),
    [anon_sym_EQ_GT] = ACTIONS(715),
    [anon_sym_EQ_CARET] = ACTIONS(715),
    [anon_sym_AT_EQ_GT] = ACTIONS(715),
    [anon_sym_CARET_EQ_GT] = ACTIONS(715),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(715),
    [anon_sym_public] = ACTIONS(717),
    [anon_sym_class] = ACTIONS(717),
    [anon_sym_extends] = ACTIONS(717),
    [sym_class_identifier] = ACTIONS(717),
    [anon_sym_new] = ACTIONS(717),
    [anon_sym_implements] = ACTIONS(717),
    [anon_sym_interface] = ACTIONS(717),
    [anon_sym_private] = ACTIONS(717),
    [anon_sym_protected] = ACTIONS(717),
    [anon_sym_pure] = ACTIONS(717),
    [anon_sym_static] = ACTIONS(717),
    [anon_sym_super] = ACTIONS(717),
    [anon_sym_this] = ACTIONS(717),
    [anon_sym_POUND_LPAREN] = ACTIONS(715),
    [anon_sym_COMMA] = ACTIONS(715),
    [anon_sym_if] = ACTIONS(717),
    [anon_sym_break] = ACTIONS(717),
    [anon_sym_continue] = ACTIONS(717),
    [anon_sym_switch] = ACTIONS(717),
    [anon_sym_LT_LT_LT] = ACTIONS(715),
    [anon_sym_ATdoc] = ACTIONS(715),
    [anon_sym_do] = ACTIONS(717),
    [anon_sym_day] = ACTIONS(717),
    [anon_sym_hour] = ACTIONS(717),
    [anon_sym_minute] = ACTIONS(717),
    [anon_sym_ms] = ACTIONS(717),
    [anon_sym_samp] = ACTIONS(717),
    [anon_sym_second] = ACTIONS(717),
    [anon_sym_week] = ACTIONS(717),
    [anon_sym_COLON_COLON] = ACTIONS(715),
    [sym_float] = ACTIONS(715),
    [anon_sym_for] = ACTIONS(717),
    [anon_sym_SEMI] = ACTIONS(715),
    [anon_sym_fun] = ACTIONS(717),
    [anon_sym_adc] = ACTIONS(717),
    [anon_sym_blackhole] = ACTIONS(717),
    [anon_sym_dac] = ACTIONS(717),
    [sym_hexidecimal] = ACTIONS(715),
    [anon_sym_PLUS_PLUS] = ACTIONS(715),
    [anon_sym_DASH_DASH] = ACTIONS(717),
    [anon_sym_ATimport] = ACTIONS(715),
    [sym_int] = ACTIONS(717),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(717),
    [anon_sym_me] = ACTIONS(717),
    [anon_sym_BANG] = ACTIONS(717),
    [anon_sym_DASH] = ACTIONS(717),
    [anon_sym_BANG_EQ] = ACTIONS(715),
    [anon_sym_PERCENT] = ACTIONS(717),
    [anon_sym_AMP] = ACTIONS(717),
    [anon_sym_AMP_AMP] = ACTIONS(715),
    [anon_sym_STAR] = ACTIONS(717),
    [anon_sym_PLUS] = ACTIONS(717),
    [anon_sym_SLASH] = ACTIONS(717),
    [anon_sym_LT] = ACTIONS(717),
    [anon_sym_LT_LT] = ACTIONS(717),
    [anon_sym_LT_EQ] = ACTIONS(715),
    [anon_sym_EQ_EQ] = ACTIONS(715),
    [anon_sym_GT] = ACTIONS(717),
    [anon_sym_GT_EQ] = ACTIONS(715),
    [anon_sym_GT_GT] = ACTIONS(715),
    [anon_sym_CARET] = ACTIONS(717),
    [anon_sym_PIPE] = ACTIONS(717),
    [anon_sym_PIPE_PIPE] = ACTIONS(715),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(715),
    [anon_sym_auto] = ACTIONS(717),
    [anon_sym_complex] = ACTIONS(717),
    [anon_sym_dur] = ACTIONS(717),
    [anon_sym_float] = ACTIONS(717),
    [anon_sym_int] = ACTIONS(717),
    [anon_sym_polar] = ACTIONS(717),
    [anon_sym_same] = ACTIONS(717),
    [anon_sym_time] = ACTIONS(717),
    [anon_sym_vec2] = ACTIONS(717),
    [anon_sym_vec3] = ACTIONS(717),
    [anon_sym_vec4] = ACTIONS(717),
    [anon_sym_void] = ACTIONS(717),
    [anon_sym_Event] = ACTIONS(717),
    [anon_sym_Object] = ACTIONS(717),
    [anon_sym_UGen] = ACTIONS(717),
    [anon_sym_array] = ACTIONS(717),
    [anon_sym_string] = ACTIONS(717),
    [anon_sym_AT_LPAREN] = ACTIONS(715),
    [anon_sym_NULL] = ACTIONS(717),
    [anon_sym_maybe] = ACTIONS(717),
    [anon_sym_now] = ACTIONS(717),
    [anon_sym_null] = ACTIONS(717),
    [anon_sym_pi] = ACTIONS(717),
    [anon_sym_return] = ACTIONS(717),
    [anon_sym_DQUOTE] = ACTIONS(715),
    [anon_sym_QMARK] = ACTIONS(715),
    [anon_sym_until] = ACTIONS(717),
    [anon_sym_while] = ACTIONS(717),
  },
  [112] = {
    [ts_builtin_sym_end] = ACTIONS(719),
    [sym_variable_identifier] = ACTIONS(721),
    [anon_sym_LBRACK] = ACTIONS(719),
    [anon_sym_LBRACE] = ACTIONS(719),
    [anon_sym_RBRACE] = ACTIONS(719),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(721),
    [anon_sym_true] = ACTIONS(721),
    [anon_sym_DOLLAR] = ACTIONS(719),
    [anon_sym_SQUOTE] = ACTIONS(719),
    [anon_sym_const] = ACTIONS(721),
    [anon_sym_function] = ACTIONS(721),
    [anon_sym_global] = ACTIONS(721),
    [anon_sym_spork] = ACTIONS(721),
    [anon_sym_LPAREN] = ACTIONS(719),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(719),
    [anon_sym_AMP_EQ_GT] = ACTIONS(719),
    [anon_sym_STAR_EQ_GT] = ACTIONS(719),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(719),
    [anon_sym_DASH_DASH_GT] = ACTIONS(719),
    [anon_sym_DASH_EQ_GT] = ACTIONS(719),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(719),
    [anon_sym_EQ_LT] = ACTIONS(719),
    [anon_sym_EQ_GT] = ACTIONS(719),
    [anon_sym_EQ_CARET] = ACTIONS(719),
    [anon_sym_AT_EQ_GT] = ACTIONS(719),
    [anon_sym_CARET_EQ_GT] = ACTIONS(719),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(719),
    [anon_sym_public] = ACTIONS(721),
    [anon_sym_class] = ACTIONS(721),
    [anon_sym_extends] = ACTIONS(721),
    [sym_class_identifier] = ACTIONS(721),
    [anon_sym_new] = ACTIONS(721),
    [anon_sym_implements] = ACTIONS(721),
    [anon_sym_interface] = ACTIONS(721),
    [anon_sym_private] = ACTIONS(721),
    [anon_sym_protected] = ACTIONS(721),
    [anon_sym_pure] = ACTIONS(721),
    [anon_sym_static] = ACTIONS(721),
    [anon_sym_super] = ACTIONS(721),
    [anon_sym_this] = ACTIONS(721),
    [anon_sym_POUND_LPAREN] = ACTIONS(719),
    [anon_sym_COMMA] = ACTIONS(719),
    [anon_sym_if] = ACTIONS(721),
    [anon_sym_break] = ACTIONS(721),
    [anon_sym_continue] = ACTIONS(721),
    [anon_sym_switch] = ACTIONS(721),
    [anon_sym_LT_LT_LT] = ACTIONS(719),
    [anon_sym_ATdoc] = ACTIONS(719),
    [anon_sym_do] = ACTIONS(721),
    [anon_sym_day] = ACTIONS(721),
    [anon_sym_hour] = ACTIONS(721),
    [anon_sym_minute] = ACTIONS(721),
    [anon_sym_ms] = ACTIONS(721),
    [anon_sym_samp] = ACTIONS(721),
    [anon_sym_second] = ACTIONS(721),
    [anon_sym_week] = ACTIONS(721),
    [anon_sym_COLON_COLON] = ACTIONS(719),
    [sym_float] = ACTIONS(719),
    [anon_sym_for] = ACTIONS(721),
    [anon_sym_SEMI] = ACTIONS(719),
    [anon_sym_fun] = ACTIONS(721),
    [anon_sym_adc] = ACTIONS(721),
    [anon_sym_blackhole] = ACTIONS(721),
    [anon_sym_dac] = ACTIONS(721),
    [sym_hexidecimal] = ACTIONS(719),
    [anon_sym_PLUS_PLUS] = ACTIONS(719),
    [anon_sym_DASH_DASH] = ACTIONS(721),
    [anon_sym_ATimport] = ACTIONS(719),
    [sym_int] = ACTIONS(721),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(721),
    [anon_sym_me] = ACTIONS(721),
    [anon_sym_BANG] = ACTIONS(721),
    [anon_sym_DASH] = ACTIONS(721),
    [anon_sym_BANG_EQ] = ACTIONS(719),
    [anon_sym_PERCENT] = ACTIONS(721),
    [anon_sym_AMP] = ACTIONS(721),
    [anon_sym_AMP_AMP] = ACTIONS(719),
    [anon_sym_STAR] = ACTIONS(721),
    [anon_sym_PLUS] = ACTIONS(721),
    [anon_sym_SLASH] = ACTIONS(721),
    [anon_sym_LT] = ACTIONS(721),
    [anon_sym_LT_LT] = ACTIONS(721),
    [anon_sym_LT_EQ] = ACTIONS(719),
    [anon_sym_EQ_EQ] = ACTIONS(719),
    [anon_sym_GT] = ACTIONS(721),
    [anon_sym_GT_EQ] = ACTIONS(719),
    [anon_sym_GT_GT] = ACTIONS(719),
    [anon_sym_CARET] = ACTIONS(721),
    [anon_sym_PIPE] = ACTIONS(721),
    [anon_sym_PIPE_PIPE] = ACTIONS(719),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(719),
    [anon_sym_auto] = ACTIONS(721),
    [anon_sym_complex] = ACTIONS(721),
    [anon_sym_dur] = ACTIONS(721),
    [anon_sym_float] = ACTIONS(721),
    [anon_sym_int] = ACTIONS(721),
    [anon_sym_polar] = ACTIONS(721),
    [anon_sym_same] = ACTIONS(721),
    [anon_sym_time] = ACTIONS(721),
    [anon_sym_vec2] = ACTIONS(721),
    [anon_sym_vec3] = ACTIONS(721),
    [anon_sym_vec4] = ACTIONS(721),
    [anon_sym_void] = ACTIONS(721),
    [anon_sym_Event] = ACTIONS(721),
    [anon_sym_Object] = ACTIONS(721),
    [anon_sym_UGen] = ACTIONS(721),
    [anon_sym_array] = ACTIONS(721),
    [anon_sym_string] = ACTIONS(721),
    [anon_sym_AT_LPAREN] = ACTIONS(719),
    [anon_sym_NULL] = ACTIONS(721),
    [anon_sym_maybe] = ACTIONS(721),
    [anon_sym_now] = ACTIONS(721),
    [anon_sym_null] = ACTIONS(721),
    [anon_sym_pi] = ACTIONS(721),
    [anon_sym_return] = ACTIONS(721),
    [anon_sym_DQUOTE] = ACTIONS(719),
    [anon_sym_QMARK] = ACTIONS(719),
    [anon_sym_until] = ACTIONS(721),
    [anon_sym_while] = ACTIONS(721),
  },
  [113] = {
    [ts_builtin_sym_end] = ACTIONS(723),
    [sym_variable_identifier] = ACTIONS(725),
    [anon_sym_LBRACK] = ACTIONS(723),
    [anon_sym_LBRACE] = ACTIONS(723),
    [anon_sym_RBRACE] = ACTIONS(723),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(725),
    [anon_sym_true] = ACTIONS(725),
    [anon_sym_DOLLAR] = ACTIONS(723),
    [anon_sym_SQUOTE] = ACTIONS(723),
    [anon_sym_const] = ACTIONS(725),
    [anon_sym_function] = ACTIONS(725),
    [anon_sym_global] = ACTIONS(725),
    [anon_sym_spork] = ACTIONS(725),
    [anon_sym_LPAREN] = ACTIONS(723),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(723),
    [anon_sym_AMP_EQ_GT] = ACTIONS(723),
    [anon_sym_STAR_EQ_GT] = ACTIONS(723),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(723),
    [anon_sym_DASH_DASH_GT] = ACTIONS(723),
    [anon_sym_DASH_EQ_GT] = ACTIONS(723),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(723),
    [anon_sym_EQ_LT] = ACTIONS(723),
    [anon_sym_EQ_GT] = ACTIONS(723),
    [anon_sym_EQ_CARET] = ACTIONS(723),
    [anon_sym_AT_EQ_GT] = ACTIONS(723),
    [anon_sym_CARET_EQ_GT] = ACTIONS(723),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(723),
    [anon_sym_public] = ACTIONS(725),
    [anon_sym_class] = ACTIONS(725),
    [anon_sym_extends] = ACTIONS(725),
    [sym_class_identifier] = ACTIONS(725),
    [anon_sym_new] = ACTIONS(725),
    [anon_sym_implements] = ACTIONS(725),
    [anon_sym_interface] = ACTIONS(725),
    [anon_sym_private] = ACTIONS(725),
    [anon_sym_protected] = ACTIONS(725),
    [anon_sym_pure] = ACTIONS(725),
    [anon_sym_static] = ACTIONS(725),
    [anon_sym_super] = ACTIONS(725),
    [anon_sym_this] = ACTIONS(725),
    [anon_sym_POUND_LPAREN] = ACTIONS(723),
    [anon_sym_COMMA] = ACTIONS(723),
    [anon_sym_if] = ACTIONS(725),
    [anon_sym_break] = ACTIONS(725),
    [anon_sym_continue] = ACTIONS(725),
    [anon_sym_switch] = ACTIONS(725),
    [anon_sym_LT_LT_LT] = ACTIONS(723),
    [anon_sym_ATdoc] = ACTIONS(723),
    [anon_sym_do] = ACTIONS(725),
    [anon_sym_day] = ACTIONS(725),
    [anon_sym_hour] = ACTIONS(725),
    [anon_sym_minute] = ACTIONS(725),
    [anon_sym_ms] = ACTIONS(725),
    [anon_sym_samp] = ACTIONS(725),
    [anon_sym_second] = ACTIONS(725),
    [anon_sym_week] = ACTIONS(725),
    [anon_sym_COLON_COLON] = ACTIONS(723),
    [sym_float] = ACTIONS(723),
    [anon_sym_for] = ACTIONS(725),
    [anon_sym_SEMI] = ACTIONS(723),
    [anon_sym_fun] = ACTIONS(725),
    [anon_sym_adc] = ACTIONS(725),
    [anon_sym_blackhole] = ACTIONS(725),
    [anon_sym_dac] = ACTIONS(725),
    [sym_hexidecimal] = ACTIONS(723),
    [anon_sym_PLUS_PLUS] = ACTIONS(723),
    [anon_sym_DASH_DASH] = ACTIONS(725),
    [anon_sym_ATimport] = ACTIONS(723),
    [sym_int] = ACTIONS(725),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(725),
    [anon_sym_me] = ACTIONS(725),
    [anon_sym_BANG] = ACTIONS(725),
    [anon_sym_DASH] = ACTIONS(725),
    [anon_sym_BANG_EQ] = ACTIONS(723),
    [anon_sym_PERCENT] = ACTIONS(725),
    [anon_sym_AMP] = ACTIONS(725),
    [anon_sym_AMP_AMP] = ACTIONS(723),
    [anon_sym_STAR] = ACTIONS(725),
    [anon_sym_PLUS] = ACTIONS(725),
    [anon_sym_SLASH] = ACTIONS(725),
    [anon_sym_LT] = ACTIONS(725),
    [anon_sym_LT_LT] = ACTIONS(725),
    [anon_sym_LT_EQ] = ACTIONS(723),
    [anon_sym_EQ_EQ] = ACTIONS(723),
    [anon_sym_GT] = ACTIONS(725),
    [anon_sym_GT_EQ] = ACTIONS(723),
    [anon_sym_GT_GT] = ACTIONS(723),
    [anon_sym_CARET] = ACTIONS(725),
    [anon_sym_PIPE] = ACTIONS(725),
    [anon_sym_PIPE_PIPE] = ACTIONS(723),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(723),
    [anon_sym_auto] = ACTIONS(725),
    [anon_sym_complex] = ACTIONS(725),
    [anon_sym_dur] = ACTIONS(725),
    [anon_sym_float] = ACTIONS(725),
    [anon_sym_int] = ACTIONS(725),
    [anon_sym_polar] = ACTIONS(725),
    [anon_sym_same] = ACTIONS(725),
    [anon_sym_time] = ACTIONS(725),
    [anon_sym_vec2] = ACTIONS(725),
    [anon_sym_vec3] = ACTIONS(725),
    [anon_sym_vec4] = ACTIONS(725),
    [anon_sym_void] = ACTIONS(725),
    [anon_sym_Event] = ACTIONS(725),
    [anon_sym_Object] = ACTIONS(725),
    [anon_sym_UGen] = ACTIONS(725),
    [anon_sym_array] = ACTIONS(725),
    [anon_sym_string] = ACTIONS(725),
    [anon_sym_AT_LPAREN] = ACTIONS(723),
    [anon_sym_NULL] = ACTIONS(725),
    [anon_sym_maybe] = ACTIONS(725),
    [anon_sym_now] = ACTIONS(725),
    [anon_sym_null] = ACTIONS(725),
    [anon_sym_pi] = ACTIONS(725),
    [anon_sym_return] = ACTIONS(725),
    [anon_sym_DQUOTE] = ACTIONS(723),
    [anon_sym_QMARK] = ACTIONS(723),
    [anon_sym_until] = ACTIONS(725),
    [anon_sym_while] = ACTIONS(725),
  },
  [114] = {
    [ts_builtin_sym_end] = ACTIONS(727),
    [sym_variable_identifier] = ACTIONS(729),
    [anon_sym_LBRACK] = ACTIONS(727),
    [anon_sym_LBRACE] = ACTIONS(727),
    [anon_sym_RBRACE] = ACTIONS(727),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(729),
    [anon_sym_true] = ACTIONS(729),
    [anon_sym_DOLLAR] = ACTIONS(727),
    [anon_sym_SQUOTE] = ACTIONS(727),
    [anon_sym_const] = ACTIONS(729),
    [anon_sym_function] = ACTIONS(729),
    [anon_sym_global] = ACTIONS(729),
    [anon_sym_spork] = ACTIONS(729),
    [anon_sym_LPAREN] = ACTIONS(727),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(727),
    [anon_sym_AMP_EQ_GT] = ACTIONS(727),
    [anon_sym_STAR_EQ_GT] = ACTIONS(727),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(727),
    [anon_sym_DASH_DASH_GT] = ACTIONS(727),
    [anon_sym_DASH_EQ_GT] = ACTIONS(727),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(727),
    [anon_sym_EQ_LT] = ACTIONS(727),
    [anon_sym_EQ_GT] = ACTIONS(727),
    [anon_sym_EQ_CARET] = ACTIONS(727),
    [anon_sym_AT_EQ_GT] = ACTIONS(727),
    [anon_sym_CARET_EQ_GT] = ACTIONS(727),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(727),
    [anon_sym_public] = ACTIONS(729),
    [anon_sym_class] = ACTIONS(729),
    [anon_sym_extends] = ACTIONS(729),
    [sym_class_identifier] = ACTIONS(729),
    [anon_sym_new] = ACTIONS(729),
    [anon_sym_implements] = ACTIONS(729),
    [anon_sym_interface] = ACTIONS(729),
    [anon_sym_private] = ACTIONS(729),
    [anon_sym_protected] = ACTIONS(729),
    [anon_sym_pure] = ACTIONS(729),
    [anon_sym_static] = ACTIONS(729),
    [anon_sym_super] = ACTIONS(729),
    [anon_sym_this] = ACTIONS(729),
    [anon_sym_POUND_LPAREN] = ACTIONS(727),
    [anon_sym_COMMA] = ACTIONS(727),
    [anon_sym_if] = ACTIONS(729),
    [anon_sym_break] = ACTIONS(729),
    [anon_sym_continue] = ACTIONS(729),
    [anon_sym_switch] = ACTIONS(729),
    [anon_sym_LT_LT_LT] = ACTIONS(727),
    [anon_sym_ATdoc] = ACTIONS(727),
    [anon_sym_do] = ACTIONS(729),
    [anon_sym_day] = ACTIONS(729),
    [anon_sym_hour] = ACTIONS(729),
    [anon_sym_minute] = ACTIONS(729),
    [anon_sym_ms] = ACTIONS(729),
    [anon_sym_samp] = ACTIONS(729),
    [anon_sym_second] = ACTIONS(729),
    [anon_sym_week] = ACTIONS(729),
    [anon_sym_COLON_COLON] = ACTIONS(727),
    [sym_float] = ACTIONS(727),
    [anon_sym_for] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(727),
    [anon_sym_fun] = ACTIONS(729),
    [anon_sym_adc] = ACTIONS(729),
    [anon_sym_blackhole] = ACTIONS(729),
    [anon_sym_dac] = ACTIONS(729),
    [sym_hexidecimal] = ACTIONS(727),
    [anon_sym_PLUS_PLUS] = ACTIONS(727),
    [anon_sym_DASH_DASH] = ACTIONS(729),
    [anon_sym_ATimport] = ACTIONS(727),
    [sym_int] = ACTIONS(729),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(729),
    [anon_sym_me] = ACTIONS(729),
    [anon_sym_BANG] = ACTIONS(729),
    [anon_sym_DASH] = ACTIONS(729),
    [anon_sym_BANG_EQ] = ACTIONS(727),
    [anon_sym_PERCENT] = ACTIONS(729),
    [anon_sym_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(727),
    [anon_sym_STAR] = ACTIONS(729),
    [anon_sym_PLUS] = ACTIONS(729),
    [anon_sym_SLASH] = ACTIONS(729),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_LT_LT] = ACTIONS(729),
    [anon_sym_LT_EQ] = ACTIONS(727),
    [anon_sym_EQ_EQ] = ACTIONS(727),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_GT_EQ] = ACTIONS(727),
    [anon_sym_GT_GT] = ACTIONS(727),
    [anon_sym_CARET] = ACTIONS(729),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(727),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(727),
    [anon_sym_auto] = ACTIONS(729),
    [anon_sym_complex] = ACTIONS(729),
    [anon_sym_dur] = ACTIONS(729),
    [anon_sym_float] = ACTIONS(729),
    [anon_sym_int] = ACTIONS(729),
    [anon_sym_polar] = ACTIONS(729),
    [anon_sym_same] = ACTIONS(729),
    [anon_sym_time] = ACTIONS(729),
    [anon_sym_vec2] = ACTIONS(729),
    [anon_sym_vec3] = ACTIONS(729),
    [anon_sym_vec4] = ACTIONS(729),
    [anon_sym_void] = ACTIONS(729),
    [anon_sym_Event] = ACTIONS(729),
    [anon_sym_Object] = ACTIONS(729),
    [anon_sym_UGen] = ACTIONS(729),
    [anon_sym_array] = ACTIONS(729),
    [anon_sym_string] = ACTIONS(729),
    [anon_sym_AT_LPAREN] = ACTIONS(727),
    [anon_sym_NULL] = ACTIONS(729),
    [anon_sym_maybe] = ACTIONS(729),
    [anon_sym_now] = ACTIONS(729),
    [anon_sym_null] = ACTIONS(729),
    [anon_sym_pi] = ACTIONS(729),
    [anon_sym_return] = ACTIONS(729),
    [anon_sym_DQUOTE] = ACTIONS(727),
    [anon_sym_QMARK] = ACTIONS(727),
    [anon_sym_until] = ACTIONS(729),
    [anon_sym_while] = ACTIONS(729),
  },
  [115] = {
    [ts_builtin_sym_end] = ACTIONS(731),
    [sym_variable_identifier] = ACTIONS(733),
    [anon_sym_LBRACK] = ACTIONS(731),
    [anon_sym_LBRACE] = ACTIONS(731),
    [anon_sym_RBRACE] = ACTIONS(731),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(733),
    [anon_sym_true] = ACTIONS(733),
    [anon_sym_DOLLAR] = ACTIONS(731),
    [anon_sym_SQUOTE] = ACTIONS(731),
    [anon_sym_const] = ACTIONS(733),
    [anon_sym_function] = ACTIONS(733),
    [anon_sym_global] = ACTIONS(733),
    [anon_sym_spork] = ACTIONS(733),
    [anon_sym_LPAREN] = ACTIONS(731),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(731),
    [anon_sym_AMP_EQ_GT] = ACTIONS(731),
    [anon_sym_STAR_EQ_GT] = ACTIONS(731),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(731),
    [anon_sym_DASH_DASH_GT] = ACTIONS(731),
    [anon_sym_DASH_EQ_GT] = ACTIONS(731),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(731),
    [anon_sym_EQ_LT] = ACTIONS(731),
    [anon_sym_EQ_GT] = ACTIONS(731),
    [anon_sym_EQ_CARET] = ACTIONS(731),
    [anon_sym_AT_EQ_GT] = ACTIONS(731),
    [anon_sym_CARET_EQ_GT] = ACTIONS(731),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(731),
    [anon_sym_public] = ACTIONS(733),
    [anon_sym_class] = ACTIONS(733),
    [anon_sym_extends] = ACTIONS(733),
    [sym_class_identifier] = ACTIONS(733),
    [anon_sym_new] = ACTIONS(733),
    [anon_sym_implements] = ACTIONS(733),
    [anon_sym_interface] = ACTIONS(733),
    [anon_sym_private] = ACTIONS(733),
    [anon_sym_protected] = ACTIONS(733),
    [anon_sym_pure] = ACTIONS(733),
    [anon_sym_static] = ACTIONS(733),
    [anon_sym_super] = ACTIONS(733),
    [anon_sym_this] = ACTIONS(733),
    [anon_sym_POUND_LPAREN] = ACTIONS(731),
    [anon_sym_COMMA] = ACTIONS(731),
    [anon_sym_if] = ACTIONS(733),
    [anon_sym_break] = ACTIONS(733),
    [anon_sym_continue] = ACTIONS(733),
    [anon_sym_switch] = ACTIONS(733),
    [anon_sym_LT_LT_LT] = ACTIONS(731),
    [anon_sym_ATdoc] = ACTIONS(731),
    [anon_sym_do] = ACTIONS(733),
    [anon_sym_day] = ACTIONS(733),
    [anon_sym_hour] = ACTIONS(733),
    [anon_sym_minute] = ACTIONS(733),
    [anon_sym_ms] = ACTIONS(733),
    [anon_sym_samp] = ACTIONS(733),
    [anon_sym_second] = ACTIONS(733),
    [anon_sym_week] = ACTIONS(733),
    [anon_sym_COLON_COLON] = ACTIONS(731),
    [sym_float] = ACTIONS(731),
    [anon_sym_for] = ACTIONS(733),
    [anon_sym_SEMI] = ACTIONS(731),
    [anon_sym_fun] = ACTIONS(733),
    [anon_sym_adc] = ACTIONS(733),
    [anon_sym_blackhole] = ACTIONS(733),
    [anon_sym_dac] = ACTIONS(733),
    [sym_hexidecimal] = ACTIONS(731),
    [anon_sym_PLUS_PLUS] = ACTIONS(731),
    [anon_sym_DASH_DASH] = ACTIONS(733),
    [anon_sym_ATimport] = ACTIONS(731),
    [sym_int] = ACTIONS(733),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(733),
    [anon_sym_me] = ACTIONS(733),
    [anon_sym_BANG] = ACTIONS(733),
    [anon_sym_DASH] = ACTIONS(733),
    [anon_sym_BANG_EQ] = ACTIONS(731),
    [anon_sym_PERCENT] = ACTIONS(733),
    [anon_sym_AMP] = ACTIONS(733),
    [anon_sym_AMP_AMP] = ACTIONS(731),
    [anon_sym_STAR] = ACTIONS(733),
    [anon_sym_PLUS] = ACTIONS(733),
    [anon_sym_SLASH] = ACTIONS(733),
    [anon_sym_LT] = ACTIONS(733),
    [anon_sym_LT_LT] = ACTIONS(733),
    [anon_sym_LT_EQ] = ACTIONS(731),
    [anon_sym_EQ_EQ] = ACTIONS(731),
    [anon_sym_GT] = ACTIONS(733),
    [anon_sym_GT_EQ] = ACTIONS(731),
    [anon_sym_GT_GT] = ACTIONS(731),
    [anon_sym_CARET] = ACTIONS(733),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_PIPE_PIPE] = ACTIONS(731),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(731),
    [anon_sym_auto] = ACTIONS(733),
    [anon_sym_complex] = ACTIONS(733),
    [anon_sym_dur] = ACTIONS(733),
    [anon_sym_float] = ACTIONS(733),
    [anon_sym_int] = ACTIONS(733),
    [anon_sym_polar] = ACTIONS(733),
    [anon_sym_same] = ACTIONS(733),
    [anon_sym_time] = ACTIONS(733),
    [anon_sym_vec2] = ACTIONS(733),
    [anon_sym_vec3] = ACTIONS(733),
    [anon_sym_vec4] = ACTIONS(733),
    [anon_sym_void] = ACTIONS(733),
    [anon_sym_Event] = ACTIONS(733),
    [anon_sym_Object] = ACTIONS(733),
    [anon_sym_UGen] = ACTIONS(733),
    [anon_sym_array] = ACTIONS(733),
    [anon_sym_string] = ACTIONS(733),
    [anon_sym_AT_LPAREN] = ACTIONS(731),
    [anon_sym_NULL] = ACTIONS(733),
    [anon_sym_maybe] = ACTIONS(733),
    [anon_sym_now] = ACTIONS(733),
    [anon_sym_null] = ACTIONS(733),
    [anon_sym_pi] = ACTIONS(733),
    [anon_sym_return] = ACTIONS(733),
    [anon_sym_DQUOTE] = ACTIONS(731),
    [anon_sym_QMARK] = ACTIONS(731),
    [anon_sym_until] = ACTIONS(733),
    [anon_sym_while] = ACTIONS(733),
  },
  [116] = {
    [ts_builtin_sym_end] = ACTIONS(735),
    [sym_variable_identifier] = ACTIONS(737),
    [anon_sym_LBRACK] = ACTIONS(735),
    [anon_sym_LBRACE] = ACTIONS(735),
    [anon_sym_RBRACE] = ACTIONS(735),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(737),
    [anon_sym_true] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(735),
    [anon_sym_SQUOTE] = ACTIONS(735),
    [anon_sym_const] = ACTIONS(737),
    [anon_sym_function] = ACTIONS(737),
    [anon_sym_global] = ACTIONS(737),
    [anon_sym_spork] = ACTIONS(737),
    [anon_sym_LPAREN] = ACTIONS(735),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(735),
    [anon_sym_AMP_EQ_GT] = ACTIONS(735),
    [anon_sym_STAR_EQ_GT] = ACTIONS(735),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(735),
    [anon_sym_DASH_DASH_GT] = ACTIONS(735),
    [anon_sym_DASH_EQ_GT] = ACTIONS(735),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(735),
    [anon_sym_EQ_LT] = ACTIONS(735),
    [anon_sym_EQ_GT] = ACTIONS(735),
    [anon_sym_EQ_CARET] = ACTIONS(735),
    [anon_sym_AT_EQ_GT] = ACTIONS(735),
    [anon_sym_CARET_EQ_GT] = ACTIONS(735),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(735),
    [anon_sym_public] = ACTIONS(737),
    [anon_sym_class] = ACTIONS(737),
    [anon_sym_extends] = ACTIONS(737),
    [sym_class_identifier] = ACTIONS(737),
    [anon_sym_new] = ACTIONS(737),
    [anon_sym_implements] = ACTIONS(737),
    [anon_sym_interface] = ACTIONS(737),
    [anon_sym_private] = ACTIONS(737),
    [anon_sym_protected] = ACTIONS(737),
    [anon_sym_pure] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(737),
    [anon_sym_super] = ACTIONS(737),
    [anon_sym_this] = ACTIONS(737),
    [anon_sym_POUND_LPAREN] = ACTIONS(735),
    [anon_sym_COMMA] = ACTIONS(735),
    [anon_sym_if] = ACTIONS(737),
    [anon_sym_break] = ACTIONS(737),
    [anon_sym_continue] = ACTIONS(737),
    [anon_sym_switch] = ACTIONS(737),
    [anon_sym_LT_LT_LT] = ACTIONS(735),
    [anon_sym_ATdoc] = ACTIONS(735),
    [anon_sym_do] = ACTIONS(737),
    [anon_sym_day] = ACTIONS(737),
    [anon_sym_hour] = ACTIONS(737),
    [anon_sym_minute] = ACTIONS(737),
    [anon_sym_ms] = ACTIONS(737),
    [anon_sym_samp] = ACTIONS(737),
    [anon_sym_second] = ACTIONS(737),
    [anon_sym_week] = ACTIONS(737),
    [anon_sym_COLON_COLON] = ACTIONS(735),
    [sym_float] = ACTIONS(735),
    [anon_sym_for] = ACTIONS(737),
    [anon_sym_SEMI] = ACTIONS(735),
    [anon_sym_fun] = ACTIONS(737),
    [anon_sym_adc] = ACTIONS(737),
    [anon_sym_blackhole] = ACTIONS(737),
    [anon_sym_dac] = ACTIONS(737),
    [sym_hexidecimal] = ACTIONS(735),
    [anon_sym_PLUS_PLUS] = ACTIONS(735),
    [anon_sym_DASH_DASH] = ACTIONS(737),
    [anon_sym_ATimport] = ACTIONS(735),
    [sym_int] = ACTIONS(737),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(737),
    [anon_sym_me] = ACTIONS(737),
    [anon_sym_BANG] = ACTIONS(737),
    [anon_sym_DASH] = ACTIONS(737),
    [anon_sym_BANG_EQ] = ACTIONS(735),
    [anon_sym_PERCENT] = ACTIONS(737),
    [anon_sym_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(735),
    [anon_sym_STAR] = ACTIONS(737),
    [anon_sym_PLUS] = ACTIONS(737),
    [anon_sym_SLASH] = ACTIONS(737),
    [anon_sym_LT] = ACTIONS(737),
    [anon_sym_LT_LT] = ACTIONS(737),
    [anon_sym_LT_EQ] = ACTIONS(735),
    [anon_sym_EQ_EQ] = ACTIONS(735),
    [anon_sym_GT] = ACTIONS(737),
    [anon_sym_GT_EQ] = ACTIONS(735),
    [anon_sym_GT_GT] = ACTIONS(735),
    [anon_sym_CARET] = ACTIONS(737),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(735),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(735),
    [anon_sym_auto] = ACTIONS(737),
    [anon_sym_complex] = ACTIONS(737),
    [anon_sym_dur] = ACTIONS(737),
    [anon_sym_float] = ACTIONS(737),
    [anon_sym_int] = ACTIONS(737),
    [anon_sym_polar] = ACTIONS(737),
    [anon_sym_same] = ACTIONS(737),
    [anon_sym_time] = ACTIONS(737),
    [anon_sym_vec2] = ACTIONS(737),
    [anon_sym_vec3] = ACTIONS(737),
    [anon_sym_vec4] = ACTIONS(737),
    [anon_sym_void] = ACTIONS(737),
    [anon_sym_Event] = ACTIONS(737),
    [anon_sym_Object] = ACTIONS(737),
    [anon_sym_UGen] = ACTIONS(737),
    [anon_sym_array] = ACTIONS(737),
    [anon_sym_string] = ACTIONS(737),
    [anon_sym_AT_LPAREN] = ACTIONS(735),
    [anon_sym_NULL] = ACTIONS(737),
    [anon_sym_maybe] = ACTIONS(737),
    [anon_sym_now] = ACTIONS(737),
    [anon_sym_null] = ACTIONS(737),
    [anon_sym_pi] = ACTIONS(737),
    [anon_sym_return] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(735),
    [anon_sym_QMARK] = ACTIONS(735),
    [anon_sym_until] = ACTIONS(737),
    [anon_sym_while] = ACTIONS(737),
  },
  [117] = {
    [ts_builtin_sym_end] = ACTIONS(735),
    [sym_variable_identifier] = ACTIONS(737),
    [anon_sym_LBRACK] = ACTIONS(735),
    [anon_sym_LBRACE] = ACTIONS(735),
    [anon_sym_RBRACE] = ACTIONS(735),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(737),
    [anon_sym_true] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(739),
    [anon_sym_SQUOTE] = ACTIONS(735),
    [anon_sym_const] = ACTIONS(737),
    [anon_sym_function] = ACTIONS(737),
    [anon_sym_global] = ACTIONS(737),
    [anon_sym_spork] = ACTIONS(737),
    [anon_sym_LPAREN] = ACTIONS(735),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(739),
    [anon_sym_AMP_EQ_GT] = ACTIONS(739),
    [anon_sym_STAR_EQ_GT] = ACTIONS(739),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(739),
    [anon_sym_DASH_DASH_GT] = ACTIONS(739),
    [anon_sym_DASH_EQ_GT] = ACTIONS(739),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(739),
    [anon_sym_EQ_LT] = ACTIONS(739),
    [anon_sym_EQ_GT] = ACTIONS(739),
    [anon_sym_EQ_CARET] = ACTIONS(739),
    [anon_sym_AT_EQ_GT] = ACTIONS(739),
    [anon_sym_CARET_EQ_GT] = ACTIONS(739),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(739),
    [anon_sym_public] = ACTIONS(737),
    [anon_sym_class] = ACTIONS(737),
    [anon_sym_extends] = ACTIONS(737),
    [sym_class_identifier] = ACTIONS(737),
    [anon_sym_new] = ACTIONS(737),
    [anon_sym_implements] = ACTIONS(737),
    [anon_sym_interface] = ACTIONS(737),
    [anon_sym_private] = ACTIONS(737),
    [anon_sym_protected] = ACTIONS(737),
    [anon_sym_pure] = ACTIONS(737),
    [anon_sym_static] = ACTIONS(737),
    [anon_sym_super] = ACTIONS(737),
    [anon_sym_this] = ACTIONS(737),
    [anon_sym_POUND_LPAREN] = ACTIONS(735),
    [anon_sym_COMMA] = ACTIONS(739),
    [anon_sym_if] = ACTIONS(737),
    [anon_sym_break] = ACTIONS(737),
    [anon_sym_continue] = ACTIONS(737),
    [anon_sym_switch] = ACTIONS(737),
    [anon_sym_LT_LT_LT] = ACTIONS(735),
    [anon_sym_ATdoc] = ACTIONS(735),
    [anon_sym_do] = ACTIONS(737),
    [anon_sym_day] = ACTIONS(737),
    [anon_sym_hour] = ACTIONS(737),
    [anon_sym_minute] = ACTIONS(737),
    [anon_sym_ms] = ACTIONS(737),
    [anon_sym_samp] = ACTIONS(737),
    [anon_sym_second] = ACTIONS(737),
    [anon_sym_week] = ACTIONS(737),
    [anon_sym_COLON_COLON] = ACTIONS(739),
    [sym_float] = ACTIONS(735),
    [anon_sym_for] = ACTIONS(737),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_fun] = ACTIONS(737),
    [anon_sym_adc] = ACTIONS(737),
    [anon_sym_blackhole] = ACTIONS(737),
    [anon_sym_dac] = ACTIONS(737),
    [sym_hexidecimal] = ACTIONS(735),
    [anon_sym_PLUS_PLUS] = ACTIONS(739),
    [anon_sym_DASH_DASH] = ACTIONS(741),
    [anon_sym_ATimport] = ACTIONS(735),
    [sym_int] = ACTIONS(737),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(737),
    [anon_sym_me] = ACTIONS(737),
    [anon_sym_BANG] = ACTIONS(737),
    [anon_sym_DASH] = ACTIONS(741),
    [anon_sym_BANG_EQ] = ACTIONS(739),
    [anon_sym_PERCENT] = ACTIONS(741),
    [anon_sym_AMP] = ACTIONS(741),
    [anon_sym_AMP_AMP] = ACTIONS(739),
    [anon_sym_STAR] = ACTIONS(741),
    [anon_sym_PLUS] = ACTIONS(741),
    [anon_sym_SLASH] = ACTIONS(741),
    [anon_sym_LT] = ACTIONS(741),
    [anon_sym_LT_LT] = ACTIONS(741),
    [anon_sym_LT_EQ] = ACTIONS(739),
    [anon_sym_EQ_EQ] = ACTIONS(739),
    [anon_sym_GT] = ACTIONS(741),
    [anon_sym_GT_EQ] = ACTIONS(739),
    [anon_sym_GT_GT] = ACTIONS(739),
    [anon_sym_CARET] = ACTIONS(741),
    [anon_sym_PIPE] = ACTIONS(741),
    [anon_sym_PIPE_PIPE] = ACTIONS(739),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(735),
    [anon_sym_auto] = ACTIONS(737),
    [anon_sym_complex] = ACTIONS(737),
    [anon_sym_dur] = ACTIONS(737),
    [anon_sym_float] = ACTIONS(737),
    [anon_sym_int] = ACTIONS(737),
    [anon_sym_polar] = ACTIONS(737),
    [anon_sym_same] = ACTIONS(737),
    [anon_sym_time] = ACTIONS(737),
    [anon_sym_vec2] = ACTIONS(737),
    [anon_sym_vec3] = ACTIONS(737),
    [anon_sym_vec4] = ACTIONS(737),
    [anon_sym_void] = ACTIONS(737),
    [anon_sym_Event] = ACTIONS(737),
    [anon_sym_Object] = ACTIONS(737),
    [anon_sym_UGen] = ACTIONS(737),
    [anon_sym_array] = ACTIONS(737),
    [anon_sym_string] = ACTIONS(737),
    [anon_sym_AT_LPAREN] = ACTIONS(735),
    [anon_sym_NULL] = ACTIONS(737),
    [anon_sym_maybe] = ACTIONS(737),
    [anon_sym_now] = ACTIONS(737),
    [anon_sym_null] = ACTIONS(737),
    [anon_sym_pi] = ACTIONS(737),
    [anon_sym_return] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(735),
    [anon_sym_QMARK] = ACTIONS(739),
    [anon_sym_until] = ACTIONS(737),
    [anon_sym_while] = ACTIONS(737),
  },
  [118] = {
    [ts_builtin_sym_end] = ACTIONS(743),
    [sym_variable_identifier] = ACTIONS(745),
    [anon_sym_LBRACK] = ACTIONS(743),
    [anon_sym_LBRACE] = ACTIONS(743),
    [anon_sym_RBRACE] = ACTIONS(743),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(745),
    [anon_sym_true] = ACTIONS(745),
    [anon_sym_DOLLAR] = ACTIONS(743),
    [anon_sym_SQUOTE] = ACTIONS(743),
    [anon_sym_const] = ACTIONS(745),
    [anon_sym_function] = ACTIONS(745),
    [anon_sym_global] = ACTIONS(745),
    [anon_sym_spork] = ACTIONS(745),
    [anon_sym_LPAREN] = ACTIONS(743),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(743),
    [anon_sym_AMP_EQ_GT] = ACTIONS(743),
    [anon_sym_STAR_EQ_GT] = ACTIONS(743),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(743),
    [anon_sym_DASH_DASH_GT] = ACTIONS(743),
    [anon_sym_DASH_EQ_GT] = ACTIONS(743),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(743),
    [anon_sym_EQ_LT] = ACTIONS(743),
    [anon_sym_EQ_GT] = ACTIONS(743),
    [anon_sym_EQ_CARET] = ACTIONS(743),
    [anon_sym_AT_EQ_GT] = ACTIONS(743),
    [anon_sym_CARET_EQ_GT] = ACTIONS(743),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(743),
    [anon_sym_public] = ACTIONS(745),
    [anon_sym_class] = ACTIONS(745),
    [anon_sym_extends] = ACTIONS(745),
    [sym_class_identifier] = ACTIONS(745),
    [anon_sym_new] = ACTIONS(745),
    [anon_sym_implements] = ACTIONS(745),
    [anon_sym_interface] = ACTIONS(745),
    [anon_sym_private] = ACTIONS(745),
    [anon_sym_protected] = ACTIONS(745),
    [anon_sym_pure] = ACTIONS(745),
    [anon_sym_static] = ACTIONS(745),
    [anon_sym_super] = ACTIONS(745),
    [anon_sym_this] = ACTIONS(745),
    [anon_sym_POUND_LPAREN] = ACTIONS(743),
    [anon_sym_COMMA] = ACTIONS(743),
    [anon_sym_if] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(745),
    [anon_sym_continue] = ACTIONS(745),
    [anon_sym_switch] = ACTIONS(745),
    [anon_sym_LT_LT_LT] = ACTIONS(743),
    [anon_sym_ATdoc] = ACTIONS(743),
    [anon_sym_do] = ACTIONS(745),
    [anon_sym_day] = ACTIONS(745),
    [anon_sym_hour] = ACTIONS(745),
    [anon_sym_minute] = ACTIONS(745),
    [anon_sym_ms] = ACTIONS(745),
    [anon_sym_samp] = ACTIONS(745),
    [anon_sym_second] = ACTIONS(745),
    [anon_sym_week] = ACTIONS(745),
    [anon_sym_COLON_COLON] = ACTIONS(743),
    [sym_float] = ACTIONS(743),
    [anon_sym_for] = ACTIONS(745),
    [anon_sym_SEMI] = ACTIONS(743),
    [anon_sym_fun] = ACTIONS(745),
    [anon_sym_adc] = ACTIONS(745),
    [anon_sym_blackhole] = ACTIONS(745),
    [anon_sym_dac] = ACTIONS(745),
    [sym_hexidecimal] = ACTIONS(743),
    [anon_sym_PLUS_PLUS] = ACTIONS(743),
    [anon_sym_DASH_DASH] = ACTIONS(745),
    [anon_sym_ATimport] = ACTIONS(743),
    [sym_int] = ACTIONS(745),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(745),
    [anon_sym_me] = ACTIONS(745),
    [anon_sym_BANG] = ACTIONS(745),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_BANG_EQ] = ACTIONS(743),
    [anon_sym_PERCENT] = ACTIONS(745),
    [anon_sym_AMP] = ACTIONS(745),
    [anon_sym_AMP_AMP] = ACTIONS(743),
    [anon_sym_STAR] = ACTIONS(745),
    [anon_sym_PLUS] = ACTIONS(745),
    [anon_sym_SLASH] = ACTIONS(745),
    [anon_sym_LT] = ACTIONS(745),
    [anon_sym_LT_LT] = ACTIONS(745),
    [anon_sym_LT_EQ] = ACTIONS(743),
    [anon_sym_EQ_EQ] = ACTIONS(743),
    [anon_sym_GT] = ACTIONS(745),
    [anon_sym_GT_EQ] = ACTIONS(743),
    [anon_sym_GT_GT] = ACTIONS(743),
    [anon_sym_CARET] = ACTIONS(745),
    [anon_sym_PIPE] = ACTIONS(745),
    [anon_sym_PIPE_PIPE] = ACTIONS(743),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(743),
    [anon_sym_auto] = ACTIONS(745),
    [anon_sym_complex] = ACTIONS(745),
    [anon_sym_dur] = ACTIONS(745),
    [anon_sym_float] = ACTIONS(745),
    [anon_sym_int] = ACTIONS(745),
    [anon_sym_polar] = ACTIONS(745),
    [anon_sym_same] = ACTIONS(745),
    [anon_sym_time] = ACTIONS(745),
    [anon_sym_vec2] = ACTIONS(745),
    [anon_sym_vec3] = ACTIONS(745),
    [anon_sym_vec4] = ACTIONS(745),
    [anon_sym_void] = ACTIONS(745),
    [anon_sym_Event] = ACTIONS(745),
    [anon_sym_Object] = ACTIONS(745),
    [anon_sym_UGen] = ACTIONS(745),
    [anon_sym_array] = ACTIONS(745),
    [anon_sym_string] = ACTIONS(745),
    [anon_sym_AT_LPAREN] = ACTIONS(743),
    [anon_sym_NULL] = ACTIONS(745),
    [anon_sym_maybe] = ACTIONS(745),
    [anon_sym_now] = ACTIONS(745),
    [anon_sym_null] = ACTIONS(745),
    [anon_sym_pi] = ACTIONS(745),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_DQUOTE] = ACTIONS(743),
    [anon_sym_QMARK] = ACTIONS(743),
    [anon_sym_until] = ACTIONS(745),
    [anon_sym_while] = ACTIONS(745),
  },
  [119] = {
    [ts_builtin_sym_end] = ACTIONS(747),
    [sym_variable_identifier] = ACTIONS(749),
    [anon_sym_LBRACK] = ACTIONS(747),
    [anon_sym_LBRACE] = ACTIONS(747),
    [anon_sym_RBRACE] = ACTIONS(747),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(749),
    [anon_sym_true] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(747),
    [anon_sym_SQUOTE] = ACTIONS(747),
    [anon_sym_const] = ACTIONS(749),
    [anon_sym_function] = ACTIONS(749),
    [anon_sym_global] = ACTIONS(749),
    [anon_sym_spork] = ACTIONS(749),
    [anon_sym_LPAREN] = ACTIONS(747),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(747),
    [anon_sym_AMP_EQ_GT] = ACTIONS(747),
    [anon_sym_STAR_EQ_GT] = ACTIONS(747),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(747),
    [anon_sym_DASH_DASH_GT] = ACTIONS(747),
    [anon_sym_DASH_EQ_GT] = ACTIONS(747),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(747),
    [anon_sym_EQ_LT] = ACTIONS(747),
    [anon_sym_EQ_GT] = ACTIONS(747),
    [anon_sym_EQ_CARET] = ACTIONS(747),
    [anon_sym_AT_EQ_GT] = ACTIONS(747),
    [anon_sym_CARET_EQ_GT] = ACTIONS(747),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(747),
    [anon_sym_public] = ACTIONS(749),
    [anon_sym_class] = ACTIONS(749),
    [anon_sym_extends] = ACTIONS(749),
    [sym_class_identifier] = ACTIONS(749),
    [anon_sym_new] = ACTIONS(749),
    [anon_sym_implements] = ACTIONS(749),
    [anon_sym_interface] = ACTIONS(749),
    [anon_sym_private] = ACTIONS(749),
    [anon_sym_protected] = ACTIONS(749),
    [anon_sym_pure] = ACTIONS(749),
    [anon_sym_static] = ACTIONS(749),
    [anon_sym_super] = ACTIONS(749),
    [anon_sym_this] = ACTIONS(749),
    [anon_sym_POUND_LPAREN] = ACTIONS(747),
    [anon_sym_COMMA] = ACTIONS(747),
    [anon_sym_if] = ACTIONS(749),
    [anon_sym_break] = ACTIONS(749),
    [anon_sym_continue] = ACTIONS(749),
    [anon_sym_switch] = ACTIONS(749),
    [anon_sym_LT_LT_LT] = ACTIONS(747),
    [anon_sym_ATdoc] = ACTIONS(747),
    [anon_sym_do] = ACTIONS(749),
    [anon_sym_day] = ACTIONS(749),
    [anon_sym_hour] = ACTIONS(749),
    [anon_sym_minute] = ACTIONS(749),
    [anon_sym_ms] = ACTIONS(749),
    [anon_sym_samp] = ACTIONS(749),
    [anon_sym_second] = ACTIONS(749),
    [anon_sym_week] = ACTIONS(749),
    [anon_sym_COLON_COLON] = ACTIONS(747),
    [sym_float] = ACTIONS(747),
    [anon_sym_for] = ACTIONS(749),
    [anon_sym_SEMI] = ACTIONS(747),
    [anon_sym_fun] = ACTIONS(749),
    [anon_sym_adc] = ACTIONS(749),
    [anon_sym_blackhole] = ACTIONS(749),
    [anon_sym_dac] = ACTIONS(749),
    [sym_hexidecimal] = ACTIONS(747),
    [anon_sym_PLUS_PLUS] = ACTIONS(747),
    [anon_sym_DASH_DASH] = ACTIONS(749),
    [anon_sym_ATimport] = ACTIONS(747),
    [sym_int] = ACTIONS(749),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(749),
    [anon_sym_me] = ACTIONS(749),
    [anon_sym_BANG] = ACTIONS(749),
    [anon_sym_DASH] = ACTIONS(749),
    [anon_sym_BANG_EQ] = ACTIONS(747),
    [anon_sym_PERCENT] = ACTIONS(749),
    [anon_sym_AMP] = ACTIONS(749),
    [anon_sym_AMP_AMP] = ACTIONS(747),
    [anon_sym_STAR] = ACTIONS(749),
    [anon_sym_PLUS] = ACTIONS(749),
    [anon_sym_SLASH] = ACTIONS(749),
    [anon_sym_LT] = ACTIONS(749),
    [anon_sym_LT_LT] = ACTIONS(749),
    [anon_sym_LT_EQ] = ACTIONS(747),
    [anon_sym_EQ_EQ] = ACTIONS(747),
    [anon_sym_GT] = ACTIONS(749),
    [anon_sym_GT_EQ] = ACTIONS(747),
    [anon_sym_GT_GT] = ACTIONS(747),
    [anon_sym_CARET] = ACTIONS(749),
    [anon_sym_PIPE] = ACTIONS(749),
    [anon_sym_PIPE_PIPE] = ACTIONS(747),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(747),
    [anon_sym_auto] = ACTIONS(749),
    [anon_sym_complex] = ACTIONS(749),
    [anon_sym_dur] = ACTIONS(749),
    [anon_sym_float] = ACTIONS(749),
    [anon_sym_int] = ACTIONS(749),
    [anon_sym_polar] = ACTIONS(749),
    [anon_sym_same] = ACTIONS(749),
    [anon_sym_time] = ACTIONS(749),
    [anon_sym_vec2] = ACTIONS(749),
    [anon_sym_vec3] = ACTIONS(749),
    [anon_sym_vec4] = ACTIONS(749),
    [anon_sym_void] = ACTIONS(749),
    [anon_sym_Event] = ACTIONS(749),
    [anon_sym_Object] = ACTIONS(749),
    [anon_sym_UGen] = ACTIONS(749),
    [anon_sym_array] = ACTIONS(749),
    [anon_sym_string] = ACTIONS(749),
    [anon_sym_AT_LPAREN] = ACTIONS(747),
    [anon_sym_NULL] = ACTIONS(749),
    [anon_sym_maybe] = ACTIONS(749),
    [anon_sym_now] = ACTIONS(749),
    [anon_sym_null] = ACTIONS(749),
    [anon_sym_pi] = ACTIONS(749),
    [anon_sym_return] = ACTIONS(749),
    [anon_sym_DQUOTE] = ACTIONS(747),
    [anon_sym_QMARK] = ACTIONS(747),
    [anon_sym_until] = ACTIONS(749),
    [anon_sym_while] = ACTIONS(749),
  },
  [120] = {
    [ts_builtin_sym_end] = ACTIONS(751),
    [sym_variable_identifier] = ACTIONS(753),
    [anon_sym_LBRACK] = ACTIONS(751),
    [anon_sym_LBRACE] = ACTIONS(751),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(753),
    [anon_sym_true] = ACTIONS(753),
    [anon_sym_DOLLAR] = ACTIONS(739),
    [anon_sym_SQUOTE] = ACTIONS(751),
    [anon_sym_const] = ACTIONS(753),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_global] = ACTIONS(753),
    [anon_sym_spork] = ACTIONS(753),
    [anon_sym_LPAREN] = ACTIONS(751),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(739),
    [anon_sym_AMP_EQ_GT] = ACTIONS(739),
    [anon_sym_STAR_EQ_GT] = ACTIONS(739),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(739),
    [anon_sym_DASH_DASH_GT] = ACTIONS(739),
    [anon_sym_DASH_EQ_GT] = ACTIONS(739),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(739),
    [anon_sym_EQ_LT] = ACTIONS(739),
    [anon_sym_EQ_GT] = ACTIONS(739),
    [anon_sym_EQ_CARET] = ACTIONS(739),
    [anon_sym_AT_EQ_GT] = ACTIONS(739),
    [anon_sym_CARET_EQ_GT] = ACTIONS(739),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(739),
    [anon_sym_public] = ACTIONS(753),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_extends] = ACTIONS(753),
    [sym_class_identifier] = ACTIONS(753),
    [anon_sym_new] = ACTIONS(753),
    [anon_sym_implements] = ACTIONS(753),
    [anon_sym_interface] = ACTIONS(753),
    [anon_sym_private] = ACTIONS(753),
    [anon_sym_protected] = ACTIONS(753),
    [anon_sym_pure] = ACTIONS(753),
    [anon_sym_static] = ACTIONS(753),
    [anon_sym_super] = ACTIONS(753),
    [anon_sym_this] = ACTIONS(753),
    [anon_sym_POUND_LPAREN] = ACTIONS(751),
    [anon_sym_COMMA] = ACTIONS(739),
    [anon_sym_if] = ACTIONS(753),
    [anon_sym_break] = ACTIONS(753),
    [anon_sym_continue] = ACTIONS(753),
    [anon_sym_switch] = ACTIONS(753),
    [anon_sym_LT_LT_LT] = ACTIONS(751),
    [anon_sym_ATdoc] = ACTIONS(751),
    [anon_sym_do] = ACTIONS(753),
    [anon_sym_day] = ACTIONS(753),
    [anon_sym_hour] = ACTIONS(753),
    [anon_sym_minute] = ACTIONS(753),
    [anon_sym_ms] = ACTIONS(753),
    [anon_sym_samp] = ACTIONS(753),
    [anon_sym_second] = ACTIONS(753),
    [anon_sym_week] = ACTIONS(753),
    [anon_sym_COLON_COLON] = ACTIONS(739),
    [sym_float] = ACTIONS(751),
    [anon_sym_for] = ACTIONS(753),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_fun] = ACTIONS(753),
    [anon_sym_adc] = ACTIONS(753),
    [anon_sym_blackhole] = ACTIONS(753),
    [anon_sym_dac] = ACTIONS(753),
    [sym_hexidecimal] = ACTIONS(751),
    [anon_sym_PLUS_PLUS] = ACTIONS(739),
    [anon_sym_DASH_DASH] = ACTIONS(741),
    [anon_sym_ATimport] = ACTIONS(751),
    [sym_int] = ACTIONS(753),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(753),
    [anon_sym_me] = ACTIONS(753),
    [anon_sym_BANG] = ACTIONS(753),
    [anon_sym_DASH] = ACTIONS(741),
    [anon_sym_BANG_EQ] = ACTIONS(739),
    [anon_sym_PERCENT] = ACTIONS(741),
    [anon_sym_AMP] = ACTIONS(741),
    [anon_sym_AMP_AMP] = ACTIONS(739),
    [anon_sym_STAR] = ACTIONS(741),
    [anon_sym_PLUS] = ACTIONS(741),
    [anon_sym_SLASH] = ACTIONS(741),
    [anon_sym_LT] = ACTIONS(741),
    [anon_sym_LT_LT] = ACTIONS(741),
    [anon_sym_LT_EQ] = ACTIONS(739),
    [anon_sym_EQ_EQ] = ACTIONS(739),
    [anon_sym_GT] = ACTIONS(741),
    [anon_sym_GT_EQ] = ACTIONS(739),
    [anon_sym_GT_GT] = ACTIONS(739),
    [anon_sym_CARET] = ACTIONS(741),
    [anon_sym_PIPE] = ACTIONS(741),
    [anon_sym_PIPE_PIPE] = ACTIONS(739),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(751),
    [anon_sym_auto] = ACTIONS(753),
    [anon_sym_complex] = ACTIONS(753),
    [anon_sym_dur] = ACTIONS(753),
    [anon_sym_float] = ACTIONS(753),
    [anon_sym_int] = ACTIONS(753),
    [anon_sym_polar] = ACTIONS(753),
    [anon_sym_same] = ACTIONS(753),
    [anon_sym_time] = ACTIONS(753),
    [anon_sym_vec2] = ACTIONS(753),
    [anon_sym_vec3] = ACTIONS(753),
    [anon_sym_vec4] = ACTIONS(753),
    [anon_sym_void] = ACTIONS(753),
    [anon_sym_Event] = ACTIONS(753),
    [anon_sym_Object] = ACTIONS(753),
    [anon_sym_UGen] = ACTIONS(753),
    [anon_sym_array] = ACTIONS(753),
    [anon_sym_string] = ACTIONS(753),
    [anon_sym_AT_LPAREN] = ACTIONS(751),
    [anon_sym_NULL] = ACTIONS(753),
    [anon_sym_maybe] = ACTIONS(753),
    [anon_sym_now] = ACTIONS(753),
    [anon_sym_null] = ACTIONS(753),
    [anon_sym_pi] = ACTIONS(753),
    [anon_sym_return] = ACTIONS(753),
    [anon_sym_DQUOTE] = ACTIONS(751),
    [anon_sym_QMARK] = ACTIONS(739),
    [anon_sym_until] = ACTIONS(753),
    [anon_sym_while] = ACTIONS(753),
  },
  [121] = {
    [sym_variable_identifier] = ACTIONS(755),
    [anon_sym_LBRACK] = ACTIONS(757),
    [anon_sym_RBRACE] = ACTIONS(757),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(755),
    [anon_sym_true] = ACTIONS(755),
    [anon_sym_DOLLAR] = ACTIONS(739),
    [anon_sym_SQUOTE] = ACTIONS(757),
    [anon_sym_const] = ACTIONS(755),
    [anon_sym_function] = ACTIONS(755),
    [anon_sym_global] = ACTIONS(755),
    [anon_sym_spork] = ACTIONS(755),
    [anon_sym_LPAREN] = ACTIONS(757),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(739),
    [anon_sym_AMP_EQ_GT] = ACTIONS(739),
    [anon_sym_STAR_EQ_GT] = ACTIONS(739),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(739),
    [anon_sym_DASH_DASH_GT] = ACTIONS(739),
    [anon_sym_DASH_EQ_GT] = ACTIONS(739),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(739),
    [anon_sym_EQ_LT] = ACTIONS(739),
    [anon_sym_EQ_GT] = ACTIONS(739),
    [anon_sym_EQ_CARET] = ACTIONS(739),
    [anon_sym_AT_EQ_GT] = ACTIONS(739),
    [anon_sym_CARET_EQ_GT] = ACTIONS(739),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(739),
    [anon_sym_public] = ACTIONS(755),
    [anon_sym_class] = ACTIONS(755),
    [anon_sym_extends] = ACTIONS(755),
    [sym_class_identifier] = ACTIONS(755),
    [anon_sym_new] = ACTIONS(755),
    [anon_sym_implements] = ACTIONS(755),
    [anon_sym_interface] = ACTIONS(755),
    [anon_sym_private] = ACTIONS(755),
    [anon_sym_protected] = ACTIONS(755),
    [anon_sym_pure] = ACTIONS(755),
    [anon_sym_static] = ACTIONS(755),
    [anon_sym_super] = ACTIONS(755),
    [anon_sym_this] = ACTIONS(755),
    [anon_sym_POUND_LPAREN] = ACTIONS(757),
    [anon_sym_COMMA] = ACTIONS(739),
    [anon_sym_if] = ACTIONS(755),
    [anon_sym_break] = ACTIONS(755),
    [anon_sym_continue] = ACTIONS(755),
    [anon_sym_switch] = ACTIONS(755),
    [anon_sym_LT_LT_LT] = ACTIONS(757),
    [anon_sym_ATdoc] = ACTIONS(757),
    [anon_sym_do] = ACTIONS(755),
    [anon_sym_day] = ACTIONS(755),
    [anon_sym_hour] = ACTIONS(755),
    [anon_sym_minute] = ACTIONS(755),
    [anon_sym_ms] = ACTIONS(755),
    [anon_sym_samp] = ACTIONS(755),
    [anon_sym_second] = ACTIONS(755),
    [anon_sym_week] = ACTIONS(755),
    [anon_sym_COLON_COLON] = ACTIONS(739),
    [sym_float] = ACTIONS(757),
    [anon_sym_for] = ACTIONS(755),
    [anon_sym_SEMI] = ACTIONS(739),
    [anon_sym_fun] = ACTIONS(755),
    [anon_sym_adc] = ACTIONS(755),
    [anon_sym_blackhole] = ACTIONS(755),
    [anon_sym_dac] = ACTIONS(755),
    [sym_hexidecimal] = ACTIONS(757),
    [anon_sym_PLUS_PLUS] = ACTIONS(739),
    [anon_sym_DASH_DASH] = ACTIONS(741),
    [sym_int] = ACTIONS(755),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(755),
    [anon_sym_me] = ACTIONS(755),
    [anon_sym_BANG] = ACTIONS(755),
    [anon_sym_DASH] = ACTIONS(741),
    [anon_sym_BANG_EQ] = ACTIONS(739),
    [anon_sym_PERCENT] = ACTIONS(741),
    [anon_sym_AMP] = ACTIONS(741),
    [anon_sym_AMP_AMP] = ACTIONS(739),
    [anon_sym_STAR] = ACTIONS(741),
    [anon_sym_PLUS] = ACTIONS(741),
    [anon_sym_SLASH] = ACTIONS(741),
    [anon_sym_LT] = ACTIONS(741),
    [anon_sym_LT_LT] = ACTIONS(741),
    [anon_sym_LT_EQ] = ACTIONS(739),
    [anon_sym_EQ_EQ] = ACTIONS(739),
    [anon_sym_GT] = ACTIONS(741),
    [anon_sym_GT_EQ] = ACTIONS(739),
    [anon_sym_GT_GT] = ACTIONS(739),
    [anon_sym_CARET] = ACTIONS(741),
    [anon_sym_PIPE] = ACTIONS(741),
    [anon_sym_PIPE_PIPE] = ACTIONS(739),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(757),
    [anon_sym_auto] = ACTIONS(755),
    [anon_sym_complex] = ACTIONS(755),
    [anon_sym_dur] = ACTIONS(755),
    [anon_sym_float] = ACTIONS(755),
    [anon_sym_int] = ACTIONS(755),
    [anon_sym_polar] = ACTIONS(755),
    [anon_sym_same] = ACTIONS(755),
    [anon_sym_time] = ACTIONS(755),
    [anon_sym_vec2] = ACTIONS(755),
    [anon_sym_vec3] = ACTIONS(755),
    [anon_sym_vec4] = ACTIONS(755),
    [anon_sym_void] = ACTIONS(755),
    [anon_sym_Event] = ACTIONS(755),
    [anon_sym_Object] = ACTIONS(755),
    [anon_sym_UGen] = ACTIONS(755),
    [anon_sym_array] = ACTIONS(755),
    [anon_sym_string] = ACTIONS(755),
    [anon_sym_AT_LPAREN] = ACTIONS(757),
    [anon_sym_NULL] = ACTIONS(755),
    [anon_sym_maybe] = ACTIONS(755),
    [anon_sym_now] = ACTIONS(755),
    [anon_sym_null] = ACTIONS(755),
    [anon_sym_pi] = ACTIONS(755),
    [anon_sym_return] = ACTIONS(755),
    [anon_sym_DQUOTE] = ACTIONS(757),
    [anon_sym_QMARK] = ACTIONS(739),
    [anon_sym_until] = ACTIONS(755),
    [anon_sym_while] = ACTIONS(755),
  },
  [122] = {
    [ts_builtin_sym_end] = ACTIONS(707),
    [sym_variable_identifier] = ACTIONS(709),
    [anon_sym_LBRACK] = ACTIONS(707),
    [anon_sym_LBRACE] = ACTIONS(707),
    [anon_sym_RBRACE] = ACTIONS(707),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(709),
    [anon_sym_true] = ACTIONS(709),
    [anon_sym_SQUOTE] = ACTIONS(707),
    [anon_sym_const] = ACTIONS(709),
    [anon_sym_function] = ACTIONS(709),
    [anon_sym_global] = ACTIONS(709),
    [anon_sym_spork] = ACTIONS(709),
    [anon_sym_LPAREN] = ACTIONS(707),
    [anon_sym_public] = ACTIONS(709),
    [anon_sym_class] = ACTIONS(709),
    [anon_sym_extends] = ACTIONS(709),
    [sym_class_identifier] = ACTIONS(709),
    [anon_sym_new] = ACTIONS(709),
    [anon_sym_implements] = ACTIONS(709),
    [anon_sym_interface] = ACTIONS(709),
    [anon_sym_private] = ACTIONS(709),
    [anon_sym_protected] = ACTIONS(709),
    [anon_sym_pure] = ACTIONS(709),
    [anon_sym_static] = ACTIONS(709),
    [anon_sym_super] = ACTIONS(709),
    [anon_sym_this] = ACTIONS(709),
    [anon_sym_POUND_LPAREN] = ACTIONS(707),
    [anon_sym_if] = ACTIONS(709),
    [anon_sym_break] = ACTIONS(709),
    [anon_sym_continue] = ACTIONS(709),
    [anon_sym_switch] = ACTIONS(709),
    [anon_sym_LT_LT_LT] = ACTIONS(707),
    [anon_sym_ATdoc] = ACTIONS(707),
    [anon_sym_do] = ACTIONS(709),
    [anon_sym_day] = ACTIONS(709),
    [anon_sym_hour] = ACTIONS(709),
    [anon_sym_minute] = ACTIONS(709),
    [anon_sym_ms] = ACTIONS(709),
    [anon_sym_samp] = ACTIONS(709),
    [anon_sym_second] = ACTIONS(709),
    [anon_sym_week] = ACTIONS(709),
    [sym_float] = ACTIONS(707),
    [anon_sym_for] = ACTIONS(709),
    [anon_sym_SEMI] = ACTIONS(707),
    [anon_sym_fun] = ACTIONS(709),
    [anon_sym_adc] = ACTIONS(709),
    [anon_sym_blackhole] = ACTIONS(709),
    [anon_sym_dac] = ACTIONS(709),
    [sym_hexidecimal] = ACTIONS(707),
    [anon_sym_PLUS_PLUS] = ACTIONS(707),
    [anon_sym_DASH_DASH] = ACTIONS(707),
    [anon_sym_ATimport] = ACTIONS(707),
    [sym_int] = ACTIONS(709),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(709),
    [anon_sym_me] = ACTIONS(709),
    [anon_sym_BANG] = ACTIONS(707),
    [anon_sym_DASH] = ACTIONS(709),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(707),
    [anon_sym_auto] = ACTIONS(709),
    [anon_sym_complex] = ACTIONS(709),
    [anon_sym_dur] = ACTIONS(709),
    [anon_sym_float] = ACTIONS(709),
    [anon_sym_int] = ACTIONS(709),
    [anon_sym_polar] = ACTIONS(709),
    [anon_sym_same] = ACTIONS(709),
    [anon_sym_time] = ACTIONS(709),
    [anon_sym_vec2] = ACTIONS(709),
    [anon_sym_vec3] = ACTIONS(709),
    [anon_sym_vec4] = ACTIONS(709),
    [anon_sym_void] = ACTIONS(709),
    [anon_sym_Event] = ACTIONS(709),
    [anon_sym_Object] = ACTIONS(709),
    [anon_sym_UGen] = ACTIONS(709),
    [anon_sym_array] = ACTIONS(709),
    [anon_sym_string] = ACTIONS(709),
    [anon_sym_AT_LPAREN] = ACTIONS(707),
    [anon_sym_NULL] = ACTIONS(709),
    [anon_sym_maybe] = ACTIONS(709),
    [anon_sym_now] = ACTIONS(709),
    [anon_sym_null] = ACTIONS(709),
    [anon_sym_pi] = ACTIONS(709),
    [anon_sym_return] = ACTIONS(709),
    [anon_sym_DQUOTE] = ACTIONS(707),
    [anon_sym_until] = ACTIONS(709),
    [anon_sym_while] = ACTIONS(709),
  },
  [123] = {
    [ts_builtin_sym_end] = ACTIONS(759),
    [sym_variable_identifier] = ACTIONS(761),
    [anon_sym_LBRACK] = ACTIONS(759),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_RBRACE] = ACTIONS(759),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(761),
    [anon_sym_true] = ACTIONS(761),
    [anon_sym_SQUOTE] = ACTIONS(759),
    [anon_sym_const] = ACTIONS(761),
    [anon_sym_function] = ACTIONS(761),
    [anon_sym_global] = ACTIONS(761),
    [anon_sym_spork] = ACTIONS(761),
    [anon_sym_LPAREN] = ACTIONS(759),
    [anon_sym_public] = ACTIONS(761),
    [anon_sym_class] = ACTIONS(761),
    [anon_sym_extends] = ACTIONS(761),
    [sym_class_identifier] = ACTIONS(761),
    [anon_sym_new] = ACTIONS(761),
    [anon_sym_implements] = ACTIONS(761),
    [anon_sym_interface] = ACTIONS(761),
    [anon_sym_private] = ACTIONS(761),
    [anon_sym_protected] = ACTIONS(761),
    [anon_sym_pure] = ACTIONS(761),
    [anon_sym_static] = ACTIONS(761),
    [anon_sym_super] = ACTIONS(761),
    [anon_sym_this] = ACTIONS(761),
    [anon_sym_POUND_LPAREN] = ACTIONS(759),
    [anon_sym_if] = ACTIONS(761),
    [anon_sym_break] = ACTIONS(761),
    [anon_sym_continue] = ACTIONS(761),
    [anon_sym_switch] = ACTIONS(761),
    [anon_sym_LT_LT_LT] = ACTIONS(759),
    [anon_sym_ATdoc] = ACTIONS(759),
    [anon_sym_do] = ACTIONS(761),
    [anon_sym_day] = ACTIONS(761),
    [anon_sym_hour] = ACTIONS(761),
    [anon_sym_minute] = ACTIONS(761),
    [anon_sym_ms] = ACTIONS(761),
    [anon_sym_samp] = ACTIONS(761),
    [anon_sym_second] = ACTIONS(761),
    [anon_sym_week] = ACTIONS(761),
    [sym_float] = ACTIONS(759),
    [anon_sym_for] = ACTIONS(761),
    [anon_sym_SEMI] = ACTIONS(759),
    [anon_sym_fun] = ACTIONS(761),
    [anon_sym_adc] = ACTIONS(761),
    [anon_sym_blackhole] = ACTIONS(761),
    [anon_sym_dac] = ACTIONS(761),
    [sym_hexidecimal] = ACTIONS(759),
    [anon_sym_PLUS_PLUS] = ACTIONS(759),
    [anon_sym_DASH_DASH] = ACTIONS(759),
    [anon_sym_ATimport] = ACTIONS(759),
    [sym_int] = ACTIONS(761),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(761),
    [anon_sym_me] = ACTIONS(761),
    [anon_sym_BANG] = ACTIONS(759),
    [anon_sym_DASH] = ACTIONS(761),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(759),
    [anon_sym_auto] = ACTIONS(761),
    [anon_sym_complex] = ACTIONS(761),
    [anon_sym_dur] = ACTIONS(761),
    [anon_sym_float] = ACTIONS(761),
    [anon_sym_int] = ACTIONS(761),
    [anon_sym_polar] = ACTIONS(761),
    [anon_sym_same] = ACTIONS(761),
    [anon_sym_time] = ACTIONS(761),
    [anon_sym_vec2] = ACTIONS(761),
    [anon_sym_vec3] = ACTIONS(761),
    [anon_sym_vec4] = ACTIONS(761),
    [anon_sym_void] = ACTIONS(761),
    [anon_sym_Event] = ACTIONS(761),
    [anon_sym_Object] = ACTIONS(761),
    [anon_sym_UGen] = ACTIONS(761),
    [anon_sym_array] = ACTIONS(761),
    [anon_sym_string] = ACTIONS(761),
    [anon_sym_AT_LPAREN] = ACTIONS(759),
    [anon_sym_NULL] = ACTIONS(761),
    [anon_sym_maybe] = ACTIONS(761),
    [anon_sym_now] = ACTIONS(761),
    [anon_sym_null] = ACTIONS(761),
    [anon_sym_pi] = ACTIONS(761),
    [anon_sym_return] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(759),
    [anon_sym_until] = ACTIONS(761),
    [anon_sym_while] = ACTIONS(761),
  },
  [124] = {
    [ts_builtin_sym_end] = ACTIONS(763),
    [sym_variable_identifier] = ACTIONS(765),
    [anon_sym_LBRACK] = ACTIONS(763),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_RBRACE] = ACTIONS(763),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(765),
    [anon_sym_true] = ACTIONS(765),
    [anon_sym_SQUOTE] = ACTIONS(763),
    [anon_sym_const] = ACTIONS(765),
    [anon_sym_function] = ACTIONS(765),
    [anon_sym_global] = ACTIONS(765),
    [anon_sym_spork] = ACTIONS(765),
    [anon_sym_LPAREN] = ACTIONS(763),
    [anon_sym_public] = ACTIONS(765),
    [anon_sym_class] = ACTIONS(765),
    [anon_sym_extends] = ACTIONS(765),
    [sym_class_identifier] = ACTIONS(765),
    [anon_sym_new] = ACTIONS(765),
    [anon_sym_implements] = ACTIONS(765),
    [anon_sym_interface] = ACTIONS(765),
    [anon_sym_private] = ACTIONS(765),
    [anon_sym_protected] = ACTIONS(765),
    [anon_sym_pure] = ACTIONS(765),
    [anon_sym_static] = ACTIONS(765),
    [anon_sym_super] = ACTIONS(765),
    [anon_sym_this] = ACTIONS(765),
    [anon_sym_POUND_LPAREN] = ACTIONS(763),
    [anon_sym_if] = ACTIONS(765),
    [anon_sym_break] = ACTIONS(765),
    [anon_sym_continue] = ACTIONS(765),
    [anon_sym_switch] = ACTIONS(765),
    [anon_sym_LT_LT_LT] = ACTIONS(763),
    [anon_sym_ATdoc] = ACTIONS(763),
    [anon_sym_do] = ACTIONS(765),
    [anon_sym_day] = ACTIONS(765),
    [anon_sym_hour] = ACTIONS(765),
    [anon_sym_minute] = ACTIONS(765),
    [anon_sym_ms] = ACTIONS(765),
    [anon_sym_samp] = ACTIONS(765),
    [anon_sym_second] = ACTIONS(765),
    [anon_sym_week] = ACTIONS(765),
    [sym_float] = ACTIONS(763),
    [anon_sym_for] = ACTIONS(765),
    [anon_sym_SEMI] = ACTIONS(763),
    [anon_sym_fun] = ACTIONS(765),
    [anon_sym_adc] = ACTIONS(765),
    [anon_sym_blackhole] = ACTIONS(765),
    [anon_sym_dac] = ACTIONS(765),
    [sym_hexidecimal] = ACTIONS(763),
    [anon_sym_PLUS_PLUS] = ACTIONS(763),
    [anon_sym_DASH_DASH] = ACTIONS(763),
    [anon_sym_ATimport] = ACTIONS(763),
    [sym_int] = ACTIONS(765),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(765),
    [anon_sym_me] = ACTIONS(765),
    [anon_sym_BANG] = ACTIONS(763),
    [anon_sym_DASH] = ACTIONS(765),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(763),
    [anon_sym_auto] = ACTIONS(765),
    [anon_sym_complex] = ACTIONS(765),
    [anon_sym_dur] = ACTIONS(765),
    [anon_sym_float] = ACTIONS(765),
    [anon_sym_int] = ACTIONS(765),
    [anon_sym_polar] = ACTIONS(765),
    [anon_sym_same] = ACTIONS(765),
    [anon_sym_time] = ACTIONS(765),
    [anon_sym_vec2] = ACTIONS(765),
    [anon_sym_vec3] = ACTIONS(765),
    [anon_sym_vec4] = ACTIONS(765),
    [anon_sym_void] = ACTIONS(765),
    [anon_sym_Event] = ACTIONS(765),
    [anon_sym_Object] = ACTIONS(765),
    [anon_sym_UGen] = ACTIONS(765),
    [anon_sym_array] = ACTIONS(765),
    [anon_sym_string] = ACTIONS(765),
    [anon_sym_AT_LPAREN] = ACTIONS(763),
    [anon_sym_NULL] = ACTIONS(765),
    [anon_sym_maybe] = ACTIONS(765),
    [anon_sym_now] = ACTIONS(765),
    [anon_sym_null] = ACTIONS(765),
    [anon_sym_pi] = ACTIONS(765),
    [anon_sym_return] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(763),
    [anon_sym_until] = ACTIONS(765),
    [anon_sym_while] = ACTIONS(765),
  },
  [125] = {
    [ts_builtin_sym_end] = ACTIONS(767),
    [sym_variable_identifier] = ACTIONS(769),
    [anon_sym_LBRACK] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(767),
    [anon_sym_RBRACE] = ACTIONS(767),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(769),
    [anon_sym_true] = ACTIONS(769),
    [anon_sym_SQUOTE] = ACTIONS(767),
    [anon_sym_const] = ACTIONS(769),
    [anon_sym_function] = ACTIONS(769),
    [anon_sym_global] = ACTIONS(769),
    [anon_sym_spork] = ACTIONS(769),
    [anon_sym_LPAREN] = ACTIONS(767),
    [anon_sym_public] = ACTIONS(769),
    [anon_sym_class] = ACTIONS(769),
    [anon_sym_extends] = ACTIONS(769),
    [sym_class_identifier] = ACTIONS(769),
    [anon_sym_new] = ACTIONS(769),
    [anon_sym_implements] = ACTIONS(769),
    [anon_sym_interface] = ACTIONS(769),
    [anon_sym_private] = ACTIONS(769),
    [anon_sym_protected] = ACTIONS(769),
    [anon_sym_pure] = ACTIONS(769),
    [anon_sym_static] = ACTIONS(769),
    [anon_sym_super] = ACTIONS(769),
    [anon_sym_this] = ACTIONS(769),
    [anon_sym_POUND_LPAREN] = ACTIONS(767),
    [anon_sym_if] = ACTIONS(769),
    [anon_sym_break] = ACTIONS(769),
    [anon_sym_continue] = ACTIONS(769),
    [anon_sym_switch] = ACTIONS(769),
    [anon_sym_LT_LT_LT] = ACTIONS(767),
    [anon_sym_ATdoc] = ACTIONS(767),
    [anon_sym_do] = ACTIONS(769),
    [anon_sym_day] = ACTIONS(769),
    [anon_sym_hour] = ACTIONS(769),
    [anon_sym_minute] = ACTIONS(769),
    [anon_sym_ms] = ACTIONS(769),
    [anon_sym_samp] = ACTIONS(769),
    [anon_sym_second] = ACTIONS(769),
    [anon_sym_week] = ACTIONS(769),
    [sym_float] = ACTIONS(767),
    [anon_sym_for] = ACTIONS(769),
    [anon_sym_SEMI] = ACTIONS(767),
    [anon_sym_fun] = ACTIONS(769),
    [anon_sym_adc] = ACTIONS(769),
    [anon_sym_blackhole] = ACTIONS(769),
    [anon_sym_dac] = ACTIONS(769),
    [sym_hexidecimal] = ACTIONS(767),
    [anon_sym_PLUS_PLUS] = ACTIONS(767),
    [anon_sym_DASH_DASH] = ACTIONS(767),
    [anon_sym_ATimport] = ACTIONS(767),
    [sym_int] = ACTIONS(769),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(769),
    [anon_sym_me] = ACTIONS(769),
    [anon_sym_BANG] = ACTIONS(767),
    [anon_sym_DASH] = ACTIONS(769),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(767),
    [anon_sym_auto] = ACTIONS(769),
    [anon_sym_complex] = ACTIONS(769),
    [anon_sym_dur] = ACTIONS(769),
    [anon_sym_float] = ACTIONS(769),
    [anon_sym_int] = ACTIONS(769),
    [anon_sym_polar] = ACTIONS(769),
    [anon_sym_same] = ACTIONS(769),
    [anon_sym_time] = ACTIONS(769),
    [anon_sym_vec2] = ACTIONS(769),
    [anon_sym_vec3] = ACTIONS(769),
    [anon_sym_vec4] = ACTIONS(769),
    [anon_sym_void] = ACTIONS(769),
    [anon_sym_Event] = ACTIONS(769),
    [anon_sym_Object] = ACTIONS(769),
    [anon_sym_UGen] = ACTIONS(769),
    [anon_sym_array] = ACTIONS(769),
    [anon_sym_string] = ACTIONS(769),
    [anon_sym_AT_LPAREN] = ACTIONS(767),
    [anon_sym_NULL] = ACTIONS(769),
    [anon_sym_maybe] = ACTIONS(769),
    [anon_sym_now] = ACTIONS(769),
    [anon_sym_null] = ACTIONS(769),
    [anon_sym_pi] = ACTIONS(769),
    [anon_sym_return] = ACTIONS(769),
    [anon_sym_DQUOTE] = ACTIONS(767),
    [anon_sym_until] = ACTIONS(769),
    [anon_sym_while] = ACTIONS(769),
  },
  [126] = {
    [ts_builtin_sym_end] = ACTIONS(771),
    [sym_variable_identifier] = ACTIONS(773),
    [anon_sym_LBRACK] = ACTIONS(771),
    [anon_sym_LBRACE] = ACTIONS(771),
    [anon_sym_RBRACE] = ACTIONS(771),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(773),
    [anon_sym_true] = ACTIONS(773),
    [anon_sym_SQUOTE] = ACTIONS(771),
    [anon_sym_const] = ACTIONS(773),
    [anon_sym_function] = ACTIONS(773),
    [anon_sym_global] = ACTIONS(773),
    [anon_sym_spork] = ACTIONS(773),
    [anon_sym_LPAREN] = ACTIONS(771),
    [anon_sym_public] = ACTIONS(773),
    [anon_sym_class] = ACTIONS(773),
    [anon_sym_extends] = ACTIONS(773),
    [sym_class_identifier] = ACTIONS(773),
    [anon_sym_new] = ACTIONS(773),
    [anon_sym_implements] = ACTIONS(773),
    [anon_sym_interface] = ACTIONS(773),
    [anon_sym_private] = ACTIONS(773),
    [anon_sym_protected] = ACTIONS(773),
    [anon_sym_pure] = ACTIONS(773),
    [anon_sym_static] = ACTIONS(773),
    [anon_sym_super] = ACTIONS(773),
    [anon_sym_this] = ACTIONS(773),
    [anon_sym_POUND_LPAREN] = ACTIONS(771),
    [anon_sym_if] = ACTIONS(773),
    [anon_sym_break] = ACTIONS(773),
    [anon_sym_continue] = ACTIONS(773),
    [anon_sym_switch] = ACTIONS(773),
    [anon_sym_LT_LT_LT] = ACTIONS(771),
    [anon_sym_ATdoc] = ACTIONS(771),
    [anon_sym_do] = ACTIONS(773),
    [anon_sym_day] = ACTIONS(773),
    [anon_sym_hour] = ACTIONS(773),
    [anon_sym_minute] = ACTIONS(773),
    [anon_sym_ms] = ACTIONS(773),
    [anon_sym_samp] = ACTIONS(773),
    [anon_sym_second] = ACTIONS(773),
    [anon_sym_week] = ACTIONS(773),
    [sym_float] = ACTIONS(771),
    [anon_sym_for] = ACTIONS(773),
    [anon_sym_SEMI] = ACTIONS(771),
    [anon_sym_fun] = ACTIONS(773),
    [anon_sym_adc] = ACTIONS(773),
    [anon_sym_blackhole] = ACTIONS(773),
    [anon_sym_dac] = ACTIONS(773),
    [sym_hexidecimal] = ACTIONS(771),
    [anon_sym_PLUS_PLUS] = ACTIONS(771),
    [anon_sym_DASH_DASH] = ACTIONS(771),
    [anon_sym_ATimport] = ACTIONS(771),
    [sym_int] = ACTIONS(773),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(773),
    [anon_sym_me] = ACTIONS(773),
    [anon_sym_BANG] = ACTIONS(771),
    [anon_sym_DASH] = ACTIONS(773),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(771),
    [anon_sym_auto] = ACTIONS(773),
    [anon_sym_complex] = ACTIONS(773),
    [anon_sym_dur] = ACTIONS(773),
    [anon_sym_float] = ACTIONS(773),
    [anon_sym_int] = ACTIONS(773),
    [anon_sym_polar] = ACTIONS(773),
    [anon_sym_same] = ACTIONS(773),
    [anon_sym_time] = ACTIONS(773),
    [anon_sym_vec2] = ACTIONS(773),
    [anon_sym_vec3] = ACTIONS(773),
    [anon_sym_vec4] = ACTIONS(773),
    [anon_sym_void] = ACTIONS(773),
    [anon_sym_Event] = ACTIONS(773),
    [anon_sym_Object] = ACTIONS(773),
    [anon_sym_UGen] = ACTIONS(773),
    [anon_sym_array] = ACTIONS(773),
    [anon_sym_string] = ACTIONS(773),
    [anon_sym_AT_LPAREN] = ACTIONS(771),
    [anon_sym_NULL] = ACTIONS(773),
    [anon_sym_maybe] = ACTIONS(773),
    [anon_sym_now] = ACTIONS(773),
    [anon_sym_null] = ACTIONS(773),
    [anon_sym_pi] = ACTIONS(773),
    [anon_sym_return] = ACTIONS(773),
    [anon_sym_DQUOTE] = ACTIONS(771),
    [anon_sym_until] = ACTIONS(773),
    [anon_sym_while] = ACTIONS(773),
  },
  [127] = {
    [ts_builtin_sym_end] = ACTIONS(775),
    [sym_variable_identifier] = ACTIONS(777),
    [anon_sym_LBRACK] = ACTIONS(775),
    [anon_sym_LBRACE] = ACTIONS(775),
    [anon_sym_RBRACE] = ACTIONS(775),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(777),
    [anon_sym_true] = ACTIONS(777),
    [anon_sym_SQUOTE] = ACTIONS(775),
    [anon_sym_const] = ACTIONS(777),
    [anon_sym_function] = ACTIONS(777),
    [anon_sym_global] = ACTIONS(777),
    [anon_sym_spork] = ACTIONS(777),
    [anon_sym_LPAREN] = ACTIONS(775),
    [anon_sym_public] = ACTIONS(777),
    [anon_sym_class] = ACTIONS(777),
    [anon_sym_extends] = ACTIONS(777),
    [sym_class_identifier] = ACTIONS(777),
    [anon_sym_new] = ACTIONS(777),
    [anon_sym_implements] = ACTIONS(777),
    [anon_sym_interface] = ACTIONS(777),
    [anon_sym_private] = ACTIONS(777),
    [anon_sym_protected] = ACTIONS(777),
    [anon_sym_pure] = ACTIONS(777),
    [anon_sym_static] = ACTIONS(777),
    [anon_sym_super] = ACTIONS(777),
    [anon_sym_this] = ACTIONS(777),
    [anon_sym_POUND_LPAREN] = ACTIONS(775),
    [anon_sym_if] = ACTIONS(777),
    [anon_sym_break] = ACTIONS(777),
    [anon_sym_continue] = ACTIONS(777),
    [anon_sym_switch] = ACTIONS(777),
    [anon_sym_LT_LT_LT] = ACTIONS(775),
    [anon_sym_ATdoc] = ACTIONS(775),
    [anon_sym_do] = ACTIONS(777),
    [anon_sym_day] = ACTIONS(777),
    [anon_sym_hour] = ACTIONS(777),
    [anon_sym_minute] = ACTIONS(777),
    [anon_sym_ms] = ACTIONS(777),
    [anon_sym_samp] = ACTIONS(777),
    [anon_sym_second] = ACTIONS(777),
    [anon_sym_week] = ACTIONS(777),
    [sym_float] = ACTIONS(775),
    [anon_sym_for] = ACTIONS(777),
    [anon_sym_SEMI] = ACTIONS(775),
    [anon_sym_fun] = ACTIONS(777),
    [anon_sym_adc] = ACTIONS(777),
    [anon_sym_blackhole] = ACTIONS(777),
    [anon_sym_dac] = ACTIONS(777),
    [sym_hexidecimal] = ACTIONS(775),
    [anon_sym_PLUS_PLUS] = ACTIONS(775),
    [anon_sym_DASH_DASH] = ACTIONS(775),
    [anon_sym_ATimport] = ACTIONS(775),
    [sym_int] = ACTIONS(777),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(777),
    [anon_sym_me] = ACTIONS(777),
    [anon_sym_BANG] = ACTIONS(775),
    [anon_sym_DASH] = ACTIONS(777),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(775),
    [anon_sym_auto] = ACTIONS(777),
    [anon_sym_complex] = ACTIONS(777),
    [anon_sym_dur] = ACTIONS(777),
    [anon_sym_float] = ACTIONS(777),
    [anon_sym_int] = ACTIONS(777),
    [anon_sym_polar] = ACTIONS(777),
    [anon_sym_same] = ACTIONS(777),
    [anon_sym_time] = ACTIONS(777),
    [anon_sym_vec2] = ACTIONS(777),
    [anon_sym_vec3] = ACTIONS(777),
    [anon_sym_vec4] = ACTIONS(777),
    [anon_sym_void] = ACTIONS(777),
    [anon_sym_Event] = ACTIONS(777),
    [anon_sym_Object] = ACTIONS(777),
    [anon_sym_UGen] = ACTIONS(777),
    [anon_sym_array] = ACTIONS(777),
    [anon_sym_string] = ACTIONS(777),
    [anon_sym_AT_LPAREN] = ACTIONS(775),
    [anon_sym_NULL] = ACTIONS(777),
    [anon_sym_maybe] = ACTIONS(777),
    [anon_sym_now] = ACTIONS(777),
    [anon_sym_null] = ACTIONS(777),
    [anon_sym_pi] = ACTIONS(777),
    [anon_sym_return] = ACTIONS(777),
    [anon_sym_DQUOTE] = ACTIONS(775),
    [anon_sym_until] = ACTIONS(777),
    [anon_sym_while] = ACTIONS(777),
  },
  [128] = {
    [ts_builtin_sym_end] = ACTIONS(779),
    [sym_variable_identifier] = ACTIONS(781),
    [anon_sym_LBRACK] = ACTIONS(779),
    [anon_sym_LBRACE] = ACTIONS(779),
    [anon_sym_RBRACE] = ACTIONS(779),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(781),
    [anon_sym_true] = ACTIONS(781),
    [anon_sym_SQUOTE] = ACTIONS(779),
    [anon_sym_const] = ACTIONS(781),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_global] = ACTIONS(781),
    [anon_sym_spork] = ACTIONS(781),
    [anon_sym_LPAREN] = ACTIONS(779),
    [anon_sym_public] = ACTIONS(781),
    [anon_sym_class] = ACTIONS(781),
    [anon_sym_extends] = ACTIONS(781),
    [sym_class_identifier] = ACTIONS(781),
    [anon_sym_new] = ACTIONS(781),
    [anon_sym_implements] = ACTIONS(781),
    [anon_sym_interface] = ACTIONS(781),
    [anon_sym_private] = ACTIONS(781),
    [anon_sym_protected] = ACTIONS(781),
    [anon_sym_pure] = ACTIONS(781),
    [anon_sym_static] = ACTIONS(781),
    [anon_sym_super] = ACTIONS(781),
    [anon_sym_this] = ACTIONS(781),
    [anon_sym_POUND_LPAREN] = ACTIONS(779),
    [anon_sym_if] = ACTIONS(781),
    [anon_sym_break] = ACTIONS(781),
    [anon_sym_continue] = ACTIONS(781),
    [anon_sym_switch] = ACTIONS(781),
    [anon_sym_LT_LT_LT] = ACTIONS(779),
    [anon_sym_ATdoc] = ACTIONS(779),
    [anon_sym_do] = ACTIONS(781),
    [anon_sym_day] = ACTIONS(781),
    [anon_sym_hour] = ACTIONS(781),
    [anon_sym_minute] = ACTIONS(781),
    [anon_sym_ms] = ACTIONS(781),
    [anon_sym_samp] = ACTIONS(781),
    [anon_sym_second] = ACTIONS(781),
    [anon_sym_week] = ACTIONS(781),
    [sym_float] = ACTIONS(779),
    [anon_sym_for] = ACTIONS(781),
    [anon_sym_SEMI] = ACTIONS(779),
    [anon_sym_fun] = ACTIONS(781),
    [anon_sym_adc] = ACTIONS(781),
    [anon_sym_blackhole] = ACTIONS(781),
    [anon_sym_dac] = ACTIONS(781),
    [sym_hexidecimal] = ACTIONS(779),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_ATimport] = ACTIONS(779),
    [sym_int] = ACTIONS(781),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(781),
    [anon_sym_me] = ACTIONS(781),
    [anon_sym_BANG] = ACTIONS(779),
    [anon_sym_DASH] = ACTIONS(781),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(779),
    [anon_sym_auto] = ACTIONS(781),
    [anon_sym_complex] = ACTIONS(781),
    [anon_sym_dur] = ACTIONS(781),
    [anon_sym_float] = ACTIONS(781),
    [anon_sym_int] = ACTIONS(781),
    [anon_sym_polar] = ACTIONS(781),
    [anon_sym_same] = ACTIONS(781),
    [anon_sym_time] = ACTIONS(781),
    [anon_sym_vec2] = ACTIONS(781),
    [anon_sym_vec3] = ACTIONS(781),
    [anon_sym_vec4] = ACTIONS(781),
    [anon_sym_void] = ACTIONS(781),
    [anon_sym_Event] = ACTIONS(781),
    [anon_sym_Object] = ACTIONS(781),
    [anon_sym_UGen] = ACTIONS(781),
    [anon_sym_array] = ACTIONS(781),
    [anon_sym_string] = ACTIONS(781),
    [anon_sym_AT_LPAREN] = ACTIONS(779),
    [anon_sym_NULL] = ACTIONS(781),
    [anon_sym_maybe] = ACTIONS(781),
    [anon_sym_now] = ACTIONS(781),
    [anon_sym_null] = ACTIONS(781),
    [anon_sym_pi] = ACTIONS(781),
    [anon_sym_return] = ACTIONS(781),
    [anon_sym_DQUOTE] = ACTIONS(779),
    [anon_sym_until] = ACTIONS(781),
    [anon_sym_while] = ACTIONS(781),
  },
  [129] = {
    [ts_builtin_sym_end] = ACTIONS(779),
    [sym_variable_identifier] = ACTIONS(781),
    [anon_sym_LBRACK] = ACTIONS(779),
    [anon_sym_LBRACE] = ACTIONS(779),
    [anon_sym_RBRACE] = ACTIONS(779),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(781),
    [anon_sym_true] = ACTIONS(781),
    [anon_sym_SQUOTE] = ACTIONS(779),
    [anon_sym_const] = ACTIONS(781),
    [anon_sym_function] = ACTIONS(781),
    [anon_sym_global] = ACTIONS(781),
    [anon_sym_spork] = ACTIONS(781),
    [anon_sym_LPAREN] = ACTIONS(779),
    [anon_sym_public] = ACTIONS(781),
    [anon_sym_class] = ACTIONS(781),
    [anon_sym_extends] = ACTIONS(781),
    [sym_class_identifier] = ACTIONS(781),
    [anon_sym_new] = ACTIONS(781),
    [anon_sym_implements] = ACTIONS(781),
    [anon_sym_interface] = ACTIONS(781),
    [anon_sym_private] = ACTIONS(781),
    [anon_sym_protected] = ACTIONS(781),
    [anon_sym_pure] = ACTIONS(781),
    [anon_sym_static] = ACTIONS(781),
    [anon_sym_super] = ACTIONS(781),
    [anon_sym_this] = ACTIONS(781),
    [anon_sym_POUND_LPAREN] = ACTIONS(779),
    [anon_sym_if] = ACTIONS(781),
    [anon_sym_break] = ACTIONS(781),
    [anon_sym_continue] = ACTIONS(781),
    [anon_sym_switch] = ACTIONS(781),
    [anon_sym_LT_LT_LT] = ACTIONS(779),
    [anon_sym_ATdoc] = ACTIONS(779),
    [anon_sym_do] = ACTIONS(781),
    [anon_sym_day] = ACTIONS(781),
    [anon_sym_hour] = ACTIONS(781),
    [anon_sym_minute] = ACTIONS(781),
    [anon_sym_ms] = ACTIONS(781),
    [anon_sym_samp] = ACTIONS(781),
    [anon_sym_second] = ACTIONS(781),
    [anon_sym_week] = ACTIONS(781),
    [sym_float] = ACTIONS(779),
    [anon_sym_for] = ACTIONS(781),
    [anon_sym_SEMI] = ACTIONS(779),
    [anon_sym_fun] = ACTIONS(781),
    [anon_sym_adc] = ACTIONS(781),
    [anon_sym_blackhole] = ACTIONS(781),
    [anon_sym_dac] = ACTIONS(781),
    [sym_hexidecimal] = ACTIONS(779),
    [anon_sym_PLUS_PLUS] = ACTIONS(779),
    [anon_sym_DASH_DASH] = ACTIONS(779),
    [anon_sym_ATimport] = ACTIONS(779),
    [sym_int] = ACTIONS(781),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(781),
    [anon_sym_me] = ACTIONS(781),
    [anon_sym_BANG] = ACTIONS(779),
    [anon_sym_DASH] = ACTIONS(781),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(779),
    [anon_sym_auto] = ACTIONS(781),
    [anon_sym_complex] = ACTIONS(781),
    [anon_sym_dur] = ACTIONS(781),
    [anon_sym_float] = ACTIONS(781),
    [anon_sym_int] = ACTIONS(781),
    [anon_sym_polar] = ACTIONS(781),
    [anon_sym_same] = ACTIONS(781),
    [anon_sym_time] = ACTIONS(781),
    [anon_sym_vec2] = ACTIONS(781),
    [anon_sym_vec3] = ACTIONS(781),
    [anon_sym_vec4] = ACTIONS(781),
    [anon_sym_void] = ACTIONS(781),
    [anon_sym_Event] = ACTIONS(781),
    [anon_sym_Object] = ACTIONS(781),
    [anon_sym_UGen] = ACTIONS(781),
    [anon_sym_array] = ACTIONS(781),
    [anon_sym_string] = ACTIONS(781),
    [anon_sym_AT_LPAREN] = ACTIONS(779),
    [anon_sym_NULL] = ACTIONS(781),
    [anon_sym_maybe] = ACTIONS(781),
    [anon_sym_now] = ACTIONS(781),
    [anon_sym_null] = ACTIONS(781),
    [anon_sym_pi] = ACTIONS(781),
    [anon_sym_return] = ACTIONS(781),
    [anon_sym_DQUOTE] = ACTIONS(779),
    [anon_sym_until] = ACTIONS(781),
    [anon_sym_while] = ACTIONS(781),
  },
  [130] = {
    [ts_builtin_sym_end] = ACTIONS(699),
    [sym_variable_identifier] = ACTIONS(701),
    [anon_sym_LBRACK] = ACTIONS(699),
    [anon_sym_LBRACE] = ACTIONS(699),
    [anon_sym_RBRACE] = ACTIONS(699),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(701),
    [anon_sym_true] = ACTIONS(701),
    [anon_sym_SQUOTE] = ACTIONS(699),
    [anon_sym_const] = ACTIONS(701),
    [anon_sym_function] = ACTIONS(701),
    [anon_sym_global] = ACTIONS(701),
    [anon_sym_spork] = ACTIONS(701),
    [anon_sym_LPAREN] = ACTIONS(699),
    [anon_sym_public] = ACTIONS(701),
    [anon_sym_class] = ACTIONS(701),
    [anon_sym_extends] = ACTIONS(701),
    [sym_class_identifier] = ACTIONS(701),
    [anon_sym_new] = ACTIONS(701),
    [anon_sym_implements] = ACTIONS(701),
    [anon_sym_interface] = ACTIONS(701),
    [anon_sym_private] = ACTIONS(701),
    [anon_sym_protected] = ACTIONS(701),
    [anon_sym_pure] = ACTIONS(701),
    [anon_sym_static] = ACTIONS(701),
    [anon_sym_super] = ACTIONS(701),
    [anon_sym_this] = ACTIONS(701),
    [anon_sym_POUND_LPAREN] = ACTIONS(699),
    [anon_sym_if] = ACTIONS(701),
    [anon_sym_break] = ACTIONS(701),
    [anon_sym_continue] = ACTIONS(701),
    [anon_sym_switch] = ACTIONS(701),
    [anon_sym_LT_LT_LT] = ACTIONS(699),
    [anon_sym_ATdoc] = ACTIONS(699),
    [anon_sym_do] = ACTIONS(701),
    [anon_sym_day] = ACTIONS(701),
    [anon_sym_hour] = ACTIONS(701),
    [anon_sym_minute] = ACTIONS(701),
    [anon_sym_ms] = ACTIONS(701),
    [anon_sym_samp] = ACTIONS(701),
    [anon_sym_second] = ACTIONS(701),
    [anon_sym_week] = ACTIONS(701),
    [sym_float] = ACTIONS(699),
    [anon_sym_for] = ACTIONS(701),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_fun] = ACTIONS(701),
    [anon_sym_adc] = ACTIONS(701),
    [anon_sym_blackhole] = ACTIONS(701),
    [anon_sym_dac] = ACTIONS(701),
    [sym_hexidecimal] = ACTIONS(699),
    [anon_sym_PLUS_PLUS] = ACTIONS(699),
    [anon_sym_DASH_DASH] = ACTIONS(699),
    [anon_sym_ATimport] = ACTIONS(699),
    [sym_int] = ACTIONS(701),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(701),
    [anon_sym_me] = ACTIONS(701),
    [anon_sym_BANG] = ACTIONS(699),
    [anon_sym_DASH] = ACTIONS(701),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(699),
    [anon_sym_auto] = ACTIONS(701),
    [anon_sym_complex] = ACTIONS(701),
    [anon_sym_dur] = ACTIONS(701),
    [anon_sym_float] = ACTIONS(701),
    [anon_sym_int] = ACTIONS(701),
    [anon_sym_polar] = ACTIONS(701),
    [anon_sym_same] = ACTIONS(701),
    [anon_sym_time] = ACTIONS(701),
    [anon_sym_vec2] = ACTIONS(701),
    [anon_sym_vec3] = ACTIONS(701),
    [anon_sym_vec4] = ACTIONS(701),
    [anon_sym_void] = ACTIONS(701),
    [anon_sym_Event] = ACTIONS(701),
    [anon_sym_Object] = ACTIONS(701),
    [anon_sym_UGen] = ACTIONS(701),
    [anon_sym_array] = ACTIONS(701),
    [anon_sym_string] = ACTIONS(701),
    [anon_sym_AT_LPAREN] = ACTIONS(699),
    [anon_sym_NULL] = ACTIONS(701),
    [anon_sym_maybe] = ACTIONS(701),
    [anon_sym_now] = ACTIONS(701),
    [anon_sym_null] = ACTIONS(701),
    [anon_sym_pi] = ACTIONS(701),
    [anon_sym_return] = ACTIONS(701),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_until] = ACTIONS(701),
    [anon_sym_while] = ACTIONS(701),
  },
  [131] = {
    [ts_builtin_sym_end] = ACTIONS(783),
    [sym_variable_identifier] = ACTIONS(785),
    [anon_sym_LBRACK] = ACTIONS(783),
    [anon_sym_LBRACE] = ACTIONS(783),
    [anon_sym_RBRACE] = ACTIONS(783),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(785),
    [anon_sym_true] = ACTIONS(785),
    [anon_sym_SQUOTE] = ACTIONS(783),
    [anon_sym_const] = ACTIONS(785),
    [anon_sym_function] = ACTIONS(785),
    [anon_sym_global] = ACTIONS(785),
    [anon_sym_spork] = ACTIONS(785),
    [anon_sym_LPAREN] = ACTIONS(783),
    [anon_sym_public] = ACTIONS(785),
    [anon_sym_class] = ACTIONS(785),
    [anon_sym_extends] = ACTIONS(785),
    [sym_class_identifier] = ACTIONS(785),
    [anon_sym_new] = ACTIONS(785),
    [anon_sym_implements] = ACTIONS(785),
    [anon_sym_interface] = ACTIONS(785),
    [anon_sym_private] = ACTIONS(785),
    [anon_sym_protected] = ACTIONS(785),
    [anon_sym_pure] = ACTIONS(785),
    [anon_sym_static] = ACTIONS(785),
    [anon_sym_super] = ACTIONS(785),
    [anon_sym_this] = ACTIONS(785),
    [anon_sym_POUND_LPAREN] = ACTIONS(783),
    [anon_sym_if] = ACTIONS(785),
    [anon_sym_break] = ACTIONS(785),
    [anon_sym_continue] = ACTIONS(785),
    [anon_sym_switch] = ACTIONS(785),
    [anon_sym_LT_LT_LT] = ACTIONS(783),
    [anon_sym_ATdoc] = ACTIONS(783),
    [anon_sym_do] = ACTIONS(785),
    [anon_sym_day] = ACTIONS(785),
    [anon_sym_hour] = ACTIONS(785),
    [anon_sym_minute] = ACTIONS(785),
    [anon_sym_ms] = ACTIONS(785),
    [anon_sym_samp] = ACTIONS(785),
    [anon_sym_second] = ACTIONS(785),
    [anon_sym_week] = ACTIONS(785),
    [sym_float] = ACTIONS(783),
    [anon_sym_for] = ACTIONS(785),
    [anon_sym_SEMI] = ACTIONS(783),
    [anon_sym_fun] = ACTIONS(785),
    [anon_sym_adc] = ACTIONS(785),
    [anon_sym_blackhole] = ACTIONS(785),
    [anon_sym_dac] = ACTIONS(785),
    [sym_hexidecimal] = ACTIONS(783),
    [anon_sym_PLUS_PLUS] = ACTIONS(783),
    [anon_sym_DASH_DASH] = ACTIONS(783),
    [anon_sym_ATimport] = ACTIONS(783),
    [sym_int] = ACTIONS(785),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(785),
    [anon_sym_me] = ACTIONS(785),
    [anon_sym_BANG] = ACTIONS(783),
    [anon_sym_DASH] = ACTIONS(785),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(783),
    [anon_sym_auto] = ACTIONS(785),
    [anon_sym_complex] = ACTIONS(785),
    [anon_sym_dur] = ACTIONS(785),
    [anon_sym_float] = ACTIONS(785),
    [anon_sym_int] = ACTIONS(785),
    [anon_sym_polar] = ACTIONS(785),
    [anon_sym_same] = ACTIONS(785),
    [anon_sym_time] = ACTIONS(785),
    [anon_sym_vec2] = ACTIONS(785),
    [anon_sym_vec3] = ACTIONS(785),
    [anon_sym_vec4] = ACTIONS(785),
    [anon_sym_void] = ACTIONS(785),
    [anon_sym_Event] = ACTIONS(785),
    [anon_sym_Object] = ACTIONS(785),
    [anon_sym_UGen] = ACTIONS(785),
    [anon_sym_array] = ACTIONS(785),
    [anon_sym_string] = ACTIONS(785),
    [anon_sym_AT_LPAREN] = ACTIONS(783),
    [anon_sym_NULL] = ACTIONS(785),
    [anon_sym_maybe] = ACTIONS(785),
    [anon_sym_now] = ACTIONS(785),
    [anon_sym_null] = ACTIONS(785),
    [anon_sym_pi] = ACTIONS(785),
    [anon_sym_return] = ACTIONS(785),
    [anon_sym_DQUOTE] = ACTIONS(783),
    [anon_sym_until] = ACTIONS(785),
    [anon_sym_while] = ACTIONS(785),
  },
  [132] = {
    [ts_builtin_sym_end] = ACTIONS(787),
    [sym_variable_identifier] = ACTIONS(789),
    [anon_sym_LBRACK] = ACTIONS(787),
    [anon_sym_LBRACE] = ACTIONS(787),
    [anon_sym_RBRACE] = ACTIONS(787),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(789),
    [anon_sym_true] = ACTIONS(789),
    [anon_sym_SQUOTE] = ACTIONS(787),
    [anon_sym_const] = ACTIONS(789),
    [anon_sym_function] = ACTIONS(789),
    [anon_sym_global] = ACTIONS(789),
    [anon_sym_spork] = ACTIONS(789),
    [anon_sym_LPAREN] = ACTIONS(787),
    [anon_sym_public] = ACTIONS(789),
    [anon_sym_class] = ACTIONS(789),
    [anon_sym_extends] = ACTIONS(789),
    [sym_class_identifier] = ACTIONS(789),
    [anon_sym_new] = ACTIONS(789),
    [anon_sym_implements] = ACTIONS(789),
    [anon_sym_interface] = ACTIONS(789),
    [anon_sym_private] = ACTIONS(789),
    [anon_sym_protected] = ACTIONS(789),
    [anon_sym_pure] = ACTIONS(789),
    [anon_sym_static] = ACTIONS(789),
    [anon_sym_super] = ACTIONS(789),
    [anon_sym_this] = ACTIONS(789),
    [anon_sym_POUND_LPAREN] = ACTIONS(787),
    [anon_sym_if] = ACTIONS(789),
    [anon_sym_break] = ACTIONS(789),
    [anon_sym_continue] = ACTIONS(789),
    [anon_sym_switch] = ACTIONS(789),
    [anon_sym_LT_LT_LT] = ACTIONS(787),
    [anon_sym_ATdoc] = ACTIONS(787),
    [anon_sym_do] = ACTIONS(789),
    [anon_sym_day] = ACTIONS(789),
    [anon_sym_hour] = ACTIONS(789),
    [anon_sym_minute] = ACTIONS(789),
    [anon_sym_ms] = ACTIONS(789),
    [anon_sym_samp] = ACTIONS(789),
    [anon_sym_second] = ACTIONS(789),
    [anon_sym_week] = ACTIONS(789),
    [sym_float] = ACTIONS(787),
    [anon_sym_for] = ACTIONS(789),
    [anon_sym_SEMI] = ACTIONS(787),
    [anon_sym_fun] = ACTIONS(789),
    [anon_sym_adc] = ACTIONS(789),
    [anon_sym_blackhole] = ACTIONS(789),
    [anon_sym_dac] = ACTIONS(789),
    [sym_hexidecimal] = ACTIONS(787),
    [anon_sym_PLUS_PLUS] = ACTIONS(787),
    [anon_sym_DASH_DASH] = ACTIONS(787),
    [anon_sym_ATimport] = ACTIONS(787),
    [sym_int] = ACTIONS(789),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(789),
    [anon_sym_me] = ACTIONS(789),
    [anon_sym_BANG] = ACTIONS(787),
    [anon_sym_DASH] = ACTIONS(789),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(787),
    [anon_sym_auto] = ACTIONS(789),
    [anon_sym_complex] = ACTIONS(789),
    [anon_sym_dur] = ACTIONS(789),
    [anon_sym_float] = ACTIONS(789),
    [anon_sym_int] = ACTIONS(789),
    [anon_sym_polar] = ACTIONS(789),
    [anon_sym_same] = ACTIONS(789),
    [anon_sym_time] = ACTIONS(789),
    [anon_sym_vec2] = ACTIONS(789),
    [anon_sym_vec3] = ACTIONS(789),
    [anon_sym_vec4] = ACTIONS(789),
    [anon_sym_void] = ACTIONS(789),
    [anon_sym_Event] = ACTIONS(789),
    [anon_sym_Object] = ACTIONS(789),
    [anon_sym_UGen] = ACTIONS(789),
    [anon_sym_array] = ACTIONS(789),
    [anon_sym_string] = ACTIONS(789),
    [anon_sym_AT_LPAREN] = ACTIONS(787),
    [anon_sym_NULL] = ACTIONS(789),
    [anon_sym_maybe] = ACTIONS(789),
    [anon_sym_now] = ACTIONS(789),
    [anon_sym_null] = ACTIONS(789),
    [anon_sym_pi] = ACTIONS(789),
    [anon_sym_return] = ACTIONS(789),
    [anon_sym_DQUOTE] = ACTIONS(787),
    [anon_sym_until] = ACTIONS(789),
    [anon_sym_while] = ACTIONS(789),
  },
  [133] = {
    [ts_builtin_sym_end] = ACTIONS(791),
    [sym_variable_identifier] = ACTIONS(793),
    [anon_sym_LBRACK] = ACTIONS(791),
    [anon_sym_LBRACE] = ACTIONS(791),
    [anon_sym_RBRACE] = ACTIONS(791),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(793),
    [anon_sym_true] = ACTIONS(793),
    [anon_sym_SQUOTE] = ACTIONS(791),
    [anon_sym_const] = ACTIONS(793),
    [anon_sym_function] = ACTIONS(793),
    [anon_sym_global] = ACTIONS(793),
    [anon_sym_spork] = ACTIONS(793),
    [anon_sym_LPAREN] = ACTIONS(791),
    [anon_sym_public] = ACTIONS(793),
    [anon_sym_class] = ACTIONS(793),
    [anon_sym_extends] = ACTIONS(793),
    [sym_class_identifier] = ACTIONS(793),
    [anon_sym_new] = ACTIONS(793),
    [anon_sym_implements] = ACTIONS(793),
    [anon_sym_interface] = ACTIONS(793),
    [anon_sym_private] = ACTIONS(793),
    [anon_sym_protected] = ACTIONS(793),
    [anon_sym_pure] = ACTIONS(793),
    [anon_sym_static] = ACTIONS(793),
    [anon_sym_super] = ACTIONS(793),
    [anon_sym_this] = ACTIONS(793),
    [anon_sym_POUND_LPAREN] = ACTIONS(791),
    [anon_sym_if] = ACTIONS(793),
    [anon_sym_break] = ACTIONS(793),
    [anon_sym_continue] = ACTIONS(793),
    [anon_sym_switch] = ACTIONS(793),
    [anon_sym_LT_LT_LT] = ACTIONS(791),
    [anon_sym_ATdoc] = ACTIONS(791),
    [anon_sym_do] = ACTIONS(793),
    [anon_sym_day] = ACTIONS(793),
    [anon_sym_hour] = ACTIONS(793),
    [anon_sym_minute] = ACTIONS(793),
    [anon_sym_ms] = ACTIONS(793),
    [anon_sym_samp] = ACTIONS(793),
    [anon_sym_second] = ACTIONS(793),
    [anon_sym_week] = ACTIONS(793),
    [sym_float] = ACTIONS(791),
    [anon_sym_for] = ACTIONS(793),
    [anon_sym_SEMI] = ACTIONS(791),
    [anon_sym_fun] = ACTIONS(793),
    [anon_sym_adc] = ACTIONS(793),
    [anon_sym_blackhole] = ACTIONS(793),
    [anon_sym_dac] = ACTIONS(793),
    [sym_hexidecimal] = ACTIONS(791),
    [anon_sym_PLUS_PLUS] = ACTIONS(791),
    [anon_sym_DASH_DASH] = ACTIONS(791),
    [anon_sym_ATimport] = ACTIONS(791),
    [sym_int] = ACTIONS(793),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(793),
    [anon_sym_me] = ACTIONS(793),
    [anon_sym_BANG] = ACTIONS(791),
    [anon_sym_DASH] = ACTIONS(793),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(791),
    [anon_sym_auto] = ACTIONS(793),
    [anon_sym_complex] = ACTIONS(793),
    [anon_sym_dur] = ACTIONS(793),
    [anon_sym_float] = ACTIONS(793),
    [anon_sym_int] = ACTIONS(793),
    [anon_sym_polar] = ACTIONS(793),
    [anon_sym_same] = ACTIONS(793),
    [anon_sym_time] = ACTIONS(793),
    [anon_sym_vec2] = ACTIONS(793),
    [anon_sym_vec3] = ACTIONS(793),
    [anon_sym_vec4] = ACTIONS(793),
    [anon_sym_void] = ACTIONS(793),
    [anon_sym_Event] = ACTIONS(793),
    [anon_sym_Object] = ACTIONS(793),
    [anon_sym_UGen] = ACTIONS(793),
    [anon_sym_array] = ACTIONS(793),
    [anon_sym_string] = ACTIONS(793),
    [anon_sym_AT_LPAREN] = ACTIONS(791),
    [anon_sym_NULL] = ACTIONS(793),
    [anon_sym_maybe] = ACTIONS(793),
    [anon_sym_now] = ACTIONS(793),
    [anon_sym_null] = ACTIONS(793),
    [anon_sym_pi] = ACTIONS(793),
    [anon_sym_return] = ACTIONS(793),
    [anon_sym_DQUOTE] = ACTIONS(791),
    [anon_sym_until] = ACTIONS(793),
    [anon_sym_while] = ACTIONS(793),
  },
  [134] = {
    [ts_builtin_sym_end] = ACTIONS(711),
    [sym_variable_identifier] = ACTIONS(713),
    [anon_sym_LBRACK] = ACTIONS(711),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_RBRACE] = ACTIONS(711),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(713),
    [anon_sym_true] = ACTIONS(713),
    [anon_sym_SQUOTE] = ACTIONS(711),
    [anon_sym_const] = ACTIONS(713),
    [anon_sym_function] = ACTIONS(713),
    [anon_sym_global] = ACTIONS(713),
    [anon_sym_spork] = ACTIONS(713),
    [anon_sym_LPAREN] = ACTIONS(711),
    [anon_sym_public] = ACTIONS(713),
    [anon_sym_class] = ACTIONS(713),
    [anon_sym_extends] = ACTIONS(713),
    [sym_class_identifier] = ACTIONS(713),
    [anon_sym_new] = ACTIONS(713),
    [anon_sym_implements] = ACTIONS(713),
    [anon_sym_interface] = ACTIONS(713),
    [anon_sym_private] = ACTIONS(713),
    [anon_sym_protected] = ACTIONS(713),
    [anon_sym_pure] = ACTIONS(713),
    [anon_sym_static] = ACTIONS(713),
    [anon_sym_super] = ACTIONS(713),
    [anon_sym_this] = ACTIONS(713),
    [anon_sym_POUND_LPAREN] = ACTIONS(711),
    [anon_sym_if] = ACTIONS(713),
    [anon_sym_break] = ACTIONS(713),
    [anon_sym_continue] = ACTIONS(713),
    [anon_sym_switch] = ACTIONS(713),
    [anon_sym_LT_LT_LT] = ACTIONS(711),
    [anon_sym_ATdoc] = ACTIONS(711),
    [anon_sym_do] = ACTIONS(713),
    [anon_sym_day] = ACTIONS(713),
    [anon_sym_hour] = ACTIONS(713),
    [anon_sym_minute] = ACTIONS(713),
    [anon_sym_ms] = ACTIONS(713),
    [anon_sym_samp] = ACTIONS(713),
    [anon_sym_second] = ACTIONS(713),
    [anon_sym_week] = ACTIONS(713),
    [sym_float] = ACTIONS(711),
    [anon_sym_for] = ACTIONS(713),
    [anon_sym_fun] = ACTIONS(713),
    [anon_sym_adc] = ACTIONS(713),
    [anon_sym_blackhole] = ACTIONS(713),
    [anon_sym_dac] = ACTIONS(713),
    [sym_hexidecimal] = ACTIONS(711),
    [anon_sym_PLUS_PLUS] = ACTIONS(711),
    [anon_sym_DASH_DASH] = ACTIONS(711),
    [anon_sym_ATimport] = ACTIONS(711),
    [sym_int] = ACTIONS(713),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(713),
    [anon_sym_me] = ACTIONS(713),
    [anon_sym_BANG] = ACTIONS(711),
    [anon_sym_DASH] = ACTIONS(713),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(711),
    [anon_sym_auto] = ACTIONS(713),
    [anon_sym_complex] = ACTIONS(713),
    [anon_sym_dur] = ACTIONS(713),
    [anon_sym_float] = ACTIONS(713),
    [anon_sym_int] = ACTIONS(713),
    [anon_sym_polar] = ACTIONS(713),
    [anon_sym_same] = ACTIONS(713),
    [anon_sym_time] = ACTIONS(713),
    [anon_sym_vec2] = ACTIONS(713),
    [anon_sym_vec3] = ACTIONS(713),
    [anon_sym_vec4] = ACTIONS(713),
    [anon_sym_void] = ACTIONS(713),
    [anon_sym_Event] = ACTIONS(713),
    [anon_sym_Object] = ACTIONS(713),
    [anon_sym_UGen] = ACTIONS(713),
    [anon_sym_array] = ACTIONS(713),
    [anon_sym_string] = ACTIONS(713),
    [anon_sym_AT_LPAREN] = ACTIONS(711),
    [anon_sym_NULL] = ACTIONS(713),
    [anon_sym_maybe] = ACTIONS(713),
    [anon_sym_now] = ACTIONS(713),
    [anon_sym_null] = ACTIONS(713),
    [anon_sym_pi] = ACTIONS(713),
    [anon_sym_return] = ACTIONS(713),
    [anon_sym_DQUOTE] = ACTIONS(711),
    [anon_sym_until] = ACTIONS(713),
    [anon_sym_while] = ACTIONS(713),
  },
  [135] = {
    [ts_builtin_sym_end] = ACTIONS(795),
    [sym_variable_identifier] = ACTIONS(797),
    [anon_sym_LBRACK] = ACTIONS(795),
    [anon_sym_LBRACE] = ACTIONS(795),
    [anon_sym_RBRACE] = ACTIONS(795),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(797),
    [anon_sym_true] = ACTIONS(797),
    [anon_sym_SQUOTE] = ACTIONS(795),
    [anon_sym_const] = ACTIONS(797),
    [anon_sym_function] = ACTIONS(797),
    [anon_sym_global] = ACTIONS(797),
    [anon_sym_spork] = ACTIONS(797),
    [anon_sym_LPAREN] = ACTIONS(795),
    [anon_sym_public] = ACTIONS(797),
    [anon_sym_class] = ACTIONS(797),
    [anon_sym_extends] = ACTIONS(797),
    [sym_class_identifier] = ACTIONS(797),
    [anon_sym_new] = ACTIONS(797),
    [anon_sym_implements] = ACTIONS(797),
    [anon_sym_interface] = ACTIONS(797),
    [anon_sym_private] = ACTIONS(797),
    [anon_sym_protected] = ACTIONS(797),
    [anon_sym_pure] = ACTIONS(797),
    [anon_sym_static] = ACTIONS(797),
    [anon_sym_super] = ACTIONS(797),
    [anon_sym_this] = ACTIONS(797),
    [anon_sym_POUND_LPAREN] = ACTIONS(795),
    [anon_sym_if] = ACTIONS(797),
    [anon_sym_break] = ACTIONS(797),
    [anon_sym_continue] = ACTIONS(797),
    [anon_sym_switch] = ACTIONS(797),
    [anon_sym_LT_LT_LT] = ACTIONS(795),
    [anon_sym_ATdoc] = ACTIONS(795),
    [anon_sym_do] = ACTIONS(797),
    [anon_sym_day] = ACTIONS(797),
    [anon_sym_hour] = ACTIONS(797),
    [anon_sym_minute] = ACTIONS(797),
    [anon_sym_ms] = ACTIONS(797),
    [anon_sym_samp] = ACTIONS(797),
    [anon_sym_second] = ACTIONS(797),
    [anon_sym_week] = ACTIONS(797),
    [sym_float] = ACTIONS(795),
    [anon_sym_for] = ACTIONS(797),
    [anon_sym_fun] = ACTIONS(797),
    [anon_sym_adc] = ACTIONS(797),
    [anon_sym_blackhole] = ACTIONS(797),
    [anon_sym_dac] = ACTIONS(797),
    [sym_hexidecimal] = ACTIONS(795),
    [anon_sym_PLUS_PLUS] = ACTIONS(795),
    [anon_sym_DASH_DASH] = ACTIONS(795),
    [anon_sym_ATimport] = ACTIONS(795),
    [sym_int] = ACTIONS(797),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(797),
    [anon_sym_me] = ACTIONS(797),
    [anon_sym_BANG] = ACTIONS(795),
    [anon_sym_DASH] = ACTIONS(797),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(795),
    [anon_sym_auto] = ACTIONS(797),
    [anon_sym_complex] = ACTIONS(797),
    [anon_sym_dur] = ACTIONS(797),
    [anon_sym_float] = ACTIONS(797),
    [anon_sym_int] = ACTIONS(797),
    [anon_sym_polar] = ACTIONS(797),
    [anon_sym_same] = ACTIONS(797),
    [anon_sym_time] = ACTIONS(797),
    [anon_sym_vec2] = ACTIONS(797),
    [anon_sym_vec3] = ACTIONS(797),
    [anon_sym_vec4] = ACTIONS(797),
    [anon_sym_void] = ACTIONS(797),
    [anon_sym_Event] = ACTIONS(797),
    [anon_sym_Object] = ACTIONS(797),
    [anon_sym_UGen] = ACTIONS(797),
    [anon_sym_array] = ACTIONS(797),
    [anon_sym_string] = ACTIONS(797),
    [anon_sym_AT_LPAREN] = ACTIONS(795),
    [anon_sym_NULL] = ACTIONS(797),
    [anon_sym_maybe] = ACTIONS(797),
    [anon_sym_now] = ACTIONS(797),
    [anon_sym_null] = ACTIONS(797),
    [anon_sym_pi] = ACTIONS(797),
    [anon_sym_return] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(795),
    [anon_sym_until] = ACTIONS(797),
    [anon_sym_while] = ACTIONS(797),
  },
  [136] = {
    [ts_builtin_sym_end] = ACTIONS(799),
    [sym_variable_identifier] = ACTIONS(801),
    [anon_sym_LBRACK] = ACTIONS(799),
    [anon_sym_LBRACE] = ACTIONS(799),
    [anon_sym_RBRACE] = ACTIONS(799),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(801),
    [anon_sym_true] = ACTIONS(801),
    [anon_sym_SQUOTE] = ACTIONS(799),
    [anon_sym_const] = ACTIONS(801),
    [anon_sym_function] = ACTIONS(801),
    [anon_sym_global] = ACTIONS(801),
    [anon_sym_spork] = ACTIONS(801),
    [anon_sym_LPAREN] = ACTIONS(799),
    [anon_sym_public] = ACTIONS(801),
    [anon_sym_class] = ACTIONS(801),
    [anon_sym_extends] = ACTIONS(801),
    [sym_class_identifier] = ACTIONS(801),
    [anon_sym_new] = ACTIONS(801),
    [anon_sym_implements] = ACTIONS(801),
    [anon_sym_interface] = ACTIONS(801),
    [anon_sym_private] = ACTIONS(801),
    [anon_sym_protected] = ACTIONS(801),
    [anon_sym_pure] = ACTIONS(801),
    [anon_sym_static] = ACTIONS(801),
    [anon_sym_super] = ACTIONS(801),
    [anon_sym_this] = ACTIONS(801),
    [anon_sym_POUND_LPAREN] = ACTIONS(799),
    [anon_sym_if] = ACTIONS(801),
    [anon_sym_break] = ACTIONS(801),
    [anon_sym_continue] = ACTIONS(801),
    [anon_sym_switch] = ACTIONS(801),
    [anon_sym_LT_LT_LT] = ACTIONS(799),
    [anon_sym_ATdoc] = ACTIONS(799),
    [anon_sym_do] = ACTIONS(801),
    [anon_sym_day] = ACTIONS(801),
    [anon_sym_hour] = ACTIONS(801),
    [anon_sym_minute] = ACTIONS(801),
    [anon_sym_ms] = ACTIONS(801),
    [anon_sym_samp] = ACTIONS(801),
    [anon_sym_second] = ACTIONS(801),
    [anon_sym_week] = ACTIONS(801),
    [sym_float] = ACTIONS(799),
    [anon_sym_for] = ACTIONS(801),
    [anon_sym_fun] = ACTIONS(801),
    [anon_sym_adc] = ACTIONS(801),
    [anon_sym_blackhole] = ACTIONS(801),
    [anon_sym_dac] = ACTIONS(801),
    [sym_hexidecimal] = ACTIONS(799),
    [anon_sym_PLUS_PLUS] = ACTIONS(799),
    [anon_sym_DASH_DASH] = ACTIONS(799),
    [anon_sym_ATimport] = ACTIONS(799),
    [sym_int] = ACTIONS(801),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(801),
    [anon_sym_me] = ACTIONS(801),
    [anon_sym_BANG] = ACTIONS(799),
    [anon_sym_DASH] = ACTIONS(801),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(799),
    [anon_sym_auto] = ACTIONS(801),
    [anon_sym_complex] = ACTIONS(801),
    [anon_sym_dur] = ACTIONS(801),
    [anon_sym_float] = ACTIONS(801),
    [anon_sym_int] = ACTIONS(801),
    [anon_sym_polar] = ACTIONS(801),
    [anon_sym_same] = ACTIONS(801),
    [anon_sym_time] = ACTIONS(801),
    [anon_sym_vec2] = ACTIONS(801),
    [anon_sym_vec3] = ACTIONS(801),
    [anon_sym_vec4] = ACTIONS(801),
    [anon_sym_void] = ACTIONS(801),
    [anon_sym_Event] = ACTIONS(801),
    [anon_sym_Object] = ACTIONS(801),
    [anon_sym_UGen] = ACTIONS(801),
    [anon_sym_array] = ACTIONS(801),
    [anon_sym_string] = ACTIONS(801),
    [anon_sym_AT_LPAREN] = ACTIONS(799),
    [anon_sym_NULL] = ACTIONS(801),
    [anon_sym_maybe] = ACTIONS(801),
    [anon_sym_now] = ACTIONS(801),
    [anon_sym_null] = ACTIONS(801),
    [anon_sym_pi] = ACTIONS(801),
    [anon_sym_return] = ACTIONS(801),
    [anon_sym_DQUOTE] = ACTIONS(799),
    [anon_sym_until] = ACTIONS(801),
    [anon_sym_while] = ACTIONS(801),
  },
  [137] = {
    [ts_builtin_sym_end] = ACTIONS(803),
    [sym_variable_identifier] = ACTIONS(805),
    [anon_sym_LBRACK] = ACTIONS(803),
    [anon_sym_LBRACE] = ACTIONS(803),
    [anon_sym_RBRACE] = ACTIONS(803),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(805),
    [anon_sym_true] = ACTIONS(805),
    [anon_sym_SQUOTE] = ACTIONS(803),
    [anon_sym_const] = ACTIONS(805),
    [anon_sym_function] = ACTIONS(805),
    [anon_sym_global] = ACTIONS(805),
    [anon_sym_spork] = ACTIONS(805),
    [anon_sym_LPAREN] = ACTIONS(803),
    [anon_sym_public] = ACTIONS(805),
    [anon_sym_class] = ACTIONS(805),
    [anon_sym_extends] = ACTIONS(805),
    [sym_class_identifier] = ACTIONS(805),
    [anon_sym_new] = ACTIONS(805),
    [anon_sym_implements] = ACTIONS(805),
    [anon_sym_interface] = ACTIONS(805),
    [anon_sym_private] = ACTIONS(805),
    [anon_sym_protected] = ACTIONS(805),
    [anon_sym_pure] = ACTIONS(805),
    [anon_sym_static] = ACTIONS(805),
    [anon_sym_super] = ACTIONS(805),
    [anon_sym_this] = ACTIONS(805),
    [anon_sym_POUND_LPAREN] = ACTIONS(803),
    [anon_sym_if] = ACTIONS(805),
    [anon_sym_break] = ACTIONS(805),
    [anon_sym_continue] = ACTIONS(805),
    [anon_sym_switch] = ACTIONS(805),
    [anon_sym_LT_LT_LT] = ACTIONS(803),
    [anon_sym_ATdoc] = ACTIONS(803),
    [anon_sym_do] = ACTIONS(805),
    [anon_sym_day] = ACTIONS(805),
    [anon_sym_hour] = ACTIONS(805),
    [anon_sym_minute] = ACTIONS(805),
    [anon_sym_ms] = ACTIONS(805),
    [anon_sym_samp] = ACTIONS(805),
    [anon_sym_second] = ACTIONS(805),
    [anon_sym_week] = ACTIONS(805),
    [sym_float] = ACTIONS(803),
    [anon_sym_for] = ACTIONS(805),
    [anon_sym_fun] = ACTIONS(805),
    [anon_sym_adc] = ACTIONS(805),
    [anon_sym_blackhole] = ACTIONS(805),
    [anon_sym_dac] = ACTIONS(805),
    [sym_hexidecimal] = ACTIONS(803),
    [anon_sym_PLUS_PLUS] = ACTIONS(803),
    [anon_sym_DASH_DASH] = ACTIONS(803),
    [anon_sym_ATimport] = ACTIONS(803),
    [sym_int] = ACTIONS(805),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(805),
    [anon_sym_me] = ACTIONS(805),
    [anon_sym_BANG] = ACTIONS(803),
    [anon_sym_DASH] = ACTIONS(805),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(803),
    [anon_sym_auto] = ACTIONS(805),
    [anon_sym_complex] = ACTIONS(805),
    [anon_sym_dur] = ACTIONS(805),
    [anon_sym_float] = ACTIONS(805),
    [anon_sym_int] = ACTIONS(805),
    [anon_sym_polar] = ACTIONS(805),
    [anon_sym_same] = ACTIONS(805),
    [anon_sym_time] = ACTIONS(805),
    [anon_sym_vec2] = ACTIONS(805),
    [anon_sym_vec3] = ACTIONS(805),
    [anon_sym_vec4] = ACTIONS(805),
    [anon_sym_void] = ACTIONS(805),
    [anon_sym_Event] = ACTIONS(805),
    [anon_sym_Object] = ACTIONS(805),
    [anon_sym_UGen] = ACTIONS(805),
    [anon_sym_array] = ACTIONS(805),
    [anon_sym_string] = ACTIONS(805),
    [anon_sym_AT_LPAREN] = ACTIONS(803),
    [anon_sym_NULL] = ACTIONS(805),
    [anon_sym_maybe] = ACTIONS(805),
    [anon_sym_now] = ACTIONS(805),
    [anon_sym_null] = ACTIONS(805),
    [anon_sym_pi] = ACTIONS(805),
    [anon_sym_return] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(803),
    [anon_sym_until] = ACTIONS(805),
    [anon_sym_while] = ACTIONS(805),
  },
  [138] = {
    [ts_builtin_sym_end] = ACTIONS(807),
    [sym_variable_identifier] = ACTIONS(809),
    [anon_sym_LBRACK] = ACTIONS(807),
    [anon_sym_LBRACE] = ACTIONS(807),
    [anon_sym_RBRACE] = ACTIONS(807),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(809),
    [anon_sym_true] = ACTIONS(809),
    [anon_sym_SQUOTE] = ACTIONS(807),
    [anon_sym_const] = ACTIONS(809),
    [anon_sym_function] = ACTIONS(809),
    [anon_sym_global] = ACTIONS(809),
    [anon_sym_spork] = ACTIONS(809),
    [anon_sym_LPAREN] = ACTIONS(807),
    [anon_sym_public] = ACTIONS(809),
    [anon_sym_class] = ACTIONS(809),
    [anon_sym_extends] = ACTIONS(809),
    [sym_class_identifier] = ACTIONS(809),
    [anon_sym_new] = ACTIONS(809),
    [anon_sym_implements] = ACTIONS(809),
    [anon_sym_interface] = ACTIONS(809),
    [anon_sym_private] = ACTIONS(809),
    [anon_sym_protected] = ACTIONS(809),
    [anon_sym_pure] = ACTIONS(809),
    [anon_sym_static] = ACTIONS(809),
    [anon_sym_super] = ACTIONS(809),
    [anon_sym_this] = ACTIONS(809),
    [anon_sym_POUND_LPAREN] = ACTIONS(807),
    [anon_sym_if] = ACTIONS(809),
    [anon_sym_break] = ACTIONS(809),
    [anon_sym_continue] = ACTIONS(809),
    [anon_sym_switch] = ACTIONS(809),
    [anon_sym_LT_LT_LT] = ACTIONS(807),
    [anon_sym_ATdoc] = ACTIONS(807),
    [anon_sym_do] = ACTIONS(809),
    [anon_sym_day] = ACTIONS(809),
    [anon_sym_hour] = ACTIONS(809),
    [anon_sym_minute] = ACTIONS(809),
    [anon_sym_ms] = ACTIONS(809),
    [anon_sym_samp] = ACTIONS(809),
    [anon_sym_second] = ACTIONS(809),
    [anon_sym_week] = ACTIONS(809),
    [sym_float] = ACTIONS(807),
    [anon_sym_for] = ACTIONS(809),
    [anon_sym_fun] = ACTIONS(809),
    [anon_sym_adc] = ACTIONS(809),
    [anon_sym_blackhole] = ACTIONS(809),
    [anon_sym_dac] = ACTIONS(809),
    [sym_hexidecimal] = ACTIONS(807),
    [anon_sym_PLUS_PLUS] = ACTIONS(807),
    [anon_sym_DASH_DASH] = ACTIONS(807),
    [anon_sym_ATimport] = ACTIONS(807),
    [sym_int] = ACTIONS(809),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(809),
    [anon_sym_me] = ACTIONS(809),
    [anon_sym_BANG] = ACTIONS(807),
    [anon_sym_DASH] = ACTIONS(809),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(807),
    [anon_sym_auto] = ACTIONS(809),
    [anon_sym_complex] = ACTIONS(809),
    [anon_sym_dur] = ACTIONS(809),
    [anon_sym_float] = ACTIONS(809),
    [anon_sym_int] = ACTIONS(809),
    [anon_sym_polar] = ACTIONS(809),
    [anon_sym_same] = ACTIONS(809),
    [anon_sym_time] = ACTIONS(809),
    [anon_sym_vec2] = ACTIONS(809),
    [anon_sym_vec3] = ACTIONS(809),
    [anon_sym_vec4] = ACTIONS(809),
    [anon_sym_void] = ACTIONS(809),
    [anon_sym_Event] = ACTIONS(809),
    [anon_sym_Object] = ACTIONS(809),
    [anon_sym_UGen] = ACTIONS(809),
    [anon_sym_array] = ACTIONS(809),
    [anon_sym_string] = ACTIONS(809),
    [anon_sym_AT_LPAREN] = ACTIONS(807),
    [anon_sym_NULL] = ACTIONS(809),
    [anon_sym_maybe] = ACTIONS(809),
    [anon_sym_now] = ACTIONS(809),
    [anon_sym_null] = ACTIONS(809),
    [anon_sym_pi] = ACTIONS(809),
    [anon_sym_return] = ACTIONS(809),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_until] = ACTIONS(809),
    [anon_sym_while] = ACTIONS(809),
  },
  [139] = {
    [ts_builtin_sym_end] = ACTIONS(751),
    [sym_variable_identifier] = ACTIONS(753),
    [anon_sym_LBRACK] = ACTIONS(751),
    [anon_sym_LBRACE] = ACTIONS(751),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(753),
    [anon_sym_true] = ACTIONS(753),
    [anon_sym_SQUOTE] = ACTIONS(751),
    [anon_sym_const] = ACTIONS(753),
    [anon_sym_function] = ACTIONS(753),
    [anon_sym_global] = ACTIONS(753),
    [anon_sym_spork] = ACTIONS(753),
    [anon_sym_LPAREN] = ACTIONS(751),
    [anon_sym_public] = ACTIONS(753),
    [anon_sym_class] = ACTIONS(753),
    [anon_sym_extends] = ACTIONS(753),
    [sym_class_identifier] = ACTIONS(753),
    [anon_sym_new] = ACTIONS(753),
    [anon_sym_implements] = ACTIONS(753),
    [anon_sym_interface] = ACTIONS(753),
    [anon_sym_private] = ACTIONS(753),
    [anon_sym_protected] = ACTIONS(753),
    [anon_sym_pure] = ACTIONS(753),
    [anon_sym_static] = ACTIONS(753),
    [anon_sym_super] = ACTIONS(753),
    [anon_sym_this] = ACTIONS(753),
    [anon_sym_POUND_LPAREN] = ACTIONS(751),
    [anon_sym_if] = ACTIONS(753),
    [anon_sym_break] = ACTIONS(753),
    [anon_sym_continue] = ACTIONS(753),
    [anon_sym_switch] = ACTIONS(753),
    [anon_sym_LT_LT_LT] = ACTIONS(751),
    [anon_sym_ATdoc] = ACTIONS(751),
    [anon_sym_do] = ACTIONS(753),
    [anon_sym_day] = ACTIONS(753),
    [anon_sym_hour] = ACTIONS(753),
    [anon_sym_minute] = ACTIONS(753),
    [anon_sym_ms] = ACTIONS(753),
    [anon_sym_samp] = ACTIONS(753),
    [anon_sym_second] = ACTIONS(753),
    [anon_sym_week] = ACTIONS(753),
    [sym_float] = ACTIONS(751),
    [anon_sym_for] = ACTIONS(753),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_fun] = ACTIONS(753),
    [anon_sym_adc] = ACTIONS(753),
    [anon_sym_blackhole] = ACTIONS(753),
    [anon_sym_dac] = ACTIONS(753),
    [sym_hexidecimal] = ACTIONS(751),
    [anon_sym_PLUS_PLUS] = ACTIONS(751),
    [anon_sym_DASH_DASH] = ACTIONS(751),
    [anon_sym_ATimport] = ACTIONS(751),
    [sym_int] = ACTIONS(753),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(753),
    [anon_sym_me] = ACTIONS(753),
    [anon_sym_BANG] = ACTIONS(751),
    [anon_sym_DASH] = ACTIONS(753),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(751),
    [anon_sym_auto] = ACTIONS(753),
    [anon_sym_complex] = ACTIONS(753),
    [anon_sym_dur] = ACTIONS(753),
    [anon_sym_float] = ACTIONS(753),
    [anon_sym_int] = ACTIONS(753),
    [anon_sym_polar] = ACTIONS(753),
    [anon_sym_same] = ACTIONS(753),
    [anon_sym_time] = ACTIONS(753),
    [anon_sym_vec2] = ACTIONS(753),
    [anon_sym_vec3] = ACTIONS(753),
    [anon_sym_vec4] = ACTIONS(753),
    [anon_sym_void] = ACTIONS(753),
    [anon_sym_Event] = ACTIONS(753),
    [anon_sym_Object] = ACTIONS(753),
    [anon_sym_UGen] = ACTIONS(753),
    [anon_sym_array] = ACTIONS(753),
    [anon_sym_string] = ACTIONS(753),
    [anon_sym_AT_LPAREN] = ACTIONS(751),
    [anon_sym_NULL] = ACTIONS(753),
    [anon_sym_maybe] = ACTIONS(753),
    [anon_sym_now] = ACTIONS(753),
    [anon_sym_null] = ACTIONS(753),
    [anon_sym_pi] = ACTIONS(753),
    [anon_sym_return] = ACTIONS(753),
    [anon_sym_DQUOTE] = ACTIONS(751),
    [anon_sym_until] = ACTIONS(753),
    [anon_sym_while] = ACTIONS(753),
  },
  [140] = {
    [ts_builtin_sym_end] = ACTIONS(811),
    [sym_variable_identifier] = ACTIONS(813),
    [anon_sym_LBRACK] = ACTIONS(811),
    [anon_sym_LBRACE] = ACTIONS(811),
    [anon_sym_RBRACE] = ACTIONS(811),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(813),
    [anon_sym_true] = ACTIONS(813),
    [anon_sym_SQUOTE] = ACTIONS(811),
    [anon_sym_const] = ACTIONS(813),
    [anon_sym_function] = ACTIONS(813),
    [anon_sym_global] = ACTIONS(813),
    [anon_sym_spork] = ACTIONS(813),
    [anon_sym_LPAREN] = ACTIONS(811),
    [anon_sym_public] = ACTIONS(813),
    [anon_sym_class] = ACTIONS(813),
    [anon_sym_extends] = ACTIONS(813),
    [sym_class_identifier] = ACTIONS(813),
    [anon_sym_new] = ACTIONS(813),
    [anon_sym_implements] = ACTIONS(813),
    [anon_sym_interface] = ACTIONS(813),
    [anon_sym_private] = ACTIONS(813),
    [anon_sym_protected] = ACTIONS(813),
    [anon_sym_pure] = ACTIONS(813),
    [anon_sym_static] = ACTIONS(813),
    [anon_sym_super] = ACTIONS(813),
    [anon_sym_this] = ACTIONS(813),
    [anon_sym_POUND_LPAREN] = ACTIONS(811),
    [anon_sym_if] = ACTIONS(813),
    [anon_sym_break] = ACTIONS(813),
    [anon_sym_continue] = ACTIONS(813),
    [anon_sym_switch] = ACTIONS(813),
    [anon_sym_LT_LT_LT] = ACTIONS(811),
    [anon_sym_ATdoc] = ACTIONS(811),
    [anon_sym_do] = ACTIONS(813),
    [anon_sym_day] = ACTIONS(813),
    [anon_sym_hour] = ACTIONS(813),
    [anon_sym_minute] = ACTIONS(813),
    [anon_sym_ms] = ACTIONS(813),
    [anon_sym_samp] = ACTIONS(813),
    [anon_sym_second] = ACTIONS(813),
    [anon_sym_week] = ACTIONS(813),
    [sym_float] = ACTIONS(811),
    [anon_sym_for] = ACTIONS(813),
    [anon_sym_fun] = ACTIONS(813),
    [anon_sym_adc] = ACTIONS(813),
    [anon_sym_blackhole] = ACTIONS(813),
    [anon_sym_dac] = ACTIONS(813),
    [sym_hexidecimal] = ACTIONS(811),
    [anon_sym_PLUS_PLUS] = ACTIONS(811),
    [anon_sym_DASH_DASH] = ACTIONS(811),
    [anon_sym_ATimport] = ACTIONS(811),
    [sym_int] = ACTIONS(813),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(813),
    [anon_sym_me] = ACTIONS(813),
    [anon_sym_BANG] = ACTIONS(811),
    [anon_sym_DASH] = ACTIONS(813),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(811),
    [anon_sym_auto] = ACTIONS(813),
    [anon_sym_complex] = ACTIONS(813),
    [anon_sym_dur] = ACTIONS(813),
    [anon_sym_float] = ACTIONS(813),
    [anon_sym_int] = ACTIONS(813),
    [anon_sym_polar] = ACTIONS(813),
    [anon_sym_same] = ACTIONS(813),
    [anon_sym_time] = ACTIONS(813),
    [anon_sym_vec2] = ACTIONS(813),
    [anon_sym_vec3] = ACTIONS(813),
    [anon_sym_vec4] = ACTIONS(813),
    [anon_sym_void] = ACTIONS(813),
    [anon_sym_Event] = ACTIONS(813),
    [anon_sym_Object] = ACTIONS(813),
    [anon_sym_UGen] = ACTIONS(813),
    [anon_sym_array] = ACTIONS(813),
    [anon_sym_string] = ACTIONS(813),
    [anon_sym_AT_LPAREN] = ACTIONS(811),
    [anon_sym_NULL] = ACTIONS(813),
    [anon_sym_maybe] = ACTIONS(813),
    [anon_sym_now] = ACTIONS(813),
    [anon_sym_null] = ACTIONS(813),
    [anon_sym_pi] = ACTIONS(813),
    [anon_sym_return] = ACTIONS(813),
    [anon_sym_DQUOTE] = ACTIONS(811),
    [anon_sym_until] = ACTIONS(813),
    [anon_sym_while] = ACTIONS(813),
  },
  [141] = {
    [ts_builtin_sym_end] = ACTIONS(703),
    [sym_variable_identifier] = ACTIONS(705),
    [anon_sym_LBRACK] = ACTIONS(703),
    [anon_sym_LBRACE] = ACTIONS(703),
    [anon_sym_RBRACE] = ACTIONS(703),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(705),
    [anon_sym_true] = ACTIONS(705),
    [anon_sym_SQUOTE] = ACTIONS(703),
    [anon_sym_const] = ACTIONS(705),
    [anon_sym_function] = ACTIONS(705),
    [anon_sym_global] = ACTIONS(705),
    [anon_sym_spork] = ACTIONS(705),
    [anon_sym_LPAREN] = ACTIONS(703),
    [anon_sym_public] = ACTIONS(705),
    [anon_sym_class] = ACTIONS(705),
    [anon_sym_extends] = ACTIONS(705),
    [sym_class_identifier] = ACTIONS(705),
    [anon_sym_new] = ACTIONS(705),
    [anon_sym_implements] = ACTIONS(705),
    [anon_sym_interface] = ACTIONS(705),
    [anon_sym_private] = ACTIONS(705),
    [anon_sym_protected] = ACTIONS(705),
    [anon_sym_pure] = ACTIONS(705),
    [anon_sym_static] = ACTIONS(705),
    [anon_sym_super] = ACTIONS(705),
    [anon_sym_this] = ACTIONS(705),
    [anon_sym_POUND_LPAREN] = ACTIONS(703),
    [anon_sym_if] = ACTIONS(705),
    [anon_sym_break] = ACTIONS(705),
    [anon_sym_continue] = ACTIONS(705),
    [anon_sym_switch] = ACTIONS(705),
    [anon_sym_LT_LT_LT] = ACTIONS(703),
    [anon_sym_ATdoc] = ACTIONS(703),
    [anon_sym_do] = ACTIONS(705),
    [anon_sym_day] = ACTIONS(705),
    [anon_sym_hour] = ACTIONS(705),
    [anon_sym_minute] = ACTIONS(705),
    [anon_sym_ms] = ACTIONS(705),
    [anon_sym_samp] = ACTIONS(705),
    [anon_sym_second] = ACTIONS(705),
    [anon_sym_week] = ACTIONS(705),
    [sym_float] = ACTIONS(703),
    [anon_sym_for] = ACTIONS(705),
    [anon_sym_fun] = ACTIONS(705),
    [anon_sym_adc] = ACTIONS(705),
    [anon_sym_blackhole] = ACTIONS(705),
    [anon_sym_dac] = ACTIONS(705),
    [sym_hexidecimal] = ACTIONS(703),
    [anon_sym_PLUS_PLUS] = ACTIONS(703),
    [anon_sym_DASH_DASH] = ACTIONS(703),
    [anon_sym_ATimport] = ACTIONS(703),
    [sym_int] = ACTIONS(705),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(705),
    [anon_sym_me] = ACTIONS(705),
    [anon_sym_BANG] = ACTIONS(703),
    [anon_sym_DASH] = ACTIONS(705),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(703),
    [anon_sym_auto] = ACTIONS(705),
    [anon_sym_complex] = ACTIONS(705),
    [anon_sym_dur] = ACTIONS(705),
    [anon_sym_float] = ACTIONS(705),
    [anon_sym_int] = ACTIONS(705),
    [anon_sym_polar] = ACTIONS(705),
    [anon_sym_same] = ACTIONS(705),
    [anon_sym_time] = ACTIONS(705),
    [anon_sym_vec2] = ACTIONS(705),
    [anon_sym_vec3] = ACTIONS(705),
    [anon_sym_vec4] = ACTIONS(705),
    [anon_sym_void] = ACTIONS(705),
    [anon_sym_Event] = ACTIONS(705),
    [anon_sym_Object] = ACTIONS(705),
    [anon_sym_UGen] = ACTIONS(705),
    [anon_sym_array] = ACTIONS(705),
    [anon_sym_string] = ACTIONS(705),
    [anon_sym_AT_LPAREN] = ACTIONS(703),
    [anon_sym_NULL] = ACTIONS(705),
    [anon_sym_maybe] = ACTIONS(705),
    [anon_sym_now] = ACTIONS(705),
    [anon_sym_null] = ACTIONS(705),
    [anon_sym_pi] = ACTIONS(705),
    [anon_sym_return] = ACTIONS(705),
    [anon_sym_DQUOTE] = ACTIONS(703),
    [anon_sym_until] = ACTIONS(705),
    [anon_sym_while] = ACTIONS(705),
  },
  [142] = {
    [ts_builtin_sym_end] = ACTIONS(815),
    [sym_variable_identifier] = ACTIONS(817),
    [anon_sym_LBRACK] = ACTIONS(815),
    [anon_sym_LBRACE] = ACTIONS(815),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(817),
    [anon_sym_true] = ACTIONS(817),
    [anon_sym_SQUOTE] = ACTIONS(815),
    [anon_sym_const] = ACTIONS(817),
    [anon_sym_function] = ACTIONS(817),
    [anon_sym_global] = ACTIONS(817),
    [anon_sym_spork] = ACTIONS(817),
    [anon_sym_LPAREN] = ACTIONS(815),
    [anon_sym_public] = ACTIONS(817),
    [anon_sym_class] = ACTIONS(817),
    [anon_sym_extends] = ACTIONS(817),
    [sym_class_identifier] = ACTIONS(817),
    [anon_sym_new] = ACTIONS(817),
    [anon_sym_implements] = ACTIONS(817),
    [anon_sym_interface] = ACTIONS(817),
    [anon_sym_private] = ACTIONS(817),
    [anon_sym_protected] = ACTIONS(817),
    [anon_sym_pure] = ACTIONS(817),
    [anon_sym_static] = ACTIONS(817),
    [anon_sym_super] = ACTIONS(817),
    [anon_sym_this] = ACTIONS(817),
    [anon_sym_POUND_LPAREN] = ACTIONS(815),
    [anon_sym_if] = ACTIONS(817),
    [anon_sym_break] = ACTIONS(817),
    [anon_sym_continue] = ACTIONS(817),
    [anon_sym_switch] = ACTIONS(817),
    [anon_sym_LT_LT_LT] = ACTIONS(815),
    [anon_sym_ATdoc] = ACTIONS(815),
    [anon_sym_do] = ACTIONS(817),
    [anon_sym_day] = ACTIONS(817),
    [anon_sym_hour] = ACTIONS(817),
    [anon_sym_minute] = ACTIONS(817),
    [anon_sym_ms] = ACTIONS(817),
    [anon_sym_samp] = ACTIONS(817),
    [anon_sym_second] = ACTIONS(817),
    [anon_sym_week] = ACTIONS(817),
    [sym_float] = ACTIONS(815),
    [anon_sym_for] = ACTIONS(817),
    [anon_sym_fun] = ACTIONS(817),
    [anon_sym_adc] = ACTIONS(817),
    [anon_sym_blackhole] = ACTIONS(817),
    [anon_sym_dac] = ACTIONS(817),
    [sym_hexidecimal] = ACTIONS(815),
    [anon_sym_PLUS_PLUS] = ACTIONS(815),
    [anon_sym_DASH_DASH] = ACTIONS(815),
    [anon_sym_ATimport] = ACTIONS(815),
    [sym_int] = ACTIONS(817),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(817),
    [anon_sym_me] = ACTIONS(817),
    [anon_sym_BANG] = ACTIONS(815),
    [anon_sym_DASH] = ACTIONS(817),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(815),
    [anon_sym_auto] = ACTIONS(817),
    [anon_sym_complex] = ACTIONS(817),
    [anon_sym_dur] = ACTIONS(817),
    [anon_sym_float] = ACTIONS(817),
    [anon_sym_int] = ACTIONS(817),
    [anon_sym_polar] = ACTIONS(817),
    [anon_sym_same] = ACTIONS(817),
    [anon_sym_time] = ACTIONS(817),
    [anon_sym_vec2] = ACTIONS(817),
    [anon_sym_vec3] = ACTIONS(817),
    [anon_sym_vec4] = ACTIONS(817),
    [anon_sym_void] = ACTIONS(817),
    [anon_sym_Event] = ACTIONS(817),
    [anon_sym_Object] = ACTIONS(817),
    [anon_sym_UGen] = ACTIONS(817),
    [anon_sym_array] = ACTIONS(817),
    [anon_sym_string] = ACTIONS(817),
    [anon_sym_AT_LPAREN] = ACTIONS(815),
    [anon_sym_NULL] = ACTIONS(817),
    [anon_sym_maybe] = ACTIONS(817),
    [anon_sym_now] = ACTIONS(817),
    [anon_sym_null] = ACTIONS(817),
    [anon_sym_pi] = ACTIONS(817),
    [anon_sym_return] = ACTIONS(817),
    [anon_sym_DQUOTE] = ACTIONS(815),
    [anon_sym_until] = ACTIONS(817),
    [anon_sym_while] = ACTIONS(817),
  },
  [143] = {
    [ts_builtin_sym_end] = ACTIONS(819),
    [sym_variable_identifier] = ACTIONS(821),
    [anon_sym_LBRACK] = ACTIONS(819),
    [anon_sym_LBRACE] = ACTIONS(819),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(821),
    [anon_sym_true] = ACTIONS(821),
    [anon_sym_SQUOTE] = ACTIONS(819),
    [anon_sym_const] = ACTIONS(821),
    [anon_sym_function] = ACTIONS(821),
    [anon_sym_global] = ACTIONS(821),
    [anon_sym_spork] = ACTIONS(821),
    [anon_sym_LPAREN] = ACTIONS(819),
    [anon_sym_public] = ACTIONS(821),
    [anon_sym_class] = ACTIONS(821),
    [anon_sym_extends] = ACTIONS(821),
    [sym_class_identifier] = ACTIONS(821),
    [anon_sym_new] = ACTIONS(821),
    [anon_sym_implements] = ACTIONS(821),
    [anon_sym_interface] = ACTIONS(821),
    [anon_sym_private] = ACTIONS(821),
    [anon_sym_protected] = ACTIONS(821),
    [anon_sym_pure] = ACTIONS(821),
    [anon_sym_static] = ACTIONS(821),
    [anon_sym_super] = ACTIONS(821),
    [anon_sym_this] = ACTIONS(821),
    [anon_sym_POUND_LPAREN] = ACTIONS(819),
    [anon_sym_if] = ACTIONS(821),
    [anon_sym_break] = ACTIONS(821),
    [anon_sym_continue] = ACTIONS(821),
    [anon_sym_switch] = ACTIONS(821),
    [anon_sym_LT_LT_LT] = ACTIONS(819),
    [anon_sym_ATdoc] = ACTIONS(819),
    [anon_sym_do] = ACTIONS(821),
    [anon_sym_day] = ACTIONS(821),
    [anon_sym_hour] = ACTIONS(821),
    [anon_sym_minute] = ACTIONS(821),
    [anon_sym_ms] = ACTIONS(821),
    [anon_sym_samp] = ACTIONS(821),
    [anon_sym_second] = ACTIONS(821),
    [anon_sym_week] = ACTIONS(821),
    [sym_float] = ACTIONS(819),
    [anon_sym_for] = ACTIONS(821),
    [anon_sym_fun] = ACTIONS(821),
    [anon_sym_adc] = ACTIONS(821),
    [anon_sym_blackhole] = ACTIONS(821),
    [anon_sym_dac] = ACTIONS(821),
    [sym_hexidecimal] = ACTIONS(819),
    [anon_sym_PLUS_PLUS] = ACTIONS(819),
    [anon_sym_DASH_DASH] = ACTIONS(819),
    [anon_sym_ATimport] = ACTIONS(819),
    [sym_int] = ACTIONS(821),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(821),
    [anon_sym_me] = ACTIONS(821),
    [anon_sym_BANG] = ACTIONS(819),
    [anon_sym_DASH] = ACTIONS(821),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(819),
    [anon_sym_auto] = ACTIONS(821),
    [anon_sym_complex] = ACTIONS(821),
    [anon_sym_dur] = ACTIONS(821),
    [anon_sym_float] = ACTIONS(821),
    [anon_sym_int] = ACTIONS(821),
    [anon_sym_polar] = ACTIONS(821),
    [anon_sym_same] = ACTIONS(821),
    [anon_sym_time] = ACTIONS(821),
    [anon_sym_vec2] = ACTIONS(821),
    [anon_sym_vec3] = ACTIONS(821),
    [anon_sym_vec4] = ACTIONS(821),
    [anon_sym_void] = ACTIONS(821),
    [anon_sym_Event] = ACTIONS(821),
    [anon_sym_Object] = ACTIONS(821),
    [anon_sym_UGen] = ACTIONS(821),
    [anon_sym_array] = ACTIONS(821),
    [anon_sym_string] = ACTIONS(821),
    [anon_sym_AT_LPAREN] = ACTIONS(819),
    [anon_sym_NULL] = ACTIONS(821),
    [anon_sym_maybe] = ACTIONS(821),
    [anon_sym_now] = ACTIONS(821),
    [anon_sym_null] = ACTIONS(821),
    [anon_sym_pi] = ACTIONS(821),
    [anon_sym_return] = ACTIONS(821),
    [anon_sym_DQUOTE] = ACTIONS(819),
    [anon_sym_until] = ACTIONS(821),
    [anon_sym_while] = ACTIONS(821),
  },
  [144] = {
    [ts_builtin_sym_end] = ACTIONS(823),
    [sym_variable_identifier] = ACTIONS(825),
    [anon_sym_LBRACK] = ACTIONS(823),
    [anon_sym_LBRACE] = ACTIONS(823),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(825),
    [anon_sym_true] = ACTIONS(825),
    [anon_sym_SQUOTE] = ACTIONS(823),
    [anon_sym_const] = ACTIONS(825),
    [anon_sym_function] = ACTIONS(825),
    [anon_sym_global] = ACTIONS(825),
    [anon_sym_spork] = ACTIONS(825),
    [anon_sym_LPAREN] = ACTIONS(823),
    [anon_sym_public] = ACTIONS(825),
    [anon_sym_class] = ACTIONS(825),
    [anon_sym_extends] = ACTIONS(825),
    [sym_class_identifier] = ACTIONS(825),
    [anon_sym_new] = ACTIONS(825),
    [anon_sym_implements] = ACTIONS(825),
    [anon_sym_interface] = ACTIONS(825),
    [anon_sym_private] = ACTIONS(825),
    [anon_sym_protected] = ACTIONS(825),
    [anon_sym_pure] = ACTIONS(825),
    [anon_sym_static] = ACTIONS(825),
    [anon_sym_super] = ACTIONS(825),
    [anon_sym_this] = ACTIONS(825),
    [anon_sym_POUND_LPAREN] = ACTIONS(823),
    [anon_sym_if] = ACTIONS(825),
    [anon_sym_break] = ACTIONS(825),
    [anon_sym_continue] = ACTIONS(825),
    [anon_sym_switch] = ACTIONS(825),
    [anon_sym_LT_LT_LT] = ACTIONS(823),
    [anon_sym_ATdoc] = ACTIONS(823),
    [anon_sym_do] = ACTIONS(825),
    [anon_sym_day] = ACTIONS(825),
    [anon_sym_hour] = ACTIONS(825),
    [anon_sym_minute] = ACTIONS(825),
    [anon_sym_ms] = ACTIONS(825),
    [anon_sym_samp] = ACTIONS(825),
    [anon_sym_second] = ACTIONS(825),
    [anon_sym_week] = ACTIONS(825),
    [sym_float] = ACTIONS(823),
    [anon_sym_for] = ACTIONS(825),
    [anon_sym_fun] = ACTIONS(825),
    [anon_sym_adc] = ACTIONS(825),
    [anon_sym_blackhole] = ACTIONS(825),
    [anon_sym_dac] = ACTIONS(825),
    [sym_hexidecimal] = ACTIONS(823),
    [anon_sym_PLUS_PLUS] = ACTIONS(823),
    [anon_sym_DASH_DASH] = ACTIONS(823),
    [anon_sym_ATimport] = ACTIONS(823),
    [sym_int] = ACTIONS(825),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(825),
    [anon_sym_me] = ACTIONS(825),
    [anon_sym_BANG] = ACTIONS(823),
    [anon_sym_DASH] = ACTIONS(825),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(823),
    [anon_sym_auto] = ACTIONS(825),
    [anon_sym_complex] = ACTIONS(825),
    [anon_sym_dur] = ACTIONS(825),
    [anon_sym_float] = ACTIONS(825),
    [anon_sym_int] = ACTIONS(825),
    [anon_sym_polar] = ACTIONS(825),
    [anon_sym_same] = ACTIONS(825),
    [anon_sym_time] = ACTIONS(825),
    [anon_sym_vec2] = ACTIONS(825),
    [anon_sym_vec3] = ACTIONS(825),
    [anon_sym_vec4] = ACTIONS(825),
    [anon_sym_void] = ACTIONS(825),
    [anon_sym_Event] = ACTIONS(825),
    [anon_sym_Object] = ACTIONS(825),
    [anon_sym_UGen] = ACTIONS(825),
    [anon_sym_array] = ACTIONS(825),
    [anon_sym_string] = ACTIONS(825),
    [anon_sym_AT_LPAREN] = ACTIONS(823),
    [anon_sym_NULL] = ACTIONS(825),
    [anon_sym_maybe] = ACTIONS(825),
    [anon_sym_now] = ACTIONS(825),
    [anon_sym_null] = ACTIONS(825),
    [anon_sym_pi] = ACTIONS(825),
    [anon_sym_return] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(823),
    [anon_sym_until] = ACTIONS(825),
    [anon_sym_while] = ACTIONS(825),
  },
  [145] = {
    [ts_builtin_sym_end] = ACTIONS(827),
    [sym_variable_identifier] = ACTIONS(829),
    [anon_sym_LBRACK] = ACTIONS(827),
    [anon_sym_LBRACE] = ACTIONS(827),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(829),
    [anon_sym_true] = ACTIONS(829),
    [anon_sym_SQUOTE] = ACTIONS(827),
    [anon_sym_const] = ACTIONS(829),
    [anon_sym_function] = ACTIONS(829),
    [anon_sym_global] = ACTIONS(829),
    [anon_sym_spork] = ACTIONS(829),
    [anon_sym_LPAREN] = ACTIONS(827),
    [anon_sym_public] = ACTIONS(829),
    [anon_sym_class] = ACTIONS(829),
    [anon_sym_extends] = ACTIONS(829),
    [sym_class_identifier] = ACTIONS(829),
    [anon_sym_new] = ACTIONS(829),
    [anon_sym_implements] = ACTIONS(829),
    [anon_sym_interface] = ACTIONS(829),
    [anon_sym_private] = ACTIONS(829),
    [anon_sym_protected] = ACTIONS(829),
    [anon_sym_pure] = ACTIONS(829),
    [anon_sym_static] = ACTIONS(829),
    [anon_sym_super] = ACTIONS(829),
    [anon_sym_this] = ACTIONS(829),
    [anon_sym_POUND_LPAREN] = ACTIONS(827),
    [anon_sym_if] = ACTIONS(829),
    [anon_sym_break] = ACTIONS(829),
    [anon_sym_continue] = ACTIONS(829),
    [anon_sym_switch] = ACTIONS(829),
    [anon_sym_LT_LT_LT] = ACTIONS(827),
    [anon_sym_ATdoc] = ACTIONS(827),
    [anon_sym_do] = ACTIONS(829),
    [anon_sym_day] = ACTIONS(829),
    [anon_sym_hour] = ACTIONS(829),
    [anon_sym_minute] = ACTIONS(829),
    [anon_sym_ms] = ACTIONS(829),
    [anon_sym_samp] = ACTIONS(829),
    [anon_sym_second] = ACTIONS(829),
    [anon_sym_week] = ACTIONS(829),
    [sym_float] = ACTIONS(827),
    [anon_sym_for] = ACTIONS(829),
    [anon_sym_fun] = ACTIONS(829),
    [anon_sym_adc] = ACTIONS(829),
    [anon_sym_blackhole] = ACTIONS(829),
    [anon_sym_dac] = ACTIONS(829),
    [sym_hexidecimal] = ACTIONS(827),
    [anon_sym_PLUS_PLUS] = ACTIONS(827),
    [anon_sym_DASH_DASH] = ACTIONS(827),
    [anon_sym_ATimport] = ACTIONS(827),
    [sym_int] = ACTIONS(829),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(829),
    [anon_sym_me] = ACTIONS(829),
    [anon_sym_BANG] = ACTIONS(827),
    [anon_sym_DASH] = ACTIONS(829),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(827),
    [anon_sym_auto] = ACTIONS(829),
    [anon_sym_complex] = ACTIONS(829),
    [anon_sym_dur] = ACTIONS(829),
    [anon_sym_float] = ACTIONS(829),
    [anon_sym_int] = ACTIONS(829),
    [anon_sym_polar] = ACTIONS(829),
    [anon_sym_same] = ACTIONS(829),
    [anon_sym_time] = ACTIONS(829),
    [anon_sym_vec2] = ACTIONS(829),
    [anon_sym_vec3] = ACTIONS(829),
    [anon_sym_vec4] = ACTIONS(829),
    [anon_sym_void] = ACTIONS(829),
    [anon_sym_Event] = ACTIONS(829),
    [anon_sym_Object] = ACTIONS(829),
    [anon_sym_UGen] = ACTIONS(829),
    [anon_sym_array] = ACTIONS(829),
    [anon_sym_string] = ACTIONS(829),
    [anon_sym_AT_LPAREN] = ACTIONS(827),
    [anon_sym_NULL] = ACTIONS(829),
    [anon_sym_maybe] = ACTIONS(829),
    [anon_sym_now] = ACTIONS(829),
    [anon_sym_null] = ACTIONS(829),
    [anon_sym_pi] = ACTIONS(829),
    [anon_sym_return] = ACTIONS(829),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_until] = ACTIONS(829),
    [anon_sym_while] = ACTIONS(829),
  },
  [146] = {
    [sym_variable_identifier] = ACTIONS(755),
    [anon_sym_LBRACK] = ACTIONS(757),
    [anon_sym_RBRACE] = ACTIONS(757),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(755),
    [anon_sym_true] = ACTIONS(755),
    [anon_sym_SQUOTE] = ACTIONS(757),
    [anon_sym_const] = ACTIONS(755),
    [anon_sym_function] = ACTIONS(755),
    [anon_sym_global] = ACTIONS(755),
    [anon_sym_spork] = ACTIONS(755),
    [anon_sym_LPAREN] = ACTIONS(757),
    [anon_sym_public] = ACTIONS(755),
    [anon_sym_class] = ACTIONS(755),
    [anon_sym_extends] = ACTIONS(755),
    [sym_class_identifier] = ACTIONS(755),
    [anon_sym_new] = ACTIONS(755),
    [anon_sym_implements] = ACTIONS(755),
    [anon_sym_interface] = ACTIONS(755),
    [anon_sym_private] = ACTIONS(755),
    [anon_sym_protected] = ACTIONS(755),
    [anon_sym_pure] = ACTIONS(755),
    [anon_sym_static] = ACTIONS(755),
    [anon_sym_super] = ACTIONS(755),
    [anon_sym_this] = ACTIONS(755),
    [anon_sym_POUND_LPAREN] = ACTIONS(757),
    [anon_sym_if] = ACTIONS(755),
    [anon_sym_break] = ACTIONS(755),
    [anon_sym_continue] = ACTIONS(755),
    [anon_sym_switch] = ACTIONS(755),
    [anon_sym_LT_LT_LT] = ACTIONS(757),
    [anon_sym_ATdoc] = ACTIONS(757),
    [anon_sym_do] = ACTIONS(755),
    [anon_sym_day] = ACTIONS(755),
    [anon_sym_hour] = ACTIONS(755),
    [anon_sym_minute] = ACTIONS(755),
    [anon_sym_ms] = ACTIONS(755),
    [anon_sym_samp] = ACTIONS(755),
    [anon_sym_second] = ACTIONS(755),
    [anon_sym_week] = ACTIONS(755),
    [sym_float] = ACTIONS(757),
    [anon_sym_for] = ACTIONS(755),
    [anon_sym_SEMI] = ACTIONS(399),
    [anon_sym_fun] = ACTIONS(755),
    [anon_sym_adc] = ACTIONS(755),
    [anon_sym_blackhole] = ACTIONS(755),
    [anon_sym_dac] = ACTIONS(755),
    [sym_hexidecimal] = ACTIONS(757),
    [anon_sym_PLUS_PLUS] = ACTIONS(757),
    [anon_sym_DASH_DASH] = ACTIONS(757),
    [sym_int] = ACTIONS(755),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(755),
    [anon_sym_me] = ACTIONS(755),
    [anon_sym_BANG] = ACTIONS(757),
    [anon_sym_DASH] = ACTIONS(755),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(757),
    [anon_sym_auto] = ACTIONS(755),
    [anon_sym_complex] = ACTIONS(755),
    [anon_sym_dur] = ACTIONS(755),
    [anon_sym_float] = ACTIONS(755),
    [anon_sym_int] = ACTIONS(755),
    [anon_sym_polar] = ACTIONS(755),
    [anon_sym_same] = ACTIONS(755),
    [anon_sym_time] = ACTIONS(755),
    [anon_sym_vec2] = ACTIONS(755),
    [anon_sym_vec3] = ACTIONS(755),
    [anon_sym_vec4] = ACTIONS(755),
    [anon_sym_void] = ACTIONS(755),
    [anon_sym_Event] = ACTIONS(755),
    [anon_sym_Object] = ACTIONS(755),
    [anon_sym_UGen] = ACTIONS(755),
    [anon_sym_array] = ACTIONS(755),
    [anon_sym_string] = ACTIONS(755),
    [anon_sym_AT_LPAREN] = ACTIONS(757),
    [anon_sym_NULL] = ACTIONS(755),
    [anon_sym_maybe] = ACTIONS(755),
    [anon_sym_now] = ACTIONS(755),
    [anon_sym_null] = ACTIONS(755),
    [anon_sym_pi] = ACTIONS(755),
    [anon_sym_return] = ACTIONS(755),
    [anon_sym_DQUOTE] = ACTIONS(757),
    [anon_sym_until] = ACTIONS(755),
    [anon_sym_while] = ACTIONS(755),
  },
  [147] = {
    [sym_array_identifier] = STATE(437),
    [sym_boolean_literal_value] = STATE(252),
    [sym__chuck_keyword] = STATE(252),
    [sym__class_keyword] = STATE(252),
    [sym_complex] = STATE(524),
    [sym_control_structure_keyword] = STATE(252),
    [sym__declaration] = STATE(447),
    [sym_duration_identifier] = STATE(252),
    [sym_expression_group] = STATE(524),
    [sym_function_call] = STATE(436),
    [sym__function_call_chain] = STATE(506),
    [sym_global_unit_generator] = STATE(227),
    [sym__identifier] = STATE(437),
    [sym_keyword] = STATE(447),
    [sym__literal_value] = STATE(252),
    [sym_member_identifier] = STATE(439),
    [sym_polar] = STATE(524),
    [sym_primitive_type] = STATE(168),
    [sym_reference_declaration] = STATE(447),
    [sym_reference_type] = STATE(159),
    [sym_special_literal_value] = STATE(252),
    [sym_string] = STATE(524),
    [sym__type] = STATE(359),
    [sym_variable_declaration] = STATE(447),
    [sym_variable_identifier] = ACTIONS(7),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(13),
    [anon_sym_true] = ACTIONS(13),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(17),
    [anon_sym_global] = ACTIONS(21),
    [anon_sym_spork] = ACTIONS(17),
    [anon_sym_LPAREN] = ACTIONS(571),
    [anon_sym_extends] = ACTIONS(17),
    [sym_class_identifier] = ACTIONS(31),
    [anon_sym_implements] = ACTIONS(17),
    [anon_sym_interface] = ACTIONS(17),
    [anon_sym_private] = ACTIONS(17),
    [anon_sym_protected] = ACTIONS(17),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_static] = ACTIONS(37),
    [anon_sym_super] = ACTIONS(17),
    [anon_sym_this] = ACTIONS(39),
    [anon_sym_POUND_LPAREN] = ACTIONS(41),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(45),
    [anon_sym_switch] = ACTIONS(45),
    [anon_sym_day] = ACTIONS(53),
    [anon_sym_hour] = ACTIONS(53),
    [anon_sym_minute] = ACTIONS(53),
    [anon_sym_ms] = ACTIONS(53),
    [anon_sym_samp] = ACTIONS(53),
    [anon_sym_second] = ACTIONS(53),
    [anon_sym_week] = ACTIONS(53),
    [anon_sym_adc] = ACTIONS(61),
    [anon_sym_blackhole] = ACTIONS(61),
    [anon_sym_dac] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_me] = ACTIONS(71),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(77),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_NULL] = ACTIONS(85),
    [anon_sym_maybe] = ACTIONS(85),
    [anon_sym_now] = ACTIONS(85),
    [anon_sym_null] = ACTIONS(85),
    [anon_sym_pi] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(89),
  },
  [148] = {
    [sym_variable_identifier] = ACTIONS(831),
    [anon_sym_LBRACK] = ACTIONS(833),
    [anon_sym_RBRACE] = ACTIONS(833),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(831),
    [anon_sym_true] = ACTIONS(831),
    [anon_sym_SQUOTE] = ACTIONS(833),
    [anon_sym_const] = ACTIONS(831),
    [anon_sym_function] = ACTIONS(831),
    [anon_sym_global] = ACTIONS(831),
    [anon_sym_spork] = ACTIONS(831),
    [anon_sym_LPAREN] = ACTIONS(833),
    [anon_sym_public] = ACTIONS(831),
    [anon_sym_class] = ACTIONS(831),
    [anon_sym_extends] = ACTIONS(831),
    [sym_class_identifier] = ACTIONS(831),
    [anon_sym_new] = ACTIONS(831),
    [anon_sym_implements] = ACTIONS(831),
    [anon_sym_interface] = ACTIONS(831),
    [anon_sym_private] = ACTIONS(831),
    [anon_sym_protected] = ACTIONS(831),
    [anon_sym_pure] = ACTIONS(831),
    [anon_sym_static] = ACTIONS(831),
    [anon_sym_super] = ACTIONS(831),
    [anon_sym_this] = ACTIONS(831),
    [anon_sym_POUND_LPAREN] = ACTIONS(833),
    [anon_sym_if] = ACTIONS(831),
    [anon_sym_break] = ACTIONS(831),
    [anon_sym_continue] = ACTIONS(831),
    [anon_sym_switch] = ACTIONS(831),
    [anon_sym_LT_LT_LT] = ACTIONS(833),
    [anon_sym_ATdoc] = ACTIONS(833),
    [anon_sym_do] = ACTIONS(831),
    [anon_sym_day] = ACTIONS(831),
    [anon_sym_hour] = ACTIONS(831),
    [anon_sym_minute] = ACTIONS(831),
    [anon_sym_ms] = ACTIONS(831),
    [anon_sym_samp] = ACTIONS(831),
    [anon_sym_second] = ACTIONS(831),
    [anon_sym_week] = ACTIONS(831),
    [sym_float] = ACTIONS(833),
    [anon_sym_for] = ACTIONS(831),
    [anon_sym_fun] = ACTIONS(831),
    [anon_sym_adc] = ACTIONS(831),
    [anon_sym_blackhole] = ACTIONS(831),
    [anon_sym_dac] = ACTIONS(831),
    [sym_hexidecimal] = ACTIONS(833),
    [anon_sym_PLUS_PLUS] = ACTIONS(833),
    [anon_sym_DASH_DASH] = ACTIONS(833),
    [sym_int] = ACTIONS(831),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(831),
    [anon_sym_me] = ACTIONS(831),
    [anon_sym_BANG] = ACTIONS(833),
    [anon_sym_DASH] = ACTIONS(831),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(833),
    [anon_sym_auto] = ACTIONS(831),
    [anon_sym_complex] = ACTIONS(831),
    [anon_sym_dur] = ACTIONS(831),
    [anon_sym_float] = ACTIONS(831),
    [anon_sym_int] = ACTIONS(831),
    [anon_sym_polar] = ACTIONS(831),
    [anon_sym_same] = ACTIONS(831),
    [anon_sym_time] = ACTIONS(831),
    [anon_sym_vec2] = ACTIONS(831),
    [anon_sym_vec3] = ACTIONS(831),
    [anon_sym_vec4] = ACTIONS(831),
    [anon_sym_void] = ACTIONS(831),
    [anon_sym_Event] = ACTIONS(831),
    [anon_sym_Object] = ACTIONS(831),
    [anon_sym_UGen] = ACTIONS(831),
    [anon_sym_array] = ACTIONS(831),
    [anon_sym_string] = ACTIONS(831),
    [anon_sym_AT_LPAREN] = ACTIONS(833),
    [anon_sym_NULL] = ACTIONS(831),
    [anon_sym_maybe] = ACTIONS(831),
    [anon_sym_now] = ACTIONS(831),
    [anon_sym_null] = ACTIONS(831),
    [anon_sym_pi] = ACTIONS(831),
    [anon_sym_return] = ACTIONS(831),
    [anon_sym_DQUOTE] = ACTIONS(833),
    [anon_sym_until] = ACTIONS(831),
    [anon_sym_while] = ACTIONS(831),
  },
  [149] = {
    [sym_variable_identifier] = ACTIONS(835),
    [anon_sym_LBRACK] = ACTIONS(837),
    [anon_sym_RBRACE] = ACTIONS(837),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(835),
    [anon_sym_true] = ACTIONS(835),
    [anon_sym_SQUOTE] = ACTIONS(837),
    [anon_sym_const] = ACTIONS(835),
    [anon_sym_function] = ACTIONS(835),
    [anon_sym_global] = ACTIONS(835),
    [anon_sym_spork] = ACTIONS(835),
    [anon_sym_LPAREN] = ACTIONS(837),
    [anon_sym_public] = ACTIONS(835),
    [anon_sym_class] = ACTIONS(835),
    [anon_sym_extends] = ACTIONS(835),
    [sym_class_identifier] = ACTIONS(835),
    [anon_sym_new] = ACTIONS(835),
    [anon_sym_implements] = ACTIONS(835),
    [anon_sym_interface] = ACTIONS(835),
    [anon_sym_private] = ACTIONS(835),
    [anon_sym_protected] = ACTIONS(835),
    [anon_sym_pure] = ACTIONS(835),
    [anon_sym_static] = ACTIONS(835),
    [anon_sym_super] = ACTIONS(835),
    [anon_sym_this] = ACTIONS(835),
    [anon_sym_POUND_LPAREN] = ACTIONS(837),
    [anon_sym_if] = ACTIONS(835),
    [anon_sym_break] = ACTIONS(835),
    [anon_sym_continue] = ACTIONS(835),
    [anon_sym_switch] = ACTIONS(835),
    [anon_sym_LT_LT_LT] = ACTIONS(837),
    [anon_sym_ATdoc] = ACTIONS(837),
    [anon_sym_do] = ACTIONS(835),
    [anon_sym_day] = ACTIONS(835),
    [anon_sym_hour] = ACTIONS(835),
    [anon_sym_minute] = ACTIONS(835),
    [anon_sym_ms] = ACTIONS(835),
    [anon_sym_samp] = ACTIONS(835),
    [anon_sym_second] = ACTIONS(835),
    [anon_sym_week] = ACTIONS(835),
    [sym_float] = ACTIONS(837),
    [anon_sym_for] = ACTIONS(835),
    [anon_sym_fun] = ACTIONS(835),
    [anon_sym_adc] = ACTIONS(835),
    [anon_sym_blackhole] = ACTIONS(835),
    [anon_sym_dac] = ACTIONS(835),
    [sym_hexidecimal] = ACTIONS(837),
    [anon_sym_PLUS_PLUS] = ACTIONS(837),
    [anon_sym_DASH_DASH] = ACTIONS(837),
    [sym_int] = ACTIONS(835),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(835),
    [anon_sym_me] = ACTIONS(835),
    [anon_sym_BANG] = ACTIONS(837),
    [anon_sym_DASH] = ACTIONS(835),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(837),
    [anon_sym_auto] = ACTIONS(835),
    [anon_sym_complex] = ACTIONS(835),
    [anon_sym_dur] = ACTIONS(835),
    [anon_sym_float] = ACTIONS(835),
    [anon_sym_int] = ACTIONS(835),
    [anon_sym_polar] = ACTIONS(835),
    [anon_sym_same] = ACTIONS(835),
    [anon_sym_time] = ACTIONS(835),
    [anon_sym_vec2] = ACTIONS(835),
    [anon_sym_vec3] = ACTIONS(835),
    [anon_sym_vec4] = ACTIONS(835),
    [anon_sym_void] = ACTIONS(835),
    [anon_sym_Event] = ACTIONS(835),
    [anon_sym_Object] = ACTIONS(835),
    [anon_sym_UGen] = ACTIONS(835),
    [anon_sym_array] = ACTIONS(835),
    [anon_sym_string] = ACTIONS(835),
    [anon_sym_AT_LPAREN] = ACTIONS(837),
    [anon_sym_NULL] = ACTIONS(835),
    [anon_sym_maybe] = ACTIONS(835),
    [anon_sym_now] = ACTIONS(835),
    [anon_sym_null] = ACTIONS(835),
    [anon_sym_pi] = ACTIONS(835),
    [anon_sym_return] = ACTIONS(835),
    [anon_sym_DQUOTE] = ACTIONS(837),
    [anon_sym_until] = ACTIONS(835),
    [anon_sym_while] = ACTIONS(835),
  },
  [150] = {
    [sym_variable_identifier] = ACTIONS(839),
    [anon_sym_LBRACK] = ACTIONS(841),
    [anon_sym_RBRACE] = ACTIONS(841),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(839),
    [anon_sym_true] = ACTIONS(839),
    [anon_sym_SQUOTE] = ACTIONS(841),
    [anon_sym_const] = ACTIONS(839),
    [anon_sym_function] = ACTIONS(839),
    [anon_sym_global] = ACTIONS(839),
    [anon_sym_spork] = ACTIONS(839),
    [anon_sym_LPAREN] = ACTIONS(841),
    [anon_sym_public] = ACTIONS(839),
    [anon_sym_class] = ACTIONS(839),
    [anon_sym_extends] = ACTIONS(839),
    [sym_class_identifier] = ACTIONS(839),
    [anon_sym_new] = ACTIONS(839),
    [anon_sym_implements] = ACTIONS(839),
    [anon_sym_interface] = ACTIONS(839),
    [anon_sym_private] = ACTIONS(839),
    [anon_sym_protected] = ACTIONS(839),
    [anon_sym_pure] = ACTIONS(839),
    [anon_sym_static] = ACTIONS(839),
    [anon_sym_super] = ACTIONS(839),
    [anon_sym_this] = ACTIONS(839),
    [anon_sym_POUND_LPAREN] = ACTIONS(841),
    [anon_sym_if] = ACTIONS(839),
    [anon_sym_break] = ACTIONS(839),
    [anon_sym_continue] = ACTIONS(839),
    [anon_sym_switch] = ACTIONS(839),
    [anon_sym_LT_LT_LT] = ACTIONS(841),
    [anon_sym_ATdoc] = ACTIONS(841),
    [anon_sym_do] = ACTIONS(839),
    [anon_sym_day] = ACTIONS(839),
    [anon_sym_hour] = ACTIONS(839),
    [anon_sym_minute] = ACTIONS(839),
    [anon_sym_ms] = ACTIONS(839),
    [anon_sym_samp] = ACTIONS(839),
    [anon_sym_second] = ACTIONS(839),
    [anon_sym_week] = ACTIONS(839),
    [sym_float] = ACTIONS(841),
    [anon_sym_for] = ACTIONS(839),
    [anon_sym_fun] = ACTIONS(839),
    [anon_sym_adc] = ACTIONS(839),
    [anon_sym_blackhole] = ACTIONS(839),
    [anon_sym_dac] = ACTIONS(839),
    [sym_hexidecimal] = ACTIONS(841),
    [anon_sym_PLUS_PLUS] = ACTIONS(841),
    [anon_sym_DASH_DASH] = ACTIONS(841),
    [sym_int] = ACTIONS(839),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(839),
    [anon_sym_me] = ACTIONS(839),
    [anon_sym_BANG] = ACTIONS(841),
    [anon_sym_DASH] = ACTIONS(839),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(841),
    [anon_sym_auto] = ACTIONS(839),
    [anon_sym_complex] = ACTIONS(839),
    [anon_sym_dur] = ACTIONS(839),
    [anon_sym_float] = ACTIONS(839),
    [anon_sym_int] = ACTIONS(839),
    [anon_sym_polar] = ACTIONS(839),
    [anon_sym_same] = ACTIONS(839),
    [anon_sym_time] = ACTIONS(839),
    [anon_sym_vec2] = ACTIONS(839),
    [anon_sym_vec3] = ACTIONS(839),
    [anon_sym_vec4] = ACTIONS(839),
    [anon_sym_void] = ACTIONS(839),
    [anon_sym_Event] = ACTIONS(839),
    [anon_sym_Object] = ACTIONS(839),
    [anon_sym_UGen] = ACTIONS(839),
    [anon_sym_array] = ACTIONS(839),
    [anon_sym_string] = ACTIONS(839),
    [anon_sym_AT_LPAREN] = ACTIONS(841),
    [anon_sym_NULL] = ACTIONS(839),
    [anon_sym_maybe] = ACTIONS(839),
    [anon_sym_now] = ACTIONS(839),
    [anon_sym_null] = ACTIONS(839),
    [anon_sym_pi] = ACTIONS(839),
    [anon_sym_return] = ACTIONS(839),
    [anon_sym_DQUOTE] = ACTIONS(841),
    [anon_sym_until] = ACTIONS(839),
    [anon_sym_while] = ACTIONS(839),
  },
  [151] = {
    [sym_variable_identifier] = ACTIONS(843),
    [anon_sym_LBRACK] = ACTIONS(845),
    [anon_sym_RBRACE] = ACTIONS(845),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(843),
    [anon_sym_true] = ACTIONS(843),
    [anon_sym_SQUOTE] = ACTIONS(845),
    [anon_sym_const] = ACTIONS(843),
    [anon_sym_function] = ACTIONS(843),
    [anon_sym_global] = ACTIONS(843),
    [anon_sym_spork] = ACTIONS(843),
    [anon_sym_LPAREN] = ACTIONS(845),
    [anon_sym_public] = ACTIONS(843),
    [anon_sym_class] = ACTIONS(843),
    [anon_sym_extends] = ACTIONS(843),
    [sym_class_identifier] = ACTIONS(843),
    [anon_sym_new] = ACTIONS(843),
    [anon_sym_implements] = ACTIONS(843),
    [anon_sym_interface] = ACTIONS(843),
    [anon_sym_private] = ACTIONS(843),
    [anon_sym_protected] = ACTIONS(843),
    [anon_sym_pure] = ACTIONS(843),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_super] = ACTIONS(843),
    [anon_sym_this] = ACTIONS(843),
    [anon_sym_POUND_LPAREN] = ACTIONS(845),
    [anon_sym_if] = ACTIONS(843),
    [anon_sym_break] = ACTIONS(843),
    [anon_sym_continue] = ACTIONS(843),
    [anon_sym_switch] = ACTIONS(843),
    [anon_sym_LT_LT_LT] = ACTIONS(845),
    [anon_sym_ATdoc] = ACTIONS(845),
    [anon_sym_do] = ACTIONS(843),
    [anon_sym_day] = ACTIONS(843),
    [anon_sym_hour] = ACTIONS(843),
    [anon_sym_minute] = ACTIONS(843),
    [anon_sym_ms] = ACTIONS(843),
    [anon_sym_samp] = ACTIONS(843),
    [anon_sym_second] = ACTIONS(843),
    [anon_sym_week] = ACTIONS(843),
    [sym_float] = ACTIONS(845),
    [anon_sym_for] = ACTIONS(843),
    [anon_sym_fun] = ACTIONS(843),
    [anon_sym_adc] = ACTIONS(843),
    [anon_sym_blackhole] = ACTIONS(843),
    [anon_sym_dac] = ACTIONS(843),
    [sym_hexidecimal] = ACTIONS(845),
    [anon_sym_PLUS_PLUS] = ACTIONS(845),
    [anon_sym_DASH_DASH] = ACTIONS(845),
    [sym_int] = ACTIONS(843),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_me] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(845),
    [anon_sym_DASH] = ACTIONS(843),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(845),
    [anon_sym_auto] = ACTIONS(843),
    [anon_sym_complex] = ACTIONS(843),
    [anon_sym_dur] = ACTIONS(843),
    [anon_sym_float] = ACTIONS(843),
    [anon_sym_int] = ACTIONS(843),
    [anon_sym_polar] = ACTIONS(843),
    [anon_sym_same] = ACTIONS(843),
    [anon_sym_time] = ACTIONS(843),
    [anon_sym_vec2] = ACTIONS(843),
    [anon_sym_vec3] = ACTIONS(843),
    [anon_sym_vec4] = ACTIONS(843),
    [anon_sym_void] = ACTIONS(843),
    [anon_sym_Event] = ACTIONS(843),
    [anon_sym_Object] = ACTIONS(843),
    [anon_sym_UGen] = ACTIONS(843),
    [anon_sym_array] = ACTIONS(843),
    [anon_sym_string] = ACTIONS(843),
    [anon_sym_AT_LPAREN] = ACTIONS(845),
    [anon_sym_NULL] = ACTIONS(843),
    [anon_sym_maybe] = ACTIONS(843),
    [anon_sym_now] = ACTIONS(843),
    [anon_sym_null] = ACTIONS(843),
    [anon_sym_pi] = ACTIONS(843),
    [anon_sym_return] = ACTIONS(843),
    [anon_sym_DQUOTE] = ACTIONS(845),
    [anon_sym_until] = ACTIONS(843),
    [anon_sym_while] = ACTIONS(843),
  },
  [152] = {
    [sym_variable_identifier] = ACTIONS(843),
    [anon_sym_LBRACK] = ACTIONS(845),
    [anon_sym_RBRACE] = ACTIONS(845),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(843),
    [anon_sym_true] = ACTIONS(843),
    [anon_sym_SQUOTE] = ACTIONS(845),
    [anon_sym_const] = ACTIONS(843),
    [anon_sym_function] = ACTIONS(843),
    [anon_sym_global] = ACTIONS(843),
    [anon_sym_spork] = ACTIONS(843),
    [anon_sym_LPAREN] = ACTIONS(845),
    [anon_sym_public] = ACTIONS(843),
    [anon_sym_class] = ACTIONS(843),
    [anon_sym_extends] = ACTIONS(843),
    [sym_class_identifier] = ACTIONS(843),
    [anon_sym_new] = ACTIONS(843),
    [anon_sym_implements] = ACTIONS(843),
    [anon_sym_interface] = ACTIONS(843),
    [anon_sym_private] = ACTIONS(843),
    [anon_sym_protected] = ACTIONS(843),
    [anon_sym_pure] = ACTIONS(843),
    [anon_sym_static] = ACTIONS(843),
    [anon_sym_super] = ACTIONS(843),
    [anon_sym_this] = ACTIONS(843),
    [anon_sym_POUND_LPAREN] = ACTIONS(845),
    [anon_sym_if] = ACTIONS(843),
    [anon_sym_break] = ACTIONS(843),
    [anon_sym_continue] = ACTIONS(843),
    [anon_sym_switch] = ACTIONS(843),
    [anon_sym_LT_LT_LT] = ACTIONS(845),
    [anon_sym_ATdoc] = ACTIONS(845),
    [anon_sym_do] = ACTIONS(843),
    [anon_sym_day] = ACTIONS(843),
    [anon_sym_hour] = ACTIONS(843),
    [anon_sym_minute] = ACTIONS(843),
    [anon_sym_ms] = ACTIONS(843),
    [anon_sym_samp] = ACTIONS(843),
    [anon_sym_second] = ACTIONS(843),
    [anon_sym_week] = ACTIONS(843),
    [sym_float] = ACTIONS(845),
    [anon_sym_for] = ACTIONS(843),
    [anon_sym_fun] = ACTIONS(843),
    [anon_sym_adc] = ACTIONS(843),
    [anon_sym_blackhole] = ACTIONS(843),
    [anon_sym_dac] = ACTIONS(843),
    [sym_hexidecimal] = ACTIONS(845),
    [anon_sym_PLUS_PLUS] = ACTIONS(845),
    [anon_sym_DASH_DASH] = ACTIONS(845),
    [sym_int] = ACTIONS(843),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(843),
    [anon_sym_me] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(845),
    [anon_sym_DASH] = ACTIONS(843),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(845),
    [anon_sym_auto] = ACTIONS(843),
    [anon_sym_complex] = ACTIONS(843),
    [anon_sym_dur] = ACTIONS(843),
    [anon_sym_float] = ACTIONS(843),
    [anon_sym_int] = ACTIONS(843),
    [anon_sym_polar] = ACTIONS(843),
    [anon_sym_same] = ACTIONS(843),
    [anon_sym_time] = ACTIONS(843),
    [anon_sym_vec2] = ACTIONS(843),
    [anon_sym_vec3] = ACTIONS(843),
    [anon_sym_vec4] = ACTIONS(843),
    [anon_sym_void] = ACTIONS(843),
    [anon_sym_Event] = ACTIONS(843),
    [anon_sym_Object] = ACTIONS(843),
    [anon_sym_UGen] = ACTIONS(843),
    [anon_sym_array] = ACTIONS(843),
    [anon_sym_string] = ACTIONS(843),
    [anon_sym_AT_LPAREN] = ACTIONS(845),
    [anon_sym_NULL] = ACTIONS(843),
    [anon_sym_maybe] = ACTIONS(843),
    [anon_sym_now] = ACTIONS(843),
    [anon_sym_null] = ACTIONS(843),
    [anon_sym_pi] = ACTIONS(843),
    [anon_sym_return] = ACTIONS(843),
    [anon_sym_DQUOTE] = ACTIONS(845),
    [anon_sym_until] = ACTIONS(843),
    [anon_sym_while] = ACTIONS(843),
  },
  [153] = {
    [sym_variable_identifier] = ACTIONS(847),
    [anon_sym_LBRACK] = ACTIONS(849),
    [anon_sym_RBRACE] = ACTIONS(849),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(847),
    [anon_sym_true] = ACTIONS(847),
    [anon_sym_SQUOTE] = ACTIONS(849),
    [anon_sym_const] = ACTIONS(847),
    [anon_sym_function] = ACTIONS(847),
    [anon_sym_global] = ACTIONS(847),
    [anon_sym_spork] = ACTIONS(847),
    [anon_sym_LPAREN] = ACTIONS(849),
    [anon_sym_public] = ACTIONS(847),
    [anon_sym_class] = ACTIONS(847),
    [anon_sym_extends] = ACTIONS(847),
    [sym_class_identifier] = ACTIONS(847),
    [anon_sym_new] = ACTIONS(847),
    [anon_sym_implements] = ACTIONS(847),
    [anon_sym_interface] = ACTIONS(847),
    [anon_sym_private] = ACTIONS(847),
    [anon_sym_protected] = ACTIONS(847),
    [anon_sym_pure] = ACTIONS(847),
    [anon_sym_static] = ACTIONS(847),
    [anon_sym_super] = ACTIONS(847),
    [anon_sym_this] = ACTIONS(847),
    [anon_sym_POUND_LPAREN] = ACTIONS(849),
    [anon_sym_if] = ACTIONS(847),
    [anon_sym_break] = ACTIONS(847),
    [anon_sym_continue] = ACTIONS(847),
    [anon_sym_switch] = ACTIONS(847),
    [anon_sym_LT_LT_LT] = ACTIONS(849),
    [anon_sym_ATdoc] = ACTIONS(849),
    [anon_sym_do] = ACTIONS(847),
    [anon_sym_day] = ACTIONS(847),
    [anon_sym_hour] = ACTIONS(847),
    [anon_sym_minute] = ACTIONS(847),
    [anon_sym_ms] = ACTIONS(847),
    [anon_sym_samp] = ACTIONS(847),
    [anon_sym_second] = ACTIONS(847),
    [anon_sym_week] = ACTIONS(847),
    [sym_float] = ACTIONS(849),
    [anon_sym_for] = ACTIONS(847),
    [anon_sym_fun] = ACTIONS(847),
    [anon_sym_adc] = ACTIONS(847),
    [anon_sym_blackhole] = ACTIONS(847),
    [anon_sym_dac] = ACTIONS(847),
    [sym_hexidecimal] = ACTIONS(849),
    [anon_sym_PLUS_PLUS] = ACTIONS(849),
    [anon_sym_DASH_DASH] = ACTIONS(849),
    [sym_int] = ACTIONS(847),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(847),
    [anon_sym_me] = ACTIONS(847),
    [anon_sym_BANG] = ACTIONS(849),
    [anon_sym_DASH] = ACTIONS(847),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(849),
    [anon_sym_auto] = ACTIONS(847),
    [anon_sym_complex] = ACTIONS(847),
    [anon_sym_dur] = ACTIONS(847),
    [anon_sym_float] = ACTIONS(847),
    [anon_sym_int] = ACTIONS(847),
    [anon_sym_polar] = ACTIONS(847),
    [anon_sym_same] = ACTIONS(847),
    [anon_sym_time] = ACTIONS(847),
    [anon_sym_vec2] = ACTIONS(847),
    [anon_sym_vec3] = ACTIONS(847),
    [anon_sym_vec4] = ACTIONS(847),
    [anon_sym_void] = ACTIONS(847),
    [anon_sym_Event] = ACTIONS(847),
    [anon_sym_Object] = ACTIONS(847),
    [anon_sym_UGen] = ACTIONS(847),
    [anon_sym_array] = ACTIONS(847),
    [anon_sym_string] = ACTIONS(847),
    [anon_sym_AT_LPAREN] = ACTIONS(849),
    [anon_sym_NULL] = ACTIONS(847),
    [anon_sym_maybe] = ACTIONS(847),
    [anon_sym_now] = ACTIONS(847),
    [anon_sym_null] = ACTIONS(847),
    [anon_sym_pi] = ACTIONS(847),
    [anon_sym_return] = ACTIONS(847),
    [anon_sym_DQUOTE] = ACTIONS(849),
    [anon_sym_until] = ACTIONS(847),
    [anon_sym_while] = ACTIONS(847),
  },
  [154] = {
    [sym_variable_identifier] = ACTIONS(851),
    [anon_sym_LBRACK] = ACTIONS(853),
    [anon_sym_RBRACE] = ACTIONS(853),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(851),
    [anon_sym_true] = ACTIONS(851),
    [anon_sym_SQUOTE] = ACTIONS(853),
    [anon_sym_const] = ACTIONS(851),
    [anon_sym_function] = ACTIONS(851),
    [anon_sym_global] = ACTIONS(851),
    [anon_sym_spork] = ACTIONS(851),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_public] = ACTIONS(851),
    [anon_sym_class] = ACTIONS(851),
    [anon_sym_extends] = ACTIONS(851),
    [sym_class_identifier] = ACTIONS(851),
    [anon_sym_new] = ACTIONS(851),
    [anon_sym_implements] = ACTIONS(851),
    [anon_sym_interface] = ACTIONS(851),
    [anon_sym_private] = ACTIONS(851),
    [anon_sym_protected] = ACTIONS(851),
    [anon_sym_pure] = ACTIONS(851),
    [anon_sym_static] = ACTIONS(851),
    [anon_sym_super] = ACTIONS(851),
    [anon_sym_this] = ACTIONS(851),
    [anon_sym_POUND_LPAREN] = ACTIONS(853),
    [anon_sym_if] = ACTIONS(851),
    [anon_sym_break] = ACTIONS(851),
    [anon_sym_continue] = ACTIONS(851),
    [anon_sym_switch] = ACTIONS(851),
    [anon_sym_LT_LT_LT] = ACTIONS(853),
    [anon_sym_ATdoc] = ACTIONS(853),
    [anon_sym_do] = ACTIONS(851),
    [anon_sym_day] = ACTIONS(851),
    [anon_sym_hour] = ACTIONS(851),
    [anon_sym_minute] = ACTIONS(851),
    [anon_sym_ms] = ACTIONS(851),
    [anon_sym_samp] = ACTIONS(851),
    [anon_sym_second] = ACTIONS(851),
    [anon_sym_week] = ACTIONS(851),
    [sym_float] = ACTIONS(853),
    [anon_sym_for] = ACTIONS(851),
    [anon_sym_fun] = ACTIONS(851),
    [anon_sym_adc] = ACTIONS(851),
    [anon_sym_blackhole] = ACTIONS(851),
    [anon_sym_dac] = ACTIONS(851),
    [sym_hexidecimal] = ACTIONS(853),
    [anon_sym_PLUS_PLUS] = ACTIONS(853),
    [anon_sym_DASH_DASH] = ACTIONS(853),
    [sym_int] = ACTIONS(851),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(851),
    [anon_sym_me] = ACTIONS(851),
    [anon_sym_BANG] = ACTIONS(853),
    [anon_sym_DASH] = ACTIONS(851),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(853),
    [anon_sym_auto] = ACTIONS(851),
    [anon_sym_complex] = ACTIONS(851),
    [anon_sym_dur] = ACTIONS(851),
    [anon_sym_float] = ACTIONS(851),
    [anon_sym_int] = ACTIONS(851),
    [anon_sym_polar] = ACTIONS(851),
    [anon_sym_same] = ACTIONS(851),
    [anon_sym_time] = ACTIONS(851),
    [anon_sym_vec2] = ACTIONS(851),
    [anon_sym_vec3] = ACTIONS(851),
    [anon_sym_vec4] = ACTIONS(851),
    [anon_sym_void] = ACTIONS(851),
    [anon_sym_Event] = ACTIONS(851),
    [anon_sym_Object] = ACTIONS(851),
    [anon_sym_UGen] = ACTIONS(851),
    [anon_sym_array] = ACTIONS(851),
    [anon_sym_string] = ACTIONS(851),
    [anon_sym_AT_LPAREN] = ACTIONS(853),
    [anon_sym_NULL] = ACTIONS(851),
    [anon_sym_maybe] = ACTIONS(851),
    [anon_sym_now] = ACTIONS(851),
    [anon_sym_null] = ACTIONS(851),
    [anon_sym_pi] = ACTIONS(851),
    [anon_sym_return] = ACTIONS(851),
    [anon_sym_DQUOTE] = ACTIONS(853),
    [anon_sym_until] = ACTIONS(851),
    [anon_sym_while] = ACTIONS(851),
  },
  [155] = {
    [sym_variable_identifier] = ACTIONS(745),
    [anon_sym_LBRACK] = ACTIONS(743),
    [anon_sym_LBRACE] = ACTIONS(743),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(745),
    [anon_sym_true] = ACTIONS(745),
    [anon_sym_SQUOTE] = ACTIONS(743),
    [anon_sym_const] = ACTIONS(745),
    [anon_sym_function] = ACTIONS(745),
    [anon_sym_global] = ACTIONS(745),
    [anon_sym_spork] = ACTIONS(745),
    [anon_sym_LPAREN] = ACTIONS(743),
    [anon_sym_public] = ACTIONS(745),
    [anon_sym_extends] = ACTIONS(745),
    [sym_class_identifier] = ACTIONS(745),
    [anon_sym_new] = ACTIONS(745),
    [anon_sym_implements] = ACTIONS(745),
    [anon_sym_interface] = ACTIONS(745),
    [anon_sym_private] = ACTIONS(745),
    [anon_sym_protected] = ACTIONS(745),
    [anon_sym_pure] = ACTIONS(745),
    [anon_sym_static] = ACTIONS(745),
    [anon_sym_super] = ACTIONS(745),
    [anon_sym_this] = ACTIONS(745),
    [anon_sym_POUND_LPAREN] = ACTIONS(743),
    [anon_sym_if] = ACTIONS(745),
    [anon_sym_break] = ACTIONS(745),
    [anon_sym_continue] = ACTIONS(745),
    [anon_sym_switch] = ACTIONS(745),
    [anon_sym_LT_LT_LT] = ACTIONS(743),
    [anon_sym_ATdoc] = ACTIONS(743),
    [anon_sym_do] = ACTIONS(745),
    [anon_sym_day] = ACTIONS(745),
    [anon_sym_hour] = ACTIONS(745),
    [anon_sym_minute] = ACTIONS(745),
    [anon_sym_ms] = ACTIONS(745),
    [anon_sym_samp] = ACTIONS(745),
    [anon_sym_second] = ACTIONS(745),
    [anon_sym_week] = ACTIONS(745),
    [sym_float] = ACTIONS(743),
    [anon_sym_for] = ACTIONS(745),
    [anon_sym_fun] = ACTIONS(745),
    [anon_sym_adc] = ACTIONS(745),
    [anon_sym_blackhole] = ACTIONS(745),
    [anon_sym_dac] = ACTIONS(745),
    [sym_hexidecimal] = ACTIONS(743),
    [anon_sym_PLUS_PLUS] = ACTIONS(743),
    [anon_sym_DASH_DASH] = ACTIONS(743),
    [sym_int] = ACTIONS(745),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(745),
    [anon_sym_me] = ACTIONS(745),
    [anon_sym_BANG] = ACTIONS(743),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(743),
    [anon_sym_auto] = ACTIONS(745),
    [anon_sym_complex] = ACTIONS(745),
    [anon_sym_dur] = ACTIONS(745),
    [anon_sym_float] = ACTIONS(745),
    [anon_sym_int] = ACTIONS(745),
    [anon_sym_polar] = ACTIONS(745),
    [anon_sym_same] = ACTIONS(745),
    [anon_sym_time] = ACTIONS(745),
    [anon_sym_vec2] = ACTIONS(745),
    [anon_sym_vec3] = ACTIONS(745),
    [anon_sym_vec4] = ACTIONS(745),
    [anon_sym_void] = ACTIONS(745),
    [anon_sym_Event] = ACTIONS(745),
    [anon_sym_Object] = ACTIONS(745),
    [anon_sym_UGen] = ACTIONS(745),
    [anon_sym_array] = ACTIONS(745),
    [anon_sym_string] = ACTIONS(745),
    [anon_sym_AT_LPAREN] = ACTIONS(743),
    [anon_sym_NULL] = ACTIONS(745),
    [anon_sym_maybe] = ACTIONS(745),
    [anon_sym_now] = ACTIONS(745),
    [anon_sym_null] = ACTIONS(745),
    [anon_sym_pi] = ACTIONS(745),
    [anon_sym_return] = ACTIONS(745),
    [anon_sym_DQUOTE] = ACTIONS(743),
    [anon_sym_until] = ACTIONS(745),
    [anon_sym_while] = ACTIONS(745),
  },
  [156] = {
    [sym_variable_identifier] = ACTIONS(855),
    [anon_sym_LBRACK] = ACTIONS(857),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(855),
    [anon_sym_true] = ACTIONS(855),
    [anon_sym_SQUOTE] = ACTIONS(857),
    [anon_sym_const] = ACTIONS(855),
    [anon_sym_function] = ACTIONS(855),
    [anon_sym_global] = ACTIONS(855),
    [anon_sym_spork] = ACTIONS(855),
    [anon_sym_LPAREN] = ACTIONS(857),
    [anon_sym_public] = ACTIONS(855),
    [anon_sym_class] = ACTIONS(855),
    [anon_sym_extends] = ACTIONS(855),
    [sym_class_identifier] = ACTIONS(855),
    [anon_sym_new] = ACTIONS(855),
    [anon_sym_implements] = ACTIONS(855),
    [anon_sym_interface] = ACTIONS(855),
    [anon_sym_private] = ACTIONS(855),
    [anon_sym_protected] = ACTIONS(855),
    [anon_sym_pure] = ACTIONS(855),
    [anon_sym_static] = ACTIONS(855),
    [anon_sym_super] = ACTIONS(855),
    [anon_sym_this] = ACTIONS(855),
    [anon_sym_POUND_LPAREN] = ACTIONS(857),
    [anon_sym_if] = ACTIONS(855),
    [anon_sym_break] = ACTIONS(855),
    [anon_sym_continue] = ACTIONS(855),
    [anon_sym_switch] = ACTIONS(855),
    [anon_sym_LT_LT_LT] = ACTIONS(857),
    [anon_sym_do] = ACTIONS(855),
    [anon_sym_day] = ACTIONS(855),
    [anon_sym_hour] = ACTIONS(855),
    [anon_sym_minute] = ACTIONS(855),
    [anon_sym_ms] = ACTIONS(855),
    [anon_sym_samp] = ACTIONS(855),
    [anon_sym_second] = ACTIONS(855),
    [anon_sym_week] = ACTIONS(855),
    [sym_float] = ACTIONS(857),
    [anon_sym_for] = ACTIONS(855),
    [anon_sym_fun] = ACTIONS(855),
    [anon_sym_adc] = ACTIONS(855),
    [anon_sym_blackhole] = ACTIONS(855),
    [anon_sym_dac] = ACTIONS(855),
    [sym_hexidecimal] = ACTIONS(857),
    [anon_sym_PLUS_PLUS] = ACTIONS(857),
    [anon_sym_DASH_DASH] = ACTIONS(857),
    [sym_int] = ACTIONS(855),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(855),
    [anon_sym_me] = ACTIONS(855),
    [anon_sym_BANG] = ACTIONS(857),
    [anon_sym_DASH] = ACTIONS(855),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(857),
    [anon_sym_auto] = ACTIONS(855),
    [anon_sym_complex] = ACTIONS(855),
    [anon_sym_dur] = ACTIONS(855),
    [anon_sym_float] = ACTIONS(855),
    [anon_sym_int] = ACTIONS(855),
    [anon_sym_polar] = ACTIONS(855),
    [anon_sym_same] = ACTIONS(855),
    [anon_sym_time] = ACTIONS(855),
    [anon_sym_vec2] = ACTIONS(855),
    [anon_sym_vec3] = ACTIONS(855),
    [anon_sym_vec4] = ACTIONS(855),
    [anon_sym_void] = ACTIONS(855),
    [anon_sym_Event] = ACTIONS(855),
    [anon_sym_Object] = ACTIONS(855),
    [anon_sym_UGen] = ACTIONS(855),
    [anon_sym_array] = ACTIONS(855),
    [anon_sym_string] = ACTIONS(855),
    [anon_sym_AT_LPAREN] = ACTIONS(857),
    [anon_sym_NULL] = ACTIONS(855),
    [anon_sym_maybe] = ACTIONS(855),
    [anon_sym_now] = ACTIONS(855),
    [anon_sym_null] = ACTIONS(855),
    [anon_sym_pi] = ACTIONS(855),
    [anon_sym_DQUOTE] = ACTIONS(857),
    [anon_sym_until] = ACTIONS(855),
    [anon_sym_while] = ACTIONS(855),
  },
  [157] = {
    [sym_variable_identifier] = ACTIONS(859),
    [anon_sym_LBRACK] = ACTIONS(861),
    [anon_sym_LBRACE] = ACTIONS(861),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_false] = ACTIONS(859),
    [anon_sym_true] = ACTIONS(859),
    [anon_sym_SQUOTE] = ACTIONS(861),
    [anon_sym_const] = ACTIONS(859),
    [anon_sym_function] = ACTIONS(859),
    [anon_sym_global] = ACTIONS(859),
    [anon_sym_spork] = ACTIONS(859),
    [anon_sym_LPAREN] = ACTIONS(861),
    [anon_sym_extends] = ACTIONS(859),
    [sym_class_identifier] = ACTIONS(859),
    [anon_sym_new] = ACTIONS(859),
    [anon_sym_implements] = ACTIONS(859),
    [anon_sym_interface] = ACTIONS(859),
    [anon_sym_private] = ACTIONS(859),
    [anon_sym_protected] = ACTIONS(859),
    [anon_sym_pure] = ACTIONS(859),
    [anon_sym_static] = ACTIONS(859),
    [anon_sym_super] = ACTIONS(859),
    [anon_sym_this] = ACTIONS(859),
    [anon_sym_POUND_LPAREN] = ACTIONS(861),
    [anon_sym_if] = ACTIONS(859),
    [anon_sym_break] = ACTIONS(859),
    [anon_sym_continue] = ACTIONS(859),
    [anon_sym_switch] = ACTIONS(859),
    [anon_sym_LT_LT_LT] = ACTIONS(861),
    [anon_sym_do] = ACTIONS(859),
    [anon_sym_day] = ACTIONS(859),
    [anon_sym_hour] = ACTIONS(859),
    [anon_sym_minute] = ACTIONS(859),
    [anon_sym_ms] = ACTIONS(859),
    [anon_sym_samp] = ACTIONS(859),
    [anon_sym_second] = ACTIONS(859),
    [anon_sym_week] = ACTIONS(859),
    [sym_float] = ACTIONS(861),
    [anon_sym_for] = ACTIONS(859),
    [anon_sym_adc] = ACTIONS(859),
    [anon_sym_blackhole] = ACTIONS(859),
    [anon_sym_dac] = ACTIONS(859),
    [sym_hexidecimal] = ACTIONS(861),
    [anon_sym_PLUS_PLUS] = ACTIONS(861),
    [anon_sym_DASH_DASH] = ACTIONS(861),
    [sym_int] = ACTIONS(859),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_repeat] = ACTIONS(859),
    [anon_sym_me] = ACTIONS(859),
    [anon_sym_BANG] = ACTIONS(861),
    [anon_sym_DASH] = ACTIONS(859),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(861),
    [anon_sym_auto] = ACTIONS(859),
    [anon_sym_complex] = ACTIONS(859),
    [anon_sym_dur] = ACTIONS(859),
    [anon_sym_float] = ACTIONS(859),
    [anon_sym_int] = ACTIONS(859),
    [anon_sym_polar] = ACTIONS(859),
    [anon_sym_same] = ACTIONS(859),
    [anon_sym_time] = ACTIONS(859),
    [anon_sym_vec2] = ACTIONS(859),
    [anon_sym_vec3] = ACTIONS(859),
    [anon_sym_vec4] = ACTIONS(859),
    [anon_sym_void] = ACTIONS(859),
    [anon_sym_Event] = ACTIONS(859),
    [anon_sym_Object] = ACTIONS(859),
    [anon_sym_UGen] = ACTIONS(859),
    [anon_sym_array] = ACTIONS(859),
    [anon_sym_string] = ACTIONS(859),
    [anon_sym_AT_LPAREN] = ACTIONS(861),
    [anon_sym_NULL] = ACTIONS(859),
    [anon_sym_maybe] = ACTIONS(859),
    [anon_sym_now] = ACTIONS(859),
    [anon_sym_null] = ACTIONS(859),
    [anon_sym_pi] = ACTIONS(859),
    [anon_sym_DQUOTE] = ACTIONS(861),
    [anon_sym_until] = ACTIONS(859),
    [anon_sym_while] = ACTIONS(859),
  },
  [158] = {
    [sym_primitive_type] = STATE(448),
    [sym_reference_type] = STATE(448),
    [sym__type] = STATE(391),
    [sym_variable_identifier] = ACTIONS(863),
    [anon_sym_RBRACK] = ACTIONS(865),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_DOLLAR] = ACTIONS(865),
    [anon_sym_RPAREN] = ACTIONS(865),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(865),
    [anon_sym_AMP_EQ_GT] = ACTIONS(865),
    [anon_sym_STAR_EQ_GT] = ACTIONS(865),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(865),
    [anon_sym_DASH_DASH_GT] = ACTIONS(865),
    [anon_sym_DASH_EQ_GT] = ACTIONS(865),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(865),
    [anon_sym_EQ_LT] = ACTIONS(865),
    [anon_sym_EQ_GT] = ACTIONS(865),
    [anon_sym_EQ_CARET] = ACTIONS(865),
    [anon_sym_AT_EQ_GT] = ACTIONS(865),
    [anon_sym_CARET_EQ_GT] = ACTIONS(865),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(865),
    [sym_class_identifier] = ACTIONS(867),
    [anon_sym_static] = ACTIONS(869),
    [anon_sym_COMMA] = ACTIONS(865),
    [anon_sym_GT_GT_GT] = ACTIONS(865),
    [anon_sym_COLON_COLON] = ACTIONS(865),
    [anon_sym_SEMI] = ACTIONS(865),
    [anon_sym_PLUS_PLUS] = ACTIONS(865),
    [anon_sym_DASH_DASH] = ACTIONS(871),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_DASH] = ACTIONS(871),
    [anon_sym_BANG_EQ] = ACTIONS(865),
    [anon_sym_PERCENT] = ACTIONS(871),
    [anon_sym_AMP] = ACTIONS(871),
    [anon_sym_AMP_AMP] = ACTIONS(865),
    [anon_sym_STAR] = ACTIONS(871),
    [anon_sym_PLUS] = ACTIONS(871),
    [anon_sym_SLASH] = ACTIONS(871),
    [anon_sym_LT] = ACTIONS(871),
    [anon_sym_LT_LT] = ACTIONS(865),
    [anon_sym_LT_EQ] = ACTIONS(865),
    [anon_sym_EQ_EQ] = ACTIONS(865),
    [anon_sym_GT] = ACTIONS(871),
    [anon_sym_GT_EQ] = ACTIONS(865),
    [anon_sym_GT_GT] = ACTIONS(871),
    [anon_sym_CARET] = ACTIONS(871),
    [anon_sym_PIPE] = ACTIONS(871),
    [anon_sym_PIPE_PIPE] = ACTIONS(865),
    [anon_sym_auto] = ACTIONS(79),
    [anon_sym_complex] = ACTIONS(79),
    [anon_sym_dur] = ACTIONS(79),
    [anon_sym_float] = ACTIONS(79),
    [anon_sym_int] = ACTIONS(79),
    [anon_sym_polar] = ACTIONS(79),
    [anon_sym_same] = ACTIONS(79),
    [anon_sym_time] = ACTIONS(79),
    [anon_sym_vec2] = ACTIONS(79),
    [anon_sym_vec3] = ACTIONS(79),
    [anon_sym_vec4] = ACTIONS(79),
    [anon_sym_void] = ACTIONS(79),
    [anon_sym_Event] = ACTIONS(81),
    [anon_sym_Object] = ACTIONS(81),
    [anon_sym_UGen] = ACTIONS(81),
    [anon_sym_array] = ACTIONS(81),
    [anon_sym_string] = ACTIONS(81),
    [anon_sym_QMARK] = ACTIONS(865),
  },
  [159] = {
    [aux_sym_array_identifier_repeat1] = STATE(182),
    [sym_variable_identifier] = ACTIONS(873),
    [anon_sym_LBRACK] = ACTIONS(875),
    [anon_sym_RBRACK] = ACTIONS(877),
    [sym_block_comment] = ACTIONS(3),
    [anon_sym_DOLLAR] = ACTIONS(877),
    [anon_sym_LPAREN] = ACTIONS(877),
    [anon_sym_RPAREN] = ACTIONS(877),
    [anon_sym_PERCENT_EQ_GT] = ACTIONS(877),
    [anon_sym_AMP_EQ_GT] = ACTIONS(877),
    [anon_sym_STAR_EQ_GT] = ACTIONS(877),
    [anon_sym_PLUS_EQ_GT] = ACTIONS(877),
    [anon_sym_DASH_DASH_GT] = ACTIONS(877),
    [anon_sym_DASH_EQ_GT] = ACTIONS(877),
    [anon_sym_SLASH_EQ_GT] = ACTIONS(877),
    [anon_sym_EQ_LT] = ACTIONS(877),
    [anon_sym_EQ_GT] = ACTIONS(877),
    [anon_sym_EQ_CARET] = ACTIONS(877),
    [anon_sym_AT_EQ_GT] = ACTIONS(877),
    [anon_sym_CARET_EQ_GT] = ACTIONS(877),
    [anon_sym_PIPE_EQ_GT] = ACTIONS(877),
    [sym_class_identifier] = ACTIONS(873),
    [anon_sym_this] = ACTIONS(873),
    [anon_sym_POUND_LPAREN] = ACTIONS(879),
    [anon_sym_COMMA] = ACTIONS(877),
    [anon_sym_GT_GT_GT] = ACTIONS(877),
    [anon_sym_COLON_COLON] = ACTIONS(877),
    [anon_sym_SEMI] = ACTIONS(877),
    [anon_sym_COLON] = ACTIONS(881),
    [anon_sym_DOT] = ACTIONS(877),
    [anon_sym_adc] = ACTIONS(873),
    [anon_sym_blackhole] = ACTIONS(873),
    [anon_sym_dac] = ACTIONS(873),
    [anon_sym_PLUS_PLUS] = ACTIONS(877),
    [anon_sym_DASH_DASH] = ACTIONS(881),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_me] = ACTIONS(873),
    [anon_sym_DASH] = ACTIONS(881),
    [anon_sym_BANG_EQ] = ACTIONS(877),
    [anon_sym_PERCENT] = ACTIONS(881),
    [anon_sym_AMP] = ACTIONS(881),
    [anon_sym_AMP_AMP] = ACTIONS(877),
    [anon_sym_STAR] = ACTIONS(881),
    [anon_sym_PLUS] = ACTIONS(881),
    [anon_sym_SLASH] = ACTIONS(881),
    [anon_sym_LT] = ACTIONS(881),
    [anon_sym_LT_LT] = ACTIONS(877),
    [anon_sym_LT_EQ] = ACTIONS(877),
    [anon_sym_EQ_EQ] = ACTIONS(877),
    [anon_sym_GT] = ACTIONS(881),
    [anon_sym_GT_EQ] = ACTIONS(877),
    [anon_sym_GT_GT] = ACTIONS(881),
    [anon_sym_CARET] = ACTIONS(881),
    [anon_sym_PIPE] = ACTIONS(881),
    [anon_sym_PIPE_PIPE] = ACTIONS(877),
    [anon_sym_PERCENT_LPAREN] = ACTIONS(879),
    [anon_sym_AT] = ACTIONS(873),
    [anon_sym_Event] = ACTIONS(873),
    [anon_sym_Object] = ACTIONS(873),
    [anon_sym_UGen] = ACTIONS(873),
    [anon_sym_array] = ACTIONS(873),
    [anon_sym_string] = ACTIONS(873),
    [anon_sym_DQUOTE] = ACTIONS(879),
    [anon_sym_QMARK] = ACTIONS(877),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(883),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(885), 27,
      anon_sym_LBRACK,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_COLON,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_DASH_DASH,
      anon_sym_me,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AT,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(887), 35,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_POUND_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_PERCENT_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [71] = 8,
    ACTIONS(889), 1,
      sym_variable_identifier,
    ACTIONS(893), 1,
      sym_class_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(445), 2,
      sym_primitive_type,
      sym_reference_type,
    ACTIONS(81), 5,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
    ACTIONS(79), 12,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
    ACTIONS(895), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(891), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [152] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(879), 3,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_DQUOTE,
    ACTIONS(873), 13,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_AT,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(881), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(877), 31,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [231] = 10,
    ACTIONS(899), 1,
      sym_variable_identifier,
    ACTIONS(901), 1,
      sym_class_identifier,
    ACTIONS(903), 1,
      anon_sym_static,
    STATE(561), 1,
      sym__type,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(517), 2,
      sym_primitive_type,
      sym_reference_type,
    ACTIONS(907), 5,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
    ACTIONS(895), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(905), 12,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
    ACTIONS(891), 27,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [315] = 9,
    ACTIONS(875), 1,
      anon_sym_LBRACK,
    ACTIONS(883), 1,
      anon_sym_LBRACK_RBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(521), 1,
      sym__function_parameters,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(879), 3,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_DQUOTE,
    ACTIONS(881), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(873), 13,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_AT,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(877), 29,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [396] = 5,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(911), 2,
      anon_sym_ATconstruct,
      anon_sym_ATdestruct,
    ACTIONS(871), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(909), 20,
      sym_class_identifier,
      anon_sym_static,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(865), 27,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [469] = 8,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(522), 1,
      sym__function_parameters,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(879), 3,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_DQUOTE,
    ACTIONS(881), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(873), 13,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_AT,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(877), 29,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [547] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(913), 25,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_DASH_DASH,
      anon_sym_me,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
      anon_sym_AT,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(915), 34,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_POUND_LPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_PERCENT_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [615] = 6,
    ACTIONS(883), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(879), 4,
      anon_sym_LPAREN,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_DQUOTE,
    ACTIONS(919), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(873), 13,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_AT,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(917), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [689] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(923), 5,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_DQUOTE,
    ACTIONS(921), 53,
      anon_sym_false,
      anon_sym_true,
      anon_sym_const,
      anon_sym_function,
      anon_sym_global,
      anon_sym_spork,
      anon_sym_extends,
      sym_class_identifier,
      anon_sym_implements,
      anon_sym_interface,
      anon_sym_private,
      anon_sym_protected,
      anon_sym_pure,
      anon_sym_static,
      anon_sym_super,
      anon_sym_this,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_switch,
      anon_sym_day,
      anon_sym_hour,
      anon_sym_minute,
      anon_sym_ms,
      anon_sym_samp,
      anon_sym_second,
      anon_sym_week,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      anon_sym_NULL,
      anon_sym_maybe,
      anon_sym_now,
      anon_sym_null,
      anon_sym_pi,
      sym_variable_identifier,
  [756] = 10,
    ACTIONS(867), 1,
      sym_class_identifier,
    ACTIONS(869), 1,
      anon_sym_static,
    ACTIONS(925), 1,
      sym_variable_identifier,
    STATE(386), 1,
      sym__type,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(448), 2,
      sym_primitive_type,
      sym_reference_type,
    ACTIONS(81), 5,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
    ACTIONS(871), 8,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(79), 12,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
    ACTIONS(865), 20,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BANG_EQ,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_STAR,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [830] = 8,
    ACTIONS(883), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(927), 1,
      anon_sym_LBRACK,
    STATE(297), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(879), 4,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_AT,
      anon_sym_DQUOTE,
    ACTIONS(881), 9,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(873), 12,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(877), 21,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_STAR,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [898] = 8,
    ACTIONS(889), 1,
      sym_variable_identifier,
    ACTIONS(893), 1,
      sym_class_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    STATE(445), 2,
      sym_primitive_type,
      sym_reference_type,
    ACTIONS(81), 5,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
    ACTIONS(895), 8,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(79), 12,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
    ACTIONS(891), 20,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BANG_EQ,
      anon_sym_PERCENT,
      anon_sym_AMP_AMP,
      anon_sym_STAR,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [966] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(885), 22,
      anon_sym_LBRACK,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_COLON,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(887), 26,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_STAR,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_PERCENT_LPAREN,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [1023] = 7,
    ACTIONS(929), 1,
      anon_sym_LBRACK,
    STATE(297), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(879), 4,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_AT,
      anon_sym_DQUOTE,
    ACTIONS(881), 9,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(873), 12,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(877), 21,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_STAR,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1088] = 9,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    STATE(230), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(935), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(931), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1156] = 9,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    STATE(231), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(941), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(939), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1224] = 8,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    STATE(231), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(941), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(939), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1289] = 6,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(949), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(947), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1350] = 5,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    STATE(179), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(956), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(954), 31,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1409] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(960), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(958), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1472] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(964), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(962), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1535] = 5,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(179), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(968), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(966), 31,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1594] = 5,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(881), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(877), 31,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1653] = 6,
    ACTIONS(883), 1,
      anon_sym_LBRACK_RBRACK,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(879), 5,
      anon_sym_LPAREN,
      anon_sym_POUND_LPAREN,
      anon_sym_PERCENT_LPAREN,
      anon_sym_AT,
      anon_sym_DQUOTE,
    ACTIONS(919), 9,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
    ACTIONS(873), 12,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(917), 19,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_STAR,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1714] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(913), 21,
      sym_class_identifier,
      anon_sym_this,
      anon_sym_COLON,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
      anon_sym_me,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PIPE,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
      sym_variable_identifier,
    ACTIONS(915), 25,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_POUND_LPAREN,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_STAR,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_PERCENT_LPAREN,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
  [1769] = 8,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    STATE(230), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(935), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(931), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1834] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(885), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(887), 33,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      sym_class_identifier,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AToperator,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      sym_variable_identifier,
  [1888] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(972), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(970), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [1950] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(976), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(974), 32,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2004] = 6,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(960), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(958), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2064] = 5,
    ACTIONS(980), 1,
      anon_sym_DOT,
    STATE(191), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(983), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(978), 31,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2122] = 6,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(964), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(962), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2182] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(987), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(985), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2244] = 5,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(191), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(991), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(989), 31,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2302] = 5,
    ACTIONS(993), 1,
      anon_sym_DOT,
    STATE(195), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(949), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(947), 30,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2360] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(885), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(887), 32,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2414] = 5,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(195), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(998), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(996), 30,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2472] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(197), 1,
      aux_sym__function_call_chain_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2534] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(230), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(935), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(931), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2596] = 7,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(231), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(941), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(939), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2658] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(956), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(954), 32,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2712] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(913), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(915), 33,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      sym_class_identifier,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_AToperator,
      anon_sym_QMARK,
      anon_sym_LBRACK_RBRACK,
      sym_variable_identifier,
  [2766] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1002), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1000), 31,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2819] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(983), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(978), 32,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2872] = 6,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(987), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(985), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2931] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1006), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1004), 31,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [2984] = 6,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3043] = 6,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3102] = 5,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(960), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(958), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3159] = 5,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(964), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(962), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3216] = 6,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1010), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1008), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3275] = 5,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(987), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(985), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3331] = 5,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(895), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(891), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3387] = 14,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    STATE(472), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1012), 3,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_GT_GT_GT,
    ACTIONS(1028), 7,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 11,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [3461] = 5,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(972), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(970), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3517] = 4,
    ACTIONS(1032), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(695), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(693), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3571] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(821), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(819), 31,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3623] = 5,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1036), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1034), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3679] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(701), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(699), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3731] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(705), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(703), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3783] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(709), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(707), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3835] = 5,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1040), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1038), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3891] = 5,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3947] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(713), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(711), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_else,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [3999] = 5,
    ACTIONS(1042), 1,
      anon_sym_COMMA,
    STATE(225), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(960), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(958), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4055] = 5,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4111] = 5,
    ACTIONS(945), 1,
      anon_sym_DOT,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(919), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(917), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4167] = 6,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    STATE(182), 1,
      aux_sym_array_identifier_repeat1,
    STATE(512), 1,
      sym__function_parameters,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(881), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(877), 29,
      anon_sym_DOLLAR,
      anon_sym_LPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4225] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1045), 5,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_SEMI,
    ACTIONS(1028), 7,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 11,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [4295] = 5,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    STATE(225), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(941), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(939), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4351] = 5,
    ACTIONS(933), 1,
      anon_sym_COMMA,
    STATE(225), 1,
      aux_sym_variable_declaration_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1049), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1047), 28,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4407] = 20,
    ACTIONS(7), 1,
      sym_variable_identifier,
    ACTIONS(31), 1,
      sym_class_identifier,
    ACTIONS(41), 1,
      anon_sym_POUND_LPAREN,
    ACTIONS(77), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(89), 1,
      anon_sym_DQUOTE,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    ACTIONS(869), 1,
      anon_sym_static,
    STATE(159), 1,
      sym_reference_type,
    STATE(180), 1,
      sym_function_call,
    STATE(209), 1,
      sym__function_call_chain,
    STATE(394), 1,
      sym__type,
    STATE(448), 1,
      sym_primitive_type,
    STATE(500), 1,
      sym_member_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1051), 2,
      anon_sym_this,
      anon_sym_me,
    STATE(190), 2,
      sym_array_identifier,
      sym__identifier,
    ACTIONS(61), 3,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
    ACTIONS(81), 5,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
    STATE(524), 5,
      sym_complex,
      sym_expression_group,
      sym_global_unit_generator,
      sym_polar,
      sym_string,
    ACTIONS(79), 12,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
  [4492] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1055), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1053), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4543] = 4,
    STATE(84), 1,
      sym_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1059), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1057), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4596] = 20,
    ACTIONS(41), 1,
      anon_sym_POUND_LPAREN,
    ACTIONS(77), 1,
      anon_sym_PERCENT_LPAREN,
    ACTIONS(89), 1,
      anon_sym_DQUOTE,
    ACTIONS(457), 1,
      sym_variable_identifier,
    ACTIONS(475), 1,
      sym_class_identifier,
    ACTIONS(571), 1,
      anon_sym_LPAREN,
    ACTIONS(869), 1,
      anon_sym_static,
    STATE(171), 1,
      sym_reference_type,
    STATE(306), 1,
      sym_function_call,
    STATE(331), 1,
      sym__function_call_chain,
    STATE(393), 1,
      sym__type,
    STATE(448), 1,
      sym_primitive_type,
    STATE(498), 1,
      sym_member_identifier,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1051), 2,
      anon_sym_this,
      anon_sym_me,
    STATE(320), 2,
      sym_array_identifier,
      sym__identifier,
    ACTIONS(61), 3,
      anon_sym_adc,
      anon_sym_blackhole,
      anon_sym_dac,
    ACTIONS(517), 5,
      anon_sym_Event,
      anon_sym_Object,
      anon_sym_UGen,
      anon_sym_array,
      anon_sym_string,
    STATE(524), 5,
      sym_complex,
      sym_expression_group,
      sym_global_unit_generator,
      sym_polar,
      sym_string,
    ACTIONS(79), 12,
      anon_sym_auto,
      anon_sym_complex,
      anon_sym_dur,
      anon_sym_float,
      anon_sym_int,
      anon_sym_polar,
      anon_sym_same,
      anon_sym_time,
      anon_sym_vec2,
      anon_sym_vec3,
      anon_sym_vec4,
      anon_sym_void,
  [4681] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1063), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1061), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4732] = 5,
    ACTIONS(737), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(735), 3,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_GT_GT_GT,
    ACTIONS(741), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 26,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4787] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(737), 13,
      anon_sym_COLON,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(735), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4838] = 4,
    STATE(84), 1,
      sym_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1067), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1065), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4891] = 4,
    STATE(84), 1,
      sym_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1071), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1069), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4944] = 4,
    STATE(84), 1,
      sym_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1075), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1073), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [4997] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1079), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1077), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5048] = 4,
    ACTIONS(1081), 1,
      anon_sym_TILDE,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(871), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(865), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5101] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1085), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1083), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5152] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1089), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1087), 30,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5203] = 4,
    STATE(84), 1,
      sym_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1093), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1091), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5256] = 14,
    ACTIONS(1012), 1,
      anon_sym_SEMI,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    STATE(472), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [5328] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1097), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1095), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5378] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1101), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1099), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5428] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(749), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(747), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5478] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(745), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(743), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5528] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(919), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(917), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5578] = 14,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1103), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    STATE(472), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [5650] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(725), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(723), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5700] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(733), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(731), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5750] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1107), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1105), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5800] = 14,
    ACTIONS(1012), 1,
      anon_sym_SEMI,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    STATE(472), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [5872] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1111), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1109), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5922] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(721), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(719), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [5972] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1115), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1113), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6022] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(729), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(727), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6072] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1119), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1117), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6122] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1123), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1121), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6172] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1127), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1125), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6222] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1036), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1034), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6272] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1131), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1129), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6322] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1135), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1133), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6372] = 3,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(717), 12,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(715), 29,
      anon_sym_RBRACK,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COMMA,
      anon_sym_GT_GT_GT,
      anon_sym_COLON_COLON,
      anon_sym_SEMI,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6422] = 14,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1018), 1,
      anon_sym_COMMA,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1137), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    STATE(472), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [6494] = 7,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    ACTIONS(1139), 1,
      anon_sym_SEMI,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 25,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COLON_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6551] = 7,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    ACTIONS(1141), 1,
      anon_sym_SEMI,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 25,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COLON_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6608] = 7,
    ACTIONS(943), 1,
      anon_sym_LPAREN,
    ACTIONS(945), 1,
      anon_sym_DOT,
    ACTIONS(1143), 1,
      anon_sym_SEMI,
    STATE(194), 1,
      aux_sym_member_identifier_repeat1,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(741), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(739), 25,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COLON_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [6665] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1145), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [6731] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1147), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [6797] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1149), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [6863] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1151), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [6929] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1153), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [6995] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1155), 1,
      anon_sym_SEMI,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [7061] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1157), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [7127] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1159), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [7193] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1161), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [7259] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1163), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [7325] = 12,
    ACTIONS(1014), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1022), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1024), 1,
      anon_sym_DASH_DASH,
    ACTIONS(1030), 1,
      anon_sym_QMARK,
    ACTIONS(1165), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym_operator,
    STATE(147), 1,
      sym_chuck_operator,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1028), 8,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
    ACTIONS(1026), 10,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1016), 13,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
  [7391] = 5,
    ACTIONS(1141), 1,
      anon_sym_SEMI,
    ACTIONS(1169), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1171), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1167), 25,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COLON_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [7442] = 5,
    ACTIONS(1143), 1,
      anon_sym_SEMI,
    ACTIONS(1173), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(1171), 11,
      anon_sym_DASH_DASH,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_AMP,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_CARET,
      anon_sym_PIPE,
    ACTIONS(1167), 25,
      anon_sym_DOLLAR,
      anon_sym_PERCENT_EQ_GT,
      anon_sym_AMP_EQ_GT,
      anon_sym_STAR_EQ_GT,
      anon_sym_PLUS_EQ_GT,
      anon_sym_DASH_DASH_GT,
      anon_sym_DASH_EQ_GT,
      anon_sym_SLASH_EQ_GT,
      anon_sym_EQ_LT,
      anon_sym_EQ_GT,
      anon_sym_EQ_CARET,
      anon_sym_AT_EQ_GT,
      anon_sym_CARET_EQ_GT,
      anon_sym_PIPE_EQ_GT,
      anon_sym_COLON_COLON,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_EQ,
      anon_sym_AMP_AMP,
      anon_sym_LT_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [7493] = 5,
    ACTIONS(1139), 1,
      anon_sym_SEMI,
    AC