/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.adapters.VirtualFlowHelper;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXTreeView;
import java.lang.ref.WeakReference;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXTreeCell<T>
extends TreeCell<T> {
    protected JFXRippler cellRippler = new JFXRippler((Node)new StackPane()){

        @Override
        protected void initListeners() {
            this.ripplerPane.setOnMousePressed(event -> this.createRipple(event.getX(), event.getY()));
        }
    };
    private HBox hbox;
    private StackPane selectedPane = new StackPane();
    private WeakReference<TreeItem<T>> treeItemRef;
    private ChangeListener<Boolean> weakExpandListener = (observable, oldValue, newValue) -> {
        int currentRow;
        JFXTreeView jfxTreeView = (JFXTreeView)this.getTreeView();
        jfxTreeView.clearAnimation();
        jfxTreeView.animateRow = currentRow = this.getTreeView().getRow(this.getTreeItem());
        jfxTreeView.expand = newValue;
        jfxTreeView.disableSiblings = false;
        VirtualFlowHelper.setTreeView(jfxTreeView, newValue, currentRow, this.getTreeItem());
    };
    private InvalidationListener treeItemGraphicInvalidationListener = observable -> this.updateDisplay(this.getItem(), this.isEmpty());
    private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicInvalidationListener);
    private ChangeListener<? super Animation.Status> weakAnimationListener = (o, oldVal, newVal) -> {
        if (newVal == Animation.Status.STOPPED) {
            this.clearCellAnimation();
        }
    };
    private WeakReference<JFXTreeView<T>> treeViewRef;

    public JFXTreeCell() {
        this.selectedPane.setStyle("-fx-background-color:RED");
        this.selectedPane.setPrefWidth(3.0);
        this.selectedPane.setMouseTransparent(true);
        this.selectedProperty().addListener((o, oldVal, newVal) -> this.selectedPane.setOpacity(newVal != false ? 1.0 : 0.0));
        InvalidationListener treeViewInvalidationListener = observable -> {
            JFXTreeView newTreeView;
            JFXTreeView oldTreeView;
            JFXTreeView jFXTreeView = oldTreeView = this.treeViewRef == null ? null : (JFXTreeView)this.treeViewRef.get();
            if (oldTreeView != null) {
                oldTreeView.trans.statusProperty().removeListener(this.weakAnimationListener);
            }
            if ((newTreeView = (JFXTreeView)this.getTreeView()) != null) {
                newTreeView.trans.statusProperty().addListener(this.weakAnimationListener);
                this.treeViewRef = new WeakReference<JFXTreeView>(newTreeView);
            }
        };
        WeakInvalidationListener weakTreeViewListener = new WeakInvalidationListener(treeViewInvalidationListener);
        this.treeViewProperty().addListener((InvalidationListener)weakTreeViewListener);
        InvalidationListener treeItemInvalidationListener = observable -> {
            TreeItem newTreeItem;
            TreeItem oldTreeItem;
            TreeItem treeItem = oldTreeItem = this.treeItemRef == null ? null : (TreeItem)this.treeItemRef.get();
            if (oldTreeItem != null) {
                oldTreeItem.graphicProperty().removeListener((InvalidationListener)this.weakTreeItemGraphicListener);
                oldTreeItem.expandedProperty().removeListener(this.weakExpandListener);
            }
            if ((newTreeItem = this.getTreeItem()) != null) {
                newTreeItem.graphicProperty().addListener((InvalidationListener)this.weakTreeItemGraphicListener);
                newTreeItem.expandedProperty().addListener(this.weakExpandListener);
                this.treeItemRef = new WeakReference<TreeItem>(newTreeItem);
            }
        };
        WeakInvalidationListener weakTreeItemListener = new WeakInvalidationListener(treeItemInvalidationListener);
        this.treeItemProperty().addListener((InvalidationListener)weakTreeItemListener);
        if (this.getTreeItem() != null) {
            this.getTreeItem().graphicProperty().addListener((InvalidationListener)this.weakTreeItemGraphicListener);
        }
    }

    public void updateIndex(int i) {
        int oldIndex;
        JFXTreeView jfxTreeView = (JFXTreeView)this.getTreeView();
        if (jfxTreeView.animateRow != -1 && i != -1 && ((oldIndex = this.getIndex()) == -1 || oldIndex > 0 && i > 0 && oldIndex != i)) {
            if (jfxTreeView.sibRow == -1 && jfxTreeView.getTreeItem(i) != null && jfxTreeView.getTreeItem(jfxTreeView.animateRow) != null && i > jfxTreeView.animateRow && jfxTreeView.getTreeItem(i).getParent() == jfxTreeView.getTreeItem(jfxTreeView.animateRow).getParent()) {
                jfxTreeView.sibRow = i;
                if (jfxTreeView.expand) {
                    jfxTreeView.height = (double)(-(jfxTreeView.sibRow - jfxTreeView.animateRow - 1)) * this.getHeight();
                }
            }
            if (jfxTreeView.getTreeItem(i) != null && jfxTreeView.getTreeItem(i) == jfxTreeView.getTreeItem(jfxTreeView.animateRow) && (double)i * this.getHeight() != jfxTreeView.layoutY) {
                jfxTreeView.disableSiblings = true;
                for (int index : jfxTreeView.sibAnimationMap.keySet()) {
                    if (index <= i) continue;
                    jfxTreeView.trans.getChildren().remove((Object)jfxTreeView.sibAnimationMap.get(index).getAnimation());
                    super.clearCellAnimation();
                }
                jfxTreeView.sibAnimationMap.clear();
            }
            if (i > jfxTreeView.animateRow) {
                if (jfxTreeView.expand) {
                    if (i >= jfxTreeView.sibRow && jfxTreeView.sibRow != -1) {
                        this.animateSibling(i, jfxTreeView);
                    } else {
                        this.animateChild(i, jfxTreeView);
                    }
                } else {
                    this.animateSibling(i, jfxTreeView);
                }
            }
        }
        super.updateIndex(i);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (!this.getChildren().contains((Object)this.cellRippler)) {
            this.getChildren().add(0, (Object)this.cellRippler);
            this.getChildren().add(0, (Object)this.selectedPane);
        }
        if (this.isEmpty()) {
            this.cellRippler.resizeRelocate(0.0, 0.0, 0.0, 0.0);
        } else {
            this.cellRippler.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        this.selectedPane.resizeRelocate(0.0, 0.0, this.selectedPane.prefWidth(-1.0), this.getHeight());
        this.selectedPane.setOpacity(this.isSelected() ? 1.0 : 0.0);
        if (((JFXTreeView)this.getTreeView()).trans.getChildren().isEmpty()) {
            this.clearCellAnimation();
            ((JFXTreeView)this.getTreeView()).animateRow = -1;
        } else if (((JFXTreeView)this.getTreeView()).trans.getStatus() == Animation.Status.STOPPED) {
            ((JFXTreeView)this.getTreeView()).trans.setOnFinished(finish -> {
                ((JFXTreeView)this.getTreeView()).trans.getChildren().clear();
                ((JFXTreeView)this.getTreeView()).animateRow = -1;
            });
            ((JFXTreeView)this.getTreeView()).trans.play();
        }
    }

    private void updateDisplay(T item, boolean empty) {
        if (item == null || empty) {
            this.hbox = null;
            this.setText(null);
            this.setGraphic(null);
        } else {
            TreeItem treeItem = this.getTreeItem();
            if (treeItem != null && treeItem.getGraphic() != null) {
                if (item instanceof Node) {
                    this.setText(null);
                    if (this.hbox == null) {
                        this.hbox = new HBox(3.0);
                    }
                    this.hbox.getChildren().setAll((Object[])new Node[]{treeItem.getGraphic(), (Node)item});
                    this.setGraphic((Node)this.hbox);
                } else {
                    this.hbox = null;
                    this.setText(item.toString());
                    this.setGraphic(treeItem.getGraphic());
                }
            } else {
                this.hbox = null;
                if (item instanceof Node) {
                    this.setText(null);
                    this.setGraphic((Node)item);
                } else {
                    this.setText(item.toString());
                    this.setGraphic(null);
                }
            }
        }
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateDisplay(item, empty);
    }

    private void animateChild(int i, JFXTreeView<T> jfxTreeView) {
        Timeline createChildAnimation = this.createChildAnimation(this, i - jfxTreeView.animateRow - 1);
        if (jfxTreeView.childrenAnimationMap.containsKey(i)) {
            jfxTreeView.trans.getChildren().remove((Object)jfxTreeView.childrenAnimationMap.get(i).getAnimation());
            super.clearCellAnimation();
        }
        jfxTreeView.childrenAnimationMap.put(i, new JFXTreeView.CellAnimation(this, (Animation)createChildAnimation));
        jfxTreeView.trans.getChildren().add((Object)createChildAnimation);
    }

    private void animateSibling(int i, JFXTreeView<T> jfxTreeView) {
        if (!jfxTreeView.disableSiblings) {
            Timeline createSibAnimation = this.createSibAnimation(this, i);
            jfxTreeView.sibAnimationMap.put(i, new JFXTreeView.CellAnimation(this, (Animation)createSibAnimation));
            jfxTreeView.trans.getChildren().add((Object)createSibAnimation);
        }
    }

    private void clearCellAnimation() {
        this.setOpacity(1.0);
        this.setTranslateY(0.0);
    }

    private Timeline createSibAnimation(TreeCell<?> cell, int index) {
        cell.setTranslateY(((JFXTreeView)this.getTreeView()).height);
        return new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), new KeyValue[]{new KeyValue((WritableValue)cell.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
    }

    private Timeline createChildAnimation(TreeCell<?> cell, int delay) {
        cell.setOpacity(0.0);
        cell.setTranslateY(-1.0);
        Timeline f1 = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)120.0), new KeyValue[]{new KeyValue((WritableValue)cell.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)cell.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
        f1.setDelay(Duration.millis((double)(20 + delay * 10)));
        return f1;
    }
}

