/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.url.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.jackhuang.hmcl.util.url.data.DataUri;

public final class DataURLConnection
extends URLConnection {
    private final DataUri dataUri;
    private byte[] data;
    private InputStream inputStream;

    DataURLConnection(URL url, DataUri dataUri) {
        super(url);
        this.dataUri = dataUri;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.connected = true;
            this.data = this.dataUri.readBytes();
            this.inputStream = new ByteArrayInputStream(this.data);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return this.dataUri.getMediaType();
    }

    @Override
    public long getContentLengthLong() {
        return this.data != null ? (long)this.data.length : -1L;
    }
}

