/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.animation;

import javafx.animation.Animation;
import javafx.scene.Node;

public abstract class JFXNodesAnimation<S extends Node, T extends Node> {
    protected S fromNode;
    protected T toNode;

    public JFXNodesAnimation(S fromNode, T toNode) {
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    public void animate() {
        this.init();
        Animation exitAnimation = this.animateExit();
        Animation sharedAnimation = this.animateSharedNodes();
        Animation enteranceAnimation = this.animateEntrance();
        exitAnimation.setOnFinished(finish -> sharedAnimation.play());
        sharedAnimation.setOnFinished(finish -> enteranceAnimation.play());
        enteranceAnimation.setOnFinished(finish -> this.end());
        exitAnimation.play();
    }

    public abstract Animation animateExit();

    public abstract Animation animateSharedNodes();

    public abstract Animation animateEntrance();

    public abstract void init();

    public abstract void end();
}

