/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.png.javafx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import org.glavo.png.PNGType;
import org.glavo.png.PNGWriter;
import org.glavo.png.image.ArgbImageWrapper;

public final class PNGJavaFXUtils {
    private PNGJavaFXUtils() {
    }

    public static ArgbImageWrapper<Image> asArgbImage(Image image) {
        final PixelReader pixelReader = image.getPixelReader();
        return new ArgbImageWrapper<Image>(image, (int)image.getWidth(), (int)image.getHeight()){

            @Override
            public int getArgb(int x, int y) {
                return pixelReader.getArgb(x, y);
            }
        };
    }

    public static void writeImage(Image image, Path file) throws IOException {
        PNGJavaFXUtils.writeImage(image, Files.newOutputStream(file, new OpenOption[0]));
    }

    public static void writeImage(Image image, Path file, PNGType type) throws IOException {
        PNGJavaFXUtils.writeImage(image, Files.newOutputStream(file, new OpenOption[0]), type);
    }

    public static void writeImage(Image image, Path file, PNGType type, int compressLevel) throws IOException {
        PNGJavaFXUtils.writeImage(image, Files.newOutputStream(file, new OpenOption[0]), type, compressLevel);
    }

    public static byte[] writeImageToArray(Image image) {
        return PNGJavaFXUtils.writeImageToArray(image, PNGType.RGBA, -1);
    }

    public static byte[] writeImageToArray(Image image, PNGType type) {
        return PNGJavaFXUtils.writeImageToArray(image, type, -1);
    }

    public static byte[] writeImageToArray(Image image, PNGType type, int compressLevel) {
        int estimatedSize = (int)(image.getWidth() * image.getHeight() * (double)(type == PNGType.RGB ? 3 : 4) + 32.0);
        if (compressLevel != 1) {
            estimatedSize /= 2;
        }
        try {
            ByteArrayOutputStream temp = new ByteArrayOutputStream(Integer.max(estimatedSize, 32));
            PNGJavaFXUtils.writeImage(image, temp, type, compressLevel);
            return temp.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeImage(Image image, OutputStream out) throws IOException {
        PNGJavaFXUtils.writeImage(image, out, PNGType.RGBA, -1);
    }

    private static void writeImage(Image image, OutputStream out, PNGType type) throws IOException {
        PNGJavaFXUtils.writeImage(image, out, type, -1);
    }

    private static void writeImage(Image image, OutputStream out, PNGType type, int compressLevel) throws IOException {
        new PNGWriter(out, type, compressLevel).write(PNGJavaFXUtils.asArgbImage(image));
    }
}

