/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.RefreshedVersionsEvent;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.account.AccountAdvancedListItem;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.main.MainPage;
import org.jackhuang.hmcl.ui.nbt.NBTEditorPage;
import org.jackhuang.hmcl.ui.nbt.NBTFileType;
import org.jackhuang.hmcl.ui.versions.GameAdvancedListItem;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.Bits;
import org.jackhuang.hmcl.util.platform.OSVersion;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class RootPage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private MainPage mainPage = null;
    private boolean checkedModpack = false;

    public RootPage() {
        EventBus.EVENT_BUS.channel(RefreshedVersionsEvent.class).register(event -> this.onRefreshedVersions((HMCLGameRepository)event.getSource()));
        Profile profile = Profiles.getSelectedProfile();
        if (profile != null && profile.getRepository().isLoaded()) {
            this.onRefreshedVersions(((Profile)Profiles.selectedProfileProperty().get()).getRepository());
        }
        this.getStyleClass().remove((Object)"gray-background");
        this.getLeft().getStyleClass().add((Object)"gray-background");
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.getMainPage().stateProperty();
    }

    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    public MainPage getMainPage() {
        if (this.mainPage == null) {
            MainPage mainPage = new MainPage();
            FXUtils.applyDragListener((Node)mainPage, file -> ModpackHelper.isFileModpackByExtension(file) || NBTFileType.isNBTFileByExtension(file), modpacks -> {
                Path file = (Path)modpacks.get(0);
                if (ModpackHelper.isFileModpackByExtension(file)) {
                    Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(Profiles.getSelectedProfile(), file), I18n.i18n("install.modpack"));
                } else if (NBTFileType.isNBTFileByExtension(file)) {
                    try {
                        Controllers.navigate((Node)new NBTEditorPage(file));
                    }
                    catch (Throwable e) {
                        Logger.LOG.warning("Fail to open nbt file", e);
                        Controllers.dialog(I18n.i18n("nbt.open.failed") + "\n\n" + StringUtils.getStackTrace(e), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                    }
                }
            });
            FXUtils.onChangeAndOperate(Profiles.selectedVersionProperty(), mainPage::setCurrentGame);
            mainPage.showUpdateProperty().bind((ObservableValue)UpdateChecker.outdatedProperty());
            mainPage.latestVersionProperty().bind(UpdateChecker.latestVersionProperty());
            Profiles.registerVersionsListener(profile -> {
                HMCLGameRepository repository = profile.getRepository();
                List children = repository.getVersions().parallelStream().filter(version -> !version.isHidden()).sorted(Comparator.comparing(version -> Lang.requireNonNullElse(version.getReleaseTime(), Instant.EPOCH)).thenComparing(version -> VersionNumber.asVersion(repository.getGameVersion((Version)version).orElse(version.getId())))).collect(Collectors.toList());
                FXUtils.runInFX(() -> {
                    if (profile == Profiles.getSelectedProfile()) {
                        mainPage.initVersions((Profile)profile, children);
                    }
                });
            });
            this.mainPage = mainPage;
        }
        return this.mainPage;
    }

    private void onRefreshedVersions(HMCLGameRepository repository) {
        FXUtils.runInFX(() -> {
            if (!this.checkedModpack) {
                Path modpackFile;
                this.checkedModpack = true;
                if (repository.getVersionCount() == 0 && Files.exists(modpackFile = Metadata.CURRENT_DIRECTORY.resolve("modpack.zip"), new LinkOption[0])) {
                    Task.supplyAsync(() -> CompressingUtils.findSuitableEncoding(modpackFile)).thenApplyAsync(encoding -> ModpackHelper.readModpackManifest(modpackFile, encoding)).thenApplyAsync(modpack -> ModpackHelper.getInstallTask(repository.getProfile(), modpackFile, modpack.getName(), modpack).executor()).thenAcceptAsync(Schedulers.javafx(), executor -> {
                        Controllers.taskDialog(executor, I18n.i18n("modpack.installing"), TaskCancellationAction.NO_CANCEL);
                        executor.start();
                    }).start();
                }
            }
        });
    }

    private static class Skin
    extends DecoratorAnimatedPage.DecoratorAnimatedPageSkin<RootPage> {
        protected Skin(RootPage control) {
            super(control);
            AccountAdvancedListItem accountListItem = new AccountAdvancedListItem();
            accountListItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getAccountListPage())));
            accountListItem.accountProperty().bind(Accounts.selectedAccountProperty());
            GameAdvancedListItem gameListItem = new GameAdvancedListItem();
            gameListItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                Profile profile = Profiles.getSelectedProfile();
                String version = Profiles.getSelectedVersion();
                if (version == null) {
                    Controllers.navigate((Node)Controllers.getGameListPage());
                } else {
                    Versions.modifyGameSettings(profile, version);
                }
            }));
            FXUtils.onScroll((Node)gameListItem, ((RootPage)this.getSkinnable()).getMainPage().getVersions(), list -> {
                String currentId = ((RootPage)this.getSkinnable()).getMainPage().getCurrentGame();
                return Lang.indexWhere(list, instance -> instance.getId().equals(currentId));
            }, it -> ((RootPage)this.getSkinnable()).getMainPage().getProfile().setSelectedVersion(it.getId()));
            if (AnimationUtils.isAnimationEnabled()) {
                FXUtils.prepareOnMouseEnter((Node)gameListItem, Controllers::prepareVersionPage);
            }
            AdvancedListItem gameItem = new AdvancedListItem();
            gameItem.setLeftGraphic(VersionPage.wrap(SVG.FORMAT_LIST_BULLETED));
            gameItem.setActionButtonVisible(false);
            gameItem.setTitle(I18n.i18n("version.manage"));
            gameItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getGameListPage())));
            AdvancedListItem downloadItem = new AdvancedListItem();
            downloadItem.setLeftGraphic(VersionPage.wrap(SVG.DOWNLOAD));
            downloadItem.setActionButtonVisible(false);
            downloadItem.setTitle(I18n.i18n("download"));
            downloadItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                Controllers.getDownloadPage().showGameDownloads();
                Controllers.navigate((Node)Controllers.getDownloadPage());
            }));
            FXUtils.installFastTooltip((Node)downloadItem, I18n.i18n("download.hint"));
            if (AnimationUtils.isAnimationEnabled()) {
                FXUtils.prepareOnMouseEnter((Node)downloadItem, Controllers::prepareDownloadPage);
            }
            AdvancedListItem launcherSettingsItem = new AdvancedListItem();
            launcherSettingsItem.setLeftGraphic(VersionPage.wrap(SVG.SETTINGS));
            launcherSettingsItem.setActionButtonVisible(false);
            launcherSettingsItem.setTitle(I18n.i18n("settings"));
            launcherSettingsItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                Controllers.getSettingsPage().showGameSettings(Profiles.getSelectedProfile());
                Controllers.navigate((Node)Controllers.getSettingsPage());
            }));
            if (AnimationUtils.isAnimationEnabled()) {
                FXUtils.prepareOnMouseEnter((Node)launcherSettingsItem, Controllers::prepareSettingsPage);
            }
            AdvancedListItem terracottaItem = new AdvancedListItem();
            terracottaItem.setLeftGraphic(VersionPage.wrap(SVG.GRAPH2));
            terracottaItem.setActionButtonVisible(false);
            terracottaItem.setTitle(I18n.i18n("terracotta"));
            terracottaItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                if (TerracottaMetadata.PROVIDER != null) {
                    Controllers.navigate(Controllers.getTerracottaPage());
                } else {
                    String message = Architecture.SYSTEM_ARCH.getBits() == Bits.BIT_32 ? I18n.i18n("terracotta.unsupported.arch.32bit") : (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && !OperatingSystem.SYSTEM_VERSION.isAtLeast(OSVersion.WINDOWS_10) ? I18n.i18n("terracotta.unsupported.os.windows.old") : (Platform.SYSTEM_PLATFORM.equals(OperatingSystem.LINUX, Architecture.LOONGARCH64_OW) ? I18n.i18n("terracotta.unsupported.arch.loongarch64_ow") : I18n.i18n("terracotta.unsupported")));
                    Controllers.dialog(message, null, MessageDialogPane.MessageType.WARNING);
                }
            }));
            AdvancedListBox sideBar = new AdvancedListBox().startCategory(I18n.i18n("account").toUpperCase(Locale.ROOT)).add((Node)accountListItem).startCategory(I18n.i18n("version").toUpperCase(Locale.ROOT)).add((Node)gameListItem).add((Node)gameItem).add((Node)downloadItem).startCategory(I18n.i18n("settings.launcher.general").toUpperCase(Locale.ROOT)).add((Node)launcherSettingsItem).add((Node)terracottaItem).addNavigationDrawerItem(I18n.i18n("chat"), SVG.CHAT, () -> FXUtils.openLink("https://www.bilibili.com/opus/905435541874409529"));
            this.setLeft(new Node[]{sideBar});
            this.setCenter(new Node[]{((RootPage)this.getSkinnable()).getMainPage()});
        }
    }
}

