/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.windows;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import org.jackhuang.hmcl.util.platform.hardware.CentralProcessor;
import org.jackhuang.hmcl.util.platform.hardware.HardwareVendor;
import org.jackhuang.hmcl.util.platform.windows.Kernel32;
import org.jackhuang.hmcl.util.platform.windows.WinReg;
import org.jackhuang.hmcl.util.platform.windows.WinTypes;
import org.jetbrains.annotations.Nullable;

final class WindowsCPUDetector {
    private static void detectName(CentralProcessor.Builder builder, WinReg reg) {
        Object name = reg.queryValue(WinReg.HKEY.HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "ProcessorNameString");
        Object vendor = reg.queryValue(WinReg.HKEY.HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0", "VendorIdentifier");
        if (name instanceof String) {
            builder.setName(CentralProcessor.cleanName((String)name));
        }
        if (vendor instanceof String) {
            builder.setVendor(HardwareVendor.of((String)vendor));
        }
    }

    private static void detectCores(CentralProcessor.Builder builder, Kernel32 kernel32) {
        int coresLogical = 0;
        int coresPhysical = 0;
        int packages = 0;
        IntByReference length = new IntByReference();
        if (!kernel32.GetLogicalProcessorInformationEx(65535, null, length) && length.getValue() == 0) {
            throw new AssertionError((Object)("Failed to get logical processor information length: " + kernel32.GetLastError()));
        }
        try (Memory pProcessorInfo = new Memory(Integer.toUnsignedLong(length.getValue()));){
            long size;
            if (!kernel32.GetLogicalProcessorInformationEx(65535, pProcessorInfo, length)) {
                throw new AssertionError((Object)("Failed to get logical processor information length: " + kernel32.GetLastError()));
            }
            for (long offset = 0L; offset < pProcessorInfo.size(); offset += size) {
                int relationship = pProcessorInfo.getInt(offset);
                size = Integer.toUnsignedLong(pProcessorInfo.getInt(offset + 4L));
                if (relationship == 4) {
                    WinTypes.GROUP_RELATIONSHIP groupRelationship = new WinTypes.GROUP_RELATIONSHIP(pProcessorInfo.share(offset + 8L, size - 8L));
                    groupRelationship.read();
                    int activeGroupCount = Short.toUnsignedInt(groupRelationship.activeGroupCount);
                    for (int i = 0; i < activeGroupCount; ++i) {
                        coresLogical += Short.toUnsignedInt(groupRelationship.groupInfo[i].maximumProcessorCount);
                    }
                    continue;
                }
                if (relationship == 0) {
                    ++coresPhysical;
                    continue;
                }
                if (relationship != 3) continue;
                ++packages;
            }
        }
        builder.setCores(new CentralProcessor.Cores(coresPhysical, coresLogical, packages));
    }

    @Nullable
    static CentralProcessor detect() {
        WinReg reg = WinReg.INSTANCE;
        Kernel32 kernel32 = Kernel32.INSTANCE;
        if (reg == null) {
            return null;
        }
        CentralProcessor.Builder builder = new CentralProcessor.Builder();
        WindowsCPUDetector.detectName(builder, reg);
        if (kernel32 != null) {
            WindowsCPUDetector.detectCores(builder, kernel32);
        }
        return builder.build();
    }

    private WindowsCPUDetector() {
    }
}

