/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import kala.compress.archivers.tar.TarArchiveEntry;
import kala.compress.archivers.tar.TarArchiveReader;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;
import org.jetbrains.annotations.NotNull;

public final class TarFileTree
extends ArchiveFileTree<TarArchiveReader, TarArchiveEntry> {
    private final Path tempFile;
    private final Thread shutdownHook;

    public static TarFileTree open(Path file) throws IOException {
        String fileName = file.getFileName().toString();
        if (fileName.endsWith(".tar.gz") || fileName.endsWith(".tgz")) {
            TarArchiveReader tarFile;
            Path tempFile = Files.createTempFile("hmcl-", ".tar", new FileAttribute[0]);
            try (GZIPInputStream input = new GZIPInputStream(Files.newInputStream(file, new OpenOption[0]));
                 OutputStream output = Files.newOutputStream(tempFile, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
                input.transferTo(output);
                tarFile = new TarArchiveReader(tempFile);
            }
            catch (Throwable e) {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            return new TarFileTree(tarFile, tempFile);
        }
        return new TarFileTree(new TarArchiveReader(file), null);
    }

    public TarFileTree(TarArchiveReader file, Path tempFile) throws IOException {
        super(file);
        this.tempFile = tempFile;
        try {
            for (TarArchiveEntry entry : file.getEntries()) {
                this.addEntry(entry);
            }
        }
        catch (Throwable e) {
            try {
                file.close();
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            if (tempFile != null) {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                }
            }
            throw e;
        }
        if (tempFile != null) {
            this.shutdownHook = new Thread(() -> {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            this.shutdownHook = null;
        }
    }

    @Override
    protected void copyAttributes(@NotNull TarArchiveEntry source, @NotNull Path targetFile) throws IOException {
        BasicFileAttributeView fileAttributeView = Files.getFileAttributeView(targetFile, BasicFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView == null) {
            return;
        }
        fileAttributeView.setTimes(source.getLastModifiedTime(), source.getLastAccessTime(), source.getCreationTime());
    }

    @Override
    public InputStream getInputStream(TarArchiveEntry entry) throws IOException {
        return ((TarArchiveReader)this.reader).getInputStream(entry);
    }

    @Override
    public boolean isLink(TarArchiveEntry entry) {
        return entry.isSymbolicLink();
    }

    @Override
    public String getLink(TarArchiveEntry entry) throws IOException {
        return entry.getLinkName();
    }

    @Override
    public boolean isExecutable(TarArchiveEntry entry) {
        return entry.isFile() && (entry.getMode() & 0x40) != 0;
    }

    @Override
    public void close() throws IOException {
        try {
            ((TarArchiveReader)this.reader).close();
        }
        finally {
            if (this.tempFile != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                Files.deleteIfExists(this.tempFile);
            }
        }
    }
}

