```@meta
CurrentModule = DelaunayTriangulation
```

# Overview 

This section gives a manual for certain parts of the package. Little code will be provided here, instead descriptions will be given for parts of the package; if you do want to see code and, for example, docstrings, you should see the [API](../api/overview.md) section or the [extended manual](../extended/overview.md) section. We will describe the following:

- [Representing Primitives](primitives.md): How geometric primitives are represented in this package, and how you can customise this representation.
- [Representing Boundaries](boundaries.md): How boundaries are represented in this package.
- [Defining Curve-Bounded Domains](curve_bounded.md): How curve-bounded domains can be defined in this package.
- [Ghost (Negative) Vertices](ghost_triangles.md): How ghost triangles and ghost vertices are used in this package to represent boundary information.
- [Geometrical Predicates](predicates.md): How geometric predicates are defined in this package.
- [Triangulation Output](triangulation_output.md): How the output of a triangulation is defined.
- [Voronoi Tessellation Output](voronoi_output.md): How the output of a Voronoi tessellation is defined.
- [Predicate Kernels](predicate_kernels.md): The methods available for computing geometric predicates.
