# Contributing Guide

Thank you for your interest in contributing to Enzyme.jl! There are multiple ways to contribute, and we appreciate all contributions. In case you have questions, you can either use Enzyme.jl's `#enzyme` [Slack Channel](https://julialang.org/slack/), or the [Julia Discourse](https://discourse.julialang.org/).


## Ways to Contribute

### Bug Reports and Feature Requests

If you are working with Enzyme, and run into a bug, or require additional features, we definitely want to know about it. Please let us know by either creating a [GitHub Issues](https://github.com/EnzymeAD/Enzyme.jl/issues), or starting a thread in the [Julia Discourse](https://discourse.julialang.org/) with the `enzyme` tag.

### Bug Fixes

If you are interested in contributing code to Enzyme, issues labeled with the [good-first-issue](https://github.com/EnzymeAD/Enzyme.jl/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+issue%22) keyword in the [GitHub Issues](https://github.com/EnzymeAD/Enzyme.jl/issues) are a good way to get familiar with the code base. If you are interested in fixing a bug please comment on it to let people know you are working on it.

Then try to reproduce and fix the bug with Julia. Start by building Enzyme on Julia's latest release candidate and use the built binaries to reproduce the failure described in the bug. If this does not reproduce the bug, please take a look at Enzyme.jl's [For Developers](https://enzyme.mit.edu/julia/dev_docs/) documentation and build Enzyme manually against Enzyme.jl.

## How to Submit a Pull Request

Once you have a pull request ready, it is time to submit it. The pull request should:

- Include a small unit test
- Not contain any unrelated changes
- Be an isolated change. Independent changes should be submitted as separate pull requests as this makes reviewing easier.

## Code of Conduct

As an Julia Project we expect all participants to abide by the [Julia Community Standards](https://julialang.org/community/standards/).
