/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.api;

import java.io.File;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/rule/engine/api/Code;", "", "content", "", "fileName", "filePath", "Ljava/nio/file/Path;", "script", "", "isStdIn", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;ZZ)V", "getContent", "()Ljava/lang/String;", "getFileName", "getFilePath", "()Ljava/nio/file/Path;", "getScript", "()Z", "fileNameOrStdin", "filePathOrStdin", "Companion", "ktlint-rule-engine"})
public final class Code {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @Nullable
    private final String fileName;
    @Nullable
    private final Path filePath;
    private final boolean script;
    private final boolean isStdIn;

    private Code(String content, String fileName, Path filePath, boolean script, boolean isStdIn) {
        this.content = content;
        this.fileName = fileName;
        this.filePath = filePath;
        this.script = script;
        this.isStdIn = isStdIn;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @Nullable
    public final String getFileName() {
        return this.fileName;
    }

    @Nullable
    public final Path getFilePath() {
        return this.filePath;
    }

    public final boolean getScript() {
        return this.script;
    }

    public final boolean isStdIn() {
        return this.isStdIn;
    }

    @NotNull
    public final String fileNameOrStdin() {
        String string;
        if (this.isStdIn) {
            string = this.fileName;
            if (string == null) {
                string = "<stdin>";
            }
        } else {
            string = this.fileName;
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    @NotNull
    public final String filePathOrStdin() {
        Object object;
        if (this.isStdIn) {
            object = this.filePath;
            if (object == null || (object = object.toString()) == null) {
                object = "<stdin>";
            }
        } else {
            Path path = this.filePath;
            object = path != null ? ((Object)path).toString() : null;
            if (object == null) {
                object = "";
            }
        }
        return object;
    }

    public /* synthetic */ Code(String content, String fileName, Path filePath, boolean script, boolean isStdIn, DefaultConstructorMarker $constructor_marker) {
        this(content, fileName, filePath, script, isStdIn);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\nJ\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lcom/pinterest/ktlint/rule/engine/api/Code$Companion;", "", "<init>", "()V", "fromFile", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "file", "Ljava/io/File;", "fromPath", "path", "Ljava/nio/file/Path;", "fromSnippet", "content", "", "script", "", "fromSnippetWithPath", "virtualPath", "fromStdin", "ktlint-rule-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Code fromFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter(file, "file");
            String string = FilesKt.readText$default(file, null, 1, null);
            String string2 = file.getName();
            Path path = file.toPath();
            String string3 = file.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            return new Code(string, string2, path, StringsKt.endsWith(string3, ".kts", true), false, null);
        }

        @NotNull
        public final Code fromPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            FileSystem fileSystem = path.getFileSystem();
            Intrinsics.checkNotNullExpressionValue(fileSystem, "getFileSystem(...)");
            org.jetbrains.kotlin.konan.file.File file = ZipUtilKt.file(fileSystem, ((Object)path).toString());
            return new Code(CollectionsKt.joinToString$default(file.readStrings(), "\n", null, null, 0, null, null, 62, null), file.getName(), path, StringsKt.endsWith(file.getName(), ".kts", true), false, null);
        }

        @NotNull
        public final Code fromSnippet(@NotNull String content, boolean script) {
            Intrinsics.checkNotNullParameter(content, "content");
            return new Code(content, null, null, script, true, null);
        }

        public static /* synthetic */ Code fromSnippet$default(Companion companion, String string, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            return companion.fromSnippet(string, bl);
        }

        @NotNull
        public final Code fromSnippetWithPath(@NotNull String content, @Nullable Path virtualPath) {
            Intrinsics.checkNotNullParameter(content, "content");
            Path path = virtualPath;
            String string = path != null ? ((Object)path).toString() : null;
            if (string == null) {
                string = "";
            }
            boolean bl = StringsKt.endsWith(string, ".kts", true);
            return new Code(content, null, virtualPath, bl, true, null);
        }

        public static /* synthetic */ Code fromSnippetWithPath$default(Companion companion, String string, Path path, int n2, Object object) {
            if ((n2 & 2) != 0) {
                path = null;
            }
            return companion.fromSnippetWithPath(string, path);
        }

        @NotNull
        public final Code fromStdin() {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "in");
            byte[] byArray = ByteStreamsKt.readBytes(inputStream);
            return com.pinterest.ktlint.rule.engine.api.Code$Companion.fromSnippetWithPath$default(this, new String(byArray, Charsets.UTF_8), null, 2, null);
        }

        @NotNull
        public final Code fromStdin(@NotNull Path virtualPath) {
            Intrinsics.checkNotNullParameter(virtualPath, "virtualPath");
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "in");
            byte[] byArray = ByteStreamsKt.readBytes(inputStream);
            return this.fromSnippetWithPath(new String(byArray, Charsets.UTF_8), virtualPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

