/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ec4j.core.model.Adaptable;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.EditorConfig;
import org.ec4j.core.model.Glob;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.ec4j.core.model.Version;

public class Section
extends Adaptable.DefaultAdaptable {
    private final Glob glob;
    private final Map<String, Property> properties;

    public static Builder builder() {
        return new Builder(null);
    }

    Section(List<Object> adapters, Glob glob, Map<String, Property> properties2) {
        super(adapters);
        this.glob = glob;
        this.properties = properties2;
    }

    public void appendTo(StringBuilder s2) {
        if (!this.glob.isEmpty()) {
            s2.append('[');
            s2.append(this.glob.toString());
            s2.append("]\n");
        }
        int i2 = 0;
        for (Property property2 : this.properties.values()) {
            if (i2 > 0) {
                s2.append("\n");
            }
            s2.append(property2.toString());
            ++i2;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Section other = (Section)obj;
        if (this.glob == null ? other.glob != null : !this.glob.equals(other.glob)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public Glob getGlob() {
        return this.glob;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.glob == null ? 0 : this.glob.hashCode());
        result2 = 31 * result2 + (this.properties == null ? 0 : this.properties.hashCode());
        return result2;
    }

    public boolean match(Ec4jPath filePath) {
        return this.glob == null ? true : this.glob.match(filePath);
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        this.appendTo(s2);
        return s2.toString();
    }

    public static class Builder
    extends Adaptable.DefaultAdaptable.Builder<Builder> {
        private Glob glob;
        private boolean parentAware = false;
        final EditorConfig.Builder parentBuilder;
        private Map<String, Property.Builder> properties = new LinkedHashMap<String, Property.Builder>();

        public Builder(EditorConfig.Builder parentBuilder) {
            this.parentBuilder = parentBuilder;
        }

        public Builder applyDefaults() {
            String value2;
            PropertyType<Integer> type2;
            Version version2 = this.parentBuilder.version;
            Property.Builder indentStyle = this.properties.get(PropertyType.indent_style.getName());
            Property.Builder indentSize = this.properties.get(PropertyType.indent_size.getName());
            Property.Builder tabWidth = this.properties.get(PropertyType.tab_width.getName());
            if (indentStyle != null && PropertyType.IndentStyleValue.tab.name().equals(indentStyle.value.getSource()) && indentSize == null && version2.compareTo(Version._0_10_0) >= 0) {
                type2 = PropertyType.indent_size;
                value2 = "tab";
                indentSize = this.openProperty().type(type2).value(type2.parse("tab"));
                this.property(indentSize);
            }
            if (indentSize != null && !"tab".equals(indentSize.value.getSource()) && tabWidth == null) {
                type2 = PropertyType.tab_width;
                value2 = indentSize.value.getSource();
                tabWidth = this.openProperty().type(type2).value(type2.parse(value2));
                this.property(tabWidth);
            }
            if (indentSize != null && "tab".equals(indentSize.value.getSource()) && tabWidth != null) {
                type2 = PropertyType.indent_size;
                value2 = tabWidth.value.getSource();
                indentSize = this.openProperty().type(type2).value(type2.parse(value2));
                this.property(indentSize);
            }
            return this;
        }

        public Section build() {
            LinkedHashMap<String, Property> useProps = new LinkedHashMap<String, Property>(this.properties.size());
            ArrayList<List> propAdapters = new ArrayList<List>();
            for (Property.Builder propBuilder : this.properties.values()) {
                if (this.parentAware) {
                    propAdapters.add(propBuilder.adapters);
                }
                Property prop = propBuilder.build();
                useProps.put(prop.getName(), prop);
            }
            this.properties = null;
            Section result2 = new Section(this.sealAdapters(), this.glob, Collections.unmodifiableMap(useProps));
            for (List adapters : propAdapters) {
                adapters.add(result2);
            }
            return result2;
        }

        public EditorConfig.Builder closeSection() {
            if (this.glob == null) {
                Property.Builder rootProp = this.properties.remove(PropertyType.root.getName());
                if (rootProp != null) {
                    this.parentBuilder.root(rootProp.value.getSource().equalsIgnoreCase(Boolean.TRUE.toString()));
                }
            } else {
                this.parentBuilder.section(this);
            }
            return this.parentBuilder;
        }

        public Builder glob(Glob glob) {
            this.glob = glob;
            return this;
        }

        public Property.Builder openProperty() {
            return new Property.Builder(this);
        }

        public Builder parentAware(boolean parentAware) {
            this.parentAware = parentAware;
            return this;
        }

        public Builder properties(Collection<Property.Builder> properties2) {
            for (Property.Builder property2 : properties2) {
                this.properties.put(property2.name, property2);
            }
            return this;
        }

        public Builder properties(Property.Builder ... properties2) {
            for (Property.Builder property2 : properties2) {
                this.properties.put(property2.name, property2);
            }
            return this;
        }

        public Builder property(Property.Builder property2) {
            this.properties.put(property2.name, property2);
            return this;
        }
    }
}

