/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.InlineFunctionUseSiteChecker;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\f\u0010 \u001a\u00020\u0019*\u00020!H\u0002\u001a \u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a&\u0010%\u001a\u00020\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001c\u0010+\u001a\u00020\u0007*\u00020,2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001c\u0010.\u001a\u00020\u0007*\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001c\u00101\u001a\u00020\u0007*\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010\r\u001a\u00020\u000eH\u0000\"!\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "getEXCLUDED_PACKAGES_FROM_VARARG_VALIDATION", "()Ljava/util/HashSet;", "validateVararg", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "varargElementType", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "EXCLUDED_MODULE_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "getEXCLUDED_MODULE_NAMES", "()Ljava/util/Set;", "visibilityError", "element", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "isVisibleAsInternal", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "isVisibleAsPrivate", "FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS", "EXCLUDED_PACKAGES_FROM_ANNOTATIONS_VISIBILITY_CHECKS", "isExcludedFromVisibilityChecks", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "checkVisibility", "referencedDeclarationSymbol", "reference", "checkFunctionUseSite", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "inlineFunctionUseSiteChecker", "Lorg/jetbrains/kotlin/backend/common/InlineFunctionUseSiteChecker;", "ensureTypeIs", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expectedType", "checkFunctionProperties", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "checkFunctionDispatchReceiver", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nCheckerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/backend/common/checkers/CheckerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,218:1\n1#2:219\n1761#3,3:220\n1634#3,3:223\n1634#3,3:229\n1634#3,3:232\n11896#4,3:226\n*S KotlinDebug\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/backend/common/checkers/CheckerUtilsKt\n*L\n115#1:220,3\n36#1:223,3\n108#1:229,3\n112#1:232,3\n70#1:226,3\n*E\n"})
public final class CheckerUtilsKt {
    @NotNull
    private static final HashSet<FqName> EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION;
    @NotNull
    private static final Set<Name> EXCLUDED_MODULE_NAMES;
    @NotNull
    private static final Set<FqName> FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS;
    @NotNull
    private static final HashSet<FqName> EXCLUDED_PACKAGES_FROM_ANNOTATIONS_VISIBILITY_CHECKS;

    @NotNull
    public static final HashSet<FqName> getEXCLUDED_PACKAGES_FROM_VARARG_VALIDATION() {
        return EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void validateVararg(@NotNull IrElement irElement, @NotNull IrType type2, @NotNull IrType varargElementType, @NotNull CheckerContext context2) {
        Boolean isCorrectArrayOfPrimitiveOrUnsigned;
        Boolean bl;
        IrType primitiveOrUnsignedElementType;
        IrType irType;
        boolean isCorrectArrayOf;
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(varargElementType, "varargElementType");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.getWithinAnnotationUsageSubTree() && EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION.contains(context2.getFile().getPackageFqName())) {
            return;
        }
        if (IrTypePredicatesKt.isArray(type2) || IrTypePredicatesKt.isNullableArray(type2)) {
            boolean bl2;
            IrTypeArgument it = CollectionsKt.single(((IrSimpleType)type2).getArguments());
            boolean bl3 = false;
            IrTypeArgument irTypeArgument = it;
            if (irTypeArgument instanceof IrSimpleType) {
                bl2 = Intrinsics.areEqual(it, varargElementType);
            } else if (irTypeArgument instanceof IrTypeProjection) {
                if (((IrTypeProjection)it).getVariance() == Variance.OUT_VARIANCE && Intrinsics.areEqual(((IrTypeProjection)it).getType(), varargElementType)) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
        }
        boolean bl4 = isCorrectArrayOf = false;
        if (isCorrectArrayOf) {
            return;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(type2);
        if (irClassifierSymbol != null) {
            IrClassifierSymbol classifier2 = irClassifierSymbol;
            boolean bl5 = false;
            irType = context2.getIrBuiltIns().getPrimitiveArrayElementTypes().get(classifier2);
            if (irType == null) {
                irType = context2.getIrBuiltIns().getUnsignedArraysElementTypes().get(classifier2);
            }
        } else {
            irType = null;
        }
        IrType irType2 = primitiveOrUnsignedElementType = irType;
        if (irType2 != null) {
            IrType it = irType2;
            boolean bl6 = false;
            bl = Intrinsics.areEqual(it, varargElementType);
        } else {
            bl = isCorrectArrayOfPrimitiveOrUnsigned = null;
        }
        if (Intrinsics.areEqual(isCorrectArrayOfPrimitiveOrUnsigned, true)) {
            return;
        }
        context2.error(irElement, "Vararg type=" + RenderIrElementKt.render$default(type2, null, 1, null) + " is expected to be an array of its underlying varargElementType=" + RenderIrElementKt.render$default(varargElementType, null, 1, null));
    }

    @NotNull
    public static final Set<Name> getEXCLUDED_MODULE_NAMES() {
        return EXCLUDED_MODULE_NAMES;
    }

    private static final void visibilityError(IrElement element, Visibility visibility, CheckerContext context2) {
        String message2 = "The following element references " + (Intrinsics.areEqual(visibility, Visibilities.Unknown.INSTANCE) ? "a declaration with unknown visibility:" : '\'' + visibility.getName() + "' declaration that is invisible in the current scope:");
        context2.error(element, message2);
    }

    private static final boolean isVisibleAsInternal(IrDeclarationWithVisibility $this$isVisibleAsInternal, IrFile file) {
        IrPackageFragment referencedDeclarationPackageFragment = IrUtilsKt.getPackageFragment($this$isVisibleAsInternal);
        IrModuleFragment module2 = file.getModule();
        if (referencedDeclarationPackageFragment.getSymbol() instanceof DescriptorlessExternalPackageFragmentSymbol) {
            return Intrinsics.areEqual(module2.getName().asString(), "<kotlin>");
        }
        return module2.getDescriptor().shouldSeeInternalsOf(IrPackageFragmentsKt.getModuleDescriptor(referencedDeclarationPackageFragment));
    }

    private static final boolean isVisibleAsPrivate(IrDeclarationWithVisibility $this$isVisibleAsPrivate, IrFile file) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$isVisibleAsPrivate);
        return Intrinsics.areEqual(file.getFileEntry(), irFile != null ? irFile.getFileEntry() : null);
    }

    private static final boolean isExcludedFromVisibilityChecks(IrSymbol $this$isExcludedFromVisibilityChecks) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqName excludedFqName = (FqName)element$iv;
                    boolean bl2 = false;
                    if (!AdditionalIrUtilsKt.hasEqualFqName($this$isExcludedFromVisibilityChecks, excludedFqName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final void checkVisibility(@NotNull IrSymbol referencedDeclarationSymbol, @NotNull IrElement reference2, @NotNull CheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(referencedDeclarationSymbol, "referencedDeclarationSymbol");
        Intrinsics.checkNotNullParameter(reference2, "reference");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrOverridableDeclaration irOverridableDeclaration = reference2 instanceof IrOverridableDeclaration ? (IrOverridableDeclaration)reference2 : null;
        boolean bl2 = irOverridableDeclaration != null ? irOverridableDeclaration.isFakeOverride() : false;
        if (bl2 && CollectionsKt.contains(((IrOverridableDeclaration)reference2).getOverriddenSymbols(), referencedDeclarationSymbol)) {
            return;
        }
        if (reference2 instanceof IrClass && CollectionsKt.contains((Iterable)((IrClass)reference2).getSealedSubclasses(), referencedDeclarationSymbol)) {
            return;
        }
        if (CheckerUtilsKt.isExcludedFromVisibilityChecks(referencedDeclarationSymbol)) {
            return;
        }
        if (context2.getWithinAnnotationUsageSubTree()) {
            IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment(referencedDeclarationSymbol.getOwner());
            if (CollectionsKt.contains((Iterable)EXCLUDED_PACKAGES_FROM_ANNOTATIONS_VISIBILITY_CHECKS, irPackageFragment != null ? irPackageFragment.getPackageFqName() : null)) {
                return;
            }
        }
        if (EXCLUDED_MODULE_NAMES.contains(context2.getFile().getModule().getName())) {
            return;
        }
        IrSymbolOwner irSymbolOwner = referencedDeclarationSymbol.getOwner();
        IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
        if (irDeclarationWithVisibility == null) {
            return;
        }
        IrDeclarationWithVisibility referencedDeclaration = irDeclarationWithVisibility;
        IrClass classOfReferenced = IrUtilsKt.getParentClassOrNull(referencedDeclaration);
        Visibility visibility = referencedDeclaration.getVisibility().getDelegate();
        IrClass irClass = classOfReferenced;
        EffectiveVisibility effectiveVisibility = EffectiveVisibilityKt.toEffectiveVisibilityOrNull(visibility, irClass != null ? irClass.getSymbol() : null, true, IrUtilsKt.isPublishedApi(referencedDeclaration));
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility;
        if (effectiveVisibility2 instanceof EffectiveVisibility.Internal || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtected || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtectedBound) {
            bl = CheckerUtilsKt.isVisibleAsInternal(referencedDeclaration, context2.getFile());
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Local || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInClass || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInFile) {
            bl = CheckerUtilsKt.isVisibleAsPrivate(referencedDeclaration, context2.getFile());
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.PackagePrivate || effectiveVisibility2 instanceof EffectiveVisibility.Protected || effectiveVisibility2 instanceof EffectiveVisibility.ProtectedBound || effectiveVisibility2 instanceof EffectiveVisibility.Public) {
            bl = true;
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Unknown || effectiveVisibility2 == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVisible = bl;
        if (!isVisible) {
            CheckerUtilsKt.visibilityError(reference2, visibility, context2);
        }
    }

    public static final void checkFunctionUseSite(@NotNull IrMemberAccessExpression<IrFunctionSymbol> expression2, @NotNull InlineFunctionUseSiteChecker inlineFunctionUseSiteChecker, @NotNull CheckerContext context2) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(inlineFunctionUseSiteChecker, "inlineFunctionUseSiteChecker");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (!function2.isInline() || inlineFunctionUseSiteChecker.isPermitted(expression2)) {
            return;
        }
        StringBuilder $this$checkFunctionUseSite_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$checkFunctionUseSite_u24lambda_u240.append("The following element references ").append(function2.getVisibility()).append(" inline ");
        IrFunction irFunction = function2;
        if (irFunction instanceof IrSimpleFunction) {
            string = AdditionalIrUtilsKt.isAccessor(function2) ? "property accessor" : "function";
        } else if (irFunction instanceof IrConstructor) {
            string = "constructor";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$checkFunctionUseSite_u24lambda_u240.append(string);
        $this$checkFunctionUseSite_u24lambda_u240.append(" ").append(function2.getName().asString());
        String message2 = stringBuilder.toString();
        context2.error(expression2, message2);
    }

    public static final void ensureTypeIs(@NotNull IrExpression $this$ensureTypeIs, @NotNull IrType expectedType, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$ensureTypeIs, "<this>");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!Intrinsics.areEqual($this$ensureTypeIs.getType(), expectedType)) {
            context2.error($this$ensureTypeIs, "unexpected type: expected " + RenderIrElementKt.render$default(expectedType, null, 1, null) + ", got " + RenderIrElementKt.render$default($this$ensureTypeIs.getType(), null, 1, null));
        }
    }

    public static final void checkFunctionProperties(@NotNull IrElement $this$checkFunctionProperties, @NotNull IrFunction function2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$checkFunctionProperties, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (function2 instanceof IrSimpleFunction) {
            IrProperty property2;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)function2).getCorrespondingPropertySymbol();
            IrProperty irProperty = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property2 != null && !Intrinsics.areEqual(property2.getGetter(), function2) && !Intrinsics.areEqual(property2.getSetter(), function2)) {
                context2.error($this$checkFunctionProperties, "Orphaned property getter/setter " + RenderIrElementKt.render$default(function2, null, 1, null));
            }
        }
    }

    public static final void checkFunctionDispatchReceiver(@NotNull IrElement $this$checkFunctionDispatchReceiver, @NotNull IrFunction function2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$checkFunctionDispatchReceiver, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if ((irValueParameter != null ? irValueParameter.getType() : null) instanceof IrDynamicType) {
            context2.error($this$checkFunctionDispatchReceiver, "Dispatch receivers with 'dynamic' type are not allowed");
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        String item$iv;
        String p0;
        Collection collection;
        Object $this$mapTo$iv;
        Object object = new String[]{"kotlinx.serialization.modules", "kotlinx.serialization.json", "kotlinx.serialization.json.internal"};
        object = CollectionsKt.listOf(object);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv2 = iterator2.next();
            String string = (String)item$iv2;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new FqName(p0));
        }
        EXCLUDED_PACKAGES_FROM_VARARG_VALIDATION = (HashSet)destination$iv;
        $this$mapTo$iv = new String[]{"stdlib", "kotlin", "kotlin", "kotlin-test"};
        destination$iv = new LinkedHashSet();
        $i$f$mapTo = false;
        int item$iv2 = ((String[])$this$mapTo$iv).length;
        for (int i2 = 0; i2 < item$iv2; ++i2) {
            void it;
            String bl = item$iv = $this$mapTo$iv[i2];
            collection = destination$iv;
            boolean bl2 = false;
            collection.add(Name.special('<' + (String)it + '>'));
        }
        EXCLUDED_MODULE_NAMES = (Set)destination$iv;
        $this$mapTo$iv = new String[]{"kotlin.wasm.internal.wasmTypeId", "kotlin.coroutines.CoroutineImpl"};
        $this$mapTo$iv = CollectionsKt.listOf($this$mapTo$iv);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        Iterator iterator3 = $this$mapTo$iv.iterator();
        while (iterator3.hasNext()) {
            Object item$iv3 = iterator3.next();
            item$iv = (String)item$iv3;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new FqName(p0));
        }
        FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS = (Set)destination$iv;
        $this$mapTo$iv = new String[]{"kotlin.jvm", "kotlin.internal", "kotlin.native", "kotlin.native.internal"};
        $this$mapTo$iv = CollectionsKt.listOf($this$mapTo$iv);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        iterator3 = $this$mapTo$iv.iterator();
        while (iterator3.hasNext()) {
            Object item$iv4 = iterator3.next();
            p0 = (String)item$iv4;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new FqName(p0));
        }
        EXCLUDED_PACKAGES_FROM_ANNOTATIONS_VISIBILITY_CHECKS = (HashSet)var1_1;
    }
}

